/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

class FileView
extends JFrame
implements WindowListener,
ActionListener {
    private JMenuItem close;
    private String fileName;
    public JEditorPane editor;
    private URL url;

    FileView(String helpFileName) {
        this.addWindowListener(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.editor = new JEditorPane();
        this.editor.setEditable(false);
        this.editor.addHyperlinkListener(new EditorPaneHyperlinkListener());
        JScrollPane scroller = new JScrollPane();
        JViewport port = scroller.getViewport();
        port.add(this.editor);
        this.setJMenuBar(this.createMenubar());
        this.getContentPane().add("Center", scroller);
        this.pack();
        this.setSize(700, 650);
        try {
            ClassLoader loader = this.getClass().getClassLoader();
            URL url = loader != null ? loader.getResource(helpFileName) : ClassLoader.getSystemResource(helpFileName);
            EnvVariable envVars = new EnvVariable();
            String sep = System.getProperty("file.separator");
            if (sep.equals("/")) {
                this.editor.setContentType("text/html;charset=Shift-jis");
            } else {
                this.editor.setContentType("text/html;charset=Shift-jis");
            }
            this.editor.setPage(url);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    JMenuBar createMenubar() {
        JMenuBar mb = new JMenuBar();
        JMenu file = new JMenu("File");
        this.close = new JMenuItem("Close");
        file.add(this.close);
        mb.add(file);
        this.close.addActionListener(this);
        return mb;
    }

    public void windowDeiconified(WindowEvent event) {
    }

    public void windowIconified(WindowEvent event) {
    }

    public void windowActivated(WindowEvent event) {
    }

    public void windowDeactivated(WindowEvent event) {
    }

    public void windowOpened(WindowEvent event) {
    }

    public void windowClosed(WindowEvent event) {
    }

    public void windowClosing(WindowEvent event) {
    }

    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.close) {
            this.setVisible(false);
            return;
        }
    }

    class EditorPaneHyperlinkListener
    implements HyperlinkListener {
        EditorPaneHyperlinkListener() {
        }

        public void hyperlinkUpdate(HyperlinkEvent event) {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JEditorPane pane = (JEditorPane)event.getSource();
                try {
                    pane.setPage(event.getURL());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

