/*
 * Decompiled with CFR 0.152.
 */
package GAG;

import GAG.DTreeFrame;
import GAG.EnvVariable;
import GAG.ErrStream;
import GAG.ExampleFileFilter;
import GAG.GAGConsole;
import GAG.GAGcommandItem;
import GAG.GAGpipe;
import GAG.ParamPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.BevelBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;

public class GAG
extends JPanel
implements TreeSelectionListener,
ActionListener {
    static final String gagVer = "J1.0a";
    private String g4Ver;
    private String command;
    private GAGpipe geant4;
    private ErrStream errStream;
    private Hashtable paramsHash;
    private Vector disableCommands;
    private ParamPanel paramPanel;
    private JPanel geantPanel;
    private JPanel mainPanel = new JPanel();
    private JPanel northPanel;
    private JSplitPane splitPane;
    private JSplitPane spane;
    private JFileChooser geant4Chooser;
    private JFileChooser historyChooser;
    private JFileChooser logChooser;
    private JMenuItem execG4;
    private JMenuItem contG4;
    private JMenuItem exitG4;
    private JMenuItem killG4;
    private JMenuItem exitGAG;
    private JMenuItem clearOneHist;
    private JMenuItem clearAllHist;
    private JMenuItem saveHist;
    private JMenuItem htmlHelp;
    private JMenuItem about;
    private JCheckBox logTerm;
    private JCheckBox logFile;
    private JCheckBox startJAS;
    private JTextField directField;
    private JLabel promptLabel;
    private String fileName;
    private String g4Binary;
    public String workdirpath = ".";
    private CardLayout cardLayout = new CardLayout();
    private boolean executingG4;
    private boolean executingACommand;
    private boolean endGAG;
    private boolean logtofile;
    private boolean logtoterm;
    private boolean JASisrunning;
    private JPanel p1;
    private PrintWriter outLog;
    private ExampleFileFilter exeFilter;
    private ExampleFileFilter outFilter;
    private ExampleFileFilter g4hFilter;
    private ExampleFileFilter logFilter;
    private ExampleFileFilter g4histFilter;
    private ExampleFileFilter txtFilter;
    private ExampleFileFilter histFilter;
    DTreeFrame dTreePanel;
    private GAGConsole console;

    public GAG() {
        this.mainPanel.setLayout(this.cardLayout);
        this.northPanel = new JPanel();
        this.northPanel.setLayout(new BorderLayout());
        this.geantPanel = new JPanel(new BorderLayout());
        JMenu geantMenu = new JMenu("Geant4");
        this.console = new GAGConsole();
        geantMenu.setFont(new Font("Serif", 1, 14));
        this.execG4 = new JMenuItem("Start_Geant4");
        this.contG4 = new JMenuItem("Continue");
        this.exitG4 = new JMenuItem("Exit_Geant4");
        this.killG4 = new JMenuItem("Kill_Geant4");
        this.exitGAG = new JMenuItem("Exit_GAG");
        this.execG4.setBackground(Color.green);
        this.contG4.setBackground(Color.green);
        this.exitG4.setBackground(Color.green);
        this.killG4.setBackground(Color.green);
        this.exitGAG.setBackground(Color.green);
        this.execG4.setFont(new Font("Serif", 1, 12));
        this.contG4.setFont(new Font("Serif", 1, 12));
        this.exitG4.setFont(new Font("Serif", 1, 12));
        this.killG4.setFont(new Font("Serif", 1, 12));
        this.exitGAG.setFont(new Font("Serif", 1, 12));
        geantMenu.add(this.execG4);
        geantMenu.add(this.contG4);
        geantMenu.add(this.exitG4);
        geantMenu.add(this.killG4);
        this.logFile = new JCheckBox("Log_to_File", false);
        this.logTerm = new JCheckBox("to_Terminal", true);
        this.startJAS = new JCheckBox("JAS", false);
        this.logFile.setFont(new Font("Serif", 1, 12));
        this.logTerm.setFont(new Font("Serif", 1, 12));
        this.startJAS.setFont(new Font("Helvetica", 1, 12));
        this.JASisrunning = false;
        this.logtofile = false;
        this.logtoterm = false;
        JMenu histMenu = new JMenu("History");
        histMenu.setFont(new Font("Serif", 1, 14));
        this.clearOneHist = new JMenuItem("Clear One");
        this.clearAllHist = new JMenuItem("Clear All");
        this.saveHist = new JMenuItem("Save History");
        this.clearOneHist.setBackground(Color.yellow);
        this.clearAllHist.setBackground(Color.yellow);
        this.saveHist.setBackground(Color.yellow);
        this.clearOneHist.setFont(new Font("Serif", 1, 12));
        this.clearAllHist.setFont(new Font("Serif", 1, 12));
        this.saveHist.setFont(new Font("Serif", 1, 12));
        histMenu.add(this.clearOneHist);
        histMenu.add(this.clearAllHist);
        histMenu.add(this.saveHist);
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setFont(new Font("Serif", 1, 14));
        this.htmlHelp = new JMenuItem("Help");
        helpMenu.add(this.htmlHelp);
        this.about = new JMenuItem("About");
        helpMenu.add(this.about);
        this.execG4.addActionListener(this);
        this.contG4.addActionListener(this);
        this.exitG4.addActionListener(this);
        this.killG4.addActionListener(this);
        this.exitGAG.addActionListener(this);
        this.clearOneHist.addActionListener(this);
        this.clearAllHist.addActionListener(this);
        this.saveHist.addActionListener(this);
        this.htmlHelp.addActionListener(this);
        this.about.addActionListener(this);
        this.logFile.addActionListener(this);
        this.logTerm.addActionListener(this);
        JMenuBar mb = new JMenuBar();
        mb.setBorder(new BevelBorder(0));
        mb.add(geantMenu);
        mb.add(histMenu);
        mb.add(helpMenu);
        for (int i = 0; i < mb.getMenuCount(); ++i) {
            JMenu menu = mb.getMenu(i);
            String text = menu.getText();
            menu.setMnemonic(text.charAt(0));
        }
        mb.add(this.logFile);
        mb.add(this.logTerm);
        this.directField = new JTextField();
        this.directField.setFont(new Font("Serif", 1, 12));
        this.directField.addActionListener(this);
        this.p1 = new JPanel(new BorderLayout());
        this.promptLabel = new JLabel("****** PROMPT ******", 0);
        this.promptLabel.setForeground(Color.black);
        this.promptLabel.setFont(new Font("Serif", 1, 12));
        this.p1.add("Center", this.directField);
        this.p1.add("West", this.promptLabel);
        this.geantPanel.add("South", this.p1);
        JLabel idleLabel = new JLabel("Welcome to Geant4 Adaptive GUI", 0);
        idleLabel.setFont(new Font("Serif", 1, 18));
        this.mainPanel.add("idle", idleLabel);
        JLabel treeLabel = new JLabel("Making command tree");
        treeLabel.setFont(new Font("Serif", 1, 18));
        this.mainPanel.add("tree", treeLabel);
        this.mainPanel.add("geant", this.geantPanel);
        this.northPanel.add("North", mb);
        this.northPanel.add("Center", this.mainPanel);
        this.setLayout(new BorderLayout());
        this.spane = new JSplitPane(0, true, this.northPanel, this.console);
        this.spane.setDividerLocation(400);
        this.spane.setContinuousLayout(true);
        this.spane.setOneTouchExpandable(true);
        this.console.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                int x = e.getComponent().getX();
                int y = e.getComponent().getY();
                int width = e.getComponent().getWidth();
                int height = e.getComponent().getHeight();
                int mainX = GAG.this.mainPanel.getX();
                int mainY = GAG.this.mainPanel.getY();
                int mainWidth = GAG.this.mainPanel.getWidth();
                int mainHeight = GAG.this.mainPanel.getHeight();
                int spaneX = GAG.this.spane.getX();
                int spaneY = GAG.this.spane.getY();
                int spaneWidth = GAG.this.spane.getWidth();
                int spaneHeight = GAG.this.spane.getHeight();
            }
        });
        this.add((Component)this.spane, "Center");
        this.cardLayout.show(this.mainPanel, "idle");
        this.setSize(800, 600);
        this.setVisible(true);
        EnvVariable ev = new EnvVariable();
        String G4BINARY = ev.get("G4WORKDIR") + "";
        if (G4BINARY.equals("null")) {
            G4BINARY = this.workdirpath;
        }
        this.geant4Chooser = new JFileChooser(G4BINARY);
        this.geant4Chooser.setDialogTitle("GEANT4 Executable File");
        this.historyChooser = new JFileChooser();
        this.historyChooser.setDialogTitle("Save Command History");
        this.g4hFilter = new ExampleFileFilter("g4h", "Geant4 History");
        this.txtFilter = new ExampleFileFilter("txt", "Geant4 History");
        this.histFilter = new ExampleFileFilter("his", "Geant4 History");
        this.historyChooser.addChoosableFileFilter(this.g4hFilter);
        this.historyChooser.addChoosableFileFilter(this.txtFilter);
        this.historyChooser.addChoosableFileFilter(this.histFilter);
        this.logChooser = new JFileChooser();
        this.logChooser.setDialogTitle("Specify a Log File");
        this.logFilter = new ExampleFileFilter("log", "Geant4 Log");
        this.logChooser.addChoosableFileFilter(this.logFilter);
        this.executingG4 = false;
        this.executingG4Menu();
        this.endGAG = true;
    }

    private void executingG4Menu() {
        if (this.executingG4) {
            this.execG4.setEnabled(true);
            this.contG4.setEnabled(true);
            this.exitG4.setEnabled(true);
            this.killG4.setEnabled(true);
            this.exitGAG.setEnabled(false);
        } else {
            this.execG4.setEnabled(true);
            this.contG4.setEnabled(false);
            this.exitG4.setEnabled(false);
            this.killG4.setEnabled(false);
            this.exitGAG.setEnabled(true);
        }
        this.repaint();
    }

    public void mainLoop() {
        this.endGAG = false;
        String[] fn = new String[1];
        while (true) {
            this.waiting();
            fn[0] = this.fileName;
            this.geantStart(fn);
        }
    }

    private synchronized void waiting() {
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private synchronized void resume() {
        this.notifyAll();
    }

    private void geantStart(String[] args) {
        String line;
        String prompt = "G4";
        this.geant4 = new GAGpipe(args);
        boolean paramChanged = false;
        this.executingG4 = false;
        if (this.geant4.isError()) {
            JOptionPane.showMessageDialog(this, this.geant4.getErrorMsg(), "Warning", 2);
            this.geant4 = null;
            this.executingG4 = false;
            this.executingG4Menu();
            return;
        }
        this.geant4.start();
        this.executingG4 = true;
        this.executingG4Menu();
        this.Log("Start execution of " + args[0]);
        this.errStream = new ErrStream(this.geant4);
        this.errStream.start();
        this.geant4.writeLine("@@GAGmodeJAVA");
        while ((line = this.geant4.readStdLine()) != null) {
            if (line.startsWith("@@")) {
                if (line.equals("@@JTreeBegin")) {
                    if (!this.makeCommandTree()) continue;
                    break;
                }
                if (line.equals("@@DTREEBegin")) {
                    if (!this.makeDTREE()) continue;
                    break;
                }
                if (line.equals("@@JParamBegin")) {
                    if (this.receiveParams()) break;
                    paramChanged = true;
                    continue;
                }
                if (line.equals("@@JDirGuideBegin")) {
                    if (!this.receiveCascade()) continue;
                    break;
                }
                if (line.equals("@@DisableListBegin")) {
                    if (this.receiveDisables()) break;
                    paramChanged = true;
                    continue;
                }
                if (line.equals("@@Ready")) {
                    if (this.paramPanel != null) {
                        this.paramPanel.toReady();
                        if (paramChanged && !this.command.equals("")) {
                            this.setParamPanel(this.command);
                        }
                    }
                    paramChanged = false;
                    this.Log(this.g4Binary + " : " + prompt + ">");
                    this.repaint();
                    continue;
                }
                if (line.startsWith("@@PROMPT")) {
                    prompt = line.substring(line.indexOf("\"") + 1, line.lastIndexOf("\""));
                    this.promptLabel.setText(this.g4Binary + " in " + prompt);
                    continue;
                }
                if (line.startsWith("@@State")) continue;
                if (line.startsWith("@@Ask")) {
                    String answer = JOptionPane.showInputDialog(this, (Object)line);
                    this.geant4.writeLine(answer);
                    continue;
                }
                if (line.startsWith("@@CurrentValue")) {
                    this.paramPanel.loadCurrentValues(line);
                    this.Log(line.substring(line.indexOf(" ") + 1));
                    continue;
                }
                if (line.startsWith("@@Version")) {
                    StringTokenizer st = new StringTokenizer(line);
                    st.nextToken();
                    this.g4Ver = st.nextToken();
                    continue;
                }
                if (line.startsWith("@@ErrResult")) {
                    JOptionPane.showMessageDialog(this, line.substring(line.indexOf("\"") + 1, line.lastIndexOf("\"")), "Warning", 2);
                    continue;
                }
            }
            this.Log(line);
        }
        this.geantTerminate();
    }

    private void geantTerminate() {
        if (this.geant4 != null) {
            this.geant4.processKill();
            this.geant4 = null;
        }
        this.paramsHash = null;
        if (this.errStream != null) {
            this.errStream = null;
        }
        this.cardLayout.show(this.mainPanel, "idle");
        this.paramPanel = null;
        this.executingG4 = false;
        this.executingG4Menu();
    }

    private boolean makeCommandTree() {
        String pLine;
        int lastIndex;
        this.command = "";
        this.cardLayout.show(this.mainPanel, "tree");
        if (this.splitPane != null) {
            this.geantPanel.remove(this.splitPane);
        }
        DefaultMutableTreeNode topTree = new DefaultMutableTreeNode((lastIndex = this.fileName.lastIndexOf("/")) < 0 ? this.fileName : this.fileName.substring(lastIndex + 1));
        while (!(pLine = this.geant4.readStdLine()).equals("@@JTreeEnd")) {
            if (pLine == null) {
                return true;
            }
            DefaultMutableTreeNode nowTree = topTree;
            DefaultMutableTreeNode childTree = null;
            boolean found = true;
            StringTokenizer stCo = new StringTokenizer(pLine, "/");
            while (stCo.hasMoreTokens()) {
                String label = stCo.nextToken();
                if (found) {
                    found = false;
                    for (int i = 0; i < nowTree.getChildCount(); ++i) {
                        childTree = (DefaultMutableTreeNode)nowTree.getChildAt(i);
                        if (!label.equals((String)childTree.getUserObject())) continue;
                        found = true;
                        break;
                    }
                }
                if (!found) {
                    childTree = new DefaultMutableTreeNode(label);
                    nowTree.add(childTree);
                }
                nowTree = childTree;
            }
        }
        JTree tree = new JTree(topTree);
        tree.addTreeSelectionListener(this);
        this.paramPanel = new ParamPanel(this);
        this.splitPane = new JSplitPane(1, new JScrollPane(tree), this.paramPanel);
        this.splitPane.setDividerLocation(350);
        this.repaint();
        this.geantPanel.add("Center", this.splitPane);
        this.cardLayout.show(this.mainPanel, "geant");
        this.paramsHash = new Hashtable();
        this.disableCommands = new Vector();
        return false;
    }

    private boolean makeDTREE() {
        String pLine;
        this.command = "";
        int lastIndex = this.fileName.lastIndexOf("/");
        DefaultMutableTreeNode topDTree = new DefaultMutableTreeNode(lastIndex < 0 ? this.fileName : this.fileName.substring(lastIndex + 1));
        while (!(pLine = this.geant4.readStdLine()).equals("@@DTREEEnd")) {
            if (pLine == null) {
                return true;
            }
            String eLine = pLine.trim();
            DefaultMutableTreeNode nowDTree = topDTree;
            DefaultMutableTreeNode childDTree = null;
            boolean found = true;
            StringTokenizer stCo = new StringTokenizer(eLine, "/");
            while (stCo.hasMoreTokens()) {
                String label = stCo.nextToken();
                if (found) {
                    found = false;
                    for (int i = 0; i < nowDTree.getChildCount(); ++i) {
                        childDTree = (DefaultMutableTreeNode)nowDTree.getChildAt(i);
                        if (!label.equals((String)childDTree.getUserObject())) continue;
                        found = true;
                        break;
                    }
                }
                if (!found) {
                    childDTree = new DefaultMutableTreeNode(label);
                    nowDTree.add(childDTree);
                }
                nowDTree = childDTree;
            }
        }
        JTree dtree = new JTree(topDTree);
        dtree.addTreeSelectionListener(this);
        this.dTreePanel = new DTreeFrame(dtree);
        this.dTreePanel.setSize(320, 420);
        this.dTreePanel.setLocation(120, 120);
        this.dTreePanel.validate();
        this.repaint();
        return false;
    }

    private boolean receiveParams() {
        int paramEnts;
        int guideEnts;
        String name = this.geant4.readStdLine();
        String lines = this.geant4.readStdLine();
        try {
            guideEnts = Integer.parseInt(lines);
        }
        catch (NumberFormatException e) {
            return true;
        }
        String[] guide = new String[guideEnts];
        for (int i = 0; i < guideEnts; ++i) {
            guide[i] = this.geant4.readStdLine();
        }
        String range = this.geant4.readStdLine();
        if (this.geant4.isError()) {
            return true;
        }
        lines = this.geant4.readStdLine();
        try {
            paramEnts = Integer.parseInt(lines);
        }
        catch (NumberFormatException e) {
            return true;
        }
        GAGcommandItem ci = new GAGcommandItem(name, guide, range, paramEnts);
        block5: for (int i = 0; i < ci.getParamEntries(); ++i) {
            int j = 0;
            while (true) {
                if (j >= 7) continue block5;
                lines = this.geant4.readStdLine();
                if (lines == null) {
                    return true;
                }
                ci.params[i][j] = lines;
                ++j;
            }
        }
        if (!this.geant4.readStdLine().equals("@@JParamEnd")) {
            return true;
        }
        this.paramsHash.put(name, ci);
        return false;
    }

    private boolean receiveCascade() {
        String name = this.geant4.readStdLine();
        String guide = this.geant4.readStdLine();
        if (!this.geant4.readStdLine().equals("@@JDirGuideEnd")) {
            return true;
        }
        this.paramsHash.put(name, guide);
        return false;
    }

    private boolean receiveDisables() {
        String line;
        this.disableCommands.removeAllElements();
        while (!(line = this.geant4.readStdLine()).equals("@@DisableListEnd")) {
            if (line == null) {
                return true;
            }
            this.disableCommands.addElement(line);
        }
        return false;
    }

    void reqCurrent(String cmd) {
        this.sendCommand("?" + cmd);
    }

    void sendCommand(String com) {
        this.Log(com);
        this.geant4.writeLine(com);
    }

    boolean setParamPanel(String key) {
        GAGcommandItem ci = (GAGcommandItem)this.paramsHash.get(key);
        if (ci == null) {
            return false;
        }
        this.command = key;
        this.paramPanel.setParamBox(ci, this.isEnableCommand(key));
        return true;
    }

    public void valueChanged(TreeSelectionEvent te) {
        if (!te.isAddedPath()) {
            return;
        }
        StringBuffer com = new StringBuffer();
        Object[] path = te.getPath().getPath();
        if (path.length > 1) {
            for (int i = 1; i < path.length; ++i) {
                com.append("/" + path[i]);
            }
            this.command = com.toString();
        } else {
            this.command = "";
        }
        DefaultMutableTreeNode nowNode = (DefaultMutableTreeNode)path[path.length - 1];
        int childCount = nowNode.getChildCount();
        if (childCount > 0) {
            String dirHelp = path.length > 1 ? (String)this.paramsHash.get(this.command + "/") : new String(path[0].toString());
            JLabel[][] helpLabel = new JLabel[2][childCount];
            for (int i = 0; childCount > i; ++i) {
                DefaultMutableTreeNode tempNode = (DefaultMutableTreeNode)nowNode.getChildAt(i);
                String tempPath = this.command + "/" + tempNode;
                if (tempNode.getChildCount() == 0) {
                    helpLabel[0][i] = new JLabel(tempNode + " ");
                    helpLabel[0][i].setForeground(this.isEnableCommand(tempPath) ? Color.red : Color.lightGray);
                    helpLabel[1][i] = new JLabel(((GAGcommandItem)this.paramsHash.get(tempPath)).getTitle());
                    continue;
                }
                helpLabel[0][i] = new JLabel(tempNode + "/ ");
                helpLabel[0][i].setForeground(this.isEnableCommand(tempPath + "/") ? Color.blue : Color.lightGray);
                helpLabel[1][i] = new JLabel((String)this.paramsHash.get(tempPath + "/"));
            }
            this.paramPanel.setTreeHelp(dirHelp, helpLabel);
        } else {
            GAGcommandItem ci = (GAGcommandItem)this.paramsHash.get(this.command);
            if (ci == null) {
                return;
            }
            this.paramPanel.setParamBox(ci, this.isEnableCommand(this.command));
        }
    }

    void Log(String line) {
        if (this.logtofile) {
            this.outLog.println(line);
        }
        if (this.logTerm.isSelected()) {
            this.console.setLine(line);
        }
    }

    boolean isEnableCommand(String command) {
        return !this.disableCommands.contains(command);
    }

    public void execG4() {
        this.geant4Chooser.setCurrentDirectory(new File(this.workdirpath));
        if (this.geant4Chooser.showOpenDialog(this) != 0) {
            return;
        }
        File f = this.geant4Chooser.getSelectedFile();
        if (f.isFile()) {
            this.fileName = f.getPath();
            this.g4Binary = f.getName();
            this.workdirpath = this.fileName;
            this.resume();
        }
        this.executingG4 = true;
        this.executingG4Menu();
    }

    public void continueG4() {
        this.sendCommand("continue");
        this.executingG4 = true;
        this.executingG4Menu();
    }

    public void exitG4() {
        this.sendCommand("exit");
        if (this.outLog != null) {
            this.outLog.flush();
            this.outLog.close();
            this.outLog = null;
            this.logtofile = false;
        }
        this.executingG4 = false;
        this.executingG4Menu();
    }

    public void killG4() {
        if (this.outLog != null) {
            this.outLog.flush();
            this.outLog.close();
            this.outLog = null;
        }
        this.geantTerminate();
        this.executingG4 = false;
        this.executingG4Menu();
    }

    public void clearAll() {
        this.paramPanel.clearAllHistory();
    }

    public void clearOne() {
        this.paramPanel.clearOneHistory();
    }

    public void saveHist() {
        this.historyChooser.setCurrentDirectory(new File(this.workdirpath));
        if (this.historyChooser.showSaveDialog(this) != 0) {
            return;
        }
        try {
            FileOutputStream fo = new FileOutputStream(this.historyChooser.getSelectedFile());
            PrintWriter outf = new PrintWriter(new DataOutputStream(fo));
            Vector items = this.paramPanel.getHistoryItems();
            for (int i = 0; i < items.size(); ++i) {
                outf.println(items.elementAt(i));
            }
            outf.close();
            Object var2_3 = null;
        }
        catch (IOException e) {
            this.Log(e.getMessage());
        }
    }

    public void actionPerformed(ActionEvent ae) {
        Object o = ae.getSource();
        if (o == this.directField) {
            this.sendCommand(this.directField.getText());
            this.paramPanel.addHistory(this.directField.getText());
            this.directField.setText("");
            return;
        }
        if (o == this.exitGAG) {
            if (this.geant4 != null) {
                if (JOptionPane.showConfirmDialog(this, "Kill GEANT4 automatically.", "Exit GAG", 0) == 1) {
                    return;
                }
                this.geantTerminate();
            }
            if (this.logtofile) {
                this.outLog.close();
                this.outLog = null;
            }
            System.exit(0);
        }
        if (o == this.exitG4) {
            this.sendCommand("exit");
            if (this.outLog != null) {
                this.outLog.flush();
                this.outLog.close();
                this.outLog = null;
                this.logtofile = false;
            }
            this.executingG4 = false;
            this.executingG4Menu();
            return;
        }
        if (o == this.contG4) {
            this.continueG4();
        }
        if (o == this.execG4) {
            this.execG4();
        }
        if (o == this.killG4) {
            this.killG4();
        }
        if (o == this.startJAS) {
            if (this.JASisrunning) {
                return;
            }
            EnvVariable evJ = new EnvVariable();
            String JASpath = evJ.get("JASROOT") + "/jas";
            try {
                Process pJAS = Runtime.getRuntime().exec(JASpath);
            }
            catch (IOException e) {
                String errMsg = e.getMessage();
                return;
            }
            this.JASisrunning = true;
        }
        if (o == this.htmlHelp) {
            return;
        }
        if (o == this.about) {
            return;
        }
        if (o == this.clearAllHist) {
            this.paramPanel.clearAllHistory();
            return;
        }
        if (o == this.clearOneHist) {
            this.paramPanel.clearOneHistory();
            return;
        }
        if (o == this.logFile) {
            if (!this.logFile.isSelected()) {
                this.logtofile = false;
                if (this.outLog != null) {
                    this.outLog.flush();
                }
                return;
            }
            this.logChooser.setCurrentDirectory(new File(this.workdirpath));
            if (this.logChooser.showOpenDialog(this) != 0) {
                return;
            }
            this.logtofile = true;
            try {
                File logFileName = this.logChooser.getSelectedFile();
                this.outLog = new PrintWriter(new BufferedWriter(new FileWriter(logFileName)));
            }
            catch (IOException e) {
                System.out.println(e);
            }
        }
        if (o == this.saveHist) {
            this.saveHist();
        }
    }
}

