/*
 * Decompiled with CFR 0.152.
 */
package GAG;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;

class GAGpipe
extends Thread {
    private Process ps;
    private BufferedReader inpS;
    private BufferedReader errS;
    private PrintWriter outS;
    private String errMsg = null;
    private boolean isErr = false;

    GAGpipe(String[] execFile) {
        try {
            this.ps = Runtime.getRuntime().exec(execFile);
        }
        catch (IOException e) {
            this.isErr = true;
            this.errMsg = e.getMessage();
            return;
        }
        this.inpS = new BufferedReader(new InputStreamReader(this.ps.getInputStream()));
        this.errS = new BufferedReader(new InputStreamReader(this.ps.getErrorStream()));
        this.outS = new PrintWriter(new DataOutputStream(this.ps.getOutputStream()), true);
    }

    String readStdLine() {
        String line = null;
        try {
            line = this.inpS.readLine();
        }
        catch (IOException e) {
            this.isErr = true;
            this.errMsg = e.getMessage();
        }
        return line;
    }

    String readErrLine() {
        String line = null;
        try {
            line = this.errS.readLine();
        }
        catch (IOException e) {
            this.isErr = true;
            this.errMsg = e.getMessage();
            System.err.println(this.errMsg);
        }
        return line;
    }

    synchronized boolean writeLine(String st) {
        this.outS.print(st + "\n");
        return this.outS.checkError();
    }

    synchronized void processKill() {
        this.ps.destroy();
    }

    boolean isError() {
        return this.isErr;
    }

    String getErrorMsg() {
        if (!this.isErr) {
            return "";
        }
        return this.errMsg;
    }
}

