/*
 * Decompiled with CFR 0.152.
 */
package GGE;

import GGE.AngUnitCombo;
import GGE.BREPItem;
import GGE.DAWNSourceFrame;
import GGE.DoubleCellEditor;
import GGE.GGETableModel;
import GGE.IntCellEditor;
import GGE.LenUnitCombo;
import GGE.SolidCellEditor;
import GGE.SolidDialog;
import GGE.SolidItem;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class BREPDialog
extends SolidDialog
implements ActionListener {
    private BREPItem solid;
    private JTextField[] phiField;
    private JTextField sidesField;
    private JComboBox sphiAngUnit;
    private JComboBox dphiAngUnit;
    private JButton addButton;
    private JButton delButton;
    private JButton view;
    private JButton okButton;
    private JFrame frame;
    private JTable zTable;
    private String[] tableHead = new String[]{"Z", "RMax", "RMin", "Unit"};
    private GGETableModel dataModel;
    DAWNSourceFrame dawnSFrame;

    public BREPDialog(SolidCellEditor parent, BREPItem solid) {
        this.solid = solid;
        this.dawnSFrame = new DAWNSourceFrame();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel brepButtonPanel = new JPanel();
        brepButtonPanel.setLayout(new GridLayout(1, 2));
        this.okButton = new JButton(" OK ");
        brepButtonPanel.add(this.okButton);
        this.view = new JButton(" VIEW ");
        brepButtonPanel.add(this.view);
        this.getContentPane().add(brepButtonPanel);
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel panel = new JPanel(gbl);
        JLabel[] phiLabel = new JLabel[2];
        this.phiField = new JTextField[2];
        this.sphiAngUnit = new AngUnitCombo();
        this.dphiAngUnit = new AngUnitCombo();
        for (int i = 0; i < solid.phi.length; ++i) {
            gbc.gridx = 0;
            gbc.gridy = i;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.fill = 0;
            phiLabel[i] = new JLabel(solid.getParaName(i));
            gbl.setConstraints(phiLabel[i], gbc);
            panel.add(phiLabel[i]);
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.gridx = 1;
            this.phiField[i] = new JTextField(8);
            gbl.setConstraints(this.phiField[i], gbc);
            panel.add(this.phiField[i]);
        }
        gbc.fill = 0;
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbl.setConstraints(this.sphiAngUnit, gbc);
        panel.add(this.sphiAngUnit);
        gbc.fill = 0;
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbl.setConstraints(this.dphiAngUnit, gbc);
        panel.add(this.dphiAngUnit);
        if (solid.getSolidType() == 1) {
            JLabel sidesLabel = new JLabel("Sides");
            this.sidesField = new JTextField();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 0.0;
            gbc.fill = 0;
            gbl.setConstraints(sidesLabel, gbc);
            panel.add(sidesLabel);
            gbc.gridx = 1;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbl.setConstraints(this.sidesField, gbc);
            panel.add(this.sidesField);
        }
        this.dataModel = new GGETableModel(this.tableHead, 0);
        this.zTable = new JTable(this.dataModel);
        this.zTable.setAutoCreateColumnsFromModel(false);
        this.zTable.setColumnSelectionAllowed(false);
        this.zTable.setRowSelectionAllowed(true);
        this.zTable.setSelectionMode(0);
        IntCellEditor zCellEditor = new IntCellEditor();
        DoubleCellEditor textCellEditor = new DoubleCellEditor();
        LenUnitCombo lenUnitCombo = new LenUnitCombo();
        textCellEditor.setClickCountToStart(2);
        zCellEditor.setClickCountToStart(2);
        TableColumn[] columns = new TableColumn[4];
        for (int i = 0; i < 4; ++i) {
            columns[i] = this.zTable.getColumn(this.tableHead[i]);
        }
        DefaultTableCellRenderer zCellRenderer = new DefaultTableCellRenderer();
        zCellRenderer.setBackground(Color.pink);
        columns[0].setCellEditor(textCellEditor);
        columns[0].setCellRenderer(zCellRenderer);
        columns[1].setCellEditor(textCellEditor);
        columns[2].setCellEditor(textCellEditor);
        columns[3].setCellEditor(new DefaultCellEditor(lenUnitCombo));
        JScrollPane scrollpane = new JScrollPane(this.zTable);
        scrollpane.setPreferredSize(new Dimension(180, 80));
        scrollpane.setMinimumSize(new Dimension(40, 20));
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 1;
        this.getContentPane().add(panel);
        JPanel panel2 = new JPanel();
        panel2.setLayout(new GridLayout(1, 2));
        this.addButton = new JButton("Add a Section");
        panel2.add(this.addButton);
        this.addButton.addActionListener(this);
        this.delButton = new JButton("Del a Section");
        panel2.add(this.delButton);
        this.delButton.addActionListener(this);
        gbl.setConstraints(panel2, gbc);
        panel.add(panel2);
        this.getContentPane().add(panel);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbl.setConstraints(scrollpane, gbc);
        panel.add(scrollpane);
        this.view.addActionListener(this);
        this.okButton.addActionListener(parent);
        this.setValues();
        this.pack();
        this.setVisible(true);
    }

    private void setValues() {
        if (this.solid.isEmpty) {
            return;
        }
        for (int i = 0; i < this.solid.phi.length; ++i) {
            this.phiField[i].setText(Double.toString(this.solid.phi[i]));
        }
        if (this.solid.getSolidType() == 1) {
            this.sidesField.setText(Integer.toString(this.solid.nSides));
        }
        for (int j = 0; j < this.solid.zVector.size(); ++j) {
            Vector br = (Vector)this.solid.zVector.elementAt(j);
            this.dataModel.addRow(br);
        }
        this.sphiAngUnit.setSelectedItem(this.solid.sAngUnit);
        this.dphiAngUnit.setSelectedItem(this.solid.dAngUnit);
    }

    public void editStop() {
        this.setVisible(false);
    }

    public SolidItem getValues() {
        for (int i = 0; i < 2; ++i) {
            try {
                this.solid.phi[i] = new Double(this.phiField[i].getText());
                continue;
            }
            catch (NumberFormatException e) {
                this.solid.phi[i] = 0.0;
            }
        }
        if (this.solid.getSolidType() == 1) {
            try {
                this.solid.nSides = Integer.parseInt(this.sidesField.getText());
            }
            catch (NumberFormatException e) {
                this.solid.nSides = 0;
            }
        }
        this.solid.zVector = this.dataModel.getDataVector();
        this.solid.sAngUnit = (String)this.sphiAngUnit.getSelectedItem();
        this.solid.dAngUnit = (String)this.dphiAngUnit.getSelectedItem();
        this.solid.isEmpty = false;
        this.dispose();
        return this.solid;
    }

    private void getDAWN() {
        this.dawnSFrame.setVisible(true);
        this.dawnSFrame.dawnEditor.setText(this.solid.getPrim());
        try {
            FileOutputStream fileout = new FileOutputStream("GGESolid.prim");
            PrintWriter outf = new PrintWriter(new DataOutputStream(fileout));
            outf.println(this.solid.getPrim());
            outf.close();
        }
        catch (IOException e) {
            System.out.println(e.toString());
        }
        try {
            String cmd = "dawn -v GGESolid.prim";
            Runtime r = Runtime.getRuntime();
            Process process = r.exec(cmd);
        }
        catch (IOException e) {
            System.out.println(e.toString());
        }
    }

    public void actionPerformed(ActionEvent ae) {
        Object o = ae.getSource();
        if (o == this.addButton) {
            Object[] tmp = new Object[]{"", "", "", "mm"};
            this.dataModel.addRow(tmp);
        }
        if (o == this.view) {
            this.getValues();
            this.getDAWN();
        }
        if (o == this.delButton) {
            if (this.zTable.getSelectedRow() == -1) {
                JOptionPane opane = new JOptionPane();
                JOptionPane.showMessageDialog(this, "Choose the  Z  ", "Warning Dialog", 2);
                JDialog dialog = opane.createDialog(this, "Warning Dialog");
                try {
                    Class<?> targetClass = dialog.getClass();
                    Class[] parameters = new Class[]{Boolean.TYPE};
                    Method method = targetClass.getDeclaredMethod("setAlwaysOnTop", parameters);
                    Object targetInstance = targetClass.newInstance();
                    Object[] params = new Object[]{new boolean[]{true}};
                    if (System.getProperty("java.version").equals("1.5.0")) {
                        method.invoke(targetInstance, params);
                    }
                }
                catch (Exception e) {}
            } else {
                this.dataModel.removeRow(this.zTable.getSelectedRow());
                return;
            }
        }
    }
}

