/*
 * Decompiled with CFR 0.152.
 */
package GGE;

import GGE.SolidItem;

public class CSGItem
extends SolidItem {
    static final int BOX = 0;
    static final int TRD = 1;
    static final int TUBS = 2;
    static final int CONS = 3;
    static final int SPHERE = 4;
    static final int PARALLEL = 5;
    static final int TORUS = 6;
    static final int HYPE = 7;
    static final String[] solidName = new String[]{"Box", "SymTrapezoid", "TubeSegment", "ConeSegment", "SphereSegment", "Parallelepiped", "TorusSegment", "HYPE"};
    static final String[] csgName = new String[]{"Box", "Trd", "Tubs", "Cons", "Sphere", "Para", "Torus", "Hype"};
    static final String[] csgDAWNName = new String[]{"Box", "Trd", "Tubs", "Cons", "SphereSeg", "Parallelepiped", "Torus", "Hype"};
    static final String[] solidConstr = new String[]{"Box", "Trapezoid", "TubeSegment", "ConeSegment", "SphereSegment", "Parallelepiped", "TorusSegment", "HYPE"};
    static final String[][] paraName = new String[][]{{"XHalfLength", "YHalfLength", "ZHalfLength"}, {"XHalfLengthAt-dz", "XHalfLengthAt+dz", "YHalfLengthAt-dz", "YHalfLengthAt+dz", "ZHalfLength"}, {"InnerRadius", "OuterRadius", "ZHalfLength", "StartPhiAngle", "DeltaPhiAngle"}, {"InnerRadiusAt-dz", "OuterRadiusAt-dz", "InnerRadiusAt+dz", "OuterRadiusAt+dz", "ZHalfLength", "StartPhiAngle", "DeltaPhiAngle"}, {"InnerRadius", "OuterRadius", "StartPhiAngle", "DeltaPhiAngle", "StartThetaAngle", "DeltaThetaAngle"}, {"XHalfLength", "YHalfLength", "ZHalfLength", "Alpha", "Theta", "phi"}, {"InnerRadius", "OuterRadius", "SweptRadius", "StartPhiAngle", "DeltaPhiAngle"}, {"InnerRadius", "OuterRadius", "InnerStereo", "OuterStereo", "ZHalfLength"}};
    static final boolean[][] isAngl = new boolean[][]{{false, false, false}, {false, false, false, false, false}, {false, false, false, true, true}, {false, false, false, false, false, true, true}, {false, false, true, true, true, true}, {false, false, false, true, true, true}, {false, false, false, true, true}, {false, false, true, true, false}};
    private double[] values;
    private String[] units;
    private double mmValue;
    private double bound;

    public CSGItem(int solidType) {
        super(solidType);
        this.values = new double[paraName[solidType].length];
        this.units = new String[isAngl[solidType].length];
        this.isEmpty = true;
    }

    int getParaCount() {
        return paraName[this.solidType].length;
    }

    double getValues(int pos) {
        return this.values[pos];
    }

    String getUnits(int pos) {
        return this.units[pos];
    }

    void setValuesUnits(int pos, double value, String unit) {
        this.values[pos] = value;
        this.units[pos] = unit;
        this.isEmpty = false;
    }

    String getParaName(int pos) {
        return paraName[this.solidType][pos];
    }

    boolean isAngle(int pos) {
        return isAngl[this.solidType][pos];
    }

    public String toString() {
        return solidName[this.solidType];
    }

    String getCPP(String name) {
        StringBuffer cpp = new StringBuffer("G4" + csgName[this.solidType] + " *solid" + name + "= new G4" + csgName[this.solidType] + "(\"solid" + name + "\"");
        for (int i = 0; i < this.values.length; ++i) {
            cpp.append(", " + this.values[i] + "*" + this.units[i]);
        }
        cpp.append(" );\n");
        return cpp.toString();
    }

    String getXML(String name, int defNum) {
        StringBuffer xml = new StringBuffer();
        int i = defNum;
        if (csgName[this.solidType] == "Box") {
            if (name == null || name.equals("")) {
                name = "box" + defNum;
            }
            xml.append("     <box name=\"" + name + "\" x=\"x-" + i + "\" y=\"y-" + i + "\" z=\"z-" + i + "\" />\n");
        } else if (csgName[this.solidType] == "Trd") {
            if (name == null || name.equals("")) {
                name = "trd" + defNum;
            }
            xml.append("     <trd name=\"" + name + "\" x1=\"x1-" + i + "\" x2=\"x2-" + i + "\" y1=\"y1-" + i + "\" y2=\"y2-" + i + "\" z=\"z-" + i + "\" />\n");
        } else if (csgName[this.solidType] == "Tubs") {
            if (name == null || name.equals("")) {
                name = "tube" + defNum;
            }
            xml.append("     <tube name=\"" + name + "\" rmin=\"rmin-" + i + "\" rmax=\"rmax-" + i + "\" z=\"z-" + i + "\" startphi=\"startphi-" + i + "\" deltaphi=\"deltaphi-" + i + "\" />\n");
        } else if (csgName[this.solidType] == "Cons") {
            if (name == null || name.equals("")) {
                name = "cone" + defNum;
            }
            xml.append("     <cone name=\"" + name + "\" rmin1=\"rmin1-" + i + "\" rmax1=\"rmax1-" + i + "\" rmin2=\"rmin2-" + i + "\" rmax2=\"rmax2-" + i + "\" z=\"z-" + i + "\" startphi=\"startphi-" + i + "\" deltaphi=\"deltaphi-" + i + "\" />\n");
        } else if (csgName[this.solidType] == "Sphere") {
            if (name == null || name.equals("")) {
                name = "sphere" + defNum;
            }
            xml.append("     <sphere name=\"" + name + "\" rmin=\"rmin-" + i + "\" rmax=\"rmax-" + i + "\" startphi=\"startphi-" + i + "\" deltaphi=\"deltaphi-" + i + "\" starttheta=\"starttheta-" + i + "\" deltatheta=\"deltatheta-" + i + "\" />\n");
        } else if (csgName[this.solidType] == "Para") {
            if (name == null || name.equals("")) {
                name = "para" + defNum;
            }
            xml.append("     <para name=\"" + name + "\" x=\"x-" + i + "\" y=\"y-" + i + "\" z=\"z-" + i + "\" alpha=\"alpha-" + i + "\" theta=\"theta-" + i + "\" phi=\"phi-" + i + "\" />\n");
        }
        return xml.toString();
    }

    String getDefine(String name, int defNum) {
        StringBuffer xml = new StringBuffer();
        int solidNum = 0;
        boolean isGDMLSolid = true;
        String[][] xmlparaName = new String[][]{{"x", "y", "z"}, {"x1", "x2", "y1", "y2", "z"}, {"rmin", "rmax", "z", "startphi", "deltaphi"}, {"rmin1", "rmax1", "rmin2", "rmax2", "z", "startphi", "deltaphi"}, {"rmin", "rmax", "startphi", "deltaphi", "starttheta", "deltatheta"}, {"x", "y", "z", "alpha", "theta", "phi"}};
        if (csgName[this.solidType] == "Box") {
            solidNum = 0;
        } else if (csgName[this.solidType] == "Trd") {
            solidNum = 1;
        } else if (csgName[this.solidType] == "Tubs") {
            solidNum = 2;
        } else if (csgName[this.solidType] == "Cons") {
            solidNum = 3;
        } else if (csgName[this.solidType] == "Sphere") {
            solidNum = 4;
        } else if (csgName[this.solidType] == "Para") {
            solidNum = 5;
        } else {
            isGDMLSolid = false;
        }
        if (isGDMLSolid) {
            for (int i = 0; i < this.values.length; ++i) {
                xml.append("        <quantity name=\"" + xmlparaName[solidNum][i] + "-" + defNum + "\" value=\"" + this.values[i] + "\" unit=\"" + this.units[i] + "\"/>\n");
            }
        }
        return xml.toString();
    }

    private double changMM(int count) {
        this.mmValue = this.getUnits(count).equals("km") ? Math.pow(this.values[count] * 1000000.0, 2.0) : (this.getUnits(count).equals("m") ? Math.pow(this.values[count] * 1000.0, 2.0) : (this.getUnits(count).equals("cm") ? Math.pow(this.values[count] * 10.0, 2.0) : (this.getUnits(count).equals("micrometer") ? Math.pow(this.values[count] / 1000.0, 2.0) : (this.getUnits(count).equals("nanoometer") ? Math.pow(this.values[count] / 1000000.0, 2.0) : (this.getUnits(count).equals("fermi") ? Math.pow(this.values[count] / 1.0E9, 2.0) : (this.getUnits(count).equals("mm") ? Math.pow(this.values[count], 2.0) : 0.0))))));
        return this.mmValue;
    }

    private double Bound() {
        this.bound = 0.0;
        for (int j = 0; j < this.values.length; ++j) {
            this.bound += this.changMM(j);
        }
        return Math.sqrt(this.bound) * 2.0;
    }

    public String getPrim() {
        StringBuffer prim = new StringBuffer("#################################\n");
        prim.append("###         GGESolid.prim      ###\n");
        prim.append("#################################\n#\n");
        prim.append("/BoundingBox ");
        prim.append(" -" + this.Bound() + "   -" + this.Bound() + "   -" + this.Bound() + "   ");
        prim.append(this.Bound() + "   " + this.Bound() + "   " + this.Bound() + "\n");
        prim.append("!SetCamera\n!OpenDevice\n!BeginModeling\n\n");
        prim.append("/" + csgDAWNName[this.solidType]);
        for (int j = 0; j < this.values.length; ++j) {
            if (this.getUnits(j).equals("km")) {
                prim.append("    " + this.values[j] * 1000000.0);
                continue;
            }
            if (this.getUnits(j).equals("m")) {
                prim.append("    " + this.values[j] * 1000.0);
                continue;
            }
            if (this.getUnits(j).equals("cm")) {
                prim.append("    " + this.values[j] * 10.0);
                continue;
            }
            if (this.getUnits(j).equals("micrometer")) {
                prim.append("    " + this.values[j] / 1000.0);
                continue;
            }
            if (this.getUnits(j).equals("nanoometer")) {
                prim.append("    " + this.values[j] / 1000000.0);
                continue;
            }
            if (this.getUnits(j).equals("fermi")) {
                prim.append("    " + this.values[j] / 1.0E9);
                continue;
            }
            if (this.getUnits(j).equals("mm")) {
                prim.append("    " + this.values[j]);
                continue;
            }
            if (this.getUnits(j).equals("mrad")) {
                prim.append(" " + this.values[j] / 1000.0);
                continue;
            }
            if (this.getUnits(j).equals("deg")) {
                prim.append(" " + this.values[j] * 2.0 * Math.PI / 360.0);
                continue;
            }
            prim.append(" " + this.values[j]);
        }
        prim.append("\n\n!EndModeling\n!DrawAll\n!CloseDevice");
        return prim.toString();
    }
}

