/*
 * Decompiled with CFR 0.152.
 */
package GGE;

import GGE.DoubleCellEditor;
import GGE.GGETableModel;
import GGE.MaterialFrame;
import GGE.NameCellEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public abstract class MaterialAbstTable
extends JTable
implements ActionListener {
    protected JButton append;
    protected JButton ins;
    protected JButton del;
    protected String tableTitle;
    MaterialFrame parent;
    protected GGETableModel model;

    public MaterialAbstTable(GGETableModel model, MaterialFrame parent) {
        super(model);
        this.model = model;
        this.parent = parent;
        this.setAutoCreateColumnsFromModel(false);
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(true);
        this.getTableHeader().setReorderingAllowed(false);
        this.setSelectionMode(0);
        JComboBox<String> stateCombo = new JComboBox<String>();
        stateCombo.addItem("kStateUndefined");
        stateCombo.addItem("kStateSolid");
        stateCombo.addItem("kStateLiquid");
        stateCombo.addItem("kStateGas");
        JComboBox<String> pressUnitCombo = new JComboBox<String>();
        pressUnitCombo.addItem("pascal");
        pressUnitCombo.addItem("bar");
        pressUnitCombo.addItem("atmosphere");
        JComboBox<String> denl = new JComboBox<String>();
        denl.addItem("mg/cm3");
        denl.addItem("g/cm3");
        denl.addItem("kg/m3");
        JComboBox<String> kl = new JComboBox<String>();
        kl.addItem("kelvin");
        JComboBox<String> use = new JComboBox<String>();
        use.addItem("    ");
        use.addItem("Used");
        DefaultTableCellRenderer useCellRenderer = new DefaultTableCellRenderer();
        useCellRenderer.setForeground(Color.red);
        DefaultTableCellRenderer nameCellRenderer = new DefaultTableCellRenderer();
        nameCellRenderer.setBackground(Color.pink);
        TableColumn column = new TableColumn();
        column = this.getColumn("Use");
        column.setCellEditor(new DefaultCellEditor(use));
        column.setCellRenderer(useCellRenderer);
        column.setWidth(4);
        column = this.getColumn("Name");
        column.setCellEditor(new NameCellEditor());
        column.setCellRenderer(nameCellRenderer);
        column.sizeWidthToFit();
        column.setResizable(true);
        column = this.getColumn("Density");
        column.setCellEditor(new DoubleCellEditor());
        column.sizeWidthToFit();
        column.setResizable(true);
        column = this.getColumn("Unit");
        column.setWidth(5);
        column.setCellEditor(new DefaultCellEditor(denl));
        column = this.getColumn("State");
        column.setCellEditor(new DefaultCellEditor(stateCombo));
        column.setWidth(8);
        column.setResizable(true);
        column = this.getColumn("Temp");
        column.setCellEditor(new DoubleCellEditor());
        column.sizeWidthToFit();
        column.setResizable(true);
        column = this.getColumn(" Unit");
        column.setCellEditor(new DefaultCellEditor(kl));
        column.setWidth(6);
        column = this.getColumn("Press");
        column.setCellEditor(new DoubleCellEditor());
        column.sizeWidthToFit();
        column.setResizable(true);
        column = this.getColumn("Unit ");
        column.setCellEditor(new DefaultCellEditor(pressUnitCombo));
        column.setWidth(6);
    }

    public JPanel makeMaterialPanel() {
        JScrollPane scrollpane = new JScrollPane(this);
        scrollpane.setPreferredSize(new Dimension(780, 250));
        scrollpane.setMinimumSize(new Dimension(150, 50));
        JPanel tab = new JPanel();
        tab.setLayout(new BorderLayout(5, 3));
        Box buttonPanel = Box.createHorizontalBox();
        JLabel mtitle = new JLabel(this.tableTitle);
        mtitle.setFont(new Font("Serif", 1, 12));
        Dimension tsize = mtitle.getPreferredSize();
        mtitle.setSize(tsize);
        buttonPanel.add(mtitle);
        this.append = new JButton("Append");
        buttonPanel.add(this.append);
        this.ins = new JButton("Insert");
        buttonPanel.add(this.ins);
        this.del = new JButton("Delete");
        buttonPanel.add(this.del);
        buttonPanel.add(Box.createHorizontalGlue());
        tab.add((Component)buttonPanel, "North");
        tab.add((Component)scrollpane, "Center");
        this.append.addActionListener(this);
        this.ins.addActionListener(this);
        this.del.addActionListener(this);
        return tab;
    }

    public void actionPerformed(ActionEvent ae) {
        Object o = ae.getSource();
        if (o == this.append) {
            this.create();
            this.append.setForeground(Color.red);
            return;
        }
        if (o == this.ins) {
            this.insert();
            this.ins.setForeground(Color.red);
            return;
        }
        if (o == this.del) {
            this.delete();
            this.del.setForeground(Color.red);
            return;
        }
    }

    public void dellMatCloseAct() {
        this.del.setForeground(Color.black);
        this.del.repaint();
    }

    public void createMatCloseAct() {
        this.append.setForeground(Color.black);
        this.append.repaint();
    }

    abstract void create();

    abstract void insert();

    abstract void delete();

    void stopEditing() {
        if (this.isEditing()) {
            this.cellEditor.stopCellEditing();
        }
        this.clearSelection();
    }

    Object getSelectedName() {
        if (this.isEditing()) {
            this.cellEditor.stopCellEditing();
        }
        Vector data = this.model.getDataVector();
        int row = this.getSelectedRow();
        if (row < 0) {
            return null;
        }
        return ((Vector)data.elementAt(row)).elementAt(0);
    }

    public void valueChanged(ListSelectionEvent lse) {
        super.valueChanged(lse);
        if (lse.getValueIsAdjusting()) {
            this.selected();
        }
        if (lse.getFirstIndex() < 0) {
            return;
        }
        if (lse.getLastIndex() < 0) {
            return;
        }
    }

    protected abstract void selected();
}

