/*
 * Decompiled with CFR 0.152.
 */
package GGE;

import GGE.AbstractGGEPanel;
import GGE.ElementItem;
import GGE.ElementsTable;
import GGE.GGETableModel;
import GGE.MaterialCombiTable;
import GGE.MaterialItem;
import GGE.MaterialScratchTable;
import GGE.RatioItem;
import GGE.VolumesFrame;
import GPE.ExampleFileFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MaterialFrame
extends AbstractGGEPanel
implements ActionListener {
    public ElementsTable et;
    ElementItem[] eic;
    public MaterialScratchTable msTable;
    public MaterialCombiTable mcTable;
    public GGETableModel msDataModel;
    public GGETableModel mcDataModel;
    String[] msNames = new String[]{"Use", "Name", "Z", "A", "Density", "Unit", "State", "Temp", " Unit", "Press", "Unit "};
    String[] mcNames = new String[]{"Use", "Name", "Elements", "Density", "Unit", "State", "Temp", " Unit", "Press", "Unit "};
    int msRow;
    int msCol;
    int mcRow;
    int mcCol;
    boolean msCel;
    boolean mcCel;
    JLabel label;
    private JMenuItem load;
    private JMenuItem xmlload;
    private JMenuItem save;
    private JMenuItem xmlsave;
    private JMenuItem append;
    private JMenuItem clear;
    private JMenuItem tOpen;
    private JMenuItem tClose;
    private JFileChooser saveData;
    private JFileChooser loadData;
    private String fileName;
    private String createFile;
    private String newFile;
    static String fileDir;
    public String workdirpath = ".";

    public MaterialFrame() {
        this.et = new ElementsTable();
        this.msDataModel = new GGETableModel(this.msNames, 0);
        this.msTable = new MaterialScratchTable(this.msDataModel, this);
        this.mcDataModel = new GGETableModel(this.mcNames, 0);
        this.mcTable = new MaterialCombiTable(this.mcDataModel, this);
        this.MaterialfileClear();
        this.setLayout(new BorderLayout());
        JSplitPane splitPane = new JSplitPane(0, true, this.msTable.makeMaterialPanel(), this.mcTable.makeMaterialPanel());
        this.add("North", this.createMenubar());
        this.add((Component)splitPane, "Center");
        this.setSize(700, 580);
        this.setVisible(true);
    }

    private JMenuBar createMenubar() {
        JMenuBar mb = new JMenuBar();
        JMenu file = new JMenu("File");
        this.load = new JMenuItem("Load a Material File");
        file.add(this.load);
        this.xmlload = new JMenuItem("Load a Material XML File");
        file.add(this.xmlload);
        file.addSeparator();
        this.append = new JMenuItem("Append a Material File");
        file.add(this.append);
        file.addSeparator();
        this.save = new JMenuItem("Save Material");
        file.add(this.save);
        this.xmlsave = new JMenuItem("Save XML Material");
        file.add(this.xmlsave);
        file.addSeparator();
        this.clear = new JMenuItem("Clear Material");
        file.add(this.clear);
        this.load.addActionListener(this);
        this.xmlload.addActionListener(this);
        this.append.addActionListener(this);
        this.save.addActionListener(this);
        this.xmlsave.addActionListener(this);
        this.clear.addActionListener(this);
        mb.add(file);
        JMenu element = new JMenu("Elements");
        this.tOpen = new JMenuItem("Open Periodic Table");
        element.add(this.tOpen);
        element.addSeparator();
        this.tClose = new JMenuItem("Close Periodic Table");
        element.add(this.tClose);
        this.tOpen.addActionListener(this);
        this.tClose.addActionListener(this);
        mb.add(element);
        return mb;
    }

    public void actionPerformed(ActionEvent ae) {
        Object o = ae.getSource();
        if (o == this.load) {
            this.MaterialfileLoad();
        }
        if (o == this.xmlload) {
            this.MaterialXMLfileLoad();
        }
        if (o == this.append) {
            this.MaterialfileAppend();
        }
        if (o == this.save) {
            this.MaterialfileSave();
        }
        if (o == this.xmlsave) {
            this.MaterialXMLfileSave();
        }
        if (o == this.clear) {
            this.MaterialfileClear();
        }
        if (o == this.tOpen) {
            this.et.setVisible(true);
        }
        if (o == this.tClose) {
            this.et.setVisible(false);
        }
    }

    private synchronized void resume() {
        this.notify();
    }

    public void MaterialfileAppend() {
        JFileChooser loadData = new JFileChooser(this.workdirpath);
        loadData.cancelSelection();
        loadData.resetChoosableFileFilters();
        ExampleFileFilter mtFile = new ExampleFileFilter("g4mt", "MaterialSource");
        loadData.setFileFilter(mtFile);
        loadData.setDialogTitle("Load Material");
        loadData.setMultiSelectionEnabled(true);
        if (loadData.showOpenDialog(this) != 0) {
            return;
        }
        File fml = loadData.getSelectedFile();
        this.fileName = fml.getPath();
        if (fml.isFile()) {
            this.resume();
            try {
                int i;
                FileInputStream filein = new FileInputStream(this.fileName);
                ObjectInputStream objin = new ObjectInputStream(filein);
                Vector mtData = (Vector)objin.readObject();
                Vector msData = (Vector)mtData.firstElement();
                Vector mcData = (Vector)mtData.lastElement();
                if (this.msDataModel.getRowCount() != 0 || msData.size() != 0) {
                    for (i = 0; i < msData.size(); ++i) {
                        Vector ms = (Vector)msData.elementAt(i);
                        this.msDataModel.addRow(ms);
                    }
                    this.repaint();
                }
                if (this.mcDataModel.getRowCount() != 0 || mcData.size() != 0) {
                    for (i = 0; i < mcData.size(); ++i) {
                        Vector mc = (Vector)mcData.elementAt(i);
                        this.mcDataModel.addRow(mc);
                    }
                    this.repaint();
                }
                objin.close();
                this.repaint();
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
        } else {
            System.out.println("error=" + fml.toString() + "isNotaFile");
        }
    }

    public void MaterialfileLoad() {
        JFileChooser loadData = new JFileChooser(this.workdirpath);
        loadData.cancelSelection();
        loadData.resetChoosableFileFilters();
        ExampleFileFilter mtFile = new ExampleFileFilter("g4mt", "MaterialSource");
        loadData.setFileFilter(mtFile);
        loadData.setDialogTitle("Load Material");
        loadData.setMultiSelectionEnabled(true);
        if (loadData.showOpenDialog(this) != 0) {
            return;
        }
        File fml = loadData.getSelectedFile();
        this.fileName = fml.getPath();
        if (fml.isFile()) {
            this.resume();
            try {
                int i;
                FileInputStream filein = new FileInputStream(this.fileName);
                ObjectInputStream objin = new ObjectInputStream(filein);
                Vector mtData = (Vector)objin.readObject();
                Vector msData = (Vector)mtData.firstElement();
                Vector mcData = (Vector)mtData.lastElement();
                if (this.msDataModel.getRowCount() != 0 || msData.size() != 0) {
                    this.msDataModel = new GGETableModel(this.msNames, 0);
                    this.msTable.setModel(this.msDataModel);
                    for (i = 0; i < msData.size(); ++i) {
                        Vector ms = (Vector)msData.elementAt(i);
                        this.msDataModel.addRow(ms);
                    }
                    this.repaint();
                }
                if (this.mcDataModel.getRowCount() != 0 || mcData.size() != 0) {
                    this.mcDataModel = new GGETableModel(this.mcNames, 0);
                    this.mcTable.setModel(this.mcDataModel);
                    for (i = 0; i < mcData.size(); ++i) {
                        Vector mc = (Vector)mcData.elementAt(i);
                        this.mcDataModel.addRow(mc);
                    }
                    this.repaint();
                }
                objin.close();
                this.repaint();
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
        } else {
            System.out.println("error=" + fml.toString() + "isNotaFile");
        }
    }

    public void MaterialXMLfileLoad() {
        JFileChooser loadXML = new JFileChooser(this.workdirpath);
        ExampleFileFilter xmlFile = new ExampleFileFilter("xml", "XML Source");
        loadXML.setFileFilter(xmlFile);
        loadXML.setDialogTitle("Load XML");
        if (loadXML.showOpenDialog(this) != 0) {
            return;
        }
        loadXML.setMultiSelectionEnabled(true);
        File fl = loadXML.getSelectedFile();
        if (fl.isFile()) {
            this.workdirpath = this.fileName = fl.getPath();
            try {
                int j;
                DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = dbfactory.newDocumentBuilder();
                Document doc = builder.parse(new File(this.fileName));
                Element root = doc.getDocumentElement();
                NodeList nodelist = root.getChildNodes();
                Vector logStrData = new Vector();
                Vector logSldData = new Vector();
                Vector mtrScrData = new Vector();
                Vector mtrComData = new Vector();
                for (int i = 0; i < nodelist.getLength(); ++i) {
                    Node node = nodelist.item(i);
                    NamedNodeMap attrs = node.getAttributes();
                    if (attrs == null || node.getNodeName() != "materials") continue;
                    NodeList mtrList = node.getChildNodes();
                    for (int j2 = 0; j2 < mtrList.getLength(); ++j2) {
                        NodeList mtrCList;
                        String dUnit;
                        String dValue;
                        Node mtrNode = mtrList.item(j2);
                        String mtrName = mtrNode.getNodeName();
                        NamedNodeMap mtrAttrs = mtrNode.getAttributes();
                        if (mtrAttrs == null || mtrName != "material") continue;
                        Node formulaNode = mtrAttrs.getNamedItem("formula");
                        if (formulaNode != null) {
                            dValue = "";
                            dUnit = "";
                            String aValue = "";
                            String tValue = "";
                            String tUnit = "";
                            String pValue = "";
                            String pUnit = "";
                            mtrCList = mtrNode.getChildNodes();
                            for (int k = 0; k < mtrCList.getLength(); ++k) {
                                Node mtrCNode = mtrCList.item(k);
                                NamedNodeMap mtrCAttrs = mtrCNode.getAttributes();
                                if (mtrCAttrs == null) continue;
                                if (mtrCNode.getNodeName() == "D") {
                                    dValue = mtrCAttrs.getNamedItem("value").getNodeValue();
                                    dUnit = mtrCAttrs.getNamedItem("unit").getNodeValue();
                                    continue;
                                }
                                if (mtrCNode.getNodeName() == "atom") {
                                    aValue = mtrCAttrs.getNamedItem("value").getNodeValue();
                                    continue;
                                }
                                if (mtrCNode.getNodeName() == "T") {
                                    tValue = mtrCAttrs.getNamedItem("value").getNodeValue();
                                    tUnit = mtrCAttrs.getNamedItem("unit").getNodeValue();
                                    continue;
                                }
                                if (mtrCNode.getNodeName() != "P") continue;
                                pValue = mtrCAttrs.getNamedItem("value").getNodeValue();
                                pUnit = mtrCAttrs.getNamedItem("unit").getNodeValue();
                            }
                            Vector<String> mtrData = new Vector<String>();
                            String stateStr = mtrAttrs.getNamedItem("state").getNodeValue();
                            String state = "";
                            state = stateStr == "unknown" ? MaterialItem.stateCode[0] : (stateStr.equals("solid") ? MaterialItem.stateCode[1] : (stateStr.equals("liquid") ? MaterialItem.stateCode[2] : (stateStr.equals("gas") ? MaterialItem.stateCode[3] : MaterialItem.stateCode[0])));
                            mtrData.addElement("Used");
                            mtrData.addElement(mtrAttrs.getNamedItem("name").getNodeValue());
                            mtrData.addElement(mtrAttrs.getNamedItem("Z").getNodeValue());
                            mtrData.addElement(aValue);
                            mtrData.addElement(dValue);
                            mtrData.addElement(dUnit);
                            mtrData.addElement(state);
                            mtrData.addElement(tValue);
                            mtrData.addElement(tUnit);
                            mtrData.addElement(pValue);
                            mtrData.addElement(pUnit);
                            mtrScrData.addElement(mtrData);
                            continue;
                        }
                        dValue = "";
                        dUnit = "";
                        String tValue = "";
                        String tUnit = "";
                        String pValue = "";
                        String pUnit = "";
                        Vector elemV = new Vector();
                        mtrCList = mtrNode.getChildNodes();
                        for (int k = 0; k < mtrCList.getLength(); ++k) {
                            Node mtrCNode = mtrCList.item(k);
                            NamedNodeMap mtrCAttrs = mtrCNode.getAttributes();
                            if (mtrCAttrs == null) continue;
                            if (mtrCNode.getNodeName() == "D") {
                                dValue = mtrCAttrs.getNamedItem("value").getNodeValue();
                                dUnit = mtrCAttrs.getNamedItem("unit").getNodeValue();
                                continue;
                            }
                            if (mtrCNode.getNodeName() == "T") {
                                tValue = mtrCAttrs.getNamedItem("value").getNodeValue();
                                tUnit = mtrCAttrs.getNamedItem("unit").getNodeValue();
                                continue;
                            }
                            if (mtrCNode.getNodeName() == "P") {
                                pValue = mtrCAttrs.getNamedItem("value").getNodeValue();
                                pUnit = mtrCAttrs.getNamedItem("unit").getNodeValue();
                                continue;
                            }
                            Vector<String> v = new Vector<String>();
                            v.addElement(mtrCNode.getNodeName());
                            v.addElement(mtrCAttrs.getNamedItem("n").getNodeValue());
                            v.addElement(mtrCAttrs.getNamedItem("ref").getNodeValue());
                            elemV.addElement(v);
                        }
                        int isfraction = 0;
                        int num = 0;
                        float[] ratioNum = new float[elemV.size()];
                        this.eic = new ElementItem[elemV.size()];
                        for (int k = 0; k < elemV.size(); ++k) {
                            String fraction = ((Vector)elemV.elementAt(k)).elementAt(0).toString();
                            String elem = ((Vector)elemV.elementAt(k)).elementAt(2).toString();
                            String ratioStr = ((Vector)elemV.elementAt(k)).elementAt(1).toString();
                            ratioNum[k] = Float.valueOf(ratioStr).floatValue();
                            for (int l = 0; l < 104; ++l) {
                                if (!this.et.getSymbol(l).equals(elem)) continue;
                                this.eic[num] = this.et.getElement(l);
                                ++num;
                            }
                            if (fraction == "fraction") {
                                isfraction = 1;
                                continue;
                            }
                            if (fraction != "composite") continue;
                            isfraction = 0;
                        }
                        RatioItem ratioItem = new RatioItem(this.eic);
                        ratioItem.ratio = ratioNum;
                        ratioItem.isEmpty = false;
                        ratioItem.isFraction = isfraction;
                        Vector<Object> mtrData = new Vector<Object>();
                        mtrData.addElement("Used");
                        mtrData.addElement(mtrAttrs.getNamedItem("name").getNodeValue());
                        mtrData.addElement(ratioItem);
                        mtrData.addElement(dValue);
                        mtrData.addElement(dUnit);
                        mtrData.addElement("kStateUndefined");
                        mtrData.addElement(tValue);
                        mtrData.addElement(tUnit);
                        mtrData.addElement(pValue);
                        mtrData.addElement(pUnit);
                        mtrComData.addElement(mtrData);
                    }
                }
                this.MaterialfileClear();
                for (j = 0; j < mtrScrData.size(); ++j) {
                    Vector scratch = (Vector)mtrScrData.elementAt(j);
                    this.msDataModel.addRow(scratch);
                }
                for (j = 0; j < mtrComData.size(); ++j) {
                    Vector combi = (Vector)mtrComData.elementAt(j);
                    this.mcDataModel.addRow(combi);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("error=" + fl.toString() + "isNotaFile");
        }
    }

    public void MaterialfileSave() {
        JFileChooser saveData = new JFileChooser(this.workdirpath);
        ExampleFileFilter mtFile = new ExampleFileFilter("g4mt", "MaterialSource");
        saveData.setFileFilter(mtFile);
        saveData.setDialogTitle("Save Material");
        if (saveData.showSaveDialog(this) != 0) {
            return;
        }
        File fms = saveData.getSelectedFile();
        this.fileName = fms.getPath();
        if (this.fileName != null) {
            try {
                FileOutputStream fileout = new FileOutputStream(this.fileName);
                ObjectOutputStream objout = new ObjectOutputStream(fileout);
                Vector<Vector> mtVector = new Vector<Vector>();
                Vector msVector = new Vector();
                mtVector.addElement(this.msDataModel.getDataVector());
                mtVector.addElement(this.mcDataModel.getDataVector());
                objout.writeObject(mtVector);
                objout.flush();
                fileout.close();
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
            return;
        }
        if (this.fileName == null) {
            return;
        }
    }

    public void MaterialXMLfileSave() {
        JFileChooser saveXML = new JFileChooser(this.workdirpath);
        ExampleFileFilter xmlFile = new ExampleFileFilter("xml", "XML Source");
        saveXML.setFileFilter(xmlFile);
        saveXML.setDialogTitle("Save XML");
        if (saveXML.showSaveDialog(this) != 0) {
            return;
        }
        VolumesFrame volframe = new VolumesFrame();
        StringBuffer xml = new StringBuffer();
        xml.append(volframe.headerXML());
        xml.append(this.getXML());
        xml.append("</gdml>");
        File fs = saveXML.getSelectedFile();
        this.fileName = fs.getPath();
        if (this.fileName != null) {
            try {
                FileOutputStream fileout = new FileOutputStream(this.fileName);
                PrintWriter outf = new PrintWriter(new DataOutputStream(fileout));
                outf.println(xml.toString());
                outf.close();
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
            return;
        }
        if (this.fileName == null) {
            return;
        }
    }

    public void MaterialfileClear() {
        this.msDataModel = new GGETableModel(this.msNames, 0);
        this.msTable.setModel(this.msDataModel);
        this.mcDataModel = new GGETableModel(this.mcNames, 0);
        this.mcTable.setModel(this.mcDataModel);
    }

    void appendMC() {
        this.eic = this.et.getSelectedElements();
        if (this.eic == null) {
            return;
        }
        Object[] tmp = new Object[]{"Used", "", new RatioItem(this.eic), "", "g/cm3", "kStateUndefined", "273.15", "kelvin", "1.0", "atmosphere"};
        this.mcDataModel.addRow(tmp);
    }

    void appendMS() {
        ElementItem[] eis = this.et.getSelectedElements();
        if (eis == null) {
            return;
        }
        Object[] tmp = new Object[]{"Used", new String(eis[0].name), new Integer(eis[0].atomNum), new Double(eis[0].massNum), "", "g/cm3", "kStateUndefined", "273.15", "kelvin", "1.0", "atmosphere"};
        this.msDataModel.addRow(tmp);
    }

    void insertMS() {
        ElementItem[] eis = this.et.getSelectedElements();
        this.msRow = this.msTable.getSelectedRow();
        this.msCol = this.msTable.getSelectedColumn();
        this.msCel = this.msTable.isCellSelected(this.msRow, this.msCol);
        if (eis == null) {
            return;
        }
        if (this.msCel) {
            Object[] tmp = new Object[]{"Used", new String(eis[0].name), new Integer(eis[0].atomNum), new Double(eis[0].massNum), "", "g/cm3", "kStateUndefined", "273.15", "kelvin", "1.0", "atmosphere"};
            int msRowCount = this.msTable.getSelectedRow() + 1;
            this.msDataModel.insertRow(msRowCount, tmp);
        }
        if (!this.msCel) {
            JOptionPane opane = new JOptionPane();
            JOptionPane.showMessageDialog(this, "Choose the MaterialName", "Warning Dialog", 2);
            JDialog dialog = opane.createDialog(this, "Warning Dialog");
            try {
                Class<?> targetClass = dialog.getClass();
                Class[] parameters = new Class[]{Boolean.TYPE};
                Method method = targetClass.getDeclaredMethod("setAlwaysOnTop", parameters);
                Object targetInstance = targetClass.newInstance();
                Object[] params = new Object[]{new boolean[]{true}};
                if (System.getProperty("java.version").equals("1.5.0")) {
                    method.invoke(targetInstance, params);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    void insertMC() {
        ElementItem[] eic = this.et.getSelectedElements();
        this.mcRow = this.mcTable.getSelectedRow();
        this.mcCol = this.mcTable.getSelectedColumn();
        this.mcCel = this.mcTable.isCellSelected(this.mcRow, this.mcCol);
        if (eic == null) {
            return;
        }
        if (this.mcCel) {
            Object[] tmp = new Object[]{"Used", "", new RatioItem(eic), "", "g/cm3", "kStateUndefined", "273.15", "kelvin", "1.0", "atmosphere"};
            int mcRowCount = this.mcTable.getSelectedRow() + 1;
            this.mcDataModel.insertRow(mcRowCount, tmp);
        }
        if (!this.mcCel) {
            JOptionPane opane = new JOptionPane();
            JOptionPane.showMessageDialog(this, "Choose the MaterialName", "Warning Dialog", 2);
            JDialog dialog = opane.createDialog(this, "Warning Dialog");
            try {
                Class<?> targetClass = dialog.getClass();
                Class[] parameters = new Class[]{Boolean.TYPE};
                Method method = targetClass.getDeclaredMethod("setAlwaysOnTop", parameters);
                Object targetInstance = targetClass.newInstance();
                Object[] params = new Object[]{new boolean[]{true}};
                if (System.getProperty("java.version").equals("1.5.0")) {
                    method.invoke(targetInstance, params);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    void dellMS() {
        this.msRow = this.msTable.getSelectedRow();
        this.msCol = this.msTable.getSelectedColumn();
        this.msCel = this.msTable.isCellSelected(this.msRow, this.msCol);
        if (!this.msCel) {
            JOptionPane opane = new JOptionPane();
            JOptionPane.showMessageDialog(this, "Choose the MaterialName", "Warning Dialog", 2);
            JDialog dialog = opane.createDialog(this, "Warning Dialog");
            try {
                Class<?> targetClass = dialog.getClass();
                Class[] parameters = new Class[]{Boolean.TYPE};
                Method method = targetClass.getDeclaredMethod("setAlwaysOnTop", parameters);
                Object targetInstance = targetClass.newInstance();
                Object[] params = new Object[]{new boolean[]{true}};
                if (System.getProperty("java.version").equals("1.5.0")) {
                    method.invoke(targetInstance, params);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.msTable.dellMatCloseAct();
        } else if (this.msCel) {
            this.msTable.stopEditing();
            this.msDataModel.removeRow(this.msRow);
            this.msTable.dellMatCloseAct();
            this.repaint();
        }
    }

    void dellMC() {
        this.mcRow = this.mcTable.getSelectedRow();
        this.mcCol = this.mcTable.getSelectedColumn();
        this.mcCel = this.mcTable.isCellSelected(this.mcRow, this.mcCol);
        if (!this.mcCel) {
            JOptionPane opane = new JOptionPane();
            JOptionPane.showMessageDialog(this, "Choose the MaterialName", "Warning Dialog", 2);
            JDialog dialog = opane.createDialog(this, "Warning Dialog");
            try {
                Class<?> targetClass = dialog.getClass();
                Class[] parameters = new Class[]{Boolean.TYPE};
                Method method = targetClass.getDeclaredMethod("setAlwaysOnTop", parameters);
                Object targetInstance = targetClass.newInstance();
                Object[] params = new Object[]{new boolean[]{true}};
                if (System.getProperty("java.version").equals("1.5.0")) {
                    method.invoke(targetInstance, params);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mcTable.dellMatCloseAct();
        } else if (this.mcCel) {
            this.mcTable.stopEditing();
            this.mcDataModel.removeRow(this.mcRow);
            this.mcTable.dellMatCloseAct();
            this.repaint();
        }
    }

    public void stopEditing() {
        this.msTable.stopEditing();
        this.mcTable.stopEditing();
    }

    void setLoadData(Vector materialData) {
    }

    void scratchSelected() {
        this.mcTable.stopEditing();
    }

    void combiSelected() {
        this.msTable.stopEditing();
    }

    public void windowIconified(WindowEvent event) {
        this.et.setVisible(false);
        this.msTable.stopEditing();
        this.mcTable.stopEditing();
    }

    public void windowDeiconified(WindowEvent event) {
        this.et.setVisible(true);
    }

    public String getCPP() {
        Vector rowData;
        StringBuffer smatcpp = new StringBuffer("\n// Materials from Scratch\n\n");
        this.stopEditing();
        this.repaint();
        this.msTable.repaint();
        this.mcTable.repaint();
        Vector data = this.msDataModel.getDataVector();
        for (int i = 0; i < data.size(); ++i) {
            rowData = (Vector)data.elementAt(i);
            if (!rowData.elementAt(0).equals("Used") || !rowData.elementAt(0).equals("Used")) continue;
            smatcpp.append("G4Material* " + rowData.elementAt(1) + " = new G4Material(\"" + rowData.elementAt(1) + "\", " + rowData.elementAt(2) + ", " + rowData.elementAt(3) + "*g/mole, " + rowData.elementAt(4) + "*" + rowData.elementAt(5) + "," + rowData.elementAt(6));
            if (!rowData.elementAt(7).toString().equals("")) {
                smatcpp.append(", " + rowData.elementAt(7) + "*" + rowData.elementAt(8));
                if (!rowData.elementAt(9).toString().equals("")) {
                    smatcpp.append(", " + rowData.elementAt(9) + "*" + rowData.elementAt(10));
                }
            }
            smatcpp.append(" );\n");
        }
        StringBuffer cmatcpp = new StringBuffer("\n// Materials from Combination\n\n");
        data = this.mcDataModel.getDataVector();
        Vector<ElementItem> elements = new Vector<ElementItem>();
        for (int i = 0; i < data.size(); ++i) {
            rowData = (Vector)data.elementAt(i);
            if (!rowData.elementAt(0).equals("Used") || !rowData.elementAt(0).equals("Used")) continue;
            RatioItem rate = (RatioItem)rowData.elementAt(2);
            String name = (String)rowData.elementAt(1);
            cmatcpp.append("G4Material* " + name + " = new G4Material(\"" + name + "\",  " + rowData.elementAt(3) + "*" + rowData.elementAt(4) + ", " + rate.getLength() + ", " + rowData.elementAt(5));
            if (!rowData.elementAt(6).toString().equals("")) {
                cmatcpp.append(", " + rowData.elementAt(6) + "*" + rowData.elementAt(7));
                if (!rowData.elementAt(8).toString().equals("")) {
                    cmatcpp.append(", " + rowData.elementAt(8) + "*" + rowData.elementAt(9));
                }
            }
            cmatcpp.append(" );\n");
            cmatcpp.append(rate.getCPP(name));
            for (int j = 0; j < rate.elems.length; ++j) {
                if (elements.contains(rate.elems[j])) continue;
                elements.addElement(rate.elems[j]);
            }
        }
        StringBuffer elecpp = new StringBuffer("// Elements\n");
        for (int i = 0; i < elements.size(); ++i) {
            elecpp.append(((ElementItem)elements.elementAt(i)).getCPP());
        }
        elecpp.append(cmatcpp.toString());
        elecpp.append(smatcpp.toString());
        return elecpp.toString();
    }

    String getXML() {
        int i;
        this.stopEditing();
        StringBuffer smatxml = new StringBuffer("\n     <!--Materials from Scratch-->\n");
        this.repaint();
        this.msTable.repaint();
        this.mcTable.repaint();
        Vector data = this.msDataModel.getDataVector();
        System.out.println("##############getXML mat data size");
        System.out.println(data.size());
        StringBuffer cmatxml = new StringBuffer("\n     <!--Materials from Combination-->\n");
        data = this.mcDataModel.getDataVector();
        Vector msdata = this.msDataModel.getDataVector();
        Vector<ElementItem> elements = new Vector<ElementItem>();
        for (int i2 = 0; i2 < data.size(); ++i2) {
            Vector rowData = (Vector)data.elementAt(i2);
            if (!rowData.elementAt(0).equals("Used") || !rowData.elementAt(0).equals("Used")) continue;
            RatioItem rate = (RatioItem)rowData.elementAt(2);
            String name = (String)rowData.elementAt(1);
            cmatxml.append("     <material name=\"" + name + "\">\n" + "         <D type=\"denstiy\"" + " value=\"" + rowData.elementAt(3) + "\" " + "unit=\"" + rowData.elementAt(4) + "\"/>\n" + "         <T type=\"temperature\"" + " value=\"" + rowData.elementAt(6) + "\"" + " unit=\"" + rowData.elementAt(7) + "\"/>\n" + "         <P type=\"pascal\"" + " value=\"" + rowData.elementAt(8) + "\"" + " unit=\"" + rowData.elementAt(9) + "\"/>\n");
            cmatxml.append(rate.getXML(name));
            cmatxml.append("     </material>\n");
            for (int j = 0; j < rate.elems.length; ++j) {
                if (elements.contains(rate.elems[j])) continue;
                elements.addElement(rate.elems[j]);
            }
        }
        StringBuffer elexml = new StringBuffer("  <materials>\n");
        elexml.append("     <!--Elements-->\n");
        for (i = 0; i < elements.size(); ++i) {
            elexml.append(((ElementItem)elements.elementAt(i)).getXML());
        }
        for (i = 0; i < msdata.size(); ++i) {
            Vector msrowData = (Vector)msdata.elementAt(i);
            String state = this.getState(msrowData.elementAt(6));
            if (!msrowData.elementAt(0).equals("Used") || !msrowData.elementAt(0).equals("Used")) continue;
            smatxml.append("     <material name=\"" + msrowData.elementAt(1) + "\" formula=\"" + msrowData.elementAt(1) + "\" Z=\"" + msrowData.elementAt(2) + "\" N=\"" + msrowData.elementAt(3) + "\" state=\"" + state + "\">\n" + "      <D type=\"density\" value=\"" + msrowData.elementAt(4) + "\" unit=\"" + msrowData.elementAt(5) + "\"/>\n" + "      <atom type=\"A\" value=\"" + msrowData.elementAt(3) + "\"/>\n" + "      <T type=\"temperature\"" + " value=\"" + msrowData.elementAt(7) + "\"" + " unit=\"" + msrowData.elementAt(8) + "\"/>\n" + "      <P type=\"pascal\"" + " value=\"" + msrowData.elementAt(9) + "\"" + " unit=\"" + msrowData.elementAt(10) + "\"/>\n" + "     </material>\n");
        }
        elexml.append(cmatxml.toString());
        elexml.append(smatxml.toString());
        elexml.append("  </materials>\n");
        return elexml.toString();
    }

    String getState(Object o) {
        String state = " ";
        String s = o.toString();
        state = s.equals(MaterialItem.stateCode[0]) ? "unknown" : (s.equals(MaterialItem.stateCode[1]) ? "solid" : (s.equals(MaterialItem.stateCode[2]) ? "liquid" : (s.equals(MaterialItem.stateCode[3]) ? "gas" : "unknown")));
        return state;
    }
}

