/*
 * Decompiled with CFR 0.152.
 */
package GGE;

import GGE.AngUnitCombo;
import GGE.DoubleCellEditor;
import GGE.GGETableModel;
import GGE.LenUnitCombo;
import GGE.NameCellEditor;
import GGE.PhysicalItem;
import GGE.VolumesFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Method;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

class RepeatedRotateVolume
extends JPanel
implements ActionListener,
MouseListener {
    PhysicalItem phyItem;
    VolumesFrame volFrame;
    JTable pTable;
    private JFrame frame1;
    private JFrame frame2;
    private JMenuItem close;
    private JButton create;
    private JButton ins;
    private JButton dell;
    GGETableModel pDataModel;
    private String move;
    private String name;
    private String log;
    private String type;
    private String many;
    private String x0;
    private String y0;
    private String z0;
    private String radius;
    private String rotAxis;
    private String startAng;
    private String incAng;
    private String elem;
    private String pValue;
    private String[] tableIdent = new String[]{"Move", "pName", "pLogic", "MomType", "pMother", "pMany", "X0", "Y0", "Z0", "Radius", "lengthUnit", "RotAxis", "Phi_0", "dPhi", "angleUnit", "nElem"};
    private JComboBox matCombo;
    DefaultComboBoxModel matComboModel;

    RepeatedRotateVolume(VolumesFrame parent) {
        this.volFrame = parent;
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(2, 1));
        this.pDataModel = new GGETableModel(this.tableIdent, 0);
        this.pTable = new JTable(this.pDataModel);
        this.pTable.setAutoCreateColumnsFromModel(false);
        this.pTable.setColumnSelectionAllowed(false);
        this.pTable.setRowSelectionAllowed(true);
        this.pTable.getTableHeader().setReorderingAllowed(false);
        this.pTable.setSelectionMode(0);
        this.pTable.addMouseListener(this);
        JComboBox<String> moveCombo = new JComboBox<String>();
        moveCombo.addItem("Frame");
        moveCombo.addItem("Body");
        JComboBox<String> manyCombo = new JComboBox<String>();
        manyCombo.addItem("true");
        manyCombo.addItem("false");
        JComboBox<String> vectorCombo = new JComboBox<String>();
        vectorCombo.addItem("X");
        vectorCombo.addItem("Y");
        vectorCombo.addItem("Z");
        JComboBox<String> motherCombo = new JComboBox<String>();
        motherCombo.addItem("logical");
        motherCombo.addItem("physical");
        this.matCombo = new JComboBox();
        this.matCombo.setEditable(true);
        this.matComboModel = new DefaultComboBoxModel();
        this.matCombo.setModel(this.matComboModel);
        this.matComboModel.addElement("");
        LenUnitCombo widthCombo = new LenUnitCombo();
        AngUnitCombo angCombo = new AngUnitCombo();
        TableColumn[] columns = new TableColumn[this.tableIdent.length];
        for (int i = 0; i < this.tableIdent.length; ++i) {
            columns[i] = this.pTable.getColumn(this.tableIdent[i]);
        }
        DefaultTableCellRenderer nameCellRenderer = new DefaultTableCellRenderer();
        nameCellRenderer.setBackground(Color.pink);
        columns[0].setCellEditor(new DefaultCellEditor(moveCombo));
        columns[0].setMinWidth(40);
        columns[1].setCellEditor(new NameCellEditor());
        columns[1].setCellRenderer(nameCellRenderer);
        columns[1].setMinWidth(60);
        columns[1].setResizable(true);
        columns[2].setCellEditor(new DefaultCellEditor(this.matCombo));
        columns[2].setMinWidth(60);
        columns[3].setCellEditor(new DefaultCellEditor(motherCombo));
        columns[3].setMinWidth(60);
        columns[4].setCellEditor(new NameCellEditor());
        columns[4].setMinWidth(50);
        columns[5].setCellEditor(new DefaultCellEditor(manyCombo));
        columns[5].setMinWidth(60);
        columns[6].setCellEditor(new DoubleCellEditor());
        columns[6].setMinWidth(40);
        columns[7].setCellEditor(new DoubleCellEditor());
        columns[7].sizeWidthToFit();
        columns[7].setMinWidth(40);
        columns[8].setCellEditor(new DoubleCellEditor());
        columns[8].sizeWidthToFit();
        columns[8].setMinWidth(40);
        columns[9].setCellEditor(new DoubleCellEditor());
        columns[9].setMinWidth(45);
        columns[10].setCellEditor(new DefaultCellEditor(widthCombo));
        columns[10].setMinWidth(70);
        columns[11].setCellEditor(new DefaultCellEditor(vectorCombo));
        columns[11].setMinWidth(55);
        columns[12].setCellEditor(new DoubleCellEditor());
        columns[12].setMinWidth(50);
        columns[13].setCellEditor(new DoubleCellEditor());
        columns[13].setMinWidth(50);
        columns[14].setCellEditor(new DefaultCellEditor(angCombo));
        columns[14].setMinWidth(60);
        columns[15].setCellEditor(new NameCellEditor());
        columns[15].setMinWidth(50);
        JScrollPane scrollpane = new JScrollPane(this.pTable);
        scrollpane.setPreferredSize(new Dimension(850, 180));
        scrollpane.setMinimumSize(new Dimension(50, 25));
        JPanel panel2 = new JPanel();
        panel2.setLayout(new GridLayout(1, 3));
        this.create = new JButton(" Append ");
        panel2.add(this.create);
        this.ins = new JButton(" Insert ");
        panel2.add(this.ins);
        this.dell = new JButton(" Delete ");
        panel2.add(this.dell);
        panel.add("Center", scrollpane);
        panel.add("North", panel2);
        this.add((Component)panel, "Center");
        this.create.addActionListener(this);
        this.dell.addActionListener(this);
        this.ins.addActionListener(this);
        PhysicalItem phyItem = new PhysicalItem();
    }

    public void actionPerformed(ActionEvent ae) {
        Object o = ae.getSource();
        if (o == this.dell) {
            this.dellRepeat();
        } else if (o == this.create) {
            this.appendRepeat();
        } else if (o == this.ins) {
            this.insertRepeat();
        } else if (o == this.close) {
            this.setVisible(false);
        }
    }

    public void mousePressed(MouseEvent e) {
        JTable table = (JTable)e.getSource();
        if (table.getSelectedColumn() == 2) {
            int i;
            String[] matStr = this.volFrame.getVolumesName();
            int modelSize = this.matComboModel.getSize();
            String[] modelStr = new String[modelSize];
            for (int i2 = 0; i2 < modelSize; ++i2) {
                modelStr[i2] = this.matComboModel.getElementAt(i2).toString();
            }
            boolean exist = false;
            for (i = 0; i < matStr.length; ++i) {
                for (int j = 0; j < modelSize; ++j) {
                    if (!modelStr[j].equals(matStr[i])) continue;
                    exist = true;
                }
                if (!exist) {
                    this.matComboModel.addElement(matStr[i]);
                }
                exist = false;
            }
            modelSize = this.matComboModel.getSize();
            modelStr = new String[modelSize];
            for (i = 0; i < modelSize; ++i) {
                modelStr[i] = this.matComboModel.getElementAt(i).toString();
            }
            exist = false;
            for (int j = 0; j < modelSize; ++j) {
                for (int i3 = 0; i3 < matStr.length; ++i3) {
                    if (!modelStr[j].equals(matStr[i3])) continue;
                    exist = true;
                }
                if (!exist && !modelStr[j].equals("")) {
                    this.matComboModel.removeElementAt(j);
                }
                exist = false;
            }
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void dellRepeatCloseAct() {
        this.dell.setForeground(Color.black);
        this.repaint();
    }

    public void createRepeatCloseAct() {
        this.create.setForeground(Color.black);
        this.repaint();
    }

    public void insertRepeatCloseAct() {
        this.ins.setForeground(Color.black);
        this.repaint();
    }

    public void repeatedRotClear() {
        this.pDataModel = new GGETableModel(this.tableIdent, 0);
        this.pTable.setModel(this.pDataModel);
        this.repaint();
    }

    public void appendRepeat() {
        Object[] tmp = new Object[20];
        tmp[0] = "Body";
        tmp[1] = "";
        tmp[2] = "";
        tmp[3] = "physical";
        tmp[4] = "";
        tmp[5] = "false";
        tmp[6] = "0.0";
        tmp[7] = "0.0";
        tmp[8] = "0.0";
        tmp[9] = "0.0";
        tmp[10] = "mm";
        tmp[11] = "Z";
        tmp[12] = "0.0";
        tmp[13] = "0.0";
        tmp[14] = "deg";
        tmp[15] = "0";
        this.pDataModel.addRow(tmp);
    }

    public void insertRepeat() {
        Object[] tmp = new Object[20];
        tmp[0] = "Body";
        tmp[1] = "";
        tmp[2] = "";
        tmp[3] = "physical";
        tmp[4] = "";
        tmp[5] = "false";
        tmp[6] = "0.0";
        tmp[7] = "0.0";
        tmp[8] = "0.0";
        tmp[9] = "0.0";
        tmp[10] = "mm";
        tmp[11] = "Z";
        tmp[12] = "0.0";
        tmp[13] = "0.0";
        tmp[14] = "deg";
        tmp[15] = "0";
        if (this.pTable.getSelectedRow() == -1) {
            JOptionPane opane = new JOptionPane();
            JOptionPane.showMessageDialog(this, "Choose the pName", "Warning Dialog", 2);
            JDialog dialog = opane.createDialog(this, "Warning Dialog");
            try {
                Class<?> targetClass = dialog.getClass();
                Class[] parameters = new Class[]{Boolean.TYPE};
                Method method = targetClass.getDeclaredMethod("setAlwaysOnTop", parameters);
                Object targetInstance = targetClass.newInstance();
                Object[] params = new Object[]{new boolean[]{true}};
                if (System.getProperty("java.version").equals("1.5.0")) {
                    method.invoke(targetInstance, params);
                }
            }
            catch (Exception e) {}
        } else {
            int pRowCount = this.pTable.getSelectedRow() + 1;
            this.pDataModel.insertRow(pRowCount, tmp);
        }
    }

    public void dellRepeat() {
        if (this.pTable.getSelectedRow() == -1) {
            JOptionPane opane = new JOptionPane();
            JOptionPane.showMessageDialog(this, "Choose the pName", "Warning Dialog", 2);
            JDialog dialog = opane.createDialog(this, "Warning Dialog");
            try {
                Class<?> targetClass = dialog.getClass();
                Class[] parameters = new Class[]{Boolean.TYPE};
                Method method = targetClass.getDeclaredMethod("setAlwaysOnTop", parameters);
                Object targetInstance = targetClass.newInstance();
                Object[] params = new Object[]{new boolean[]{true}};
                if (System.getProperty("java.version").equals("1.5.0")) {
                    method.invoke(targetInstance, params);
                }
            }
            catch (Exception exception) {}
        } else {
            this.stopEditing();
            this.pDataModel.removeRow(this.pTable.getSelectedRow());
            this.dell.setForeground(Color.black);
            this.repaint();
        }
    }

    void stopEditing() {
        int row = 0;
        int column = 0;
        row = this.pTable.getEditingRow();
        if (row != -1 && (column = this.pTable.getEditingColumn()) != -1) {
            TableCellEditor cellEditor = this.pTable.getCellEditor(row, column);
            cellEditor.stopCellEditing();
        }
    }

    String getCPP() {
        StringBuffer cpp = new StringBuffer("\n// Repeated Placement AxialSymmetoric\n\n");
        if (this.pDataModel.getRowCount() == 0) {
            return cpp.toString();
        }
        for (int i = 0; i < this.pDataModel.getRowCount(); ++i) {
            String pMother = this.pDataModel.getValueAt(i, 4).toString();
            this.move = this.pDataModel.getValueAt(i, 0).toString();
            this.name = this.pDataModel.getValueAt(i, 1).toString();
            this.log = this.pDataModel.getValueAt(i, 2).toString();
            this.type = this.pDataModel.getValueAt(i, 3).toString();
            this.many = this.pDataModel.getValueAt(i, 5).toString();
            this.x0 = this.pDataModel.getValueAt(i, 6).toString() + "*" + this.pDataModel.getValueAt(i, 10).toString();
            this.y0 = this.pDataModel.getValueAt(i, 7).toString() + "*" + this.pDataModel.getValueAt(i, 10).toString();
            this.z0 = this.pDataModel.getValueAt(i, 8).toString() + "*" + this.pDataModel.getValueAt(i, 10).toString();
            this.radius = this.pDataModel.getValueAt(i, 9).toString() + "*" + this.pDataModel.getValueAt(i, 10).toString();
            this.rotAxis = this.pDataModel.getValueAt(i, 11).toString();
            this.startAng = this.pDataModel.getValueAt(i, 12).toString() + "*" + this.pDataModel.getValueAt(i, 14).toString();
            this.incAng = this.pDataModel.getValueAt(i, 13).toString() + "*" + this.pDataModel.getValueAt(i, 14).toString();
            this.elem = this.pDataModel.getValueAt(i, 15).toString();
            if (this.move.equals("Body")) {
                cpp.append("// Active Rotation of Bodies\n");
                cpp.append("G4int copy" + this.name + ";\ncopy" + this.name + "=0;\n");
                cpp.append("G4RotationMatrix rotationMatrix" + this.name + ";");
                cpp.append("G4double start" + this.name + " = " + this.startAng + ";\n");
                cpp.append("G4double inc" + this.name + " = " + this.incAng + ";\n");
                cpp.append("rotationMatrix" + this.name + ".rotate" + this.rotAxis + "(start" + this.name + ");\n");
                cpp.append("G4double x0" + this.name + " = " + this.x0 + ";\n");
                cpp.append("G4double y0" + this.name + " = " + this.y0 + ";\n");
                cpp.append("G4double z0" + this.name + " = " + this.z0 + ";\n");
                cpp.append("G4double radius" + this.name + " = " + this.radius + ";\n\n");
                cpp.append("for (G4int index" + this.name + "=1; index" + this.name + "<=" + this.elem + "; index" + this.name + "++){\n");
                cpp.append("  G4double trans" + this.name + " = start" + this.name + "+" + "inc" + this.name + "*(index" + this.name + "-1);\n\n");
                cpp.append("  G4double x" + this.name + ", y" + this.name + ", z" + this.name + ";\n");
                if (this.rotAxis.equals("X")) {
                    cpp.append("  x" + this.name + " = x0" + this.name + ";\n");
                    cpp.append("  y" + this.name + " = y0" + this.name + " + radius" + this.name + " * cos(trans" + this.name + ");\n");
                    cpp.append("  z" + this.name + " = z0" + this.name + " + radius" + this.name + " * sin(trans" + this.name + ");\n\n");
                } else if (this.rotAxis.equals("Y")) {
                    cpp.append("  x" + this.name + " = x0" + this.name + " + radius" + this.name + " * sin(trans" + this.name + ");\n");
                    cpp.append("  y" + this.name + " = y0" + this.name + ";\n");
                    cpp.append("  z" + this.name + " = z0" + this.name + " + radius" + this.name + " * cos(trans" + this.name + ");\n");
                } else if (this.rotAxis.equals("Z")) {
                    cpp.append("  x" + this.name + " = x0" + this.name + " + radius" + this.name + " * cos(trans" + this.name + ");\n");
                    cpp.append("  y" + this.name + " = y0" + this.name + " + radius" + this.name + " * sin(trans" + this.name + ");\n");
                    cpp.append("  z" + this.name + " = z0" + this.name + ";\n");
                }
                cpp.append("  G4VPhysicalVolume * " + this.name + " = new G4PVPlacement(G4Transform3D(rotationMatrix" + this.name + ",\t//rotate\n" + "\t\t G4ThreeVector(" + "x" + this.name + ", y" + this.name + ", z" + this.name + ")),\n");
                if (this.type.equals("physical")) {
                    cpp.append("\t\t \"" + this.name + "\",   //its name \n" + "\t\t " + this.log + ",         //its logical volume\n");
                } else if (this.type.equals("logical")) {
                    cpp.append("\t\t " + this.log + ",\t//its logical volume\n" + "\t\t \"" + this.name + "\",   //its name \n");
                }
                cpp.append("\t\t " + pMother + ",            //its mother volume\n" + "\t\t " + this.many + ",             //no boolean operation\n" + "\t\t copy" + this.name + "++);      //copy number \n" + "  rotationMatrix" + this.name + ".rotate" + this.rotAxis + "(inc" + this.name + ");\n" + "}\n\n");
                continue;
            }
            if (this.move.equals("Frame")) {
                cpp.append("// Rotation of Frames\n\n");
                cpp.append("G4int copy" + this.name + ";\ncopy" + this.name + "=0;\n");
                cpp.append("G4RotationMatrix rotationMatrix" + this.name + "; //rotation matrix \n");
                cpp.append("G4double start" + this.name + " = " + this.startAng + ";  // starting angle\n");
                cpp.append("G4double inc" + this.name + " = " + this.incAng + ";  // incremental angle\n");
                cpp.append("rotationMatrix" + this.name + ".rotate" + this.rotAxis + "(start" + this.name + ");  //rotate to the starting angle\n");
                cpp.append("G4double x0" + this.name + " = " + this.x0 + ";  //X0 position\n");
                cpp.append("G4double y0" + this.name + " = " + this.y0 + ";  //Y0 position\n");
                cpp.append("G4double z0" + this.name + " = " + this.z0 + ";  //Z0 position\n");
                cpp.append("G4double radius" + this.name + " = " + this.radius + ";  //radius\n\n");
                cpp.append("for (G4int index" + this.name + "=1; index" + this.name + "<=" + this.elem + "; index" + this.name + "++){  // loop for incremental rotation\n");
                cpp.append("  G4double trans" + this.name + " = -(start" + this.name + ") + " + "-(inc" + this.name + ")*(index" + this.name + "-1);  // angle for every increment\n\n");
                cpp.append("  G4double x" + this.name + ", y" + this.name + ", z" + this.name + ";  // coordinates for every incremental rotation\n");
                if (this.rotAxis.equals("X")) {
                    cpp.append("  x" + this.name + " = x0" + this.name + ";  // rotation around the X axisi\n");
                    cpp.append("  y" + this.name + " = y0" + this.name + " + radius" + this.name + " * cos(trans" + this.name + ");\n");
                    cpp.append("  z" + this.name + " = z0" + this.name + " + radius" + this.name + " * sin(trans" + this.name + ");\n\n");
                } else if (this.rotAxis.equals("Y")) {
                    cpp.append("  x" + this.name + " = x0" + this.name + " + radius" + this.name + " * sin(trans" + this.name + ");  // rotation around the Y axis\n");
                    cpp.append("  y" + this.name + " = y0" + this.name + ";\n");
                    cpp.append("  z" + this.name + " = z0" + this.name + " + radius" + this.name + " * cos(trans" + this.name + ");\n");
                } else if (this.rotAxis.equals("Z")) {
                    cpp.append("  x" + this.name + " = x0" + this.name + " + radius" + this.name + " * cos(trans" + this.name + ");  // rotation around the Z axis\n");
                    cpp.append("  y" + this.name + " = y0" + this.name + " + radius" + this.name + " * sin(trans" + this.name + ");\n");
                    cpp.append("  z" + this.name + " = z0" + this.name + ";\n");
                }
                cpp.append("  G4VPhysicalVolume * " + this.name + " = new G4PVPlacement( new G4RotationMatrix(rotationMatrix" + this.name + "),\t//rotate\n" + "\t\t G4ThreeVector(" + "x" + this.name + ", y" + this.name + ", z" + this.name + "),  // translate\n");
                if (this.type.equals("physical")) {
                    cpp.append("\t\t \"" + this.name + "\",   //mother is physical. its name \n" + "\t\t " + this.log + ",         //its logical volume\n");
                } else if (this.type.equals("logical")) {
                    cpp.append("\t\t " + this.log + ",\t// mother is logical. Current logical volume\n" + "\t\t \"" + this.name + "\",   //its name \n");
                }
                cpp.append("\t\t " + pMother + ",            //its mother volume\n" + "\t\t " + this.many + ",             //no boolean operation\n" + "\t\t copy" + this.name + "++);      //copy number \n" + "  rotationMatrix" + this.name + ".rotate" + this.rotAxis + "(inc" + this.name + ");\n" + "}\n\n");
                continue;
            }
            cpp.append("// No Rotation \n\n");
        }
        return cpp.toString();
    }
}

