/*
 * Decompiled with CFR 0.152.
 */
package GGE;

import GGE.BooleanCombo;
import GGE.VisAtbItem;
import GGE.VisMethodPanel;
import GGE.VolumesFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;

class VisAtbDialog
extends JDialog
implements ActionListener {
    boolean isCanceled;
    VisMethodPanel[] atb;
    private JButton ok;
    private JButton cancel;
    JTextField nameField;
    JColorChooser colorChooser;
    private VolumesFrame parent;
    private JFrame frame1;

    public VisAtbDialog(VolumesFrame parent) {
        this.parent = parent;
        this.atb = new VisMethodPanel[5];
        this.getContentPane().setLayout(new BorderLayout(3, 0));
        this.colorChooser = new JColorChooser();
        this.getContentPane().add("East", this.colorChooser);
        JPanel p1 = new JPanel();
        p1.setLayout(new BorderLayout(1, 8));
        p1.add("West", new JLabel("Name"));
        this.nameField = new JTextField();
        p1.add("Center", this.nameField);
        JComboBox<String> lineStyle = new JComboBox<String>();
        lineStyle.addItem("unbroken");
        lineStyle.addItem("dashed");
        lineStyle.addItem("dotted");
        JPanel c = new JPanel();
        c.setLayout(new BoxLayout(c, 1));
        c.setBorder(new LineBorder(Color.darkGray, 1));
        this.atb[0] = new VisMethodPanel(VisAtbItem.atbMethodName[0], new BooleanCombo());
        c.add(this.atb[0]);
        this.atb[1] = new VisMethodPanel(VisAtbItem.atbMethodName[1], lineStyle);
        c.add(this.atb[1]);
        this.atb[2] = new VisMethodPanel(VisAtbItem.atbMethodName[2], new JTextField());
        c.add(this.atb[2]);
        this.atb[3] = new VisMethodPanel(VisAtbItem.atbMethodName[3], new BooleanCombo());
        c.add(this.atb[3]);
        this.atb[4] = new VisMethodPanel(VisAtbItem.atbMethodName[4], new BooleanCombo());
        c.add(this.atb[4]);
        p1.add("South", c);
        JPanel p2 = new JPanel(new BorderLayout());
        p2.add("North", p1);
        JPanel p3 = new JPanel(new BorderLayout(3, 0));
        this.ok = new JButton("OK");
        p3.add("Center", this.ok);
        this.cancel = new JButton("Cancel");
        p3.add("East", this.cancel);
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        p2.add("South", p3);
        this.getContentPane().add("Center", p2);
        this.pack();
        this.setResizable(false);
    }

    VisAtbItem getNewAtb() {
        this.setVisible(true);
        if (this.isCanceled) {
            return null;
        }
        return this.getValues();
    }

    VisAtbItem getChangedAtb(VisAtbItem visItem) {
        this.setValues(visItem);
        this.setVisible(true);
        if (this.isCanceled) {
            return null;
        }
        return this.getValues();
    }

    private void setValues(VisAtbItem visItem) {
        this.colorChooser.setColor(visItem.color);
        this.nameField.setText(visItem.name);
        for (int i = 0; i < 5; ++i) {
            this.atb[i].setAtbState(visItem.atbsIsValid[i]);
            this.atb[i].setValues(visItem.atbsValue[i]);
        }
    }

    private VisAtbItem getValues() {
        VisAtbItem newVisItem = new VisAtbItem();
        newVisItem.name = this.nameField.getText().trim();
        if (newVisItem.name.equals("")) {
            return null;
        }
        newVisItem.color = this.colorChooser.getColor();
        for (int i = 0; i < 5; ++i) {
            newVisItem.atbsIsValid[i] = this.atb[i].getAtbState();
            newVisItem.atbsValue[i] = this.atb[i].toString();
        }
        return newVisItem;
    }

    public void actionPerformed(ActionEvent ae) {
        Object ob = ae.getSource();
        if (ob == this.cancel) {
            this.isCanceled = ob == this.cancel;
            this.setVisible(false);
            this.parent.visPanel.visCloseAct();
        } else if (ob == this.ok) {
            this.isCanceled = ob != this.ok;
            System.out.println(this.getValues());
            if (this.getValues() == null) {
                JOptionPane opane = new JOptionPane();
                JOptionPane.showMessageDialog(this, "No given name for color", "Warning Dialog", 2);
                JDialog dialog = opane.createDialog(this, "Warning Dialog");
                try {
                    Class<?> targetClass = dialog.getClass();
                    Class[] parameters = new Class[]{Boolean.TYPE};
                    Method method = targetClass.getDeclaredMethod("setAlwaysOnTop", parameters);
                    Object targetInstance = targetClass.newInstance();
                    Object[] params = new Object[]{new boolean[]{true}};
                    if (System.getProperty("java.version").equals("1.5.0")) {
                        method.invoke(targetInstance, params);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                return;
            }
            this.parent.visPanel.listModel.addElement(this.getNewAtb());
            this.nameField.setText("");
        }
    }
}

