/*
 * Decompiled with CFR 0.152.
 */
package GGE;

import GGE.GGEListModel;
import GGE.VisAtbDialog;
import GGE.VisAtbItem;
import GGE.VolumesFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class VisAtbPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    private JButton addVis;
    private JButton delVis;
    JList visList;
    VisAtbItem visItem;
    public GGEListModel listModel;
    private VisAtbDialog visDialog;

    VisAtbPanel(VolumesFrame parent) {
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder(LineBorder.createBlackLineBorder(), " VisAttrib "));
        this.listModel = new GGEListModel();
        this.visList = new JList(this.listModel);
        JPanel buttons = new JPanel(new BorderLayout());
        this.addVis = new JButton(" Create ");
        buttons.add("Center", this.addVis);
        this.delVis = new JButton("Del");
        buttons.add("East", this.delVis);
        this.delVis.setEnabled(false);
        this.add("North", buttons);
        this.visDialog = new VisAtbDialog(parent);
        this.addVis.addActionListener(this);
        this.delVis.addActionListener(this);
        this.visList.addListSelectionListener(this);
        this.visList.addMouseListener(new editVis());
        JScrollPane scrollpane = new JScrollPane(this.visList);
        scrollpane.setPreferredSize(new Dimension(80, 270));
        scrollpane.setMinimumSize(new Dimension(50, 30));
        this.add("Center", scrollpane);
    }

    VisAtbItem getSelectedVis() {
        return (VisAtbItem)this.visList.getSelectedValue();
    }

    String[] getColorName() {
        int size = this.listModel.getSize();
        String[] colName = new String[size];
        for (int i = 0; i < size; ++i) {
            colName[i] = this.listModel.elementAt(i).toString();
        }
        return colName;
    }

    public void actionPerformed(ActionEvent ae) {
        Object o = ae.getSource();
        if (o == this.addVis) {
            this.addVis.setForeground(Color.red);
            VisAtbItem visItem = this.visDialog.getNewAtb();
            if (visItem == null) {
                return;
            }
            this.listModel.addElement(visItem);
            this.addVis.setForeground(Color.black);
            this.repaint();
        } else if (o == this.delVis) {
            this.delVis.setForeground(Color.red);
            int index = this.visList.getSelectedIndex();
            if (index < 0) {
                return;
            }
            this.listModel.removeElementAt(index);
        }
    }

    public void visCloseAct() {
        this.addVis.setForeground(Color.black);
    }

    public void visClear() {
        this.listModel = new GGEListModel();
        this.visList.setModel(this.listModel);
        this.repaint();
    }

    public void valueChanged(ListSelectionEvent le) {
        if (le.getValueIsAdjusting()) {
            return;
        }
        this.delVis.setEnabled(this.visList.getSelectedIndex() >= 0);
    }

    public String getCPP() {
        StringBuffer cpp = new StringBuffer("\n// Visualization attributes\n\n");
        if (this.listModel.getSize() == 0) {
            return cpp.toString();
        }
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            VisAtbItem vObject = (VisAtbItem)this.listModel.elementAt(i);
            cpp.append("\nG4VisAttributes * ");
            cpp.append(vObject.name + "= new G4VisAttributes( G4Colour(");
            cpp.append(vObject.color.getRed() + "/255. ," + vObject.color.getGreen() + "/255. ," + vObject.color.getBlue() + "/255. ));\n");
            for (int j = 0; j < vObject.atbsIsValid.length; ++j) {
                if (!vObject.atbsIsValid[j]) continue;
                cpp.append(vObject.name + "->Set" + VisAtbItem.atbMethodName[j] + "(" + vObject.atbsValue[j] + ");\n");
            }
        }
        return cpp.toString();
    }

    String getXML() {
        StringBuffer xml = new StringBuffer("\n  <!-Visualization attributes->\n\n");
        if (this.listModel.getSize() == 0) {
            return xml.toString();
        }
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            VisAtbItem vObject = (VisAtbItem)this.listModel.elementAt(i);
            xml.append("\nG4VisAttributes * ");
            xml.append(vObject.name + "= new G4VisAttributes( G4Colour(");
            xml.append(vObject.color.getRed() + "/255. ," + vObject.color.getGreen() + "/255. ," + vObject.color.getBlue() + "/255. ));\n");
            for (int j = 0; j < vObject.atbsIsValid.length; ++j) {
                if (!vObject.atbsIsValid[j]) continue;
                xml.append(vObject.name + "->Set" + VisAtbItem.atbMethodName[j] + "(" + vObject.atbsValue[j] + ");\n");
            }
        }
        return xml.toString();
    }

    class editVis
    extends MouseAdapter {
        editVis() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                int index = VisAtbPanel.this.visList.locationToIndex(e.getPoint());
                if (index < 0) {
                    return;
                }
                VisAtbItem newItem = VisAtbPanel.this.visDialog.getChangedAtb((VisAtbItem)VisAtbPanel.this.listModel.getElementAt(index));
                if (newItem == null) {
                    return;
                }
                VisAtbPanel.this.listModel.setElementAt(newItem, index);
            }
        }
    }
}

