/*
 * Decompiled with CFR 0.152.
 */
package GGE;

import GGE.AbstractGGEPanel;
import GGE.AxiParameFrame;
import GGE.BREPItem;
import GGE.CSGItem;
import GGE.DAWNSourceFrame;
import GGE.ElementItem;
import GGE.ElementsTable;
import GGE.GGETableModel;
import GGE.LogicalPanel;
import GGE.MaterialFrame;
import GGE.MaterialItem;
import GGE.PhysicalPanel;
import GGE.RatioItem;
import GGE.RepeatedRotateVolume;
import GGE.RepeatedVolume;
import GGE.ReplicasFrame;
import GGE.SingleVolume;
import GGE.SlicingAxialFrame;
import GGE.SolidCellEditor;
import GGE.SolidItem;
import GGE.SourceFrame;
import GGE.TransParameFrame;
import GGE.VisAtbPanel;
import GPE.ExampleFileFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VolumesFrame
extends AbstractGGEPanel
implements ActionListener {
    public MaterialFrame matFrame;
    Date today = new Date();
    public SourceFrame sf;
    public SourceFrame includesf;
    public SourceFrame xmlf;
    DAWNSourceFrame dawnSFrame;
    public LogicalPanel logPanel;
    public VisAtbPanel visPanel;
    PhysicalPanel phyPanel;
    ReplicasFrame repFrame;
    RepeatedVolume repeatVol;
    RepeatedRotateVolume repeatRotVol;
    SingleVolume singleVol;
    SlicingAxialFrame slicingFrame;
    TransParameFrame transParameFrame;
    AxiParameFrame axiParameFrame;
    ElementsTable et;
    private JMenuItem load;
    private JMenuItem append;
    private JMenuItem save;
    private JMenuItem clear;
    private JMenuItem exit;
    private JMenuItem loadXML;
    private JMenuItem saveXML;
    private JMenuItem CPP;
    private JMenuItem CHH;
    private JMenuItem closeCPP;
    private JMenuItem XML;
    private JMenuItem closeXML;
    private JMenuItem tOpen;
    private JMenuItem tClose;
    JLabel label;
    public JTextField classNameField;
    private JFileChooser loadGGE;
    private JFileChooser saveGGE;
    private String fileName;
    static String fileDir;
    public String workdirpath = ".";

    public VolumesFrame() {
        this.setLayout(new FlowLayout(0, 15, 5));
        this.matFrame = new MaterialFrame();
        this.sf = new SourceFrame();
        this.includesf = new SourceFrame();
        this.xmlf = new SourceFrame();
        this.dawnSFrame = new DAWNSourceFrame();
        this.repFrame = new ReplicasFrame(this);
        this.slicingFrame = new SlicingAxialFrame(this);
        this.repeatVol = new RepeatedVolume(this);
        this.repeatRotVol = new RepeatedRotateVolume(this);
        this.singleVol = new SingleVolume(this);
        this.transParameFrame = new TransParameFrame();
        this.axiParameFrame = new AxiParameFrame();
        this.logPanel = new LogicalPanel(this);
        this.visPanel = new VisAtbPanel(this);
        this.phyPanel = new PhysicalPanel(this);
        JPanel panel1 = new JPanel(new BorderLayout());
        JTabbedPane panel2 = new JTabbedPane();
        panel1.add("Center", this.logPanel);
        panel1.add("East", this.visPanel);
        ImageIcon icon = new ImageIcon("yellow-ball.gif");
        panel2.addTab("Single", icon, this.singleVol);
        panel2.addTab("RepeatTrans", icon, this.repeatVol);
        panel2.addTab("RepeatRotate", icon, this.repeatRotVol);
        panel2.addTab("ReplicaTrans", icon, this.repFrame);
        panel2.addTab("ReplicaAxial", icon, this.slicingFrame);
        panel2.setSize(200, 450);
        JSplitPane splitPane = new JSplitPane(0, true, panel1, panel2);
        splitPane.setDividerLocation(310);
        JPanel panel3 = new JPanel();
        panel3.add(this.createMenubar());
        panel3.add(this.makeClassNamePanel());
        this.add((Component)panel3, "North");
        this.add((Component)splitPane, "Center");
        this.setSize(700, 580);
        this.setVisible(true);
    }

    private JMenuBar createMenubar() {
        JMenuBar mb = new JMenuBar();
        JMenu file = new JMenu("File");
        file.setForeground(Color.cyan);
        this.load = new JMenuItem("Load a Volumes File");
        file.add(this.load);
        this.loadXML = new JMenuItem("Load a XML Volumes File");
        file.add(this.loadXML);
        this.append = new JMenuItem("Append a Volumes File");
        file.add(this.append);
        this.save = new JMenuItem("Save Volumes");
        file.add(this.save);
        this.saveXML = new JMenuItem("Save XML Volumes");
        file.add(this.saveXML);
        this.clear = new JMenuItem("Clear Volumes");
        file.add(this.clear);
        file.addSeparator();
        this.load.addActionListener(this);
        this.loadXML.addActionListener(this);
        this.append.addActionListener(this);
        this.save.addActionListener(this);
        this.saveXML.addActionListener(this);
        this.clear.addActionListener(this);
        mb.add(file);
        JMenu mkCode = new JMenu("MakeSource");
        mkCode.setForeground(Color.cyan);
        this.CPP = new JMenuItem("Make C++ code");
        mkCode.add(this.CPP);
        this.CHH = new JMenuItem("Make Header File");
        mkCode.add(this.CHH);
        this.XML = new JMenuItem("Make XML code File");
        mkCode.add(this.XML);
        this.CPP.addActionListener(this);
        this.CHH.addActionListener(this);
        this.XML.addActionListener(this);
        mb.add(mkCode);
        return mb;
    }

    public JPanel makeClassNamePanel() {
        JLabel textFieldTitle = new JLabel("ClassName", 0);
        textFieldTitle.setFont(new Font("Serif", 1, 12));
        Dimension titlesize = textFieldTitle.getPreferredSize();
        textFieldTitle.setSize(titlesize);
        JPanel textFieldPanel = new JPanel();
        textFieldPanel.setSize(640, 60);
        textFieldPanel.setLayout(new FlowLayout(0, 15, 2));
        textFieldPanel.add(textFieldTitle);
        this.classNameField = new JTextField(20);
        textFieldPanel.add(this.classNameField);
        return textFieldPanel;
    }

    public void actionPerformed(ActionEvent ae) {
        Object o = ae.getSource();
        if (o == this.load) {
            this.GGEfileLoad();
        }
        if (o == this.loadXML) {
            this.XMLfileLoad();
        }
        if (o == this.append) {
            this.GGEfileAppend();
        }
        if (o == this.save) {
            this.GGEfileSave();
        }
        if (o == this.saveXML) {
            this.XMLfileSave();
        }
        if (o == this.clear) {
            this.volClear();
        }
        if (o == this.exit) {
            System.exit(0);
        }
        if (o == this.CPP && this.makeCPP() != "") {
            this.sf.setVisible(true);
            this.sf.editor.setText(this.makeCPP());
        }
        if (o == this.XML && this.makeXML() != "") {
            this.xmlf.setVisible(true);
            this.xmlf.editor.setText(this.makeXML());
        }
        if (o == this.CHH && this.makeCHH() != "") {
            this.includesf.setVisible(true);
            this.includesf.editor.setText(this.makeCHH());
        }
    }

    public void singleOpen() {
        this.singleVol.setVisible(true);
    }

    public void replicaOpen() {
        this.repFrame.setVisible(true);
    }

    public void slicingOpen() {
        this.slicingFrame.setVisible(true);
    }

    public void repeatOpen() {
        this.repeatVol.setVisible(true);
    }

    public void repeatRotateOpen() {
        this.repeatRotVol.setVisible(true);
    }

    public void transParameOpen() {
        this.transParameFrame.setVisible(true);
    }

    public void axiParameOpen() {
        this.axiParameFrame.setVisible(true);
    }

    String makeCHH() {
        String myName = this.classNameField.getText();
        StringTokenizer st = new StringTokenizer(myName);
        if (!st.hasMoreTokens()) {
            JOptionPane opane = new JOptionPane();
            JOptionPane.showMessageDialog(this, "Type in your ClassName", "Warning Dialog", 2);
            JDialog dialog = opane.createDialog(this, "Warning Dialog");
            try {
                Class<?> targetClass = dialog.getClass();
                Class[] parameters = new Class[]{Boolean.TYPE};
                Method method = targetClass.getDeclaredMethod("setAlwaysOnTop", parameters);
                Object targetInstance = targetClass.newInstance();
                Object[] params = new Object[]{new boolean[]{true}};
                if (System.getProperty("java.version").equals("1.5.0")) {
                    method.invoke(targetInstance, params);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return "";
        }
        StringBuffer smatchh = new StringBuffer("\n// Geometry Header File \n");
        smatchh.append("//   " + myName + ".hh generated by Geant4 Geometry Editor at " + this.today.toString() + "  \n\n");
        smatchh.append("\n#ifndef " + myName + "_h\n");
        smatchh.append("#define  " + myName + "_h  1\n\n");
        smatchh.append("class G4VPhysicalVolume;\n");
        smatchh.append("#include \"G4VUserDetectorConstruction.hh\"\n");
        smatchh.append("class  " + myName + ":  public G4VUserDetectorConstruction\n");
        smatchh.append("   {");
        smatchh.append("      public:\n");
        smatchh.append("      " + myName + "();\n");
        smatchh.append("     ~" + myName + "();\n\n");
        smatchh.append("      public:\n");
        smatchh.append("      G4VPhysicalVolume* Construct();\n");
        smatchh.append("  };\n");
        smatchh.append("#endif\n");
        return smatchh.toString();
    }

    String makeCPP() {
        StringBuffer smatcpp = new StringBuffer();
        String myName = this.classNameField.getText();
        StringTokenizer token = new StringTokenizer(myName);
        if (!token.hasMoreTokens()) {
            JOptionPane opane = new JOptionPane();
            JOptionPane.showMessageDialog(this, "Type in your ClassName", "Warning Dialog", 2);
            JDialog dialog = opane.createDialog(this, "Warning Dialog");
            try {
                Class<?> targetClass = dialog.getClass();
                Class[] parameters = new Class[]{Boolean.TYPE};
                Method method = targetClass.getDeclaredMethod("setAlwaysOnTop", parameters);
                Object targetInstance = targetClass.newInstance();
                Object[] params = new Object[]{new boolean[]{true}};
                if (System.getProperty("java.version").equals("1.5.0")) {
                    method.invoke(targetInstance, params);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return "";
        }
        smatcpp.append("//***** Generated by Geant4 Geometry Editor at  " + this.today.toString() + " *****\n\n");
        smatcpp.append(this.headerCPP());
        smatcpp.append(this.matFrame.getCPP());
        smatcpp.append(this.visPanel.getCPP());
        smatcpp.append(this.logPanel.getCPP());
        smatcpp.append(this.phyPanel.getCPP());
        smatcpp.append(this.singleVol.getCPP());
        smatcpp.append(this.repeatVol.getCPP());
        smatcpp.append(this.repeatRotVol.getCPP());
        smatcpp.append(this.repFrame.getCPP());
        smatcpp.append(this.slicingFrame.getCPP());
        smatcpp.append(this.getCPP());
        return smatcpp.toString();
    }

    String makeXML() {
        StringBuffer smatxml = new StringBuffer();
        StringBuffer logxml = new StringBuffer(this.logPanel.getXML());
        String myName = this.classNameField.getText();
        StringTokenizer st = new StringTokenizer(myName);
        String noSldName = this.logPanel.noSldName();
        int option = 0;
        if (!st.hasMoreTokens()) {
            JOptionPane opane = new JOptionPane();
            JOptionPane.showMessageDialog(this, "Type in your ClassName", "Warning Dialog", 2);
            JDialog dialog = opane.createDialog(this, "Warning Dialog");
            try {
                Class<?> targetClass = dialog.getClass();
                Class[] parameters = new Class[]{Boolean.TYPE};
                Method method = targetClass.getDeclaredMethod("setAlwaysOnTop", parameters);
                Object targetInstance = targetClass.newInstance();
                Object[] params = new Object[]{new boolean[]{true}};
                if (System.getProperty("java.version").equals("1.5.0")) {
                    method.invoke(targetInstance, params);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return "";
        }
        if (this.logPanel.isSaveOk()) {
            Object[] options = new Object[]{"OK", "Cancel"};
            JOptionPane opane = new JOptionPane();
            option = JOptionPane.showOptionDialog(this, "Can not create \n" + noSldName + " in GDML,\nChoose OK to save", "Warning", -1, 2, null, options, options[0]);
            JDialog dialog = opane.createDialog(this, "Warning Dialog");
            try {
                Class<?> targetClass = dialog.getClass();
                Class[] parameters = new Class[]{Boolean.TYPE};
                Method method = targetClass.getDeclaredMethod("setAlwaysOnTop", parameters);
                Object targetInstance = targetClass.newInstance();
                Object[] params = new Object[]{new boolean[]{true}};
                if (System.getProperty("java.version").equals("1.5.0")) {
                    method.invoke(targetInstance, params);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (option == 0) {
            smatxml.append(this.headerXML());
            smatxml.append(this.matFrame.getXML());
            smatxml.append(logxml);
            smatxml.append("</gdml>");
            return smatxml.toString();
        }
        return "";
    }

    private synchronized void resume() {
        this.notify();
    }

    String getCPP() {
        StringBuffer cpp = new StringBuffer("\n// return the physical World\n\n");
        if (this.singleVol.singleTable.getRowCount() == 0) {
            return cpp.toString();
        }
        for (int i = 0; i < this.singleVol.singleDataModel.getRowCount(); ++i) {
            String mother = (String)this.singleVol.singleDataModel.getValueAt(i, 3);
            if (!mother.equals("NULL") || !mother.equals("NULL")) continue;
            cpp.append("\n return " + this.singleVol.singleDataModel.getValueAt(i, 1) + ";\n}");
        }
        return cpp.toString();
    }

    String getXML() {
        StringBuffer xml = new StringBuffer("\n// Physical world \n\n");
        if (this.singleVol.singleTable.getRowCount() == 0) {
            return xml.toString();
        }
        for (int i = 0; i < this.singleVol.singleDataModel.getRowCount(); ++i) {
            String mother = (String)this.singleVol.singleDataModel.getValueAt(i, 3);
            if (!mother.equals("NULL") || !mother.equals("NULL")) continue;
            xml.append("\n <physical" + this.singleVol.singleDataModel.getValueAt(i, 1) + "/physical\n}");
        }
        return xml.toString();
    }

    String headerXML() {
        String xmls = new String("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<gdml xmlns:gdml=\"http://cern.ch/2001/Schemas/GDML\"\n     xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n     xsi:noNamespaceSchemaLocation=\"../schema/gdml_1.0.xsd\">\n  <define>\n    <constant name=\"HALFPI\" value=\"pi/2.\"/>\n    <constant name=\"PI\" value=\"1.*pi\"/>\n    <constant name=\"TWOPI\" value=\"2.*pi\"/>\n    <position name=\"center\"/>\n    <rotation name=\"identity\"/>\n    <position name=\"shiftbyx\" x=\"20.0\"/>\n    <rotation name=\"rotatebyx\" x=\"HALFPI\"/>\n    <rotation name=\"rotatebyall\" x=\"HALFPI\" y=\"PI\" z=\"TWOPI\"/>\n   </define>\n\n");
        return xmls;
    }

    String headerCPP() {
        String myName = this.classNameField.getText();
        StringBuffer cpp = new StringBuffer("//------HeaderFile-\n ");
        cpp.append("#include \"" + myName + ".hh\"\n\n");
        cpp.append("#include \"G4UnitsTable.hh\"\n\n");
        cpp.append("#include \"G4VUserDetectorConstruction.hh\"\n\n");
        cpp.append("#include \"globals.hh\"\n");
        cpp.append("#include \"G4Material.hh\"\n");
        cpp.append("#include \"G4MaterialTable.hh\"\n");
        cpp.append("#include \"G4Element.hh\"\n");
        cpp.append("#include \"G4ElementTable.hh\"\n");
        int a = 0;
        int b = 0;
        int c = 0;
        int d = 0;
        int e = 0;
        int f = 0;
        int g = 0;
        int h = 0;
        int i = 0;
        int j = 0;
        for (int s = 0; s < this.logPanel.logDataModel.getRowCount(); ++s) {
            SolidItem solidData;
            SolidItem solidItem = (SolidItem)this.logPanel.logDataModel.getValueAt(s, 1);
            if (solidItem instanceof CSGItem) {
                solidData = new CSGItem(solidItem.getSolidType());
                if (solidData.toString() == "Box") {
                    ++a;
                    continue;
                }
                if (solidData.toString() == "TubeSegment") {
                    ++b;
                    continue;
                }
                if (solidData.toString() == "ConeSegment") {
                    ++c;
                    continue;
                }
                if (solidData.toString() == "SymTrapezoid") {
                    ++d;
                    continue;
                }
                if (solidData.toString() == "SphereSegment") {
                    ++e;
                    continue;
                }
                if (solidData.toString() == "Parallelepiped") {
                    ++f;
                    continue;
                }
                if (solidData.toString() == "TorusSegment") {
                    ++g;
                    continue;
                }
                if (solidData.toString() != "Hype") continue;
                ++h;
                continue;
            }
            if (!(solidItem instanceof BREPItem)) continue;
            solidData = new BREPItem(solidItem.getSolidType());
            if (solidData.toString() == "PolyConeSegment") {
                ++i;
                continue;
            }
            if (solidData.toString() != "PolyGonSegment") continue;
            ++j;
        }
        if (a != 0) {
            cpp.append("#include \"G4Box.hh\"\n");
        }
        if (b != 0) {
            cpp.append("#include \"G4Tubs.hh\"\n");
        }
        if (c != 0) {
            cpp.append("#include \"G4Cons.hh\"\n");
        }
        if (d != 0) {
            cpp.append("#include \"G4Trd.hh\"\n");
        }
        if (e != 0) {
            cpp.append("#include \"G4Sphere.hh\"\n");
        }
        if (f != 0) {
            cpp.append("#include \"G4Para.hh\"\n");
        }
        if (g != 0) {
            cpp.append("#include \"G4Torus.hh\"\n");
        }
        if (h != 0) {
            cpp.append("#include \"G4Hype.hh\"\n");
        }
        if (i != 0) {
            cpp.append("#include \"G4BREPSolidPCone.hh\"\n");
        }
        if (j != 0) {
            cpp.append("#include \"G4BREPSolidPolyhedra.hh\"\n");
        }
        cpp.append("#include \"G4LogicalVolume.hh\"\n");
        cpp.append("#include \"G4ThreeVector.hh\"\n");
        cpp.append("#include \"G4PVPlacement.hh\"\n");
        cpp.append("#include \"G4PVReplica.hh\"\n");
        cpp.append("#include \"G4SDManager.hh\"\n");
        cpp.append("#include \"G4VisAttributes.hh\"\n");
        cpp.append("#include \"G4Colour.hh\"\n\n");
        cpp.append(myName + "::" + myName + "()\n{ ; }\n");
        cpp.append(myName + "::~" + myName + "()\n{ ; }\n");
        cpp.append("G4VPhysicalVolume* " + myName + "::Construct( )\n{\n");
        return cpp.toString();
    }

    public void volClear() {
        this.logPanel.logClear();
        this.visPanel.visClear();
        this.singleVol.singleClear();
        this.repFrame.replicasClear();
        this.slicingFrame.slicingClear();
        this.repeatVol.repeatedClear();
        this.repeatRotVol.repeatedRotClear();
        this.transParameFrame.transParameClear();
        this.axiParameFrame.axiParameClear();
    }

    public void XMLfileLoad() {
        JFileChooser loadXML = new JFileChooser(this.workdirpath);
        ExampleFileFilter xmlFile = new ExampleFileFilter("xml", "XML Source");
        loadXML.setFileFilter(xmlFile);
        loadXML.setDialogTitle("Load XML");
        if (loadXML.showOpenDialog(this) != 0) {
            return;
        }
        loadXML.setMultiSelectionEnabled(true);
        File fl = loadXML.getSelectedFile();
        this.et = new ElementsTable();
        if (fl.isFile()) {
            this.fileName = fl.getPath();
            try {
                int j;
                DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = dbfactory.newDocumentBuilder();
                Document doc = builder.parse(new File(this.fileName));
                Element root = doc.getDocumentElement();
                NodeList nodelist = root.getChildNodes();
                Vector logStrData = new Vector();
                Vector logSldData = new Vector();
                Vector defineData = new Vector();
                Vector mtrScrData = new Vector();
                Vector mtrComData = new Vector();
                for (int i = 0; i < nodelist.getLength(); ++i) {
                    int j2;
                    Node node = nodelist.item(i);
                    NamedNodeMap attrs = node.getAttributes();
                    if (attrs == null) continue;
                    String volName = "";
                    String materialStr = "";
                    String solidStr = "";
                    if (node.getNodeName() == "structure") {
                        NodeList strList = node.getChildNodes();
                        for (j2 = 0; j2 < strList.getLength(); ++j2) {
                            Node strNode = strList.item(j2);
                            NamedNodeMap strAttrs = strNode.getAttributes();
                            if (strAttrs == null || strNode.getNodeName() != "volume") continue;
                            Vector<String> v = new Vector<String>();
                            volName = strAttrs.getNamedItem("name").getNodeValue();
                            NodeList volList = strNode.getChildNodes();
                            for (int k = 0; k < volList.getLength(); ++k) {
                                Node child = volList.item(k);
                                NamedNodeMap volAttrs = child.getAttributes();
                                if (volAttrs == null) continue;
                                if (child.getNodeName() == "solidref") {
                                    solidStr = volAttrs.getNamedItem("ref").getNodeValue();
                                    continue;
                                }
                                if (child.getNodeName() != "materialref") continue;
                                materialStr = volAttrs.getNamedItem("ref").getNodeValue();
                            }
                            v.addElement(volName);
                            v.addElement(solidStr);
                            v.addElement(materialStr);
                            v.addElement("");
                            logStrData.addElement(v);
                        }
                    }
                    if (node.getNodeName() == "solids") {
                        NodeList sldList = node.getChildNodes();
                        for (j2 = 0; j2 < sldList.getLength(); ++j2) {
                            Node sldNode = sldList.item(j2);
                            Vector<String> v = new Vector<String>();
                            String sldName = sldNode.getNodeName();
                            NamedNodeMap sldAttrs = sldNode.getAttributes();
                            if (sldAttrs == null) continue;
                            if (sldName == "define") {
                                NodeList defList = sldNode.getChildNodes();
                                for (int k = 0; k < defList.getLength(); ++k) {
                                    Node defNode = defList.item(k);
                                    Vector<String> quav = new Vector<String>();
                                    NamedNodeMap defAttrs = defNode.getAttributes();
                                    if (defAttrs == null) continue;
                                    quav.addElement(this.getAttrName(defAttrs, "name"));
                                    quav.addElement(this.getAttrName(defAttrs, "value"));
                                    quav.addElement(this.getAttrName(defAttrs, "unit"));
                                    defineData.addElement(quav);
                                }
                            } else if (sldName == "box") {
                                v.addElement("0");
                                v.addElement(this.getAttrName(sldAttrs, "name"));
                                v.addElement(this.getAttrName(sldAttrs, "x"));
                                v.addElement(this.getAttrName(sldAttrs, "y"));
                                v.addElement(this.getAttrName(sldAttrs, "z"));
                            } else if (sldName == "trd") {
                                v.addElement("1");
                                v.addElement(this.getAttrName(sldAttrs, "name"));
                                v.addElement(this.getAttrName(sldAttrs, "x1"));
                                v.addElement(this.getAttrName(sldAttrs, "x2"));
                                v.addElement(this.getAttrName(sldAttrs, "y1"));
                                v.addElement(this.getAttrName(sldAttrs, "y2"));
                                v.addElement(this.getAttrName(sldAttrs, "z"));
                            } else if (sldName == "tube") {
                                v.addElement("2");
                                v.addElement(this.getAttrName(sldAttrs, "name"));
                                v.addElement(this.getAttrName(sldAttrs, "rmin"));
                                v.addElement(this.getAttrName(sldAttrs, "rmax"));
                                v.addElement(this.getAttrName(sldAttrs, "z"));
                                v.addElement(this.getAttrName(sldAttrs, "startphi"));
                                v.addElement(this.getAttrName(sldAttrs, "deltaphi"));
                            } else if (sldName == "cone") {
                                v.addElement("3");
                                v.addElement(this.getAttrName(sldAttrs, "name"));
                                v.addElement(this.getAttrName(sldAttrs, "rmin1"));
                                v.addElement(this.getAttrName(sldAttrs, "rmax1"));
                                v.addElement(this.getAttrName(sldAttrs, "rmin2"));
                                v.addElement(this.getAttrName(sldAttrs, "rmax2"));
                                v.addElement(this.getAttrName(sldAttrs, "z"));
                                v.addElement(this.getAttrName(sldAttrs, "startphi"));
                                v.addElement(this.getAttrName(sldAttrs, "deltaphi"));
                            } else if (sldName == "sphere") {
                                v.addElement("4");
                                v.addElement(this.getAttrName(sldAttrs, "name"));
                                v.addElement(this.getAttrName(sldAttrs, "rmin"));
                                v.addElement(this.getAttrName(sldAttrs, "rmax"));
                                v.addElement(this.getAttrName(sldAttrs, "startphi"));
                                v.addElement(this.getAttrName(sldAttrs, "deltaphi"));
                                v.addElement(this.getAttrName(sldAttrs, "starttheta"));
                                v.addElement(this.getAttrName(sldAttrs, "deltatheta"));
                            } else if (sldName == "para") {
                                v.addElement("5");
                                v.addElement(this.getAttrName(sldAttrs, "name"));
                                v.addElement(this.getAttrName(sldAttrs, "x"));
                                v.addElement(this.getAttrName(sldAttrs, "y"));
                                v.addElement(this.getAttrName(sldAttrs, "z"));
                                v.addElement(this.getAttrName(sldAttrs, "alpha"));
                                v.addElement(this.getAttrName(sldAttrs, "theta"));
                                v.addElement(this.getAttrName(sldAttrs, "phi"));
                            }
                            if (v.size() == 0) continue;
                            logSldData.addElement(v);
                        }
                    }
                    if (node.getNodeName() != "materials") continue;
                    NodeList mtrList = node.getChildNodes();
                    for (j2 = 0; j2 < mtrList.getLength(); ++j2) {
                        String dUnit;
                        Node mtrNode = mtrList.item(j2);
                        String mtrName = mtrNode.getNodeName();
                        NamedNodeMap mtrAttrs = mtrNode.getAttributes();
                        if (mtrAttrs == null || mtrName != "material") continue;
                        NodeList mtrCList = mtrNode.getChildNodes();
                        boolean isScratch = true;
                        for (int k = 0; k < mtrCList.getLength(); ++k) {
                            Node mtrCNode = mtrCList.item(k);
                            NamedNodeMap mtrCAttrs = mtrCNode.getAttributes();
                            if (mtrCAttrs == null || mtrCNode.getNodeName() != "composite" && mtrCNode.getNodeName() != "fraction") continue;
                            isScratch = false;
                        }
                        if (isScratch) {
                            String dValue = "";
                            dUnit = "";
                            String aValue = "";
                            String tValue = "";
                            String tUnit = "";
                            String pValue = "";
                            String pUnit = "";
                            for (int k = 0; k < mtrCList.getLength(); ++k) {
                                Node mtrCNode = mtrCList.item(k);
                                NamedNodeMap mtrCAttrs = mtrCNode.getAttributes();
                                if (mtrCAttrs == null) continue;
                                if (mtrCNode.getNodeName() == "D") {
                                    dValue = this.getAttrName(mtrCAttrs, "value");
                                    dUnit = this.getAttrName(mtrCAttrs, "unit");
                                    continue;
                                }
                                if (mtrCNode.getNodeName() == "atom") {
                                    aValue = this.getAttrName(mtrCAttrs, "value");
                                    continue;
                                }
                                if (mtrCNode.getNodeName() == "T") {
                                    tValue = this.getAttrName(mtrCAttrs, "value");
                                    tUnit = this.getAttrName(mtrCAttrs, "unit");
                                    continue;
                                }
                                if (mtrCNode.getNodeName() != "P") continue;
                                pValue = this.getAttrName(mtrCAttrs, "value");
                                pUnit = this.getAttrName(mtrCAttrs, "unit");
                            }
                            Vector<String> mtrData = new Vector<String>();
                            String stateStr = this.getAttrName(mtrAttrs, "state");
                            String state = "";
                            state = stateStr.equals("unknown") ? MaterialItem.stateCode[0] : (stateStr.equals("solid") ? MaterialItem.stateCode[1] : (stateStr.equals("liquid") ? MaterialItem.stateCode[2] : (stateStr.equals("gas") ? MaterialItem.stateCode[3] : MaterialItem.stateCode[0])));
                            mtrData.addElement("Used");
                            mtrData.addElement(this.getAttrName(mtrAttrs, "name"));
                            mtrData.addElement(this.getAttrName(mtrAttrs, "Z"));
                            mtrData.addElement(aValue);
                            mtrData.addElement(dValue);
                            mtrData.addElement(dUnit);
                            mtrData.addElement(state);
                            mtrData.addElement(tValue);
                            mtrData.addElement(tUnit);
                            mtrData.addElement(pValue);
                            mtrData.addElement(pUnit);
                            mtrScrData.addElement(mtrData);
                            continue;
                        }
                        String dValue = "";
                        dUnit = "";
                        String tValue = "";
                        String tUnit = "";
                        String pValue = "";
                        String pUnit = "";
                        Vector elemV = new Vector();
                        int symbolNum = 0;
                        for (int k = 0; k < mtrCList.getLength(); ++k) {
                            Node mtrCNode = mtrCList.item(k);
                            NamedNodeMap mtrCAttrs = mtrCNode.getAttributes();
                            if (mtrCAttrs == null) continue;
                            if (mtrCNode.getNodeName() == "D") {
                                dValue = mtrCAttrs.getNamedItem("value").getNodeValue();
                                dUnit = this.getAttrName(mtrCAttrs, "unit");
                                continue;
                            }
                            if (mtrCNode.getNodeName() == "T") {
                                tValue = this.getAttrName(mtrCAttrs, "value");
                                tUnit = this.getAttrName(mtrCAttrs, "unit");
                                continue;
                            }
                            if (mtrCNode.getNodeName() == "P") {
                                pValue = this.getAttrName(mtrCAttrs, "value");
                                pUnit = this.getAttrName(mtrCAttrs, "unit");
                                continue;
                            }
                            Vector<String> v = new Vector<String>();
                            String elem = this.getAttrName(mtrCAttrs, "ref");
                            v.addElement(mtrCNode.getNodeName());
                            v.addElement(this.getAttrName(mtrCAttrs, "n"));
                            v.addElement(elem);
                            elemV.addElement(v);
                            for (int l = 0; l < 104; ++l) {
                                if (this.et.getSymbol(l).equals(elem)) {
                                    ++symbolNum;
                                    continue;
                                }
                                if (!this.et.getName(l).equals(elem)) continue;
                                ++symbolNum;
                            }
                        }
                        if (((Vector)elemV.elementAt(0)).elementAt(2).toString() == "") continue;
                        int isfraction = 0;
                        int num = 0;
                        boolean isUnknown = true;
                        float[] ratioNum = new float[symbolNum];
                        ElementItem[] ei = new ElementItem[symbolNum];
                        for (int k = 0; k < elemV.size(); ++k) {
                            String fraction = this.getStr(elemV, k, 0);
                            String ratioStr = this.getStr(elemV, k, 1);
                            String elem = this.getStr(elemV, k, 2);
                            for (int l = 0; l < 104; ++l) {
                                if (this.et.getSymbol(l).equals(elem)) {
                                    ei[num] = this.et.getElement(l);
                                    isUnknown = false;
                                    ratioNum[num] = ratioStr != "" ? Float.valueOf(ratioStr).floatValue() : 0.0f;
                                    ++num;
                                    continue;
                                }
                                if (!this.et.getName(l).equals(elem)) continue;
                                ei[num] = this.et.getElement(l);
                                isUnknown = false;
                                ratioNum[num] = ratioStr != "" ? Float.valueOf(ratioStr).floatValue() : 0.0f;
                                ++num;
                            }
                            if (fraction == "fraction") {
                                isfraction = 1;
                                continue;
                            }
                            if (fraction != "composite") continue;
                            isfraction = 0;
                        }
                        if (isUnknown) continue;
                        RatioItem ratioItem = new RatioItem(ei);
                        ratioItem.ratio = ratioNum;
                        ratioItem.isEmpty = false;
                        ratioItem.isFraction = isfraction;
                        Vector<Object> mtrData = new Vector<Object>();
                        mtrData.addElement("Used");
                        mtrData.addElement(this.getAttrName(mtrAttrs, "name"));
                        mtrData.addElement(ratioItem);
                        mtrData.addElement(dValue);
                        mtrData.addElement(dUnit);
                        mtrData.addElement("kStateUndefined");
                        mtrData.addElement(tValue);
                        mtrData.addElement(tUnit);
                        mtrData.addElement(pValue);
                        mtrData.addElement(pUnit);
                        mtrComData.addElement(mtrData);
                    }
                }
                this.logPanel.logClear();
                SolidCellEditor sce = new SolidCellEditor(this);
                for (j = 0; j < logStrData.size(); ++j) {
                    Vector logData = new Vector();
                    int solidType = 0;
                    int sldnum = 0;
                    boolean knownSld = false;
                    for (int k = 0; k < logSldData.size(); ++k) {
                        if (this.getStr(logSldData, k, 1).equals(this.getStr(logStrData, j, 1))) {
                            solidType = Integer.parseInt(this.getStr(logSldData, j, 0));
                            sldnum = k;
                            knownSld = true;
                            continue;
                        }
                        if (!this.getStr(logSldData, k, 1).equals(this.getStr(logStrData, j, 0))) continue;
                        solidType = Integer.parseInt(this.getStr(logSldData, j, 0));
                        sldnum = k;
                        knownSld = true;
                    }
                    if (!knownSld) continue;
                    CSGItem csgItem = new CSGItem(solidType);
                    for (int k = 0; k < ((Vector)logSldData.elementAt(sldnum)).size() - 2; ++k) {
                        String values = "";
                        String unit = "";
                        String valuesStr = this.getStr(logSldData, sldnum, k + 2);
                        for (int l = 0; l < defineData.size(); ++l) {
                            Vector defv = (Vector)defineData.elementAt(l);
                            if (!valuesStr.equals(defv.elementAt(0).toString())) continue;
                            values = defv.elementAt(1).toString();
                            unit = defv.elementAt(2).toString();
                        }
                        double doubleValue = 0.0;
                        doubleValue = values != "" ? Double.valueOf(values) : 0.0;
                        csgItem.setValuesUnits(k, doubleValue, unit);
                    }
                    sce.getTableCellEditorComponent(this.logPanel.logTable, csgItem, true, sldnum, 1);
                    logData.addElement(((Vector)logStrData.elementAt(j)).elementAt(0));
                    logData.addElement(csgItem);
                    logData.addElement(((Vector)logStrData.elementAt(j)).elementAt(2));
                    logData.addElement("");
                    this.logPanel.logDataModel.addRow(logData);
                }
                this.logPanel.repaint();
                this.matFrame.MaterialfileClear();
                for (j = 0; j < mtrScrData.size(); ++j) {
                    Vector scratch = (Vector)mtrScrData.elementAt(j);
                    this.matFrame.msDataModel.addRow(scratch);
                }
                this.matFrame.repaint();
                for (j = 0; j < mtrComData.size(); ++j) {
                    Vector combi = (Vector)mtrComData.elementAt(j);
                    this.matFrame.mcDataModel.addRow(combi);
                }
                this.matFrame.repaint();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    String getAttrName(NamedNodeMap attrs, String name) {
        if (attrs.getNamedItem(name) != null) {
            return attrs.getNamedItem(name).getNodeValue();
        }
        return "";
    }

    String getStr(Vector v, int i, int j) {
        if (((Vector)v.elementAt(i)).elementAt(j) != "") {
            return ((Vector)v.elementAt(i)).elementAt(j).toString();
        }
        return "";
    }

    public void XMLfileSave() {
        JFileChooser saveXML = new JFileChooser(this.workdirpath);
        ExampleFileFilter xmlFile = new ExampleFileFilter("xml", "XML Source");
        saveXML.setFileFilter(xmlFile);
        saveXML.setDialogTitle("Save XML");
        if (saveXML.showSaveDialog(this) != 0) {
            return;
        }
        File fs = saveXML.getSelectedFile();
        this.fileName = fs.getPath();
        if (this.fileName != null) {
            try {
                FileOutputStream fileout = new FileOutputStream(this.fileName);
                PrintWriter outf = new PrintWriter(new DataOutputStream(fileout));
                outf.println(this.makeXML());
                outf.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            return;
        }
        if (this.fileName == null) {
            return;
        }
    }

    public void GGEfileLoad() {
        JFileChooser loadGGE = new JFileChooser(this.workdirpath);
        ExampleFileFilter dtFile = new ExampleFileFilter("g4dt", "DetectorSource");
        loadGGE.setFileFilter(dtFile);
        loadGGE.setDialogTitle("Load Detector");
        if (loadGGE.showOpenDialog(this) != 0) {
            return;
        }
        loadGGE.setMultiSelectionEnabled(true);
        File fl = loadGGE.getSelectedFile();
        if (fl.isFile()) {
            this.fileName = fl.getPath();
            try {
                FileInputStream filein = new FileInputStream(this.fileName);
                ObjectInputStream objin = new ObjectInputStream(filein);
                Vector detectorData = (Vector)objin.readObject();
                Vector logData = (Vector)detectorData.elementAt(0);
                Vector visData = (Vector)detectorData.elementAt(1);
                Vector replicaData = (Vector)detectorData.elementAt(2);
                Vector repeatData = (Vector)detectorData.elementAt(3);
                Vector repeatRotData = (Vector)detectorData.elementAt(4);
                Vector singleData = (Vector)detectorData.elementAt(5);
                Vector matSData = (Vector)detectorData.elementAt(6);
                Vector matCData = (Vector)detectorData.elementAt(7);
                Vector slicingData = (Vector)detectorData.elementAt(8);
                Vector transParameData = (Vector)detectorData.elementAt(9);
                Vector axiParameData = (Vector)detectorData.elementAt(10);
                Object classNameFieldObject = detectorData.elementAt(11);
                this.logPanel.logClear();
                int logVectorCount = logData.size();
                for (int i = 0; i < logVectorCount; ++i) {
                    Vector lt = (Vector)logData.elementAt(i);
                    this.logPanel.logDataModel.addRow(lt);
                }
                this.logPanel.repaint();
                this.visPanel.visClear();
                int visVectorCount = visData.size();
                for (int i = 0; i < visVectorCount; ++i) {
                    Object vis = visData.elementAt(i);
                    this.visPanel.listModel.addElement(vis);
                }
                this.visPanel.repaint();
                this.repFrame.replicasClear();
                int replicaVectorCount = replicaData.size();
                for (int i = 0; i < replicaVectorCount; ++i) {
                    Vector replica = (Vector)replicaData.elementAt(i);
                    this.repFrame.repDataModel.addRow(replica);
                }
                this.repFrame.repaint();
                this.repeatVol.repeatedClear();
                int repeatVectorCount = repeatData.size();
                for (int i = 0; i < repeatVectorCount; ++i) {
                    Vector repeat = (Vector)repeatData.elementAt(i);
                    this.repeatVol.pDataModel.addRow(repeat);
                }
                this.repeatVol.repaint();
                this.repeatRotVol.repeatedRotClear();
                int repeatRotVectorCount = repeatRotData.size();
                for (int i = 0; i < repeatRotVectorCount; ++i) {
                    Vector repeatRot = (Vector)repeatRotData.elementAt(i);
                    this.repeatRotVol.pDataModel.addRow(repeatRot);
                }
                this.repeatRotVol.repaint();
                this.singleVol.singleClear();
                int singleVectorCount = singleData.size();
                for (int i = 0; i < singleVectorCount; ++i) {
                    Vector single = (Vector)singleData.elementAt(i);
                    this.singleVol.singleDataModel.addRow(single);
                }
                this.singleVol.repaint();
                this.matFrame.MaterialfileClear();
                int msVectorCount = matSData.size();
                for (int i = 0; i < msVectorCount; ++i) {
                    Vector scratch = (Vector)matSData.elementAt(i);
                    this.matFrame.msDataModel.addRow(scratch);
                }
                int mcVectorCount = matCData.size();
                for (int i = 0; i < mcVectorCount; ++i) {
                    Vector combi = (Vector)matCData.elementAt(i);
                    this.matFrame.mcDataModel.addRow(combi);
                }
                this.slicingFrame.slicingClear();
                int slicingVectorCount = slicingData.size();
                for (int i = 0; i < slicingVectorCount; ++i) {
                    Vector slicing = (Vector)slicingData.elementAt(i);
                    this.slicingFrame.slicingDataModel.addRow(slicing);
                }
                this.transParameFrame.transParameClear();
                int transParameCount = transParameData.size();
                for (int i = 0; i < transParameCount; ++i) {
                    Vector trans = (Vector)transParameData.elementAt(i);
                    this.transParameFrame.pDataModel.addRow(trans);
                }
                this.axiParameFrame.axiParameClear();
                int axiParameCount = axiParameData.size();
                for (int i = 0; i < axiParameCount; ++i) {
                    Vector axi = (Vector)axiParameData.elementAt(i);
                    this.axiParameFrame.pDataModel.addRow(axi);
                }
                String classNameFieldString = classNameFieldObject.toString();
                this.classNameField.setText(classNameFieldString);
                this.slicingFrame.repaint();
                objin.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void GGEfileAppend() {
        JFileChooser loadGGE = new JFileChooser(this.workdirpath);
        ExampleFileFilter dtFile = new ExampleFileFilter("g4dt", "DetectorSource");
        loadGGE.setFileFilter(dtFile);
        loadGGE.setDialogTitle("Load Detector");
        int returnVal = loadGGE.showOpenDialog(this);
        loadGGE.setMultiSelectionEnabled(true);
        File fl = loadGGE.getSelectedFile();
        if (returnVal == 0) {
            this.fileName = fl.getPath();
            try {
                FileInputStream filein = new FileInputStream(this.fileName);
                ObjectInputStream objin = new ObjectInputStream(filein);
                Vector detectorData = (Vector)objin.readObject();
                Vector logData = (Vector)detectorData.elementAt(0);
                Vector visData = (Vector)detectorData.elementAt(1);
                Vector replicaData = (Vector)detectorData.elementAt(2);
                Vector repeatData = (Vector)detectorData.elementAt(3);
                Vector repeatRotData = (Vector)detectorData.elementAt(4);
                Vector singleData = (Vector)detectorData.elementAt(5);
                Vector matSData = (Vector)detectorData.elementAt(6);
                Vector matCData = (Vector)detectorData.elementAt(7);
                Vector slicingData = (Vector)detectorData.elementAt(8);
                Vector transParameData = (Vector)detectorData.elementAt(9);
                Vector axiParameData = (Vector)detectorData.elementAt(10);
                Object classNameFieldObject = detectorData.elementAt(11);
                int logVectorCount = logData.size();
                for (int i = 0; i < logVectorCount; ++i) {
                    Vector lt = (Vector)logData.elementAt(i);
                    this.logPanel.logDataModel.addRow(lt);
                }
                this.logPanel.repaint();
                int visVectorCount = visData.size();
                for (int i = 0; i < visVectorCount; ++i) {
                    Object vis = visData.elementAt(i);
                    this.visPanel.listModel.addElement(vis);
                }
                this.visPanel.repaint();
                int replicaVectorCount = replicaData.size();
                for (int i = 0; i < replicaVectorCount; ++i) {
                    Vector replica = (Vector)replicaData.elementAt(i);
                    this.repFrame.repDataModel.addRow(replica);
                }
                this.repFrame.repaint();
                int repeatVectorCount = repeatData.size();
                for (int i = 0; i < repeatVectorCount; ++i) {
                    Vector repeat = (Vector)repeatData.elementAt(i);
                    this.repeatVol.pDataModel.addRow(repeat);
                }
                this.repeatVol.repaint();
                int repeatRotVectorCount = repeatRotData.size();
                for (int i = 0; i < repeatRotVectorCount; ++i) {
                    Vector repeatRot = (Vector)repeatRotData.elementAt(i);
                    this.repeatVol.pDataModel.addRow(repeatRot);
                }
                this.repeatRotVol.repaint();
                int singleVectorCount = singleData.size();
                for (int i = 0; i < singleVectorCount; ++i) {
                    Vector single = (Vector)singleData.elementAt(i);
                    this.singleVol.singleDataModel.addRow(single);
                }
                this.singleVol.repaint();
                int msVectorCount = matSData.size();
                for (int i = 0; i < msVectorCount; ++i) {
                    Vector scratch = (Vector)matSData.elementAt(i);
                    this.matFrame.msDataModel.addRow(scratch);
                }
                int mcVectorCount = matCData.size();
                for (int i = 0; i < mcVectorCount; ++i) {
                    Vector combi = (Vector)matCData.elementAt(i);
                    this.matFrame.mcDataModel.addRow(combi);
                }
                int slicingVectorCount = slicingData.size();
                for (int i = 0; i < slicingVectorCount; ++i) {
                    Vector slicing = (Vector)slicingData.elementAt(i);
                    this.slicingFrame.slicingDataModel.addRow(slicing);
                }
                int transParameCount = transParameData.size();
                for (int i = 0; i < transParameCount; ++i) {
                    Vector trans = (Vector)transParameData.elementAt(i);
                    this.transParameFrame.pDataModel.addRow(trans);
                }
                int axiParameCount = axiParameData.size();
                for (int i = 0; i < axiParameCount; ++i) {
                    Vector axi = (Vector)axiParameData.elementAt(i);
                    this.axiParameFrame.pDataModel.addRow(axi);
                }
                String classNameFieldString = classNameFieldObject.toString();
                this.classNameField.setText(classNameFieldString);
                this.slicingFrame.repaint();
                objin.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void GGEfileSave() {
        JFileChooser saveGGE = new JFileChooser(this.workdirpath);
        ExampleFileFilter dtFile = new ExampleFileFilter("g4dt", "DetectorSource");
        saveGGE.setFileFilter(dtFile);
        saveGGE.setDialogTitle("Save Detector");
        if (saveGGE.showSaveDialog(this) != 0) {
            return;
        }
        File fs = saveGGE.getSelectedFile();
        this.fileName = fs.getPath();
        if (this.fileName != null) {
            try {
                FileOutputStream fileout = new FileOutputStream(this.fileName);
                ObjectOutputStream objout = new ObjectOutputStream(fileout);
                Vector<Object> detectorVector = new Vector<Object>();
                detectorVector.addElement(this.logPanel.logDataModel.getDataVector());
                Vector<Object> visVector = new Vector<Object>();
                for (int i = 0; i < this.visPanel.listModel.getSize(); ++i) {
                    visVector.addElement(this.visPanel.listModel.elementAt(i));
                }
                detectorVector.addElement(visVector);
                detectorVector.addElement(this.repFrame.repDataModel.getDataVector());
                detectorVector.addElement(this.repeatVol.pDataModel.getDataVector());
                detectorVector.addElement(this.repeatRotVol.pDataModel.getDataVector());
                detectorVector.addElement(this.singleVol.singleDataModel.getDataVector());
                Vector msdata = this.matFrame.msDataModel.getDataVector();
                Vector<Vector> msUsed = new Vector<Vector>();
                for (int i = 0; i < msdata.size(); ++i) {
                    Vector msRowData = (Vector)msdata.elementAt(i);
                    if (!msRowData.elementAt(0).equals("Used") || !msRowData.elementAt(0).equals("Used")) continue;
                    msUsed.addElement((Vector)msdata.elementAt(i));
                }
                detectorVector.addElement(msUsed);
                Vector mcdata = this.matFrame.mcDataModel.getDataVector();
                Vector<Vector> mcUsed = new Vector<Vector>();
                for (int i = 0; i < mcdata.size(); ++i) {
                    Vector mcRowData = (Vector)mcdata.elementAt(i);
                    if (!mcRowData.elementAt(0).equals("Used") || !mcRowData.elementAt(0).equals("Used")) continue;
                    mcUsed.addElement((Vector)mcdata.elementAt(i));
                }
                detectorVector.addElement(mcUsed);
                detectorVector.addElement(this.slicingFrame.slicingDataModel.getDataVector());
                detectorVector.addElement(this.transParameFrame.pDataModel.getDataVector());
                detectorVector.addElement(this.axiParameFrame.pDataModel.getDataVector());
                detectorVector.addElement(this.classNameField.getText());
                objout.writeObject(detectorVector);
                objout.flush();
                fileout.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            return;
        }
        if (this.fileName == null) {
            return;
        }
    }

    public void okCommand() {
        int i;
        Object[] mtclear = new Object[]{""};
        for (i = 0; i < this.matFrame.msTable.getRowCount(); ++i) {
            this.matFrame.msTable.setValueAt(mtclear[0], i, 0);
        }
        for (i = 0; i < this.matFrame.mcTable.getRowCount(); ++i) {
            this.matFrame.mcTable.setValueAt(mtclear[0], i, 0);
        }
        for (int i2 = 0; i2 < this.logPanel.logTable.getRowCount(); ++i2) {
            String logMaterial = (String)this.logPanel.logDataModel.getValueAt(i2, 2);
            if (this.matFrame.msDataModel.getRowCount() != -1) {
                for (int j = 0; j < this.matFrame.msDataModel.getRowCount(); ++j) {
                    String msMaterial = (String)this.matFrame.msDataModel.getValueAt(j, 1);
                    if (!logMaterial.equals(msMaterial) || !logMaterial.equals(msMaterial)) continue;
                    this.matFrame.msDataModel.setValueAt("Used", j, 0);
                }
            }
            if (this.matFrame.mcDataModel.getRowCount() == -1) continue;
            for (int h = 0; h < this.matFrame.mcDataModel.getRowCount(); ++h) {
                String mcMaterial = (String)this.matFrame.mcDataModel.getValueAt(h, 1);
                if (!logMaterial.equals(mcMaterial) || !logMaterial.equals(mcMaterial)) continue;
                this.matFrame.mcDataModel.setValueAt("Used", h, 0);
            }
        }
    }

    public String[] getMaterialName() {
        int i;
        int i2;
        GGETableModel msModel = this.matFrame.msDataModel;
        GGETableModel mcModel = this.matFrame.mcDataModel;
        int sRow = msModel.getRowCount();
        int cRow = mcModel.getRowCount();
        int scratchRow = 0;
        int combiRow = 0;
        for (i2 = 0; i2 < sRow; ++i2) {
            if (!msModel.getValueAt(i2, 0).equals("Used")) continue;
            ++scratchRow;
        }
        for (i2 = 0; i2 < cRow; ++i2) {
            if (!mcModel.getValueAt(i2, 0).equals("Used")) continue;
            ++combiRow;
        }
        int matRow = scratchRow + combiRow;
        String[] materialName = new String[matRow];
        matRow = 0;
        for (i = 0; i < sRow; ++i) {
            if (!msModel.getValueAt(i, 0).equals("Used")) continue;
            materialName[matRow] = msModel.getValueAt(i, 1).toString();
            ++matRow;
        }
        for (i = 0; i < cRow; ++i) {
            if (!mcModel.getValueAt(i, 0).equals("Used")) continue;
            materialName[matRow] = mcModel.getValueAt(i, 1).toString();
            ++matRow;
        }
        return materialName;
    }

    public String[] getVolumesName() {
        GGETableModel logModel = this.logPanel.logDataModel;
        int logRow = logModel.getRowCount();
        String[] volumesName = new String[logRow];
        for (int i = 0; i < logRow; ++i) {
            volumesName[i] = logModel.getValueAt(i, 0).toString();
        }
        return volumesName;
    }
}

