/*
 * Decompiled with CFR 0.152.
 */
package GPE;

import GPE.AbstractGPEFrame;
import GPE.PhysicsFrame;
import GPE.ProcessCell;
import GPE.ProcessItem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

class HadronProcessesTable
extends AbstractGPEFrame
implements ActionListener {
    private ProcessCell[] procel;
    PhysicsFrame phyFrame;
    JButton changeProcessButton;
    JButton closeTableButton;

    HadronProcessesTable(PhysicsFrame phyFrame) {
        super("HadronicProcesses Table");
        this.phyFrame = phyFrame;
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        int[] proPosX = new int[]{1, 2, 3, 4, 5, 6, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 1, 2, 1, 1, 2, 3, 4, 5, 6, 7};
        int[] proPosY = new int[]{0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 4, 4, 5, 6, 6, 6, 6, 6, 6, 6};
        ProcessItem[] proi = this.makeProcess();
        gbc.insets = new Insets(1, 1, 1, 1);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.procel = new ProcessCell[proi.length];
        this.changeProcessButton = new JButton("Change Process");
        this.changeProcessButton.setBackground(Color.green);
        this.closeTableButton = new JButton("CloseTable");
        this.closeTableButton.setBackground(Color.yellow);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 2));
        buttonPanel.setBackground(new Color(230, 250, 230));
        buttonPanel.add(this.changeProcessButton);
        buttonPanel.add(this.closeTableButton);
        JPanel tablePanel = new JPanel();
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout(1, 1));
        mainPanel.add((Component)buttonPanel, "North");
        mainPanel.add((Component)tablePanel, "Center");
        tablePanel.setLayout(gbl);
        tablePanel.setBackground(new Color(225, 235, 100));
        this.changeProcessButton.addActionListener(this);
        this.closeTableButton.addActionListener(this);
        for (int i = 0; i < proi.length; ++i) {
            gbc.gridx = proPosX[i];
            gbc.gridy = proPosY[i];
            this.procel[i] = new ProcessCell(proi[i]);
            gbl.setConstraints(this.procel[i], gbc);
            tablePanel.add(this.procel[i]);
        }
        Color lightred = new Color(255, 200, 200);
        Color brightred = new Color(255, 190, 190);
        JLabel l02 = new JLabel("Inelastic of", 0);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbl.setConstraints(l02, gbc);
        tablePanel.add(l02);
        l02.setOpaque(true);
        l02.setBackground(brightred);
        l02.setFont(new Font("Serif", 1, 12));
        JLabel l06 = new JLabel("neutron-induced", 0);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbl.setConstraints(l06, gbc);
        tablePanel.add(l06);
        l06.setOpaque(true);
        l06.setBackground(lightred);
        l06.setFont(new Font("Serif", 1, 12));
        JLabel l07 = new JLabel("all hadrons/ions", 0);
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbl.setConstraints(l07, gbc);
        tablePanel.add(l07);
        l07.setOpaque(true);
        l07.setBackground(lightred);
        l07.setFont(new Font("Serif", 1, 12));
        JLabel l08 = new JLabel("Stopping", 0);
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbl.setConstraints(l08, gbc);
        tablePanel.add(l08);
        l08.setOpaque(true);
        l08.setBackground(lightred);
        l08.setFont(new Font("Serif", 1, 12));
        this.setSize(850, 180);
        this.add(mainPanel);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.changeProcessButton) {
            this.phyFrame.changeHadronProcess();
        } else if (e.getSource() == this.closeTableButton) {
            this.setVisible(false);
            this.phyFrame.phyHadTable.openHProcButtonCloseAct();
            this.getSelectedProcess();
        }
    }

    ProcessItem[] getSelectedProcess() {
        int k = 0;
        if (ProcessCell.selectedProc == 0) {
            return null;
        }
        ProcessItem[] pi = new ProcessItem[ProcessCell.selectedProc];
        for (int i = 0; i < this.procel.length; ++i) {
            if (!this.procel[i].isSelected()) continue;
            pi[k] = this.procel[i].pi;
            this.procel[i].clear();
            ++k;
        }
        return pi;
    }

    ProcessItem[] makeProcess() {
        ProcessItem[] proi = new ProcessItem[]{new ProcessItem("G4PionMinusInelasticProcess", "PionMinusInelastic", "\u03c0- inel", "model?", "ordInActive", "ordInActive", "ordDefault"), new ProcessItem("G4PionPlusInelasticProcess", "PionPlusInelastic", "\u03c0+ inel", "model?", "ordInActive", "ordInActive", "ordDefault"), new ProcessItem("G4KaonMinusInelasticProcess", "KaonMinusInelastic", "K- inel", "model?", "ordInActive", "ordInActive", "ordDefault"), new ProcessItem("G4KaonPlusInelasticProcess", "KaonPlusInelastic", "K+ inel", "model?", "ordInActive", "ordInActive", "ordDefault"), new ProcessItem("G4KaonZeroLInelasticProcess", "KaonZeroLInelastic", "K0L inel", "model?", "ordInActive", "ordInActive", "ordDefault"), new ProcessItem("G4KaonZeroSInelasticProcess", "KaonZeroSInelastic", "K0S inel", "model?", "ordInActive", "ordInActive", "ordDefault"), new ProcessItem("G4ProtonInelasticProcess", "ProtonInelastic", "p inel", "model?", "ordInActive", "ordInActive", "ordDefault"), new ProcessItem("G4NeutronInelasticProcess", "NeutronInelastic", "n inel", "model?", "ordInActive", "ordInActive", "ordDefault"), new ProcessItem("G4LambdaInelasticProcess", "LambdaInelastic", "\u039b inel", "model?", "ordInActive", "ordInActive", "ordDefault"), new ProcessItem("G4SigmaPlusInelasticProcess", "SigmaPlusInelastic", "\u03a3+ inel", "model?", "ordInActive", "ordInActive", "ordDefault"), new ProcessItem("G4SigmaMinusInelasticProcess", "SigmaMinusInelastic", "\u03a3- inel", "model?", "ordInActive", "ordInActive", "ordDefault"), new ProcessItem("G4XiZeroInelasticProcess", "XiZeroInelastic", "\u039e0 inel", "model?", "ordInActive", "ordInActive", "ordDefault"), new ProcessItem("G4XiMinusInelasticProcess", "XiMinusInelastic", "\u039e- inel", "model?", "ordInActive", "ordInActive", "ordDefault"), new ProcessItem("G4OmegaMinusInelasticProcess", "OmegaMinusInelastic", "\u03a9- inel", "model?", "ordInActive", "ordInActive", "ordDefault"), new ProcessItem("G4AntiProtonInelasticProcess", "anti_ProtonInelastic", "anti-p inel", "model?", "ordInActive", "ordInActive", "ordDefault"), new ProcessItem("G4AntiNeutronInelasticProcess", "anti_NeutronInelastic", "anti-n inel", "model?", "ordInActive", "ordInActive", "ordDefault"), new ProcessItem("G4AntiLambdaInelasticProcess", "anti_LambdaInelastic", "anti-\u039b inel", "model?", "ordInActive", "ordInActive", "ordDefault"), new ProcessItem("G4AntiSigmaPlusInelasticProcess", "anti_SigmaPlusInelastic", "anti-\u03a3+ inel", "model?", "ordInActive", "ordInActive", "ordDefault"), new ProcessItem("G4AntiSigmaMinusInelasticProcess", "anti_SigmaMinusInelastic", "anti-\u03a3- inel", "model?", "ordInActive", "ordInActive", "ordDefault"), new ProcessItem("G4AntiXiZeroInelasticProcess", "anti_XiZeroInelastic", "anti-\u039e0 inel", "model?", "ordInActive", "ordInActive", "ordDefault"), new ProcessItem("G4AntiXiMinusInelasticProcess", "anti_XiMinusInelastic", "anti-\u039e- inel", "model?", "ordInActive", "ordInActive", "ordDefault"), new ProcessItem("G4AntiOmegaMinusInelasticProcess", "anti_OmegaMinusInelastic", "anti-\u03a9- inel", "model?", "ordInActive", "ordInActive", "ordDefault"), new ProcessItem("G4AlphaInelasticProcess", "AlphaInelastic", "\u03b1 inel", "model?", "ordInActive", "ordInActive", "ordDefault"), new ProcessItem("G4DeuteronInelasticProcess", "DeuteronInelastic", "d inel", "model?", "ordInActive", "ordInActive", "ordDefault"), new ProcessItem("G4TritonInelasticProcess", "TritonInelastic", "triton inel", "model?", "ordInActive", "ordInActive", "ordDefault"), new ProcessItem("G4HadronCaptureProcess", "HadronCapture", "capture", "model?", "ordInActive", "ordInActive", "ordDefault"), new ProcessItem("G4HadronFissionProcess", "HadronFission", "fission", "model?", "ordInActive", "ordInActive", "ordDefault"), new ProcessItem("G4HadronElasticProcess", "HadronElastic", "elastic", "model?", "ordInActive", "ordInActive", "ordDefault"), new ProcessItem("G4PiMinusAbsorptionAtRest", "PiMinusAbsorptionAtRest", "\u03c0- absorp", "no model", "ordDefault", "ordInActive", "ordInActive"), new ProcessItem("G4PionMinusAbsorptionAtRest", "PionMinusAbsorptionAtRest", "\u03c0- absorp", "no model", "ordDefault", "ordInActive", "ordInActive"), new ProcessItem("G4KaonMinusAbsorptionAtRest", "KaonMinusAbsorptionAtRest", "K- absorp", "no model", "ordDefault", "ordInActive", "ordInActive"), new ProcessItem("G4MuonMinusCaptureAtRest", "MuonMinusCaptureAtRest", "muon- capt", "no model", "ordDefault", "ordInActive", "ordInActive"), new ProcessItem("G4AntiProtonAnnihilationAtRest", "anti-p annih", "anti-p annih", "no model", "ordDefault", "ordInActive", "ordInActive"), new ProcessItem("G4NeutronCaptureAtRest", "NeutronCaptureAtRest", "n capt", "no model", "ordDefault", "ordInActive", "ordInActive"), new ProcessItem("G4AntiNeutronAnnihilationAtRest", "AntiNeutronAnnihilationAtRest", "anti-n annih", "no model", "ordDefault", "ordInActive", "ordInActive")};
        return proi;
    }
}

