/*
 * Decompiled with CFR 0.152.
 */
package GPE;

import GPE.GPETableModel;
import GPE.PhysicsFrame;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableColumn;

public abstract class PhysicsAbstTable
extends JTable
implements ActionListener {
    protected JButton createButton;
    protected JButton deleteButton;
    protected JButton openProcButton;
    protected JButton openHProcButton;
    protected String tableTitle;
    PhysicsFrame parent;
    protected GPETableModel model;

    PhysicsAbstTable(GPETableModel model, PhysicsFrame parent) {
        super(model);
        this.model = model;
        this.parent = parent;
        this.setAutoCreateColumnsFromModel(false);
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(true);
        this.setFont(new Font("Serif", 1, 11));
        this.getTableHeader().setReorderingAllowed(false);
        this.setSelectionMode(0);
        JTextField tf = new JTextField();
        TableColumn column = new TableColumn();
        column = this.getColumn("Particle");
        column.sizeWidthToFit();
        column.setResizable(true);
        column = this.getColumn("Process");
        column.sizeWidthToFit();
        column.setResizable(true);
        column = this.getColumn("AtRest");
        column.setCellEditor(new DefaultCellEditor(tf));
        column.sizeWidthToFit();
        column.setResizable(true);
        column = this.getColumn("AlongStep");
        column.setCellEditor(new DefaultCellEditor(tf));
        column.sizeWidthToFit();
        column.setResizable(true);
        column = this.getColumn("PostStep");
        column.setCellEditor(new DefaultCellEditor(tf));
        column.sizeWidthToFit();
        column.setResizable(true);
    }

    public void delMatCloseAct() {
        this.deleteButton.setForeground(Color.black);
        this.deleteButton.repaint();
    }

    public void createMatCloseAct() {
        this.createButton.setForeground(Color.black);
        this.createButton.repaint();
    }

    public boolean isCellEditable(int row, int column) {
        return column != 0 && column != 1;
    }

    void stopEditing() {
        if (this.isEditing()) {
            this.cellEditor.stopCellEditing();
        }
        this.clearSelection();
    }

    Object getSelectedName() {
        if (this.isEditing()) {
            this.cellEditor.stopCellEditing();
        }
        Vector data = this.model.getDataVector();
        int row = this.getSelectedRow();
        if (row < 0) {
            return null;
        }
        return ((Vector)data.elementAt(row)).elementAt(0);
    }

    public void valueChanged(ListSelectionEvent lse) {
        super.valueChanged(lse);
        if (lse.getValueIsAdjusting()) {
            this.selected();
        }
    }

    public void columnSelectionChanged(ListSelectionEvent e) {
        super.columnSelectionChanged(e);
        if (e.getValueIsAdjusting()) {
            return;
        }
    }

    protected abstract void selected();
}

