/*
 * Decompiled with CFR 0.152.
 */
package GPE;

import GPE.AbstractGPEFrame;
import GPE.EMParticlesTable;
import GPE.ExampleFileFilter;
import GPE.GPETableModel;
import GPE.HadParticlesTable;
import GPE.HadronProcessesTable;
import GPE.ParticleItem;
import GPE.PhysicsEMTable;
import GPE.PhysicsHadTable;
import GPE.ProcessItem;
import GPE.ProcessesTable;
import GPE.SourceFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class PhysicsFrame
extends AbstractGPEFrame
implements ActionListener {
    Date today = new Date();
    public EMParticlesTable emParTable;
    public HadParticlesTable hadParTable;
    public ProcessesTable proTable;
    public HadronProcessesTable hadronproTable;
    public PhysicsEMTable phyEMTable;
    public PhysicsHadTable phyHadTable;
    public SourceFrame source;
    public SourceFrame include;
    GPETableModel emDataModel;
    GPETableModel hadDataModel;
    public JTextField physicsClassName;
    public String workdirpath = ".";
    JTextField cutValue;
    JComboBox lengthCombo;
    String[] emNames = new String[]{"Particle", "Process", "AtRest", "AlongStep", "PostStep"};
    String[] hadNames = new String[]{"Particle", "Process", "Model", "Generator", "Transport", "AtRest", "AlongStep", "PostStep"};
    String[] allBosons = new String[]{"\u03b3", "geantino", "chargedgeantino"};
    String[] allLeptons = new String[]{"e-", "\u03bc-", "\u03c4-", "anti-\u03bde", "anti-\u03bd\u03bc", "anti-\u03bd\u03c4", "e+", "\u03bc+", "\u03c4+", "\u03bde", "\u03bd\u03bc", "\u03bd\u03c4"};
    String[] allEMMesons = new String[]{"\u03c0+", "\u03c0-", "\u03c00", "\u03b7", "\u03b7\u0374", "K+", "K-", "K0", "K0S", "K0L", "anti-K0", "D+", "D-", "D0", "anti-D0", "Ds+", "Ds-", "B+", "B-", "B0", "Bs0", "anti-B0", "anti-Bs0", "\u03a8"};
    String[] allHadMesons = new String[]{"\u03c0+", "\u03c0-", "K+", "K-", "K0", "K0S", "K0L", "anti-K0"};
    String[] allEMBaryons = new String[]{"p", "n", "anti-p", "anti-n", "\u039b", "\u03a3+", "\u03a30", "\u03a3-", "\u039e0", "\u039e-", "\u03a9-", "anti-\u039b", "anti-\u03a3+", "anti-\u03a30", "anti-\u03a3-", "anti-\u039e0", "anti-\u039e-", "anti-\u03a9-", "\u039bc+", "\u03a3c++", "\u03a3c+", "\u03a3c0", "\u039ec+", "\u039ec0", "\u03a9c0", "anti-\u039bc+", "anti-\u03a3c++", "anti-\u03a3c+", "anti-\u03a3c0", "anti-\u039ec+", "anti-\u039ec0", "anti-\u03a9c0"};
    String[] allHadBaryons = new String[]{"p", "n", "anti-p", "anti-n", "\u039b", "\u03a3+", "\u03a30", "\u03a3-", "\u039e0", "\u039e-", "\u03a9-", "anti-\u039b", "anti-\u03a3+", "anti-\u03a30", "anti-\u03a3-", "anti-\u039e0", "anti-\u039e-", "anti-\u03a9-"};
    String[] allIons = new String[]{"\u03b1", "d", "He3", "triton", "GenericIon"};
    JLabel label;
    private JMenuItem load;
    private JMenuItem save;
    private JMenuItem append;
    private JMenuItem clear;
    private JMenuItem exit;
    private JMenuItem particleOpen;
    private JMenuItem particleClose;
    private JMenuItem cpp;
    private JMenuItem chh;
    private JMenuItem processOpen;
    private JMenuItem processClose;
    private JFileChooser saveData;
    private JFileChooser loadData;
    private String fileName;
    private String createFile;
    private String newFile;
    static String fileDir;
    private JFrame appendParticleMessage;
    private JFrame insertEMParticleMessage;
    private JFrame insertHadParticleMessage;
    private JFrame chooseParticleMessage;
    private JFrame deleteRowMessage;
    private JFrame chooseProcessMessage;
    private JFrame changeProcessMessage;

    public PhysicsFrame() {
        super("Geant4 Physics Editor");
        this.emParTable = new EMParticlesTable(this);
        this.hadParTable = new HadParticlesTable(this);
        this.proTable = new ProcessesTable(this);
        this.hadronproTable = new HadronProcessesTable(this);
        this.emDataModel = new GPETableModel(this.emNames, 0);
        this.phyEMTable = new PhysicsEMTable(this.emDataModel, this);
        this.hadDataModel = new GPETableModel(this.hadNames, 0);
        this.phyHadTable = new PhysicsHadTable(this.hadDataModel, this);
        this.source = new SourceFrame();
        this.include = new SourceFrame();
        this.setLayout(new FlowLayout(0, 15, 2));
        this.add(this.createMenubar());
        this.add(this.makePhysicsClassNamePanel());
        this.add(this.makeTablePanel());
        this.setVisible(true);
    }

    private JPanel makeTablePanel() {
        JPanel makeTablePanel = new JPanel();
        JTabbedPane parprocTabbedPane = new JTabbedPane();
        ImageIcon icon = new ImageIcon("yellow-ball.gif");
        parprocTabbedPane.addTab("EM Particles", icon, this.emParTable);
        parprocTabbedPane.addTab("EM Processes", icon, this.proTable);
        parprocTabbedPane.setForegroundAt(0, Color.blue);
        parprocTabbedPane.setForegroundAt(1, Color.blue);
        makeTablePanel.setLayout(new BorderLayout());
        JSplitPane splitPane = new JSplitPane(0, true, this.phyEMTable.makeEMPanel(), parprocTabbedPane);
        makeTablePanel.add((Component)splitPane, "Center");
        return makeTablePanel;
    }

    private JMenuBar createMenubar() {
        JMenuBar mb = new JMenuBar();
        JMenu file = new JMenu("File");
        file.setForeground(Color.blue);
        this.load = new JMenuItem("Load  Physics File");
        file.add(this.load);
        file.addSeparator();
        this.save = new JMenuItem("Save Physics Table");
        file.add(this.save);
        file.addSeparator();
        this.clear = new JMenuItem("Clear Physics Table");
        file.add(this.clear);
        this.load.addActionListener(this);
        this.save.addActionListener(this);
        this.clear.addActionListener(this);
        mb.add(file);
        JMenu make = new JMenu("Make");
        make.setForeground(Color.blue);
        this.cpp = new JMenuItem("Make C++ Source");
        make.add(this.cpp);
        this.chh = new JMenuItem("Make Header file");
        make.add(this.chh);
        this.cpp.addActionListener(this);
        this.chh.addActionListener(this);
        mb.add(make);
        return mb;
    }

    public JPanel makePhysicsClassNamePanel() {
        String[] lengthName = new String[]{"mm", "cm", "m"};
        JLabel textFieldTitle = new JLabel("Enter PhysicsClassName", 0);
        textFieldTitle.setFont(new Font("Serif", 1, 12));
        Dimension titlesize = textFieldTitle.getPreferredSize();
        textFieldTitle.setSize(titlesize);
        JLabel defaultCutValue = new JLabel("Enter defaultCutValue", 0);
        defaultCutValue.setFont(new Font("Serif", 1, 12));
        Dimension cutValuesize = defaultCutValue.getPreferredSize();
        defaultCutValue.setSize(cutValuesize);
        JPanel textFieldPanel = new JPanel();
        textFieldPanel.setLayout(new FlowLayout(0, 15, 2));
        textFieldPanel.add(textFieldTitle);
        this.physicsClassName = new JTextField(20);
        textFieldPanel.add(this.physicsClassName);
        textFieldPanel.add(defaultCutValue);
        this.cutValue = new JTextField(7);
        textFieldPanel.add(this.cutValue);
        this.lengthCombo = new JComboBox<String>(lengthName);
        this.lengthCombo.setSelectedItem(lengthName[0]);
        textFieldPanel.add(this.lengthCombo);
        return textFieldPanel;
    }

    public String getPhysicsClassName() {
        String myName = this.physicsClassName.getText();
        return myName;
    }

    public void actionPerformed(ActionEvent ae) {
        Object o = ae.getSource();
        if (o == this.load) {
            this.PhysicsfileLoad();
        }
        if (o == this.save) {
            this.PhysicsfileSave();
        }
        if (o == this.clear) {
            this.PhysicsfileClear();
        }
        if (o == this.cpp && this.getCPP() != "") {
            this.source.setVisible(true);
            this.source.editor.setText(this.getCPP());
        }
        if (o == this.chh && this.getCHH() != "") {
            this.include.setVisible(true);
            this.include.editor.setText(this.getCHH());
        }
    }

    private synchronized void resume() {
        this.notify();
    }

    public void openProc() {
        this.proTable.setVisible(true);
    }

    public void openHProc() {
        this.hadronproTable.setVisible(true);
    }

    void PhysicsfileAppend() {
        JFileChooser loadData = new JFileChooser(this.workdirpath);
        loadData.cancelSelection();
        loadData.resetChoosableFileFilters();
        ExampleFileFilter mtFile = new ExampleFileFilter("g4ph", "PhysicsSource");
        loadData.setFileFilter(mtFile);
        loadData.setDialogTitle("Load Physics");
        loadData.setMultiSelectionEnabled(true);
        if (loadData.showOpenDialog(this) != 0) {
            return;
        }
        File fml = loadData.getSelectedFile();
        this.fileName = fml.getPath();
        if (fml.isFile()) {
            this.resume();
            try {
                FileInputStream filein = new FileInputStream(this.fileName);
                ObjectInputStream objin = new ObjectInputStream(filein);
                Vector mtData = (Vector)objin.readObject();
                Vector emData = (Vector)mtData.firstElement();
                if (this.emDataModel.getRowCount() != 0 || emData.size() != 0) {
                    for (int i = 0; i < emData.size(); ++i) {
                        Vector em = (Vector)emData.elementAt(i);
                        this.emDataModel.addRow(em);
                    }
                    this.repaint();
                }
                objin.close();
                this.repaint();
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
        } else {
            System.out.println("error=" + fml.toString() + "isNotaFile");
        }
    }

    public void PhysicsfileLoad() {
        JFileChooser loadData = new JFileChooser(this.workdirpath);
        loadData.cancelSelection();
        loadData.resetChoosableFileFilters();
        ExampleFileFilter mtFile = new ExampleFileFilter("g4ph", "PhysicsSource");
        loadData.setFileFilter(mtFile);
        loadData.setDialogTitle("Load Physics");
        if (loadData.showOpenDialog(this) != 0) {
            return;
        }
        loadData.setMultiSelectionEnabled(true);
        File fml = loadData.getSelectedFile();
        this.fileName = fml.getPath();
        if (fml.isFile()) {
            this.resume();
            try {
                int i;
                FileInputStream filein = new FileInputStream(this.fileName);
                ObjectInputStream objin = new ObjectInputStream(filein);
                Vector mtData = (Vector)objin.readObject();
                Vector emData = (Vector)mtData.elementAt(0);
                Vector hadData = (Vector)mtData.elementAt(1);
                Object physicsClassNameObject = mtData.elementAt(2);
                String physicsClassNameString = physicsClassNameObject.toString();
                Object cutValueObject = mtData.elementAt(3);
                String cutValueString = cutValueObject.toString();
                Object lengthComboObject = mtData.elementAt(4);
                if (this.emDataModel.getRowCount() != 0 || emData.size() != 0) {
                    this.emDataModel = new GPETableModel(this.emNames, 0);
                    this.phyEMTable.setModel(this.emDataModel);
                    for (i = 0; i < emData.size(); ++i) {
                        Vector em = (Vector)emData.elementAt(i);
                        this.emDataModel.addRow(em);
                    }
                    this.repaint();
                }
                if (this.hadDataModel.getRowCount() != 0 || hadData.size() != 0) {
                    this.hadDataModel = new GPETableModel(this.hadNames, 0);
                    this.phyHadTable.setModel(this.hadDataModel);
                    for (i = 0; i < hadData.size(); ++i) {
                        Vector had = (Vector)hadData.elementAt(i);
                        this.hadDataModel.addRow(had);
                    }
                    this.repaint();
                }
                this.physicsClassName.setText(physicsClassNameString);
                this.repaint();
                this.cutValue.setText(cutValueString);
                this.repaint();
                this.lengthCombo.setSelectedItem(lengthComboObject);
                this.repaint();
                objin.close();
                this.repaint();
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
        } else {
            System.out.println("error=" + fml.toString() + "isNotaFile");
        }
    }

    public void PhysicsfileSave() {
        JFileChooser saveData = new JFileChooser(this.workdirpath);
        ExampleFileFilter mtFile = new ExampleFileFilter("g4ph", "PhysicsSource");
        saveData.setFileFilter(mtFile);
        saveData.setDialogTitle("Save Physics");
        if (saveData.showSaveDialog(this) != 0) {
            return;
        }
        File fms = saveData.getSelectedFile();
        this.fileName = fms.getPath();
        if (this.fileName != null) {
            try {
                FileOutputStream fileout = new FileOutputStream(this.fileName);
                ObjectOutputStream objout = new ObjectOutputStream(fileout);
                Vector<Object> mtVector = new Vector<Object>();
                mtVector.addElement(this.emDataModel.getDataVector());
                mtVector.addElement(this.hadDataModel.getDataVector());
                mtVector.addElement(this.physicsClassName.getText());
                mtVector.addElement(this.cutValue.getText());
                mtVector.addElement(this.lengthCombo.getSelectedItem());
                objout.writeObject(mtVector);
                objout.flush();
                fileout.close();
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
            return;
        }
        if (this.fileName == null) {
            return;
        }
    }

    public void PhysicsfileClear() {
        this.emDataModel = new GPETableModel(this.emNames, 0);
        this.phyEMTable.setModel(this.emDataModel);
        this.hadDataModel = new GPETableModel(this.hadNames, 0);
        this.phyHadTable.setModel(this.hadDataModel);
    }

    public void appendEMParticle() {
        ParticleItem[] eis = this.emParTable.getSelectedElements();
        Object[] tmp = new Object[5];
        tmp[1] = "Null";
        tmp[2] = "";
        tmp[3] = "";
        tmp[4] = "";
        if (eis == null) {
            this.appendParticleMessage = new JFrame();
            JOptionPane.showMessageDialog(this.appendParticleMessage, "Choose a Particle or allParticles from the Table", "Warning Dialog", 2);
            return;
        }
        if (eis[0].symbol == "all bosons") {
            for (int i = 0; i < this.allBosons.length; ++i) {
                tmp[0] = this.allBosons[i];
                this.emDataModel.addRow(tmp);
            }
        } else if (eis[0].symbol == "all leptons") {
            for (int i = 0; i < this.allLeptons.length; ++i) {
                tmp[0] = this.allLeptons[i];
                this.emDataModel.addRow(tmp);
            }
        } else if (eis[0].symbol == "all mesons") {
            for (int i = 0; i < this.allEMMesons.length; ++i) {
                tmp[0] = this.allEMMesons[i];
                this.emDataModel.addRow(tmp);
            }
        } else if (eis[0].symbol == "all baryons") {
            for (int i = 0; i < this.allEMBaryons.length; ++i) {
                tmp[0] = this.allEMBaryons[i];
                this.emDataModel.addRow(tmp);
            }
        } else if (eis[0].symbol == "all ions") {
            for (int i = 0; i < this.allIons.length; ++i) {
                tmp[0] = this.allIons[i];
                this.emDataModel.addRow(tmp);
            }
        } else if (eis[0].symbol == "all shortlived") {
            tmp[0] = "all shortlived";
            this.emDataModel.addRow(tmp);
        } else {
            tmp[0] = new String(eis[0].symbol);
            this.emDataModel.addRow(tmp);
        }
    }

    public void appendHadParticle() {
        ParticleItem[] eis = this.hadParTable.getSelectedElements();
        Object[] tmp = new Object[5];
        tmp[1] = "Null";
        tmp[2] = "";
        tmp[3] = "";
        tmp[4] = "";
        if (eis == null) {
            this.appendParticleMessage = new JFrame();
            JOptionPane.showMessageDialog(this.appendParticleMessage, "Choose a Particle or allParticles from the Table", "Warning Dialog", 2);
            return;
        }
        if (eis[0].symbol == "all bosons") {
            for (int i = 0; i < this.allBosons.length; ++i) {
                tmp[0] = this.allBosons[i];
                this.hadDataModel.addRow(tmp);
            }
        } else if (eis[0].symbol == "all mesons") {
            for (int i = 0; i < this.allHadMesons.length; ++i) {
                tmp[0] = this.allHadMesons[i];
                this.hadDataModel.addRow(tmp);
            }
        } else if (eis[0].symbol == "all baryons") {
            for (int i = 0; i < this.allHadBaryons.length; ++i) {
                tmp[0] = this.allHadBaryons[i];
                this.hadDataModel.addRow(tmp);
            }
        } else if (eis[0].symbol == "all ions") {
            for (int i = 0; i < this.allIons.length; ++i) {
                tmp[0] = this.allIons[i];
                this.hadDataModel.addRow(tmp);
            }
        } else if (eis[0].symbol == "all shortlived") {
            tmp[0] = "all shortlived";
            this.hadDataModel.addRow(tmp);
        } else {
            tmp[0] = new String(eis[0].symbol);
            this.hadDataModel.addRow(tmp);
        }
    }

    public void insertEMParticle() {
        ParticleItem[] eis = this.emParTable.getSelectedElements();
        Object[] tmp = new Object[5];
        tmp[1] = "Null";
        tmp[2] = "";
        tmp[3] = "";
        tmp[4] = "";
        int emRow = this.phyEMTable.getSelectedRow();
        int emCol = this.phyEMTable.getSelectedColumn();
        boolean emCel = this.phyEMTable.isCellSelected(emRow, emCol);
        if (eis == null) {
            this.insertEMParticleMessage = new JFrame();
            JOptionPane.showMessageDialog(this.insertEMParticleMessage, "Choose a Particle or allParticles from the Table", "Warning Dialog", 2);
            return;
        }
        if (emCel) {
            if (eis[0].symbol == "all bosons") {
                for (int i = 0; i < this.allBosons.length; ++i) {
                    tmp[0] = this.allBosons[i];
                    int emRowCount = this.phyEMTable.getSelectedRow() + 1;
                    this.emDataModel.insertRow(emRowCount + i, tmp);
                }
            } else if (eis[0].symbol == "all leptons") {
                for (int i = 0; i < this.allLeptons.length; ++i) {
                    tmp[0] = this.allLeptons[i];
                    int emRowCount = this.phyEMTable.getSelectedRow() + 1;
                    this.emDataModel.insertRow(emRowCount + i, tmp);
                }
            } else if (eis[0].symbol == "all mesons") {
                for (int i = 0; i < this.allEMMesons.length; ++i) {
                    tmp[0] = this.allEMMesons[i];
                    int emRowCount = this.phyEMTable.getSelectedRow() + 1;
                    this.emDataModel.insertRow(emRowCount + i, tmp);
                }
            } else if (eis[0].symbol == "all baryons") {
                for (int i = 0; i < this.allEMBaryons.length; ++i) {
                    tmp[0] = this.allEMBaryons[i];
                    int emRowCount = this.phyEMTable.getSelectedRow() + 1;
                    this.emDataModel.insertRow(emRowCount + i, tmp);
                }
            } else if (eis[0].symbol == "all ions") {
                for (int i = 0; i < this.allIons.length; ++i) {
                    tmp[0] = this.allIons[i];
                    int emRowCount = this.phyEMTable.getSelectedRow() + 1;
                    this.emDataModel.insertRow(emRowCount + i, tmp);
                }
            } else if (eis[0].symbol == "all shortlived") {
                tmp[0] = "all shortlived";
                int emRowCount = this.phyEMTable.getSelectedRow() + 1;
                this.emDataModel.insertRow(emRowCount, tmp);
            } else {
                tmp[0] = new String(eis[0].symbol);
                int emRowCount = this.phyEMTable.getSelectedRow() + 1;
                this.emDataModel.insertRow(emRowCount, tmp);
            }
        } else if (!emCel) {
            this.chooseParticleMessage = new JFrame();
            JOptionPane.showMessageDialog(this.chooseParticleMessage, "Choose a Particle's Name", "Warning Dialog", 2);
            return;
        }
    }

    public void insertHadParticle() {
        ParticleItem[] eis = this.hadParTable.getSelectedElements();
        Object[] tmp = new Object[5];
        tmp[1] = "Null";
        tmp[2] = "";
        tmp[3] = "";
        tmp[4] = "";
        int hadRow = this.phyHadTable.getSelectedRow();
        int hadCol = this.phyHadTable.getSelectedColumn();
        boolean hadCel = this.phyHadTable.isCellSelected(hadRow, hadCol);
        if (eis == null) {
            this.insertHadParticleMessage = new JFrame();
            JOptionPane.showMessageDialog(this.insertHadParticleMessage, "Choose a Particle or allParticles from the Table", "Warning Dialog", 2);
            return;
        }
        if (hadCel) {
            if (eis[0].symbol == "all bosons") {
                for (int i = 0; i < this.allBosons.length; ++i) {
                    tmp[0] = this.allBosons[i];
                    int hadRowCount = this.phyHadTable.getSelectedRow() + 1;
                    this.hadDataModel.insertRow(hadRowCount + i, tmp);
                }
            } else if (eis[0].symbol == "all mesons") {
                for (int i = 0; i < this.allHadMesons.length; ++i) {
                    tmp[0] = this.allHadMesons[i];
                    int hadRowCount = this.phyHadTable.getSelectedRow() + 1;
                    this.hadDataModel.insertRow(hadRowCount + i, tmp);
                }
            } else if (eis[0].symbol == "all baryons") {
                for (int i = 0; i < this.allHadBaryons.length; ++i) {
                    tmp[0] = this.allHadBaryons[i];
                    int hadRowCount = this.phyHadTable.getSelectedRow() + 1;
                    this.hadDataModel.insertRow(hadRowCount + i, tmp);
                }
            } else if (eis[0].symbol == "all ions") {
                for (int i = 0; i < this.allIons.length; ++i) {
                    tmp[0] = this.allIons[i];
                    int hadRowCount = this.phyHadTable.getSelectedRow() + 1;
                    this.hadDataModel.insertRow(hadRowCount + i, tmp);
                }
            } else if (eis[0].symbol == "all shortlived") {
                tmp[0] = "all shortlived";
                int hadRowCount = this.phyHadTable.getSelectedRow() + 1;
                this.hadDataModel.insertRow(hadRowCount, tmp);
            } else {
                tmp[0] = new String(eis[0].symbol);
                int hadRowCount = this.phyHadTable.getSelectedRow() + 1;
                this.hadDataModel.insertRow(hadRowCount, tmp);
            }
        } else if (!hadCel) {
            this.chooseParticleMessage = new JFrame();
            JOptionPane.showMessageDialog(this.chooseParticleMessage, "Choose a Particle's Name", "Warning Dialog", 2);
            return;
        }
    }

    public void deleteRow() {
        int emRow = this.phyEMTable.getSelectedRow();
        int emCol = this.phyEMTable.getSelectedColumn();
        int hadRow = this.phyHadTable.getSelectedRow();
        int hadCol = this.phyHadTable.getSelectedColumn();
        boolean emCel = this.phyEMTable.isCellSelected(emRow, emCol);
        boolean hadCel = this.phyHadTable.isCellSelected(hadRow, hadCol);
        if (emCel) {
            this.emDataModel.removeRow(this.phyEMTable.getSelectedRow());
            this.repaint();
        }
        if (hadCel) {
            this.hadDataModel.removeRow(this.phyHadTable.getSelectedRow());
            this.repaint();
        }
        if (!emCel && !hadCel) {
            this.deleteRowMessage = new JFrame();
            JOptionPane.showMessageDialog(this.deleteRowMessage, "Choose a Particle's Name", "Warning Dialog", 2);
        }
    }

    public void changeProcess() {
        ProcessItem[] pis = this.proTable.getSelectedProcess();
        int emRow = this.phyEMTable.getSelectedRow();
        int emCol = this.phyEMTable.getSelectedColumn();
        boolean emCel = this.phyEMTable.isCellSelected(emRow, emCol);
        if (pis == null) {
            this.chooseProcessMessage = new JFrame();
            JOptionPane.showMessageDialog(this.chooseProcessMessage, "Choose a EM Process from the Table", "Warning Dialog", 2);
            return;
        }
        if (emCel) {
            Object[] tmp = new Object[5];
            tmp[0] = new String(pis[0].name);
            tmp[1] = new String(pis[0].At);
            tmp[2] = new String(pis[0].Along);
            tmp[3] = new String(pis[0].Post);
            int phyEMTablerow = this.phyEMTable.getSelectedRow();
            if (phyEMTablerow != -1) {
                this.emDataModel.setValueAt(tmp[0], phyEMTablerow, 1);
                this.emDataModel.setValueAt(tmp[1], phyEMTablerow, 2);
                this.emDataModel.setValueAt(tmp[2], phyEMTablerow, 3);
                this.emDataModel.setValueAt(tmp[3], phyEMTablerow, 4);
                this.repaint();
            }
        } else if (!emCel) {
            this.changeProcessMessage = new JFrame();
            JOptionPane.showMessageDialog(this.changeProcessMessage, "Choose a Particle's Name", "Warning Dialog", 2);
            return;
        }
    }

    public void changeHadronProcess() {
        ProcessItem[] pis = this.hadronproTable.getSelectedProcess();
        int hadRow = this.phyHadTable.getSelectedRow();
        int hadCol = this.phyHadTable.getSelectedColumn();
        boolean hadCel = this.phyHadTable.isCellSelected(hadRow, hadCol);
        if (pis == null) {
            this.chooseProcessMessage = new JFrame();
            JOptionPane.showMessageDialog(this.chooseProcessMessage, "Choose a Hadronic Process from the Table", "Warning Dialog", 2);
            return;
        }
        if (hadCel) {
            Object[] tmp = new Object[]{new String(pis[0].name), new String(pis[0].At), new String(pis[0].Along), new String(pis[0].Post)};
            int phyHadTablerow = this.phyHadTable.getSelectedRow();
            if (phyHadTablerow != -1) {
                this.hadDataModel.setValueAt(tmp[0], phyHadTablerow, 1);
                this.hadDataModel.setValueAt(tmp[1], phyHadTablerow, 5);
                this.hadDataModel.setValueAt(tmp[2], phyHadTablerow, 6);
                this.hadDataModel.setValueAt(tmp[3], phyHadTablerow, 7);
                this.repaint();
            }
        } else if (!hadCel) {
            this.changeProcessMessage = new JFrame();
            JOptionPane.showMessageDialog(this.changeProcessMessage, "Choose a Particle's Name", "Warning Dialog", 2);
            return;
        }
    }

    void setLoadData(Vector materialData) {
    }

    void phyEMTableSelected() {
        this.phyHadTable.stopEditing();
    }

    void phyHadTableSelected() {
        this.phyEMTable.stopEditing();
    }

    public void windowIconified(WindowEvent event) {
        this.emParTable.setVisible(false);
        this.hadParTable.setVisible(false);
        this.phyEMTable.stopEditing();
        this.phyHadTable.stopEditing();
    }

    public void windowDeiconified(WindowEvent event) {
        this.emParTable.setVisible(true);
        this.hadParTable.setVisible(true);
    }

    public String getCHH() {
        String myName = this.physicsClassName.getText();
        StringTokenizer st = new StringTokenizer(myName);
        if (!st.hasMoreTokens()) {
            JFrame noNameMessage = new JFrame();
            JOptionPane.showMessageDialog(noNameMessage, "Type in your ClassName", "Warning Dialog", 2);
            return "";
        }
        StringBuffer physchh = new StringBuffer("\n// Physics List Header File \n");
        physchh.append("//   " + myName + ".hh generated by Geant4 Physics Editor at " + this.today.toString() + "  \n\n");
        physchh.append("\n #ifndef  " + myName + "_h\n");
        physchh.append("#define  " + myName + "_h  1\n\n");
        physchh.append("#include \"G4VUserPhysicsList.hh\"\n");
        physchh.append("class  " + myName + ":  public G4VUserPhysicsList\n");
        physchh.append("   {");
        physchh.append("      public:\n");
        physchh.append("      " + myName + "();\n");
        physchh.append("      virtual ~" + myName + "();\n\n");
        physchh.append("  protected:\n");
        physchh.append("    virtual void ConstructParticle();\n");
        physchh.append("    virtual void ConstructProcess();\n");
        physchh.append("    virtual void SetCuts();\n");
        physchh.append("  protected:\n");
        physchh.append("    virtual void ConstructBosons();\n");
        physchh.append("    virtual void ConstructLeptons();\n");
        physchh.append("    virtual void ConstructMesons();\n");
        physchh.append("    virtual void ConstructBaryons();\n");
        physchh.append("  protected:\n");
        physchh.append("    virtual void ConstructGeneral();\n");
        physchh.append("    virtual void ConstructEM();\n");
        physchh.append("    virtual void ConstructAllShortLiveds();\n");
        physchh.append("  };\n");
        physchh.append("#endif\n");
        return physchh.toString();
    }

    public String getCPP() {
        String myParticle;
        int i;
        Vector rowData;
        String myName = this.physicsClassName.getText();
        String myCutValue = this.cutValue.getText();
        StringTokenizer stName = new StringTokenizer(myName);
        StringTokenizer stCut = new StringTokenizer(myCutValue);
        if (!stName.hasMoreTokens() || !stCut.hasMoreTokens()) {
            JFrame noNameMessage = new JFrame();
            JOptionPane.showMessageDialog(noNameMessage, "Type in your ClassName AND CutValue", "Warning Dialog", 2);
            return "";
        }
        StringBuffer physcpp = new StringBuffer("\n// " + myName + ".cc \n\n");
        Vector data = this.emDataModel.getDataVector();
        physcpp.append("//  generated by Geant4 Physics Editor at   " + this.today.toString() + "\n\n");
        physcpp.append("#include \"" + myName + ".hh\"\n\n");
        physcpp.append("#include \"globals.hh\"\n");
        physcpp.append("#include \"G4ParticleDefinition.hh\"\n");
        physcpp.append("#include \"G4ParticleWithCuts.hh\"\n");
        physcpp.append("#include \"G4ProcessManager.hh\"\n");
        physcpp.append("#include \"G4ProcessVector.hh\"\n");
        physcpp.append("#include \"G4ParticleTypes.hh\"\n");
        physcpp.append("#include \"G4ParticleTable.hh\"\n");
        physcpp.append("#include \"G4ShortLivedConstructor.hh\"\n");
        physcpp.append("#include \"G4Material.hh\"\n");
        physcpp.append("#include \"G4MaterialTable.hh\"\n\n");
        physcpp.append("#include \"G4ios.hh\"\n\n");
        physcpp.append(myName + "::" + myName + "():  G4VUserPhysicsList()\n{\n");
        physcpp.append("// Here used the default cut value you have typed in\n\n");
        physcpp.append("  defaultCutValue = " + myCutValue + "*" + (String)this.lengthCombo.getSelectedItem() + ";\n");
        physcpp.append("  SetVerboseLevel(1);\n}\n\n");
        physcpp.append(myName + "::~" + myName + "()\n{}\n\n");
        physcpp.append("void " + myName + "::ConstructParticle()\n{\n");
        physcpp.append("// Here are constructed all particles you have chosen\n\n");
        physcpp.append("  ConstructBosons();\n");
        physcpp.append("  ConstructLeptons();\n");
        physcpp.append("  ConstructMesons();\n");
        physcpp.append("  ConstructBaryons();\n");
        physcpp.append("  ConstructAllShortLiveds();\n}\n\n");
        physcpp.append("// In this method, static member functions should be called for ALL particles to be used.\n\n");
        physcpp.append("void " + myName + "::ConstructBosons()\n{\n");
        boolean[] bosonsBoolean = new boolean[]{false, false, false};
        String[] bosonsDefinition = new String[]{"  G4Geantino::GeantinoDefinition();", "  G4ChargedGeantino::ChargedGeantinoDefinition();", "  G4Gamma::GammaDefinition();"};
        for (int i2 = 0; i2 < data.size(); ++i2) {
            rowData = (Vector)data.elementAt(i2);
            String myParticle2 = rowData.elementAt(0).toString();
            for (int ii = 0; ii < this.allBosons.length; ++ii) {
                if (!myParticle2.equals(this.allBosons[ii]) || bosonsBoolean[ii]) continue;
                physcpp.append(bosonsDefinition[ii]);
                physcpp.append("\n");
                bosonsBoolean[ii] = true;
            }
        }
        physcpp.append("}\n");
        physcpp.append("void " + myName + "::ConstructLeptons()\n{\n");
        boolean[] leptonsBoolean = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false};
        String[] leptonsDefinition = new String[]{"  G4Electron::ElectronDefinition();", "  G4MuonMinus::MuonMinusDefinition();", "  G4TauMinus::TauMinusDefinition();", "  G4AntiNeutrinoE::AntiNeutrinoEDefinition();", "  G4AntiNeutrinoMu::AntiNeutrinoMuDefinition();", "  G4AntiNeutrinoTau::AntiNeutrinoTauDefinition();", "  G4Positron::PositronDefinition();", "  G4MuonPlus::MuonPlusDefinition();", "  G4TauPlus::TauPlusDefinition();", "  G4NeutrinoE::NeutrinoEDefinition();", "  G4NeutrinoMu::NeutrinoMuDefinition();", "  G4NeutrinoTau::NeutrinoTauDefinition();"};
        for (int i3 = 0; i3 < data.size(); ++i3) {
            rowData = (Vector)data.elementAt(i3);
            String myParticle3 = rowData.elementAt(0).toString();
            for (int ii = 0; ii < this.allLeptons.length; ++ii) {
                if (!myParticle3.equals(this.allLeptons[ii]) || leptonsBoolean[ii]) continue;
                physcpp.append(leptonsDefinition[ii]);
                physcpp.append("\n");
                leptonsBoolean[ii] = true;
            }
        }
        physcpp.append("}\n");
        physcpp.append("void " + myName + "::ConstructMesons()\n{\n");
        boolean[] mesonsBoolean = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
        String[] mesonsDefinition = new String[]{"  G4PionPlus::PionPlusDefinition();", "  G4PionMinus::PionMinusDefinition();", "  G4PionZero::PionZeroDefinition();", "  G4Eta::EtaDefinition();", "  G4EtaPrime::EtaPrimeDefinition();", "  G4RhoZero::RhoZeroDefinition();", "  G4KaonPlus::KaonPlusDefinition();", "  G4KaonMinus::KaonMinusDefinition();", "  G4KaonZero::KaonZeroDefinition();", "  G4KaonZeroShort::KaonZeroShortDefinition();", "  G4KaonZeroLong::KaonZeroLongDefinition();", "  G4AntiKaonZero::AntiKaonZeroDefinition();", "  G4DMesonPlus::DMesonPlusDefinition();", "  G4DMesonMinus::DMesonMinusDefinition();", "  G4DMesonZero::DMesonZeroDefinition();", "  G4AntiDMesonZero::AntiDMesonZeroDefinition();", "  G4DsMesonPlus::DsMesonPlusDefinition();", "  G4DsMesonMinus::DsMesonMinusDefinition();", "  G4BMesonPlus::BMesonPlusDefinition();", "  G4BMesonMinus::BMesonMinusDefinition();", "  G4BMesonZero::BMesonZeroDefinition();", "  G4BsMesonZero::BsMesonZeroDefinition();", "  G4AntiBMesonZero::AntiBMesonZeroDefinition();", "  G4AntiBsMesonZero::AntiBsMesonZeroDefinition();", "  G4JPsi::JPsiDefinition();"};
        for (int i4 = 0; i4 < data.size(); ++i4) {
            rowData = (Vector)data.elementAt(i4);
            String myParticle4 = rowData.elementAt(0).toString();
            for (int ii = 0; ii < this.allEMMesons.length; ++ii) {
                if (!myParticle4.equals(this.allEMMesons[ii]) || mesonsBoolean[ii] || ii == 5) continue;
                physcpp.append(mesonsDefinition[ii]);
                physcpp.append("\n");
                mesonsBoolean[ii] = true;
            }
        }
        physcpp.append("}\n");
        physcpp.append("void " + myName + "::ConstructBaryons()\n{\n");
        boolean[] baryonsBoolean = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
        String[] baryonsDefinition = new String[]{"  G4Proton::ProtonDefinition();", "  G4Neutron::NeutronDefinition();", "  G4AntiProton::AntiProtonDefinition();", "  G4AntiNeutron::AntiNeutronDefinition();", "  G4Lambda::LambdaDefinition();", "  G4SigmaPlus::SigmaPlusDefinition();", "  G4SigmaZero::SigmaZeroDefinition();", "  G4SigmaMinus::SigmaMinusDefinition();", "  G4XiZero::XiZeroDefinition();", "  G4XiMinus::XiMinusDefinition();", "  G4OmegaMinus::OmegaMinusDefinition();", "  G4AntiLambda::AntiLambdaDefinition();", "  G4AntiSigmaPlus::AntiSigmaPlusDefinition();", "  G4AntiSigmaZero::AntiSigmaZeroDefinition();", "  G4AntiSigmaMinus::AntiSigmaMinusDefinition();", "  G4AntiXiZero::AntiXiZeroDefinition();", "  G4AntiXiMinus::AntiXiMinusDefinition();", "  G4AntiOmegaMinus::AntiOmegaMinusDefinition();", "  G4LambdacPlus::LambdacPlusDefinition();", "  G4SigmacPlusPlus::SigmacPlusPlusDefinition();", "  G4SigmacPlus::SigmacPlusDefinition();", "  G4SigmacZero::SigmacZeroDefinition();", "  G4XicPlus::XicPlusDefinition();", "  G4XicZero::XicZeroDefinition();", "  G4OmegacZero::OmegacZeroDefinition();", "  G4AntiLambdacPlus::AntiLambdacPlusDefinition();", "  G4AntiSigmacPlusPlus::AntiSigmacPlusPlusDefinition();", "  G4AntiSigmacPlus::AntiSigmacPlusDefinition();", "  G4AntiSigmacZero::AntiSigmacZeroDefinition();", "  G4AntiXicPlus::AntiXicPlusDefinition();", "  G4AntiXicZero::AntiXicZeroDefinition();", "  G4AntiOmegacZero::AntiOmegacZeroDefinition();"};
        for (int i5 = 0; i5 < data.size(); ++i5) {
            rowData = (Vector)data.elementAt(i5);
            String myParticle5 = rowData.elementAt(0).toString();
            for (int ii = 0; ii < this.allEMBaryons.length; ++ii) {
                if (!myParticle5.equals(this.allEMBaryons[ii]) || baryonsBoolean[ii]) continue;
                physcpp.append(baryonsDefinition[ii]);
                physcpp.append("\n");
                baryonsBoolean[ii] = true;
            }
        }
        physcpp.append("}\n");
        physcpp.append("void " + myName + "::ConstructAllShortLiveds()\n{\n");
        physcpp.append("// Here are contructed all short liveds\n\n");
        boolean allshortlived = false;
        for (int i6 = 0; i6 < data.size(); ++i6) {
            rowData = (Vector)data.elementAt(i6);
            String myParticle6 = rowData.elementAt(0).toString();
            if (!myParticle6.equals("all shortlived") || allshortlived) continue;
            physcpp.append("  G4ShortLivedConstructor pConstructor;\n");
            physcpp.append("  pConstructor.ConstructParticle();\n");
            allshortlived = true;
        }
        physcpp.append("}\n");
        physcpp.append("void " + myName + "::ConstructProcess()\n{\n");
        physcpp.append("// Transportation, electromagnetic and general processes \n\n");
        physcpp.append("  AddTransportation();\n");
        physcpp.append("  ConstructEM();\n");
        physcpp.append("  ConstructGeneral();\n}\n");
        String[] allProcesses = new String[]{"Compton", "PolarizedCompton", "GammaConv", "PhotoElectric", "eIonisation", "eBrems", "e+Annihilation", "SynchrotronRad", "eIonisationPlus", "eBremsPlus", "hIonisation", "ionIonisation", "IeIonisation", "IeBrems", "Ie+Annihilation", "IMultipleScatt", "IhIonisation", "MultipleScatt", "MuIonisation", "MuBrems", "MuPairProd", "IMuIonisation", "IMuBrems", "IMuPairProd", "Cerenkov", "Scintillation", "LECompton", "LEGammaConv", "LEPhotoElec", "LERayleigh", "LEIonisation", "LEBrems", "hLEIonisation"};
        boolean[] processesBoolean = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
        String[] processesDefinition = new String[]{"#include \"G4ComptonScattering.hh\"", "#include \"G4PolarizedComptonScattering.hh\"", "#include \"G4GammaConversion.hh\"", "#include \"G4PhotoElectricEffect.hh\"", "#include \"G4eIonisation.hh\"", "#include \"G4eBremsstrahlung.hh\"", "#include \"G4eplusAnnihilation.hh\"", "#include \"G4SynchrotronRadiation.hh\"", "#include \"G4eIonisationPlus.hh\"", "#include \"G4eBremsstrahlungPlus.hh\"", "#include \"G4hIonisation.hh\"", "#include \"G4ionIonisation.hh\"", "#include \"G4IeIonisation.hh\"", "#include \"G4IeBremsstrahlung.hh\"", "#include \"G4IeplusAnnihilation.hh\"", "#include \"G4IMultipleScattering.hh\"", "#include \"G4IhIonisation.hh\"", "#include \"G4MultipleScattering.hh\"", "#include \"G4MuIonisation.hh\"", "#include \"G4MuBremsstrahlung.hh\"", "#include \"G4MuPairProduction.hh\"", "#include \"G4IMuIonisation.hh\"", "#include \"G4IMuBremsstrahlung.hh\"", "#include \"G4IMuPairProduction.hh\"", "#include \"G4Cerenkov.hh\"", "#include \"G4Scintillation.hh\"", "#include \"G4LowEnergyCompton.hh\"", "#include \"G4LowEnergyGammaConversion.hh\"", "#include \"G4LowEnergyPhotoElectric.hh\"", "#include \"G4LowEnergyRayleigh.hh\"", "#include \"G4LowEnergyIonisation.hh\"", "#include \"G4LowEnergyBremsstrahlung.hh\"", "#include \"G4hLowEnergyIonisation.hh\""};
        physcpp.append("// Here are respective header files for chosen processes\n\n");
        for (i = 0; i < data.size(); ++i) {
            rowData = (Vector)data.elementAt(i);
            myParticle = rowData.elementAt(0).toString();
            for (int ii = 0; ii < allProcesses.length; ++ii) {
                if (!rowData.elementAt(1).equals(allProcesses[ii]) || processesBoolean[ii]) continue;
                physcpp.append(processesDefinition[ii]);
                physcpp.append("\n");
                processesBoolean[ii] = true;
            }
        }
        physcpp.append("\n");
        physcpp.append("// The next two processes are always included.\n\n");
        physcpp.append("#include \"G4hIonisation.hh\"\n");
        physcpp.append("#include \"G4MultipleScattering.hh\"\n");
        physcpp.append("void " + myName + "::ConstructEM()\n{\n");
        physcpp.append("  theParticleIterator->reset();\n");
        physcpp.append("  while( (*theParticleIterator)() ){\n");
        physcpp.append("    G4ParticleDefinition* particle = theParticleIterator->value();\n");
        physcpp.append("    G4ProcessManager* pmanager = particle->GetProcessManager();\n");
        physcpp.append("    G4String particleName = particle->GetParticleName();\n\n");
        physcpp.append("// The next processes are always added.\n\n");
        physcpp.append("    if ((!particle->IsShortLived()) &&\n");
        physcpp.append("         (particle->GetPDGCharge() != 0.0 )&&\n");
        physcpp.append("           (particle->GetParticleName() != \"e-\") &&\n");
        physcpp.append("           (particle->GetParticleName() != \"e+\") &&\n");
        physcpp.append("           (particle->GetParticleName() != \"mu-\") &&\n");
        physcpp.append("           (particle->GetParticleName() != \"mu+\") &&\n");
        physcpp.append("           (particle->GetParticleName() != \"chargedgeantino\")){\n");
        physcpp.append("      pmanager->AddProcess(new G4MultipleScattering(), -1, 1, 1);\n");
        physcpp.append("      pmanager->AddProcess(new G4hIonisation(), -1, 2, 2);\n");
        physcpp.append("    }\n");
        physcpp.append("// Each if clause corresponds to a row in the PhysicsTable\n\n");
        for (i = 0; i < data.size(); ++i) {
            rowData = (Vector)data.elementAt(i);
            if (rowData.elementAt(2).equals("")) continue;
            myParticle = rowData.elementAt(0).toString();
            ParticleItem[] pari = this.emParTable.makeParticle();
            for (int ii = 0; ii < pari.length; ++ii) {
                if (!myParticle.equals(pari[ii].symbol) || rowData.elementAt(1).equals("Null")) continue;
                physcpp.append("    if (particleName == \"" + pari[ii].name + "\") {\n");
            }
            ProcessItem[] proi = this.proTable.makeProcess();
            for (int iii = 0; iii < proi.length; ++iii) {
                if (rowData.elementAt(1).equals("Null") || !rowData.elementAt(1).equals(proi[iii].name)) continue;
                physcpp.append("      pmanager->AddProcess(new " + proi[iii].G4name + "()," + rowData.elementAt(2) + "," + rowData.elementAt(3) + "," + rowData.elementAt(4) + ");\n    }\n");
            }
        }
        physcpp.append("  }\n");
        physcpp.append("}\n");
        physcpp.append("\n");
        physcpp.append("#include \"G4Decay.hh\"\n\n");
        physcpp.append("void " + myName + "::ConstructGeneral()\n{\n");
        physcpp.append("  G4Decay* theDecayProcess = new G4Decay();\n");
        physcpp.append("  theParticleIterator->reset();\n");
        physcpp.append("  while( (*theParticleIterator)() ){\n");
        physcpp.append("    G4ParticleDefinition* particle = theParticleIterator->value();\n");
        physcpp.append("    G4ProcessManager* pmanager = particle->GetProcessManager();\n");
        physcpp.append("    if (theDecayProcess->IsApplicable(*particle)) {\n");
        physcpp.append("      pmanager ->AddProcess(theDecayProcess);\n");
        physcpp.append("      pmanager ->SetProcessOrdering(theDecayProcess, idxPostStep);\n");
        physcpp.append("      pmanager ->SetProcessOrdering(theDecayProcess, idxAtRest);\n");
        physcpp.append("    }\n  }\n}\n\n");
        physcpp.append("void " + myName + "::SetCuts()\n{\n");
        physcpp.append("// defaultCutValue you have typed in is used\n\n");
        physcpp.append("  if (verboseLevel >1){\n");
        physcpp.append("    G4cout << \"" + myName + "::SetCuts:\";\n  }\n");
        physcpp.append("  SetCutsWithDefault();\n");
        physcpp.append("}\n");
        return physcpp.toString();
    }
}

