/*
 * Decompiled with CFR 0.152.
 */
import GAG.GAG;
import GGE.SourceFrame;
import GGE.VolumesFrame;
import GPE.PhysicsFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Date;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class TabbedPaneFrame
extends JFrame
implements ChangeListener,
ActionListener {
    private JFileChooser fileChooser;
    private String fileName;
    JMenuBar mbar;
    JMenu fileJM;
    JMenu projectJM;
    JMenu helpJM;
    JMenu XMLJM;
    JTabbedPane momotabbedPane;
    JButton g4workdirBT;
    JTextField g4target;
    JTextField g4workdir;
    private MOMOpipe pipeMake;
    private MOMOpipe pipeClean;
    private ErrStream errStreamMake;
    private ErrStream errStreamClean;
    EnvPanel envPanel;
    EnvVariable envVars;
    String[] envName;
    String g4workdirpath;
    PhysicsFrame physicsFrame;
    VolumesFrame volumesFrame;
    SourceFrame momomake;
    SourceFrame mainprog;
    GAG gagPanel;
    static final String MENU_NAME_ATTRIBUTE = "name";
    static final String MENU_ACTION_ATTRIBUTE = "action";
    static final String MENU_ITEM_NAME = "MENU-ITEM";
    static final String MENU_NAME = "MENU";

    public TabbedPaneFrame() {
        this.setTitle("momo");
        try {
            ClassLoader loader = this.getClass().getClassLoader();
            String menuDef = "MenuML-momo.xml";
            URL url = loader != null ? loader.getResource(menuDef) : ClassLoader.getSystemResource(menuDef);
            this.mbar = this.getXMLJMenu(url);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        JPanel g4targetbase = new JPanel();
        g4targetbase.setLayout(new BoxLayout(g4targetbase, 0));
        container.add(g4targetbase);
        this.setJMenuBar(this.mbar);
        this.momomake = new SourceFrame();
        this.mainprog = new SourceFrame();
        this.g4target = new JTextField();
        this.g4target.setColumns(30);
        g4targetbase.add(new JLabel("Typein G4TARGET name"));
        g4targetbase.add(this.g4target);
        g4targetbase.add(Box.createHorizontalGlue());
        this.g4workdirBT = new JButton("set GEANT4 WORKDIR");
        EnvVariable envVars = new EnvVariable();
        this.g4workdirpath = String.valueOf(envVars.get("G4WORKDIR"));
        this.g4workdir = new JTextField(this.g4workdirpath);
        this.g4workdirBT.addActionListener(this);
        this.g4workdir.addActionListener(this);
        g4targetbase.add(this.g4workdirBT);
        g4targetbase.add(this.g4workdir);
        this.setSize(900, 700);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.momotabbedPane = new JTabbedPane();
        this.momotabbedPane.addChangeListener(this);
        this.envPanel = new EnvPanel();
        this.physicsFrame = new PhysicsFrame();
        this.volumesFrame = new VolumesFrame();
        this.gagPanel = new GAG();
        ImageIcon icon = new ImageIcon("yellow-ball.gif");
        this.momotabbedPane.addTab("Env Vars", icon, this.envPanel);
        this.momotabbedPane.setForegroundAt(0, Color.red);
        this.momotabbedPane.addTab("em Physics", icon, this.physicsFrame);
        this.momotabbedPane.setForegroundAt(1, Color.blue);
        this.momotabbedPane.addTab("Volumes", icon, this.volumesFrame);
        this.momotabbedPane.addTab("Materials", icon, this.volumesFrame.matFrame);
        this.momotabbedPane.setForegroundAt(2, Color.cyan);
        this.momotabbedPane.setForegroundAt(3, Color.magenta);
        this.momotabbedPane.addTab("GAG", icon, this.gagPanel);
        this.momotabbedPane.setForegroundAt(4, Color.darkGray);
        container.add((Component)this.momotabbedPane, "Center");
        this.setPath(this.g4workdirpath);
    }

    public void getPath() {
        JFrame frame = new JFrame("HIBMC HOME PATH");
        Container c = frame.getContentPane();
        JLabel label = new JLabel("Enter the Absolute Path of HIBMC");
        c.add(label);
        JTextField text = new JTextField("/home/");
        text.setColumns(20);
        c.add(text);
        JButton button = new JButton("...");
        button.addActionListener(this);
        JFileChooser dataPath = new JFileChooser(".");
        dataPath.setDialogTitle("HIBMC Data Directory");
        dataPath.setDialogType(2);
        dataPath.setFileSelectionMode(1);
        if (dataPath.showDialog(this, "choose") == 1) {
            return;
        }
        File fl = dataPath.getCurrentDirectory();
        System.out.println();
        text.setText(fl.getPath());
    }

    public void gagrun() {
        this.gagPanel.mainLoop();
    }

    public void actionPerformed(ActionEvent ae) {
        JOptionPane opane;
        FileView fv;
        Object o = ae.getSource();
        String cmd = ae.getActionCommand();
        if (cmd.equals("emPhy")) {
            this.momotabbedPane.setSelectedIndex(1);
        }
        if (cmd.equals("LoadPhyData")) {
            this.momotabbedPane.setSelectedIndex(1);
            this.physicsFrame.PhysicsfileLoad();
        }
        if (cmd.equals("SavePhyData")) {
            this.momotabbedPane.setSelectedIndex(1);
            this.physicsFrame.PhysicsfileSave();
        }
        if (cmd.equals("ClearPhyData")) {
            this.momotabbedPane.setSelectedIndex(1);
            this.physicsFrame.PhysicsfileClear();
        }
        if (cmd.equals("MakePhyC++") && this.physicsFrame.getCPP() != "") {
            this.momotabbedPane.setSelectedIndex(1);
            this.physicsFrame.source.setVisible(true);
            this.physicsFrame.source.editor.setText(this.physicsFrame.getCPP());
        }
        if (cmd.equals("MakePhyHead") && this.physicsFrame.getCHH() != "") {
            this.momotabbedPane.setSelectedIndex(1);
            this.physicsFrame.include.setVisible(true);
            this.physicsFrame.include.editor.setText(this.physicsFrame.getCHH());
        }
        if (cmd.equals("LoadVolData")) {
            this.momotabbedPane.setSelectedIndex(2);
            this.volumesFrame.GGEfileLoad();
        }
        if (cmd.equals("LoadVolXMLData")) {
            this.momotabbedPane.setSelectedIndex(2);
            this.volumesFrame.XMLfileLoad();
        }
        if (cmd.equals("AddVolData")) {
            this.momotabbedPane.setSelectedIndex(2);
            this.volumesFrame.GGEfileAppend();
        }
        if (cmd.equals("SaveVolData")) {
            this.momotabbedPane.setSelectedIndex(2);
            this.volumesFrame.GGEfileSave();
        }
        if (cmd.equals("SaveVolXMLData")) {
            this.momotabbedPane.setSelectedIndex(2);
            this.volumesFrame.XMLfileSave();
        }
        if (cmd.equals("ClearVolData")) {
            this.momotabbedPane.setSelectedIndex(2);
            this.volumesFrame.volClear();
        }
        if (cmd.equals("LoadMatData")) {
            this.momotabbedPane.setSelectedIndex(3);
            this.volumesFrame.matFrame.MaterialfileLoad();
        }
        if (cmd.equals("LoadMatXMLData")) {
            this.momotabbedPane.setSelectedIndex(3);
            this.volumesFrame.matFrame.MaterialXMLfileLoad();
        }
        if (cmd.equals("AddMatData")) {
            this.momotabbedPane.setSelectedIndex(3);
            this.volumesFrame.matFrame.MaterialfileAppend();
        }
        if (cmd.equals("SaveMatData")) {
            this.momotabbedPane.setSelectedIndex(3);
            this.volumesFrame.matFrame.MaterialfileSave();
        }
        if (cmd.equals("SaveMatXMLData")) {
            this.momotabbedPane.setSelectedIndex(3);
            this.volumesFrame.matFrame.MaterialXMLfileSave();
        }
        if (cmd.equals("ClearMatData")) {
            this.momotabbedPane.setSelectedIndex(3);
            this.volumesFrame.matFrame.MaterialfileClear();
        }
        if (cmd.equals("OpenMatElem")) {
            this.momotabbedPane.setSelectedIndex(3);
            this.volumesFrame.matFrame.et.setVisible(true);
        }
        if (cmd.equals("CloseMatElem")) {
            this.momotabbedPane.setSelectedIndex(3);
            this.volumesFrame.matFrame.et.setVisible(false);
        }
        if (cmd.equals("G4StartGAG")) {
            this.momotabbedPane.setSelectedIndex(4);
            this.gagPanel.execG4();
        }
        if (cmd.equals("ContinueGAG")) {
            this.momotabbedPane.setSelectedIndex(4);
            this.gagPanel.continueG4();
        }
        if (cmd.equals("G4ExitGAG")) {
            this.momotabbedPane.setSelectedIndex(4);
            this.gagPanel.exitG4();
        }
        if (cmd.equals("G4KillGAG")) {
            this.momotabbedPane.setSelectedIndex(4);
            this.gagPanel.killG4();
        }
        if (cmd.equals("ClearGAGHisOne")) {
            this.momotabbedPane.setSelectedIndex(4);
            this.gagPanel.clearOne();
        }
        if (cmd.equals("ClearGAGHisAll")) {
            this.momotabbedPane.setSelectedIndex(4);
            this.gagPanel.clearAll();
        }
        if (cmd.equals("SaveGAGHis")) {
            this.momotabbedPane.setSelectedIndex(4);
            this.gagPanel.saveHist();
        }
        if (cmd.equals("exit")) {
            System.exit(0);
        }
        if (cmd.equals("MOMOHelp")) {
            fv = new FileView("MOMOHelp.html");
            fv.setVisible(true);
        }
        if (cmd.equals("MOMOHelpjp")) {
            fv = new FileView("MOMOHelp_AD.html");
            fv.setVisible(true);
        }
        if (cmd.equals("Maire")) {
            fv = new FileView("MaireCourse.html");
            fv.setVisible(true);
        }
        if (cmd.equals("Makefile")) {
            if (this.g4target.getText().trim().equals("")) {
                opane = new JOptionPane();
                JOptionPane.showMessageDialog(this, "Please Specify the Target Name", "Warning Dialog", 2);
                JDialog dialog = opane.createDialog(this, "Warning Dialog");
                try {
                    Class<?> targetClass = dialog.getClass();
                    Class[] parameters = new Class[]{Boolean.TYPE};
                    Method method = targetClass.getDeclaredMethod("setAlwaysOnTop", parameters);
                    Object targetInstance = targetClass.newInstance();
                    Object[] params = new Object[]{new boolean[]{true}};
                    if (System.getProperty("java.version").equals("1.5.0")) {
                        method.invoke(targetInstance, params);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                return;
            }
            StringBuffer gmake = new StringBuffer(this.getMakefile());
            this.momomake.setVisible(true);
            this.momomake.editor.setText(this.getMakefile());
            this.fileName = "Momomake.gmk";
        }
        if (cmd.equals("MainProgram")) {
            if (this.g4target.getText().trim().equals("")) {
                opane = new JOptionPane();
                JOptionPane.showMessageDialog(this, "Please Specify the Target Name", "Warning Dialog", 2);
                JDialog dialog = opane.createDialog(this, "Warning Dialog");
                try {
                    Class<?> targetClass = dialog.getClass();
                    Class[] parameters = new Class[]{Boolean.TYPE};
                    Method method = targetClass.getDeclaredMethod("setAlwaysOnTop", parameters);
                    Object targetInstance = targetClass.newInstance();
                    Object[] params = new Object[]{new boolean[]{true}};
                    if (System.getProperty("java.version").equals("1.5.0")) {
                        method.invoke(targetInstance, params);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                return;
            }
            try {
                StringBuffer maincc = new StringBuffer(this.getMain());
                this.mainprog.setVisible(true);
                this.mainprog.editor.setText(this.getMain());
                String mainfileName = this.g4target.getText() + ".cc";
                FileOutputStream mainfile = new FileOutputStream(mainfileName);
                PrintWriter mainoutPut = new PrintWriter(new DataOutputStream(mainfile));
                mainoutPut.println(maincc.toString());
                mainoutPut.close();
            }
            catch (IOException ie) {
                System.out.println(ie.toString());
            }
        } else if (cmd.equals("Compile")) {
            String cmdMake = "make -f Momomake.gmk";
            System.out.println(cmdMake);
            this.pipeMake = new MOMOpipe(cmdMake);
            if (this.pipeMake == null) {
                System.out.println("MOMOpipe error");
            } else {
                this.errStreamMake = new ErrStream(this.pipeMake);
                this.errStreamMake.start();
            }
        } else if (cmd.equals("MakeClean")) {
            String cmdClean = "make clean -f Momomake.gmk";
            this.pipeClean = new MOMOpipe(cmdClean);
            if (this.pipeClean == null) {
                System.out.println("MOMOpipe error");
            } else {
                this.errStreamClean = new ErrStream(this.pipeClean);
                this.errStreamClean.start();
            }
        } else if (o == this.g4workdirBT) {
            this.loadPath();
            this.setPath(this.g4workdir.getText());
        } else if (o == this.g4workdir) {
            this.g4workdirpath = this.g4workdir.getText();
            this.setPath(this.g4workdirpath);
        }
    }

    public void setPath(String path) {
        if (path.equals("null")) {
            path = ".";
        }
        this.volumesFrame.workdirpath = path;
        this.volumesFrame.sf.workdirpath = path;
        this.volumesFrame.includesf.workdirpath = path;
        this.volumesFrame.xmlf.workdirpath = path;
        this.volumesFrame.matFrame.workdirpath = path;
        this.physicsFrame.workdirpath = path;
        this.physicsFrame.source.workdirpath = path;
        this.physicsFrame.include.workdirpath = path;
        this.gagPanel.workdirpath = path;
        this.momomake.workdirpath = path;
        this.mainprog.workdirpath = path;
    }

    public void stateChanged(ChangeEvent event) {
        JTabbedPane pane = (JTabbedPane)event.getSource();
        if (pane.getSelectedComponent() == null) {
            int n = pane.getSelectedIndex();
            String title = pane.getTitleAt(n);
            ImageIcon planetIcon = new ImageIcon(title + ".gif");
            pane.setComponentAt(n, new JLabel(planetIcon));
            pane.setIconAt(n, new ImageIcon("red-ball.gif"));
        }
    }

    String getMakefile() {
        StringBuffer gmake = new StringBuffer("##### GNUmakefile #####\n");
        gmake.append("# ----------------------------------------------------------\n");
        gmake.append("# Script defining rules and paths for making binaries.\n");
        gmake.append("# ----------------------------------------------------------\n");
        gmake.append("# Automatic creation of GNUmakefile for Momo environment.\n");
        gmake.append("# with users selection of G4TARGET, UI and VIS variables\n");
        gmake.append("#  Momo is the name of legendary samurai who conquered bad geants. ----   H. Yoshida.\n");
        gmake.append("\n");
        gmake.append("name := " + this.g4target.getText() + "\n");
        gmake.append("G4TARGET := $(name)\n");
        gmake.append("G4EXLIB := true\n");
        gmake.append("\n");
        gmake.append("# Vis/GUI used\n");
        int i = 0;
        while (true) {
            if (i >= EnvPanel.visguiuseName.length) break;
            if (this.envPanel.checkU[i].isSelected()) {
                gmake.append(EnvPanel.visguiuseName[i] + " := 1\n");
            }
            ++i;
        }
        gmake.append("# Vis/GUI built\n");
        i = 0;
        while (true) {
            if (i >= EnvPanel.visguibuildName.length) break;
            if (this.envPanel.checkB[i].isSelected()) {
                gmake.append(EnvPanel.visguibuildName[i] + " := 1\n");
            }
            ++i;
        }
        gmake.append("\n");
        gmake.append("# General Envs defined\n");
        i = 0;
        while (true) {
            if (i >= EnvPanel.envName.length) break;
            if (!this.envPanel.textF[i].getText().trim().equals("null")) {
                gmake.append(EnvPanel.envName[i] + ":=" + this.envPanel.textF[i].getText() + "\n");
            }
            ++i;
        }
        gmake.append("\n");
        gmake.append("ifndef G4INSTALL\n");
        gmake.append("   G4INSTALL = ../../..\n");
        gmake.append("endif\n");
        gmake.append("\n");
        gmake.append(".PHONY: all\n");
        gmake.append("all: lib bin\n");
        gmake.append("\n");
        gmake.append("  include $(G4INSTALL)/config/binmake.gmk\n");
        gmake.append("\n");
        return gmake.toString();
    }

    String getMain() {
        Date today = new Date();
        StringBuffer maincc = new StringBuffer("//##### MOMO Main program #####\n");
        maincc.append("//# ----------------------------------------------------------\n");
        maincc.append("//# Automatic creation of the main program for Momo environment.\n");
        maincc.append("// 2003 December, updated for  geant4.6.0\n");
        maincc.append("// --------------------------------------------------------------\n");
        maincc.append("//   " + this.g4target.getText() + ".cc generated by Geant4 Momo\n");
        maincc.append("//     at " + today.toString() + "  \n\n");
        maincc.append("\n");
        maincc.append("// This code implementation is the intellectual property of\n");
        maincc.append("// the  GEANT4 collaboration.\n");
        maincc.append("//\n");
        maincc.append("// By copying, distributing or modifying the Program (or any work\n");
        maincc.append("// based on the Program) you indicate your acceptance of this statement,\n");
        maincc.append("// and all its terms.\n");
        maincc.append("//\n");
        maincc.append("// \n");
        maincc.append("#include \"G4RunManager.hh\"\n");
        maincc.append("#include \"G4UImanager.hh\"\n");
        maincc.append("// Your choice of User Interface driver\n");
        maincc.append("#include \"G4UIGAG.hh\"\n");
        maincc.append("// Detector geometry generated by Momo's GGE\n");
        maincc.append("#include \"" + this.volumesFrame.classNameField.getText().trim() + ".hh\"\n");
        maincc.append("// Physics List generated by Momo's GPE\n");
        maincc.append("#include \"" + this.physicsFrame.physicsClassName.getText().trim() + ".hh\"\n");
        maincc.append("// Momo's default PrimaryGeneratorAction\n");
        maincc.append("#include \"MomoPrimaryGeneratorAction.hh\"\n");
        maincc.append("#include \"MomoRunAction.hh\"\n");
        maincc.append("#include \"MomoEventAction.hh\"\n");
        maincc.append("#ifdef G4VIS_USE\n");
        maincc.append("#include \"MomoVisManager.hh\"\n");
        maincc.append("#endif\n");
        maincc.append("int main()\n");
        maincc.append("{\n");
        maincc.append("  // Construct the default run manager\n");
        maincc.append("  G4RunManager* runManager = new G4RunManager;\n");
        maincc.append("  // set mandatory initialization classes\n");
        maincc.append("  runManager->SetUserInitialization(new " + this.volumesFrame.classNameField.getText().trim() + ");\n");
        maincc.append("  runManager->SetUserInitialization(new " + this.physicsFrame.physicsClassName.getText().trim() + ");\n");
        maincc.append("#ifdef G4VIS_USE\n");
        maincc.append("  // visualization manager\n");
        maincc.append("  G4VisManager* visManager = new MomoVisManager;\n");
        maincc.append("  visManager->Initialize();\n");
        maincc.append("#endif\n");
        maincc.append("  // set mandatory user action class\n");
        maincc.append("  runManager->SetUserAction(new MomoPrimaryGeneratorAction);\n");
        maincc.append("  // set user action classes to visualise trajectories\n");
        maincc.append("  runManager->SetUserAction(new MomoRunAction);\n");
        maincc.append("  runManager->SetUserAction(new MomoEventAction);\n");
        maincc.append("  // Initialize G4 kernel\n");
        maincc.append("  runManager->Initialize();\n");
        maincc.append("  // get the pointer to the User Interface manager \n");
        maincc.append("  G4UImanager* UI = G4UImanager::GetUIpointer();\n");
        maincc.append("      G4UIsession * session = new G4UIGAG;\n");
        maincc.append("      session->SessionStart();\n");
        maincc.append("      delete session;\n");
        maincc.append("  // job termination\n");
        maincc.append("#ifdef G4VIS_USE\n");
        maincc.append("  delete visManager;\n");
        maincc.append("#endif\n");
        maincc.append("  delete runManager;\n");
        maincc.append("  return 0;\n");
        maincc.append("}\n");
        return maincc.toString();
    }

    public void loadPath() {
        if (this.g4workdirpath.equals("null")) {
            this.g4workdirpath = ".";
        }
        JFileChooser dataPath = new JFileChooser(this.g4workdirpath);
        dataPath.setDialogTitle("set GEANT4 WORKDIR");
        dataPath.setDialogType(2);
        dataPath.setFileSelectionMode(2);
        if (dataPath.showDialog(this, "choose") == 1) {
            return;
        }
        File fl = dataPath.getCurrentDirectory();
        this.g4workdir.setText(fl.getPath());
        this.g4workdirpath = fl.getPath();
    }

    public static JMenuBar menuFactory(Document menuMLDocument, ActionListener al) {
        JMenuBar mbar = new JMenuBar();
        Element root = menuMLDocument.getDocumentElement();
        NodeList menus = root.getChildNodes();
        int numMenus = menus.getLength();
        for (int i = 0; i < numMenus; ++i) {
            Node menuNode = menus.item(i);
            NamedNodeMap attrs = menuNode.getAttributes();
            if (attrs == null) continue;
            Node name = attrs.getNamedItem(MENU_NAME_ATTRIBUTE);
            Node action = attrs.getNamedItem(MENU_ACTION_ATTRIBUTE);
            JMenu menu = new JMenu(name.getNodeValue());
            if (action != null) {
                menu.setActionCommand(action.getNodeValue());
            }
            mbar.add(menu);
            TabbedPaneFrame.processMenu(menuNode, menu, al);
        }
        return mbar;
    }

    private static void processMenu(Node menuNode, JMenu menu, ActionListener al) {
        NodeList children = menuNode.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            NamedNodeMap attrs;
            Node n = children.item(i);
            if (n.getNodeName().equals(MENU_ITEM_NAME)) {
                attrs = n.getAttributes();
                Node action = attrs.getNamedItem(MENU_ACTION_ATTRIBUTE);
                Node name = attrs.getNamedItem(MENU_NAME_ATTRIBUTE);
                JMenuItem item = new JMenuItem(name.getNodeValue());
                item.addActionListener(al);
                if (action != null) {
                    item.setActionCommand(action.getNodeValue());
                }
                menu.add(item);
                continue;
            }
            if (!n.getNodeName().equals(MENU_NAME)) continue;
            attrs = n.getAttributes();
            Node name = attrs.getNamedItem(MENU_NAME_ATTRIBUTE);
            JMenu submenu = new JMenu(name.getNodeValue());
            menu.add(submenu);
            TabbedPaneFrame.processMenu(n, submenu, al);
        }
    }

    public JMenuBar getXMLJMenu(URL fileName) throws Exception {
        DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = dbfactory.newDocumentBuilder();
        Document doc = builder.parse(fileName.toString());
        JMenuBar menu = TabbedPaneFrame.menuFactory(doc, this);
        return menu;
    }
}

