//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//##### MOMO Main program #####
//# ----------------------------------------------------------
//# Automatic creation of the main program for Momo environment.
// 2003 December, updated for  geant4.6.0
// --------------------------------------------------------------
//   linac.cc generated by Geant4 Momo
//     at Sat Nov 27 12:16:36 JST 2004  


// This code implementation is the intellectual property of
// the  GEANT4 collaboration.
//
// By copying, distributing or modifying the Program (or any work
// based on the Program) you indicate your acceptance of this statement,
// and all its terms.
//
// 
#include "G4RunManager.hh"
#include "G4UImanager.hh"
// Your choice of User Interface driver
#include "G4UIGAG.hh"
// Detector geometry generated by Momo's GGE
#include "flatteningFilter.hh"
// Physics List generated by Momo's GPE
#include "MomoN02PhysicsList.hh"
// Momo's default PrimaryGeneratorAction
#include "MomoPrimaryGeneratorAction.hh"
#include "MomoRunAction.hh"
#include "MomoEventAction.hh"
#ifdef G4VIS_USE
#include "MomoVisManager.hh"
#endif
int main()
{
  // Construct the default run manager
  G4RunManager* runManager = new G4RunManager;
  // set mandatory initialization classes
  runManager->SetUserInitialization(new flatteningFilter);
  runManager->SetUserInitialization(new MomoN02PhysicsList);
#ifdef G4VIS_USE
  // visualization manager
  G4VisManager* visManager = new MomoVisManager;
  visManager->Initialize();
#endif
  // set mandatory user action class
  runManager->SetUserAction(new MomoPrimaryGeneratorAction);
  // set user action classes to visualise trajectories
  runManager->SetUserAction(new MomoRunAction);
  runManager->SetUserAction(new MomoEventAction);
  // Initialize G4 kernel
  runManager->Initialize();
  // get the pointer to the User Interface manager 
  G4UImanager* UI = G4UImanager::GetUIpointer();
      G4UIsession * session = new G4UIGAG;
      session->SessionStart();
      delete session;
  // job termination
#ifdef G4VIS_USE
  delete visManager;
#endif
  delete runManager;
  return 0;
}

