//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//
// --------------------------------------------------------------
//                 GEANT 4 - ULTRA experiment example
// --------------------------------------------------------------
//
// Code developed by:
// B. Tome, M.C. Espirito-Santo, A. Trindade, P. Rodrigues 
//
//   **********************************************
//   *        UltraEventAction.hh
//   **********************************************
//
//    Ultra EventAction class. The UltraAnalysisManager class is used for histogram
//    filling if the G4ANALYSIS_USE environment variable is set.
//
#ifndef UltraEventAction_h
#define UltraEventAction_h 1

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo....
  
#include "UltraRunAction.hh"

#include "G4UserEventAction.hh"
#include "globals.hh"
#include "G4ThreeVector.hh"

class UltraRunAction;
class UltraPrimaryGeneratorAction;
class G4HCofThisEvent;

class UltraEventAction : public G4UserEventAction
{
  public:
    UltraEventAction(UltraRunAction*);
   ~UltraEventAction();

  public:
    void BeginOfEventAction(const G4Event*);
    void EndOfEventAction(const G4Event*);
    

    G4int GetRunNumb(){return UltraRun->GetRunNumb() ;} ;
    G4int GetEvtNumb(){return evtNb ;} ;

  private:
    UltraRunAction* UltraRun;
    G4int    evtNb ;

  private: 

    G4int OpticalHitsCollID ; 
};
    
#endif
