//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
// $Id: MedLinacPrimaryGeneratorMessenger.cc,v 1.5 2006/06/29 16:04:45 gunter Exp $
//
//
// Code developed by: M. Piergentili
//
#include "MedLinacPrimaryGeneratorMessenger.hh"

#include "MedLinacPrimaryGeneratorAction.hh"
#include "MedLinacRunAction.hh"
#include "G4UIdirectory.hh"
#include "G4UIcmdWithAString.hh"
#include "G4UIcmdWithADoubleAndUnit.hh"

MedLinacPrimaryGeneratorMessenger::MedLinacPrimaryGeneratorMessenger(MedLinacPrimaryGeneratorAction* MedLinacGun)
  :MedLinacAction(MedLinacGun)

{  
  EnergyCmd = new G4UIcmdWithADoubleAndUnit("/energy",this);
  EnergyCmd->SetGuidance("Select the energy (and unit) of the primary particles");
  EnergyCmd->SetGuidance("Type particle Energy");
  EnergyCmd->SetParameterName("energy",true,true);
  EnergyCmd->SetDefaultValue(1.);
  EnergyCmd->AvailableForStates(G4State_PreInit,G4State_Idle);

  SourceTypeCmd = new G4UIcmdWithADoubleAndUnit("/sourceType",this);
  SourceTypeCmd->SetGuidance("Select the standard deviation of the energy.");
  SourceTypeCmd->SetParameterName("standard deviation",true);
  SourceTypeCmd->SetDefaultValue(1.);
  SourceTypeCmd->AvailableForStates(G4State_PreInit,G4State_Idle);

}

void MedLinacPrimaryGeneratorMessenger::SetNewValue(G4UIcommand* command, G4String newValue)
{ 
  if( command == EnergyCmd )
    { 
      G4double newEnergy = EnergyCmd->GetNewDoubleValue(newValue);
      MedLinacAction->SetEnergy(newEnergy);
 G4cout << "Energy "<< newEnergy << G4endl; 
    }

  if( command == SourceTypeCmd )
 {
   G4double newSourceType = SourceTypeCmd->GetNewDoubleValue(newValue);
      MedLinacAction->SetSourceType(newSourceType);
    
      G4cout << "dev stand "<< newSourceType << G4endl;  
 }
}


MedLinacPrimaryGeneratorMessenger::~MedLinacPrimaryGeneratorMessenger()
{
  delete EnergyCmd;
  delete SourceTypeCmd;
}
