//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//
// $Id: TestEm10.cc,v 1.9 2007/07/27 17:52:04 vnivanch Exp $
// GEANT4 tag $Name: geant4-09-02 $
//
// 
// --------------------------------------------------------------
//      GEANT 4 - TestEm10 
//
// --------------------------------------------------------------
// Comments
//     
//   
// --------------------------------------------------------------

#include "G4RunManager.hh"
#include "G4UImanager.hh"
#include "G4UIterminal.hh"
#include "Randomize.hh"

#ifdef G4VIS_USE
#include "G4VisExecutive.hh"
#endif

#include "Em10DetectorConstruction.hh"
// #include "ALICEDetectorConstruction.hh"
#include "Em10PhysicsList.hh"
#include "Em10PrimaryGeneratorAction.hh"
#include "Em10RunAction.hh"
#include "Em10EventAction.hh"
#include "Em10SteppingAction.hh"
#include "Em10SteppingVerbose.hh"
#include "Em10TrackingAction.hh"
 
int main(int argc,char** argv) 
{

  //choose the Random engine

  CLHEP::HepRandom::setTheEngine(new CLHEP::RanecuEngine);
  
  //my Verbose output class

  G4VSteppingVerbose::SetInstance(new Em10SteppingVerbose);
    
  // Construct the default run manager

  G4RunManager * runManager = new G4RunManager;

  // set mandatory initialization classes

  Em10DetectorConstruction* detector;
  detector = new Em10DetectorConstruction;

  // ALICEDetectorConstruction* detector;
  // detector = new ALICEDetectorConstruction;

  runManager->SetUserInitialization(detector);
  runManager->SetUserInitialization(new Em10PhysicsList(detector));
  
#ifdef G4VIS_USE
  G4VisManager* visManager = 0;
#endif 
 
  // set user action classes
  runManager->SetUserAction(new Em10PrimaryGeneratorAction(detector));

  Em10RunAction* runAction = new Em10RunAction;

  runManager->SetUserAction(runAction);

  Em10EventAction* eventAction = new Em10EventAction(runAction);

  runManager->SetUserAction(eventAction);

  Em10SteppingAction* steppingAction = new Em10SteppingAction(detector,
                                                            eventAction, 
                                                            runAction);
  runManager->SetUserAction(steppingAction);


  runManager->SetUserAction( new Em10TrackingAction );


  G4UImanager* UI = G4UImanager::GetUIpointer();  
 
  if (argc==1)   // Define UI terminal for interactive mode  
    { 
#ifdef G4VIS_USE
      visManager = new G4VisExecutive;
      visManager->Initialize();
#endif 

      G4UIsession * session = new G4UIterminal;
      UI->ApplyCommand("/control/execute init.mac");    
      session->SessionStart();
      delete session;
    }
  else           // Batch mode
    { 
      G4String command = "/control/execute ";
      G4String fileName = argv[1];
      UI->ApplyCommand(command+fileName);
    }
    
  // job termination
#ifdef G4VIS_USE
  delete visManager;
#endif  
  delete runManager;

  return 0;
}

