//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//
// $Id: G4PSDirectionFlag.hh,v 1.1 2007/07/11 01:29:28 asaim Exp $
// GEANT4 tag $Name: geant4-09-02 $
//
//
//---------------------------------------------------------------
//
// G4PSDirectionFlag.hh
//
// Class Description:
//   This is an enumerator to define the direction of
// the particle's Surface Current or Flux for PrimitiveScorer
//
//
//---------------------------------------------------------------

#ifndef G4PSDirectionFlag_h
#define G4PSDirectionFlag_h 1

//////////////////
enum G4PSFluxFlag
//////////////////
{ 
    fFlux_InOut, 
    // For both direction In / Out.
    fFlux_In, 
    // IN : Direction which comes into the geometry
    fFlux_Out 
};

/////////////////////
enum G4PSCurrentFlag
/////////////////////
{ 
    fCurrent_InOut, 
    // For both direction In / Out.
    fCurrent_In, 
    // IN : Direction which comes into the geometry
    fCurrent_Out 
    // OUT : Direction which goes out fromthe geometry
};

#endif


