//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//
// -------------------------------------------------------------------
//
// GEANT4 Class file
//
//
// File name:     G4hSRIM2000p
//
// Author:        V.Ivanchenko (Vladimir.Ivanchenko@cern.ch)
// 
// Creation date: 07 Jan 2003
//
// Modifications: 
//
// Class Description: 
//
// Electronic stopping power parametrised according to
// J. F. Ziegler, SRIM-2000 software package from www.SRIM.org
//
// Class Description: End 
//
// -------------------------------------------------------------------
//
//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo....

#include "G4hSRIM2000p.hh"
#include "G4UnitsTable.hh"
#include "globals.hh"
#include "G4Material.hh"

G4double G4hSRIM2000p::a[92][8] = {
  { 1.28116E-02, 5.33047E-03, 6.51042E-01, 5.31902E-01, 1.95901E03, 1.18870E00, 5.98263E02, 9.54514E-03}
  ,{ 3.11787E-01, 4.99529E-03, 1.18546E-01, 9.20917E-01, 9.84843E02, 1.08223E00, 5.54388E02, 5.05072E-02}
  ,{ 6.44503E-01, 5.00368E-03, 8.66544E-01, 5.67488E-01, 9.62900E02, 1.01566E00, 1.62034E03, 2.37767E-02}
  ,{ 9.53561E-01, 5.07406E-03, 1.30450E00, 5.90300E-01, 1.94512E03, 1.05703E00, 3.26951E02, 1.30441E-02}
  ,{ 1.53151E00, 4.88520E-03, 2.56760E00, 4.23246E-01, 1.73888E03, 1.03208E00, 1.82942E03, 2.00331E-02}
  ,{ 2.40289E00, 4.91497E-03, 2.49101E00, 4.14939E-01, 1.85836E03, 1.01581E00, 2.50417E03, 1.81984E-02}
  ,{ 3.31007E00, 4.95744E-03, 5.40621E-01, 7.79940E-01, 1.10415E03, 9.67848E-01, 2.23535E03, 5.31612E-02}
  ,{ 9.72706E-01, 5.00390E-03, 1.35102E00, 5.49800E-01, 1.25428E03, 9.68356E-01, 5.09320E03, 5.36453E-02}
  ,{ 6.90408E-01, 4.62723E-03, 3.26749E-01, 1.10520E00, 1.30190E03, 9.43525E-01, 4.70373E01, 2.80245E-02}
  ,{ 2.81235E-01, 4.59698E-03, 5.25630E-01, 8.78183E-01, 1.15830E03, 9.38564E-01, 1.01606E01, 4.14147E-02}
  ,{ 2.15352E00, 4.40847E-03, 2.30923E00, 6.06001E-01, 1.33224E03, 9.43478E-01, 7.35116E02, 5.77231E-02}
  ,{ 3.42983E00, 4.36897E-03, 2.39377E00, 5.54737E-01, 1.14029E03, 9.29844E-01, 2.10748E03, 7.89342E-02}
  ,{ 3.89096E-02, 4.54168E-03, 4.27975E00, 4.78838E-01, 1.31642E03, 9.34106E-01, 5.65574E02, 5.27220E-02}
  ,{ 1.33101E00, 4.43533E-03, 1.52262E00, 7.75843E-01, 1.22702E03, 9.14146E-01, 1.09117E03, 4.44972E-02}
  ,{ 5.78119E00, 3.98281E-03, 3.24072E-01, 1.22769E00, 6.73459E02, 8.65731E-01, 1.23619E02, 1.82036E-01}
  ,{ 6.11741E-01, 4.46376E-03, 3.38101E00, 5.42907E-01, 1.16067E03, 9.12049E-01, 1.40312E04, 8.77050E-02}
  ,{ 1.15307E00, 4.47333E-03, 4.20464E00, 5.38231E-01, 1.30113E03, 9.02702E-01, 4.92301E03, 5.25717E-02}
  ,{ 1.70408E00, 4.47609E-03, 2.75072E00, 5.83835E-01, 2.71393E03, 9.53183E-01, 2.03579E03, 1.46897E-02}
  ,{ 2.60265E00, 4.32185E-03, 1.56811E00, 8.64656E-01, 5.56393E02, 8.44750E-01, 1.20010E02, 9.62648E-01}
  ,{ 5.36555E-01, 4.40846E-03, 3.22706E00, 6.02927E-01, 5.00851E02, 8.33450E-01, 1.76639E03, 2.02699E00}
  ,{ 1.71870E00, 4.36934E-03, 4.60285E00, 5.16212E-01, 1.60160E03, 9.14664E-01, 6.34168E03, 6.29243E-02}
  ,{ 1.46403E-01, 4.84558E-03, 5.54014E00, 4.55903E-01, 1.76346E03, 9.19014E-01, 3.95193E03, 5.50341E-02}
  ,{ 4.21238E00, 4.00130E-03, 3.79858E00, 4.82892E-01, 2.41697E03, 9.36204E-01, 7.73596E03, 2.89635E-02}
  ,{ 6.97881E-01, 4.30794E-03, 2.28630E00, 7.84069E-01, 9.67872E02, 8.57874E-01, 1.78526E01, 1.11149E-01}
  ,{ 5.92743E-01, 4.31334E-03, 1.40625E00, 9.68261E-01, 1.42642E03, 8.81488E-01, 1.44002E01, 4.24183E-02}
  ,{ 2.83155E-02, 3.54506E-03, 5.64961E-01, 1.24111E00, 1.52781E03, 8.81848E-01, 2.59497E01, 3.54067E-02}
  ,{ 2.69545E-01, 4.32088E-03, 2.24249E00, 7.64706E-01, 1.24391E03, 8.67051E-01, 2.34911E01, 6.04457E-02}
  ,{ 3.68234E00, 4.37139E-03, 1.52146E00, 7.36656E-01, 1.47086E03, 8.74909E-01, 2.51685E02, 4.28115E-02}
  ,{ 2.15403E00, 4.32278E-03, 2.69390E00, 5.23003E-01, 1.71727E03, 8.93617E-01, 2.09938E03, 5.25222E-02}
  ,{ 5.31847E-01, 3.82833E-03, 6.75606E-01, 1.06647E00, 1.00848E03, 8.26099E-01, 3.58939E01, 4.19818E-02}
  ,{ 6.91973E00, 4.01198E-03, 5.22284E-01, 9.74708E-01, 8.99033E02, 8.21636E-01, 3.71581E02, 7.38361E-02}
  ,{ 1.80976E00, 4.48896E-03, 5.66120E00, 4.18493E-01, 1.55821E03, 8.70542E-01, 1.75605E03, 6.05859E-02}
  ,{ 1.64641E00, 4.30255E-03, 5.12108E00, 5.16356E-01, 1.02024E03, 8.32723E-01, 2.20277E03, 8.46531E-02}
  ,{ 4.07150E00, 4.29051E-03, 3.33803E00, 5.43517E-01, 2.60626E03, 9.03072E-01, 1.08974E03, 1.81133E-02}
  ,{ 1.99798E00, 4.29503E-03, 3.23907E00, 5.93111E-01, 4.64572E03, 9.47444E-01, 6.40841E02, 9.69460E-03}
  ,{ 5.08884E00, 4.25630E-03, 1.43000E00, 7.22156E-01, 7.08778E03, 9.79865E-01, 7.62818E02, 6.04351E-03}
  ,{ 6.26370E-01, 4.13189E-03, 6.66229E-02, 2.65318E00, 1.07460E03, 8.14706E-01, 8.69523E00, 5.04427E-02}
  ,{ 5.04987E00, 3.93427E-03, 4.95613E00, 5.27062E-01, 1.88617E03, 8.68672E-01, 4.81765E03, 3.49423E-02}
  ,{ 1.17376E00, 4.21587E-03, 5.93823E00, 4.90520E-01, 1.55691E03, 8.49851E-01, 7.82193E03, 4.34207E-02}
  ,{ 7.26083E00, 4.19413E-03, 5.93121E00, 4.47579E-01, 4.68769E03, 9.39722E-01, 2.44636E03, 1.01526E-02}
  ,{ 3.51621E-01, 4.12551E-03, 1.33637E00, 1.28649E00, 1.49535E03, 8.50544E-01, 1.27864E01, 4.71084E-02}
  ,{ 1.79112E-02, 4.17066E-03, 1.16601E00, 1.18837E00, 1.26027E03, 8.25733E-01, 1.29721E01, 4.82827E-02}
  ,{ 3.72287E00, 4.17681E-03, 4.62860E00, 5.67689E-01, 1.67802E03, 8.62020E-01, 3.09395E03, 6.24402E-02}
  ,{ 1.79112E-02, 4.17066E-03, 1.16601E00, 1.18837E00, 1.26027E03, 8.25733E-01, 1.29721E01, 4.82827E-02}
  ,{ 3.07959E-01, 4.14183E-03, 5.45099E-01, 1.36766E00, 1.49906E03, 8.36456E-01, 2.65156E01, 3.82323E-02}
  ,{ 8.13324E-01, 4.21976E-03, 5.48878E00, 6.21228E-01, 1.49147E03, 8.43298E-01, 1.70197E01, 6.33415E-02}
  ,{ 2.89508E00, 4.20494E-03, 5.30021E00, 4.58632E-01, 1.38077E03, 8.35929E-01, 1.31565E04, 7.68200E-02}
  ,{ 3.47169E00, 4.13440E-03, 3.23372E00, 6.37885E-01, 1.11636E03, 8.19589E-01, 4.76603E03, 1.17895E-01}
  ,{ 2.28576E00, 4.22582E-03, 3.48478E00, 6.25713E-01, 8.04033E02, 7.95990E-01, 8.95357E03, 3.02479E-01}
  ,{ 4.70915E00, 4.09414E-03, 3.88322E00, 5.82491E-01, 1.03140E03, 8.15544E-01, 1.33004E04, 1.67355E-01}
  ,{ 7.35883E00, 4.38746E-03, 3.22730E00, 6.93616E-01, 1.36465E03, 8.32171E-01, 1.51236E03, 7.87703E-02}
  ,{ 1.20379E00, 4.21476E-03, 4.65732E00, 6.15557E-01, 8.57568E02, 7.94208E-01, 5.81437E03, 2.55765E-01}
  ,{ 4.21323E00, 4.20978E-03, 4.67533E00, 5.79451E-01, 3.50393E03, 8.92614E-01, 1.46887E03, 1.43590E-02}
  ,{ 1.00615E01, 3.91035E-03, 3.64002E-01, 1.20347E00, 1.53997E03, 8.21892E-01, 1.42428E03, 4.02424E-02}
  ,{ 3.73157E-01, 3.64035E-03, 2.26519E00, 1.15100E00, 1.67529E03, 8.37764E-01, 1.30656E01, 5.16993E-02}
  ,{ 4.82483E00, 4.14578E-03, 6.09343E00, 5.70256E-01, 2.30011E03, 8.63588E-01, 2.98072E03, 3.86788E-02}
  ,{ 5.74872E-01, 4.10857E-03, 2.76314E00, 8.78406E-01, 6.54727E02, 7.77081E-01, 4.60584E02, 9.63426E-01}
  ,{ 3.27544E00, 4.21774E-03, 5.76803E00, 5.40540E-01, 6.63129E03, 9.42817E-01, 7.44066E02, 8.30259E-03}
  ,{ 2.99783E00, 4.09014E-03, 4.52986E00, 6.20247E-01, 2.16115E03, 8.56688E-01, 1.26859E03, 4.30305E-02}
  ,{ 3.02248E00, 4.10313E-03, 3.16182E00, 7.50444E-01, 6.87321E02, 7.65038E-01, 3.63380E02, 3.89438E-01}
  ,{ 3.56550E00, 4.11367E-03, 6.01196E00, 5.21709E-01, 1.83002E03, 8.38996E-01, 3.66199E03, 5.75667E-02}
  ,{ 3.64072E00, 4.17820E-03, 4.87424E00, 5.78614E-01, 1.26770E03, 8.22111E-01, 3.50817E03, 2.41737E-01}
  ,{ 5.42525E-01, 4.12806E-03, 4.33656E00, 6.39323E-01, 1.10785E03, 7.88122E-01, 3.52321E02, 9.46601E-02}
  ,{ 7.54702E00, 4.08134E-03, 4.92913E00, 5.07107E-01, 2.56583E03, 8.61877E-01, 3.29996E03, 3.12730E-02}
  ,{ 4.43006E00, 4.19028E-03, 5.39210E00, 5.08608E-01, 3.60527E03, 8.85038E-01, 1.68786E03, 1.64866E-02}
  ,{ 4.31706E00, 4.06269E-03, 3.55237E00, 5.72971E-01, 2.13874E03, 8.39174E-01, 3.20435E03, 2.94710E-02}
  ,{ 2.73097E00, 4.02842E-03, 3.10590E00, 6.45438E-01, 1.80236E03, 8.20889E-01, 6.91941E02, 3.06839E-02}
  ,{ 1.27982E00, 4.05535E-03, 4.63018E00, 5.73846E-01, 1.59512E03, 8.16419E-01, 1.06728E03, 5.52321E-02}
  ,{ 5.75613E00, 4.04905E-03, 4.35700E00, 5.24956E-01, 2.20732E03, 8.37956E-01, 1.57951E03, 2.71650E-02}
  ,{ 9.20610E00, 4.03636E-03, 3.37689E00, 5.72174E-01, 3.66035E03, 8.68034E-01, 1.19114E03, 9.53995E-03}
  ,{ 8.23962E00, 4.04348E-03, 3.83028E00, 5.34511E-01, 4.35771E03, 8.82431E-01, 1.52426E03, 7.86437E-03}
  ,{ 3.06189E00, 4.05111E-03, 3.58030E00, 5.90820E-01, 2.34610E03, 8.37132E-01, 1.22199E03, 2.00717E-02}
  ,{ 7.99485E00, 3.29576E-03, 1.26335E00, 7.77934E-01, 1.80413E03, 8.12400E-01, 1.26630E03, 2.63526E-02}
  ,{ 6.48326E00, 4.14609E-03, 7.76185E-01, 1.08393E00, 2.50557E02, 6.43106E-01, 1.77277E02, 8.98821E-01}
  ,{ 6.20494E-01, 4.03017E-03, 2.53792E00, 6.77642E-01, 7.27918E02, 7.48340E-01, 1.17069E02, 2.01369E-01}
  ,{ 5.51045E-01, 4.02571E-03, 2.70928E00, 6.83870E-01, 1.08946E03, 7.77755E-01, 1.08830E03, 8.10305E-02}
  ,{ 1.26011E00, 4.04797E-03, 3.57127E00, 5.25416E-01, 2.61309E03, 8.53001E-01, 2.15571E03, 2.82139E-02}
  ,{ 3.20857E00, 4.05101E-03, 3.66577E00, 5.36178E-01, 3.09116E03, 8.56024E-01, 1.50812E03, 1.54014E-02}
  ,{ 1.04066E00, 4.05071E-03, 5.61035E00, 4.39133E-01, 3.64613E03, 8.69259E-01, 2.87840E03, 1.39437E-02}
  ,{ 1.04586E00, 4.05038E-03, 5.38433E00, 4.45067E-01, 3.71715E03, 8.70310E-01, 2.90728E03, 1.32933E-02}
  ,{ 3.15124E00, 4.05235E-03, 4.09956E00, 5.42499E-01, 3.24631E03, 8.57723E-01, 1.69177E03, 1.50581E-02}
  ,{ 3.06995E00, 4.05334E-03, 6.62045E00, 4.52822E-01, 3.38058E03, 8.60267E-01, 2.63856E03, 1.53938E-02}
  ,{ 3.84541E00, 4.06028E-03, 8.77920E00, 4.42301E-01, 2.72199E03, 8.43866E-01, 2.51315E03, 2.28962E-02}
  ,{ 4.36117E00, 4.05648E-03, 8.18512E00, 4.36260E-01, 3.11358E03, 8.52235E-01, 3.00179E03, 1.72051E-02}
  ,{ 4.36117E00, 4.05648E-03, 8.18512E00, 4.36260E-01, 3.11358E03, 8.52235E-01, 3.00179E03, 1.72051E-02}
  ,{ 3.22200E00, 4.00409E-03, 5.90236E00, 5.26779E-01, 4.04015E03, 8.68037E-01, 1.65835E03, 1.17469E-02}
  ,{ 9.34124E00, 3.96606E-03, 7.92099E00, 4.29769E-01, 5.18090E03, 8.87726E-01, 2.17316E03, 9.20070E-03}
  ,{ 6.28686E00, 3.96735E-03, 5.81778E00, 5.35859E-01, 4.86643E03, 8.84427E-01, 2.25734E03, 1.05815E-02}
  ,{ 5.92839E00, 3.96948E-03, 6.40824E00, 5.21225E-01, 4.61951E03, 8.80827E-01, 2.32352E03, 1.16274E-02}
  ,{ 5.24536E00, 3.97440E-03, 6.79689E00, 4.85424E-01, 4.58631E03, 8.77944E-01, 2.48150E03, 1.12824E-02}
  ,{ 2.77047E00, 3.98192E-03, 3.55107E00, 6.38231E-01, 2.51688E03, 8.29309E-01, 2.15559E03, 2.31207E-02}
  ,{ 2.78483E00, 3.98116E-03, 3.32988E00, 6.47983E-01, 2.66277E03, 8.36780E-01, 2.33743E03, 2.40740E-02}

  };

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo....

G4hSRIM2000p::G4hSRIM2000p():G4VhElectronicStoppingPower(), 
  protonMassAMU(1.007276)
{;}

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo....

G4hSRIM2000p::~G4hSRIM2000p() 
{;}

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo....

G4bool G4hSRIM2000p::HasMaterial(const G4Material* material) 
{
  if(1 == (material->GetNumberOfElements())) return true;
  return false ;
}

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo....

G4double G4hSRIM2000p::StoppingPower(const G4Material* material,
                                              G4double kineticEnergy) 
{
  G4double ionloss = 0.0 ;

  // pure material (normally not the case for this function)
  if(1 == (material->GetNumberOfElements())) {
    G4double z = material->GetZ() ;
    ionloss = ElectronicStoppingPower( z, kineticEnergy ) ;  
  }
  
  return ionloss;
}  

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo....

G4double G4hSRIM2000p::ElectronicStoppingPower(G4double z,
                                               G4double kineticEnergy) const
{
  G4double ionloss ;
  G4int i = G4int(z) - 1 ;  // index of atom
  if(i < 0)  i = 0 ;
  if(i > 91) i = 91 ;
  
  // Proton kinetic energy for parametrisation in Ziegler's units (keV/amu)  
  
  G4double T = kineticEnergy/(keV*protonMassAMU) ; 
  
  
  
  G4double e = T ;
  if ( T < 25.0 ) e = 25.0 ;
  
  // universal approximation  
  G4double slow  = a[i][0] * std::pow(e, a[i][1]) + a[i][2] * std::pow(e, a[i][3])  ;
  G4double shigh = std::log( a[i][6]/e + a[i][7]*e ) * a[i][4] / std::pow(e, a[i][5]) ;
  ionloss = slow*shigh / (slow + shigh) ; 
    
  // low energy region
  if ( T < 25.0 ) {
    
    G4double  s = 0.45 ;
    // light elements
    if(6.5 > z) s = 0.25 ;
    // semiconductors
    if(5 == i || 13 == i || 31 == i) s = 0.375 ;
    
    ionloss *= std::pow(T/25.0, s) ;
  }
  
  if ( ionloss < 0.0) ionloss = 0.0 ;
  
  return ionloss;
}

