//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//

 // G4 Low energy model: n-p scattering -- Data
 // THIS FILE contains static array initialization
 // F.W. Jones, L.G. Greeniaus, H.P. Wellisch


// Table of Cumulative np Scattering Probabilities
// To be used for generation as a function of std::cos(theta cm)
// NOTE: Assumes angle range to be generated is 0-180 degrees
//       This allows tracking of
//       well-defined GEANT4 particles and generation of secondary
// Range of validity of tables: 10 - 1200 MeV
// Results are extracted from RA Arndt"s PSA of 1998
// CM Angle range: 0.5 - 179.5 degrees in 1 degree steps
// Data written 8 values/line, delimited by commas
// Appended at end: cm momentum (GeV/c), Lab Energy (GeV), max 
// dsigma/domega-CM (mb/sr), total cross section 

 G4float G4AngularDistributionNP::sig[NENERGY][NANGLE] = {
   //------------  0.01 GeV
  {0.00007,   0.00030,   0.00066,   0.00118,   0.00184,   0.00265,   0.00360,
   0.00471,   0.00595,   0.00735,   0.00888,   0.01057,   0.01239,   0.01436,
   0.01648,   0.01874,   0.02113,   0.02367,   0.02635,   0.02917,   0.03213,
   0.03523,   0.03847,   0.04184,   0.04534,   0.04899,   0.05276,   0.05667,
   0.06071,   0.06488,   0.06917,   0.07360,   0.07815,   0.08283,   0.08763,
   0.09255,   0.09760,   0.10276,   0.10805,   0.11345,   0.11896,   0.12459,
   0.13033,   0.13618,   0.14214,   0.14821,   0.15438,   0.16066,   0.16704,
   0.17352,   0.18009,   0.18677,   0.19353,   0.20039,   0.20734,   0.21438,
   0.22151,   0.22871,   0.23601,   0.24338,   0.25083,   0.25835,   0.26595,
   0.27362,   0.28136,   0.28917,   0.29704,   0.30497,   0.31297,   0.32102,
   0.32913,   0.33729,   0.34550,   0.35376,   0.36207,   0.37042,   0.37881,
   0.38724,   0.39570,   0.40420,   0.41273,   0.42129,   0.42988,   0.43848,
   0.44711,   0.45576,   0.46443,   0.47310,   0.48179,   0.49049,   0.49919,
   0.50789,   0.51659,   0.52530,   0.53399,   0.54268,   0.55136,   0.56003,
   0.56868,   0.57731,   0.58592,   0.59451,   0.60307,   0.61161,   0.62011,
   0.62858,   0.63701,   0.64540,   0.65376,   0.66206,   0.67032,   0.67853,
   0.68669,   0.69480,   0.70285,   0.71083,   0.71876,   0.72662,   0.73442,
   0.74214,   0.74979,   0.75737,   0.76487,   0.77230,   0.77964,   0.78689,
   0.79407,   0.80115,   0.80814,   0.81504,   0.82184,   0.82854,   0.83515,
   0.84165,   0.84805,   0.85434,   0.86052,   0.86659,   0.87255,   0.87840,
   0.88413,   0.88974,   0.89523,   0.90060,   0.90584,   0.91096,   0.91595,
   0.92081,   0.92554,   0.93014,   0.93460,   0.93892,   0.94311,   0.94716,
   0.95107,   0.95484,   0.95847,   0.96195,   0.96528,   0.96847,   0.97151,
   0.97440,   0.97714,   0.97973,   0.98217,   0.98445,   0.98658,   0.98856,
   0.99038,   0.99204,   0.99355,   0.99490,   0.99610,   0.99713,   0.99801,
   0.99872,   0.99928,   0.99968,   0.99992,   1.00000},
   //---------  0.02 GeV
  {0.00008,   0.00030,   0.00068,   0.00120,   0.00188,   0.00271,   0.00368,
   0.00480,   0.00608,   0.00750,   0.00906,   0.01078,   0.01264,   0.01465,
   0.01680,   0.01909,   0.02153,   0.02411,   0.02684,   0.02970,   0.03270,
   0.03584,   0.03912,   0.04254,   0.04609,   0.04977,   0.05359,   0.05753,
   0.06161,   0.06582,   0.07015,   0.07461,   0.07919,   0.08390,   0.08873,
   0.09367,   0.09874,   0.10392,   0.10922,   0.11463,   0.12015,   0.12578,
   0.13152,   0.13737,   0.14332,   0.14937,   0.15553,   0.16178,   0.16813,
   0.17458,   0.18112,   0.18775,   0.19447,   0.20128,   0.20817,   0.21515,
   0.22221,   0.22935,   0.23657,   0.24386,   0.25123,   0.25866,   0.26617,
   0.27374,   0.28138,   0.28908,   0.29685,   0.30467,   0.31255,   0.32048,
   0.32846,   0.33650,   0.34458,   0.35271,   0.36088,   0.36909,   0.37734,
   0.38563,   0.39395,   0.40231,   0.41069,   0.41911,   0.42754,   0.43600,
   0.44448,   0.45298,   0.46150,   0.47003,   0.47857,   0.48712,   0.49568,
   0.50424,   0.51280,   0.52136,   0.52992,   0.53848,   0.54703,   0.55557,
   0.56409,   0.57260,   0.58110,   0.58957,   0.59803,   0.60645,   0.61486,
   0.62323,   0.63157,   0.63988,   0.64815,   0.65639,   0.66458,   0.67273,
   0.68083,   0.68889,   0.69689,   0.70484,   0.71274,   0.72057,   0.72835,
   0.73607,   0.74372,   0.75130,   0.75881,   0.76625,   0.77362,   0.78090,
   0.78811,   0.79524,   0.80228,   0.80924,   0.81611,   0.82289,   0.82957,
   0.83616,   0.84265,   0.84904,   0.85533,   0.86151,   0.86759,   0.87356,
   0.87942,   0.88516,   0.89079,   0.89630,   0.90168,   0.90695,   0.91209,
   0.91711,   0.92200,   0.92675,   0.93138,   0.93587,   0.94022,   0.94443,
   0.94851,   0.95244,   0.95623,   0.95987,   0.96336,   0.96670,   0.96989,
   0.97293,   0.97582,   0.97854,   0.98111,   0.98352,   0.98578,   0.98786,
   0.98979,   0.99155,   0.99315,   0.99459,   0.99585,   0.99695,   0.99788,
   0.99864,   0.99924,   0.99966,   0.99992,   1.00000},
   //---------  0.03 GeV
  {0.00008,   0.00032,   0.00073,   0.00129,   0.00201,   0.00289,   0.00393,
   0.00513,   0.00649,   0.00801,   0.00968,   0.01150,   0.01348,   0.01561,
   0.01790,   0.02033,   0.02291,   0.02564,   0.02852,   0.03154,   0.03470,
   0.03801,   0.04145,   0.04503,   0.04875,   0.05261,   0.05659,   0.06071,
   0.06495,   0.06932,   0.07382,   0.07844,   0.08318,   0.08804,   0.09302,
   0.09811,   0.10331,   0.10863,   0.11405,   0.11958,   0.12522,   0.13096,
   0.13679,   0.14273,   0.14876,   0.15489,   0.16111,   0.16742,   0.17382,
   0.18030,   0.18687,   0.19352,   0.20025,   0.20705,   0.21394,   0.22089,
   0.22792,   0.23501,   0.24218,   0.24941,   0.25670,   0.26405,   0.27147,
   0.27894,   0.28646,   0.29404,   0.30167,   0.30935,   0.31708,   0.32486,
   0.33268,   0.34054,   0.34844,   0.35638,   0.36435,   0.37236,   0.38040,
   0.38848,   0.39658,   0.40471,   0.41286,   0.42104,   0.42924,   0.43746,
   0.44569,   0.45395,   0.46221,   0.47049,   0.47878,   0.48708,   0.49538,
   0.50369,   0.51201,   0.52032,   0.52863,   0.53694,   0.54524,   0.55354,
   0.56183,   0.57010,   0.57837,   0.58662,   0.59485,   0.60306,   0.61125,
   0.61942,   0.62756,   0.63568,   0.64377,   0.65182,   0.65984,   0.66783,
   0.67577,   0.68368,   0.69155,   0.69937,   0.70714,   0.71486,   0.72253,
   0.73015,   0.73772,   0.74522,   0.75267,   0.76005,   0.76737,   0.77462,
   0.78180,   0.78891,   0.79594,   0.80290,   0.80978,   0.81658,   0.82329,
   0.82993,   0.83647,   0.84292,   0.84928,   0.85554,   0.86171,   0.86777,
   0.87374,   0.87960,   0.88535,   0.89099,   0.89652,   0.90194,   0.90724,
   0.91242,   0.91747,   0.92241,   0.92721,   0.93188,   0.93643,   0.94083,
   0.94510,   0.94923,   0.95322,   0.95706,   0.96075,   0.96429,   0.96767,
   0.97091,   0.97398,   0.97689,   0.97964,   0.98222,   0.98464,   0.98688,
   0.98896,   0.99086,   0.99258,   0.99413,   0.99550,   0.99669,   0.99770,
   0.99853,   0.99917,   0.99963,   0.99991,   1.00000},
   //---------  0.05 GeV
  {0.00010,   0.00040,   0.00089,   0.00157,   0.00245,   0.00352,   0.00478,
   0.00623,   0.00787,   0.00970,   0.01170,   0.01389,   0.01626,   0.01880,
   0.02151,   0.02439,   0.02744,   0.03065,   0.03402,   0.03754,   0.04122,
   0.04505,   0.04902,   0.05313,   0.05738,   0.06176,   0.06628,   0.07092,
   0.07568,   0.08057,   0.08557,   0.09068,   0.09590,   0.10123,   0.10666,
   0.11219,   0.11781,   0.12353,   0.12933,   0.13522,   0.14119,   0.14725,
   0.15337,   0.15957,   0.16585,   0.17218,   0.17859,   0.18505,   0.19157,
   0.19816,   0.20479,   0.21148,   0.21821,   0.22499,   0.23182,   0.23869,
   0.24560,   0.25255,   0.25953,   0.26655,   0.27361,   0.28069,   0.28781,
   0.29495,   0.30212,   0.30932,   0.31654,   0.32378,   0.33105,   0.33834,
   0.34565,   0.35298,   0.36032,   0.36769,   0.37507,   0.38247,   0.38988,
   0.39731,   0.40476,   0.41221,   0.41968,   0.42717,   0.43466,   0.44217,
   0.44969,   0.45722,   0.46476,   0.47231,   0.47987,   0.48744,   0.49501,
   0.50260,   0.51019,   0.51778,   0.52539,   0.53300,   0.54061,   0.54823,
   0.55584,   0.56347,   0.57109,   0.57871,   0.58633,   0.59395,   0.60157,
   0.60918,   0.61678,   0.62438,   0.63197,   0.63955,   0.64711,   0.65467,
   0.66221,   0.66973,   0.67723,   0.68472,   0.69218,   0.69961,   0.70702,
   0.71440,   0.72175,   0.72907,   0.73635,   0.74360,   0.75080,   0.75796,
   0.76508,   0.77215,   0.77918,   0.78615,   0.79306,   0.79992,   0.80672,
   0.81346,   0.82013,   0.82674,   0.83328,   0.83974,   0.84613,   0.85244,
   0.85867,   0.86482,   0.87088,   0.87685,   0.88273,   0.88851,   0.89420,
   0.89978,   0.90526,   0.91063,   0.91589,   0.92103,   0.92605,   0.93095,
   0.93572,   0.94036,   0.94487,   0.94923,   0.95345,   0.95751,   0.96143,
   0.96518,   0.96876,   0.97218,   0.97542,   0.97849,   0.98136,   0.98405,
   0.98654,   0.98884,   0.99093,   0.99281,   0.99448,   0.99593,   0.99717,
   0.99819,   0.99898,   0.99955,   0.99989,   1.00000},
   //---------  0.07 GeV
  {0.00012,   0.00048,   0.00108,   0.00191,   0.00298,   0.00427,   0.00580,
   0.00755,   0.00952,   0.01171,   0.01412,   0.01673,   0.01954,   0.02256,
   0.02577,   0.02916,   0.03274,   0.03649,   0.04041,   0.04450,   0.04874,
   0.05314,   0.05768,   0.06237,   0.06719,   0.07214,   0.07722,   0.08241,
   0.08772,   0.09313,   0.09865,   0.10426,   0.10996,   0.11575,   0.12162,
   0.12757,   0.13359,   0.13968,   0.14583,   0.15204,   0.15830,   0.16462,
   0.17098,   0.17738,   0.18382,   0.19029,   0.19679,   0.20333,   0.20988,
   0.21646,   0.22306,   0.22968,   0.23630,   0.24294,   0.24959,   0.25625,
   0.26291,   0.26958,   0.27625,   0.28291,   0.28958,   0.29625,   0.30292,
   0.30958,   0.31624,   0.32290,   0.32955,   0.33620,   0.34284,   0.34948,
   0.35612,   0.36275,   0.36939,   0.37601,   0.38264,   0.38927,   0.39589,
   0.40252,   0.40915,   0.41578,   0.42241,   0.42905,   0.43570,   0.44235,
   0.44901,   0.45568,   0.46237,   0.46906,   0.47576,   0.48248,   0.48922,
   0.49597,   0.50274,   0.50952,   0.51633,   0.52315,   0.53000,   0.53686,
   0.54375,   0.55066,   0.55759,   0.56454,   0.57152,   0.57851,   0.58553,
   0.59257,   0.59963,   0.60671,   0.61381,   0.62093,   0.62807,   0.63523,
   0.64239,   0.64958,   0.65677,   0.66398,   0.67119,   0.67841,   0.68564,
   0.69286,   0.70009,   0.70731,   0.71453,   0.72174,   0.72894,   0.73613,
   0.74329,   0.75044,   0.75757,   0.76467,   0.77174,   0.77879,   0.78579,
   0.79276,   0.79968,   0.80656,   0.81340,   0.82018,   0.82690,   0.83357,
   0.84018,   0.84672,   0.85320,   0.85960,   0.86593,   0.87218,   0.87835,
   0.88443,   0.89042,   0.89632,   0.90212,   0.90782,   0.91341,   0.91890,
   0.92426,   0.92950,   0.93462,   0.93960,   0.94443,   0.94913,   0.95366,
   0.95804,   0.96225,   0.96628,   0.97012,   0.97377,   0.97722,   0.98045,
   0.98347,   0.98625,   0.98880,   0.99111,   0.99316,   0.99495,   0.99648,
   0.99774,   0.99873,   0.99943,   0.99986,   1.00000},
   //---------  0.10 GeV
  {0.00015,   0.00060,   0.00133,   0.00235,   0.00366,   0.00524,   0.00710,
   0.00923,   0.01162,   0.01427,   0.01716,   0.02030,   0.02366,   0.02724,
   0.03104,   0.03503,   0.03922,   0.04360,   0.04815,   0.05287,   0.05775,
   0.06278,   0.06795,   0.07325,   0.07868,   0.08423,   0.08988,   0.09563,
   0.10148,   0.10742,   0.11343,   0.11951,   0.12567,   0.13187,   0.13813,
   0.14444,   0.15078,   0.15716,   0.16357,   0.17000,   0.17644,   0.18290,
   0.18936,   0.19582,   0.20228,   0.20874,   0.21519,   0.22162,   0.22803,
   0.23442,   0.24080,   0.24714,   0.25346,   0.25974,   0.26600,   0.27222,
   0.27841,   0.28456,   0.29068,   0.29676,   0.30280,   0.30881,   0.31478,
   0.32071,   0.32661,   0.33247,   0.33830,   0.34410,   0.34987,   0.35560,
   0.36131,   0.36700,   0.37266,   0.37830,   0.38392,   0.38953,   0.39512,
   0.40070,   0.40628,   0.41185,   0.41741,   0.42298,   0.42856,   0.43414,
   0.43973,   0.44533,   0.45095,   0.45659,   0.46226,   0.46795,   0.47367,
   0.47942,   0.48520,   0.49102,   0.49689,   0.50279,   0.50874,   0.51474,
   0.52078,   0.52688,   0.53303,   0.53924,   0.54550,   0.55181,   0.55819,
   0.56462,   0.57111,   0.57766,   0.58427,   0.59094,   0.59767,   0.60445,
   0.61129,   0.61819,   0.62514,   0.63215,   0.63920,   0.64631,   0.65346,
   0.66065,   0.66789,   0.67516,   0.68246,   0.68980,   0.69717,   0.70455,
   0.71196,   0.71938,   0.72681,   0.73425,   0.74169,   0.74913,   0.75656,
   0.76398,   0.77138,   0.77876,   0.78611,   0.79344,   0.80072,   0.80797,
   0.81517,   0.82232,   0.82942,   0.83646,   0.84343,   0.85034,   0.85718,
   0.86395,   0.87063,   0.87724,   0.88375,   0.89017,   0.89650,   0.90273,
   0.90885,   0.91485,   0.92074,   0.92650,   0.93213,   0.93762,   0.94297,
   0.94815,   0.95316,   0.95800,   0.96264,   0.96707,   0.97129,   0.97528,
   0.97902,   0.98250,   0.98570,   0.98861,   0.99122,   0.99351,   0.99547,
   0.99708,   0.99835,   0.99927,   0.99982,   1.00000},
   //---------  0.14 GeV
  {0.00018,   0.00069,   0.00154,   0.00271,   0.00421,   0.00603,   0.00816,
   0.01058,   0.01329,   0.01628,   0.01953,   0.02304,   0.02678,   0.03075,
   0.03494,   0.03933,   0.04391,   0.04867,   0.05360,   0.05868,   0.06391,
   0.06928,   0.07478,   0.08039,   0.08611,   0.09193,   0.09784,   0.10383,
   0.10989,   0.11602,   0.12220,   0.12843,   0.13470,   0.14101,   0.14734,
   0.15369,   0.16005,   0.16642,   0.17279,   0.17915,   0.18550,   0.19183,
   0.19815,   0.20443,   0.21069,   0.21690,   0.22309,   0.22922,   0.23532,
   0.24136,   0.24736,   0.25330,   0.25919,   0.26502,   0.27079,   0.27651,
   0.28217,   0.28777,   0.29331,   0.29879,   0.30421,   0.30958,   0.31489,
   0.32015,   0.32536,   0.33051,   0.33562,   0.34068,   0.34569,   0.35067,
   0.35561,   0.36051,   0.36538,   0.37022,   0.37504,   0.37984,   0.38462,
   0.38939,   0.39414,   0.39890,   0.40365,   0.40840,   0.41316,   0.41794,
   0.42273,   0.42754,   0.43237,   0.43723,   0.44213,   0.44706,   0.45204,
   0.45706,   0.46213,   0.46725,   0.47243,   0.47768,   0.48298,   0.48836,
   0.49380,   0.49933,   0.50492,   0.51060,   0.51636,   0.52221,   0.52814,
   0.53416,   0.54027,   0.54647,   0.55277,   0.55915,   0.56563,   0.57221,
   0.57887,   0.58563,   0.59248,   0.59941,   0.60644,   0.61355,   0.62075,
   0.62803,   0.63538,   0.64281,   0.65031,   0.65788,   0.66551,   0.67320,
   0.68094,   0.68873,   0.69656,   0.70443,   0.71233,   0.72025,   0.72819,
   0.73614,   0.74409,   0.75205,   0.75999,   0.76792,   0.77583,   0.78370,
   0.79155,   0.79935,   0.80710,   0.81480,   0.82244,   0.83001,   0.83752,
   0.84495,   0.85230,   0.85956,   0.86674,   0.87382,   0.88080,   0.88769,
   0.89446,   0.90113,   0.90769,   0.91412,   0.92043,   0.92660,   0.93263,
   0.93852,   0.94424,   0.94978,   0.95514,   0.96030,   0.96524,   0.96994,
   0.97438,   0.97854,   0.98240,   0.98593,   0.98912,   0.99193,   0.99435,
   0.99636,   0.99794,   0.99908,   0.99977,   1.00000},
   //---------  0.18 GeV
  {0.00019,   0.00073,   0.00162,   0.00286,   0.00444,   0.00635,   0.00857,
   0.01110,   0.01391,   0.01701,   0.02036,   0.02396,   0.02779,   0.03185,
   0.03610,   0.04055,   0.04518,   0.04998,   0.05494,   0.06004,   0.06528,
   0.07065,   0.07613,   0.08172,   0.08741,   0.09319,   0.09906,   0.10499,
   0.11099,   0.11705,   0.12316,   0.12931,   0.13550,   0.14171,   0.14794,
   0.15419,   0.16045,   0.16670,   0.17296,   0.17920,   0.18543,   0.19163,
   0.19781,   0.20396,   0.21008,   0.21615,   0.22219,   0.22817,   0.23411,
   0.24000,   0.24584,   0.25162,   0.25734,   0.26300,   0.26861,   0.27415,
   0.27963,   0.28505,   0.29041,   0.29571,   0.30094,   0.30612,   0.31124,
   0.31630,   0.32131,   0.32627,   0.33117,   0.33603,   0.34084,   0.34560,
   0.35033,   0.35502,   0.35968,   0.36430,   0.36890,   0.37348,   0.37804,
   0.38258,   0.38711,   0.39163,   0.39615,   0.40067,   0.40520,   0.40974,
   0.41429,   0.41886,   0.42345,   0.42808,   0.43273,   0.43742,   0.44215,
   0.44693,   0.45175,   0.45663,   0.46156,   0.46656,   0.47163,   0.47676,
   0.48197,   0.48725,   0.49261,   0.49806,   0.50359,   0.50921,   0.51493,
   0.52074,   0.52664,   0.53265,   0.53875,   0.54496,   0.55127,   0.55768,
   0.56420,   0.57082,   0.57755,   0.58439,   0.59132,   0.59836,   0.60550,
   0.61274,   0.62008,   0.62751,   0.63503,   0.64264,   0.65033,   0.65810,
   0.66594,   0.67385,   0.68182,   0.68985,   0.69793,   0.70606,   0.71422,
   0.72240,   0.73061,   0.73884,   0.74706,   0.75529,   0.76350,   0.77170,
   0.77987,   0.78800,   0.79609,   0.80412,   0.81210,   0.82001,   0.82785,
   0.83561,   0.84329,   0.85087,   0.85836,   0.86575,   0.87303,   0.88021,
   0.88727,   0.89422,   0.90105,   0.90776,   0.91435,   0.92080,   0.92712,
   0.93329,   0.93931,   0.94517,   0.95086,   0.95636,   0.96165,   0.96672,
   0.97153,   0.97607,   0.98030,   0.98420,   0.98774,   0.99088,   0.99360,
   0.99587,   0.99766,   0.99895,   0.99974,   1.00000},
   //---------  0.24 GeV
  {0.00019,   0.00074,   0.00163,   0.00288,   0.00445,   0.00635,   0.00855,
   0.01104,   0.01381,   0.01683,   0.02010,   0.02360,   0.02732,   0.03123,
   0.03534,   0.03962,   0.04408,   0.04869,   0.05346,   0.05837,   0.06341,
   0.06858,   0.07388,   0.07929,   0.08480,   0.09042,   0.09613,   0.10192,
   0.10780,   0.11374,   0.11976,   0.12583,   0.13196,   0.13813,   0.14434,
   0.15058,   0.15686,   0.16315,   0.16945,   0.17577,   0.18208,   0.18840,
   0.19470,   0.20099,   0.20727,   0.21352,   0.21974,   0.22593,   0.23208,
   0.23819,   0.24426,   0.25029,   0.25626,   0.26219,   0.26805,   0.27387,
   0.27962,   0.28532,   0.29095,   0.29653,   0.30205,   0.30750,   0.31290,
   0.31824,   0.32351,   0.32873,   0.33390,   0.33901,   0.34407,   0.34907,
   0.35403,   0.35895,   0.36382,   0.36865,   0.37344,   0.37820,   0.38294,
   0.38764,   0.39232,   0.39698,   0.40163,   0.40626,   0.41089,   0.41551,
   0.42013,   0.42475,   0.42939,   0.43403,   0.43869,   0.44337,   0.44807,
   0.45280,   0.45757,   0.46236,   0.46720,   0.47208,   0.47701,   0.48199,
   0.48703,   0.49213,   0.49729,   0.50251,   0.50781,   0.51318,   0.51862,
   0.52415,   0.52976,   0.53545,   0.54124,   0.54712,   0.55309,   0.55916,
   0.56532,   0.57159,   0.57796,   0.58443,   0.59101,   0.59769,   0.60448,
   0.61137,   0.61837,   0.62547,   0.63267,   0.63997,   0.64737,   0.65486,
   0.66245,   0.67012,   0.67788,   0.68571,   0.69362,   0.70159,   0.70962,
   0.71770,   0.72583,   0.73400,   0.74220,   0.75041,   0.75864,   0.76687,
   0.77509,   0.78329,   0.79146,   0.79960,   0.80768,   0.81571,   0.82368,
   0.83157,   0.83937,   0.84708,   0.85470,   0.86220,   0.86960,   0.87688,
   0.88403,   0.89106,   0.89797,   0.90474,   0.91138,   0.91788,   0.92425,
   0.93048,   0.93656,   0.94249,   0.94827,   0.95387,   0.95929,   0.96451,
   0.96950,   0.97424,   0.97870,   0.98284,   0.98662,   0.99001,   0.99296,
   0.99544,   0.99741,   0.99884,   0.99971,   1.00000},
   //---------  0.34 GeV
  {0.00019,   0.00072,   0.00159,   0.00279,   0.00431,   0.00612,   0.00823,
   0.01060,   0.01322,   0.01608,   0.01917,   0.02247,   0.02598,   0.02969,
   0.03359,   0.03768,   0.04195,   0.04641,   0.05104,   0.05584,   0.06082,
   0.06596,   0.07126,   0.07673,   0.08235,   0.08811,   0.09403,   0.10008,
   0.10626,   0.11257,   0.11900,   0.12554,   0.13219,   0.13893,   0.14576,
   0.15267,   0.15965,   0.16669,   0.17379,   0.18094,   0.18812,   0.19533,
   0.20257,   0.20981,   0.21706,   0.22430,   0.23153,   0.23874,   0.24592,
   0.25307,   0.26017,   0.26724,   0.27424,   0.28120,   0.28808,   0.29491,
   0.30166,   0.30834,   0.31494,   0.32147,   0.32791,   0.33427,   0.34055,
   0.34674,   0.35285,   0.35888,   0.36483,   0.37069,   0.37647,   0.38217,
   0.38779,   0.39334,   0.39882,   0.40422,   0.40956,   0.41483,   0.42004,
   0.42519,   0.43028,   0.43532,   0.44031,   0.44525,   0.45015,   0.45501,
   0.45984,   0.46463,   0.46940,   0.47414,   0.47886,   0.48356,   0.48825,
   0.49292,   0.49759,   0.50226,   0.50693,   0.51160,   0.51629,   0.52098,
   0.52568,   0.53041,   0.53516,   0.53994,   0.54474,   0.54958,   0.55446,
   0.55937,   0.56434,   0.56935,   0.57441,   0.57953,   0.58471,   0.58996,
   0.59527,   0.60065,   0.60611,   0.61165,   0.61727,   0.62297,   0.62877,
   0.63465,   0.64063,   0.64670,   0.65287,   0.65914,   0.66552,   0.67199,
   0.67857,   0.68525,   0.69202,   0.69890,   0.70588,   0.71295,   0.72011,
   0.72736,   0.73469,   0.74209,   0.74957,   0.75711,   0.76470,   0.77233,
   0.78001,   0.78771,   0.79542,   0.80314,   0.81086,   0.81855,   0.82621,
   0.83383,   0.84140,   0.84889,   0.85631,   0.86365,   0.87088,   0.87800,
   0.88500,   0.89188,   0.89864,   0.90525,   0.91173,   0.91806,   0.92425,
   0.93030,   0.93621,   0.94197,   0.94758,   0.95304,   0.95835,   0.96348,
   0.96843,   0.97316,   0.97766,   0.98188,   0.98579,   0.98932,   0.99244,
   0.99508,   0.99719,   0.99874,   0.99968,   1.00000},
   //---------  0.42 GeV
  {0.00020,   0.00075,   0.00165,   0.00289,   0.00445,   0.00633,   0.00849,
   0.01094,   0.01364,   0.01660,   0.01979,   0.02322,   0.02688,   0.03077,
   0.03487,   0.03920,   0.04375,   0.04852,   0.05350,   0.05870,   0.06411,
   0.06973,   0.07556,   0.08159,   0.08782,   0.09423,   0.10084,   0.10761,
   0.11456,   0.12167,   0.12893,   0.13633,   0.14386,   0.15152,   0.15928,
   0.16715,   0.17510,   0.18313,   0.19123,   0.19938,   0.20757,   0.21580,
   0.22404,   0.23229,   0.24054,   0.24877,   0.25698,   0.26515,   0.27328,
   0.28135,   0.28937,   0.29732,   0.30519,   0.31298,   0.32068,   0.32829,
   0.33580,   0.34320,   0.35051,   0.35771,   0.36479,   0.37177,   0.37864,
   0.38539,   0.39204,   0.39857,   0.40499,   0.41131,   0.41751,   0.42362,
   0.42962,   0.43551,   0.44132,   0.44702,   0.45264,   0.45816,   0.46361,
   0.46896,   0.47424,   0.47945,   0.48458,   0.48964,   0.49464,   0.49958,
   0.50446,   0.50928,   0.51405,   0.51878,   0.52345,   0.52809,   0.53269,
   0.53725,   0.54178,   0.54628,   0.55076,   0.55521,   0.55965,   0.56407,
   0.56847,   0.57287,   0.57726,   0.58165,   0.58604,   0.59044,   0.59484,
   0.59925,   0.60368,   0.60813,   0.61260,   0.61710,   0.62163,   0.62620,
   0.63080,   0.63545,   0.64015,   0.64490,   0.64970,   0.65457,   0.65950,
   0.66450,   0.66958,   0.67473,   0.67997,   0.68529,   0.69070,   0.69620,
   0.70179,   0.70749,   0.71328,   0.71917,   0.72516,   0.73126,   0.73745,
   0.74374,   0.75014,   0.75662,   0.76320,   0.76987,   0.77661,   0.78343,
   0.79032,   0.79727,   0.80427,   0.81131,   0.81839,   0.82548,   0.83258,
   0.83967,   0.84675,   0.85380,   0.86081,   0.86776,   0.87464,   0.88144,
   0.88815,   0.89475,   0.90125,   0.90762,   0.91386,   0.91997,   0.92594,
   0.93177,   0.93746,   0.94301,   0.94842,   0.95368,   0.95880,   0.96376,
   0.96855,   0.97316,   0.97757,   0.98173,   0.98560,   0.98913,   0.99227,
   0.99495,   0.99711,   0.99870,   0.99967,   1.00000},
   //---------  0.50 GeV
  {0.00023,   0.00086,   0.00190,   0.00333,   0.00513,   0.00729,   0.00979,
   0.01261,   0.01574,   0.01917,   0.02288,   0.02688,   0.03115,   0.03570,
   0.04053,   0.04562,   0.05098,   0.05661,   0.06251,   0.06866,   0.07507,
   0.08173,   0.08863,   0.09577,   0.10314,   0.11072,   0.11851,   0.12650,
   0.13468,   0.14303,   0.15154,   0.16020,   0.16900,   0.17791,   0.18693,
   0.19605,   0.20524,   0.21449,   0.22379,   0.23312,   0.24247,   0.25182,
   0.26117,   0.27048,   0.27977,   0.28900,   0.29818,   0.30728,   0.31630,
   0.32523,   0.33406,   0.34278,   0.35138,   0.35987,   0.36823,   0.37645,
   0.38454,   0.39250,   0.40031,   0.40798,   0.41551,   0.42289,   0.43013,
   0.43723,   0.44419,   0.45101,   0.45769,   0.46424,   0.47065,   0.47694,
   0.48310,   0.48913,   0.49505,   0.50085,   0.50654,   0.51212,   0.51759,
   0.52297,   0.52824,   0.53342,   0.53852,   0.54352,   0.54845,   0.55329,
   0.55806,   0.56276,   0.56739,   0.57195,   0.57645,   0.58089,   0.58528,
   0.58961,   0.59390,   0.59814,   0.60233,   0.60648,   0.61060,   0.61468,
   0.61873,   0.62275,   0.62675,   0.63072,   0.63467,   0.63861,   0.64253,
   0.64645,   0.65035,   0.65426,   0.65816,   0.66207,   0.66598,   0.66991,
   0.67385,   0.67781,   0.68180,   0.68581,   0.68985,   0.69393,   0.69806,
   0.70222,   0.70644,   0.71071,   0.71505,   0.71944,   0.72391,   0.72844,
   0.73306,   0.73776,   0.74254,   0.74741,   0.75237,   0.75742,   0.76257,
   0.76782,   0.77317,   0.77862,   0.78416,   0.78980,   0.79553,   0.80136,
   0.80727,   0.81327,   0.81934,   0.82548,   0.83168,   0.83794,   0.84423,
   0.85056,   0.85690,   0.86325,   0.86960,   0.87592,   0.88222,   0.88846,
   0.89465,   0.90076,   0.90678,   0.91271,   0.91853,   0.92424,   0.92982,
   0.93528,   0.94061,   0.94580,   0.95086,   0.95579,   0.96058,   0.96523,
   0.96973,   0.97408,   0.97825,   0.98221,   0.98592,   0.98933,   0.99238,
   0.99500,   0.99713,   0.99871,   0.99967,   1.00000},
   //---------  0.58 GeV
  {0.00029,   0.00110,   0.00243,   0.00427,   0.00660,   0.00938,   0.01260,
   0.01623,   0.02027,   0.02469,   0.02948,   0.03464,   0.04015,   0.04601,
   0.05222,   0.05876,   0.06564,   0.07283,   0.08034,   0.08815,   0.09626,
   0.10465,   0.11331,   0.12223,   0.13138,   0.14077,   0.15037,   0.16017,
   0.17014,   0.18027,   0.19055,   0.20096,   0.21147,   0.22207,   0.23275,
   0.24347,   0.25423,   0.26500,   0.27577,   0.28652,   0.29723,   0.30789,
   0.31847,   0.32897,   0.33938,   0.34967,   0.35984,   0.36987,   0.37975,
   0.38948,   0.39905,   0.40845,   0.41767,   0.42671,   0.43556,   0.44423,
   0.45271,   0.46099,   0.46909,   0.47699,   0.48471,   0.49223,   0.49957,
   0.50673,   0.51371,   0.52051,   0.52714,   0.53360,   0.53989,   0.54603,
   0.55201,   0.55785,   0.56354,   0.56908,   0.57450,   0.57978,   0.58494,
   0.58997,   0.59489,   0.59970,   0.60440,   0.60900,   0.61350,   0.61790,
   0.62221,   0.62644,   0.63059,   0.63465,   0.63865,   0.64257,   0.64643,
   0.65022,   0.65395,   0.65763,   0.66125,   0.66483,   0.66836,   0.67184,
   0.67529,   0.67870,   0.68208,   0.68543,   0.68876,   0.69206,   0.69534,
   0.69860,   0.70185,   0.70509,   0.70832,   0.71155,   0.71478,   0.71802,
   0.72126,   0.72451,   0.72777,   0.73105,   0.73436,   0.73769,   0.74105,
   0.74444,   0.74787,   0.75134,   0.75486,   0.75843,   0.76206,   0.76575,
   0.76949,   0.77331,   0.77720,   0.78116,   0.78520,   0.78933,   0.79354,
   0.79784,   0.80222,   0.80670,   0.81128,   0.81594,   0.82070,   0.82555,
   0.83049,   0.83552,   0.84064,   0.84583,   0.85110,   0.85643,   0.86182,
   0.86726,   0.87274,   0.87825,   0.88378,   0.88931,   0.89484,   0.90034,
   0.90581,   0.91122,   0.91657,   0.92185,   0.92703,   0.93212,   0.93710,
   0.94196,   0.94671,   0.95132,   0.95582,   0.96018,   0.96443,   0.96855,
   0.97254,   0.97640,   0.98011,   0.98366,   0.98701,   0.99011,   0.99290,
   0.99532,   0.99731,   0.99878,   0.99969,   1.00000},
   //---------  0.62 GeV
  {0.00033,   0.00125,   0.00277,   0.00487,   0.00752,   0.01069,   0.01436,
   0.01850,   0.02311,   0.02815,   0.03361,   0.03949,   0.04576,   0.05243,
   0.05948,   0.06691,   0.07469,   0.08283,   0.09130,   0.10010,   0.10920,
   0.11860,   0.12828,   0.13822,   0.14841,   0.15881,   0.16943,   0.18023,
   0.19119,   0.20230,   0.21354,   0.22488,   0.23630,   0.24779,   0.25931,
   0.27086,   0.28241,   0.29393,   0.30542,   0.31686,   0.32821,   0.33948,
   0.35063,   0.36166,   0.37255,   0.38329,   0.39387,   0.40427,   0.41448,
   0.42451,   0.43433,   0.44395,   0.45335,   0.46254,   0.47151,   0.48026,
   0.48880,   0.49711,   0.50520,   0.51307,   0.52073,   0.52818,   0.53541,
   0.54245,   0.54928,   0.55592,   0.56236,   0.56862,   0.57470,   0.58061,
   0.58635,   0.59192,   0.59734,   0.60260,   0.60772,   0.61270,   0.61754,
   0.62225,   0.62684,   0.63131,   0.63566,   0.63990,   0.64404,   0.64808,
   0.65203,   0.65588,   0.65965,   0.66334,   0.66695,   0.67049,   0.67396,
   0.67736,   0.68071,   0.68399,   0.68723,   0.69042,   0.69356,   0.69666,
   0.69973,   0.70276,   0.70576,   0.70874,   0.71169,   0.71462,   0.71753,
   0.72043,   0.72332,   0.72620,   0.72908,   0.73195,   0.73483,   0.73772,
   0.74062,   0.74353,   0.74645,   0.74939,   0.75236,   0.75535,   0.75838,
   0.76143,   0.76453,   0.76767,   0.77085,   0.77408,   0.77736,   0.78070,
   0.78410,   0.78756,   0.79110,   0.79470,   0.79838,   0.80214,   0.80598,
   0.80990,   0.81391,   0.81801,   0.82220,   0.82648,   0.83086,   0.83532,
   0.83988,   0.84452,   0.84925,   0.85406,   0.85895,   0.86392,   0.86894,
   0.87403,   0.87916,   0.88433,   0.88952,   0.89474,   0.89995,   0.90515,
   0.91032,   0.91546,   0.92054,   0.92555,   0.93049,   0.93533,   0.94007,
   0.94470,   0.94921,   0.95360,   0.95786,   0.96201,   0.96603,   0.96993,
   0.97371,   0.97737,   0.98090,   0.98427,   0.98746,   0.99043,   0.99312,
   0.99546,   0.99738,   0.99881,   0.99970,   1.00000},
   //---------  0.68 GeV
  {0.00038,   0.00148,   0.00327,   0.00575,   0.00888,   0.01263,   0.01698,
   0.02189,   0.02733,   0.03330,   0.03977,   0.04672,   0.05414,   0.06201,
   0.07032,   0.07906,   0.08819,   0.09771,   0.10760,   0.11783,   0.12839,
   0.13924,   0.15038,   0.16178,   0.17340,   0.18524,   0.19725,   0.20943,
   0.22173,   0.23415,   0.24665,   0.25920,   0.27179,   0.28438,   0.29697,
   0.30951,   0.32199,   0.33439,   0.34669,   0.35887,   0.37091,   0.38279,
   0.39449,   0.40600,   0.41732,   0.42841,   0.43928,   0.44992,   0.46031,
   0.47046,   0.48034,   0.48997,   0.49934,   0.50844,   0.51728,   0.52586,
   0.53418,   0.54223,   0.55003,   0.55758,   0.56489,   0.57195,   0.57877,
   0.58536,   0.59173,   0.59789,   0.60383,   0.60957,   0.61511,   0.62047,
   0.62564,   0.63064,   0.63546,   0.64013,   0.64464,   0.64901,   0.65323,
   0.65732,   0.66128,   0.66512,   0.66884,   0.67245,   0.67596,   0.67937,
   0.68269,   0.68592,   0.68907,   0.69215,   0.69515,   0.69809,   0.70097,
   0.70379,   0.70656,   0.70928,   0.71196,   0.71460,   0.71721,   0.71978,
   0.72233,   0.72486,   0.72737,   0.72986,   0.73234,   0.73481,   0.73728,
   0.73974,   0.74221,   0.74467,   0.74715,   0.74963,   0.75212,   0.75463,
   0.75715,   0.75970,   0.76227,   0.76486,   0.76748,   0.77013,   0.77282,
   0.77554,   0.77830,   0.78110,   0.78395,   0.78685,   0.78980,   0.79281,
   0.79587,   0.79899,   0.80218,   0.80544,   0.80877,   0.81217,   0.81565,
   0.81921,   0.82286,   0.82659,   0.83040,   0.83431,   0.83831,   0.84240,
   0.84658,   0.85085,   0.85521,   0.85966,   0.86419,   0.86881,   0.87350,
   0.87825,   0.88307,   0.88794,   0.89285,   0.89779,   0.90274,   0.90771,
   0.91266,   0.91760,   0.92249,   0.92733,   0.93211,   0.93681,   0.94141,
   0.94592,   0.95031,   0.95459,   0.95874,   0.96278,   0.96669,   0.97048,
   0.97416,   0.97772,   0.98115,   0.98444,   0.98757,   0.99048,   0.99313,
   0.99546,   0.99737,   0.99881,   0.99970,   1.00000},
   //---------  0.74 GeV
  {0.00043,   0.00168,   0.00373,   0.00655,   0.01012,   0.01440,   0.01935,
   0.02495,   0.03117,   0.03798,   0.04537,   0.05330,   0.06176,   0.07073,
   0.08018,   0.09010,   0.10045,   0.11121,   0.12235,   0.13386,   0.14569,
   0.15782,   0.17022,   0.18285,   0.19570,   0.20873,   0.22190,   0.23519,
   0.24856,   0.26200,   0.27546,   0.28892,   0.30236,   0.31574,   0.32905,
   0.34225,   0.35532,   0.36824,   0.38099,   0.39355,   0.40591,   0.41803,
   0.42992,   0.44155,   0.45292,   0.46401,   0.47482,   0.48533,   0.49555,
   0.50547,   0.51509,   0.52440,   0.53341,   0.54212,   0.55052,   0.55863,
   0.56645,   0.57398,   0.58123,   0.58821,   0.59492,   0.60137,   0.60757,
   0.61353,   0.61925,   0.62475,   0.63002,   0.63509,   0.63996,   0.64464,
   0.64913,   0.65345,   0.65761,   0.66160,   0.66545,   0.66915,   0.67272,
   0.67616,   0.67948,   0.68269,   0.68580,   0.68880,   0.69171,   0.69454,
   0.69729,   0.69997,   0.70258,   0.70512,   0.70762,   0.71006,   0.71246,
   0.71482,   0.71714,   0.71943,   0.72170,   0.72395,   0.72618,   0.72840,
   0.73060,   0.73280,   0.73500,   0.73720,   0.73941,   0.74162,   0.74384,
   0.74607,   0.74831,   0.75057,   0.75286,   0.75516,   0.75748,   0.75983,
   0.76221,   0.76461,   0.76705,   0.76952,   0.77202,   0.77456,   0.77713,
   0.77975,   0.78240,   0.78510,   0.78784,   0.79063,   0.79348,   0.79637,
   0.79932,   0.80232,   0.80538,   0.80851,   0.81170,   0.81497,   0.81830,
   0.82170,   0.82519,   0.82875,   0.83240,   0.83613,   0.83995,   0.84386,
   0.84785,   0.85194,   0.85612,   0.86038,   0.86474,   0.86918,   0.87370,
   0.87829,   0.88296,   0.88769,   0.89247,   0.89730,   0.90216,   0.90704,
   0.91193,   0.91682,   0.92168,   0.92650,   0.93127,   0.93598,   0.94061,
   0.94514,   0.94957,   0.95389,   0.95809,   0.96217,   0.96613,   0.96997,
   0.97368,   0.97728,   0.98075,   0.98409,   0.98726,   0.99022,   0.99293,
   0.99531,   0.99728,   0.99877,   0.99969,   1.00000},
   //---------  0.80 GeV
  {0.00048,   0.00187,   0.00414,   0.00728,   0.01125,   0.01601,   0.02152,
   0.02775,   0.03467,   0.04225,   0.05046,   0.05928,   0.06868,   0.07863,
   0.08910,   0.10007,   0.11150,   0.12335,   0.13560,   0.14821,   0.16114,
   0.17435,   0.18782,   0.20150,   0.21536,   0.22936,   0.24347,   0.25764,
   0.27186,   0.28608,   0.30027,   0.31440,   0.32844,   0.34237,   0.35615,
   0.36976,   0.38318,   0.39638,   0.40935,   0.42206,   0.43450,   0.44666,
   0.45851,   0.47006,   0.48128,   0.49218,   0.50275,   0.51298,   0.52287,
   0.53242,   0.54164,   0.55052,   0.55906,   0.56728,   0.57518,   0.58275,
   0.59002,   0.59699,   0.60366,   0.61005,   0.61617,   0.62202,   0.62761,
   0.63296,   0.63808,   0.64296,   0.64764,   0.65210,   0.65637,   0.66046,
   0.66436,   0.66811,   0.67169,   0.67512,   0.67841,   0.68157,   0.68461,
   0.68753,   0.69035,   0.69306,   0.69568,   0.69822,   0.70068,   0.70307,
   0.70539,   0.70766,   0.70987,   0.71204,   0.71417,   0.71626,   0.71833,
   0.72037,   0.72239,   0.72440,   0.72639,   0.72838,   0.73037,   0.73236,
   0.73436,   0.73636,   0.73838,   0.74041,   0.74246,   0.74452,   0.74661,
   0.74873,   0.75086,   0.75303,   0.75523,   0.75745,   0.75971,   0.76200,
   0.76433,   0.76669,   0.76909,   0.77153,   0.77400,   0.77651,   0.77907,
   0.78166,   0.78429,   0.78697,   0.78969,   0.79245,   0.79526,   0.79812,
   0.80103,   0.80399,   0.80700,   0.81007,   0.81320,   0.81639,   0.81964,
   0.82296,   0.82635,   0.82981,   0.83334,   0.83696,   0.84066,   0.84444,
   0.84831,   0.85226,   0.85630,   0.86044,   0.86466,   0.86896,   0.87336,
   0.87783,   0.88238,   0.88701,   0.89170,   0.89644,   0.90123,   0.90605,
   0.91089,   0.91575,   0.92059,   0.92542,   0.93020,   0.93493,   0.93959,
   0.94417,   0.94865,   0.95303,   0.95729,   0.96143,   0.96545,   0.96935,
   0.97312,   0.97677,   0.98030,   0.98369,   0.98691,   0.98994,   0.99271,
   0.99516,   0.99719,   0.99872,   0.99968,   1.00000},
   //---------  0.90 GeV
  {0.00056,   0.00217,   0.00482,   0.00847,   0.01308,   0.01861,   0.02502,
   0.03227,   0.04031,   0.04912,   0.05865,   0.06887,   0.07974,   0.09123,
   0.10329,   0.11587,   0.12895,   0.14246,   0.15636,   0.17061,   0.18515,
   0.19995,   0.21495,   0.23011,   0.24538,   0.26072,   0.27608,   0.29143,
   0.30673,   0.32194,   0.33703,   0.35195,   0.36668,   0.38120,   0.39547,
   0.40947,   0.42318,   0.43658,   0.44965,   0.46238,   0.47475,   0.48676,
   0.49839,   0.50964,   0.52050,   0.53098,   0.54108,   0.55078,   0.56011,
   0.56906,   0.57764,   0.58586,   0.59372,   0.60123,   0.60840,   0.61525,
   0.62178,   0.62800,   0.63392,   0.63957,   0.64494,   0.65004,   0.65490,
   0.65952,   0.66392,   0.66809,   0.67206,   0.67584,   0.67943,   0.68285,
   0.68611,   0.68921,   0.69217,   0.69499,   0.69768,   0.70026,   0.70273,
   0.70511,   0.70739,   0.70958,   0.71170,   0.71376,   0.71575,   0.71768,
   0.71958,   0.72142,   0.72324,   0.72502,   0.72679,   0.72853,   0.73026,
   0.73199,   0.73371,   0.73543,   0.73715,   0.73889,   0.74063,   0.74239,
   0.74417,   0.74597,   0.74779,   0.74964,   0.75151,   0.75342,   0.75535,
   0.75732,   0.75933,   0.76137,   0.76345,   0.76556,   0.76771,   0.76990,
   0.77213,   0.77440,   0.77671,   0.77905,   0.78144,   0.78386,   0.78632,
   0.78882,   0.79135,   0.79393,   0.79654,   0.79919,   0.80188,   0.80461,
   0.80739,   0.81020,   0.81306,   0.81596,   0.81891,   0.82191,   0.82497,
   0.82808,   0.83125,   0.83448,   0.83778,   0.84115,   0.84459,   0.84811,
   0.85170,   0.85538,   0.85914,   0.86299,   0.86693,   0.87095,   0.87507,
   0.87927,   0.88355,   0.88792,   0.89236,   0.89687,   0.90145,   0.90608,
   0.91075,   0.91545,   0.92017,   0.92489,   0.92960,   0.93427,   0.93890,
   0.94346,   0.94794,   0.95233,   0.95661,   0.96078,   0.96484,   0.96877,
   0.97257,   0.97626,   0.97982,   0.98324,   0.98651,   0.98960,   0.99244,
   0.99495,   0.99706,   0.99866,   0.99966,   1.00000},
   //---------  1.00 GeV
  {0.00064,   0.00248,   0.00552,   0.00970,   0.01498,   0.02132,   0.02865,
   0.03694,   0.04614,   0.05619,   0.06706,   0.07870,   0.09105,   0.10406,
   0.11768,   0.13184,   0.14650,   0.16159,   0.17704,   0.19281,   0.20883,
   0.22505,   0.24140,   0.25784,   0.27431,   0.29076,   0.30714,   0.32342,
   0.33955,   0.35548,   0.37119,   0.38664,   0.40181,   0.41666,   0.43117,
   0.44532,   0.45910,   0.47248,   0.48546,   0.49803,   0.51018,   0.52191,
   0.53321,   0.54408,   0.55453,   0.56457,   0.57418,   0.58339,   0.59220,
   0.60062,   0.60867,   0.61634,   0.62365,   0.63062,   0.63725,   0.64356,
   0.64957,   0.65527,   0.66069,   0.66583,   0.67071,   0.67534,   0.67973,
   0.68389,   0.68784,   0.69158,   0.69512,   0.69848,   0.70167,   0.70468,
   0.70755,   0.71027,   0.71285,   0.71530,   0.71764,   0.71987,   0.72201,
   0.72405,   0.72601,   0.72789,   0.72971,   0.73147,   0.73319,   0.73485,
   0.73649,   0.73809,   0.73967,   0.74123,   0.74278,   0.74432,   0.74586,
   0.74740,   0.74894,   0.75050,   0.75206,   0.75365,   0.75525,   0.75687,
   0.75852,   0.76020,   0.76190,   0.76363,   0.76539,   0.76719,   0.76902,
   0.77088,   0.77278,   0.77472,   0.77669,   0.77871,   0.78076,   0.78284,
   0.78497,   0.78713,   0.78932,   0.79156,   0.79382,   0.79613,   0.79846,
   0.80083,   0.80322,   0.80565,   0.80811,   0.81060,   0.81311,   0.81566,
   0.81824,   0.82085,   0.82349,   0.82617,   0.82889,   0.83164,   0.83444,
   0.83728,   0.84017,   0.84311,   0.84611,   0.84916,   0.85228,   0.85547,
   0.85872,   0.86205,   0.86546,   0.86895,   0.87252,   0.87618,   0.87992,
   0.88376,   0.88768,   0.89169,   0.89578,   0.89995,   0.90420,   0.90852,
   0.91289,   0.91732,   0.92179,   0.92627,   0.93077,   0.93526,   0.93973,
   0.94415,   0.94851,   0.95279,   0.95699,   0.96108,   0.96506,   0.96892,
   0.97267,   0.97630,   0.97980,   0.98319,   0.98642,   0.98949,   0.99233,
   0.99486,   0.99700,   0.99863,   0.99965,   1.00000},
   //---------  1.10 GeV
  {0.00072,   0.00280,   0.00623,   0.01096,   0.01693,   0.02409,   0.03237,
   0.04173,   0.05210,   0.06342,   0.07565,   0.08870,   0.10253,   0.11705,
   0.13220,   0.14790,   0.16408,   0.18067,   0.19759,   0.21477,   0.23214,
   0.24964,   0.26719,   0.28474,   0.30223,   0.31961,   0.33682,   0.35382,
   0.37056,   0.38702,   0.40315,   0.41893,   0.43433,   0.44933,   0.46390,
   0.47804,   0.49173,   0.50497,   0.51774,   0.53005,   0.54190,   0.55328,
   0.56421,   0.57468,   0.58471,   0.59431,   0.60348,   0.61224,   0.62059,
   0.62856,   0.63616,   0.64339,   0.65028,   0.65683,   0.66306,   0.66897,
   0.67460,   0.67993,   0.68499,   0.68979,   0.69434,   0.69865,   0.70273,
   0.70659,   0.71025,   0.71370,   0.71696,   0.72004,   0.72295,   0.72570,
   0.72830,   0.73076,   0.73309,   0.73529,   0.73738,   0.73937,   0.74127,
   0.74308,   0.74481,   0.74648,   0.74809,   0.74964,   0.75116,   0.75264,
   0.75410,   0.75554,   0.75696,   0.75837,   0.75978,   0.76120,   0.76262,
   0.76405,   0.76550,   0.76697,   0.76845,   0.76996,   0.77150,   0.77306,
   0.77465,   0.77627,   0.77792,   0.77961,   0.78133,   0.78308,   0.78487,
   0.78669,   0.78855,   0.79045,   0.79238,   0.79435,   0.79636,   0.79840,
   0.80047,   0.80258,   0.80472,   0.80690,   0.80910,   0.81133,   0.81358,
   0.81586,   0.81816,   0.82049,   0.82283,   0.82519,   0.82757,   0.82997,
   0.83238,   0.83482,   0.83727,   0.83974,   0.84224,   0.84476,   0.84730,
   0.84988,   0.85249,   0.85514,   0.85782,   0.86056,   0.86334,   0.86617,
   0.86906,   0.87201,   0.87502,   0.87811,   0.88127,   0.88450,   0.88782,
   0.89121,   0.89469,   0.89826,   0.90191,   0.90565,   0.90947,   0.91337,
   0.91734,   0.92138,   0.92547,   0.92961,   0.93377,   0.93795,   0.94213,
   0.94628,   0.95040,   0.95446,   0.95845,   0.96235,   0.96616,   0.96986,
   0.97345,   0.97693,   0.98029,   0.98355,   0.98667,   0.98964,   0.99241,
   0.99489,   0.99700,   0.99862,   0.99965,   1.00000},
   //---------  1.20 GeV
  {0.00080,   0.00312,   0.00693,   0.01219,   0.01884,   0.02680,   0.03601,
   0.04640,   0.05791,   0.07047,   0.08400,   0.09841,   0.11364,   0.12959,
   0.14617,   0.16331,   0.18089,   0.19885,   0.21709,   0.23553,   0.25408,
   0.27268,   0.29125,   0.30973,   0.32804,   0.34614,   0.36398,   0.38151,
   0.39868,   0.41547,   0.43184,   0.44777,   0.46324,   0.47822,   0.49272,
   0.50672,   0.52021,   0.53319,   0.54567,   0.55765,   0.56914,   0.58014,
   0.59067,   0.60074,   0.61035,   0.61953,   0.62829,   0.63665,   0.64461,
   0.65220,   0.65943,   0.66631,   0.67286,   0.67909,   0.68501,   0.69065,
   0.69600,   0.70108,   0.70589,   0.71046,   0.71479,   0.71889,   0.72276,
   0.72642,   0.72988,   0.73314,   0.73621,   0.73910,   0.74183,   0.74439,
   0.74681,   0.74908,   0.75123,   0.75325,   0.75516,   0.75697,   0.75869,
   0.76033,   0.76190,   0.76341,   0.76486,   0.76628,   0.76766,   0.76902,
   0.77036,   0.77169,   0.77301,   0.77434,   0.77568,   0.77704,   0.77841,
   0.77980,   0.78121,   0.78266,   0.78413,   0.78563,   0.78717,   0.78873,
   0.79034,   0.79197,   0.79364,   0.79535,   0.79710,   0.79888,   0.80069,
   0.80255,   0.80444,   0.80636,   0.80833,   0.81033,   0.81236,   0.81443,
   0.81653,   0.81866,   0.82082,   0.82301,   0.82522,   0.82746,   0.82971,
   0.83198,   0.83427,   0.83656,   0.83887,   0.84118,   0.84350,   0.84582,
   0.84815,   0.85047,   0.85280,   0.85514,   0.85747,   0.85982,   0.86217,
   0.86453,   0.86690,   0.86929,   0.87171,   0.87414,   0.87661,   0.87910,
   0.88163,   0.88421,   0.88683,   0.88950,   0.89223,   0.89502,   0.89788,
   0.90080,   0.90380,   0.90688,   0.91003,   0.91328,   0.91660,   0.92001,
   0.92349,   0.92705,   0.93068,   0.93437,   0.93811,   0.94189,   0.94568,
   0.94948,   0.95326,   0.95701,   0.96071,   0.96434,   0.96789,   0.97135,
   0.97472,   0.97798,   0.98115,   0.98421,   0.98717,   0.98999,   0.99263,
   0.99502,   0.99707,   0.99865,   0.99965,   1.00000}
 };

 // CM momentum (GeV/c)
 G4float G4AngularDistributionNP::pcm[NENERGY] = {
   0.685E-01, 0.969E-01, 0.119, 0.153, 0.181, 0.217, 0.256,
   0.291, 0.336, 0.399, 0.444, 0.484, 0.522, 0.539,
   0.565, 0.589, 0.613, 0.650, 0.685, 0.718, 0.750
 };

 // Lab energy (GeV)
 G4float G4AngularDistributionNP::elab[NENERGY] = {
   0.100E-01, 0.200E-01, 0.300E-01, 0.500E-01, 0.700E-01, 0.100, 0.140,
   0.180, 0.240, 0.340, 0.420, 0.500, 0.580, 0.620,
   0.680, 0.740, 0.800, 0.900,  1.00,  1.10,  1.20
 };

 // Max dsigma/domega-CM (mb/sr)
 G4float G4AngularDistributionNP::dsigmax[NENERGY] = {
   79.0,  43.0,  29.8,  20.0,  16.3,  14.5,  13.3,
   12.6,  11.9,  11.3,  11.1,  10.7,  9.69,  10.1,
   11.4,  12.5,  13.3,  14.5,  15.6,  16.9,  18.3
 };

 // Total cross section
 G4float G4AngularDistributionNP::sigtot[NENERGY] = {
   947.,  485.,  310.,  168.,  110.,  75.7,  55.2,
   45.9,  39.1,  34.1,  32.3,  31.3,  30.1,  29.5,
   28.4,  27.4,  26.4,  24.8,  23.4,  22.4,  21.9    
 };
