//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//

 // G4 Low energy model: n-n or p-p scattering -- Data
 // THIS FILE contains static array initialization
 // F.W. Jones, L.G. Greeniaus, H.P. Wellisch

 // Table of Cumulative nn or pp Scattering Probabilities
 // To be used for generation as a function of std::cos(theta cm)
 // Coulomb effects are SUPPRESSED
 // -- including pp Coulomb-nuclear interference  
 // NOTE: Assumes angle range to be generated is 0-180 degrees  
 //       even for IDENTICAL particles.  This allows tracking of  
 //       well-defined GEANT4 particles and generation of secondary  
 // Range of validity of tables: 10 - 1200 MeV  
 // Results are extracted from RA Arndt's PSA of 1998  
 // CM Angle range: 0.5 - 179.5 degrees in 1 degree steps  
 
 // CM momentum (GeV/c)
 G4float G4AngularDistributionPP::pcm[NENERGY] = {
     0.685E-01, 0.969E-01, 0.137, 0.181, 0.217, 0.237, 0.256,
     0.291, 0.321, 0.349, 0.363, 0.375, 0.400, 0.444,
     0.494, 0.540, 0.573, 0.613, 0.650, 0.685, 0.719, 0.751
 };
 
 // Lab energy (GeV)
 G4float G4AngularDistributionPP::elab[NENERGY] = {
     0.100E-01, 0.200E-01, 0.400E-01, 0.700E-01, 0.100, 0.120, 0.140,
     0.180, 0.220, 0.260, 0.280, 0.300, 0.340, 0.420,
     0.520, 0.620, 0.700, 0.800, 0.900, 1.00, 1.10, 1.20
 };
 
 // Max dSigma/domega-CM (mb/sr)
 G4float G4AngularDistributionPP::dsigmax[NENERGY] = {
     63.9, 29.9, 14.5, 8.97, 7.23, 6.66, 6.30,
     5.89, 5.68, 5.57, 5.56, 5.57, 5.74, 6.38,
     7.66, 9.65, 12.4, 15.6, 18.0, 20.1, 22.0, 23.8
 };
 
 // Total cross section
 G4float G4AngularDistributionPP::sigtot[NENERGY] = {
     396., 179., 80.7, 44.5, 32.8, 29.0, 26.9,
     24.9, 24.4, 24.3, 24.4, 24.4, 24.7, 25.5,
     26.4, 26.1, 25.6, 25.1, 24.4, 23.4, 22.4, 21.5
 };
 
 G4float G4AngularDistributionPP::sig[NENERGY][NANGLE] = {
     //------------  0.01 GeV
    {0.00008,   0.00031,   0.00070,   0.00124,   0.00193,   0.00278,   0.00378,
     0.00494,   0.00624,   0.00770,   0.00932,   0.01108,   0.01299,   0.01506,
     0.01727,   0.01963,   0.02214,   0.02480,   0.02760,   0.03055,   0.03364,
     0.03687,   0.04025,   0.04377,   0.04743,   0.05122,   0.05515,   0.05922,
     0.06342,   0.06776,   0.07223,   0.07682,   0.08155,   0.08640,   0.09138,
     0.09649,   0.10171,   0.10706,   0.11252,   0.11810,   0.12380,   0.12961,
     0.13553,   0.14156,   0.14770,   0.15395,   0.16030,   0.16675,   0.17330,
     0.17995,   0.18670,   0.19354,   0.20047,   0.20749,   0.21459,   0.22179,
     0.22906,   0.23642,   0.24385,   0.25136,   0.25895,   0.26660,   0.27433,
     0.28212,   0.28998,   0.29790,   0.30587,   0.31391,   0.32200,   0.33015,
     0.33834,   0.34658,   0.35487,   0.36320,   0.37157,   0.37998,   0.38842,
     0.39690,   0.40540,   0.41394,   0.42250,   0.43108,   0.43968,   0.44830,
     0.45694,   0.46559,   0.47424,   0.48291,   0.49158,   0.50025,   0.50892,
     0.51759,   0.52626,   0.53492,   0.54356,   0.55220,   0.56081,   0.56941,
     0.57799,   0.58655,   0.59508,   0.60358,   0.61206,   0.62050,   0.62890,
     0.63726,   0.64559,   0.65387,   0.66211,   0.67029,   0.67843,   0.68652,
     0.69455,   0.70252,   0.71043,   0.71828,   0.72607,   0.73378,   0.74143,
     0.74901,   0.75651,   0.76394,   0.77128,   0.77855,   0.78574,   0.79283,
     0.79985,   0.80677,   0.81360,   0.82033,   0.82697,   0.83352,   0.83996,
     0.84630,   0.85254,   0.85867,   0.86469,   0.87060,   0.87641,   0.88209,
     0.88767,   0.89312,   0.89846,   0.90368,   0.90877,   0.91374,   0.91859,
     0.92331,   0.92790,   0.93236,   0.93669,   0.94088,   0.94494,   0.94887,
     0.95266,   0.95631,   0.95982,   0.96319,   0.96642,   0.96951,   0.97245,
     0.97525,   0.97790,   0.98040,   0.98276,   0.98497,   0.98703,   0.98894,
     0.99070,   0.99231,   0.99377,   0.99507,   0.99623,   0.99723,   0.99807,
     0.99877,   0.99931,   0.99969,   0.99992,   1.00000},
     //---------  0.02 GeV
    {0.00008,   0.00032,   0.00072,   0.00128,   0.00199,   0.00287,   0.00390,
     0.00509,   0.00644,   0.00795,   0.00961,   0.01142,   0.01339,   0.01552,
     0.01779,   0.02022,   0.02280,   0.02553,   0.02840,   0.03142,   0.03459,
     0.03790,   0.04136,   0.04495,   0.04869,   0.05256,   0.05658,   0.06072,
     0.06500,   0.06942,   0.07396,   0.07863,   0.08343,   0.08835,   0.09340,
     0.09857,   0.10386,   0.10927,   0.11479,   0.12042,   0.12617,   0.13203,
     0.13800,   0.14407,   0.15025,   0.15653,   0.16290,   0.16938,   0.17595,
     0.18262,   0.18938,   0.19622,   0.20316,   0.21018,   0.21728,   0.22447,
     0.23173,   0.23907,   0.24648,   0.25397,   0.26152,   0.26914,   0.27683,
     0.28458,   0.29240,   0.30027,   0.30819,   0.31617,   0.32420,   0.33229,
     0.34041,   0.34859,   0.35680,   0.36506,   0.37335,   0.38168,   0.39004,
     0.39843,   0.40685,   0.41529,   0.42376,   0.43225,   0.44076,   0.44928,
     0.45782,   0.46637,   0.47493,   0.48350,   0.49207,   0.50064,   0.50921,
     0.51778,   0.52634,   0.53490,   0.54344,   0.55198,   0.56050,   0.56900,
     0.57748,   0.58594,   0.59438,   0.60279,   0.61117,   0.61952,   0.62783,
     0.63611,   0.64435,   0.65256,   0.66071,   0.66883,   0.67689,   0.68491,
     0.69287,   0.70078,   0.70863,   0.71642,   0.72416,   0.73182,   0.73943,
     0.74696,   0.75443,   0.76182,   0.76914,   0.77638,   0.78354,   0.79062,
     0.79762,   0.80453,   0.81136,   0.81809,   0.82473,   0.83128,   0.83774,
     0.84410,   0.85035,   0.85651,   0.86256,   0.86850,   0.87434,   0.88006,
     0.88568,   0.89118,   0.89656,   0.90183,   0.90698,   0.91201,   0.91691,
     0.92169,   0.92635,   0.93087,   0.93527,   0.93953,   0.94366,   0.94765,
     0.95151,   0.95523,   0.95882,   0.96226,   0.96555,   0.96871,   0.97172,
     0.97458,   0.97730,   0.97986,   0.98228,   0.98455,   0.98666,   0.98863,
     0.99043,   0.99209,   0.99359,   0.99493,   0.99612,   0.99714,   0.99802,
     0.99873,   0.99929,   0.99968,   0.99992,   1.00000},
     //---------  0.04 GeV
    {0.00009,   0.00034,   0.00077,   0.00138,   0.00215,   0.00309,   0.00421,
     0.00549,   0.00694,   0.00855,   0.01033,   0.01228,   0.01438,   0.01665,
     0.01908,   0.02166,   0.02440,   0.02729,   0.03033,   0.03352,   0.03686,
     0.04034,   0.04397,   0.04773,   0.05164,   0.05568,   0.05986,   0.06417,
     0.06861,   0.07318,   0.07787,   0.08269,   0.08763,   0.09269,   0.09786,
     0.10316,   0.10856,   0.11408,   0.11970,   0.12543,   0.13127,   0.13720,
     0.14324,   0.14938,   0.15561,   0.16194,   0.16836,   0.17487,   0.18146,
     0.18815,   0.19491,   0.20176,   0.20868,   0.21569,   0.22277,   0.22992,
     0.23714,   0.24443,   0.25179,   0.25921,   0.26669,   0.27424,   0.28184,
     0.28949,   0.29721,   0.30497,   0.31278,   0.32064,   0.32854,   0.33649,
     0.34448,   0.35250,   0.36057,   0.36867,   0.37680,   0.38496,   0.39314,
     0.40136,   0.40960,   0.41786,   0.42614,   0.43444,   0.44275,   0.45108,
     0.45942,   0.46777,   0.47612,   0.48448,   0.49285,   0.50121,   0.50958,
     0.51794,   0.52630,   0.53465,   0.54299,   0.55132,   0.55963,   0.56794,
     0.57622,   0.58449,   0.59273,   0.60095,   0.60914,   0.61731,   0.62545,
     0.63355,   0.64163,   0.64966,   0.65766,   0.66562,   0.67354,   0.68141,
     0.68923,   0.69701,   0.70474,   0.71241,   0.72003,   0.72760,   0.73510,
     0.74255,   0.74993,   0.75725,   0.76450,   0.77168,   0.77878,   0.78582,
     0.79278,   0.79966,   0.80647,   0.81319,   0.81983,   0.82638,   0.83285,
     0.83922,   0.84551,   0.85170,   0.85779,   0.86379,   0.86969,   0.87548,
     0.88117,   0.88675,   0.89223,   0.89759,   0.90285,   0.90799,   0.91301,
     0.91791,   0.92269,   0.92735,   0.93189,   0.93629,   0.94057,   0.94472,
     0.94873,   0.95261,   0.95635,   0.95995,   0.96341,   0.96672,   0.96989,
     0.97291,   0.97578,   0.97850,   0.98106,   0.98347,   0.98572,   0.98781,
     0.98974,   0.99151,   0.99311,   0.99455,   0.99582,   0.99693,   0.99786,
     0.99863,   0.99923,   0.99966,   0.99991,   1.00000},
     //---------  0.07 GeV
    {0.00010,   0.00039,   0.00087,   0.00154,   0.00240,   0.00345,   0.00469,
     0.00611,   0.00771,   0.00950,   0.01146,   0.01359,   0.01590,   0.01837,
     0.02101,   0.02381,   0.02677,   0.02988,   0.03314,   0.03656,   0.04012,
     0.04382,   0.04767,   0.05165,   0.05577,   0.06001,   0.06439,   0.06889,
     0.07352,   0.07827,   0.08314,   0.08812,   0.09322,   0.09843,   0.10376,
     0.10919,   0.11472,   0.12036,   0.12610,   0.13193,   0.13787,   0.14389,
     0.15001,   0.15622,   0.16252,   0.16890,   0.17537,   0.18191,   0.18854,
     0.19524,   0.20202,   0.20886,   0.21578,   0.22277,   0.22981,   0.23693,
     0.24410,   0.25133,   0.25862,   0.26596,   0.27335,   0.28079,   0.28828,
     0.29582,   0.30340,   0.31102,   0.31868,   0.32638,   0.33411,   0.34187,
     0.34967,   0.35750,   0.36535,   0.37323,   0.38114,   0.38906,   0.39701,
     0.40498,   0.41296,   0.42096,   0.42898,   0.43700,   0.44504,   0.45309,
     0.46114,   0.46921,   0.47727,   0.48534,   0.49342,   0.50149,   0.50956,
     0.51763,   0.52569,   0.53375,   0.54181,   0.54985,   0.55789,   0.56591,
     0.57392,   0.58191,   0.58989,   0.59786,   0.60580,   0.61372,   0.62162,
     0.62950,   0.63734,   0.64517,   0.65296,   0.66072,   0.66845,   0.67614,
     0.68380,   0.69142,   0.69899,   0.70653,   0.71402,   0.72146,   0.72886,
     0.73621,   0.74350,   0.75074,   0.75792,   0.76504,   0.77210,   0.77910,
     0.78603,   0.79289,   0.79969,   0.80641,   0.81306,   0.81963,   0.82612,
     0.83253,   0.83886,   0.84511,   0.85126,   0.85733,   0.86331,   0.86919,
     0.87497,   0.88066,   0.88625,   0.89174,   0.89712,   0.90239,   0.90756,
     0.91261,   0.91755,   0.92238,   0.92708,   0.93167,   0.93614,   0.94047,
     0.94469,   0.94877,   0.95271,   0.95653,   0.96020,   0.96373,   0.96712,
     0.97035,   0.97344,   0.97638,   0.97915,   0.98177,   0.98422,   0.98651,
     0.98863,   0.99057,   0.99234,   0.99394,   0.99535,   0.99657,   0.99762,
     0.99847,   0.99914,   0.99962,   0.99990,   1.00000},
     //---------  0.1 GeV
    {0.00011,   0.00042,   0.00095,   0.00168,   0.00262,   0.00377,   0.00511,
     0.00665,   0.00838,   0.01030,   0.01240,   0.01469,   0.01714,   0.01977,
     0.02257,   0.02552,   0.02863,   0.03189,   0.03531,   0.03886,   0.04256,
     0.04640,   0.05037,   0.05447,   0.05871,   0.06306,   0.06754,   0.07214,
     0.07686,   0.08170,   0.08664,   0.09170,   0.09687,   0.10214,   0.10752,
     0.11300,   0.11858,   0.12426,   0.13004,   0.13591,   0.14187,   0.14792,
     0.15406,   0.16028,   0.16659,   0.17297,   0.17944,   0.18598,   0.19259,
     0.19928,   0.20604,   0.21286,   0.21974,   0.22669,   0.23370,   0.24077,
     0.24789,   0.25506,   0.26229,   0.26956,   0.27688,   0.28425,   0.29166,
     0.29910,   0.30659,   0.31411,   0.32167,   0.32926,   0.33688,   0.34453,
     0.35221,   0.35991,   0.36764,   0.37539,   0.38316,   0.39096,   0.39877,
     0.40660,   0.41444,   0.42230,   0.43017,   0.43805,   0.44594,   0.45384,
     0.46174,   0.46966,   0.47757,   0.48549,   0.49342,   0.50134,   0.50926,
     0.51718,   0.52510,   0.53301,   0.54091,   0.54881,   0.55670,   0.56458,
     0.57244,   0.58030,   0.58814,   0.59596,   0.60377,   0.61156,   0.61933,
     0.62707,   0.63480,   0.64250,   0.65017,   0.65782,   0.66544,   0.67303,
     0.68058,   0.68810,   0.69559,   0.70304,   0.71045,   0.71781,   0.72514,
     0.73242,   0.73965,   0.74683,   0.75396,   0.76103,   0.76805,   0.77502,
     0.78192,   0.78876,   0.79553,   0.80224,   0.80888,   0.81544,   0.82194,
     0.82835,   0.83469,   0.84095,   0.84712,   0.85321,   0.85922,   0.86513,
     0.87095,   0.87668,   0.88231,   0.88785,   0.89329,   0.89862,   0.90385,
     0.90898,   0.91400,   0.91890,   0.92370,   0.92838,   0.93294,   0.93739,
     0.94171,   0.94591,   0.94998,   0.95392,   0.95773,   0.96140,   0.96493,
     0.96832,   0.97156,   0.97465,   0.97758,   0.98036,   0.98296,   0.98541,
     0.98767,   0.98976,   0.99167,   0.99339,   0.99492,   0.99626,   0.99739,
     0.99833,   0.99906,   0.99958,   0.99990,   1.00000},
     //---------  0.12 GeV
    {0.00011,   0.00044,   0.00099,   0.00175,   0.00272,   0.00391,   0.00530,
     0.00689,   0.00867,   0.01065,   0.01280,   0.01514,   0.01765,   0.02033,
     0.02318,   0.02618,   0.02933,   0.03263,   0.03608,   0.03966,   0.04339,
     0.04724,   0.05123,   0.05534,   0.05958,   0.06394,   0.06842,   0.07302,
     0.07773,   0.08255,   0.08748,   0.09252,   0.09767,   0.10292,   0.10827,
     0.11372,   0.11927,   0.12492,   0.13066,   0.13649,   0.14242,   0.14843,
     0.15453,   0.16071,   0.16697,   0.17332,   0.17974,   0.18624,   0.19281,
     0.19945,   0.20617,   0.21295,   0.21979,   0.22670,   0.23367,   0.24070,
     0.24778,   0.25492,   0.26211,   0.26935,   0.27664,   0.28398,   0.29136,
     0.29878,   0.30624,   0.31375,   0.32129,   0.32886,   0.33647,   0.34411,
     0.35178,   0.35948,   0.36720,   0.37495,   0.38273,   0.39052,   0.39834,
     0.40618,   0.41403,   0.42190,   0.42978,   0.43768,   0.44559,   0.45351,
     0.46144,   0.46937,   0.47731,   0.48525,   0.49320,   0.50114,   0.50909,
     0.51703,   0.52497,   0.53291,   0.54084,   0.54876,   0.55667,   0.56456,
     0.57245,   0.58032,   0.58818,   0.59602,   0.60383,   0.61163,   0.61941,
     0.62717,   0.63490,   0.64260,   0.65027,   0.65792,   0.66553,   0.67311,
     0.68066,   0.68817,   0.69564,   0.70307,   0.71046,   0.71781,   0.72511,
     0.73237,   0.73957,   0.74673,   0.75383,   0.76088,   0.76787,   0.77480,
     0.78166,   0.78847,   0.79521,   0.80188,   0.80848,   0.81501,   0.82147,
     0.82785,   0.83415,   0.84038,   0.84652,   0.85257,   0.85854,   0.86442,
     0.87022,   0.87592,   0.88152,   0.88703,   0.89245,   0.89776,   0.90297,
     0.90808,   0.91309,   0.91798,   0.92277,   0.92745,   0.93201,   0.93646,
     0.94079,   0.94500,   0.94908,   0.95304,   0.95687,   0.96057,   0.96413,
     0.96756,   0.97084,   0.97397,   0.97695,   0.97978,   0.98244,   0.98494,
     0.98726,   0.98941,   0.99137,   0.99315,   0.99473,   0.99611,   0.99729,
     0.99826,   0.99902,   0.99956,   0.99989,   1.00000},
     //---------  0.14 GeV
    {0.00011,   0.00045,   0.00101,   0.00178,   0.00278,   0.00398,   0.00540,
     0.00701,   0.00882,   0.01081,   0.01299,   0.01534,   0.01787,   0.02055,
     0.02340,   0.02640,   0.02954,   0.03283,   0.03626,   0.03983,   0.04352,
     0.04735,   0.05130,   0.05537,   0.05957,   0.06388,   0.06830,   0.07284,
     0.07750,   0.08226,   0.08712,   0.09210,   0.09718,   0.10236,   0.10764,
     0.11302,   0.11850,   0.12407,   0.12974,   0.13550,   0.14135,   0.14729,
     0.15331,   0.15942,   0.16562,   0.17190,   0.17825,   0.18469,   0.19120,
     0.19778,   0.20444,   0.21117,   0.21797,   0.22483,   0.23176,   0.23875,
     0.24580,   0.25292,   0.26008,   0.26731,   0.27458,   0.28191,   0.28929,
     0.29672,   0.30419,   0.31171,   0.31927,   0.32687,   0.33451,   0.34218,
     0.34990,   0.35764,   0.36542,   0.37323,   0.38107,   0.38894,   0.39683,
     0.40474,   0.41268,   0.42064,   0.42862,   0.43661,   0.44462,   0.45264,
     0.46067,   0.46871,   0.47676,   0.48481,   0.49287,   0.50093,   0.50899,
     0.51704,   0.52510,   0.53314,   0.54118,   0.54920,   0.55722,   0.56522,
     0.57320,   0.58117,   0.58912,   0.59705,   0.60495,   0.61283,   0.62068,
     0.62850,   0.63630,   0.64406,   0.65179,   0.65948,   0.66714,   0.67476,
     0.68234,   0.68988,   0.69737,   0.70482,   0.71222,   0.71957,   0.72688,
     0.73413,   0.74132,   0.74846,   0.75554,   0.76257,   0.76953,   0.77642,
     0.78326,   0.79002,   0.79672,   0.80334,   0.80989,   0.81637,   0.82277,
     0.82909,   0.83534,   0.84150,   0.84757,   0.85357,   0.85947,   0.86529,
     0.87101,   0.87664,   0.88218,   0.88763,   0.89298,   0.89822,   0.90337,
     0.90842,   0.91336,   0.91820,   0.92293,   0.92756,   0.93207,   0.93647,
     0.94075,   0.94492,   0.94897,   0.95290,   0.95670,   0.96037,   0.96392,
     0.96733,   0.97060,   0.97373,   0.97671,   0.97954,   0.98222,   0.98473,
     0.98707,   0.98924,   0.99122,   0.99302,   0.99463,   0.99603,   0.99723,
     0.99822,   0.99900,   0.99955,   0.99989,   1.00000},
     //---------  0.18 GeV
    {0.00011,   0.00045,   0.00101,   0.00180,   0.00279,   0.00400,   0.00541,
     0.00701,   0.00880,   0.01077,   0.01291,   0.01522,   0.01768,   0.02030,
     0.02307,   0.02597,   0.02901,   0.03218,   0.03549,   0.03891,   0.04246,
     0.04613,   0.04991,   0.05381,   0.05783,   0.06195,   0.06619,   0.07053,
     0.07498,   0.07954,   0.08420,   0.08897,   0.09384,   0.09881,   0.10388,
     0.10905,   0.11432,   0.11969,   0.12515,   0.13071,   0.13637,   0.14212,
     0.14796,   0.15390,   0.15993,   0.16605,   0.17225,   0.17855,   0.18493,
     0.19140,   0.19795,   0.20458,   0.21129,   0.21809,   0.22496,   0.23191,
     0.23893,   0.24602,   0.25319,   0.26043,   0.26773,   0.27510,   0.28254,
     0.29004,   0.29760,   0.30522,   0.31289,   0.32063,   0.32841,   0.33625,
     0.34414,   0.35207,   0.36006,   0.36808,   0.37615,   0.38426,   0.39240,
     0.40058,   0.40880,   0.41704,   0.42531,   0.43360,   0.44192,   0.45026,
     0.45862,   0.46699,   0.47537,   0.48376,   0.49215,   0.50055,   0.50895,
     0.51734,   0.52573,   0.53411,   0.54248,   0.55083,   0.55917,   0.56748,
     0.57578,   0.58404,   0.59228,   0.60049,   0.60867,   0.61681,   0.62491,
     0.63297,   0.64099,   0.64896,   0.65689,   0.66477,   0.67260,   0.68038,
     0.68810,   0.69577,   0.70337,   0.71092,   0.71841,   0.72583,   0.73319,
     0.74048,   0.74770,   0.75486,   0.76194,   0.76894,   0.77587,   0.78273,
     0.78950,   0.79620,   0.80281,   0.80935,   0.81579,   0.82216,   0.82843,
     0.83462,   0.84071,   0.84672,   0.85264,   0.85846,   0.86419,   0.86982,
     0.87536,   0.88081,   0.88615,   0.89140,   0.89655,   0.90160,   0.90655,
     0.91139,   0.91614,   0.92078,   0.92532,   0.92975,   0.93407,   0.93829,
     0.94239,   0.94639,   0.95027,   0.95404,   0.95770,   0.96123,   0.96464,
     0.96793,   0.97109,   0.97412,   0.97701,   0.97976,   0.98237,   0.98483,
     0.98713,   0.98926,   0.99123,   0.99301,   0.99461,   0.99601,   0.99721,
     0.99821,   0.99899,   0.99955,   0.99989,   1.00000},
     //---------  0.22 GeV
    {0.00011,   0.00045,   0.00100,   0.00177,   0.00274,   0.00392,   0.00529,
     0.00685,   0.00858,   0.01049,   0.01255,   0.01477,   0.01714,   0.01964,
     0.02229,   0.02506,   0.02796,   0.03099,   0.03414,   0.03740,   0.04078,
     0.04428,   0.04789,   0.05161,   0.05544,   0.05938,   0.06343,   0.06759,
     0.07186,   0.07623,   0.08071,   0.08529,   0.08998,   0.09477,   0.09967,
     0.10467,   0.10977,   0.11498,   0.12029,   0.12571,   0.13122,   0.13684,
     0.14256,   0.14839,   0.15431,   0.16033,   0.16645,   0.17267,   0.17898,
     0.18540,   0.19190,   0.19850,   0.20519,   0.21197,   0.21884,   0.22580,
     0.23284,   0.23997,   0.24718,   0.25447,   0.26183,   0.26928,   0.27680,
     0.28440,   0.29206,   0.29980,   0.30760,   0.31547,   0.32340,   0.33139,
     0.33945,   0.34755,   0.35572,   0.36394,   0.37220,   0.38052,   0.38887,
     0.39728,   0.40572,   0.41419,   0.42270,   0.43124,   0.43981,   0.44840,
     0.45702,   0.46565,   0.47429,   0.48295,   0.49161,   0.50028,   0.50894,
     0.51760,   0.52626,   0.53490,   0.54354,   0.55215,   0.56074,   0.56931,
     0.57785,   0.58636,   0.59484,   0.60328,   0.61168,   0.62004,   0.62835,
     0.63662,   0.64483,   0.65300,   0.66110,   0.66916,   0.67715,   0.68508,
     0.69294,   0.70075,   0.70848,   0.71614,   0.72373,   0.73125,   0.73869,
     0.74606,   0.75334,   0.76055,   0.76767,   0.77470,   0.78165,   0.78852,
     0.79529,   0.80197,   0.80856,   0.81506,   0.82146,   0.82776,   0.83397,
     0.84008,   0.84609,   0.85200,   0.85781,   0.86352,   0.86913,   0.87464,
     0.88004,   0.88534,   0.89053,   0.89562,   0.90061,   0.90550,   0.91028,
     0.91495,   0.91952,   0.92398,   0.92834,   0.93259,   0.93674,   0.94078,
     0.94471,   0.94853,   0.95224,   0.95583,   0.95932,   0.96269,   0.96595,
     0.96909,   0.97210,   0.97500,   0.97776,   0.98040,   0.98290,   0.98526,
     0.98747,   0.98953,   0.99143,   0.99316,   0.99472,   0.99609,   0.99726,
     0.99824,   0.99900,   0.99956,   0.99989,   1.00000},
     //---------  0.26 GeV
    {0.00011,   0.00044,   0.00098,   0.00173,   0.00269,   0.00384,   0.00518,
     0.00670,   0.00838,   0.01023,   0.01222,   0.01436,   0.01665,   0.01906,
     0.02161,   0.02428,   0.02707,   0.02999,   0.03302,   0.03617,   0.03943,
     0.04281,   0.04630,   0.04990,   0.05361,   0.05743,   0.06137,   0.06541,
     0.06956,   0.07382,   0.07819,   0.08267,   0.08726,   0.09195,   0.09676,
     0.10167,   0.10669,   0.11182,   0.11706,   0.12241,   0.12787,   0.13344,
     0.13911,   0.14489,   0.15078,   0.15678,   0.16288,   0.16909,   0.17540,
     0.18182,   0.18834,   0.19495,   0.20167,   0.20849,   0.21540,   0.22241,
     0.22950,   0.23669,   0.24397,   0.25133,   0.25878,   0.26631,   0.27392,
     0.28160,   0.28936,   0.29720,   0.30510,   0.31307,   0.32111,   0.32921,
     0.33736,   0.34558,   0.35385,   0.36217,   0.37054,   0.37896,   0.38743,
     0.39593,   0.40447,   0.41305,   0.42166,   0.43030,   0.43897,   0.44766,
     0.45636,   0.46509,   0.47383,   0.48258,   0.49133,   0.50009,   0.50885,
     0.51761,   0.52636,   0.53510,   0.54383,   0.55254,   0.56123,   0.56990,
     0.57854,   0.58715,   0.59573,   0.60427,   0.61278,   0.62125,   0.62967,
     0.63804,   0.64637,   0.65464,   0.66286,   0.67102,   0.67912,   0.68716,
     0.69514,   0.70304,   0.71088,   0.71864,   0.72633,   0.73394,   0.74147,
     0.74892,   0.75628,   0.76356,   0.77075,   0.77785,   0.78485,   0.79176,
     0.79858,   0.80530,   0.81191,   0.81843,   0.82484,   0.83115,   0.83736,
     0.84345,   0.84945,   0.85533,   0.86111,   0.86678,   0.87234,   0.87779,
     0.88313,   0.88836,   0.89349,   0.89850,   0.90341,   0.90821,   0.91290,
     0.91748,   0.92195,   0.92631,   0.93056,   0.93471,   0.93874,   0.94267,
     0.94648,   0.95019,   0.95378,   0.95726,   0.96063,   0.96389,   0.96703,
     0.97006,   0.97297,   0.97576,   0.97842,   0.98096,   0.98338,   0.98565,
     0.98779,   0.98979,   0.99163,   0.99331,   0.99483,   0.99616,   0.99731,
     0.99827,   0.99902,   0.99956,   0.99989,   1.00000},
     //---------  0.28 GeV
    {0.00011,   0.00044,   0.00098,   0.00172,   0.00267,   0.00382,   0.00514,
     0.00664,   0.00831,   0.01014,   0.01211,   0.01422,   0.01648,   0.01886,
     0.02137,   0.02401,   0.02677,   0.02965,   0.03265,   0.03576,   0.03899,
     0.04233,   0.04578,   0.04935,   0.05303,   0.05683,   0.06073,   0.06475,
     0.06888,   0.07311,   0.07746,   0.08192,   0.08650,   0.09118,   0.09597,
     0.10088,   0.10589,   0.11102,   0.11626,   0.12161,   0.12708,   0.13265,
     0.13834,   0.14413,   0.15004,   0.15605,   0.16218,   0.16841,   0.17474,
     0.18119,   0.18773,   0.19438,   0.20113,   0.20797,   0.21492,   0.22195,
     0.22908,   0.23630,   0.24361,   0.25101,   0.25848,   0.26604,   0.27368,
     0.28139,   0.28918,   0.29704,   0.30496,   0.31295,   0.32101,   0.32912,
     0.33730,   0.34553,   0.35381,   0.36214,   0.37052,   0.37895,   0.38741,
     0.39592,   0.40446,   0.41304,   0.42165,   0.43029,   0.43895,   0.44763,
     0.45634,   0.46506,   0.47379,   0.48253,   0.49128,   0.50003,   0.50878,
     0.51753,   0.52627,   0.53500,   0.54373,   0.55243,   0.56112,   0.56978,
     0.57842,   0.58703,   0.59561,   0.60416,   0.61267,   0.62114,   0.62957,
     0.63796,   0.64629,   0.65458,   0.66281,   0.67099,   0.67911,   0.68717,
     0.69516,   0.70309,   0.71096,   0.71875,   0.72646,   0.73410,   0.74166,
     0.74914,   0.75654,   0.76385,   0.77108,   0.77821,   0.78525,   0.79219,
     0.79904,   0.80579,   0.81243,   0.81898,   0.82542,   0.83176,   0.83799,
     0.84411,   0.85012,   0.85603,   0.86182,   0.86750,   0.87307,   0.87853,
     0.88388,   0.88912,   0.89424,   0.89925,   0.90415,   0.90894,   0.91362,
     0.91818,   0.92264,   0.92698,   0.93122,   0.93534,   0.93935,   0.94325,
     0.94704,   0.95071,   0.95427,   0.95773,   0.96106,   0.96429,   0.96739,
     0.97039,   0.97326,   0.97601,   0.97865,   0.98116,   0.98354,   0.98579,
     0.98790,   0.98987,   0.99170,   0.99336,   0.99486,   0.99619,   0.99733,
     0.99828,   0.99902,   0.99956,   0.99989,   1.00000},
     //---------  0.30 GeV
    {0.00011,   0.00044,   0.00097,   0.00172,   0.00267,   0.00380,   0.00512,
     0.00661,   0.00827,   0.01008,   0.01204,   0.01414,   0.01637,   0.01873,
     0.02122,   0.02384,   0.02658,   0.02944,   0.03241,   0.03551,   0.03872,
     0.04204,   0.04548,   0.04904,   0.05271,   0.05650,   0.06039,   0.06441,
     0.06853,   0.07277,   0.07712,   0.08159,   0.08617,   0.09086,   0.09567,
     0.10059,   0.10562,   0.11077,   0.11604,   0.12141,   0.12690,   0.13251,
     0.13822,   0.14405,   0.14999,   0.15605,   0.16221,   0.16847,   0.17485,
     0.18133,   0.18791,   0.19460,   0.20138,   0.20827,   0.21525,   0.22232,
     0.22948,   0.23673,   0.24406,   0.25148,   0.25898,   0.26656,   0.27422,
     0.28194,   0.28974,   0.29761,   0.30554,   0.31353,   0.32158,   0.32969,
     0.33786,   0.34607,   0.35434,   0.36266,   0.37102,   0.37942,   0.38786,
     0.39634,   0.40485,   0.41340,   0.42197,   0.43057,   0.43919,   0.44784,
     0.45650,   0.46518,   0.47387,   0.48256,   0.49127,   0.49998,   0.50868,
     0.51739,   0.52609,   0.53478,   0.54346,   0.55212,   0.56077,   0.56939,
     0.57800,   0.58657,   0.59512,   0.60364,   0.61212,   0.62057,   0.62897,
     0.63734,   0.64566,   0.65393,   0.66215,   0.67032,   0.67844,   0.68650,
     0.69450,   0.70243,   0.71030,   0.71811,   0.72584,   0.73350,   0.74108,
     0.74858,   0.75601,   0.76335,   0.77060,   0.77777,   0.78484,   0.79182,
     0.79871,   0.80550,   0.81218,   0.81877,   0.82525,   0.83163,   0.83790,
     0.84406,   0.85011,   0.85605,   0.86188,   0.86759,   0.87320,   0.87869,
     0.88406,   0.88932,   0.89447,   0.89950,   0.90442,   0.90922,   0.91391,
     0.91849,   0.92295,   0.92730,   0.93154,   0.93566,   0.93966,   0.94356,
     0.94734,   0.95101,   0.95456,   0.95800,   0.96132,   0.96452,   0.96761,
     0.97059,   0.97344,   0.97618,   0.97879,   0.98128,   0.98364,   0.98587,
     0.98797,   0.98993,   0.99173,   0.99339,   0.99488,   0.99620,   0.99733,
     0.99828,   0.99903,   0.99957,   0.99989,   1.00000},
     //---------  0.34 GeV
    {0.00011,   0.00044,   0.00099,   0.00175,   0.00271,   0.00387,   0.00520,
     0.00671,   0.00838,   0.01021,   0.01218,   0.01429,   0.01654,   0.01892,
     0.02143,   0.02406,   0.02682,   0.02969,   0.03269,   0.03581,   0.03905,
     0.04241,   0.04588,   0.04947,   0.05318,   0.05701,   0.06095,   0.06501,
     0.06918,   0.07347,   0.07788,   0.08240,   0.08704,   0.09180,   0.09667,
     0.10166,   0.10676,   0.11198,   0.11732,   0.12277,   0.12833,   0.13401,
     0.13980,   0.14571,   0.15172,   0.15785,   0.16408,   0.17042,   0.17687,
     0.18341,   0.19006,   0.19680,   0.20364,   0.21057,   0.21760,   0.22471,
     0.23190,   0.23918,   0.24653,   0.25397,   0.26147,   0.26905,   0.27670,
     0.28441,   0.29218,   0.30002,   0.30791,   0.31586,   0.32386,   0.33191,
     0.34001,   0.34815,   0.35634,   0.36457,   0.37284,   0.38114,   0.38948,
     0.39785,   0.40624,   0.41467,   0.42312,   0.43159,   0.44009,   0.44860,
     0.45713,   0.46567,   0.47422,   0.48277,   0.49134,   0.49990,   0.50847,
     0.51703,   0.52559,   0.53414,   0.54268,   0.55121,   0.55973,   0.56822,
     0.57670,   0.58516,   0.59359,   0.60199,   0.61036,   0.61871,   0.62702,
     0.63529,   0.64352,   0.65172,   0.65987,   0.66797,   0.67603,   0.68404,
     0.69199,   0.69989,   0.70773,   0.71551,   0.72323,   0.73088,   0.73847,
     0.74598,   0.75342,   0.76078,   0.76806,   0.77526,   0.78238,   0.78941,
     0.79634,   0.80319,   0.80994,   0.81659,   0.82314,   0.82959,   0.83593,
     0.84216,   0.84829,   0.85431,   0.86022,   0.86601,   0.87169,   0.87726,
     0.88271,   0.88805,   0.89327,   0.89837,   0.90336,   0.90823,   0.91299,
     0.91763,   0.92215,   0.92655,   0.93084,   0.93502,   0.93907,   0.94301,
     0.94684,   0.95054,   0.95413,   0.95761,   0.96096,   0.96420,   0.96732,
     0.97031,   0.97319,   0.97595,   0.97858,   0.98109,   0.98346,   0.98571,
     0.98782,   0.98980,   0.99162,   0.99329,   0.99480,   0.99613,   0.99729,
     0.99825,   0.99901,   0.99956,   0.99989,   1.00000},
     //---------  0.42 GeV
    {0.00012,   0.00048,   0.00107,   0.00188,   0.00291,   0.00414,   0.00557,
     0.00717,   0.00895,   0.01089,   0.01299,   0.01523,   0.01762,   0.02014,
     0.02281,   0.02561,   0.02854,   0.03160,   0.03479,   0.03811,   0.04155,
     0.04513,   0.04882,   0.05264,   0.05658,   0.06064,   0.06482,   0.06912,
     0.07355,   0.07809,   0.08275,   0.08752,   0.09242,   0.09742,   0.10255,
     0.10779,   0.11315,   0.11861,   0.12419,   0.12988,   0.13568,   0.14159,
     0.14760,   0.15372,   0.15994,   0.16625,   0.17266,   0.17917,   0.18576,
     0.19244,   0.19921,   0.20606,   0.21298,   0.21998,   0.22705,   0.23419,
     0.24139,   0.24865,   0.25598,   0.26335,   0.27078,   0.27826,   0.28579,
     0.29336,   0.30098,   0.30863,   0.31632,   0.32405,   0.33181,   0.33960,
     0.34742,   0.35527,   0.36315,   0.37106,   0.37898,   0.38694,   0.39491,
     0.40290,   0.41091,   0.41894,   0.42698,   0.43504,   0.44311,   0.45119,
     0.45929,   0.46739,   0.47549,   0.48360,   0.49172,   0.49984,   0.50795,
     0.51607,   0.52418,   0.53229,   0.54039,   0.54849,   0.55657,   0.56465,
     0.57271,   0.58076,   0.58879,   0.59680,   0.60480,   0.61278,   0.62073,
     0.62867,   0.63658,   0.64446,   0.65232,   0.66015,   0.66795,   0.67572,
     0.68345,   0.69115,   0.69881,   0.70643,   0.71401,   0.72154,   0.72903,
     0.73647,   0.74385,   0.75118,   0.75845,   0.76566,   0.77281,   0.77988,
     0.78689,   0.79382,   0.80067,   0.80745,   0.81414,   0.82074,   0.82725,
     0.83367,   0.83999,   0.84621,   0.85233,   0.85835,   0.86426,   0.87006,
     0.87576,   0.88134,   0.88681,   0.89217,   0.89742,   0.90254,   0.90756,
     0.91245,   0.91723,   0.92189,   0.92643,   0.93086,   0.93516,   0.93935,
     0.94341,   0.94735,   0.95117,   0.95486,   0.95844,   0.96188,   0.96520,
     0.96839,   0.97146,   0.97439,   0.97719,   0.97985,   0.98238,   0.98477,
     0.98701,   0.98910,   0.99104,   0.99282,   0.99443,   0.99585,   0.99709,
     0.99812,   0.99893,   0.99952,   0.99988,   1.00000},
     //---------  0.52 GeV
    {0.00014,   0.00055,   0.00124,   0.00219,   0.00338,   0.00481,   0.00647,
     0.00834,   0.01041,   0.01267,   0.01512,   0.01775,   0.02055,   0.02353,
     0.02666,   0.02996,   0.03341,   0.03701,   0.04076,   0.04466,   0.04870,
     0.05288,   0.05719,   0.06164,   0.06621,   0.07092,   0.07574,   0.08069,
     0.08575,   0.09093,   0.09622,   0.10162,   0.10713,   0.11275,   0.11847,
     0.12429,   0.13020,   0.13621,   0.14231,   0.14850,   0.15477,   0.16112,
     0.16755,   0.17406,   0.18063,   0.18726,   0.19396,   0.20071,   0.20751,
     0.21436,   0.22126,   0.22819,   0.23516,   0.24217,   0.24920,   0.25625,
     0.26333,   0.27043,   0.27754,   0.28467,   0.29181,   0.29896,   0.30611,
     0.31328,   0.32044,   0.32761,   0.33478,   0.34196,   0.34913,   0.35631,
     0.36348,   0.37066,   0.37784,   0.38501,   0.39219,   0.39936,   0.40654,
     0.41371,   0.42088,   0.42806,   0.43523,   0.44241,   0.44959,   0.45676,
     0.46394,   0.47112,   0.47830,   0.48547,   0.49265,   0.49983,   0.50701,
     0.51419,   0.52137,   0.52855,   0.53573,   0.54291,   0.55009,   0.55726,
     0.56444,   0.57162,   0.57880,   0.58598,   0.59316,   0.60034,   0.60752,
     0.61470,   0.62188,   0.62906,   0.63624,   0.64342,   0.65060,   0.65778,
     0.66496,   0.67214,   0.67932,   0.68649,   0.69366,   0.70083,   0.70798,
     0.71513,   0.72226,   0.72938,   0.73649,   0.74357,   0.75064,   0.75768,
     0.76469,   0.77166,   0.77861,   0.78551,   0.79237,   0.79918,   0.80593,
     0.81264,   0.81928,   0.82585,   0.83236,   0.83880,   0.84515,   0.85143,
     0.85763,   0.86373,   0.86975,   0.87567,   0.88149,   0.88721,   0.89283,
     0.89834,   0.90375,   0.90904,   0.91423,   0.91929,   0.92424,   0.92907,
     0.93377,   0.93835,   0.94279,   0.94711,   0.95129,   0.95533,   0.95923,
     0.96298,   0.96659,   0.97004,   0.97333,   0.97647,   0.97944,   0.98224,
     0.98487,   0.98732,   0.98959,   0.99166,   0.99353,   0.99519,   0.99662,
     0.99781,   0.99876,   0.99945,   0.99986,   1.00000},
     //---------  0.62 GeV
    {0.00018,   0.00070,   0.00158,   0.00278,   0.00431,   0.00615,   0.00828,
     0.01070,   0.01339,   0.01635,   0.01956,   0.02301,   0.02670,   0.03062,
     0.03476,   0.03912,   0.04368,   0.04843,   0.05337,   0.05850,   0.06379,
     0.06925,   0.07486,   0.08062,   0.08653,   0.09256,   0.09872,   0.10500,
     0.11139,   0.11789,   0.12448,   0.13117,   0.13795,   0.14480,   0.15172,
     0.15871,   0.16575,   0.17285,   0.17999,   0.18716,   0.19437,   0.20159,
     0.20883,   0.21607,   0.22332,   0.23055,   0.23777,   0.24497,   0.25214,
     0.25928,   0.26638,   0.27343,   0.28044,   0.28739,   0.29428,   0.30112,
     0.30789,   0.31460,   0.32125,   0.32782,   0.33433,   0.34077,   0.34714,
     0.35344,   0.35967,   0.36584,   0.37195,   0.37799,   0.38396,   0.38988,
     0.39574,   0.40155,   0.40730,   0.41301,   0.41866,   0.42428,   0.42985,
     0.43538,   0.44087,   0.44634,   0.45177,   0.45718,   0.46256,   0.46792,
     0.47327,   0.47860,   0.48391,   0.48922,   0.49452,   0.49982,   0.50512,
     0.51043,   0.51574,   0.52106,   0.52639,   0.53173,   0.53710,   0.54248,
     0.54789,   0.55333,   0.55880,   0.56430,   0.56983,   0.57541,   0.58103,
     0.58669,   0.59240,   0.59816,   0.60397,   0.60984,   0.61576,   0.62174,
     0.62779,   0.63390,   0.64008,   0.64632,   0.65263,   0.65900,   0.66545,
     0.67196,   0.67855,   0.68520,   0.69192,   0.69870,   0.70554,   0.71244,
     0.71940,   0.72642,   0.73348,   0.74059,   0.74773,   0.75491,   0.76211,
     0.76934,   0.77658,   0.78383,   0.79108,   0.79833,   0.80556,   0.81277,
     0.81995,   0.82709,   0.83419,   0.84124,   0.84824,   0.85517,   0.86202,
     0.86880,   0.87549,   0.88209,   0.88859,   0.89498,   0.90126,   0.90743,
     0.91346,   0.91937,   0.92513,   0.93074,   0.93620,   0.94150,   0.94662,
     0.95157,   0.95632,   0.96088,   0.96524,   0.96938,   0.97330,   0.97699,
     0.98044,   0.98365,   0.98660,   0.98930,   0.99171,   0.99385,   0.99569,
     0.99722,   0.99842,   0.99930,   0.99982,   1.00000},
     //---------  0.70 GeV
    {0.00023,   0.00093,   0.00207,   0.00366,   0.00567,   0.00810,   0.01091,
     0.01410,   0.01765,   0.02155,   0.02578,   0.03032,   0.03517,   0.04031,
     0.04572,   0.05139,   0.05731,   0.06345,   0.06981,   0.07636,   0.08310,
     0.09002,   0.09708,   0.10429,   0.11163,   0.11908,   0.12665,   0.13430,
     0.14203,   0.14984,   0.15771,   0.16562,   0.17357,   0.18155,   0.18955,
     0.19755,   0.20555,   0.21354,   0.22150,   0.22942,   0.23731,   0.24514,
     0.25290,   0.26060,   0.26822,   0.27575,   0.28318,   0.29052,   0.29774,
     0.30486,   0.31185,   0.31873,   0.32548,   0.33210,   0.33859,   0.34496,
     0.35118,   0.35728,   0.36325,   0.36908,   0.37479,   0.38036,   0.38581,
     0.39114,   0.39635,   0.40145,   0.40643,   0.41130,   0.41606,   0.42073,
     0.42529,   0.42977,   0.43416,   0.43846,   0.44268,   0.44683,   0.45091,
     0.45493,   0.45888,   0.46278,   0.46663,   0.47043,   0.47419,   0.47792,
     0.48161,   0.48528,   0.48893,   0.49256,   0.49619,   0.49981,   0.50342,
     0.50705,   0.51068,   0.51433,   0.51800,   0.52170,   0.52543,   0.52919,
     0.53300,   0.53685,   0.54075,   0.54471,   0.54872,   0.55281,   0.55696,
     0.56119,   0.56550,   0.56989,   0.57437,   0.57894,   0.58361,   0.58839,
     0.59326,   0.59825,   0.60335,   0.60856,   0.61390,   0.61936,   0.62494,
     0.63065,   0.63650,   0.64247,   0.64857,   0.65481,   0.66118,   0.66768,
     0.67431,   0.68107,   0.68795,   0.69496,   0.70208,   0.70931,   0.71665,
     0.72410,   0.73164,   0.73926,   0.74696,   0.75474,   0.76258,   0.77047,
     0.77840,   0.78637,   0.79436,   0.80237,   0.81037,   0.81838,   0.82636,
     0.83432,   0.84224,   0.85011,   0.85792,   0.86566,   0.87332,   0.88088,
     0.88834,   0.89568,   0.90289,   0.90996,   0.91688,   0.92362,   0.93018,
     0.93654,   0.94268,   0.94860,   0.95427,   0.95968,   0.96482,   0.96967,
     0.97422,   0.97845,   0.98235,   0.98590,   0.98909,   0.99190,   0.99433,
     0.99634,   0.99793,   0.99907,   0.99977,   1.00000},
     //---------  0.80 GeV
    {0.00030,   0.00119,   0.00266,   0.00469,   0.00727,   0.01037,   0.01397,
     0.01805,   0.02259,   0.02756,   0.03294,   0.03872,   0.04486,   0.05135,
     0.05816,   0.06528,   0.07267,   0.08031,   0.08818,   0.09626,   0.10452,
     0.11294,   0.12151,   0.13020,   0.13899,   0.14786,   0.15680,   0.16579,
     0.17481,   0.18385,   0.19288,   0.20190,   0.21089,   0.21984,   0.22873,
     0.23755,   0.24629,   0.25493,   0.26346,   0.27187,   0.28016,   0.28830,
     0.29630,   0.30414,   0.31182,   0.31933,   0.32666,   0.33381,   0.34078,
     0.34756,   0.35415,   0.36055,   0.36677,   0.37279,   0.37863,   0.38428,
     0.38974,   0.39503,   0.40014,   0.40507,   0.40984,   0.41445,   0.41890,
     0.42319,   0.42734,   0.43134,   0.43521,   0.43895,   0.44257,   0.44607,
     0.44945,   0.45273,   0.45590,   0.45898,   0.46197,   0.46487,   0.46770,
     0.47045,   0.47314,   0.47576,   0.47833,   0.48084,   0.48331,   0.48574,
     0.48814,   0.49051,   0.49286,   0.49518,   0.49750,   0.49981,   0.50212,
     0.50444,   0.50677,   0.50912,   0.51149,   0.51388,   0.51632,   0.51879,
     0.52130,   0.52387,   0.52650,   0.52918,   0.53194,   0.53477,   0.53767,
     0.54067,   0.54375,   0.54693,   0.55021,   0.55359,   0.55709,   0.56071,
     0.56445,   0.56833,   0.57234,   0.57649,   0.58079,   0.58524,   0.58985,
     0.59463,   0.59957,   0.60468,   0.60997,   0.61545,   0.62110,   0.62694,
     0.63297,   0.63919,   0.64560,   0.65220,   0.65899,   0.66597,   0.67313,
     0.68047,   0.68798,   0.69567,   0.70351,   0.71152,   0.71967,   0.72796,
     0.73638,   0.74492,   0.75357,   0.76231,   0.77114,   0.78004,   0.78899,
     0.79799,   0.80702,   0.81606,   0.82511,   0.83413,   0.84313,   0.85207,
     0.86095,   0.86975,   0.87844,   0.88701,   0.89544,   0.90371,   0.91179,
     0.91966,   0.92731,   0.93470,   0.94182,   0.94863,   0.95512,   0.96127,
     0.96705,   0.97243,   0.97740,   0.98194,   0.98602,   0.98962,   0.99273,
     0.99531,   0.99734,   0.99881,   0.99970,   1.00000},
     //---------  0.90 GeV
    {0.00035,   0.00141,   0.00316,   0.00557,   0.00863,   0.01231,   0.01657,
     0.02139,   0.02674,   0.03260,   0.03893,   0.04570,   0.05288,   0.06045,
     0.06837,   0.07660,   0.08513,   0.09391,   0.10292,   0.11212,   0.12149,
     0.13100,   0.14063,   0.15034,   0.16012,   0.16994,   0.17978,   0.18962,
     0.19944,   0.20922,   0.21894,   0.22859,   0.23814,   0.24758,   0.25690,
     0.26609,   0.27511,   0.28398,   0.29267,   0.30117,   0.30947,   0.31757,
     0.32546,   0.33313,   0.34057,   0.34779,   0.35477,   0.36153,   0.36806,
     0.37435,   0.38042,   0.38626,   0.39187,   0.39727,   0.40246,   0.40743,
     0.41221,   0.41679,   0.42118,   0.42538,   0.42942,   0.43328,   0.43698,
     0.44053,   0.44394,   0.44720,   0.45033,   0.45334,   0.45622,   0.45900,
     0.46167,   0.46424,   0.46671,   0.46910,   0.47141,   0.47364,   0.47580,
     0.47790,   0.47993,   0.48191,   0.48385,   0.48573,   0.48758,   0.48939,
     0.49118,   0.49294,   0.49468,   0.49640,   0.49812,   0.49983,   0.50154,
     0.50325,   0.50498,   0.50672,   0.50848,   0.51026,   0.51207,   0.51392,
     0.51581,   0.51774,   0.51972,   0.52176,   0.52386,   0.52602,   0.52825,
     0.53056,   0.53295,   0.53543,   0.53800,   0.54067,   0.54344,   0.54633,
     0.54934,   0.55247,   0.55574,   0.55915,   0.56270,   0.56641,   0.57027,
     0.57431,   0.57852,   0.58291,   0.58750,   0.59228,   0.59726,   0.60245,
     0.60785,   0.61347,   0.61932,   0.62539,   0.63169,   0.63822,   0.64498,
     0.65198,   0.65920,   0.66665,   0.67433,   0.68222,   0.69033,   0.69864,
     0.70715,   0.71585,   0.72472,   0.73376,   0.74295,   0.75227,   0.76173,
     0.77129,   0.78094,   0.79067,   0.80046,   0.81028,   0.82013,   0.82998,
     0.83980,   0.84959,   0.85931,   0.86894,   0.87846,   0.88783,   0.89704,
     0.90605,   0.91483,   0.92336,   0.93160,   0.93952,   0.94709,   0.95428,
     0.96106,   0.96739,   0.97325,   0.97860,   0.98342,   0.98769,   0.99137,
     0.99443,   0.99684,   0.99859,   0.99965,   1.00000},
     //---------  1.00 GeV
    {0.00041,   0.00164,   0.00366,   0.00645,   0.00999,   0.01423,   0.01914,
     0.02469,   0.03084,   0.03755,   0.04478,   0.05250,   0.06066,   0.06923,
     0.07815,   0.08741,   0.09694,   0.10672,   0.11670,   0.12685,   0.13714,
     0.14753,   0.15800,   0.16850,   0.17902,   0.18953,   0.20000,   0.21041,
     0.22075,   0.23098,   0.24109,   0.25107,   0.26088,   0.27053,   0.27999,
     0.28924,   0.29829,   0.30711,   0.31569,   0.32403,   0.33212,   0.33995,
     0.34752,   0.35483,   0.36187,   0.36864,   0.37515,   0.38140,   0.38738,
     0.39312,   0.39861,   0.40385,   0.40886,   0.41364,   0.41820,   0.42256,
     0.42671,   0.43066,   0.43443,   0.43803,   0.44146,   0.44473,   0.44786,
     0.45084,   0.45368,   0.45640,   0.45901,   0.46150,   0.46389,   0.46618,
     0.46838,   0.47050,   0.47253,   0.47450,   0.47639,   0.47823,   0.48000,
     0.48172,   0.48340,   0.48503,   0.48662,   0.48818,   0.48970,   0.49120,
     0.49267,   0.49413,   0.49557,   0.49700,   0.49842,   0.49984,   0.50125,
     0.50267,   0.50410,   0.50554,   0.50700,   0.50847,   0.50997,   0.51150,
     0.51305,   0.51464,   0.51627,   0.51795,   0.51967,   0.52145,   0.52328,
     0.52518,   0.52714,   0.52918,   0.53129,   0.53350,   0.53579,   0.53818,
     0.54067,   0.54328,   0.54600,   0.54885,   0.55183,   0.55495,   0.55823,
     0.56166,   0.56526,   0.56904,   0.57300,   0.57715,   0.58151,   0.58607,
     0.59086,   0.59587,   0.60112,   0.60661,   0.61235,   0.61835,   0.62460,
     0.63112,   0.63790,   0.64494,   0.65226,   0.65983,   0.66767,   0.67577,
     0.68412,   0.69271,   0.70153,   0.71059,   0.71985,   0.72932,   0.73897,
     0.74880,   0.75878,   0.76890,   0.77914,   0.78948,   0.79990,   0.81038,
     0.82089,   0.83142,   0.84193,   0.85240,   0.86280,   0.87309,   0.88325,
     0.89324,   0.90302,   0.91256,   0.92181,   0.93075,   0.93931,   0.94748,
     0.95520,   0.96244,   0.96915,   0.97530,   0.98085,   0.98576,   0.99001,
     0.99355,   0.99634,   0.99836,   0.99959,   1.00000},
     //---------  1.10 GeV
    {0.00047,   0.00187,   0.00418,   0.00737,   0.01140,   0.01623,   0.02181,
     0.02811,   0.03507,   0.04265,   0.05079,   0.05946,   0.06859,   0.07814,
     0.08806,   0.09829,   0.10878,   0.11950,   0.13038,   0.14140,   0.15250,
     0.16366,   0.17483,   0.18598,   0.19709,   0.20813,   0.21906,   0.22987,
     0.24053,   0.25103,   0.26134,   0.27145,   0.28134,   0.29100,   0.30041,
     0.30956,   0.31844,   0.32704,   0.33536,   0.34339,   0.35112,   0.35856,
     0.36569,   0.37253,   0.37908,   0.38533,   0.39130,   0.39699,   0.40241,
     0.40756,   0.41246,   0.41712,   0.42154,   0.42574,   0.42972,   0.43351,
     0.43710,   0.44050,   0.44374,   0.44682,   0.44974,   0.45253,   0.45518,
     0.45770,   0.46011,   0.46241,   0.46461,   0.46672,   0.46874,   0.47068,
     0.47254,   0.47434,   0.47607,   0.47774,   0.47936,   0.48093,   0.48246,
     0.48395,   0.48540,   0.48681,   0.48820,   0.48956,   0.49089,   0.49221,
     0.49351,   0.49479,   0.49606,   0.49733,   0.49859,   0.49984,   0.50110,
     0.50236,   0.50362,   0.50490,   0.50618,   0.50748,   0.50879,   0.51013,
     0.51149,   0.51288,   0.51429,   0.51574,   0.51722,   0.51875,   0.52032,
     0.52194,   0.52362,   0.52535,   0.52714,   0.52901,   0.53095,   0.53297,
     0.53507,   0.53728,   0.53958,   0.54199,   0.54452,   0.54717,   0.54995,
     0.55288,   0.55596,   0.55920,   0.56261,   0.56620,   0.56999,   0.57397,
     0.57818,   0.58260,   0.58726,   0.59217,   0.59733,   0.60275,   0.60845,
     0.61442,   0.62068,   0.62723,   0.63408,   0.64123,   0.64867,   0.65641,
     0.66444,   0.67277,   0.68138,   0.69027,   0.69943,   0.70884,   0.71851,
     0.72841,   0.73852,   0.74884,   0.75935,   0.77002,   0.78083,   0.79178,
     0.80282,   0.81393,   0.82509,   0.83627,   0.84743,   0.85854,   0.86956,
     0.88046,   0.89117,   0.90167,   0.91191,   0.92183,   0.93138,   0.94052,
     0.94919,   0.95734,   0.96492,   0.97188,   0.97818,   0.98377,   0.98860,
     0.99263,   0.99582,   0.99813,   0.99953,   1.00000},
     //---------  1.20 GeV
    {0.00053,   0.00211,   0.00472,   0.00832,   0.01286,   0.01829,   0.02456,
     0.03163,   0.03942,   0.04788,   0.05695,   0.06657,   0.07667,   0.08720,
     0.09809,   0.10927,   0.12069,   0.13230,   0.14403,   0.15585,   0.16769,
     0.17953,   0.19131,   0.20301,   0.21460,   0.22604,   0.23731,   0.24838,
     0.25924,   0.26986,   0.28023,   0.29033,   0.30015,   0.30968,   0.31890,
     0.32782,   0.33641,   0.34469,   0.35263,   0.36025,   0.36754,   0.37450,
     0.38114,   0.38746,   0.39347,   0.39918,   0.40459,   0.40971,   0.41456,
     0.41915,   0.42349,   0.42759,   0.43147,   0.43513,   0.43860,   0.44187,
     0.44497,   0.44791,   0.45069,   0.45332,   0.45583,   0.45821,   0.46047,
     0.46263,   0.46469,   0.46666,   0.46855,   0.47036,   0.47210,   0.47377,
     0.47538,   0.47694,   0.47845,   0.47991,   0.48133,   0.48272,   0.48407,
     0.48539,   0.48668,   0.48795,   0.48920,   0.49043,   0.49165,   0.49284,
     0.49403,   0.49521,   0.49637,   0.49754,   0.49869,   0.49985,   0.50101,
     0.50216,   0.50333,   0.50449,   0.50567,   0.50685,   0.50805,   0.50927,
     0.51049,   0.51174,   0.51301,   0.51431,   0.51563,   0.51698,   0.51836,
     0.51979,   0.52125,   0.52276,   0.52432,   0.52593,   0.52760,   0.52934,
     0.53115,   0.53303,   0.53500,   0.53707,   0.53923,   0.54149,   0.54387,
     0.54638,   0.54902,   0.55180,   0.55474,   0.55784,   0.56112,   0.56459,
     0.56825,   0.57213,   0.57624,   0.58058,   0.58518,   0.59003,   0.59516,
     0.60058,   0.60629,   0.61231,   0.61863,   0.62528,   0.63225,   0.63955,
     0.64717,   0.65512,   0.66340,   0.67201,   0.68093,   0.69016,   0.69970,
     0.70953,   0.71964,   0.73001,   0.74064,   0.75151,   0.76259,   0.77386,
     0.78531,   0.79690,   0.80861,   0.82040,   0.83224,   0.84409,   0.85591,
     0.86765,   0.87926,   0.89069,   0.90188,   0.91277,   0.92330,   0.93341,
     0.94303,   0.95210,   0.96057,   0.96836,   0.97543,   0.98170,   0.98714,
     0.99168,   0.99528,   0.99789,   0.99947,   1.00000}
 };

