//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
#include "G4HETCEmissionFactory.hh"

#include "G4HETCNeutron.hh"
#include "G4HETCProton.hh"
#include "G4HETCDeuteron.hh"
#include "G4HETCTriton.hh"
#include "G4HETCHe3.hh"
#include "G4HETCAlpha.hh"


const G4HETCEmissionFactory & G4HETCEmissionFactory::
operator=(const G4HETCEmissionFactory & )
{
  throw G4HadronicException(__FILE__, __LINE__, "G4HETCEmissionFactory::operator= meant to not be accessable.");
  return *this;
}

G4bool G4HETCEmissionFactory::
operator==(const G4HETCEmissionFactory & ) const
{
  throw G4HadronicException(__FILE__, __LINE__, "G4HETCEmissionFactory::operator== meant to not be accessable.");
  return false;
}

G4bool G4HETCEmissionFactory::
operator!=(const G4HETCEmissionFactory & ) const
{
  throw G4HadronicException(__FILE__, __LINE__, "G4HETCEmissionFactory::operator!= meant to not be accessable.");
  return true;
}


std::vector<G4VPreCompoundFragment*> *  G4HETCEmissionFactory::
CreateFragmentVector()
{
  std::vector<G4VPreCompoundFragment*> * theFragVector = 
    new std::vector<G4VPreCompoundFragment*>;
  theFragVector->reserve(6);

  // neutron
  theFragVector->push_back(new G4HETCNeutron());
  // proton
  theFragVector->push_back(new G4HETCProton());
  // deuterium
  theFragVector->push_back(new G4HETCDeuteron());
  // alpha
  theFragVector->push_back(new G4HETCAlpha());
  // triton
  theFragVector->push_back(new G4HETCTriton());
  // helium3
  theFragVector->push_back(new G4HETCHe3());

  return theFragVector;
}
