// This code implementation is the intellectual property of
// the GEANT4 collaboration.
//
// By copying, distributing or modifying the Program (or any work
// based on the Program) you indicate your acceptance of this statement,
// and all its terms.
//
// $Id: G3toG4PrimaryGeneratorAction.hh,v 1.3 1999/12/05 17:50:25 gcosmo Exp $
// GEANT4 tag $Name: geant4-01-00 $
//

#ifndef G3toG4PrimaryGeneratorAction_h
#define G3toG4PrimaryGeneratorAction_h 1

#include "G4Event.hh"
#include "G4ParticleGun.hh"
#include "G4VUserPrimaryGeneratorAction.hh"
#include "G4ThreeVector.hh"

class G3toG4PrimaryGeneratorAction : public G4VUserPrimaryGeneratorAction
{
  public:
    G3toG4PrimaryGeneratorAction();
    ~G3toG4PrimaryGeneratorAction();

  public:
    void GeneratePrimaries(G4Event* anEvent);

  private:
    G4ParticleGun* particleGun;
    G4ThreeVector GetRandomDirection();
};

#endif


