

//



//
// $Id: STEPcomplex.h,v 1.2 1999/05/21 20:20:31 japost Exp $
// GEANT4 tag $Name: geant4-01-00 $
//
#ifndef STEPCOMPLEX_H
#define STEPCOMPLEX_H

#include <errordesc.h>
#include <sdai.h>
#include <baseType.h>
#include <ExpDict.h>
#include <STEPentity.h>
#include <Registry.h>

class STEPcomplex : public STEPentity {
  public:
    STEPcomplex * sc;
    STEPcomplex * head;
    Registry * _registry;
    int visited; // used when reading (or as you wish?)

  public:
    STEPcomplex(Registry *registry, int fileid);
    STEPcomplex(Registry *registry, const SCLstring **names, int fileid);
    STEPcomplex(Registry *registry, const char **names, int fileid);

    virtual ~STEPcomplex();

    int EntityExists(const char *name);
    STEPcomplex *EntityPart(const char *name);

/*
    // page 241 Stroustrup
    STEPcomplex &operator[](const char *name);
    STEPcomplex &operator[](const int index);
*/

    virtual Severity ValidLevel(ErrorDescriptor *error, InstMgr *im, 
			int clearError = 1);
// READ
    virtual Severity STEPread(int id, int addFileId, 
				   InstMgr * instance_set,
				   istream& in =cin);
    virtual void STEPread_error(char c, int index, istream& in);

// WRITE
    virtual void STEPwrite(ostream& out =G4cout, int writeComment = 1);
    virtual const char * STEPwrite(SCLstring &buf);

    virtual void WriteExtMapEntities(ostream& out =G4cout);
    virtual const char * WriteExtMapEntities(SCLstring &buf);
    virtual void AppendEntity(STEPcomplex *stepc);

  protected:
    virtual void CopyAs (STEPentity *);
    void BuildAttrs(const char *s );
    void AddEntityPart(const char *name);
    void AssignDerives();
    
};

#endif
