// This code implementation is the intellectual property of
// the GEANT4 collaboration.
//
// By copying, distributing or modifying the Program (or any work
// based on the Program) you indicate your acceptance of this statement,
// and all its terms.
//
// $Id: G4SigmaMinus.cc,v 1.3.6.1 1999/12/07 20:49:32 gunter Exp $
// GEANT4 tag $Name: geant4-01-00 $
//
// 
// ----------------------------------------------------------------------
//      GEANT 4 class implementation file
//
//      For information related to this code contact:
//      CERN, CN Division, ASD Group
//      History: first implementation, based on object model of
//      4th April 1996, G.Cosmo
// **********************************************************************
//  Added particle definitions, H.Kurashige, 14 Feb  1997
// ----------------------------------------------------------------------

#include <fstream.h>
#include <iomanip.h>

#include "G4SigmaMinus.hh"

#include "G4PhaseSpaceDecayChannel.hh"
#include "G4DecayTable.hh"

// ######################################################################
// ###                           SigmaMinus                           ###
// ######################################################################

G4SigmaMinus::G4SigmaMinus(
       const G4String&     aName,        G4double            mass,
       G4double            width,        G4double            charge,   
       G4int               iSpin,        G4int               iParity,    
       G4int               iConjugation, G4int               iIsospin,   
       G4int               iIsospin3,    G4int               gParity,
       const G4String&     pType,        G4int               lepton,      
       G4int               baryon,       G4int               encoding,
       G4bool              stable,       G4double            lifetime,
       G4DecayTable        *decaytable )
 : G4VBaryon( aName,mass,width,charge,iSpin,iParity,
              iConjugation,iIsospin,iIsospin3,gParity,pType,
              lepton,baryon,encoding,stable,lifetime,decaytable )
{
 //create Decay Table 
  G4DecayTable*   table = GetDecayTable();
  if (table!=NULL) delete table;
  table = new G4DecayTable();

  // create decay channels
  G4VDecayChannel** mode = new G4VDecayChannel*[1];
  // sigma- -> neutron + pi-
  mode[0] = new G4PhaseSpaceDecayChannel("sigma-",1.00,2,"neutron","pi-");
 
  for (G4int index=0; index <1; index++ ) table->Insert(mode[index]);  
  delete [] mode;

  SetDecayTable(table);
}

// ......................................................................
// ...                 static member definitions                      ...
// ......................................................................
//     
//    Arguments for constructor are as follows
//               name             mass          width         charge
//             2*spin           parity  C-conjugation
//          2*Isospin       2*Isospin3       G-parity
//               type    lepton number  baryon number   PDG encoding
//             stable         lifetime    decay table 

G4SigmaMinus G4SigmaMinus::theSigmaMinus(
             "sigma-",     1.19744*GeV,  4.45e-12*MeV,    -1*eplus, 
		    1,              +1,             0,          
		    2,              -2,             0,             
	     "baryon",               0,            +1,        3112,
		false,       0.1479*ns,          NULL
);

G4SigmaMinus* G4SigmaMinus::SigmaMinusDefinition(){return &theSigmaMinus;}
// initialization for static cut values
G4double   G4SigmaMinus::theSigmaMinusLengthCut = -1.0;
G4double*  G4SigmaMinus::theSigmaMinusKineticEnergyCuts = NULL;
