// This code implementation is the intellectual property of
// the GEANT4 collaboration.
//
// By copying, distributing or modifying the Program (or any work
// based on the Program) you indicate your acceptance of this statement,
// and all its terms.
//
// $Id: G4DynamicParticleFastVector.hh,v 1.1.10.1 1999/12/07 20:49:50 gunter Exp $
// GEANT4 tag $Name: geant4-01-00 $
//
// 
// ------------------------------------------------------------
//	GEANT 4 class header file 
//
//	For information related to this code contact:
//	CERN, CN Division, ASD group
//	History: first implementation, based on object model of
//	2nd December 1995, G.Cosmo
// ------------------------------------------------------------

#ifndef G4DynamicParticleFastVector_h
#define G4DynamicParticleFastVector_h 1

#include "globals.hh"
#include "G4ios.hh"

class G4DynamicParticle;
#include "G4FastVector.hh"


typedef G4FastVector<G4DynamicParticle,512> G4DynamicParticleFastVector;
//  Contains pointers to G4DynamicParticle objects which are
//  generated by either primary or secondary interaction.

#endif

