
#include "G4NucleiPropertiesTheoreticalTable.hh"


//+-----------------------------+
//| Table of Atomic Mass Excess |
//+-----------------------------+
// unit: MeV
G4double G4NucleiPropertiesTheoreticalTable::AtomicMassExcess
        [G4NucleiPropertiesTheoreticalTable::nEntries] = {
 -4.84, -0.17, -2.62,  2.56,  2.57,  8.20, 10.41, 17.72, 22.14, 30.93,
 36.75, 46.58, 53.73, 65.03, 72.83, 82.30, 91.32,104.63,113.70,  1.90,
  1.21, -3.08,  0.10, -0.68,  3.08,  4.24,  9.32, 12.81, 19.94, 24.99,
 33.22, 39.88, 49.32, 53.55, 63.38, 72.02, 83.79, 93.12,104.00,110.24,
124.51,  3.21,  0.47, -7.72, -5.87, -8.69, -5.01, -5.98, -0.98,  1.02,
  7.25, 10.02, 17.83, 22.44, 29.13, 33.32, 42.96, 49.56, 60.85, 68.78,
 79.59, 84.85, 98.86,107.82,118.93, 11.47,  6.16, -2.82, -4.93, -9.82,
 -7.43, -8.97, -5.89, -5.18, -0.73,  2.48,  8.21, 12.25, 18.44, 23.14,
 30.00, 36.19, 45.38, 52.41, 61.44, 68.78, 80.14, 88.51, 99.15,107.71,
118.77, 16.07,  9.86, -1.50, -5.84,-14.08,-12.52,-16.39,-12.54,-14.50,
 -9.34, -9.14, -3.55, -1.42,  5.36,  7.89, 14.92, 19.16, 27.56, 32.74,
 41.12, 45.42, 58.18, 65.52, 76.28, 78.06, 95.37,101.10,115.53, 26.48,
 18.04,  6.45,  0.40, -8.45,-10.77,-16.90,-15.48,-16.44,-14.48,-14.40,
-10.76, -9.07, -4.21, -1.54,  4.39,  8.29, 15.18, 20.06, 28.15, 30.43,
 41.11, 49.47, 58.38, 61.22, 76.24, 84.70, 95.83,105.02,115.13,123.86,
 33.17, 23.60,  9.82,  3.20, -8.35,-12.73,-21.10,-20.38,-22.48,-20.51,
-22.30,-19.29,-19.51,-14.76,-13.37, -7.95, -5.73,  0.88,  4.82,  9.78,
 12.87, 22.62, 29.17, 38.44, 42.28, 55.21, 62.62, 73.26, 81.03, 92.00,
 99.17,109.51,117.75, 45.66, 33.78, 20.52, 11.39,  1.05, -6.50,-15.89,
-17.43,-21.94,-21.75,-24.00,-22.78,-23.46,-20.42,-19.44,-15.19,-13.41,
 -8.35, -5.48,  0.62,  3.19, 11.64, 17.18, 24.86, 29.18, 39.81, 46.60,
 56.55, 64.34, 73.74, 81.71, 91.06, 98.86,109.64,118.58, 55.74, 43.40,
 27.74, 17.22,  3.88, -2.70,-12.30,-16.59,-23.75,-24.37,-28.32,-27.57,
-29.95,-27.26,-27.78,-24.30,-23.88,-19.20,-17.79,-12.15, -9.38, -2.64,
  1.72,  9.22, 14.05, 22.25, 27.65, 37.67, 44.48, 53.87, 60.74, 70.61,
 77.62, 87.57, 95.55,108.22,117.20, 70.02, 54.31, 39.29, 28.26, 14.83,
  4.91, -5.38,-11.47,-19.01,-23.12,-28.11,-28.40,-31.19,-30.27,-31.12,
-28.68,-28.57,-25.27,-24.05,-19.91,-18.31,-12.63, -8.64, -2.06,  2.62,
  9.89, 15.29, 23.56, 30.24, 38.73, 45.90, 54.66, 61.71, 69.42, 76.33,
 85.75, 92.41,102.60,111.67, 64.71, 45.81, 35.41, 19.95, 10.79, -2.12,
 -7.76,-17.03,-22.48,-29.56,-30.96,-35.38,-34.77,-36.53,-34.39,-35.62,
-32.88,-33.30,-30.03,-28.99,-24.03,-21.24,-14.88,-11.47, -4.48, -0.29,
  7.56, 12.86, 20.22, 24.98, 34.13, 40.49, 49.31, 55.56, 64.38, 70.32,
 80.57, 88.39, 99.44,108.94,119.56, 61.63, 48.08, 32.16, 20.62,  7.40,
 -0.99,-10.68,-16.91,-24.93,-28.87,-34.39,-35.36,-37.78,-36.97,-38.55,
-37.32,-38.06,-35.71,-35.44,-31.61,-28.86,-23.51,-19.78,-13.77, -9.53,
 -2.68,  2.52,  8.92, 14.11, 21.93, 27.01, 34.92, 40.78, 48.96, 55.59,
 66.21, 72.98, 82.44, 89.86, 99.39,107.00,117.43, 72.94, 58.76, 40.83,
 28.78, 13.66,  4.90, -6.51,-13.13,-22.88,-27.99,-35.44,-36.65,-40.86,
-40.40,-43.48,-42.47,-44.70,-43.06,-43.79,-40.30,-38.65,-33.55,-31.07,
-25.39,-22.46,-16.25,-12.82, -5.29, -1.99,  5.59, 10.47, 17.78, 23.10,
 31.94, 37.53, 46.38, 52.43, 61.47, 67.90, 77.27, 83.65, 94.58,102.73,
113.66, 70.75, 54.23, 40.37, 25.05, 14.67,  2.91, -5.46,-15.45,-22.21,
-29.89,-33.58,-38.70,-39.83,-43.29,-43.77,-46.43,-45.66,-46.89,-44.53,
-43.40,-39.36,-36.84,-32.03,-29.17,-23.84,-20.44,-14.59,-10.99, -4.83,
 -1.02,  6.67, 11.68, 18.97, 24.37, 32.16, 37.96, 46.09, 52.34, 60.76,
 67.62, 77.04, 84.94, 94.90,103.72,114.94, 63.45, 49.64, 33.53, 22.63,
  9.21,  0.58,-10.40,-17.48,-26.90,-31.52,-38.83,-40.25,-45.10,-45.86,
-49.89,-50.13,-52.30,-50.34,-50.22,-46.56,-45.53,-41.20,-39.58,-34.26,
-32.12,-26.47,-23.95,-18.00,-14.68, -7.55, -4.07,  3.59,  7.75, 15.43,
 20.41, 28.39, 33.65, 41.82, 47.47, 57.16, 64.43, 74.62, 82.79, 93.69,
102.38,111.73,120.75, 62.54, 45.71, 33.84, 19.86, 10.22, -0.89, -9.43,
-19.20,-25.27,-32.96,-36.43,-42.36,-45.59,-48.85,-50.49,-52.84,-52.14,
-52.25,-49.73,-49.21,-45.76,-44.44,-40.31,-38.49,-33.56,-31.18,-26.17,
-23.29,-16.89,-13.49, -7.82, -3.08,  3.40,  8.08, 15.15, 20.46, 27.63,
 33.32, 42.08, 49.41, 58.85, 66.68, 76.33, 84.45, 94.33,102.91,113.18,
122.23, 55.65, 43.31, 28.04, 17.70,  5.44, -3.49,-14.66,-21.08,-30.12,
-34.64,-42.51,-46.29,-50.60,-52.76,-56.35,-55.99,-57.47,-55.16,-55.80,
-52.64,-52.48,-48.68,-47.91,-42.70,-41.18,-36.03,-34.95,-28.74,-26.33,
-20.50,-17.34,-11.09, -7.36, -0.33,  4.13, 11.23, 16.02, 24.73, 31.21,
 40.44, 47.29, 56.85, 65.14, 74.81, 82.57, 92.36,100.53,110.96,119.45,
 56.06, 40.12, 28.84, 15.02,  5.47, -5.92,-13.80,-23.16,-30.03,-38.58,
-42.74,-49.11,-51.49,-55.42,-56.16,-57.70,-56.57,-57.42,-55.50,-55.57,
-52.95,-52.15,-48.42,-47.19,-42.98,-40.95,-36.25,-34.48,-29.29,-26.39,
-20.94,-17.44,-11.52, -7.38, -1.26,  3.38, 11.38, 17.99, 26.46, 33.35,
 42.24, 49.42, 59.16, 67.00, 76.19, 83.85, 93.54,101.79,111.75,119.89,
 49.40, 37.99, 23.62, 12.91, -0.02, -8.12,-18.93,-25.08,-34.60,-40.82,
-48.35,-51.93,-57.08,-58.12,-60.72,-60.01,-61.98,-60.19,-61.49,-59.16,
-59.41,-56.02,-55.99,-52.41,-51.52,-46.53,-45.36,-40.23,-38.25,-33.08,
-30.56,-24.74,-21.61,-15.59,-11.98, -3.97,  1.85, 10.08, 16.55, 25.49,
 31.98, 41.16, 48.57, 57.77, 64.45, 74.04, 81.63, 91.22, 98.68,109.43,
116.36, 50.51, 34.72, 23.33,  9.58,  0.26,-11.21,-18.71,-28.68,-35.08,
-43.78,-48.21,-54.92,-56.56,-59.80,-59.90,-61.97,-61.39,-62.70,-61.17,
-61.80,-59.49,-59.61,-56.92,-56.24,-52.58,-51.44,-47.38,-45.50,-41.22,
-38.83,-34.02,-31.17,-26.07,-22.48,-15.36, -9.68, -2.05,  4.18, 12.34,
 18.72, 27.49, 34.78, 43.11, 49.91, 58.60, 65.96, 74.96, 82.19, 92.22,
100.32,109.53,117.79,127.66, 44.73, 32.20, 17.59,  7.83, -4.66,-12.38,
-23.57,-30.40,-40.40,-46.39,-54.40,-56.88,-60.84,-61.30,-64.64,-64.18,
-66.44,-65.26,-66.96,-65.23,-66.27,-64.12,-64.31,-60.41,-60.47,-56.32,
-55.19,-51.09,-49.52,-45.13,-43.12,-38.13,-36.04,-28.49,-24.12,-16.22,
-11.16, -2.51,  3.21, 11.68, 18.35, 26.81, 32.82, 41.43, 47.92, 56.83,
 63.58, 73.09, 80.57, 90.14, 97.41,107.10,114.88,124.74, 44.97, 29.68,
 19.13,  5.94, -2.78,-14.28,-21.97,-32.20,-38.65,-47.74,-50.88,-56.15,
-57.63,-61.22,-61.95,-64.63,-64.43,-66.51,-65.57,-66.94,-65.24,-65.73,
-63.26,-63.22,-60.38,-59.74,-56.49,-55.25,-51.52,-49.68,-45.52,-42.95,
-36.82,-32.14,-25.29,-20.33,-13.11, -7.67,  0.04,  6.55, 14.26, 19.90,
 27.81, 34.40, 42.49, 49.19, 58.21, 65.67, 74.64, 81.89, 90.96, 98.51,
108.34,116.71,126.40, 29.04, 15.18,  6.18, -6.70,-14.62,-25.95,-32.89,
-42.47,-46.80,-53.60,-55.53,-60.33,-61.27,-65.07,-65.32,-68.34,-67.72,
-69.95,-68.37,-69.92,-67.56,-68.54,-65.88,-66.56,-63.43,-63.13,-59.44,
-58.51,-54.28,-52.62,-46.70,-42.79,-36.26,-32.18,-25.27,-20.72,-13.00,
 -7.58,  0.25,  5.25, 13.30, 19.10, 26.89, 32.87, 41.66, 48.48, 57.33,
 63.84, 72.48, 79.38, 89.41, 97.17,106.79,114.54,124.36, 27.90, 17.64,
  4.68, -4.40,-15.73,-23.83,-33.78,-39.03,-46.22,-49.83,-55.42,-57.65,
-61.74,-62.96,-65.92,-66.38,-68.75,-68.35,-69.94,-68.64,-69.71,-68.34,
-68.85,-66.61,-66.48,-63.76,-62.96,-59.74,-57.90,-53.08,-49.16,-43.55,
-39.58,-33.38,-28.95,-22.29,-17.26,-10.18, -5.34,  1.79,  7.27, 14.77,
 20.93, 29.16, 35.53, 43.59, 50.06, 58.15, 64.90, 73.89, 81.50, 90.57,
 98.18,107.28,114.25,123.36, 27.47, 13.35,  4.02, -8.37,-16.59,-27.38,
-33.22,-41.36,-45.86,-53.04,-55.58,-60.78,-62.12,-66.48,-66.83,-70.17,
-69.95,-72.51,-71.50,-73.34,-71.72,-73.60,-71.53,-72.36,-69.79,-69.82,
-66.48,-65.49,-60.78,-58.06,-52.47,-49.33,-43.32,-39.65,-33.20,-29.07,
-22.19,-17.83,-11.03, -6.22,  1.29,  6.61, 14.51, 20.00, 27.85, 33.52,
 41.52, 47.71, 56.60, 63.54, 72.41, 79.39, 88.52, 95.77,104.30,111.82,
121.12,128.93, 25.99, 15.47,  2.86, -6.25,-17.27,-24.05,-32.72,-38.35,
-45.88,-49.97,-55.96,-58.46,-63.03,-64.33,-67.78,-68.58,-71.23,-71.24,
-73.23,-72.51,-74.36,-73.23,-74.26,-72.63,-72.70,-70.52,-69.58,-65.67,
-63.05,-58.20,-55.12,-49.89,-46.38,-40.77,-36.82,-30.76,-26.46,-20.33,
-15.69, -8.95, -3.72,  3.21,  8.52, 15.55, 21.35, 28.69, 34.64, 42.81,
 49.55, 57.86, 64.73, 73.08, 80.34, 88.59, 96.14,104.78,112.34,119.06,
126.63, 25.08, 11.39,  2.03, -9.77,-16.93,-26.65,-32.56,-41.17,-46.05,
-53.55,-56.33,-61.87,-63.39,-67.77,-68.56,-72.32,-72.50,-75.49,-74.93,
-77.46,-76.51,-78.45,-77.01,-78.11,-75.72,-75.68,-71.78,-70.18,-65.41,
-63.17,-58.14,-55.44,-49.91,-46.82,-40.94,-37.50,-31.51,-27.56,-20.95,
-16.44, -9.67, -5.36,  1.57,  6.70, 13.90, 19.27, 27.30, 33.43, 41.62,
 47.78, 56.23, 62.90, 71.29, 77.70, 86.49, 93.49,100.31,107.45,117.57,
126.43, 23.96, 14.19,  1.58, -6.60,-16.71,-23.58,-32.48,-38.43,-46.35,
-50.58,-56.79,-59.45,-63.81,-65.91,-69.40,-70.62,-73.73,-74.12,-76.20,
-76.48,-78.66,-78.15,-79.44,-77.86,-78.22,-75.10,-73.51,-69.62,-67.23,
-63.01,-60.52,-55.83,-52.82,-48.04,-44.71,-39.51,-35.72,-29.83,-25.46,
-19.38,-14.98, -8.72, -3.87,  2.81,  8.15, 15.48, 21.50, 29.12, 35.41,
 44.34, 50.96, 57.17, 63.75, 71.66, 78.54, 84.55, 91.52,101.17,109.96,
120.63,129.85, 23.84, 10.20,  1.72, -9.41,-16.44,-26.39,-32.55,-41.50,
-46.39,-54.03,-56.86,-62.87,-64.83,-69.56,-69.96,-74.16,-74.78,-77.50,
-77.83,-80.88,-80.92,-82.86,-81.68,-83.00,-79.93,-79.10,-75.24,-73.69,
-69.61,-67.95,-63.33,-61.31,-56.71,-54.16,-49.11,-46.04,-40.31,-36.71,
-30.72,-26.93,-20.77,-16.76,-10.04, -5.39,  1.82,  7.40, 14.91, 21.65,
 29.64, 35.60, 41.50, 47.40, 55.20, 61.10, 67.64, 73.83, 83.49, 91.71,
102.13,110.81,121.10,130.40, 13.70,  2.21, -5.77,-15.92,-23.38,-32.51,
-38.30,-46.43,-51.16,-57.79,-61.01,-65.68,-67.65,-70.72,-72.22,-75.24,
-76.36,-79.62,-80.23,-82.65,-82.43,-83.91,-81.65,-80.86,-77.70,-76.29,
-73.11,-71.59,-67.89,-66.04,-62.26,-59.90,-55.58,-52.61,-47.65,-44.13,
-38.86,-35.12,-29.56,-25.65,-19.74,-14.99, -8.65, -3.19,  4.03, 10.57,
 18.01, 22.26, 29.11, 34.80, 42.01, 47.79, 53.74, 59.72, 68.90, 76.97,
 86.94, 95.40,105.34,114.48,125.42,133.43,143.15, 10.57,  2.43, -8.72,
-15.85,-26.07,-32.38,-41.62,-47.04,-54.97,-58.35,-64.06,-66.15,-68.84,
-70.65,-75.50,-76.77,-80.88,-81.61,-85.02,-85.01,-87.54,-85.21,-85.12,
-82.05,-81.23,-77.99,-77.55,-74.19,-73.01,-69.31,-67.71,-63.46,-61.29,
-56.47,-53.69,-48.51,-45.45,-40.04,-36.74,-30.86,-26.80,-20.32,-15.34,
 -8.38, -2.73,  3.47,  8.08, 14.85, 20.04, 27.18, 32.40, 38.20, 43.66,
 52.85, 60.41, 69.99, 78.10, 87.88, 97.04,107.55,114.98,125.01,132.79,
142.58, 13.76,  2.51, -5.78,-16.01,-23.35,-32.77,-39.18,-47.42,-52.11,
-58.50,-61.44,-66.13,-66.79,-71.82,-73.93,-78.22,-79.82,-83.41,-84.19,
-87.12,-85.41,-85.41,-83.07,-82.57,-79.91,-79.43,-76.82,-76.06,-73.09,
-71.70,-68.15,-66.11,-62.01,-59.34,-54.88,-51.89,-47.16,-43.92,-38.78,
-34.83,-28.93,-24.20,-17.43,-12.76, -6.44, -1.92,  4.09,  9.15, 15.66,
 21.10, 26.39, 31.47, 40.17, 47.65, 56.72, 64.77, 74.05, 82.79, 92.72,
100.30,109.44,117.40,126.55,134.84,144.50, 11.34,  2.98, -8.30,-15.84,
-26.07,-32.69,-41.82,-47.18,-54.84,-58.01,-61.74,-64.61,-70.53,-72.82,
-77.96,-79.72,-84.19,-85.24,-88.98,-87.33,-88.16,-85.94,-86.00,-83.60,
-83.69,-81.08,-81.04,-78.16,-77.53,-74.13,-72.83,-68.82,-66.89,-62.49,
-60.16,-55.56,-52.97,-47.97,-44.62,-38.86,-34.87,-28.15,-24.43,-18.49,
-14.52, -8.54, -4.18,  2.25,  7.10, 12.36, 16.81, 25.50, 32.39, 41.44,
 48.87, 58.56, 66.78, 76.38, 83.62, 92.47,100.00,109.24,116.91,126.56,
134.49,144.18, 14.39,  3.47, -4.97,-15.46,-22.94,-32.41,-38.71,-46.55,
-51.02,-56.89,-59.25,-65.35,-68.51,-73.80,-76.41,-81.03,-82.88,-86.62,
-86.07,-86.97,-85.53,-85.80,-84.27,-84.44,-82.42,-82.39,-80.16,-79.73,
-77.08,-75.94,-72.63,-70.76,-67.01,-64.76,-60.73,-58.24,-53.90,-50.71,
-45.63,-41.20,-35.87,-32.22,-27.05,-23.14,-17.79,-13.49, -7.74, -2.88,
  1.44,  6.15, 14.14, 20.97, 29.51, 36.72, 46.20, 54.11, 63.08, 70.29,
 78.69, 86.10, 94.85,102.49,111.56,119.43,128.59,136.59,145.83,  3.59,
 -7.05,-14.10,-25.37,-31.76,-39.59,-44.99,-51.84,-55.75,-62.72,-66.03,
-72.20,-74.96,-80.44,-82.42,-87.17,-86.59,-88.34,-87.03,-88.20,-86.64,
-87.44,-85.47,-85.99,-83.71,-83.80,-81.27,-80.77,-77.66,-76.52,-72.86,
-71.28,-67.36,-65.57,-61.31,-58.78,-53.14,-50.47,-45.52,-42.55,-37.43,
-34.12,-28.85,-25.19,-19.57,-15.34,-11.06, -7.17,  0.77,  7.16, 15.57,
 22.39, 32.27, 39.15, 48.07, 54.83, 63.35, 70.24, 78.98, 86.12, 95.18,
102.50,111.68,119.20,128.43,136.03,145.19,152.83,  4.14, -3.93,-14.12,
-21.25,-30.65,-36.95,-43.89,-49.02,-56.54,-60.65,-67.02,-70.60,-76.22,
-79.00,-83.88,-84.06,-85.93,-85.38,-86.95,-86.04,-86.90,-85.64,-86.09,
+-84.53,-84.75,-82.73,-82.32,-79.80,-78.86,-75.89,-73.69,-70.46,-68.85,
-65.21,-63.06,-58.89,-56.31,-51.97,-49.05,-44.60,-41.39,-36.69,-33.14,
-28.09,-23.95,-20.28,-16.50, -9.13, -2.81,  5.08, 12.09, 21.03, 27.83,
 36.18, 42.99, 50.99, 57.69, 66.04, 73.12, 81.64, 88.83, 97.54,105.09,
113.79,121.32,130.06,137.76,147.14,155.86,  4.83, -6.24,-12.24,-22.44,
-28.92,-38.44,-44.10,-52.79,-57.10,-64.29,-68.01,-74.48,-77.39,-83.08,
-83.32,-85.97,-85.54,-87.88,-87.11,-88.68,-87.52,-88.63,-87.06,-87.82,
-85.79,-86.01,-83.58,-83.26,-80.43,-79.41,-76.30,-75.35,-71.81,-70.32,
-66.24,-64.29,-60.04,-57.81,-53.41,-50.84,-46.31,-43.37,-38.45,-35.80,
-31.63,-28.43,-21.08,-15.33, -7.50, -1.35,  7.72, 14.21, 22.49, 28.94,
 37.01, 43.25, 51.56, 58.11, 66.58, 73.29, 81.92, 88.92, 97.67,104.75,
113.57,120.76,130.18,138.22,148.07,156.12,  4.91, -2.38,-12.71,-19.93,
-29.66,-36.11,-44.99,-50.43,-58.13,-62.58,-69.20,-72.87,-78.68,-79.82,
-82.70,-83.22,-85.33,-85.33,-86.99,-86.53,-87.73,-86.68,-87.35,-86.18,
-86.33,-84.72,-84.01,-81.95,-81.60,-79.15,-78.31,-75.40,-74.03,-70.57,
-68.76,-65.10,-62.94,-59.19,-56.79,-52.83,-50.05,-45.71,-43.16,-39.55,
-36.50,-29.62,-24.02,-16.76,-10.17, -2.10,  4.26, 12.03, 18.37, 26.07,
 32.20, 39.88, 46.47, 54.41, 61.01, 69.14, 76.08, 84.24, 91.33, 99.71,
106.96,115.86,123.93,133.12,141.15,150.34,158.34, -4.96,-12.35,-22.89,
-29.51,-39.23,-45.16,-54.03,-58.68,-66.27,-69.98,-76.69,-77.84,-81.55,
-81.83,-84.88,-85.03,-87.43,-87.01,-88.89,-87.94,-89.30,-88.05,-88.95,
-87.39,-87.91,-85.46,-85.80,-83.45,-83.28,-80.41,-79.75,-76.35,-75.20,
-71.67,-70.31,-66.60,-64.83,-60.85,-59.04,-55.16,-53.37,-49.45,-46.84,
-40.23,-35.20,-27.93,-22.40,-13.92, -7.99, -0.12,  5.60, 13.43, 19.12,
 26.76, 32.69, 40.67, 46.84, 54.95, 61.39, 69.58, 76.17, 84.62, 91.41,
100.25,107.69,116.86,124.40,133.57,141.03,150.23,157.78, -2.49,-13.22,
-20.66,-30.54,-37.20,-46.25,-52.02,-59.94,-64.56,-71.14,-73.37,-77.08,
-78.31,-81.33,-82.28,-84.66,-84.85,-86.82,-86.54,-87.92,-87.21,-88.21,
-87.15,-87.79,-86.17,-86.56,-84.89,-84.82,-82.57,-82.03,-79.21,-78.31,
-75.19,-73.94,-70.75,-69.64,-66.32,-64.89,-61.50,-59.66,-56.31,-53.81,
-47.74,-42.78,-36.06,-30.64,-22.56,-16.97, -9.43, -3.84,  3.71,  9.47,
 16.57, 22.41, 29.90, 36.04, 43.62, 50.00, 57.69, 64.22, 72.20, 78.97,
 87.26, 94.56,103.29,110.72,119.38,126.76,135.48,142.97,151.65,159.27,
168.47, -5.41,-13.00,-23.71,-30.60,-40.44,-46.68,-55.85,-60.53,-68.17,
-70.19,-74.89,-75.95,-79.52,-80.59,-83.64,-84.13,-86.73,-86.64,-88.76,
-88.19,-89.83,-88.78,-90.07,-88.68,-89.61,-87.80,-88.30,-86.10,-86.24,
-83.51,-83.64,-80.85,-80.41,-77.26,-76.94,-73.84,-72.78,-69.43,-68.29,
-65.03,-63.12,-57.08,-52.68,-45.93,-41.01,-33.96,-28.85,-20.76,-15.43,
 -7.49, -2.18,  4.90, 10.21, 17.69, 23.32, 30.91, 36.77, 44.44, 50.47,
 58.38, 64.73, 72.92, 79.73, 88.36, 95.36,104.01,110.90,119.53,126.59,
135.28,142.50,151.61,159.41,168.36, -3.38,-14.30,-21.98,-31.99,-39.01,
-48.22,-54.13,-62.17,-64.96,-69.54,-71.53,-75.21,-76.75,-79.79,-80.92,
-83.61,-84.18,-86.35,-86.31,-88.08,-87.64,-89.04,-88.21,-89.21,-87.94,
-88.66,-87.12,-87.52,-85.68,-85.77,-83.58,-83.43,-80.97,-80.63,-77.99,
-77.40,-74.60,-73.62,-70.56,-68.69,-63.32,-59.03,-52.73,-47.92,-41.35,
-36.23,-28.82,-23.75,-16.63,-10.59, -3.98,  1.39,  8.41, 13.94, 21.03,
 26.88, 34.04, 40.04, 47.43, 53.74, 61.52, 68.24, 76.26, 83.04, 91.24,
 98.17,106.39,113.36,121.89,129.26,137.89,145.11,153.62,161.20,169.87,
 -6.70,-14.52,-25.33,-32.52,-42.58,-48.73,-57.87,-60.99,-66.38,-68.34,
-72.70,-74.20,-78.00,-78.85,-82.21,-82.72,-85.83,-85.95,-88.50,-88.04,
-90.30,-89.57,-91.26,-90.18,-91.43,-89.91,-90.92,-89.31,-90.01,-88.00,
-88.49,-86.19,-86.36,-83.84,-83.71,-80.92,-80.55,-77.56,-76.41,-70.99,
-67.20,-61.00,-56.67,-50.21,-45.70,-38.92,-34.20,-26.77,-21.90,-14.24,
 -9.49, -2.50,  2.60,  9.66, 15.08, 22.20, 27.71, 35.10, 40.91, 48.61,
 54.87, 62.90, 69.25, 77.42, 84.04, 92.18, 98.71,107.28,113.94,122.46,
129.33,137.91,144.77,153.39,160.55,169.28,-12.31,-20.22,-30.29,-37.33,
-46.60,-50.66,-56.49,-59.35,-63.92,-66.33,-70.32,-72.14,-75.68,-77.08,
-80.07,-80.92,-83.52,-83.94,-86.25,-86.32,-88.25,-87.90,-89.34,-88.55,
-89.61,-88.41,-89.18,-87.71,-88.26,-86.45,-86.85,-84.85,-85.12,-82.83,
-82.64,-80.12,-78.97,-74.29,-70.44,-64.92,-60.69,-54.09,-49.88,-43.73,
-39.25,-32.36,-27.86,-21.64,-16.91,-10.61, -5.62,  1.01,  6.28, 12.99,
 18.51, 25.41, 31.19, 38.38, 44.58, 52.09, 58.44, 66.18, 72.77, 80.48,
 87.15, 95.16,101.88,109.92,116.68,124.86,131.61,139.89,147.02,155.59,
163.20,171.46,-10.02,-21.09,-27.92,-38.03,-42.42,-49.33,-52.26,-57.94,
-60.36,-65.25,-67.26,-71.54,-73.04,-76.80,-77.93,-81.15,-81.95,-84.72,
-84.61,-87.18,-86.97,-89.07,-88.43,-90.01,-88.92,-90.29,-88.87,-89.96,
-88.25,-89.23,-87.54,-88.03,-85.90,-86.26,-83.86,-83.30,-78.63,-75.50,
-69.96,-66.31,-59.97,-56.23,-50.11,-46.36,-40.39,-36.51,-30.43,-26.21,
-19.97,-15.50, -9.02, -4.24,  2.49,  7.53, 14.37, 19.62, 26.66, 32.41,
 39.93, 45.85, 53.57, 59.71, 67.45, 73.69, 81.56, 87.91, 96.07,102.40,
110.50,117.15,125.08,131.85,140.56,147.23,155.80,162.51,170.64,177.49,
 -8.07,-15.83,-25.60,-31.23,-38.44,-42.45,-48.52,-51.95,-57.01,-59.87,
-64.31,-66.69,-70.55,-72.53,-75.85,-77.28,-80.16,-81.06,-83.52,-83.97,
-85.78,-85.76,-87.40,-86.90,-88.20,-87.41,-88.41,-87.38,-88.19,-86.88,
-87.55,-86.08,-86.57,-84.68,-84.28,-80.21,-77.15,-71.50,-68.25,-63.15,
-59.69,-54.35,-50.77,-45.37,-41.55,-36.14,-31.97,-26.30,-21.91,-15.91,
-11.24, -5.16, -0.18,  6.12, 11.34, 17.78, 23.47, 30.54, 36.41, 43.63,
 49.67, 57.01, 63.16, 70.68, 77.16, 84.81, 91.25, 98.83,105.50,113.35,
119.75,128.00,134.85,142.97,149.80,157.41,164.26,172.08,179.34, -5.29,
-15.87,-21.52,-29.50,-34.24,-41.38,-45.02,-50.91,-53.86,-59.20,-61.76,
-66.46,-68.54,-72.61,-74.07,-77.67,-78.66,-81.79,-82.30,-84.95,-85.04,
-87.10,-86.77,-88.42,-87.65,-89.08,-88.02,-89.24,-87.98,-89.20,-87.92,
-88.75,-86.99,-87.16,-83.23,-80.61,-75.52,-72.75,-67.98,-65.22,-60.19,
-57.05,-51.75,-48.66,-43.39,-39.79,-34.15,-30.24,-24.43,-20.26,-14.27,
 -9.91, -3.76,  0.92,  7.48, 12.69, 19.70, 25.14, 32.32, 37.90, 45.23,
 50.99, 58.50, 64.39, 72.07, 78.24, 85.94, 92.01,100.01,106.28,114.25,
120.75,128.77,135.08,142.86,149.35,157.03,164.04,174.40,183.49, -9.41,
-17.67,-23.33,-30.69,-35.75,-42.19,-45.81,-51.16,-54.42,-59.48,-62.19,
-66.42,-68.53,-72.20,-73.86,-77.10,-78.30,-80.98,-81.73,-83.72,-83.98,
-85.68,-85.48,-86.88,-86.38,-87.43,-86.60,-87.67,-86.75,-87.95,-86.81,
-87.03,-83.75,-81.11,-76.57,-74.21,-70.26,-67.60,-63.32,-60.28,-55.51,
-52.51,-47.80,-44.23,-39.19,-35.35,-30.17,-26.10,-20.61,-16.37,-10.76,
 -6.15, -0.09,  5.07, 11.66, 16.99, 23.72, 29.27, 36.17, 41.91, 48.99,
 54.79, 62.08, 68.18, 75.50, 81.68, 89.03, 95.35,102.74,109.59,117.18,
123.50,130.82,137.28,144.60,151.48,161.46,170.38,180.69,189.70, -7.99,
-13.81,-22.22,-27.53,-34.70,-38.58,-44.94,-48.50,-54.38,-57.23,-62.13,
-64.36,-68.68,-70.41,-74.31,-75.60,-78.94,-79.75,-82.49,-82.75,-84.90,
-84.75,-86.57,-86.07,-87.63,-86.80,-88.38,-87.45,-89.18,-88.09,-88.92,
-85.60,-83.76,-79.29,-77.60,-73.83,-71.92,-67.67,-65.20,-60.74,-58.30,
-53.78,-50.82,-45.94,-42.60,-37.44,-33.90,-28.51,-24.74,-19.21,-15.16,
 -9.10, -4.45,  2.06,  6.95, 13.66, 18.78, 25.62, 30.96, 38.01, 43.45,
 50.54, 56.29, 63.62, 69.40, 76.64, 82.69, 90.11, 96.61,104.03,110.13,
117.45,123.51,130.71,137.38,147.29,155.59,165.93,174.64,184.20,192.49,
201.88, -2.10,-10.61,-16.45,-24.34,-29.40,-36.14,-40.53,-46.59,-50.10,
-55.15,-57.92,-62.31,-64.68,-68.64,-70.50,-73.89,-75.27,-78.02,-78.84,
-81.00,-81.38,-83.21,-83.24,-84.84,-84.57,-85.97,-85.58,-87.39,-86.84,
-87.78,-84.92,-83.26,-79.31,-77.87,-74.78,-73.05,-69.24,-66.98,-63.41,
-61.12,-57.23,-54.36,-50.01,-46.78,-42.14,-38.63,-33.72,-30.01,-24.98,
-21.02,-15.38,-10.77, -4.70,  0.18,  6.41, 11.51, 17.98, 23.25, 29.79,
 35.20, 41.81, 47.53, 54.42, 60.19, 67.00, 73.03, 80.05, 86.75, 93.62,
 99.69,106.52,112.62,119.49,126.04,135.32,143.79,153.73,162.31,171.38,
179.70,188.78,197.28,206.60, -7.19,-15.56,-21.22,-29.21,-33.80,-40.57,
-44.27,-50.01,-52.95,-57.99,-60.41,-64.93,-66.87,-70.82,-72.24,-75.54,
-76.39,-79.17,-79.43,-81.89,-81.96,-84.02,-83.76,-85.67,-85.32,-87.62,
-87.15,-88.68,-85.88,-84.78,-81.04,-80.23,-77.19,-76.00,-72.33,-70.83,
-67.49,-65.80,-62.05,-59.78,-55.56,-52.90,-48.38,-45.40,-40.55,-37.29,
-32.32,-28.70,-23.23,-19.01,-13.04, -8.62, -2.43,  2.23,  8.61, 13.43,
 20.03, 25.00, 31.56, 36.82, 43.72, 49.07, 55.93, 61.53, 68.90, 74.94,
 81.87, 87.48, 94.39, 99.94,106.82,112.90,122.33,130.13,140.24,148.27,
157.28,165.15,174.31,182.80,191.68,199.33,208.78, -4.41,-10.87,-19.11,
-24.69,-31.87,-36.33,-42.19,-45.75,-50.83,-53.85,-58.42,-60.93,-64.94,
-66.90,-70.28,-71.62,-74.36,-75.26,-77.64,-78.10,-80.13,-80.46,-82.35,
-82.54,-84.83,-84.88,-86.53,-84.30,-83.28,-80.25,-79.41,-76.97,-75.79,
-72.98,-71.86,-69.09,-67.47,-64.31,-62.17,-58.51,-55.93,-51.91,-48.99,
-44.64,-41.53,-36.93,-33.35,-28.36,-24.30,-18.68,-14.34, -8.58, -3.95,
  2.04,  6.85, 13.00, 17.96, 24.18, 29.23, 35.70, 41.05, 47.50, 53.07,
 60.01, 66.04, 72.60, 78.28, 84.66, 90.22, 96.72,102.75,111.73,119.62,
129.22,137.07,145.58,153.46,162.71,170.70,179.17,186.87,195.76,203.76,
212.89,-10.69,-16.66,-24.83,-29.40,-35.90,-39.56,-45.30,-48.36,-53.54,
-56.13,-60.75,-62.80,-66.76,-68.17,-71.49,-72.20,-75.13,-75.73,-78.32,
-78.62,-81.01,-81.30,-84.10,-84.29,-86.48,-84.33,-83.82,-80.85,-80.52,
-78.22,-77.71,-75.16,-74.70,-72.02,-71.02,-67.89,-66.40,-62.80,-60.82,
-56.90,-54.54,-50.28,-47.66,-43.19,-40.19,-35.20,-31.54,-25.93,-21.93,
-16.24,-12.08, -6.12, -1.75,  4.34,  8.84, 15.04, 19.68, 26.15, 31.07,
 37.70, 42.76, 50.26, 55.31, 61.95, 67.17, 73.55, 78.66, 85.13, 90.81,
 99.77,107.12,116.69,124.06,132.73,140.25,149.41,156.90,165.55,172.75,
181.49,189.06,198.12,205.85,215.01, -5.91,-14.24,-19.75,-26.63,-30.93,
-36.77,-40.49,-45.73,-48.91,-53.60,-56.27,-60.30,-62.37,-65.72,-67.06,
-69.88,-71.07,-73.61,-74.29,-76.71,-77.48,-80.31,-81.01,-83.33,-81.75,
-81.31,-78.92,-78.78,-77.10,-76.77,-74.78,-74.42,-72.29,-71.40,-68.87,
-67.47,-64.44,-62.61,-59.24,-57.02,-53.31,-50.77,-46.78,-43.86,-39.34,
-35.76,-30.61,-26.65,-21.28,-17.19,-11.70, -7.32, -1.60,  2.89,  8.66,
 13.28, 19.33, 24.22, 30.49, 35.47, 42.49, 47.54, 53.71, 59.00, 65.05,
 70.05, 76.10, 81.76, 90.31, 97.64,106.53,113.82,122.34,129.78,138.62,
145.94,154.04,161.31,169.65,177.20,185.84,193.52,202.32,209.86,218.65,
226.49,-11.09,-18.86,-23.29,-29.69,-33.54,-39.44,-42.68,-48.05,-50.77,
-55.56,-57.62,-61.59,-63.07,-66.52,-67.74,-70.83,-71.55,-74.51,-75.34,
-78.66,-79.44,-82.32,-80.79,-80.90,-78.62,-78.94,-77.22,-77.47,-75.50,
-75.77,-73.72,-73.38,-70.90,-70.09,-67.13,-65.82,-62.62,-60.95,-57.38,
-55.36,-51.45,-49.05,-44.58,-41.38,-36.32,-32.98,-27.77,-24.17,-18.73,
-14.83, -9.19, -5.15,  0.59,  4.76, 10.77, 15.33, 21.65, 26.21, 33.19,
 37.81, 44.06, 48.88, 54.94, 59.57, 65.65, 70.90, 79.42, 86.32, 95.18,
102.04,110.64,117.72,126.42,133.39,141.42,148.21,156.66,163.80,172.34,
179.75,188.41,195.92,204.27,211.71,220.34,228.05, -7.59,-12.81,-19.70,
-24.24,-30.30,-34.22,-39.75,-43.16,-48.03,-50.66,-54.73,-56.74,-60.23,
-62.01,-65.27,-66.40,-69.30,-70.65,-73.96,-75.19,-78.19,-77.11,-77.41,
-75.78,-76.29,-75.08,-75.42,-74.03,-74.28,-72.71,-72.46,-70.47,-69.70,
-67.34,-66.15,-63.48,-61.95,-58.87,-56.95,-53.56,-51.25,-47.34,-44.37,
-39.87,-36.46,-31.73,-28.21,-23.22,-19.35,-14.11,-10.05, -4.74, -0.56,
  4.97,  9.51, 15.38, 20.00, 26.42, 31.00, 36.86, 41.71, 47.39, 52.11,
 57.69, 62.91, 71.03, 77.92, 86.18, 93.00,101.43,108.40,116.71,123.55,
131.24,138.07,146.06,153.18,161.38,168.63,176.91,184.01,192.37,199.79,
208.00,215.57,224.44,232.48,-11.35,-16.06,-22.81,-26.88,-33.15,-36.68,
-42.20,-44.94,-49.60,-51.71,-55.99,-57.68,-61.56,-62.03,-66.21,-67.64,
-71.33,-72.78,-76.25,-75.24,-76.07,-74.49,-75.43,-74.22,-75.10,-73.68,
-74.46,-72.92,-73.18,-71.24,-71.02,-68.74,-68.12,-65.50,-64.51,-61.54,
-60.18,-56.87,-55.03,-51.24,-48.79,-44.40,-41.71,-37.12,-34.10,-29.19,
-25.83,-20.64,-17.05,-11.76, -8.00, -2.46,  1.67,  7.49, 11.80, 18.13,
 22.27, 28.15, 32.60, 38.32, 42.68, 48.26, 53.09, 61.18, 67.64, 75.96,
 82.40, 90.76, 97.33,105.50,112.08,119.79,126.15,134.18,140.88,149.05,
155.87,164.12,170.89,179.21,186.13,194.48,201.74,210.42,218.04,227.25,
235.17, -5.60,-12.75,-17.52,-23.89,-28.11,-33.76,-37.11,-41.80,-44.47,
-48.65,-51.14,-54.99,-55.96,-60.09,-62.05,-65.74,-67.50,-71.18,-70.56,
-71.59,-70.67,-71.76,-71.13,-72.06,-71.16,-71.97,-70.92,-71.21,-69.77,
-69.64,-67.83,-67.35,-65.21,-64.40,-61.92,-60.63,-57.82,-56.13,-52.84,
-50.53,-46.72,-44.13,-40.03,-37.08,-32.66,-29.33,-24.56,-20.92,-16.17,
-12.39, -7.33, -3.19,  2.26,  6.59, 12.41, 16.52, 21.96, 26.43, 31.85,
 36.20, 41.57, 46.17, 53.98, 60.47, 68.28, 74.75, 82.56, 89.07, 96.85,
105.54,110.69,117.04,124.66,131.30,139.11,145.85,153.73,160.72,168.42,
175.25,183.29,190.54,198.95,206.54,215.34,223.18,231.88,239.82,248.91,
 -9.38,-16.42,-20.71,-27.02,-30.48,-35.79,-38.62,-43.46,-45.83,-50.28,
-51.27,-56.03,-58.06,-62.21,-64.25,-68.31,-67.96,-69.43,-68.41,-69.93,
-69.27,-70.72,-69.84,-71.11,-70.09,-70.91,-69.49,-69.90,-68.16,-68.24,
-66.17,-65.91,-63.52,-62.78,-60.06,-58.90,-55.76,-53.96,-50.28,-48.22,
-44.24,-41.85,-37.49,-34.67,-30.00,-26.92,-22.08,-18.77,-13.70,-10.01,
 -4.55, -0.64,  5.13,  8.79, 14.27, 18.33, 23.73, 27.69, 32.98, 37.30,
 45.08, 50.95, 58.94, 65.18, 73.01, 79.10, 86.85, 92.93,100.31,106.25,
113.87,120.12,127.87,134.21,142.12,148.64,156.62,162.96,170.96,177.70,
186.08,193.32,201.99,209.43,218.09,225.61,234.80,242.69,252.07,-11.27,
-17.71,-21.75,-27.16,-30.52,-35.28,-38.43,-42.85,-44.24,-48.99,-51.57,
-55.76,-58.00,-62.17,-62.24,-63.96,-63.64,-65.25,-65.08,-66.64,-66.29,
-67.58,-67.03,-67.85,-66.98,-67.47,-66.26,-66.43,-64.89,-64.72,-62.88,
-62.21,-60.02,-59.00,-56.34,-54.66,-51.53,-49.61,-46.19,-43.84,-39.95,
-37.17,-32.97,-29.86,-25.50,-22.19,-17.56,-13.88, -8.90, -4.86,  0.40,
  4.02,  9.15, 13.16, 18.14, 22.10, 27.13, 31.35, 38.71, 44.62, 52.39,
 58.51, 65.85, 71.88, 79.23, 85.22, 92.22, 98.17,105.38,111.59,118.96,
125.27,132.77,139.37,146.87,153.22,160.84,167.70,175.62,182.73,190.97,
198.31,206.55,214.01,222.69,230.64,239.60,247.63,256.62, -9.87,-14.06,
-19.98,-23.50,-28.87,-31.96,-36.92,-38.51,-43.84,-46.49,-51.23,-53.58,
-58.27,-58.42,-60.67,-60.48,-62.46,-62.24,-64.22,-63.86,-65.56,-65.07,
-66.48,-65.62,-66.64,-65.50,-66.18,-64.76,-65.10,-63.35,-63.24,-61.15,
-60.58,-58.06,-56.93,-53.92,-52.52,-49.21,-47.40,-43.61,-41.31,-37.23,
-34.62,-30.33,-27.49,-22.87,-19.63,-14.68,-11.05, -5.88, -2.68,  2.44,
  6.02, 10.98, 14.54, 19.43, 23.39, 30.73, 36.14, 43.95, 49.71, 57.18,
 62.81, 70.14, 75.77, 82.86, 88.44, 95.64,101.46,108.84,114.77,122.22,
128.40,136.06,142.20,149.63,155.96,163.90,170.58,178.75,185.64,193.84,
200.90,209.60,217.05,225.94,233.52,242.53,250.21,259.20,-10.36,-14.38,
-19.78,-23.60,-28.63,-30.62,-36.00,-39.22,-44.02,-46.62,-51.30,-52.02,
-54.31,-54.76,-56.82,-57.16,-59.18,-59.30,-61.04,-60.91,-62.40,-62.06,
-63.12,-62.53,-63.27,-62.35,-62.79,-61.58,-61.53,-59.94,-59.49,-57.44,
-56.45,-53.96,-52.70,-49.97,-48.21,-44.93,-42.72,-39.08,-36.52,-32.67,
-29.86,-25.68,-22.52,-17.98,-14.37, -9.57, -6.44, -1.72,  1.85,  6.36,
  9.92, 14.42, 18.28, 25.28, 30.66, 38.11, 44.02, 50.80, 56.47, 63.45,
 69.08, 75.80, 81.40, 88.19, 93.98,100.96,106.86,113.92,120.07,127.28,
133.39,140.79,146.90,154.32,161.04,168.81,175.67,183.49,190.51,198.80,
206.21,214.66,222.23,230.79,238.42,247.05,254.75,263.47, -6.29,-12.28,
-16.12,-20.17,-23.95,-29.94,-33.21,-38.62,-41.28,-46.54,-47.30,-50.13,
-50.26,-53.05,-53.45,-55.81,-55.93,-58.14,-58.01,-59.90,-59.64,-61.25,
-60.65,-61.95,-61.03,-61.99,-60.80,-61.29,-59.73,-59.80,-57.83,-57.35,
-55.06,-54.29,-51.65,-50.48,-47.29,-45.61,-42.08,-40.10,-36.19,-33.97,
-29.90,-27.12,-22.65,-19.54,-14.73,-12.04, -7.39, -4.28,  0.16,  3.29,
  7.75, 11.25, 18.05, 23.13, 30.69, 36.13, 43.01, 48.33, 55.18, 60.62,
 67.44, 72.68, 79.47, 84.88, 91.84, 97.36,104.46,110.18,117.37,123.25,
130.49,136.26,143.78,150.02,157.71,164.18,171.98,178.63,186.91,193.94,
202.36,209.50,217.99,225.24,233.72,240.99,249.63,257.10,266.35,274.47,
 -6.43,-10.80,-15.08,-21.14,-24.92,-30.34,-33.53,-38.84,-40.15,-43.04,
-43.79,-46.59,-47.49,-49.92,-50.52,-52.72,-53.04,-54.90,-55.04,-56.78,
-56.65,-57.91,-57.46,-58.49,-57.73,-58.29,-57.23,-57.32,-55.90,-55.53,
-53.72,-53.15,-51.01,-49.94,-47.24,-45.69,-42.67,-40.68,-37.52,-35.20,
-31.63,-28.98,-24.99,-21.91,-17.38,-14.75,-10.56, -7.50, -3.52, -0.41,
  3.69,  7.21, 13.47, 18.53, 25.61, 31.13, 37.62, 42.93, 49.43, 54.84,
 61.28, 66.56, 73.04, 78.38, 84.94, 90.45, 97.17,102.84,109.68,115.52,
122.41,128.44,135.59,141.46,148.82,155.24,162.66,169.27,177.17,184.14,
192.20,199.32,207.44,214.61,222.71,229.91,238.15,245.56,254.49,262.42,
271.52,279.64, -7.26,-13.98,-17.85,-23.90,-27.26,-33.25,-34.53,-37.99,
-38.82,-41.80,-42.83,-45.74,-46.32,-48.98,-49.32,-51.63,-51.73,-53.82,
-53.74,-55.55,-55.11,-56.58,-55.85,-56.89,-55.82,-56.47,-55.09,-55.26,
-53.54,-53.45,-51.40,-50.79,-48.17,-47.16,-44.23,-42.82,-39.50,-37.92,
-34.42,-32.29,-28.30,-26.01,-21.47,-19.31,-15.22,-12.77, -8.74, -6.09,
 -2.00,  1.06,  7.30, 11.93, 18.79, 23.98, 30.78, 35.71, 42.34, 47.18,
 53.89, 58.81, 65.27, 70.30, 76.86, 81.96, 88.67, 93.99,100.81,106.25,
113.18,118.82,125.97,131.77,138.85,144.85,152.32,158.48,166.48,173.01,
181.33,187.99,196.02,202.56,210.60,217.40,225.59,232.60,241.44,249.11,
258.02,265.78,274.82,284.42, -4.33, -8.78,-14.92,-18.78,-24.87,-26.64,
-30.22,-31.44,-34.62,-36.09,-38.97,-40.09,-42.75,-43.55,-45.88,-46.42,
-48.52,-48.80,-50.67,-50.69,-52.19,-51.89,-52.97,-52.32,-53.04,-52.14,
-52.39,-51.13,-51.21,-49.59,-49.09,-47.00,-46.00,-43.64,-42.33,-39.64,
-38.15,-35.03,-33.03,-29.53,-27.47,-23.15,-21.05,-17.44,-15.07,-11.47,
 -8.86, -5.17, -2.12,  3.69,  8.27, 14.81, 19.88, 26.22, 31.21, 37.40,
 42.29, 48.66, 53.58, 59.71, 64.78, 70.91, 76.01, 82.34, 87.64, 94.14,
 99.55,106.22,111.83,118.56,124.34,131.25,137.23,144.36,150.26,158.12,
164.57,172.37,178.98,186.62,193.28,200.78,207.51,215.35,222.30,230.76,
238.24,246.86,254.57,263.86,272.55,281.49,289.21, -7.65,-11.70,-18.17,
-20.16,-24.28,-25.42,-29.04,-30.43,-33.85,-35.00,-38.11,-38.95,-41.74,
-42.31,-44.83,-45.11,-47.40,-47.40,-49.31,-49.02,-50.55,-49.90,-51.14,
-50.22,-51.05,-49.83,-50.41,-48.85,-48.84,-46.83,-46.39,-44.03,-43.33,
-40.73,-39.60,-36.68,-35.11,-32.17,-30.47,-26.17,-24.55,-21.04,-19.22,
-15.68,-13.61,-10.01, -7.34, -1.53,  2.56,  8.94, 13.62, 20.22, 24.84,
 31.24, 35.71, 41.97, 46.72, 52.92, 57.58, 63.81, 68.54, 74.88, 79.81,
 86.29, 91.33, 97.92,103.21,109.92,115.36,122.25,127.87,135.00,140.85,
148.38,154.59,162.19,168.40,176.02,182.30,189.91,196.29,204.09,210.65,
218.95,226.16,234.84,242.39,251.19,259.53,268.15,275.33,286.50,293.78,
303.29, -2.46, -9.06,-11.49,-15.71,-17.48,-21.03,-22.96,-26.33,-27.89,
-31.03,-32.30,-35.04,-36.11,-38.63,-39.36,-41.65,-42.12,-44.02,-44.24,
-45.81,-45.69,-46.92,-46.47,-47.41,-46.62,-47.24,-46.18,-46.33,-44.74,
-44.33,-42.44,-41.71,-39.61,-38.51,-36.13,-34.95,-32.49,-30.90,-27.60,
-25.41,-22.34,-20.66,-17.53,-15.50,-12.13, -9.53, -4.19,  0.00,  6.05,
 10.56, 16.57, 21.18, 27.16, 31.72, 37.61, 42.40, 48.26, 52.95, 58.83,
 63.56, 69.51, 74.44, 80.56, 85.59, 91.84, 97.05,103.46,108.86,115.37,
121.01,127.72,133.55,140.75,146.82,154.05,160.26,167.61,173.85,181.15,
187.42,194.94,201.42,209.40,216.63,224.90,232.80,241.49,248.80,257.09,
265.14,275.02,282.39,291.34,298.72,307.22, -4.33, -9.07,-10.71,-14.69,
-16.41,-20.24,-21.84,-25.44,-26.77,-30.02,-30.97,-33.98,-34.77,-37.45,
-37.92,-40.34,-40.35,-42.45,-42.30,-44.04,-43.56,-45.06,-44.26,-45.39,
-44.33,-45.02,-43.45,-43.56,-41.72,-41.35,-39.26,-38.69,-36.53,-36.02,
-33.62,-32.62,-29.61,-27.97,-25.09,-23.90,-20.85,-19.29,-16.14,-13.90,
 -8.64, -4.89,  1.11,  5.25, 11.39, 15.66, 21.82, 26.04, 31.94, 36.26,
 42.33, 46.68, 52.60, 57.00, 63.03, 67.58, 73.74, 78.36, 84.62, 89.48,
 95.84,100.85,107.40,112.64,119.39,124.86,132.04,137.76,145.00,150.89,
158.30,164.19,171.49,177.43,184.90,190.99,199.02,205.99,214.46,221.93,
230.19,237.37,247.15,254.94,262.36,269.33,278.66,285.71,294.13,301.56,
309.85, -2.20, -6.12, -8.16,-11.88,-13.83,-17.37,-19.15,-22.34,-23.76,
-26.70,-27.81,-30.40,-31.29,-33.66,-34.51,-36.33,-36.81,-38.70,-38.63,
-40.17,-39.67,-40.92,-40.26,-41.10,-39.97,-39.92,-38.41,-38.28,-36.82,
-36.53,-34.80,-34.41,-32.39,-31.68,-29.22,-27.92,-25.77,-24.52,-21.89,
-20.39,-17.62,-15.43,-10.43, -6.88, -1.25,  2.80,  8.64, 12.89, 18.71,
 22.93, 28.50, 32.80, 38.61, 42.93, 48.61, 52.97, 58.62, 63.16, 68.96,
 73.68, 79.57, 84.44, 90.41, 95.43,101.56,106.79,113.18,118.67,125.51,
131.31,138.35,144.20,151.35,157.22,164.22,170.13,177.14,183.28,190.97,
197.88,206.21,213.16,221.12,229.40,237.59,245.03,251.82,258.80,267.75,
275.06,283.15,290.38,298.28,305.96,315.23, -0.81, -5.00, -6.77,-10.63,
-12.53,-16.11,-17.53,-20.93,-22.18,-25.25,-26.25,-29.00,-29.58,-32.18,
-32.41,-34.58,-34.64,-36.47,-36.20,-37.78,-37.15,-38.22,-37.25,-37.14,
-35.88,-36.56,-35.09,-35.54,-33.88,-34.13,-32.29,-32.27,-30.01,-29.64,
-27.49,-26.73,-24.16,-23.06,-20.35,-18.54,-13.71,-10.43, -4.80, -1.12,
  4.53,  8.44, 14.23, 18.21, 23.85, 27.85, 33.54, 37.53, 43.29, 47.35,
 53.06, 57.27, 63.08, 67.39, 73.27, 77.79, 83.82, 88.48, 94.68, 99.56,
105.94,111.08,117.93,123.36,130.26,135.90,142.98,148.59,155.59,161.18,
168.20,174.01,181.68,188.15,196.49,203.11,213.16,218.80,227.03,233.85,
241.76,248.14,256.18,262.89,271.06,277.93,285.36,292.68,301.92,309.21,
317.96,325.59,  3.73,  1.51, -2.35, -4.29, -7.89, -9.55,-12.87,-14.30,
-17.34,-18.52,-21.32,-22.28,-24.82,-25.53,-27.81,-28.24,-30.25,-30.37,
-32.01,-31.82,-33.13,-32.55,-33.57,-32.80,-33.56,-32.55,-33.10,-31.86,
-32.19,-30.76,-30.81,-29.10,-28.72,-27.04,-26.32,-24.14,-23.14,-20.86,
-19.18,-14.62,-11.47, -6.39, -2.60,  2.69,  6.55, 11.83, 15.79, 21.24,
 25.23, 30.71, 34.71, 40.17, 44.23, 49.60, 53.86, 59.34, 63.62, 69.19,
 73.69, 79.40, 84.06, 89.91, 94.77,100.84,105.94,112.47,117.89,124.45,
130.04,136.76,142.31,149.22,154.63,161.41,167.18,174.55,181.31,191.25,
197.39,204.69,210.56,218.20,224.54,230.82,237.45,245.17,253.03,260.85,
266.77,274.74,281.97,290.84,298.14,306.56,314.17,322.81,330.90,  4.84,
  2.89, -1.16, -2.88, -6.64, -8.11,-11.61,-12.79,-16.01,-16.99,-19.94,
-20.68,-23.41,-23.86,-26.33,-26.52,-28.58,-28.48,-30.27,-29.81,-31.33,
-30.64,-31.89,-30.94,-31.94,-30.80,-31.66,-30.17,-30.75,-29.12,-29.30,
-27.45,-27.28,-25.19,-24.66,-22.52,-21.20,-16.78,-13.99, -8.95, -5.58,
 -0.32,  3.13,  8.51, 12.02, 17.64, 21.35, 27.01, 30.71, 36.12, 39.80,
 45.08, 48.98, 54.46, 58.38, 63.93, 68.09, 73.77, 78.07, 83.92, 88.46,
 94.53, 99.29,105.83,110.91,117.58,122.73,129.44,134.67,141.45,146.62,
153.48,158.99,166.22,174.31,181.55,187.02,194.06,199.57,206.79,212.82,
220.37,226.60,234.34,240.85,248.57,255.16,263.17,270.06,278.76,285.76,
294.19,301.45,310.04,317.82,327.93,336.39,  8.00,  5.92,  2.12,  0.30,
 -3.24, -4.87, -8.17, -9.50,-12.57,-13.65,-16.44,-17.26,-19.74,-20.36,
-22.51,-22.88,-24.76,-24.84,-26.49,-26.30,-27.71,-27.19,-28.42,-27.75,
-28.59,-27.68,-28.22,-27.10,-27.33,-26.04,-25.90,-24.19,-23.78,-21.92,
-20.71,-16.64,-13.89, -9.19, -5.97, -1.22,  2.25,  7.20, 10.79, 15.99,
 19.59, 24.49, 28.27, 33.67, 37.68, 42.63, 46.54, 51.67, 55.60, 60.85,
 65.00, 70.30, 74.60, 80.08, 84.59, 90.31, 95.07,101.26,106.37,112.64,
117.82,124.19,129.43,135.79,142.95,149.60,154.92,161.71,167.21,174.17,
179.92,186.81,192.57,199.73,205.79,213.09,219.19,226.63,232.99,240.47,
246.56,254.41,261.17,268.89,275.88,283.92,291.14,299.52,307.30,317.11,
325.54,335.77,344.56, 13.72,  9.42,  7.45,  3.43,  1.77, -2.03, -3.43,
 -6.93, -8.09,-11.24,-12.09,-14.99,-15.52,-18.18,-18.52,-20.87,-20.88,
-23.09,-22.83,-24.79,-24.30,-25.96,-25.26,-26.61,-25.67,-26.71,-25.61,
-26.30,-24.99,-25.44,-23.90,-23.98,-22.02,-21.15,-17.17,-14.80,-10.16,
 -7.39, -2.52,  0.41,  5.32,  8.34, 13.27, 16.48, 21.60, 25.00, 30.97,
 34.32, 39.22, 42.66, 47.86, 51.37, 56.54, 60.31, 65.59, 69.54, 75.01,
 79.18, 84.85, 89.32, 95.51,100.26,106.57,111.45,117.79,122.71,129.10,
135.49,142.10,147.08,153.85,158.81,165.92,171.32,178.19,183.64,190.79,
196.46,203.74,209.64,217.07,223.13,230.65,236.76,244.28,250.57,258.31,
265.00,272.99,279.93,288.32,295.78,305.61,313.71,323.86,332.27,342.06,
350.38,360.04, 18.31, 14.27, 12.10,  8.53,  6.41,  3.02,  1.39, -1.93,
 -3.30, -6.28, -7.35,-10.05,-10.88,-13.31,-13.86,-16.05,-16.32,-18.25,
-18.23,-19.94,-19.75,-21.14,-20.68,-21.73,-21.06,-21.81,-20.90,-21.31,
-20.11,-20.20,-18.74,-17.99,-14.43,-12.05, -7.87, -5.18, -0.66,  2.14,
  6.55,  9.48, 13.94, 17.17, 21.81, 25.08, 29.89, 33.19, 37.74, 41.29,
 46.03, 49.54, 54.34, 58.13, 63.04, 66.99, 72.09, 76.27, 81.61, 86.04,
 91.89, 96.63,102.60,107.45,113.47,118.38,124.44,130.81,137.18,142.12,
148.51,153.72,160.18,165.60,172.09,177.56,184.38,190.12,197.04,202.88,
210.00,216.07,223.26,229.21,236.65,243.05,250.39,257.04,264.77,271.72,
279.79,287.29,296.79,304.87,314.72,323.08,332.57,340.92,350.23,358.71,
370.62, 20.06, 15.55, 13.24,  9.13,  7.20,  3.63,  2.22, -0.77, -1.66,
 -4.43, -5.06, -8.06, -8.57,-10.85,-11.19,-13.40,-13.54,-15.53,-15.32,
-17.17,-16.70,-18.22,-17.57,-18.74,-17.86,-18.83,-17.72,-18.23,-16.78,
-16.33,-12.84,-10.94, -6.77, -4.46, -0.09,  2.29,  6.39,  8.88, 13.47,
 16.24, 20.76, 23.61, 27.99, 30.89, 35.35, 38.45, 43.12, 46.24, 51.00,
 54.40, 59.22, 62.81, 67.91, 71.72, 77.01, 81.12, 86.95, 91.38, 97.37,
101.92,107.96,112.56,118.61,123.27,129.45,134.37,142.14,146.84,153.41,
158.51,164.98,170.12,176.96,182.35,189.27,194.19,201.90,207.65,214.77,
220.53,227.92,234.01,241.36,247.62,255.37,261.99,270.07,277.24,286.75,
294.49,304.23,312.30,321.64,329.64,338.90,349.46,358.45,366.19,375.51,
 22.63, 18.32, 15.97, 12.34, 10.59,  7.44,  6.14,  3.59,  2.28, -0.47,
 -1.43, -3.78, -4.30, -6.37, -6.69, -8.64, -8.90,-10.62,-10.66,-12.09,
-12.06,-12.96,-12.77,-13.58,-12.77,-13.28,-12.27,-11.87, -8.75, -6.99,
 -3.23, -0.96,  2.94,  4.89,  8.46, 10.94, 14.61, 17.20, 21.35, 24.14,
 28.09, 30.90, 34.95, 37.98, 42.25, 45.33, 49.71, 53.07, 57.54, 61.14,
 65.86, 69.68, 74.60, 78.55, 84.22, 88.61, 94.35, 98.86,104.56,109.14,
114.87,119.52,125.40,130.27,137.69,142.60,148.83,153.87,160.07,165.14,
171.59,177.02,183.61,188.29,195.95,201.68,208.53,214.22,221.32,227.40,
234.61,240.89,248.31,254.96,262.70,269.90,279.08,286.78,296.28,304.32,
313.44,321.30,332.15,339.79,348.48,356.23,365.01,373.06,382.03, 25.91,
 23.49, 19.43, 17.57, 14.04, 12.79,  9.69,  8.70,  5.75,  4.74,  1.93,
  1.27, -1.13, -1.53, -3.66, -3.82, -6.10, -6.14, -8.06, -7.92, -9.28,
 -8.93,-10.06, -9.30,-10.27, -9.28, -9.26, -6.17, -4.77, -1.04,  0.70,
  4.14,  5.92,  9.20, 11.07, 14.60, 16.93, 20.93, 23.23, 27.08, 29.47,
 33.43, 36.00, 40.16, 42.87, 47.17, 50.15, 54.60, 57.82, 62.56, 66.00,
 70.92, 74.51, 80.22, 84.24, 89.91, 94.15, 99.88,104.15,109.88,114.19,
120.04,124.59,130.74,136.77,143.18,147.86,153.93,158.73,165.13,170.23,
176.82,181.16,188.87,194.31,201.16,206.37,213.44,219.40,226.59,232.60,
240.09,246.45,254.19,261.08,270.26,277.61,287.05,294.65,303.68,311.29,
321.35,328.68,337.33,344.75,353.67,361.37,370.38,377.82,386.97,394.85,
 28.99, 26.71, 23.09, 21.23, 18.12, 16.90, 13.92, 13.01, 10.15,  9.04,
  6.52,  5.77,  3.55,  3.02,  1.00,  0.67, -1.45, -1.69, -3.18, -2.96,
 -4.09, -3.67, -4.64, -4.03, -4.01, -1.35, -0.07,  3.24,  5.00,  7.45,
  8.84, 11.72, 13.40, 16.73, 18.80, 22.28, 24.41, 27.92, 30.28, 33.90,
 36.37, 40.14, 42.82, 46.74, 49.67, 53.79, 57.01, 61.36, 64.82, 69.35,
 72.91, 78.18, 82.36, 87.70, 91.91, 97.35,101.64,107.00,111.31,116.81,
121.38,127.18,133.34,139.31,144.00,149.87,154.58,160.69,165.72,171.97,
176.41,183.75,189.28,195.75,200.91,207.69,213.77,220.65,226.72,233.82,
240.21,247.62,254.51,263.37,270.71,279.88,287.50,297.14,304.34,312.65,
319.95,328.30,335.70,344.44,352.00,361.10,369.18,376.95,384.87,395.70,
403.74, 30.70, 28.93, 25.37, 24.02, 20.70, 19.44, 16.76, 15.60, 12.76,
 11.91,  9.34,  8.77,  6.31,  5.93,  3.47,  3.26,  1.38,  1.59,  0.15,
  0.53, -0.81, -0.17, -0.62,  1.93,  2.85,  6.05,  7.36,  9.36, 10.48,
 13.13, 14.34, 17.74, 19.38, 22.47, 24.24, 27.68, 29.62, 33.12, 35.15,
 38.86, 41.14, 45.02, 47.63, 51.63, 54.46, 58.78, 61.88, 66.51, 69.71,
 74.98, 78.85, 84.18, 87.99, 93.41, 97.41,102.78,106.79,112.29,116.49,
122.34,126.99,134.26,138.77,144.51,148.98,154.98,159.74,165.99,169.94,
177.48,182.65,189.16,193.90,200.79,206.46,213.51,219.24,226.41,232.47,
239.91,246.49,255.35,262.35,271.45,278.74,287.65,294.55,302.79,309.74,
318.10,325.40,334.03,341.32,350.58,358.02,366.85,373.41,384.15,391.86,
398.87,406.70, 34.82, 32.90, 29.58, 28.05, 25.38, 24.33, 21.42, 20.17,
 17.52, 16.52, 14.05, 13.27, 11.01, 10.50,  8.34,  8.24,  6.86,  6.93,
  5.60,  5.80,  5.28,  7.48,  8.35, 10.90, 12.24, 13.43, 14.34, 16.53,
 17.92, 20.69, 22.05, 24.74, 26.40, 29.40, 31.28, 34.32, 36.30, 39.63,
 41.86, 45.41, 48.00, 51.64, 54.46, 58.40, 61.48, 65.58, 68.94, 73.87,
 77.59, 82.74, 86.59, 91.69, 95.63,100.69,104.69,109.89,114.12,119.61,
124.26,131.31,135.91,141.45,145.76,151.54,156.23,162.23,166.06,173.25,
178.42,184.59,189.47,195.92,201.59,208.40,214.14,220.99,227.09,234.20,
240.79,249.30,256.30,265.08,272.35,280.23,287.06,295.06,301.99,309.98,
317.17,325.39,332.81,341.42,348.86,356.74,364.33,374.70,382.37,389.17,
397.03,405.88,413.93, 37.16, 35.54, 32.23, 31.36, 28.40, 27.14, 24.10,
 23.07, 20.17, 19.32, 16.58, 16.01, 13.66, 13.50, 11.76, 11.75, 10.12,
 10.30,  9.42, 11.52, 11.96, 14.40, 15.10, 16.37, 16.85, 19.01, 20.20,
 22.51, 23.78, 26.21, 27.33, 30.07, 31.39, 34.36, 35.94, 39.22, 41.09,
 44.62, 46.79, 50.40, 52.85, 56.81, 59.52, 63.59, 66.59, 71.51, 74.87,
 80.03, 83.53, 88.54, 92.23, 97.27,100.93,106.12,109.99,115.55,119.90,
125.91,131.18,136.72,140.86,146.44,150.96,156.88,160.60,167.72,172.61,
178.78,183.39,189.84,195.16,202.06,207.46,214.33,220.09,227.26,233.53,
242.07,248.71,257.41,264.23,271.66,278.18,286.18,292.88,300.84,307.65,
315.87,322.96,331.55,338.23,346.65,355.49,364.01,371.40,378.38,385.93,
394.77,402.52,411.69,419.97,428.76, 44.94, 41.61, 40.40, 37.18, 35.65,
 32.78, 31.34, 28.68, 27.41, 24.67, 23.73, 21.37, 20.93, 19.17, 18.83,
 17.19, 17.01, 16.08, 17.83, 18.21, 20.70, 21.47, 21.25, 21.76, 23.67,
 24.38, 26.64, 27.19, 29.25, 30.33, 32.60, 33.90, 36.49, 38.01, 40.86,
 42.73, 45.85, 48.06, 51.26, 53.69, 57.31, 59.99, 63.88, 66.62, 71.01,
 74.56, 79.44, 82.89, 87.57, 91.20, 95.95, 99.62,104.48,108.38,113.58,
117.95,123.75,128.02,134.18,138.34,143.82,148.19,153.87,157.57,164.41,
169.29,175.22,179.75,185.89,191.21,197.80,203.22,209.77,215.56,222.43,
228.71,236.92,243.54,251.86,257.73,265.19,271.80,279.43,286.06,293.68,
300.50,308.34,315.35,323.38,330.46,338.62,347.19,355.38,362.74,371.18,
377.29,385.80,393.71,402.65,410.66,420.19,426.83,435.92, 48.07, 44.58,
 43.06, 39.87, 38.37, 35.33, 34.26, 31.08, 30.11, 27.35, 26.82, 24.75,
 24.39, 22.38, 22.17, 20.87, 22.64, 22.50, 23.98, 24.12, 25.12, 25.22,
 27.14, 27.45, 29.08, 29.29, 31.21, 31.85, 34.08, 34.90, 37.40, 38.52,
 41.34, 42.84, 45.93, 47.77, 50.95, 53.01, 56.59, 58.90, 62.75, 65.16,
 69.48, 72.72, 77.54, 80.63, 85.32, 88.60, 93.31, 96.63,101.48,105.04,
110.28,114.35,119.79,124.13,129.57,133.89,139.49,143.75,149.42,152.90,
159.56,164.14,170.02,174.40,180.55,185.52,192.16,197.27,203.82,209.32,
216.17,222.13,230.37,236.67,244.89,250.18,257.60,263.79,271.39,277.80,
285.48,291.97,299.80,306.58,314.63,321.38,329.57,337.51,345.73,352.64,
361.00,368.28,377.08,383.52,392.31,400.18,408.10,415.60,424.67,434.44,
441.78, 52.26, 49.04, 47.41, 44.31, 42.85, 39.93, 38.55, 35.82, 34.88,
 32.85, 32.15, 30.21, 29.73, 28.29, 29.70, 29.47, 31.48, 29.80, 31.09,
 31.22, 32.45, 32.32, 33.55, 33.69, 35.22, 35.76, 37.54, 38.28, 40.38,
 41.42, 43.90, 45.33, 48.08, 49.69, 52.65, 54.68, 57.90, 60.15, 63.67,
 66.01, 70.02, 73.19, 77.49, 80.82, 85.16, 88.44, 92.82, 96.15,100.66,
104.19,109.11,113.15,118.30,122.71,127.85,132.09,137.42,141.79,147.07,
150.66,156.99,161.62,167.19,171.55,177.38,182.37,188.77,193.95,200.22,
205.76,212.23,218.20,226.08,232.35,238.88,244.93,251.97,258.12,265.49,
271.77,279.16,285.70,293.27,300.10,308.21,315.01,323.52,330.19,337.95,
344.94,352.88,360.13,368.35,375.83,383.51,390.80,399.15,406.65,415.45,
425.18,432.29,440.34,449.62, 55.05, 51.65, 50.09, 46.92, 45.63, 42.50,
 41.55, 39.12, 38.38, 36.04, 35.46, 33.72, 35.05, 34.45, 35.15, 34.48,
 35.58, 35.22, 36.49, 35.90, 37.11, 36.81, 38.31, 38.38, 40.12, 40.45,
 42.48, 43.10, 45.51, 46.53, 49.08, 50.44, 53.37, 54.99, 58.11, 59.98,
 63.19, 65.39, 69.33, 72.19, 76.46, 79.39, 83.68, 86.59, 90.97, 93.94,
 98.44,101.63,106.54,110.27,115.46,119.59,124.75,128.48,134.08,138.13,
143.38,146.74,152.98,157.22,162.84,166.83,172.76,177.41,183.80,188.66,
194.90,200.10,206.67,212.32,220.13,226.12,233.74,238.44,245.40,251.34,
258.46,264.53,271.93,278.28,286.19,292.54,300.27,307.15,314.90,321.43,
329.12,335.70,343.78,350.55,358.93,365.57,373.73,380.72,389.07,396.25,
405.07,412.70,421.54,429.41,438.44,446.28,455.37,463.11, 59.43, 56.16,
 54.83, 51.72, 50.44, 47.94, 46.86, 44.56, 43.72, 41.81, 42.89, 42.08,
 43.62, 41.70, 42.45, 41.77, 42.34, 41.67, 42.49, 42.15, 43.26, 43.23,
 44.57, 44.79, 46.44, 46.99, 48.99, 49.98, 52.12, 53.40, 55.94, 57.52,
 60.27, 62.11, 64.96, 67.14, 70.72, 73.55, 77.50, 80.40, 84.34, 87.23,
 91.24, 94.21, 98.40,101.58,106.16,109.88,114.76,118.92,123.71,127.51,
132.64,136.95,141.88,145.30,151.10,155.43,160.72,164.74,170.26,175.02,
181.15,186.03,192.01,197.22,203.51,209.18,216.47,222.43,228.50,234.18,
240.91,246.72,253.58,260.77,266.77,273.27,280.52,287.16,294.50,300.81,
308.24,314.75,322.21,328.71,336.52,343.25,351.10,358.07,365.99,372.99,
381.04,388.23,396.75,404.39,412.96,420.77,429.41,437.38,445.97,453.73,
462.59,470.48, 62.34, 59.13, 57.80, 54.87, 53.77, 51.05, 50.10, 47.88,
 48.81, 47.42, 49.22, 46.91, 47.76, 46.63, 47.20, 46.13, 46.93, 46.18,
 47.25, 46.82, 48.12, 47.92, 49.55, 49.69, 51.63, 52.04, 54.24, 55.12,
 57.39, 58.52, 61.21, 62.59, 65.61, 67.32, 70.89, 73.35, 77.24, 79.65,
 83.75, 86.25, 90.25, 92.85, 96.99, 99.82,104.37,107.78,112.65,116.26,
121.41,124.85,129.74,134.02,138.96,142.19,147.82,151.82,157.10,160.93,
166.43,170.87,176.93,181.49,187.47,192.36,198.65,203.99,211.33,216.91,
224.15,229.88,236.41,241.71,248.53,254.05,261.06,266.77,273.98,279.85,
287.15,293.15,300.55,306.72,314.25,320.56,328.13,334.68,342.54,349.22,
357.15,363.84,371.88,378.78,387.30,394.61,403.17,410.67,419.30,426.83,
435.49,442.94,451.83,459.44,468.46,476.48, 67.33, 64.39, 62.90, 60.21,
 59.00, 56.63, 57.27, 55.55, 57.01, 54.97, 54.92, 53.54, 53.82, 52.70,
 53.13, 52.36, 53.04, 52.53, 53.45, 53.19, 54.45, 54.49, 55.89, 56.39,
 58.19, 58.80, 60.83, 61.91, 64.21, 65.54, 68.15, 69.82, 73.02, 75.19,
 79.00, 81.38, 85.15, 87.64, 91.29, 93.88, 97.68,100.49,104.70,108.08,
112.67,116.21,121.17,124.63,129.20,133.41,138.23,141.51,146.74,150.70,
155.71,159.60,164.78,169.23,175.04,179.59,185.27,190.20,196.21,201.56,
208.40,213.93,220.76,226.05,232.40,237.69,244.19,249.70,256.40,262.09,
268.96,274.81,281.74,287.79,294.79,300.89,308.11,314.45,321.69,328.22,
335.75,342.67,350.36,357.02,364.75,371.65,379.69,386.97,395.38,402.82,
411.21,418.72,427.02,434.47,443.11,450.73,459.46,467.46,476.41,484.61,
 70.47, 67.36, 66.11, 63.38, 63.87, 61.92, 63.26, 60.91, 60.87, 59.17,
 59.38, 57.92, 58.39, 57.21, 57.85, 56.97, 57.84, 57.20, 58.42, 58.05,
 59.39, 59.44, 61.01, 61.37, 63.37, 64.04, 66.26, 67.21, 69.74, 70.89,
 74.18, 76.00, 79.76, 81.77, 85.30, 87.59, 91.21, 93.42, 97.19, 99.61,
103.76,106.84,111.44,114.69,119.66,122.72,127.37,131.25,136.03,139.16,
144.20,147.82,152.84,156.51,161.68,165.79,171.53,175.78,181.46,186.07,
192.09,197.13,204.00,209.20,215.92,221.02,227.35,232.32,238.81,244.01,
250.67,256.04,262.88,268.42,275.40,281.01,288.05,293.80,300.96,306.98,
314.31,320.57,328.03,334.51,342.26,348.90,356.53,363.22,371.24,378.23,
386.60,393.73,402.07,409.30,417.51,424.93,433.28,440.55,449.26,457.04,
465.91,473.83,482.94,494.22,502.69, 75.58, 72.85, 72.93, 70.75, 71.80,
 69.02, 68.60, 66.88, 66.72, 65.29, 65.34, 64.13, 64.42, 63.44, 63.96,
 63.22, 64.05, 63.58, 64.67, 64.69, 65.82, 66.13, 67.73, 68.34, 70.18,
 71.03, 73.01, 74.28, 77.23, 79.00, 82.39, 84.39, 87.54, 89.68, 93.09,
 95.28, 98.66,101.06,104.91,107.91,112.21,115.42,120.20,123.25,127.59,
131.33,135.81,139.39,143.86,147.48,152.15,156.15,160.79,164.89,170.29,
174.61,179.98,184.65,190.31,195.33,201.66,206.90,213.50,218.22,224.24,
229.20,235.38,240.54,246.88,252.24,258.76,264.27,270.85,276.51,283.17,
288.95,295.76,301.76,308.79,315.04,322.34,328.80,336.31,342.88,350.30,
357.02,364.70,371.68,379.62,386.59,394.77,401.95,409.89,417.33,425.41,
432.67,441.07,448.81,457.44,465.34,474.14,482.19,493.92,500.95,509.65,
 80.20, 80.22, 77.89, 78.71, 75.75, 75.28, 73.20, 72.97, 71.18, 71.31,
 69.72, 70.01, 68.64, 69.14, 68.10, 68.88, 68.05, 69.08, 68.69, 69.77,
 69.69, 71.23, 71.43, 73.22, 73.66, 75.56, 76.43, 79.34, 80.71, 83.79,
 85.66, 88.77, 90.51, 93.69, 95.61, 98.98,101.00,104.79,107.45,111.78,
114.64,119.42,122.18,126.49,129.89,134.38,137.62,142.04,145.33,150.00,
153.69,158.42,162.19,167.52,171.52,176.88,181.29,186.94,191.63,198.01,
203.51,209.32,214.13,220.14,224.76,230.91,235.78,242.10,247.14,253.63,
258.84,265.38,270.74,277.36,282.74,289.57,295.29,302.23,308.19,315.76,
321.72,329.40,335.71,343.13,349.57,357.23,363.86,371.98,378.43,386.57,
393.38,401.60,408.41,416.44,423.40,431.78,439.24,447.82,455.43,464.22,
471.96,483.60,490.35,499.07,506.73,515.87, 87.43, 87.92, 84.91, 84.01,
 81.87, 81.26, 79.38, 79.16, 77.60, 77.55, 76.26, 76.38, 75.22, 75.62,
 74.77, 75.43, 75.00, 75.96, 75.56, 76.71, 76.83, 78.24, 78.58, 80.12,
 80.91, 83.40, 84.72, 87.36, 89.20, 91.87, 93.54, 96.34, 98.23,101.23,
103.21,106.65,109.30,113.30,116.15,120.35,123.51,127.51,130.57,135.12,
138.15,142.44,145.71,150.07,153.74,158.26,162.01,167.06,171.05,176.13,
180.53,185.86,190.50,197.20,201.38,207.42,212.22,217.92,222.51,228.35,
233.19,239.21,244.23,250.41,255.61,261.85,267.12,273.45,278.83,285.33,
291.00,297.75,303.72,310.98,317.03,324.22,330.56,337.89,344.31,351.66,
358.43,365.89,372.47,380.20,387.00,394.60,401.71,409.42,416.43,424.47,
431.85,440.17,447.75,456.29,464.03,475.54,482.30,490.73,498.43,507.28,
515.09,523.88, 93.03, 91.63, 89.12, 88.47, 86.22, 85.89, 83.98, 84.03,
 82.29, 82.43, 80.98, 81.37, 80.13, 80.76, 79.95, 80.86, 80.08, 81.21,
 80.93, 82.30, 82.20, 83.84, 84.05, 86.55, 87.42, 90.03, 91.44, 94.05,
 95.32, 98.17, 99.52,102.45,104.04,107.45,109.74,113.74,116.21,120.35,
123.20,127.18,129.92,134.41,137.14,141.39,144.33,148.66,152.01,156.66,
160.09,165.02,168.69,173.81,177.83,183.22,187.62,193.55,198.16,204.22,
210.66,214.69,218.98,224.81,229.32,235.32,240.05,246.22,251.08,257.29,
262.26,268.56,273.64,280.11,285.50,292.28,297.95,305.18,311.22,318.43,
324.49,331.83,337.97,345.36,351.55,358.99,365.25,372.93,379.38,386.99,
393.47,401.44,407.85,416.10,423.04,431.38,438.70,447.15,454.59,465.94,
472.46,480.94,488.31,497.20,504.80,513.56,521.31,530.11,537.99, 98.57,
 97.54, 95.24, 94.54, 92.55, 92.13, 90.48, 90.33, 88.87, 88.86, 87.62,
 87.89, 87.01, 87.55, 86.74, 87.46, 87.09, 88.09, 87.89, 89.15, 89.30,
 91.42, 92.20, 94.42, 95.71, 97.96, 99.16,101.64,102.91,105.51,107.04,
110.05,112.32,115.99,118.50,122.39,125.24,128.86,131.54,135.62,138.38,
142.50,145.43,149.45,152.79,157.22,160.62,165.25,168.92,173.73,177.76,
182.84,187.13,192.73,197.31,204.67,209.63,213.35,217.60,223.11,227.62,
233.33,238.05,243.85,248.69,254.66,259.50,265.55,270.53,276.71,282.00,
288.49,294.23,301.14,307.03,314.00,319.99,327.11,333.16,340.36,346.62,
353.82,360.04,367.42,373.82,381.12,387.58,394.99,401.68,409.41,416.54,
424.53,431.85,440.01,447.45,458.62,465.16,473.35,480.74,489.33,496.95,
505.50,513.13,521.70,529.59,102.93,102.09, 99.85, 99.41, 97.47, 97.32,
 95.46, 95.45, 93.83, 94.09, 92.81, 93.31, 92.12, 92.81, 92.05, 92.96,
 92.39, 93.46, 93.38, 95.37, 95.80, 97.95, 98.81,100.98,101.79,104.07,
105.07,107.59,108.68,111.71,113.62,117.26,119.45,123.33,125.86,129.44,
131.81,135.98,138.33,142.21,144.78,148.81,151.81,156.35,159.41,163.96,
167.40,172.14,175.80,180.88,184.93,190.59,195.49,202.05,205.13,211.01,
214.92,220.41,224.61,230.30,234.65,240.49,245.01,250.86,255.49,261.48,
266.14,272.34,277.33,283.85,289.29,296.06,301.66,308.62,314.35,321.37,
327.18,334.30,340.26,347.39,353.53,360.74,366.96,374.25,380.42,387.81,
394.19,401.91,408.72,416.74,423.76,431.92,438.98,449.82,456.05,464.27,
471.41,480.01,487.40,495.91,503.40,511.99,109.27,108.41,106.45,105.95,
104.08,103.70,102.06,101.91,100.60,100.72, 99.50, 99.80, 98.94, 99.54,
 98.83, 99.55, 99.40,100.97,101.34,103.07,103.85,105.66,106.41,108.33,
109.16,111.42,112.42,115.12,117.04,120.32,122.53,126.05,128.68,131.94,
134.26,137.95,140.46,144.03,146.57,150.27,153.26,157.62,160.68,164.88,
168.17,172.80,176.46,181.21,185.23,191.28,195.51,200.21,204.69,210.48,
214.37,219.55,223.72,229.08,233.43,238.94,243.41,248.97,253.53,259.25,
263.91,269.77,274.82,281.07,286.38,292.85,298.47,305.10,310.76,317.45,
323.20,329.93,335.91,342.77,348.71,355.71,361.77,368.89,375.30,382.42,
388.77,396.20,402.98,410.77,417.67,425.54,432.66,443.15,449.46,457.40,
464.56,472.89,480.30,488.52,496.02,113.98,113.66,111.44,111.01,109.02,
108.87,107.16,107.26,105.64,105.89,104.66,105.12,104.00,104.79,104.27,
105.67,105.73,107.43,107.83,109.57,109.94,111.78,112.24,114.35,115.09,
117.74,119.26,122.54,124.43,127.95,130.19,133.43,135.48,139.30,141.24,
144.62,146.79,150.42,153.10,157.46,160.10,164.27,167.38,171.80,175.16,
179.89,183.68,189.66,193.13,198.59,202.81,208.30,212.56,217.78,221.59,
226.94,230.98,236.45,240.59,246.15,250.39,256.05,260.40,266.30,270.96,
277.22,282.21,288.70,293.96,300.55,305.91,312.52,317.94,324.67,330.17,
337.08,342.90,350.05,355.94,363.31,368.97,376.01,382.21,389.64,396.26,
403.86,410.53,418.39,427.96,435.12,441.05,449.06,455.95,464.21,471.51,
479.82,120.61,120.06,118.01,117.50,115.61,115.32,113.79,113.69,112.34,
112.51,111.38,111.77,111.13,112.24,112.15,113.45,113.68,115.14,115.43,
116.90,117.30,119.04,119.71,122.03,123.50,126.43,128.30,131.45,133.76,
136.68,138.63,142.20,144.12,147.17,149.34,152.63,155.31,159.15,162.04,
165.85,168.97,173.06,176.39,180.82,184.59,189.79,193.76,198.93,203.15,
208.35,212.92,217.76,221.58,226.61,230.66,235.80,239.94,245.18,249.38,
254.75,259.11,264.67,269.34,275.31,280.29,286.45,291.70,297.95,303.27,
309.56,314.95,321.30,326.84,333.45,339.30,346.24,352.13,359.21,365.16,
371.71,377.88,384.99,391.53,398.87,405.46,412.99,422.26,429.14,435.05,
442.80,449.71,457.71,465.09,125.82,125.31,123.16,122.85,120.83,120.71,
119.03,119.17,117.67,118.05,117.07,118.05,117.57,118.80,118.73,120.02,
119.94,121.34,121.36,123.05,123.36,125.60,126.72,129.59,131.15,134.36,
136.18,139.12,141.14,143.95,145.47,148.47,150.34,153.61,155.90,159.68,
162.27,165.99,168.74,172.79,175.89,180.32,183.79,189.20,192.91,198.18,
202.13,207.41,212.97,216.76,220.32,225.36,229.04,234.18,238.01,243.25,
247.17,252.53,256.61,262.17,266.55,272.51,277.20,283.35,288.30,294.54,
299.56,305.83,310.90,317.26,322.51,329.09,334.68,341.61,347.46,354.32,
360.05,366.55,375.46,382.71,388.52,395.62,399.43,409.43,414.97,421.83,
427.46,435.21,441.88,449.89,132.66,131.99,130.05,129.61,127.75,127.55,
126.01,126.04,125.02,125.82,125.23,126.03,125.72,126.65,126.59,127.60,
127.48,128.85,129.03,130.89,131.96,134.51,135.99,138.78,140.57,143.25,
145.12,147.55,149.14,151.85,153.63,156.60,158.94,162.42,164.85,168.18,
170.95,174.68,177.76,181.88,185.34,190.49,194.19,199.24,203.21,209.47,
212.27,217.33,221.10,225.84,229.52,234.36,238.20,243.17,247.08,252.15,
256.28,261.45,265.95,271.61,276.30,282.13,287.05,292.97,297.97,303.91,
308.97,315.03,320.27,326.59,332.19,338.82,344.47,351.04,356.80,365.92,
371.83,378.82,384.62,391.48,397.42,404.44,409.92,416.50,422.11,429.60,
436.29,137.92,137.46,135.36,135.08,133.30,133.34,131.99,132.57,131.59,
132.37,131.78,132.64,132.10,133.08,132.68,133.94,133.82,135.57,136.29,
138.76,139.87,142.71,143.98,146.47,147.65,150.09,151.32,153.99,155.46,
158.40,160.37,163.87,165.68,169.05,171.49,175.21,177.99,182.11,185.26,
190.54,193.85,199.17,203.07,208.04,212.49,216.97,220.78,225.28,228.73,
233.58,237.13,242.07,245.72,250.75,254.55,259.81,264.00,269.65,274.05,
279.89,284.52,290.46,295.14,301.11,305.89,311.95,316.93,323.24,328.55,
335.18,340.47,347.14,354.30,361.18,366.73,373.40,378.91,385.79,391.61,
398.29,403.39,409.96,415.28,422.79,144.95,144.39,142.55,142.23,140.87,
141.11,140.11,140.51,139.80,140.34,139.77,140.42,140.02,140.93,140.79,
142.14,142.77,144.84,145.89,148.32,149.34,151.34,152.36,154.46,155.64,
158.00,159.44,162.05,163.94,167.06,168.78,171.87,174.30,177.73,180.49,
184.34,187.46,192.39,195.71,201.00,204.52,209.95,213.30,218.24,222.08,
227.07,229.97,234.55,238.09,242.72,246.37,251.16,254.95,259.95,264.15,
269.52,273.91,279.46,284.12,289.77,294.50,300.23,305.01,310.83,315.77,
321.85,327.30,333.51,338.76,345.42,351.19,357.80,363.33,369.90,375.39,
382.11,387.61,394.09,399.02,405.30,410.60,150.53,150.23,148.55,148.72,
147.39,147.76,146.70,147.22,146.30,146.90,146.13,147.01,146.50,147.86,
148.09,150.08,151.01,153.00,153.42,155.27,155.82,157.91,158.77,161.11,
162.23,164.82,166.23,169.03,170.44,173.53,175.61,178.99,181.44,185.29,
188.11,192.96,196.03,201.26,204.60,209.84,213.37,218.49,222.07,227.19,
231.38,234.53,237.73,242.40,245.79,250.52,254.02,258.98,262.83,268.23,
272.50,278.05,282.41,288.05,292.49,298.19,302.71,308.45,313.74,319.70,
324.39,330.53,335.52,341.87,347.10,353.80,358.97,365.51,370.70,377.34,
382.32,388.68,393.27,399.54,158.26,156.83,156.80,155.67,155.83,154.84,
155.11,154.30,154.82,154.34,155.25,155.37,157.12,157.82,158.73,159.01,
160.52,161.12,162.91,163.76,165.79,166.89,169.18,170.32,172.92,174.27,
177.07,179.20,182.33,184.81,188.35,191.16,195.88,198.75,203.72,206.99,
211.92,215.44,220.33,223.92,229.20,232.45,236.01,239.48,243.87,247.22,
251.68,255.20,259.91,263.66,268.85,273.01,278.44,282.81,288.17,292.61,
298.06,302.59,308.02,313.26,318.96,323.52,329.29,334.18,340.34,345.44,
351.69,356.82,362.93,368.06,374.19,379.17,385.19,389.80,164.74,163.23,
163.38,162.06,162.34,161.21,161.78,160.89,161.76,161.57,162.33,162.12,
163.44,163.44,165.00,165.28,167.04,167.64,169.64,170.36,172.40,173.15,
175.69,176.91,179.70,181.48,184.59,186.72,190.28,192.78,197.50,200.05,
205.02,207.96,213.00,216.10,221.21,224.40,229.58,232.84,238.09,241.42,
244.12,247.23,251.75,254.94,259.65,263.15,268.25,272.23,277.55,281.80,
287.18,291.37,296.83,301.08,306.47,311.26,316.94,321.21,326.98,331.71,
337.79,342.54,348.76,353.48,359.62,364.23,370.21,374.66,380.64,172.65,
171.29,171.28,170.11,170.29,169.37,169.91,169.04,169.68,169.37,170.34,
170.32,171.49,171.75,173.19,173.79,175.46,176.21,178.13,178.97,181.14,
182.22,184.58,186.34,189.18,191.36,194.61,197.10,201.50,204.03,208.67,
211.60,216.31,219.40,224.19,227.37,232.12,235.43,238.65,241.95,246.13,
249.27,253.55,256.79,261.19,264.69,269.52,273.47,278.54,282.79,287.91,
292.28,297.33,301.61,306.92,311.19,316.70,321.03,326.64,331.11,336.88,
341.62,347.42,352.11,357.95,362.53,368.15,372.79,179.26,177.77,177.93,
176.67,177.20,175.74,176.35,175.65,176.56,176.15,177.32,177.28,178.72,
179.02,180.73,181.18,183.18,183.61,185.76,186.55,188.96,190.44,193.29,
195.13,198.37,200.55,204.72,207.15,211.76,214.39,219.06,221.84,226.54,
229.54,234.11,237.23,240.27,243.07,247.46,249.95,254.19,257.19,261.61,
264.80,269.62,273.28,278.42,282.30,287.54,291.48,296.56,300.58,305.84,
310.10,315.50,319.61,325.14,329.51,335.30,339.56,345.30,349.71,355.51,
359.95,365.40,187.18,185.55,186.17,184.42,184.65,183.96,184.51,184.08,
184.94,184.83,185.93,186.15,187.51,187.94,189.59,190.31,192.23,192.98,
194.93,196.39,198.94,200.79,203.74,205.91,209.77,212.17,216.45,219.08,
223.47,226.21,230.52,231.88,237.98,240.88,243.45,246.51,250.86,252.64,
256.67,259.64,263.83,266.95,271.55,275.22,280.07,283.96,288.92,292.89,
297.74,301.80,306.80,310.94,316.09,320.23,325.46,329.77,335.09,339.35,
344.80,349.21,354.69,359.12,194.15,192.01,192.33,191.26,191.84,191.12,
191.86,191.45,192.50,192.51,193.70,193.81,195.43,195.88,197.79,198.32,
200.29,201.48,204.02,205.58,208.54,210.40,214.43,216.31,220.59,222.88,
227.14,229.66,233.86,236.66,240.60,243.15,241.27,243.77,247.65,253.91,
258.05,260.74,264.90,267.87,272.33,275.71,280.56,284.18,289.12,292.81,
297.79,301.59,305.24,309.00,314.23,319.58,324.84,328.92,334.20,338.17,
343.60,347.69,353.15,201.62,200.64,200.81,199.83,200.32,200.05,200.73,
200.46,201.52,201.46,202.74,203.25,205.09,205.48,207.16,208.20,210.50,
212.08,214.74,216.59,220.31,222.18,226.16,228.41,232.31,234.82,238.65,
241.12,245.06,247.56,245.07,247.43,251.02,257.08,261.12,263.81,267.77,
270.77,274.97,278.36,282.97,286.58,291.22,294.94,299.61,303.39,306.40,
310.25,315.21,321.18,326.09,330.08,335.04,338.96,344.06,348.14,208.74,
207.61,208.15,207.32,208.20,207.76,208.61,208.23,209.48,209.92,211.39,
211.66,213.32,214.14,216.38,217.62,220.29,221.83,225.44,227.09,231.00,
233.04,236.74,238.94,242.67,244.76,248.54,250.67,247.69,249.74,253.31,
255.71,263.23,265.72,269.58,272.28,276.47,279.61,284.17,287.48,292.12,
295.53,300.23,303.83,308.60,312.25,315.22,321.24,326.47,330.02,335.09,
338.73,343.82,217.46,216.59,217.07,216.61,217.31,217.09,218.04,218.24,
219.51,219.69,221.01,221.76,223.76,225.00,227.37,228.90,232.47,233.90,
237.40,239.36,242.61,244.73,248.04,250.07,253.48,255.58,252.06,254.25,
257.40,259.80,266.97,269.51,273.17,275.77,279.80,282.89,287.25,290.50,
294.89,298.52,302.73,306.21,310.79,314.42,317.18,323.36,328.12,332.07,
336.78,340.59,224.38,225.13,224.69,225.84,225.57,226.90,226.33,227.71,
228.13,230.45,231.38,233.74,234.97,238.29,239.70,242.92,244.62,247.68,
249.40,252.64,254.30,257.61,259.37,255.40,257.14,260.41,262.52,265.98,
272.03,275.68,277.98,281.98,284.78,289.11,292.11,296.46,299.59,304.03,
307.22,311.78,315.15,320.04,324.05,328.83,332.33,337.36,234.01,235.01,
234.65,235.62,234.93,235.87,235.79,238.76,239.66,241.72,242.97,245.96,
247.31,250.04,251.60,254.25,255.90,258.77,260.38,263.36,265.08,260.46,
262.33,265.18,267.26,270.44,276.47,279.96,282.23,285.93,288.73,292.77,
295.75,299.85,302.97,307.19,310.38,314.67,318.00,322.62,326.67,331.28,
334.76,242.74,243.53,241.88,242.78,242.39,243.57,246.88,248.93,249.94,
252.65,253.72,256.22,257.42,259.99,261.29,264.09,265.34,261.91,261.74,
264.49,265.93,268.87,270.65,273.80,275.80,283.21,285.28,288.88,291.40,
295.40,298.09,302.13,304.98,309.17,312.07,316.35,319.38,324.00,326.86,
332.59,250.56,251.22,250.73,255.51,256.12,257.95,258.95,261.21,262.37,
264.23,265.28,267.49,268.73,271.11,272.40,267.90,267.79,270.26,271.78,
274.30,276.06,278.92,280.90,288.19,286.41,293.54,296.05,299.76,302.36,
306.20,308.94,312.95,315.87,319.89,322.90,327.21,330.26,257.99,258.83,
264.13,265.90,266.31,268.43,268.89,271.04,271.83,273.97,274.88,277.17,
278.17,272.96,274.40,274.99,276.08,278.67,280.11,282.94,284.63,292.15,
293.92,297.23,299.42,303.11,305.47,309.23,311.83,315.64,318.26,322.26,
325.00,329.34,275.64,275.96,277.61,277.98,279.79,280.39,282.32,283.17,
276.14,277.25,279.70,281.12,281.46,282.50,284.81,286.24,288.80,290.46,
293.35,295.36,302.60,304.77,308.17,310.52,314.02,316.46,320.05,322.65,
326.43,329.15,285.38,285.56,287.19,287.61,289.35,289.89,282.37,283.24,
285.61,286.75,289.49,287.60,289.89,290.99,293.48,294.86,297.73,299.45,
307.10,308.94,312.25,314.35,317.76,319.98,323.59,325.92,329.49,296.53,
296.78,288.14,288.56,290.39,291.23,293.26,294.35,296.77,294.70,296.68,
297.77,299.97,301.32,303.90,305.61,313.17,315.00,318.02,320.10,323.31,
325.60,329.08,330.86,305.95,306.12,297.60,298.05,300.12,300.84,299.98,
300.52,302.47,303.27,305.46,306.52,314.46,310.49,318.26,319.80,322.84,
324.61,327.63,329.54,333.08,306.67,308.50,309.25,307.78,308.31,309.96,
310.72,312.63,313.65,315.93,317.31,325.03,326.64,329.30,330.62,333.57,
335.52,316.48,314.59,314.83,316.45,316.93,318.81,319.54,327.64,328.48,
330.77,332.12,334.81,336.27,338.59,323.27,324.61,325.06,326.65,332.80,
335.40,336.34,338.20,339.41,341.93,342.57,337.21,339.08,339.57,342.19,
342.65,344.65,345.52,347.87,350.58,351.04,352.67,353.55,359.66
};

//+------------------------------------------------------------+
//| Table of Z (number of protons) and A (number of nucleons)  |
//|        indexArray[0][ ] --> Z                              |
//|        indexArray[1][ ] --> A                              |
//+------------------------------------------------------------+
G4int G4NucleiPropertiesTheoreticalTable::indexArray[2][G4NucleiPropertiesTheoreticalTable::nEntries] = {
  // ---------- Z ----------
  {
  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
  8,  8,  8,  8,  8,  8,  8,  8,  8,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9, 10, 10, 10, 10, 10, 10, 10, 10, 10,
 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
 10, 10, 10, 10, 10, 11, 11, 11, 11, 11,
 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,
 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,
 11, 12, 12, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12, 12, 12, 13,
 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15, 15, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 18, 18, 18, 18, 18, 18,
 18, 18, 18, 18, 18, 18, 18, 18, 18, 18,
 18, 18, 18, 18, 18, 18, 18, 18, 18, 18,
 18, 18, 18, 18, 18, 18, 18, 18, 18, 18,
 18, 18, 18, 18, 18, 19, 19, 19, 19, 19,
 19, 19, 19, 19, 19, 19, 19, 19, 19, 19,
 19, 19, 19, 19, 19, 19, 19, 19, 19, 19,
 19, 19, 19, 19, 19, 19, 19, 19, 19, 19,
 19, 19, 19, 19, 19, 19, 19, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 22, 22, 22, 22,
 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
 22, 22, 22, 23, 23, 23, 23, 23, 23, 23,
 23, 23, 23, 23, 23, 23, 23, 23, 23, 23,
 23, 23, 23, 23, 23, 23, 23, 23, 23, 23,
 23, 23, 23, 23, 23, 23, 23, 23, 23, 23,
 23, 23, 23, 23, 23, 23, 23, 23, 23, 23,
 23, 24, 24, 24, 24, 24, 24, 24, 24, 24,
 24, 24, 24, 24, 24, 24, 24, 24, 24, 24,
 24, 24, 24, 24, 24, 24, 24, 24, 24, 24,
 24, 24, 24, 24, 24, 24, 24, 24, 24, 24,
 24, 24, 24, 24, 24, 24, 24, 24, 24, 24,
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
 26, 27, 27, 27, 27, 27, 27, 27, 27, 27,
 27, 27, 27, 27, 27, 27, 27, 27, 27, 27,
 27, 27, 27, 27, 27, 27, 27, 27, 27, 27,
 27, 27, 27, 27, 27, 27, 27, 27, 27, 27,
 27, 27, 27, 27, 27, 27, 27, 27, 27, 27,
 27, 27, 27, 27, 28, 28, 28, 28, 28, 28,
 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
 28, 28, 28, 28, 28, 28, 28, 28, 29, 29,
 29, 29, 29, 29, 29, 29, 29, 29, 29, 29,
 29, 29, 29, 29, 29, 29, 29, 29, 29, 29,
 29, 29, 29, 29, 29, 29, 29, 29, 29, 29,
 29, 29, 29, 29, 29, 29, 29, 29, 29, 29,
 29, 29, 29, 29, 29, 29, 29, 29, 29, 29,
 29, 29, 29, 30, 30, 30, 30, 30, 30, 30,
 30, 30, 30, 30, 30, 30, 30, 30, 30, 30,
 30, 30, 30, 30, 30, 30, 30, 30, 30, 30,
 30, 30, 30, 30, 30, 30, 30, 30, 30, 30,
 30, 30, 30, 30, 30, 30, 30, 30, 30, 30,
 30, 30, 30, 30, 30, 30, 30, 30, 31, 31,
 31, 31, 31, 31, 31, 31, 31, 31, 31, 31,
 31, 31, 31, 31, 31, 31, 31, 31, 31, 31,
 31, 31, 31, 31, 31, 31, 31, 31, 31, 31,
 31, 31, 31, 31, 31, 31, 31, 31, 31, 31,
 31, 31, 31, 31, 31, 31, 31, 31, 31, 31,
 31, 31, 31, 31, 32, 32, 32, 32, 32, 32,
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
 32, 32, 33, 33, 33, 33, 33, 33, 33, 33,
 33, 33, 33, 33, 33, 33, 33, 33, 33, 33,
 33, 33, 33, 33, 33, 33, 33, 33, 33, 33,
 33, 33, 33, 33, 33, 33, 33, 33, 33, 33,
 33, 33, 33, 33, 33, 33, 33, 33, 33, 33,
 33, 33, 33, 33, 33, 33, 33, 33, 33, 33,
 33, 34, 34, 34, 34, 34, 34, 34, 34, 34,
 34, 34, 34, 34, 34, 34, 34, 34, 34, 34,
 34, 34, 34, 34, 34, 34, 34, 34, 34, 34,
 34, 34, 34, 34, 34, 34, 34, 34, 34, 34,
 34, 34, 34, 34, 34, 34, 34, 34, 34, 34,
 34, 34, 34, 34, 34, 34, 34, 34, 34, 34,
 34, 35, 35, 35, 35, 35, 35, 35, 35, 35,
 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
 35, 35, 36, 36, 36, 36, 36, 36, 36, 36,
 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
 36, 36, 36, 36, 37, 37, 37, 37, 37, 37,
 37, 37, 37, 37, 37, 37, 37, 37, 37, 37,
 37, 37, 37, 37, 37, 37, 37, 37, 37, 37,
 37, 37, 37, 37, 37, 37, 37, 37, 37, 37,
 37, 37, 37, 37, 37, 37, 37, 37, 37, 37,
 37, 37, 37, 37, 37, 37, 37, 37, 37, 37,
 37, 37, 37, 37, 37, 37, 37, 38, 38, 38,
 38, 38, 38, 38, 38, 38, 38, 38, 38, 38,
 38, 38, 38, 38, 38, 38, 38, 38, 38, 38,
 38, 38, 38, 38, 38, 38, 38, 38, 38, 38,
 38, 38, 38, 38, 38, 38, 38, 38, 38, 38,
 38, 38, 38, 38, 38, 38, 38, 38, 38, 38,
 38, 38, 38, 38, 38, 38, 38, 38, 38, 38,
 38, 39, 39, 39, 39, 39, 39, 39, 39, 39,
 39, 39, 39, 39, 39, 39, 39, 39, 39, 39,
 39, 39, 39, 39, 39, 39, 39, 39, 39, 39,
 39, 39, 39, 39, 39, 39, 39, 39, 39, 39,
 39, 39, 39, 39, 39, 39, 39, 39, 39, 39,
 39, 39, 39, 39, 39, 39, 39, 39, 39, 39,
 39, 39, 39, 39, 39, 39, 40, 40, 40, 40,
 40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
 40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
 40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
 40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
 40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
 40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
 40, 40, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 42,
 42, 42, 42, 42, 42, 42, 42, 42, 42, 42,
 42, 42, 42, 42, 42, 42, 42, 42, 42, 42,
 42, 42, 42, 42, 42, 42, 42, 42, 42, 42,
 42, 42, 42, 42, 42, 42, 42, 42, 42, 42,
 42, 42, 42, 42, 42, 42, 42, 42, 42, 42,
 42, 42, 42, 42, 42, 42, 42, 42, 42, 42,
 42, 42, 42, 42, 42, 42, 42, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 44, 44, 44, 44,
 44, 44, 44, 44, 44, 44, 44, 44, 44, 44,
 44, 44, 44, 44, 44, 44, 44, 44, 44, 44,
 44, 44, 44, 44, 44, 44, 44, 44, 44, 44,
 44, 44, 44, 44, 44, 44, 44, 44, 44, 44,
 44, 44, 44, 44, 44, 44, 44, 44, 44, 44,
 44, 44, 44, 44, 44, 44, 44, 44, 44, 44,
 44, 44, 44, 44, 44, 44, 45, 45, 45, 45,
 45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
 45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
 45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
 45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
 45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
 45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
 45, 45, 45, 45, 45, 45, 45, 46, 46, 46,
 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,
 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,
 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,
 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,
 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,
 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,
 46, 46, 46, 46, 46, 46, 46, 46, 47, 47,
 47, 47, 47, 47, 47, 47, 47, 47, 47, 47,
 47, 47, 47, 47, 47, 47, 47, 47, 47, 47,
 47, 47, 47, 47, 47, 47, 47, 47, 47, 47,
 47, 47, 47, 47, 47, 47, 47, 47, 47, 47,
 47, 47, 47, 47, 47, 47, 47, 47, 47, 47,
 47, 47, 47, 47, 47, 47, 47, 47, 47, 47,
 47, 47, 47, 47, 47, 47, 47, 47, 47, 47,
 47, 48, 48, 48, 48, 48, 48, 48, 48, 48,
 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
 48, 48, 48, 48, 48, 49, 49, 49, 49, 49,
 49, 49, 49, 49, 49, 49, 49, 49, 49, 49,
 49, 49, 49, 49, 49, 49, 49, 49, 49, 49,
 49, 49, 49, 49, 49, 49, 49, 49, 49, 49,
 49, 49, 49, 49, 49, 49, 49, 49, 49, 49,
 49, 49, 49, 49, 49, 49, 49, 49, 49, 49,
 49, 49, 49, 49, 49, 49, 49, 49, 49, 49,
 49, 49, 49, 49, 49, 49, 49, 49, 49, 49,
 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
 50, 50, 50, 50, 50, 50, 51, 51, 51, 51,
 51, 51, 51, 51, 51, 51, 51, 51, 51, 51,
 51, 51, 51, 51, 51, 51, 51, 51, 51, 51,
 51, 51, 51, 51, 51, 51, 51, 51, 51, 51,
 51, 51, 51, 51, 51, 51, 51, 51, 51, 51,
 51, 51, 51, 51, 51, 51, 51, 51, 51, 51,
 51, 51, 51, 51, 51, 51, 51, 51, 51, 51,
 51, 51, 51, 51, 51, 51, 51, 51, 51, 51,
 51, 51, 52, 52, 52, 52, 52, 52, 52, 52,
 52, 52, 52, 52, 52, 52, 52, 52, 52, 52,
 52, 52, 52, 52, 52, 52, 52, 52, 52, 52,
 52, 52, 52, 52, 52, 52, 52, 52, 52, 52,
 52, 52, 52, 52, 52, 52, 52, 52, 52, 52,
 52, 52, 52, 52, 52, 52, 52, 52, 52, 52,
 52, 52, 52, 52, 52, 52, 52, 52, 52, 52,
 52, 52, 52, 52, 52, 52, 52, 52, 52, 52,
 53, 53, 53, 53, 53, 53, 53, 53, 53, 53,
 53, 53, 53, 53, 53, 53, 53, 53, 53, 53,
 53, 53, 53, 53, 53, 53, 53, 53, 53, 53,
 53, 53, 53, 53, 53, 53, 53, 53, 53, 53,
 53, 53, 53, 53, 53, 53, 53, 53, 53, 53,
 53, 53, 53, 53, 53, 53, 53, 53, 53, 53,
 53, 53, 53, 53, 53, 53, 53, 53, 53, 53,
 53, 53, 53, 53, 53, 53, 53, 53, 53, 54,
 54, 54, 54, 54, 54, 54, 54, 54, 54, 54,
 54, 54, 54, 54, 54, 54, 54, 54, 54, 54,
 54, 54, 54, 54, 54, 54, 54, 54, 54, 54,
 54, 54, 54, 54, 54, 54, 54, 54, 54, 54,
 54, 54, 54, 54, 54, 54, 54, 54, 54, 54,
 54, 54, 54, 54, 54, 54, 54, 54, 54, 54,
 54, 54, 54, 54, 54, 54, 54, 54, 54, 54,
 54, 54, 54, 54, 54, 54, 54, 54, 54, 55,
 55, 55, 55, 55, 55, 55, 55, 55, 55, 55,
 55, 55, 55, 55, 55, 55, 55, 55, 55, 55,
 55, 55, 55, 55, 55, 55, 55, 55, 55, 55,
 55, 55, 55, 55, 55, 55, 55, 55, 55, 55,
 55, 55, 55, 55, 55, 55, 55, 55, 55, 55,
 55, 55, 55, 55, 55, 55, 55, 55, 55, 55,
 55, 55, 55, 55, 55, 55, 55, 55, 55, 55,
 55, 55, 55, 55, 55, 55, 55, 55, 55, 56,
 56, 56, 56, 56, 56, 56, 56, 56, 56, 56,
 56, 56, 56, 56, 56, 56, 56, 56, 56, 56,
 56, 56, 56, 56, 56, 56, 56, 56, 56, 56,
 56, 56, 56, 56, 56, 56, 56, 56, 56, 56,
 56, 56, 56, 56, 56, 56, 56, 56, 56, 56,
 56, 56, 56, 56, 56, 56, 56, 56, 56, 56,
 56, 56, 56, 56, 56, 56, 56, 56, 56, 56,
 56, 56, 56, 56, 56, 56, 56, 56, 56, 56,
 56, 57, 57, 57, 57, 57, 57, 57, 57, 57,
 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
 57, 57, 57, 57, 58, 58, 58, 58, 58, 58,
 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
 58, 58, 58, 58, 58, 58, 58, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 60, 60, 60, 60, 60, 60, 60, 60, 60,
 60, 60, 60, 60, 60, 60, 60, 60, 60, 60,
 60, 60, 60, 60, 60, 60, 60, 60, 60, 60,
 60, 60, 60, 60, 60, 60, 60, 60, 60, 60,
 60, 60, 60, 60, 60, 60, 60, 60, 60, 60,
 60, 60, 60, 60, 60, 60, 60, 60, 60, 60,
 60, 60, 60, 60, 60, 60, 60, 60, 60, 60,
 60, 60, 60, 60, 60, 60, 60, 60, 60, 60,
 60, 60, 60, 60, 60, 61, 61, 61, 61, 61,
 61, 61, 61, 61, 61, 61, 61, 61, 61, 61,
 61, 61, 61, 61, 61, 61, 61, 61, 61, 61,
 61, 61, 61, 61, 61, 61, 61, 61, 61, 61,
 61, 61, 61, 61, 61, 61, 61, 61, 61, 61,
 61, 61, 61, 61, 61, 61, 61, 61, 61, 61,
 61, 61, 61, 61, 61, 61, 61, 61, 61, 61,
 61, 61, 61, 61, 61, 61, 61, 61, 61, 61,
 61, 61, 61, 61, 61, 61, 61, 61, 61, 61,
 61, 62, 62, 62, 62, 62, 62, 62, 62, 62,
 62, 62, 62, 62, 62, 62, 62, 62, 62, 62,
 62, 62, 62, 62, 62, 62, 62, 62, 62, 62,
 62, 62, 62, 62, 62, 62, 62, 62, 62, 62,
 62, 62, 62, 62, 62, 62, 62, 62, 62, 62,
 62, 62, 62, 62, 62, 62, 62, 62, 62, 62,
 62, 62, 62, 62, 62, 62, 62, 62, 62, 62,
 62, 62, 62, 62, 62, 62, 62, 62, 62, 62,
 62, 62, 62, 62, 62, 62, 62, 63, 63, 63,
 63, 63, 63, 63, 63, 63, 63, 63, 63, 63,
 63, 63, 63, 63, 63, 63, 63, 63, 63, 63,
 63, 63, 63, 63, 63, 63, 63, 63, 63, 63,
 63, 63, 63, 63, 63, 63, 63, 63, 63, 63,
 63, 63, 63, 63, 63, 63, 63, 63, 63, 63,
 63, 63, 63, 63, 63, 63, 63, 63, 63, 63,
 63, 63, 63, 63, 63, 63, 63, 63, 63, 63,
 63, 63, 63, 63, 63, 63, 63, 63, 63, 63,
 63, 63, 63, 63, 64, 64, 64, 64, 64, 64,
 64, 64, 64, 64, 64, 64, 64, 64, 64, 64,
 64, 64, 64, 64, 64, 64, 64, 64, 64, 64,
 64, 64, 64, 64, 64, 64, 64, 64, 64, 64,
 64, 64, 64, 64, 64, 64, 64, 64, 64, 64,
 64, 64, 64, 64, 64, 64, 64, 64, 64, 64,
 64, 64, 64, 64, 64, 64, 64, 64, 64, 64,
 64, 64, 64, 64, 64, 64, 64, 64, 64, 64,
 64, 64, 64, 64, 64, 64, 64, 64, 64, 64,
 64, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 66, 66, 66, 66, 66, 66, 66, 66, 66, 66,
 66, 66, 66, 66, 66, 66, 66, 66, 66, 66,
 66, 66, 66, 66, 66, 66, 66, 66, 66, 66,
 66, 66, 66, 66, 66, 66, 66, 66, 66, 66,
 66, 66, 66, 66, 66, 66, 66, 66, 66, 66,
 66, 66, 66, 66, 66, 66, 66, 66, 66, 66,
 66, 66, 66, 66, 66, 66, 66, 66, 66, 66,
 66, 66, 66, 66, 66, 66, 66, 66, 66, 66,
 66, 66, 66, 66, 66, 66, 66, 66, 66, 67,
 67, 67, 67, 67, 67, 67, 67, 67, 67, 67,
 67, 67, 67, 67, 67, 67, 67, 67, 67, 67,
 67, 67, 67, 67, 67, 67, 67, 67, 67, 67,
 67, 67, 67, 67, 67, 67, 67, 67, 67, 67,
 67, 67, 67, 67, 67, 67, 67, 67, 67, 67,
 67, 67, 67, 67, 67, 67, 67, 67, 67, 67,
 67, 67, 67, 67, 67, 67, 67, 67, 67, 67,
 67, 67, 67, 67, 67, 67, 67, 67, 67, 67,
 67, 67, 67, 67, 67, 67, 67, 67, 68, 68,
 68, 68, 68, 68, 68, 68, 68, 68, 68, 68,
 68, 68, 68, 68, 68, 68, 68, 68, 68, 68,
 68, 68, 68, 68, 68, 68, 68, 68, 68, 68,
 68, 68, 68, 68, 68, 68, 68, 68, 68, 68,
 68, 68, 68, 68, 68, 68, 68, 68, 68, 68,
 68, 68, 68, 68, 68, 68, 68, 68, 68, 68,
 68, 68, 68, 68, 68, 68, 68, 68, 68, 68,
 68, 68, 68, 68, 68, 68, 68, 68, 68, 68,
 68, 68, 68, 68, 68, 68, 68, 68, 69, 69,
 69, 69, 69, 69, 69, 69, 69, 69, 69, 69,
 69, 69, 69, 69, 69, 69, 69, 69, 69, 69,
 69, 69, 69, 69, 69, 69, 69, 69, 69, 69,
 69, 69, 69, 69, 69, 69, 69, 69, 69, 69,
 69, 69, 69, 69, 69, 69, 69, 69, 69, 69,
 69, 69, 69, 69, 69, 69, 69, 69, 69, 69,
 69, 69, 69, 69, 69, 69, 69, 69, 69, 69,
 69, 69, 69, 69, 69, 69, 69, 69, 69, 69,
 69, 69, 69, 69, 69, 69, 69, 69, 70, 70,
 70, 70, 70, 70, 70, 70, 70, 70, 70, 70,
 70, 70, 70, 70, 70, 70, 70, 70, 70, 70,
 70, 70, 70, 70, 70, 70, 70, 70, 70, 70,
 70, 70, 70, 70, 70, 70, 70, 70, 70, 70,
 70, 70, 70, 70, 70, 70, 70, 70, 70, 70,
 70, 70, 70, 70, 70, 70, 70, 70, 70, 70,
 70, 70, 70, 70, 70, 70, 70, 70, 70, 70,
 70, 70, 70, 70, 70, 70, 70, 70, 70, 70,
 70, 70, 70, 70, 70, 70, 70, 70, 70, 70,
 71, 71, 71, 71, 71, 71, 71, 71, 71, 71,
 71, 71, 71, 71, 71, 71, 71, 71, 71, 71,
 71, 71, 71, 71, 71, 71, 71, 71, 71, 71,
 71, 71, 71, 71, 71, 71, 71, 71, 71, 71,
 71, 71, 71, 71, 71, 71, 71, 71, 71, 71,
 71, 71, 71, 71, 71, 71, 71, 71, 71, 71,
 71, 71, 71, 71, 71, 71, 71, 71, 71, 71,
 71, 71, 71, 71, 71, 71, 71, 71, 71, 71,
 71, 71, 71, 71, 71, 71, 71, 71, 71, 71,
 71, 71, 72, 72, 72, 72, 72, 72, 72, 72,
 72, 72, 72, 72, 72, 72, 72, 72, 72, 72,
 72, 72, 72, 72, 72, 72, 72, 72, 72, 72,
 72, 72, 72, 72, 72, 72, 72, 72, 72, 72,
 72, 72, 72, 72, 72, 72, 72, 72, 72, 72,
 72, 72, 72, 72, 72, 72, 72, 72, 72, 72,
 72, 72, 72, 72, 72, 72, 72, 72, 72, 72,
 72, 72, 72, 72, 72, 72, 72, 72, 72, 72,
 72, 72, 72, 72, 72, 72, 72, 72, 72, 72,
 72, 72, 72, 72, 73, 73, 73, 73, 73, 73,
 73, 73, 73, 73, 73, 73, 73, 73, 73, 73,
 73, 73, 73, 73, 73, 73, 73, 73, 73, 73,
 73, 73, 73, 73, 73, 73, 73, 73, 73, 73,
 73, 73, 73, 73, 73, 73, 73, 73, 73, 73,
 73, 73, 73, 73, 73, 73, 73, 73, 73, 73,
 73, 73, 73, 73, 73, 73, 73, 73, 73, 73,
 73, 73, 73, 73, 73, 73, 73, 73, 73, 73,
 73, 73, 73, 73, 73, 73, 73, 73, 73, 73,
 73, 73, 73, 73, 73, 73, 73, 74, 74, 74,
 74, 74, 74, 74, 74, 74, 74, 74, 74, 74,
 74, 74, 74, 74, 74, 74, 74, 74, 74, 74,
 74, 74, 74, 74, 74, 74, 74, 74, 74, 74,
 74, 74, 74, 74, 74, 74, 74, 74, 74, 74,
 74, 74, 74, 74, 74, 74, 74, 74, 74, 74,
 74, 74, 74, 74, 74, 74, 74, 74, 74, 74,
 74, 74, 74, 74, 74, 74, 74, 74, 74, 74,
 74, 74, 74, 74, 74, 74, 74, 74, 74, 74,
 74, 74, 74, 74, 74, 74, 74, 74, 74, 74,
 74, 75, 75, 75, 75, 75, 75, 75, 75, 75,
 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,
 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,
 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,
 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,
 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,
 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,
 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,
 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,
 75, 75, 75, 75, 75, 75, 76, 76, 76, 76,
 76, 76, 76, 76, 76, 76, 76, 76, 76, 76,
 76, 76, 76, 76, 76, 76, 76, 76, 76, 76,
 76, 76, 76, 76, 76, 76, 76, 76, 76, 76,
 76, 76, 76, 76, 76, 76, 76, 76, 76, 76,
 76, 76, 76, 76, 76, 76, 76, 76, 76, 76,
 76, 76, 76, 76, 76, 76, 76, 76, 76, 76,
 76, 76, 76, 76, 76, 76, 76, 76, 76, 76,
 76, 76, 76, 76, 76, 76, 76, 76, 76, 76,
 76, 76, 76, 76, 76, 76, 76, 76, 76, 76,
 76, 77, 77, 77, 77, 77, 77, 77, 77, 77,
 77, 77, 77, 77, 77, 77, 77, 77, 77, 77,
 77, 77, 77, 77, 77, 77, 77, 77, 77, 77,
 77, 77, 77, 77, 77, 77, 77, 77, 77, 77,
 77, 77, 77, 77, 77, 77, 77, 77, 77, 77,
 77, 77, 77, 77, 77, 77, 77, 77, 77, 77,
 77, 77, 77, 77, 77, 77, 77, 77, 77, 77,
 77, 77, 77, 77, 77, 77, 77, 77, 77, 77,
 77, 77, 77, 77, 77, 77, 77, 77, 77, 77,
 77, 77, 77, 77, 77, 77, 78, 78, 78, 78,
 78, 78, 78, 78, 78, 78, 78, 78, 78, 78,
 78, 78, 78, 78, 78, 78, 78, 78, 78, 78,
 78, 78, 78, 78, 78, 78, 78, 78, 78, 78,
 78, 78, 78, 78, 78, 78, 78, 78, 78, 78,
 78, 78, 78, 78, 78, 78, 78, 78, 78, 78,
 78, 78, 78, 78, 78, 78, 78, 78, 78, 78,
 78, 78, 78, 78, 78, 78, 78, 78, 78, 78,
 78, 78, 78, 78, 78, 78, 78, 78, 78, 78,
 78, 78, 78, 78, 78, 78, 78, 78, 78, 78,
 78, 78, 79, 79, 79, 79, 79, 79, 79, 79,
 79, 79, 79, 79, 79, 79, 79, 79, 79, 79,
 79, 79, 79, 79, 79, 79, 79, 79, 79, 79,
 79, 79, 79, 79, 79, 79, 79, 79, 79, 79,
 79, 79, 79, 79, 79, 79, 79, 79, 79, 79,
 79, 79, 79, 79, 79, 79, 79, 79, 79, 79,
 79, 79, 79, 79, 79, 79, 79, 79, 79, 79,
 79, 79, 79, 79, 79, 79, 79, 79, 79, 79,
 79, 79, 79, 79, 79, 79, 79, 79, 79, 79,
 79, 79, 79, 79, 79, 79, 79, 79, 79, 80,
 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
 80, 80, 80, 80, 80, 80, 81, 81, 81, 81,
 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
 81, 81, 81, 82, 82, 82, 82, 82, 82, 82,
 82, 82, 82, 82, 82, 82, 82, 82, 82, 82,
 82, 82, 82, 82, 82, 82, 82, 82, 82, 82,
 82, 82, 82, 82, 82, 82, 82, 82, 82, 82,
 82, 82, 82, 82, 82, 82, 82, 82, 82, 82,
 82, 82, 82, 82, 82, 82, 82, 82, 82, 82,
 82, 82, 82, 82, 82, 82, 82, 82, 82, 82,
 82, 82, 82, 82, 82, 82, 82, 82, 82, 82,
 82, 82, 82, 82, 82, 82, 82, 82, 82, 82,
 82, 82, 82, 82, 82, 82, 82, 82, 82, 82,
 82, 82, 83, 83, 83, 83, 83, 83, 83, 83,
 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
 83, 84, 84, 84, 84, 84, 84, 84, 84, 84,
 84, 84, 84, 84, 84, 84, 84, 84, 84, 84,
 84, 84, 84, 84, 84, 84, 84, 84, 84, 84,
 84, 84, 84, 84, 84, 84, 84, 84, 84, 84,
 84, 84, 84, 84, 84, 84, 84, 84, 84, 84,
 84, 84, 84, 84, 84, 84, 84, 84, 84, 84,
 84, 84, 84, 84, 84, 84, 84, 84, 84, 84,
 84, 84, 84, 84, 84, 84, 84, 84, 84, 84,
 84, 84, 84, 84, 84, 84, 84, 84, 84, 84,
 84, 84, 84, 84, 84, 84, 84, 84, 84, 84,
 85, 85, 85, 85, 85, 85, 85, 85, 85, 85,
 85, 85, 85, 85, 85, 85, 85, 85, 85, 85,
 85, 85, 85, 85, 85, 85, 85, 85, 85, 85,
 85, 85, 85, 85, 85, 85, 85, 85, 85, 85,
 85, 85, 85, 85, 85, 85, 85, 85, 85, 85,
 85, 85, 85, 85, 85, 85, 85, 85, 85, 85,
 85, 85, 85, 85, 85, 85, 85, 85, 85, 85,
 85, 85, 85, 85, 85, 85, 85, 85, 85, 85,
 85, 85, 85, 85, 85, 85, 85, 85, 85, 85,
 85, 85, 85, 85, 85, 85, 85, 85, 85, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 87, 87, 87, 87, 87, 87, 87, 87, 87, 87,
 87, 87, 87, 87, 87, 87, 87, 87, 87, 87,
 87, 87, 87, 87, 87, 87, 87, 87, 87, 87,
 87, 87, 87, 87, 87, 87, 87, 87, 87, 87,
 87, 87, 87, 87, 87, 87, 87, 87, 87, 87,
 87, 87, 87, 87, 87, 87, 87, 87, 87, 87,
 87, 87, 87, 87, 87, 87, 87, 87, 87, 87,
 87, 87, 87, 87, 87, 87, 87, 87, 87, 87,
 87, 87, 87, 87, 87, 87, 87, 87, 87, 87,
 87, 87, 87, 87, 87, 87, 87, 87, 87, 87,
 87, 88, 88, 88, 88, 88, 88, 88, 88, 88,
 88, 88, 88, 88, 88, 88, 88, 88, 88, 88,
 88, 88, 88, 88, 88, 88, 88, 88, 88, 88,
 88, 88, 88, 88, 88, 88, 88, 88, 88, 88,
 88, 88, 88, 88, 88, 88, 88, 88, 88, 88,
 88, 88, 88, 88, 88, 88, 88, 88, 88, 88,
 88, 88, 88, 88, 88, 88, 88, 88, 88, 88,
 88, 88, 88, 88, 88, 88, 88, 88, 88, 88,
 88, 88, 88, 88, 88, 88, 88, 88, 88, 88,
 88, 88, 88, 88, 88, 88, 88, 88, 88, 88,
 88, 88, 89, 89, 89, 89, 89, 89, 89, 89,
 89, 89, 89, 89, 89, 89, 89, 89, 89, 89,
 89, 89, 89, 89, 89, 89, 89, 89, 89, 89,
 89, 89, 89, 89, 89, 89, 89, 89, 89, 89,
 89, 89, 89, 89, 89, 89, 89, 89, 89, 89,
 89, 89, 89, 89, 89, 89, 89, 89, 89, 89,
 89, 89, 89, 89, 89, 89, 89, 89, 89, 89,
 89, 89, 89, 89, 89, 89, 89, 89, 89, 89,
 89, 89, 89, 89, 89, 89, 89, 89, 89, 89,
 89, 89, 89, 89, 89, 89, 89, 89, 89, 89,
 89, 89, 89, 90, 90, 90, 90, 90, 90, 90,
 90, 90, 90, 90, 90, 90, 90, 90, 90, 90,
 90, 90, 90, 90, 90, 90, 90, 90, 90, 90,
 90, 90, 90, 90, 90, 90, 90, 90, 90, 90,
 90, 90, 90, 90, 90, 90, 90, 90, 90, 90,
 90, 90, 90, 90, 90, 90, 90, 90, 90, 90,
 90, 90, 90, 90, 90, 90, 90, 90, 90, 90,
 90, 90, 90, 90, 90, 90, 90, 90, 90, 90,
 90, 90, 90, 90, 90, 90, 90, 90, 90, 90,
 90, 90, 90, 90, 90, 90, 90, 90, 90, 90,
 90, 90, 90, 90, 90, 91, 91, 91, 91, 91,
 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
 91, 91, 91, 91, 91, 91, 91, 91, 92, 92,
 92, 92, 92, 92, 92, 92, 92, 92, 92, 92,
 92, 92, 92, 92, 92, 92, 92, 92, 92, 92,
 92, 92, 92, 92, 92, 92, 92, 92, 92, 92,
 92, 92, 92, 92, 92, 92, 92, 92, 92, 92,
 92, 92, 92, 92, 92, 92, 92, 92, 92, 92,
 92, 92, 92, 92, 92, 92, 92, 92, 92, 92,
 92, 92, 92, 92, 92, 92, 92, 92, 92, 92,
 92, 92, 92, 92, 92, 92, 92, 92, 92, 92,
 92, 92, 92, 92, 92, 92, 92, 92, 92, 92,
 92, 92, 92, 92, 92, 92, 92, 92, 92, 92,
 92, 93, 93, 93, 93, 93, 93, 93, 93, 93,
 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
 93, 93, 93, 93, 94, 94, 94, 94, 94, 94,
 94, 94, 94, 94, 94, 94, 94, 94, 94, 94,
 94, 94, 94, 94, 94, 94, 94, 94, 94, 94,
 94, 94, 94, 94, 94, 94, 94, 94, 94, 94,
 94, 94, 94, 94, 94, 94, 94, 94, 94, 94,
 94, 94, 94, 94, 94, 94, 94, 94, 94, 94,
 94, 94, 94, 94, 94, 94, 94, 94, 94, 94,
 94, 94, 94, 94, 94, 94, 94, 94, 94, 94,
 94, 94, 94, 94, 94, 94, 94, 94, 94, 94,
 94, 94, 94, 94, 94, 94, 94, 94, 94, 94,
 94, 94, 94, 94, 94, 94, 94, 94, 95, 95,
 95, 95, 95, 95, 95, 95, 95, 95, 95, 95,
 95, 95, 95, 95, 95, 95, 95, 95, 95, 95,
 95, 95, 95, 95, 95, 95, 95, 95, 95, 95,
 95, 95, 95, 95, 95, 95, 95, 95, 95, 95,
 95, 95, 95, 95, 95, 95, 95, 95, 95, 95,
 95, 95, 95, 95, 95, 95, 95, 95, 95, 95,
 95, 95, 95, 95, 95, 95, 95, 95, 95, 95,
 95, 95, 95, 95, 95, 95, 95, 95, 95, 95,
 95, 95, 95, 95, 95, 95, 95, 95, 95, 95,
 95, 95, 95, 95, 95, 95, 95, 95, 95, 95,
 95, 95, 96, 96, 96, 96, 96, 96, 96, 96,
 96, 96, 96, 96, 96, 96, 96, 96, 96, 96,
 96, 96, 96, 96, 96, 96, 96, 96, 96, 96,
 96, 96, 96, 96, 96, 96, 96, 96, 96, 96,
 96, 96, 96, 96, 96, 96, 96, 96, 96, 96,
 96, 96, 96, 96, 96, 96, 96, 96, 96, 96,
 96, 96, 96, 96, 96, 96, 96, 96, 96, 96,
 96, 96, 96, 96, 96, 96, 96, 96, 96, 96,
 96, 96, 96, 96, 96, 96, 96, 96, 96, 96,
 96, 96, 96, 96, 96, 96, 96, 96, 96, 96,
 96, 96, 96, 96, 96, 96, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
 98, 98, 98, 98, 98, 99, 99, 99, 99, 99,
 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
100,100,100,100,100,100,100,100,100,100,
100,100,100,100,100,100,100,100,100,100,
100,100,100,100,100,100,100,100,100,100,
100,100,100,100,100,100,100,100,100,100,
100,100,100,100,100,100,100,100,100,100,
100,100,100,100,100,100,100,100,100,100,
100,100,100,100,100,100,100,100,100,100,
100,100,100,100,100,100,100,100,100,100,
100,100,100,100,100,100,100,100,100,100,
100,100,100,100,100,100,100,100,100,100,
100,100,100,100,100,100,101,101,101,101,
101,101,101,101,101,101,101,101,101,101,
101,101,101,101,101,101,101,101,101,101,
101,101,101,101,101,101,101,101,101,101,
101,101,101,101,101,101,101,101,101,101,
101,101,101,101,101,101,101,101,101,101,
101,101,101,101,101,101,101,101,101,101,
101,101,101,101,101,101,101,101,101,101,
101,101,101,101,101,101,101,101,101,101,
101,101,101,101,101,101,101,101,101,101,
101,101,101,101,101,101,101,101,101,101,
101,101,102,102,102,102,102,102,102,102,
102,102,102,102,102,102,102,102,102,102,
102,102,102,102,102,102,102,102,102,102,
102,102,102,102,102,102,102,102,102,102,
102,102,102,102,102,102,102,102,102,102,
102,102,102,102,102,102,102,102,102,102,
102,102,102,102,102,102,102,102,102,102,
102,102,102,102,102,102,102,102,102,102,
102,102,102,102,102,102,102,102,102,102,
102,102,102,102,102,102,102,102,102,102,
102,102,102,102,102,102,102,102,102,103,
103,103,103,103,103,103,103,103,103,103,
103,103,103,103,103,103,103,103,103,103,
103,103,103,103,103,103,103,103,103,103,
103,103,103,103,103,103,103,103,103,103,
103,103,103,103,103,103,103,103,103,103,
103,103,103,103,103,103,103,103,103,103,
103,103,103,103,103,103,103,103,103,103,
103,103,103,103,103,103,103,103,103,103,
103,103,103,103,103,103,103,103,103,103,
103,103,103,103,103,103,103,103,103,103,
103,103,103,103,104,104,104,104,104,104,
104,104,104,104,104,104,104,104,104,104,
104,104,104,104,104,104,104,104,104,104,
104,104,104,104,104,104,104,104,104,104,
104,104,104,104,104,104,104,104,104,104,
104,104,104,104,104,104,104,104,104,104,
104,104,104,104,104,104,104,104,104,104,
104,104,104,104,104,104,104,104,104,104,
104,104,104,104,104,104,104,104,104,104,
104,104,104,104,104,104,104,104,104,104,
104,104,104,104,104,104,105,105,105,105,
105,105,105,105,105,105,105,105,105,105,
105,105,105,105,105,105,105,105,105,105,
105,105,105,105,105,105,105,105,105,105,
105,105,105,105,105,105,105,105,105,105,
105,105,105,105,105,105,105,105,105,105,
105,105,105,105,105,105,105,105,105,105,
105,105,105,105,105,105,105,105,105,105,
105,105,105,105,105,105,105,105,105,105,
105,105,105,105,105,105,105,105,105,105,
105,105,105,105,105,106,106,106,106,106,
106,106,106,106,106,106,106,106,106,106,
106,106,106,106,106,106,106,106,106,106,
106,106,106,106,106,106,106,106,106,106,
106,106,106,106,106,106,106,106,106,106,
106,106,106,106,106,106,106,106,106,106,
106,106,106,106,106,106,106,106,106,106,
106,106,106,106,106,106,106,106,106,106,
106,106,106,106,106,106,106,106,106,106,
106,106,106,106,106,106,106,106,106,106,
106,107,107,107,107,107,107,107,107,107,
107,107,107,107,107,107,107,107,107,107,
107,107,107,107,107,107,107,107,107,107,
107,107,107,107,107,107,107,107,107,107,
107,107,107,107,107,107,107,107,107,107,
107,107,107,107,107,107,107,107,107,107,
107,107,107,107,107,107,107,107,107,107,
107,107,107,107,107,107,107,107,107,107,
107,107,107,107,107,107,107,107,107,107,
107,107,107,107,108,108,108,108,108,108,
108,108,108,108,108,108,108,108,108,108,
108,108,108,108,108,108,108,108,108,108,
108,108,108,108,108,108,108,108,108,108,
108,108,108,108,108,108,108,108,108,108,
108,108,108,108,108,108,108,108,108,108,
108,108,108,108,108,108,108,108,108,108,
108,108,108,108,108,108,108,108,108,108,
108,108,108,108,108,108,108,108,108,108,
108,108,108,108,109,109,109,109,109,109,
109,109,109,109,109,109,109,109,109,109,
109,109,109,109,109,109,109,109,109,109,
109,109,109,109,109,109,109,109,109,109,
109,109,109,109,109,109,109,109,109,109,
109,109,109,109,109,109,109,109,109,109,
109,109,109,109,109,109,109,109,109,109,
109,109,109,109,109,109,109,109,109,109,
109,109,109,109,109,109,109,109,109,109,
109,110,110,110,110,110,110,110,110,110,
110,110,110,110,110,110,110,110,110,110,
110,110,110,110,110,110,110,110,110,110,
110,110,110,110,110,110,110,110,110,110,
110,110,110,110,110,110,110,110,110,110,
110,110,110,110,110,110,110,110,110,110,
110,110,110,110,110,110,110,110,110,110,
110,110,110,110,110,110,110,110,110,110,
110,110,110,110,110,111,111,111,111,111,
111,111,111,111,111,111,111,111,111,111,
111,111,111,111,111,111,111,111,111,111,
111,111,111,111,111,111,111,111,111,111,
111,111,111,111,111,111,111,111,111,111,
111,111,111,111,111,111,111,111,111,111,
111,111,111,111,111,111,111,111,111,111,
111,111,111,111,111,111,111,111,111,111,
111,111,111,111,111,111,112,112,112,112,
112,112,112,112,112,112,112,112,112,112,
112,112,112,112,112,112,112,112,112,112,
112,112,112,112,112,112,112,112,112,112,
112,112,112,112,112,112,112,112,112,112,
112,112,112,112,112,112,112,112,112,112,
112,112,112,112,112,112,112,112,112,112,
112,112,112,112,112,112,112,112,112,112,
112,112,112,112,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,114,114,
114,114,114,114,114,114,114,114,114,114,
114,114,114,114,114,114,114,114,114,114,
114,114,114,114,114,114,114,114,114,114,
114,114,114,114,114,114,114,114,114,114,
114,114,114,114,114,114,114,114,114,114,
114,114,114,114,114,114,114,114,114,114,
114,114,114,114,114,114,114,114,114,115,
115,115,115,115,115,115,115,115,115,115,
115,115,115,115,115,115,115,115,115,115,
115,115,115,115,115,115,115,115,115,115,
115,115,115,115,115,115,115,115,115,115,
115,115,115,115,115,115,115,115,115,115,
115,115,115,115,115,115,115,115,115,115,
115,115,115,115,115,115,115,116,116,116,
116,116,116,116,116,116,116,116,116,116,
116,116,116,116,116,116,116,116,116,116,
116,116,116,116,116,116,116,116,116,116,
116,116,116,116,116,116,116,116,116,116,
116,116,116,116,116,116,116,116,116,116,
116,116,116,116,116,116,116,116,116,116,
116,116,117,117,117,117,117,117,117,117,
117,117,117,117,117,117,117,117,117,117,
117,117,117,117,117,117,117,117,117,117,
117,117,117,117,117,117,117,117,117,117,
117,117,117,117,117,117,117,117,117,117,
117,117,117,117,117,117,117,117,117,117,
117,117,117,117,118,118,118,118,118,118,
118,118,118,118,118,118,118,118,118,118,
118,118,118,118,118,118,118,118,118,118,
118,118,118,118,118,118,118,118,118,118,
118,118,118,118,118,118,118,118,118,118,
118,118,118,118,118,118,118,118,118,118,
118,118,118,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,120,
120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,
120,120,121,121,121,121,121,121,121,121,
121,121,121,121,121,121,121,121,121,121,
121,121,121,121,121,121,121,121,121,121,
121,121,121,121,121,121,121,121,121,121,
121,121,121,121,121,121,121,121,121,121,
121,121,122,122,122,122,122,122,122,122,
122,122,122,122,122,122,122,122,122,122,
122,122,122,122,122,122,122,122,122,122,
122,122,122,122,122,122,122,122,122,122,
122,122,122,122,122,122,122,122,123,123,
123,123,123,123,123,123,123,123,123,123,
123,123,123,123,123,123,123,123,123,123,
123,123,123,123,123,123,123,123,123,123,
123,123,123,123,123,123,123,123,123,123,
123,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,
124,125,125,125,125,125,125,125,125,125,
125,125,125,125,125,125,125,125,125,125,
125,125,125,125,125,125,125,125,125,125,
125,125,125,125,125,125,125,125,126,126,
126,126,126,126,126,126,126,126,126,126,
126,126,126,126,126,126,126,126,126,126,
126,126,126,126,126,126,126,126,126,126,
126,126,127,127,127,127,127,127,127,127,
127,127,127,127,127,127,127,127,127,127,
127,127,127,127,127,127,127,127,127,127,
127,127,128,128,128,128,128,128,128,128,
128,128,128,128,128,128,128,128,128,128,
128,128,128,128,128,128,128,128,128,129,
129,129,129,129,129,129,129,129,129,129,
129,129,129,129,129,129,129,129,129,129,
129,129,129,130,130,130,130,130,130,130,
130,130,130,130,130,130,130,130,130,130,
130,130,130,130,131,131,131,131,131,131,
131,131,131,131,131,131,131,131,131,131,
131,132,132,132,132,132,132,132,132,132,
132,132,132,132,132,133,133,133,133,133,
133,133,133,133,133,133,134,134,134,134,
134,134,134,134,135,135,135,135,136
  },
  // --------- A -----------
  {
 16, 17, 18, 19, 20, 21, 22, 23, 24, 25,
 26, 27, 28, 29, 30, 31, 32, 33, 34, 17,
 18, 19, 20, 21, 22, 23, 24, 25, 26, 27,
 28, 29, 30, 31, 32, 33, 34, 35, 36, 37,
 38, 18, 19, 20, 21, 22, 23, 24, 25, 26,
 27, 28, 29, 30, 31, 32, 33, 34, 35, 36,
 37, 38, 39, 40, 41, 19, 20, 21, 22, 23,
 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
 34, 35, 36, 37, 38, 39, 40, 41, 42, 43,
 44, 20, 21, 22, 23, 24, 25, 26, 27, 28,
 29, 30, 31, 32, 33, 34, 35, 36, 37, 38,
 39, 40, 41, 42, 43, 44, 45, 46, 47, 21,
 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
 42, 43, 44, 45, 46, 47, 48, 49, 50, 51,
 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
 42, 43, 44, 45, 46, 47, 48, 49, 50, 51,
 52, 53, 54, 23, 24, 25, 26, 27, 28, 29,
 30, 31, 32, 33, 34, 35, 36, 37, 38, 39,
 40, 41, 42, 43, 44, 45, 46, 47, 48, 49,
 50, 51, 52, 53, 54, 55, 56, 57, 24, 25,
 26, 27, 28, 29, 30, 31, 32, 33, 34, 35,
 36, 37, 38, 39, 40, 41, 42, 43, 44, 45,
 46, 47, 48, 49, 50, 51, 52, 53, 54, 55,
 56, 57, 58, 59, 60, 25, 26, 27, 28, 29,
 30, 31, 32, 33, 34, 35, 36, 37, 38, 39,
 40, 41, 42, 43, 44, 45, 46, 47, 48, 49,
 50, 51, 52, 53, 54, 55, 56, 57, 58, 59,
 60, 61, 62, 63, 27, 28, 29, 30, 31, 32,
 33, 34, 35, 36, 37, 38, 39, 40, 41, 42,
 43, 44, 45, 46, 47, 48, 49, 50, 51, 52,
 53, 54, 55, 56, 57, 58, 59, 60, 61, 62,
 63, 64, 65, 66, 67, 29, 30, 31, 32, 33,
 34, 35, 36, 37, 38, 39, 40, 41, 42, 43,
 44, 45, 46, 47, 48, 49, 50, 51, 52, 53,
 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
 64, 65, 66, 67, 68, 69, 70, 30, 31, 32,
 33, 34, 35, 36, 37, 38, 39, 40, 41, 42,
 43, 44, 45, 46, 47, 48, 49, 50, 51, 52,
 53, 54, 55, 56, 57, 58, 59, 60, 61, 62,
 63, 64, 65, 66, 67, 68, 69, 70, 71, 72,
 73, 32, 33, 34, 35, 36, 37, 38, 39, 40,
 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
 51, 52, 53, 54, 55, 56, 57, 58, 59, 60,
 61, 62, 63, 64, 65, 66, 67, 68, 69, 70,
 71, 72, 73, 74, 75, 76, 34, 35, 36, 37,
 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
 48, 49, 50, 51, 52, 53, 54, 55, 56, 57,
 58, 59, 60, 61, 62, 63, 64, 65, 66, 67,
 68, 69, 70, 71, 72, 73, 74, 75, 76, 77,
 78, 79, 80, 36, 37, 38, 39, 40, 41, 42,
 43, 44, 45, 46, 47, 48, 49, 50, 51, 52,
 53, 54, 55, 56, 57, 58, 59, 60, 61, 62,
 63, 64, 65, 66, 67, 68, 69, 70, 71, 72,
 73, 74, 75, 76, 77, 78, 79, 80, 81, 82,
 83, 38, 39, 40, 41, 42, 43, 44, 45, 46,
 47, 48, 49, 50, 51, 52, 53, 54, 55, 56,
 57, 58, 59, 60, 61, 62, 63, 64, 65, 66,
 67, 68, 69, 70, 71, 72, 73, 74, 75, 76,
 77, 78, 79, 80, 81, 82, 83, 84, 85, 86,
 40, 41, 42, 43, 44, 45, 46, 47, 48, 49,
 50, 51, 52, 53, 54, 55, 56, 57, 58, 59,
 60, 61, 62, 63, 64, 65, 66, 67, 68, 69,
 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
 80, 81, 82, 83, 84, 85, 86, 87, 88, 89,
 42, 43, 44, 45, 46, 47, 48, 49, 50, 51,
 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
 62, 63, 64, 65, 66, 67, 68, 69, 70, 71,
 72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
 82, 83, 84, 85, 86, 87, 88, 89, 90, 91,
 92, 44, 45, 46, 47, 48, 49, 50, 51, 52,
 53, 54, 55, 56, 57, 58, 59, 60, 61, 62,
 63, 64, 65, 66, 67, 68, 69, 70, 71, 72,
 73, 74, 75, 76, 77, 78, 79, 80, 81, 82,
 83, 84, 85, 86, 87, 88, 89, 90, 91, 92,
 93, 94, 95, 96, 46, 47, 48, 49, 50, 51,
 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
 62, 63, 64, 65, 66, 67, 68, 69, 70, 71,
 72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
 82, 83, 84, 85, 86, 87, 88, 89, 90, 91,
 92, 93, 94, 95, 96, 97, 98, 99, 48, 49,
 50, 51, 52, 53, 54, 55, 56, 57, 58, 59,
 60, 61, 62, 63, 64, 65, 66, 67, 68, 69,
 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
 80, 81, 82, 83, 84, 85, 86, 87, 88, 89,
 90, 91, 92, 93, 94, 95, 96, 97, 98, 99,
100,101,102, 51, 52, 53, 54, 55, 56, 57,
 58, 59, 60, 61, 62, 63, 64, 65, 66, 67,
 68, 69, 70, 71, 72, 73, 74, 75, 76, 77,
 78, 79, 80, 81, 82, 83, 84, 85, 86, 87,
 88, 89, 90, 91, 92, 93, 94, 95, 96, 97,
 98, 99,100,101,102,103,104,105, 53, 54,
 55, 56, 57, 58, 59, 60, 61, 62, 63, 64,
 65, 66, 67, 68, 69, 70, 71, 72, 73, 74,
 75, 76, 77, 78, 79, 80, 81, 82, 83, 84,
 85, 86, 87, 88, 89, 90, 91, 92, 93, 94,
 95, 96, 97, 98, 99,100,101,102,103,104,
105,106,107,108, 55, 56, 57, 58, 59, 60,
 61, 62, 63, 64, 65, 66, 67, 68, 69, 70,
 71, 72, 73, 74, 75, 76, 77, 78, 79, 80,
 81, 82, 83, 84, 85, 86, 87, 88, 89, 90,
 91, 92, 93, 94, 95, 96, 97, 98, 99,100,
101,102,103,104,105,106,107,108,109,110,
111,112, 57, 58, 59, 60, 61, 62, 63, 64,
 65, 66, 67, 68, 69, 70, 71, 72, 73, 74,
 75, 76, 77, 78, 79, 80, 81, 82, 83, 84,
 85, 86, 87, 88, 89, 90, 91, 92, 93, 94,
 95, 96, 97, 98, 99,100,101,102,103,104,
105,106,107,108,109,110,111,112,113,114,
115, 59, 60, 61, 62, 63, 64, 65, 66, 67,
 68, 69, 70, 71, 72, 73, 74, 75, 76, 77,
 78, 79, 80, 81, 82, 83, 84, 85, 86, 87,
 88, 89, 90, 91, 92, 93, 94, 95, 96, 97,
 98, 99,100,101,102,103,104,105,106,107,
108,109,110,111,112,113,114,115,116,117,
118, 61, 62, 63, 64, 65, 66, 67, 68, 69,
 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
 80, 81, 82, 83, 84, 85, 86, 87, 88, 89,
 90, 91, 92, 93, 94, 95, 96, 97, 98, 99,
100,101,102,103,104,105,106,107,108,109,
110,111,112,113,114,115,116,117,118,119,
120,121, 63, 64, 65, 66, 67, 68, 69, 70,
 71, 72, 73, 74, 75, 76, 77, 78, 79, 80,
 81, 82, 83, 84, 85, 86, 87, 88, 89, 90,
 91, 92, 93, 94, 95, 96, 97, 98, 99,100,
101,102,103,104,105,106,107,108,109,110,
111,112,113,114,115,116,117,118,119,120,
121,122,123,124, 66, 67, 68, 69, 70, 71,
 72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
 82, 83, 84, 85, 86, 87, 88, 89, 90, 91,
 92, 93, 94, 95, 96, 97, 98, 99,100,101,
102,103,104,105,106,107,108,109,110,111,
112,113,114,115,116,117,118,119,120,121,
122,123,124,125,126,127,128, 68, 69, 70,
 71, 72, 73, 74, 75, 76, 77, 78, 79, 80,
 81, 82, 83, 84, 85, 86, 87, 88, 89, 90,
 91, 92, 93, 94, 95, 96, 97, 98, 99,100,
101,102,103,104,105,106,107,108,109,110,
111,112,113,114,115,116,117,118,119,120,
121,122,123,124,125,126,127,128,129,130,
131, 70, 71, 72, 73, 74, 75, 76, 77, 78,
 79, 80, 81, 82, 83, 84, 85, 86, 87, 88,
 89, 90, 91, 92, 93, 94, 95, 96, 97, 98,
 99,100,101,102,103,104,105,106,107,108,
109,110,111,112,113,114,115,116,117,118,
119,120,121,122,123,124,125,126,127,128,
129,130,131,132,133,134, 72, 73, 74, 75,
 76, 77, 78, 79, 80, 81, 82, 83, 84, 85,
 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
 96, 97, 98, 99,100,101,102,103,104,105,
106,107,108,109,110,111,112,113,114,115,
116,117,118,119,120,121,122,123,124,125,
126,127,128,129,130,131,132,133,134,135,
136,137, 74, 75, 76, 77, 78, 79, 80, 81,
 82, 83, 84, 85, 86, 87, 88, 89, 90, 91,
 92, 93, 94, 95, 96, 97, 98, 99,100,101,
102,103,104,105,106,107,108,109,110,111,
112,113,114,115,116,117,118,119,120,121,
122,123,124,125,126,127,128,129,130,131,
132,133,134,135,136,137,138,139,140, 77,
 78, 79, 80, 81, 82, 83, 84, 85, 86, 87,
 88, 89, 90, 91, 92, 93, 94, 95, 96, 97,
 98, 99,100,101,102,103,104,105,106,107,
108,109,110,111,112,113,114,115,116,117,
118,119,120,121,122,123,124,125,126,127,
128,129,130,131,132,133,134,135,136,137,
138,139,140,141,142,143,144, 79, 80, 81,
 82, 83, 84, 85, 86, 87, 88, 89, 90, 91,
 92, 93, 94, 95, 96, 97, 98, 99,100,101,
102,103,104,105,106,107,108,109,110,111,
112,113,114,115,116,117,118,119,120,121,
122,123,124,125,126,127,128,129,130,131,
132,133,134,135,136,137,138,139,140,141,
142,143,144,145,146,147, 81, 82, 83, 84,
 85, 86, 87, 88, 89, 90, 91, 92, 93, 94,
 95, 96, 97, 98, 99,100,101,102,103,104,
105,106,107,108,109,110,111,112,113,114,
115,116,117,118,119,120,121,122,123,124,
125,126,127,128,129,130,131,132,133,134,
135,136,137,138,139,140,141,142,143,144,
145,146,147,148,149,150, 83, 84, 85, 86,
 87, 88, 89, 90, 91, 92, 93, 94, 95, 96,
 97, 98, 99,100,101,102,103,104,105,106,
107,108,109,110,111,112,113,114,115,116,
117,118,119,120,121,122,123,124,125,126,
127,128,129,130,131,132,133,134,135,136,
137,138,139,140,141,142,143,144,145,146,
147,148,149,150,151,152,153, 86, 87, 88,
 89, 90, 91, 92, 93, 94, 95, 96, 97, 98,
 99,100,101,102,103,104,105,106,107,108,
109,110,111,112,113,114,115,116,117,118,
119,120,121,122,123,124,125,126,127,128,
129,130,131,132,133,134,135,136,137,138,
139,140,141,142,143,144,145,146,147,148,
149,150,151,152,153,154,155,156, 88, 89,
 90, 91, 92, 93, 94, 95, 96, 97, 98, 99,
100,101,102,103,104,105,106,107,108,109,
110,111,112,113,114,115,116,117,118,119,
120,121,122,123,124,125,126,127,128,129,
130,131,132,133,134,135,136,137,138,139,
140,141,142,143,144,145,146,147,148,149,
150,151,152,153,154,155,156,157,158,159,
160, 90, 91, 92, 93, 94, 95, 96, 97, 98,
 99,100,101,102,103,104,105,106,107,108,
109,110,111,112,113,114,115,116,117,118,
119,120,121,122,123,124,125,126,127,128,
129,130,131,132,133,134,135,136,137,138,
139,140,141,142,143,144,145,146,147,148,
149,150,151,152,153,154,155,156,157,158,
159,160,161,162,163, 92, 93, 94, 95, 96,
 97, 98, 99,100,101,102,103,104,105,106,
107,108,109,110,111,112,113,114,115,116,
117,118,119,120,121,122,123,124,125,126,
127,128,129,130,131,132,133,134,135,136,
137,138,139,140,141,142,143,144,145,146,
147,148,149,150,151,152,153,154,155,156,
157,158,159,160,161,162,163,164,165,166,
 94, 95, 96, 97, 98, 99,100,101,102,103,
104,105,106,107,108,109,110,111,112,113,
114,115,116,117,118,119,120,121,122,123,
124,125,126,127,128,129,130,131,132,133,
134,135,136,137,138,139,140,141,142,143,
144,145,146,147,148,149,150,151,152,153,
154,155,156,157,158,159,160,161,162,163,
164,165,166,167,168,169, 97, 98, 99,100,
101,102,103,104,105,106,107,108,109,110,
111,112,113,114,115,116,117,118,119,120,
121,122,123,124,125,126,127,128,129,130,
131,132,133,134,135,136,137,138,139,140,
141,142,143,144,145,146,147,148,149,150,
151,152,153,154,155,156,157,158,159,160,
161,162,163,164,165,166,167,168,169,170,
171,172, 99,100,101,102,103,104,105,106,
107,108,109,110,111,112,113,114,115,116,
117,118,119,120,121,122,123,124,125,126,
127,128,129,130,131,132,133,134,135,136,
137,138,139,140,141,142,143,144,145,146,
147,148,149,150,151,152,153,154,155,156,
157,158,159,160,161,162,163,164,165,166,
167,168,169,170,171,172,173,174,175,176,
101,102,103,104,105,106,107,108,109,110,
111,112,113,114,115,116,117,118,119,120,
121,122,123,124,125,126,127,128,129,130,
131,132,133,134,135,136,137,138,139,140,
141,142,143,144,145,146,147,148,149,150,
151,152,153,154,155,156,157,158,159,160,
161,162,163,164,165,166,167,168,169,170,
171,172,173,174,175,176,177,178,179,103,
104,105,106,107,108,109,110,111,112,113,
114,115,116,117,118,119,120,121,122,123,
124,125,126,127,128,129,130,131,132,133,
134,135,136,137,138,139,140,141,142,143,
144,145,146,147,148,149,150,151,152,153,
154,155,156,157,158,159,160,161,162,163,
164,165,166,167,168,169,170,171,172,173,
174,175,176,177,178,179,180,181,182,106,
107,108,109,110,111,112,113,114,115,116,
117,118,119,120,121,122,123,124,125,126,
127,128,129,130,131,132,133,134,135,136,
137,138,139,140,141,142,143,144,145,146,
147,148,149,150,151,152,153,154,155,156,
157,158,159,160,161,162,163,164,165,166,
167,168,169,170,171,172,173,174,175,176,
177,178,179,180,181,182,183,184,185,108,
109,110,111,112,113,114,115,116,117,118,
119,120,121,122,123,124,125,126,127,128,
129,130,131,132,133,134,135,136,137,138,
139,140,141,142,143,144,145,146,147,148,
149,150,151,152,153,154,155,156,157,158,
159,160,161,162,163,164,165,166,167,168,
169,170,171,172,173,174,175,176,177,178,
179,180,181,182,183,184,185,186,187,188,
189,110,111,112,113,114,115,116,117,118,
119,120,121,122,123,124,125,126,127,128,
129,130,131,132,133,134,135,136,137,138,
139,140,141,142,143,144,145,146,147,148,
149,150,151,152,153,154,155,156,157,158,
159,160,161,162,163,164,165,166,167,168,
169,170,171,172,173,174,175,176,177,178,
179,180,181,182,183,184,185,186,187,188,
189,190,191,192,113,114,115,116,117,118,
119,120,121,122,123,124,125,126,127,128,
129,130,131,132,133,134,135,136,137,138,
139,140,141,142,143,144,145,146,147,148,
149,150,151,152,153,154,155,156,157,158,
159,160,161,162,163,164,165,166,167,168,
169,170,171,172,173,174,175,176,177,178,
179,180,181,182,183,184,185,186,187,188,
189,190,191,192,193,194,195,115,116,117,
118,119,120,121,122,123,124,125,126,127,
128,129,130,131,132,133,134,135,136,137,
138,139,140,141,142,143,144,145,146,147,
148,149,150,151,152,153,154,155,156,157,
158,159,160,161,162,163,164,165,166,167,
168,169,170,171,172,173,174,175,176,177,
178,179,180,181,182,183,184,185,186,187,
188,189,190,191,192,193,194,195,196,197,
198,118,119,120,121,122,123,124,125,126,
127,128,129,130,131,132,133,134,135,136,
137,138,139,140,141,142,143,144,145,146,
147,148,149,150,151,152,153,154,155,156,
157,158,159,160,161,162,163,164,165,166,
167,168,169,170,171,172,173,174,175,176,
177,178,179,180,181,182,183,184,185,186,
187,188,189,190,191,192,193,194,195,196,
197,198,199,200,201,120,121,122,123,124,
125,126,127,128,129,130,131,132,133,134,
135,136,137,138,139,140,141,142,143,144,
145,146,147,148,149,150,151,152,153,154,
155,156,157,158,159,160,161,162,163,164,
165,166,167,168,169,170,171,172,173,174,
175,176,177,178,179,180,181,182,183,184,
185,186,187,188,189,190,191,192,193,194,
195,196,197,198,199,200,201,202,203,204,
205,123,124,125,126,127,128,129,130,131,
132,133,134,135,136,137,138,139,140,141,
142,143,144,145,146,147,148,149,150,151,
152,153,154,155,156,157,158,159,160,161,
162,163,164,165,166,167,168,169,170,171,
172,173,174,175,176,177,178,179,180,181,
182,183,184,185,186,187,188,189,190,191,
192,193,194,195,196,197,198,199,200,201,
202,203,204,205,206,207,208,125,126,127,
128,129,130,131,132,133,134,135,136,137,
138,139,140,141,142,143,144,145,146,147,
148,149,150,151,152,153,154,155,156,157,
158,159,160,161,162,163,164,165,166,167,
168,169,170,171,172,173,174,175,176,177,
178,179,180,181,182,183,184,185,186,187,
188,189,190,191,192,193,194,195,196,197,
198,199,200,201,202,203,204,205,206,207,
208,209,210,211,128,129,130,131,132,133,
134,135,136,137,138,139,140,141,142,143,
144,145,146,147,148,149,150,151,152,153,
154,155,156,157,158,159,160,161,162,163,
164,165,166,167,168,169,170,171,172,173,
174,175,176,177,178,179,180,181,182,183,
184,185,186,187,188,189,190,191,192,193,
194,195,196,197,198,199,200,201,202,203,
204,205,206,207,208,209,210,211,212,213,
214,130,131,132,133,134,135,136,137,138,
139,140,141,142,143,144,145,146,147,148,
149,150,151,152,153,154,155,156,157,158,
159,160,161,162,163,164,165,166,167,168,
169,170,171,172,173,174,175,176,177,178,
179,180,181,182,183,184,185,186,187,188,
189,190,191,192,193,194,195,196,197,198,
199,200,201,202,203,204,205,206,207,208,
209,210,211,212,213,214,215,216,217,218,
133,134,135,136,137,138,139,140,141,142,
143,144,145,146,147,148,149,150,151,152,
153,154,155,156,157,158,159,160,161,162,
163,164,165,166,167,168,169,170,171,172,
173,174,175,176,177,178,179,180,181,182,
183,184,185,186,187,188,189,190,191,192,
193,194,195,196,197,198,199,200,201,202,
203,204,205,206,207,208,209,210,211,212,
213,214,215,216,217,218,219,220,221,136,
137,138,139,140,141,142,143,144,145,146,
147,148,149,150,151,152,153,154,155,156,
157,158,159,160,161,162,163,164,165,166,
167,168,169,170,171,172,173,174,175,176,
177,178,179,180,181,182,183,184,185,186,
187,188,189,190,191,192,193,194,195,196,
197,198,199,200,201,202,203,204,205,206,
207,208,209,210,211,212,213,214,215,216,
217,218,219,220,221,222,223,224,138,139,
140,141,142,143,144,145,146,147,148,149,
150,151,152,153,154,155,156,157,158,159,
160,161,162,163,164,165,166,167,168,169,
170,171,172,173,174,175,176,177,178,179,
180,181,182,183,184,185,186,187,188,189,
190,191,192,193,194,195,196,197,198,199,
200,201,202,203,204,205,206,207,208,209,
210,211,212,213,214,215,216,217,218,219,
220,221,222,223,224,225,226,227,141,142,
143,144,145,146,147,148,149,150,151,152,
153,154,155,156,157,158,159,160,161,162,
163,164,165,166,167,168,169,170,171,172,
173,174,175,176,177,178,179,180,181,182,
183,184,185,186,187,188,189,190,191,192,
193,194,195,196,197,198,199,200,201,202,
203,204,205,206,207,208,209,210,211,212,
213,214,215,216,217,218,219,220,221,222,
223,224,225,226,227,228,229,230,143,144,
145,146,147,148,149,150,151,152,153,154,
155,156,157,158,159,160,161,162,163,164,
165,166,167,168,169,170,171,172,173,174,
175,176,177,178,179,180,181,182,183,184,
185,186,187,188,189,190,191,192,193,194,
195,196,197,198,199,200,201,202,203,204,
205,206,207,208,209,210,211,212,213,214,
215,216,217,218,219,220,221,222,223,224,
225,226,227,228,229,230,231,232,233,234,
146,147,148,149,150,151,152,153,154,155,
156,157,158,159,160,161,162,163,164,165,
166,167,168,169,170,171,172,173,174,175,
176,177,178,179,180,181,182,183,184,185,
186,187,188,189,190,191,192,193,194,195,
196,197,198,199,200,201,202,203,204,205,
206,207,208,209,210,211,212,213,214,215,
216,217,218,219,220,221,222,223,224,225,
226,227,228,229,230,231,232,233,234,235,
236,237,149,150,151,152,153,154,155,156,
157,158,159,160,161,162,163,164,165,166,
167,168,169,170,171,172,173,174,175,176,
177,178,179,180,181,182,183,184,185,186,
187,188,189,190,191,192,193,194,195,196,
197,198,199,200,201,202,203,204,205,206,
207,208,209,210,211,212,213,214,215,216,
217,218,219,220,221,222,223,224,225,226,
227,228,229,230,231,232,233,234,235,236,
237,238,239,240,151,152,153,154,155,156,
157,158,159,160,161,162,163,164,165,166,
167,168,169,170,171,172,173,174,175,176,
177,178,179,180,181,182,183,184,185,186,
187,188,189,190,191,192,193,194,195,196,
197,198,199,200,201,202,203,204,205,206,
207,208,209,210,211,212,213,214,215,216,
217,218,219,220,221,222,223,224,225,226,
227,228,229,230,231,232,233,234,235,236,
237,238,239,240,241,242,243,154,155,156,
157,158,159,160,161,162,163,164,165,166,
167,168,169,170,171,172,173,174,175,176,
177,178,179,180,181,182,183,184,185,186,
187,188,189,190,191,192,193,194,195,196,
197,198,199,200,201,202,203,204,205,206,
207,208,209,210,211,212,213,214,215,216,
217,218,219,220,221,222,223,224,225,226,
227,228,229,230,231,232,233,234,235,236,
237,238,239,240,241,242,243,244,245,246,
247,156,157,158,159,160,161,162,163,164,
165,166,167,168,169,170,171,172,173,174,
175,176,177,178,179,180,181,182,183,184,
185,186,187,188,189,190,191,192,193,194,
195,196,197,198,199,200,201,202,203,204,
205,206,207,208,209,210,211,212,213,214,
215,216,217,218,219,220,221,222,223,224,
225,226,227,228,229,230,231,232,233,234,
235,236,237,238,239,240,241,242,243,244,
245,246,247,248,249,250,159,160,161,162,
163,164,165,166,167,168,169,170,171,172,
173,174,175,176,177,178,179,180,181,182,
183,184,185,186,187,188,189,190,191,192,
193,194,195,196,197,198,199,200,201,202,
203,204,205,206,207,208,209,210,211,212,
213,214,215,216,217,218,219,220,221,222,
223,224,225,226,227,228,229,230,231,232,
233,234,235,236,237,238,239,240,241,242,
243,244,245,246,247,248,249,250,251,252,
253,162,163,164,165,166,167,168,169,170,
171,172,173,174,175,176,177,178,179,180,
181,182,183,184,185,186,187,188,189,190,
191,192,193,194,195,196,197,198,199,200,
201,202,203,204,205,206,207,208,209,210,
211,212,213,214,215,216,217,218,219,220,
221,222,223,224,225,226,227,228,229,230,
231,232,233,234,235,236,237,238,239,240,
241,242,243,244,245,246,247,248,249,250,
251,252,253,254,255,256,165,166,167,168,
169,170,171,172,173,174,175,176,177,178,
179,180,181,182,183,184,185,186,187,188,
189,190,191,192,193,194,195,196,197,198,
199,200,201,202,203,204,205,206,207,208,
209,210,211,212,213,214,215,216,217,218,
219,220,221,222,223,224,225,226,227,228,
229,230,231,232,233,234,235,236,237,238,
239,240,241,242,243,244,245,246,247,248,
249,250,251,252,253,254,255,256,257,258,
259,260,167,168,169,170,171,172,173,174,
175,176,177,178,179,180,181,182,183,184,
185,186,187,188,189,190,191,192,193,194,
195,196,197,198,199,200,201,202,203,204,
205,206,207,208,209,210,211,212,213,214,
215,216,217,218,219,220,221,222,223,224,
225,226,227,228,229,230,231,232,233,234,
235,236,237,238,239,240,241,242,243,244,
245,246,247,248,249,250,251,252,253,254,
255,256,257,258,259,260,261,262,263,170,
171,172,173,174,175,176,177,178,179,180,
181,182,183,184,185,186,187,188,189,190,
191,192,193,194,195,196,197,198,199,200,
201,202,203,204,205,206,207,208,209,210,
211,212,213,214,215,216,217,218,219,220,
221,222,223,224,225,226,227,228,229,230,
231,232,233,234,235,236,237,238,239,240,
241,242,243,244,245,246,247,248,249,250,
251,252,253,254,255,256,257,258,259,260,
261,262,263,264,265,266,173,174,175,176,
177,178,179,180,181,182,183,184,185,186,
187,188,189,190,191,192,193,194,195,196,
197,198,199,200,201,202,203,204,205,206,
207,208,209,210,211,212,213,214,215,216,
217,218,219,220,221,222,223,224,225,226,
227,228,229,230,231,232,233,234,235,236,
237,238,239,240,241,242,243,244,245,246,
247,248,249,250,251,252,253,254,255,256,
257,258,259,260,261,262,263,264,265,266,
267,268,269,175,176,177,178,179,180,181,
182,183,184,185,186,187,188,189,190,191,
192,193,194,195,196,197,198,199,200,201,
202,203,204,205,206,207,208,209,210,211,
212,213,214,215,216,217,218,219,220,221,
222,223,224,225,226,227,228,229,230,231,
232,233,234,235,236,237,238,239,240,241,
242,243,244,245,246,247,248,249,250,251,
252,253,254,255,256,257,258,259,260,261,
262,263,264,265,266,267,268,269,270,271,
272,273,178,179,180,181,182,183,184,185,
186,187,188,189,190,191,192,193,194,195,
196,197,198,199,200,201,202,203,204,205,
206,207,208,209,210,211,212,213,214,215,
216,217,218,219,220,221,222,223,224,225,
226,227,228,229,230,231,232,233,234,235,
236,237,238,239,240,241,242,243,244,245,
246,247,248,249,250,251,252,253,254,255,
256,257,258,259,260,261,262,263,264,265,
266,267,268,269,270,271,272,273,274,275,
276,181,182,183,184,185,186,187,188,189,
190,191,192,193,194,195,196,197,198,199,
200,201,202,203,204,205,206,207,208,209,
210,211,212,213,214,215,216,217,218,219,
220,221,222,223,224,225,226,227,228,229,
230,231,232,233,234,235,236,237,238,239,
240,241,242,243,244,245,246,247,248,249,
250,251,252,253,254,255,256,257,258,259,
260,261,262,263,264,265,266,267,268,269,
270,271,272,273,274,275,276,277,278,279,
184,185,186,187,188,189,190,191,192,193,
194,195,196,197,198,199,200,201,202,203,
204,205,206,207,208,209,210,211,212,213,
214,215,216,217,218,219,220,221,222,223,
224,225,226,227,228,229,230,231,232,233,
234,235,236,237,238,239,240,241,242,243,
244,245,246,247,248,249,250,251,252,253,
254,255,256,257,258,259,260,261,262,263,
264,265,266,267,268,269,270,271,272,273,
274,275,276,277,278,279,280,281,282,186,
187,188,189,190,191,192,193,194,195,196,
197,198,199,200,201,202,203,204,205,206,
207,208,209,210,211,212,213,214,215,216,
217,218,219,220,221,222,223,224,225,226,
227,228,229,230,231,232,233,234,235,236,
237,238,239,240,241,242,243,244,245,246,
247,248,249,250,251,252,253,254,255,256,
257,258,259,260,261,262,263,264,265,266,
267,268,269,270,271,272,273,274,275,276,
277,278,279,280,281,282,283,284,285,286,
189,190,191,192,193,194,195,196,197,198,
199,200,201,202,203,204,205,206,207,208,
209,210,211,212,213,214,215,216,217,218,
219,220,221,222,223,224,225,226,227,228,
229,230,231,232,233,234,235,236,237,238,
239,240,241,242,243,244,245,246,247,248,
249,250,251,252,253,254,255,256,257,258,
259,260,261,262,263,264,265,266,267,268,
269,270,271,272,273,274,275,276,277,278,
279,280,281,282,283,284,285,286,287,288,
289,192,193,194,195,196,197,198,199,200,
201,202,203,204,205,206,207,208,209,210,
211,212,213,214,215,216,217,218,219,220,
221,222,223,224,225,226,227,228,229,230,
231,232,233,234,235,236,237,238,239,240,
241,242,243,244,245,246,247,248,249,250,
251,252,253,254,255,256,257,258,259,260,
261,262,263,264,265,266,267,268,269,270,
271,272,273,274,275,276,277,278,279,280,
281,282,283,284,285,286,287,288,289,290,
291,292,195,196,197,198,199,200,201,202,
203,204,205,206,207,208,209,210,211,212,
213,214,215,216,217,218,219,220,221,222,
223,224,225,226,227,228,229,230,231,232,
233,234,235,236,237,238,239,240,241,242,
243,244,245,246,247,248,249,250,251,252,
253,254,255,256,257,258,259,260,261,262,
263,264,265,266,267,268,269,270,271,272,
273,274,275,276,277,278,279,280,281,282,
283,284,285,286,287,288,289,290,291,292,
293,294,295,198,199,200,201,202,203,204,
205,206,207,208,209,210,211,212,213,214,
215,216,217,218,219,220,221,222,223,224,
225,226,227,228,229,230,231,232,233,234,
235,236,237,238,239,240,241,242,243,244,
245,246,247,248,249,250,251,252,253,254,
255,256,257,258,259,260,261,262,263,264,
265,266,267,268,269,270,271,272,273,274,
275,276,277,278,279,280,281,282,283,284,
285,286,287,288,289,290,291,292,293,294,
295,296,297,298,299,200,201,202,203,204,
205,206,207,208,209,210,211,212,213,214,
215,216,217,218,219,220,221,222,223,224,
225,226,227,228,229,230,231,232,233,234,
235,236,237,238,239,240,241,242,243,244,
245,246,247,248,249,250,251,252,253,254,
255,256,257,258,259,260,261,262,263,264,
265,266,267,268,269,270,271,272,273,274,
275,276,277,278,279,280,281,282,283,284,
285,286,287,288,289,290,291,292,293,294,
295,296,297,298,299,300,301,302,203,204,
205,206,207,208,209,210,211,212,213,214,
215,216,217,218,219,220,221,222,223,224,
225,226,227,228,229,230,231,232,233,234,
235,236,237,238,239,240,241,242,243,244,
245,246,247,248,249,250,251,252,253,254,
255,256,257,258,259,260,261,262,263,264,
265,266,267,268,269,270,271,272,273,274,
275,276,277,278,279,280,281,282,283,284,
285,286,287,288,289,290,291,292,293,294,
295,296,297,298,299,300,301,302,303,304,
305,206,207,208,209,210,211,212,213,214,
215,216,217,218,219,220,221,222,223,224,
225,226,227,228,229,230,231,232,233,234,
235,236,237,238,239,240,241,242,243,244,
245,246,247,248,249,250,251,252,253,254,
255,256,257,258,259,260,261,262,263,264,
265,266,267,268,269,270,271,272,273,274,
275,276,277,278,279,280,281,282,283,284,
285,286,287,288,289,290,291,292,293,294,
295,296,297,298,299,300,301,302,303,304,
305,306,307,308,209,210,211,212,213,214,
215,216,217,218,219,220,221,222,223,224,
225,226,227,228,229,230,231,232,233,234,
235,236,237,238,239,240,241,242,243,244,
245,246,247,248,249,250,251,252,253,254,
255,256,257,258,259,260,261,262,263,264,
265,266,267,268,269,270,271,272,273,274,
275,276,277,278,279,280,281,282,283,284,
285,286,287,288,289,290,291,292,293,294,
295,296,297,298,299,300,301,302,303,304,
305,306,307,308,309,310,311,312,212,213,
214,215,216,217,218,219,220,221,222,223,
224,225,226,227,228,229,230,231,232,233,
234,235,236,237,238,239,240,241,242,243,
244,245,246,247,248,249,250,251,252,253,
254,255,256,257,258,259,260,261,262,263,
264,265,266,267,268,269,270,271,272,273,
274,275,276,277,278,279,280,281,282,283,
284,285,286,287,288,289,290,291,292,293,
294,295,296,297,298,299,300,301,302,303,
304,305,306,307,308,309,310,311,312,313,
314,315,215,216,217,218,219,220,221,222,
223,224,225,226,227,228,229,230,231,232,
233,234,235,236,237,238,239,240,241,242,
243,244,245,246,247,248,249,250,251,252,
253,254,255,256,257,258,259,260,261,262,
263,264,265,266,267,268,269,270,271,272,
273,274,275,276,277,278,279,280,281,282,
283,284,285,286,287,288,289,290,291,292,
293,294,295,296,297,298,299,300,301,302,
303,304,305,306,307,308,309,310,311,312,
313,314,315,316,317,318,218,219,220,221,
222,223,224,225,226,227,228,229,230,231,
232,233,234,235,236,237,238,239,240,241,
242,243,244,245,246,247,248,249,250,251,
252,253,254,255,256,257,258,259,260,261,
262,263,264,265,266,267,268,269,270,271,
272,273,274,275,276,277,278,279,280,281,
282,283,284,285,286,287,288,289,290,291,
292,293,294,295,296,297,298,299,300,301,
302,303,304,305,306,307,308,309,310,311,
312,313,314,315,316,317,318,319,320,321,
221,222,223,224,225,226,227,228,229,230,
231,232,233,234,235,236,237,238,239,240,
241,242,243,244,245,246,247,248,249,250,
251,252,253,254,255,256,257,258,259,260,
261,262,263,264,265,266,267,268,269,270,
271,272,273,274,275,276,277,278,279,280,
281,282,283,284,285,286,287,288,289,290,
291,292,293,294,295,296,297,298,299,300,
301,302,303,304,305,306,307,308,309,310,
311,312,313,314,315,316,317,318,319,320,
321,322,323,324,325,224,225,226,227,228,
229,230,231,232,233,234,235,236,237,238,
239,240,241,242,243,244,245,246,247,248,
249,250,251,252,253,254,255,256,257,258,
259,260,261,262,263,264,265,266,267,268,
269,270,271,272,273,274,275,276,277,278,
279,280,281,282,283,284,285,286,287,288,
289,290,291,292,293,294,295,296,297,298,
299,300,301,302,303,304,305,306,307,308,
309,310,311,312,313,314,315,316,317,318,
319,320,321,322,323,324,325,326,327,328,
226,227,228,229,230,231,232,233,234,235,
236,237,238,239,240,241,242,243,244,245,
246,247,248,249,250,251,252,253,254,255,
256,257,258,259,260,261,262,263,264,265,
266,267,268,269,270,271,272,273,274,275,
276,277,278,279,280,281,282,283,284,285,
286,287,288,289,290,291,292,293,294,295,
296,297,298,299,300,301,302,303,304,305,
306,307,308,309,310,311,312,313,314,315,
316,317,318,319,320,321,322,323,324,325,
326,327,328,329,330,331,229,230,231,232,
233,234,235,236,237,238,239,240,241,242,
243,244,245,246,247,248,249,250,251,252,
253,254,255,256,257,258,259,260,261,262,
263,264,265,266,267,268,269,270,271,272,
273,274,275,276,277,278,279,280,281,282,
283,284,285,286,287,288,289,290,291,292,
293,294,295,296,297,298,299,300,301,302,
303,304,305,306,307,308,309,310,311,312,
313,314,315,316,317,318,319,320,321,322,
323,324,325,326,327,328,329,330,331,332,
333,334,232,233,234,235,236,237,238,239,
240,241,242,243,244,245,246,247,248,249,
250,251,252,253,254,255,256,257,258,259,
260,261,262,263,264,265,266,267,268,269,
270,271,272,273,274,275,276,277,278,279,
280,281,282,283,284,285,286,287,288,289,
290,291,292,293,294,295,296,297,298,299,
300,301,302,303,304,305,306,307,308,309,
310,311,312,313,314,315,316,317,318,319,
320,321,322,323,324,325,326,327,328,329,
330,331,332,333,334,335,336,337,338,235,
236,237,238,239,240,241,242,243,244,245,
246,247,248,249,250,251,252,253,254,255,
256,257,258,259,260,261,262,263,264,265,
266,267,268,269,270,271,272,273,274,275,
276,277,278,279,280,281,282,283,284,285,
286,287,288,289,290,291,292,293,294,295,
296,297,298,299,300,301,302,303,304,305,
306,307,308,309,310,311,312,313,314,315,
316,317,318,319,320,321,322,323,324,325,
326,327,328,329,330,331,332,333,334,335,
336,337,338,339,238,239,240,241,242,243,
244,245,246,247,248,249,250,251,252,253,
254,255,256,257,258,259,260,261,262,263,
264,265,266,267,268,269,270,271,272,273,
274,275,276,277,278,279,280,281,282,283,
284,285,286,287,288,289,290,291,292,293,
294,295,296,297,298,299,300,301,302,303,
304,305,306,307,308,309,310,311,312,313,
314,315,316,317,318,319,320,321,322,323,
324,325,326,327,328,329,330,331,332,333,
334,335,336,337,338,339,241,242,243,244,
245,246,247,248,249,250,251,252,253,254,
255,256,257,258,259,260,261,262,263,264,
265,266,267,268,269,270,271,272,273,274,
275,276,277,278,279,280,281,282,283,284,
285,286,287,288,289,290,291,292,293,294,
295,296,297,298,299,300,301,302,303,304,
305,306,307,308,309,310,311,312,313,314,
315,316,317,318,319,320,321,322,323,324,
325,326,327,328,329,330,331,332,333,334,
335,336,337,338,339,244,245,246,247,248,
249,250,251,252,253,254,255,256,257,258,
259,260,261,262,263,264,265,266,267,268,
269,270,271,272,273,274,275,276,277,278,
279,280,281,282,283,284,285,286,287,288,
289,290,291,292,293,294,295,296,297,298,
299,300,301,302,303,304,305,306,307,308,
309,310,311,312,313,314,315,316,317,318,
319,320,321,322,323,324,325,326,327,328,
329,330,331,332,333,334,335,336,337,338,
339,247,248,249,250,251,252,253,254,255,
256,257,258,259,260,261,262,263,264,265,
266,267,268,269,270,271,272,273,274,275,
276,277,278,279,280,281,282,283,284,285,
286,287,288,289,290,291,292,293,294,295,
296,297,298,299,300,301,302,303,304,305,
306,307,308,309,310,311,312,313,314,315,
316,317,318,319,320,321,322,323,324,325,
326,327,328,329,330,331,332,333,334,335,
336,337,338,339,250,251,252,253,254,255,
256,257,258,259,260,261,262,263,264,265,
266,267,268,269,270,271,272,273,274,275,
276,277,278,279,280,281,282,283,284,285,
286,287,288,289,290,291,292,293,294,295,
296,297,298,299,300,301,302,303,304,305,
306,307,308,309,310,311,312,313,314,315,
316,317,318,319,320,321,322,323,324,325,
326,327,328,329,330,331,332,333,334,335,
336,337,338,339,253,254,255,256,257,258,
259,260,261,262,263,264,265,266,267,268,
269,270,271,272,273,274,275,276,277,278,
279,280,281,282,283,284,285,286,287,288,
289,290,291,292,293,294,295,296,297,298,
299,300,301,302,303,304,305,306,307,308,
309,310,311,312,313,314,315,316,317,318,
319,320,321,322,323,324,325,326,327,328,
329,330,331,332,333,334,335,336,337,338,
339,256,257,258,259,260,261,262,263,264,
265,266,267,268,269,270,271,272,273,274,
275,276,277,278,279,280,281,282,283,284,
285,286,287,288,289,290,291,292,293,294,
295,296,297,298,299,300,301,302,303,304,
305,306,307,308,309,310,311,312,313,314,
315,316,317,318,319,320,321,322,323,324,
325,326,327,328,329,330,331,332,333,334,
335,336,337,338,339,259,260,261,262,263,
264,265,266,267,268,269,270,271,272,273,
274,275,276,277,278,279,280,281,282,283,
284,285,286,287,288,289,290,291,292,293,
294,295,296,297,298,299,300,301,302,303,
304,305,306,307,308,309,310,311,312,313,
314,315,316,317,318,319,320,321,322,323,
324,325,326,327,328,329,330,331,332,333,
334,335,336,337,338,339,262,263,264,265,
266,267,268,269,270,271,272,273,274,275,
276,277,278,279,280,281,282,283,284,285,
286,287,288,289,290,291,292,293,294,295,
296,297,298,299,300,301,302,303,304,305,
306,307,308,309,310,311,312,313,314,315,
316,317,318,319,320,321,322,323,324,325,
326,327,328,329,330,331,332,333,334,335,
336,337,338,339,266,267,268,269,270,271,
272,273,274,275,276,277,278,279,280,281,
282,283,284,285,286,287,288,289,290,291,
292,293,294,295,296,297,298,299,300,301,
302,303,304,305,306,307,308,309,310,311,
312,313,314,315,316,317,318,319,320,321,
322,323,324,325,326,327,328,329,330,331,
332,333,334,335,336,337,338,339,269,270,
271,272,273,274,275,276,277,278,279,280,
281,282,283,284,285,286,287,288,289,290,
291,292,293,294,295,296,297,298,299,300,
301,302,303,304,305,306,307,308,309,310,
311,312,313,314,315,316,317,318,319,320,
321,322,323,324,325,326,327,328,329,330,
331,332,333,334,335,336,337,338,339,272,
273,274,275,276,277,278,279,280,281,282,
283,284,285,286,287,288,289,290,291,292,
293,294,295,296,297,298,299,300,301,302,
303,304,305,306,307,308,309,310,311,312,
313,314,315,316,317,318,319,320,321,322,
323,324,325,326,327,328,329,330,331,332,
333,334,335,336,337,338,339,275,276,277,
278,279,280,281,282,283,284,285,286,287,
288,289,290,291,292,293,294,295,296,297,
298,299,300,301,302,303,304,305,306,307,
308,309,310,311,312,313,314,315,316,317,
318,319,320,321,322,323,324,325,326,327,
328,329,330,331,332,333,334,335,336,337,
338,339,278,279,280,281,282,283,284,285,
286,287,288,289,290,291,292,293,294,295,
296,297,298,299,300,301,302,303,304,305,
306,307,308,309,310,311,312,313,314,315,
316,317,318,319,320,321,322,323,324,325,
326,327,328,329,330,331,332,333,334,335,
336,337,338,339,281,282,283,284,285,286,
287,288,289,290,291,292,293,294,295,296,
297,298,299,300,301,302,303,304,305,306,
307,308,309,310,311,312,313,314,315,316,
317,318,319,320,321,322,323,324,325,326,
327,328,329,330,331,332,333,334,335,336,
337,338,339,284,285,286,287,288,289,290,
291,292,293,294,295,296,297,298,299,300,
301,302,303,304,305,306,307,308,309,310,
311,312,313,314,315,316,317,318,319,320,
321,322,323,324,325,326,327,328,329,330,
331,332,333,334,335,336,337,338,339,287,
288,289,290,291,292,293,294,295,296,297,
298,299,300,301,302,303,304,305,306,307,
308,309,310,311,312,313,314,315,316,317,
318,319,320,321,322,323,324,325,326,327,
328,329,330,331,332,333,334,335,336,337,
338,339,290,291,292,293,294,295,296,297,
298,299,300,301,302,303,304,305,306,307,
308,309,310,311,312,313,314,315,316,317,
318,319,320,321,322,323,324,325,326,327,
328,329,330,331,332,333,334,335,336,337,
338,339,294,295,296,297,298,299,300,301,
302,303,304,305,306,307,308,309,310,311,
312,313,314,315,316,317,318,319,320,321,
322,323,324,325,326,327,328,329,330,331,
332,333,334,335,336,337,338,339,297,298,
299,300,301,302,303,304,305,306,307,308,
309,310,311,312,313,314,315,316,317,318,
319,320,321,322,323,324,325,326,327,328,
329,330,331,332,333,334,335,336,337,338,
339,300,301,302,303,304,305,306,307,308,
309,310,311,312,313,314,315,316,317,318,
319,320,321,322,323,324,325,326,327,328,
329,330,331,332,333,334,335,336,337,338,
339,303,304,305,306,307,308,309,310,311,
312,313,314,315,316,317,318,319,320,321,
322,323,324,325,326,327,328,329,330,331,
332,333,334,335,336,337,338,339,306,307,
308,309,310,311,312,313,314,315,316,317,
318,319,320,321,322,323,324,325,326,327,
328,329,330,331,332,333,334,335,336,337,
338,339,310,311,312,313,314,315,316,317,
318,319,320,321,322,323,324,325,326,327,
328,329,330,331,332,333,334,335,336,337,
338,339,313,314,315,316,317,318,319,320,
321,322,323,324,325,326,327,328,329,330,
331,332,333,334,335,336,337,338,339,316,
317,318,319,320,321,322,323,324,325,326,
327,328,329,330,331,332,333,334,335,336,
337,338,339,319,320,321,322,323,324,325,
326,327,328,329,330,331,332,333,334,335,
336,337,338,339,323,324,325,326,327,328,
329,330,331,332,333,334,335,336,337,338,
339,326,327,328,329,330,331,332,333,334,
335,336,337,338,339,329,330,331,332,333,
334,335,336,337,338,339,332,333,334,335,
336,337,338,339,336,337,338,339,339
  }
};
