// neutron_hp -- source file
// J.P. Wellisch, Nov-1996
// A prototype of the low energy neutron transport model.
#include "G4NeutronHPFastLegendre.hh"

G4double
  G4NeutronHPFastLegendre::l14[3001] = {1, 0.931204, 0.864781,
  0.800676, 0.738836, 0.679211, 0.621748, 0.566398, 0.513111,
  0.461839, 0.412535, 0.36515, 0.319639, 0.275958, 0.23406, 0.193903,
  0.155444, 0.11864, 0.0834497, 0.0498324, 0.017748, -0.0128428,
  -0.0419788, -0.0696977, -0.0960371, -0.121033, -0.144723, -0.16714,
  -0.18832, -0.208297, -0.227105, -0.244775, -0.261341, -0.276833,
  -0.291284, -0.304722, -0.317178, -0.328681, -0.33926, -0.348943,
  -0.357758, -0.365731, -0.372889, -0.379258, -0.384863, -0.38973,
  -0.393883, -0.397346, -0.400142, -0.402294, -0.403825, -0.404757,
  -0.405111, -0.404909, -0.404172, -0.402919, -0.40117, -0.398945,
  -0.396263, -0.393143, -0.389602, -0.385658, -0.381329, -0.376631,
  -0.371582, -0.366198, -0.360493, -0.354485, -0.348187, -0.341615,
  -0.334783, -0.327705, -0.320396, -0.312867, -0.305134, -0.297207,
  -0.2891, -0.280825, -0.272393, -0.263816, -0.255106, -0.246273,
  -0.237328, -0.228282, -0.219144, -0.209924, -0.200632, -0.191277,
  -0.181868, -0.172414, -0.162923, -0.153404, -0.143865, -0.134314,
  -0.124757, -0.115203, -0.105658, -0.0961304, -0.0866255, -0.0771502,
  -0.0677107, -0.0583131, -0.0489633, -0.0396669, -0.0304293,
  -0.0212558, -0.0121515, -0.00312135, 0.00583006, 0.0146981,
  0.0234785, 0.032167, 0.0407596, 0.0492525, 0.0576418, 0.0659241,
  0.0740961, 0.0821543, 0.0900959, 0.0979177, 0.105617, 0.113191,
  0.120638, 0.127954, 0.135138, 0.142188, 0.149101, 0.155876, 0.16251,
  0.169003, 0.175352, 0.181557, 0.187615, 0.193527, 0.199289,
  0.204903, 0.210365, 0.215677, 0.220837, 0.225845, 0.230699, 0.2354,
  0.239947, 0.244341, 0.24858, 0.252664, 0.256594, 0.26037, 0.263992,
  0.267459, 0.270773, 0.273933, 0.27694, 0.279795, 0.282498, 0.285049,
  0.287449, 0.289699, 0.2918, 0.293752, 0.295556, 0.297214, 0.298726,
  0.300093, 0.301316, 0.302396, 0.303336, 0.304134, 0.304794,
  0.305316, 0.305701, 0.305951, 0.306067, 0.306051, 0.305904,
  0.305627, 0.305223, 0.304692, 0.304036, 0.303256, 0.302355,
  0.301334, 0.300195, 0.298938, 0.297567, 0.296082, 0.294486, 0.29278,
  0.290965, 0.289045, 0.28702, 0.284892, 0.282663, 0.280336, 0.277911,
  0.27539, 0.272777, 0.270071, 0.267276, 0.264393, 0.261424, 0.258372,
  0.255236, 0.252021, 0.248727, 0.245357, 0.241913, 0.238396,
  0.234808, 0.231151, 0.227427, 0.223639, 0.219787, 0.215874,
  0.211902, 0.207873, 0.203788, 0.199649, 0.195459, 0.191219,
  0.186931, 0.182596, 0.178218, 0.173797, 0.169335, 0.164835,
  0.160297, 0.155725, 0.151119, 0.146481, 0.141814, 0.137118,
  0.132396, 0.12765, 0.122881, 0.11809, 0.11328, 0.108452, 0.103608,
  0.0987501, 0.0938789, 0.0889965, 0.0841045, 0.0792044, 0.074298,
  0.0693867, 0.0644721, 0.0595557, 0.054639, 0.0497235, 0.0448108,
  0.0399022, 0.0349992, 0.0301033, 0.0252158, 0.0203382, 0.0154718,
  0.010618, 0.00577811, 0.000953485, -0.00385458, -0.00864481,
  -0.0134159, -0.0181667, -0.0228958, -0.0276022, -0.0322846,
  -0.0369418, -0.0415726, -0.0461761, -0.0507509, -0.0552961,
  -0.0598105, -0.0642931, -0.0687428, -0.0731586, -0.0775396,
  -0.0818847, -0.086193, -0.0904635, -0.0946953, -0.0988875,
  -0.103039, -0.10715, -0.111218, -0.115243, -0.119224, -0.123161,
  -0.127052, -0.130897, -0.134695, -0.138446, -0.142148, -0.145801,
  -0.149405, -0.152958, -0.156461, -0.159911, -0.16331, -0.166656,
  -0.169949, -0.173189, -0.176373, -0.179504, -0.182579, -0.185598,
  -0.188561, -0.191468, -0.194318, -0.19711, -0.199845, -0.202521,
  -0.20514, -0.207699, -0.2102, -0.212641, -0.215023, -0.217345,
  -0.219607, -0.221808, -0.22395, -0.22603, -0.22805, -0.230009,
  -0.231906, -0.233743, -0.235518, -0.237231, -0.238883, -0.240474,
  -0.242003, -0.24347, -0.244876, -0.24622, -0.247502, -0.248722,
  -0.249881, -0.250979, -0.252015, -0.252989, -0.253903, -0.254754,
  -0.255545, -0.256275, -0.256944, -0.257553, -0.258101, -0.258588,
  -0.259016, -0.259383, -0.259691, -0.259939, -0.260128, -0.260258,
  -0.26033, -0.260343, -0.260297, -0.260194, -0.260033, -0.259815,
  -0.25954, -0.259209, -0.258821, -0.258377, -0.257877, -0.257323,
  -0.256713, -0.25605, -0.255332, -0.25456, -0.253736, -0.252858,
  -0.251928, -0.250947, -0.249913, -0.248829, -0.247694, -0.24651,
  -0.245275, -0.243992, -0.242659, -0.241279, -0.239851, -0.238376,
  -0.236855, -0.235287, -0.233674, -0.232015, -0.230312, -0.228566,
  -0.226776, -0.224943, -0.223067, -0.221151, -0.219192, -0.217194,
  -0.215155, -0.213077, -0.21096, -0.208805, -0.206613, -0.204383,
  -0.202117, -0.199814, -0.197477, -0.195105, -0.192699, -0.19026,
  -0.187788, -0.185284, -0.182748, -0.180181, -0.177584, -0.174958,
  -0.172302, -0.169618, -0.166907, -0.164168, -0.161403, -0.158611,
  -0.155795, -0.152954, -0.150089, -0.147201, -0.144291, -0.141358,
  -0.138404, -0.135429, -0.132435, -0.12942, -0.126387, -0.123336,
  -0.120268, -0.117182, -0.114081, -0.110964, -0.107831, -0.104685,
  -0.101525, -0.0983521, -0.0951667, -0.0919696, -0.0887614,
  -0.0855427, -0.0823141, -0.0790764, -0.0758301, -0.0725757,
  -0.0693141, -0.0660457, -0.0627713, -0.0594913, -0.0562064,
  -0.0529173, -0.0496246, -0.0463287, -0.0430305, -0.0397304,
  -0.036429, -0.0331269, -0.0298248, -0.0265232, -0.0232227,
  -0.0199239, -0.0166274, -0.0133337, -0.0100434, -0.00675703,
  -0.00347523, -0.000198532, 0.00307252, 0.00633737, 0.00959546,
  0.0128463, 0.0160892, 0.0193238, 0.0225495, 0.0257658, 0.0289721,
  0.0321679, 0.0353527, 0.038526, 0.0416874, 0.0448362, 0.047972,
  0.0510944, 0.0542027, 0.0572966, 0.0603755, 0.0634391, 0.0664867,
  0.069518, 0.0725325, 0.0755298, 0.0785093, 0.0814707, 0.0844136,
  0.0873374, 0.0902417, 0.0931262, 0.0959904, 0.098834, 0.101656,
  0.104457, 0.107236, 0.109993, 0.112727, 0.115438, 0.118126, 0.12079,
  0.123429, 0.126044, 0.128635, 0.1312, 0.133739, 0.136253, 0.138741,
  0.141202, 0.143636, 0.146043, 0.148422, 0.150774, 0.153097,
  0.155393, 0.157659, 0.159897, 0.162106, 0.164285, 0.166434,
  0.168554, 0.170643, 0.172702, 0.17473, 0.176727, 0.178693, 0.180628,
  0.182531, 0.184403, 0.186242, 0.188049, 0.189824, 0.191567,
  0.193276, 0.194953, 0.196597, 0.198207, 0.199784, 0.201327,
  0.202837, 0.204313, 0.205755, 0.207163, 0.208537, 0.209876,
  0.211182, 0.212452, 0.213688, 0.214889, 0.216055, 0.217187,
  0.218283, 0.219345, 0.220371, 0.221363, 0.222319, 0.223239,
  0.224125, 0.224975, 0.22579, 0.226569, 0.227313, 0.228022, 0.228695,
  0.229332, 0.229934, 0.230501, 0.231032, 0.231528, 0.231988,
  0.232413, 0.232803, 0.233157, 0.233476, 0.23376, 0.234009, 0.234223,
  0.234401, 0.234544, 0.234653, 0.234727, 0.234765, 0.23477, 0.234739,
  0.234674, 0.234575, 0.234441, 0.234273, 0.234071, 0.233835,
  0.233565, 0.233262, 0.232924, 0.232554, 0.23215, 0.231712, 0.231242,
  0.230739, 0.230203, 0.229634, 0.229033, 0.2284, 0.227734, 0.227037,
  0.226308, 0.225547, 0.224755, 0.223932, 0.223077, 0.222192,
  0.221277, 0.22033, 0.219354, 0.218348, 0.217312, 0.216246, 0.215151,
  0.214027, 0.212873, 0.211692, 0.210481, 0.209243, 0.207977,
  0.206683, 0.205361, 0.204012, 0.202636, 0.201234, 0.199805,
  0.198349, 0.196868, 0.195361, 0.193829, 0.192271, 0.190689,
  0.189082, 0.18745, 0.185795, 0.184116, 0.182413, 0.180687, 0.178938,
  0.177167, 0.175373, 0.173557, 0.171719, 0.16986, 0.16798, 0.166078,
  0.164157, 0.162215, 0.160253, 0.158271, 0.15627, 0.15425, 0.152212,
  0.150154, 0.148079, 0.145986, 0.143876, 0.141748, 0.139604,
  0.137443, 0.135266, 0.133073, 0.130865, 0.128642, 0.126403, 0.12415,
  0.121883, 0.119602, 0.117307, 0.115, 0.112679, 0.110346, 0.108,
  0.105643, 0.103274, 0.100893, 0.0985024, 0.0961008, 0.0936889,
  0.0912671, 0.0888358, 0.0863953, 0.0839459, 0.081488, 0.0790218,
  0.0765478, 0.0740663, 0.0715775, 0.0690819, 0.0665798, 0.0640714,
  0.0615572, 0.0590375, 0.0565126, 0.0539829, 0.0514486, 0.0489101,
  0.0463678, 0.043822, 0.041273, 0.0387212, 0.0361668, 0.0336102,
  0.0310518, 0.0284918, 0.0259307, 0.0233686, 0.0208061, 0.0182432,
  0.0156805, 0.0131182, 0.0105567, 0.00799625, 0.00543717, 0.00287981,
  0.000324482, -0.0022285, -0.00477882, -0.00732616, -0.0098702,
  -0.0124106, -0.0149472, -0.0174794, -0.0200072, -0.0225301,
  -0.0250479, -0.0275602, -0.0300667, -0.0325672, -0.0350613,
  -0.0375488, -0.0400293, -0.0425026, -0.0449683, -0.0474262,
  -0.049876, -0.0523173, -0.05475, -0.0571736, -0.059588, -0.0619929,
  -0.064388, -0.0667729, -0.0691474, -0.0715114, -0.0738644,
  -0.0762062, -0.0785365, -0.0808551, -0.0831618, -0.0854562,
  -0.087738, -0.0900072, -0.0922633, -0.0945061, -0.0967355,
  -0.098951, -0.101153, -0.10334, -0.105513, -0.107671, -0.109814,
  -0.111942, -0.114054, -0.116151, -0.118232, -0.120297, -0.122345,
  -0.124377, -0.126393, -0.128391, -0.130372, -0.132335, -0.134281,
  -0.13621, -0.13812, -0.140012, -0.141885, -0.14374, -0.145577,
  -0.147394, -0.149192, -0.150971, -0.15273, -0.154469, -0.156189,
  -0.157888, -0.159568, -0.161227, -0.162865, -0.164483, -0.166079,
  -0.167655, -0.16921, -0.170743, -0.172255, -0.173745, -0.175214,
  -0.17666, -0.178085, -0.179487, -0.180867, -0.182225, -0.18356,
  -0.184872, -0.186162, -0.187429, -0.188672, -0.189893, -0.19109,
  -0.192264, -0.193415, -0.194542, -0.195646, -0.196725, -0.197781,
  -0.198813, -0.199821, -0.200806, -0.201765, -0.202701, -0.203612,
  -0.204499, -0.205362, -0.2062, -0.207014, -0.207803, -0.208567,
  -0.209307, -0.210022, -0.210712, -0.211377, -0.212017, -0.212633,
  -0.213223, -0.213789, -0.214329, -0.214845, -0.215335, -0.2158,
  -0.216241, -0.216656, -0.217046, -0.21741, -0.21775, -0.218065,
  -0.218354, -0.218618, -0.218857, -0.219071, -0.21926, -0.219424,
  -0.219563, -0.219676, -0.219765, -0.219828, -0.219867, -0.21988,
  -0.219869, -0.219833, -0.219771, -0.219685, -0.219575, -0.219439,
  -0.219279, -0.219094, -0.218885, -0.218651, -0.218393, -0.21811,
  -0.217803, -0.217471, -0.217116, -0.216736, -0.216332, -0.215904,
  -0.215453, -0.214977, -0.214478, -0.213955, -0.213409, -0.212839,
  -0.212246, -0.211629, -0.210989, -0.210326, -0.209641, -0.208932,
  -0.2082, -0.207446, -0.206669, -0.20587, -0.205049, -0.204205,
  -0.20334, -0.202452, -0.201542, -0.200611, -0.199658, -0.198684,
  -0.197688, -0.196672, -0.195634, -0.194575, -0.193496, -0.192396,
  -0.191275, -0.190134, -0.188973, -0.187792, -0.186591, -0.18537,
  -0.18413, -0.18287, -0.181592, -0.180294, -0.178977, -0.177641,
  -0.176287, -0.174914, -0.173523, -0.172114, -0.170687, -0.169243,
  -0.16778, -0.166301, -0.164804, -0.16329, -0.161759, -0.160212,
  -0.158648, -0.157068, -0.155472, -0.15386, -0.152232, -0.150589,
  -0.148931, -0.147257, -0.145568, -0.143865, -0.142147, -0.140414,
  -0.138668, -0.136908, -0.135134, -0.133346, -0.131545, -0.129731,
  -0.127904, -0.126064, -0.124212, -0.122348, -0.120471, -0.118583,
  -0.116683, -0.114771, -0.112848, -0.110915, -0.10897, -0.107015,
  -0.10505, -0.103074, -0.101089, -0.0990934, -0.0970887, -0.0950748,
  -0.0930519, -0.0910201, -0.0889798, -0.086931, -0.0848742,
  -0.0828094, -0.080737, -0.078657, -0.0765699, -0.0744757,
  -0.0723747, -0.0702672, -0.0681533, -0.0660333, -0.0639075,
  -0.061776, -0.0596391, -0.0574969, -0.0553498, -0.053198,
  -0.0510417, -0.0488811, -0.0467164, -0.0445479, -0.0423758,
  -0.0402004, -0.0380218, -0.0358403, -0.0336561, -0.0314695,
  -0.0292807, -0.0270899, -0.0248973, -0.0227032, -0.0205078,
  -0.0183113, -0.0161139, -0.013916, -0.0117176, -0.00951913,
  -0.00732067, -0.00512251, -0.00292486, -0.000727956, 0.00146799,
  0.00366274, 0.00585607, 0.00804777, 0.0102376, 0.0124254, 0.0146108,
  0.0167937, 0.0189739, 0.021151, 0.023325, 0.0254956, 0.0276626,
  0.0298257, 0.0319847, 0.0341394, 0.0362897, 0.0384352, 0.0405758,
  0.0427112, 0.0448413, 0.0469658, 0.0490846, 0.0511973, 0.0533039,
  0.055404, 0.0574975, 0.0595842, 0.0616639, 0.0637363, 0.0658013,
  0.0678586, 0.0699081, 0.0719495, 0.0739827, 0.0760075, 0.0780236,
  0.0800308, 0.0820291, 0.0840181, 0.0859976, 0.0879676, 0.0899278,
  0.0918779, 0.0938179, 0.0957475, 0.0976665, 0.0995749, 0.101472,
  0.103359, 0.105234, 0.107097, 0.108949, 0.110789, 0.112617,
  0.114433, 0.116236, 0.118028, 0.119806, 0.121571, 0.123324,
  0.125063, 0.126789, 0.128502, 0.1302, 0.131885, 0.133556, 0.135213,
  0.136856, 0.138484, 0.140097, 0.141696, 0.14328, 0.144849, 0.146402,
  0.14794, 0.149463, 0.15097, 0.152462, 0.153937, 0.155397, 0.15684,
  0.158267, 0.159678, 0.161072, 0.16245, 0.16381, 0.165154, 0.166481,
  0.16779, 0.169083, 0.170358, 0.171615, 0.172855, 0.174077, 0.175281,
  0.176467, 0.177636, 0.178786, 0.179918, 0.181031, 0.182126,
  0.183203, 0.184261, 0.1853, 0.18632, 0.187322, 0.188304, 0.189268,
  0.190212, 0.191137, 0.192043, 0.19293, 0.193797, 0.194644, 0.195472,
  0.19628, 0.197069, 0.197837, 0.198586, 0.199315, 0.200024, 0.200713,
  0.201382, 0.202031, 0.202659, 0.203268, 0.203856, 0.204423,
  0.204971, 0.205498, 0.206004, 0.20649, 0.206956, 0.207401, 0.207825,
  0.208229, 0.208612, 0.208975, 0.209317, 0.209638, 0.209939,
  0.210218, 0.210477, 0.210716, 0.210933, 0.21113, 0.211306, 0.211461,
  0.211595, 0.211709, 0.211802, 0.211874, 0.211925, 0.211955,
  0.211965, 0.211954, 0.211922, 0.21187, 0.211797, 0.211703, 0.211588,
  0.211453, 0.211298, 0.211121, 0.210924, 0.210707, 0.210469,
  0.210211, 0.209932, 0.209633, 0.209313, 0.208974, 0.208614,
  0.208233, 0.207833, 0.207412, 0.206972, 0.206511, 0.206031,
  0.205531, 0.20501, 0.20447, 0.203911, 0.203331, 0.202732, 0.202114,
  0.201476, 0.200819, 0.200142, 0.199447, 0.198732, 0.197998,
  0.197245, 0.196473, 0.195682, 0.194873, 0.194045, 0.193199,
  0.192334, 0.19145, 0.190549, 0.189629, 0.188691, 0.187735, 0.186761,
  0.18577, 0.18476, 0.183733, 0.182689, 0.181628, 0.180549, 0.179453,
  0.17834, 0.17721, 0.176063, 0.174899, 0.17372, 0.172523, 0.17131,
  0.170081, 0.168836, 0.167576, 0.166299, 0.165006, 0.163698,
  0.162375, 0.161036, 0.159683, 0.158314, 0.15693, 0.155531, 0.154118,
  0.152691, 0.151249, 0.149793, 0.148323, 0.146839, 0.145341, 0.14383,
  0.142305, 0.140767, 0.139216, 0.137652, 0.136075, 0.134485,
  0.132883, 0.131268, 0.129642, 0.128003, 0.126352, 0.12469, 0.123016,
  0.12133, 0.119634, 0.117926, 0.116207, 0.114478, 0.112738, 0.110988,
  0.109227, 0.107456, 0.105676, 0.103886, 0.102086, 0.100277,
  0.0984582, 0.0966308, 0.0947945, 0.0929496, 0.0910961, 0.0892344,
  0.0873645, 0.0854867, 0.083601, 0.0817078, 0.0798071, 0.0778992,
  0.0759843, 0.0740625, 0.072134, 0.0701989, 0.0682576, 0.0663101,
  0.0643567, 0.0623975, 0.0604327, 0.0584626, 0.0564872, 0.0545068,
  0.0525216, 0.0505317, 0.0485374, 0.0465388, 0.0445362, 0.0425296,
  0.0405194, 0.0385056, 0.0364886, 0.0344684, 0.0324452, 0.0304194,
  0.0283909, 0.0263601, 0.0243271, 0.0222922, 0.0202554, 0.0182171,
  0.0161773, 0.0141364, 0.0120944, 0.0100515, 0.00800804, 0.00596411,
  0.00391992, 0.00187566, -0.000168475, -0.0022123, -0.00425561,
  -0.00629823, -0.00833997, -0.0103806, -0.01242, -0.014458,
  -0.0164942, -0.0185287, -0.0205611, -0.0225913, -0.0246191,
  -0.0266443, -0.0286667, -0.0306862, -0.0327025, -0.0347154,
  -0.0367249, -0.0387306, -0.0407323, -0.04273, -0.0447235,
  -0.0467124, -0.0486968, -0.0506763, -0.0526507, -0.05462,
  -0.0565839, -0.0585423, -0.0604949, -0.0624416, -0.0643822,
  -0.0663165, -0.0682443, -0.0701655, -0.0720799, -0.0739873,
  -0.0758876, -0.0777805, -0.0796658, -0.0815435, -0.0834134,
  -0.0852751, -0.0871287, -0.0889739, -0.0908106, -0.0926385,
  -0.0944576, -0.0962676, -0.0980684, -0.0998598, -0.101642,
  -0.103414, -0.105176, -0.106928, -0.10867, -0.110402, -0.112123,
  -0.113834, -0.115533, -0.117222, -0.118899, -0.120566, -0.12222,
  -0.123864, -0.125495, -0.127115, -0.128722, -0.130317, -0.1319,
  -0.133471, -0.135029, -0.136574, -0.138106, -0.139625, -0.141131,
  -0.142623, -0.144102, -0.145568, -0.14702, -0.148457, -0.149881,
  -0.151291, -0.152687, -0.154068, -0.155434, -0.156786, -0.158123,
  -0.159446, -0.160753, -0.162045, -0.163322, -0.164584, -0.16583,
  -0.167061, -0.168275, -0.169474, -0.170658, -0.171825, -0.172976,
  -0.17411, -0.175229, -0.176331, -0.177416, -0.178485, -0.179537,
  -0.180572, -0.181591, -0.182592, -0.183576, -0.184543, -0.185493,
  -0.186425, -0.18734, -0.188237, -0.189117, -0.189979, -0.190823,
  -0.191649, -0.192458, -0.193248, -0.19402, -0.194774, -0.19551,
  -0.196228, -0.196927, -0.197608, -0.198271, -0.198915, -0.19954,
  -0.200147, -0.200734, -0.201304, -0.201854, -0.202386, -0.202898,
  -0.203392, -0.203866, -0.204322, -0.204759, -0.205176, -0.205574,
  -0.205953, -0.206313, -0.206654, -0.206975, -0.207277, -0.20756,
  -0.207823, -0.208067, -0.208291, -0.208496, -0.208681, -0.208847,
  -0.208994, -0.209121, -0.209228, -0.209316, -0.209385, -0.209434,
  -0.209463, -0.209473, -0.209463, -0.209434, -0.209385, -0.209316,
  -0.209228, -0.209121, -0.208994, -0.208847, -0.208681, -0.208496,
  -0.208291, -0.208067, -0.207823, -0.20756, -0.207277, -0.206975,
  -0.206654, -0.206313, -0.205953, -0.205574, -0.205176, -0.204759,
  -0.204322, -0.203866, -0.203392, -0.202898, -0.202386, -0.201854,
  -0.201304, -0.200734, -0.200147, -0.19954, -0.198915, -0.198271,
  -0.197608, -0.196927, -0.196228, -0.19551, -0.194774, -0.19402,
  -0.193248, -0.192458, -0.191649, -0.190823, -0.189979, -0.189117,
  -0.188237, -0.18734, -0.186425, -0.185493, -0.184543, -0.183576,
  -0.182592, -0.181591, -0.180572, -0.179537, -0.178485, -0.177416,
  -0.176331, -0.175229, -0.17411, -0.172976, -0.171825, -0.170658,
  -0.169474, -0.168275, -0.167061, -0.16583, -0.164584, -0.163322,
  -0.162045, -0.160753, -0.159446, -0.158123, -0.156786, -0.155434,
  -0.154068, -0.152687, -0.151291, -0.149881, -0.148457, -0.14702,
  -0.145568, -0.144102, -0.142623, -0.141131, -0.139625, -0.138106,
  -0.136574, -0.135029, -0.133471, -0.1319, -0.130317, -0.128722,
  -0.127115, -0.125495, -0.123864, -0.12222, -0.120566, -0.118899,
  -0.117222, -0.115533, -0.113834, -0.112123, -0.110402, -0.10867,
  -0.106928, -0.105176, -0.103414, -0.101642, -0.0998598, -0.0980684,
  -0.0962676, -0.0944576, -0.0926385, -0.0908106, -0.0889739,
  -0.0871287, -0.0852751, -0.0834134, -0.0815435, -0.0796658,
  -0.0777805, -0.0758876, -0.0739873, -0.0720799, -0.0701655,
  -0.0682443, -0.0663165, -0.0643822, -0.0624416, -0.0604949,
  -0.0585423, -0.0565839, -0.05462, -0.0526507, -0.0506763,
  -0.0486968, -0.0467124, -0.0447235, -0.04273, -0.0407323,
  -0.0387306, -0.0367249, -0.0347154, -0.0327025, -0.0306862,
  -0.0286667, -0.0266443, -0.0246191, -0.0225913, -0.0205611,
  -0.0185287, -0.0164942, -0.014458, -0.01242, -0.0103806,
  -0.00833997, -0.00629823, -0.00425561, -0.0022123, -0.000168475,
  0.00187566, 0.00391992, 0.00596411, 0.00800804, 0.0100515,
  0.0120944, 0.0141364, 0.0161773, 0.0182171, 0.0202554, 0.0222922,
  0.0243271, 0.0263601, 0.0283909, 0.0304194, 0.0324452, 0.0344684,
  0.0364886, 0.0385056, 0.0405194, 0.0425296, 0.0445362, 0.0465388,
  0.0485374, 0.0505317, 0.0525216, 0.0545068, 0.0564872, 0.0584626,
  0.0604327, 0.0623975, 0.0643567, 0.0663101, 0.0682576, 0.0701989,
  0.072134, 0.0740625, 0.0759843, 0.0778992, 0.0798071, 0.0817078,
  0.083601, 0.0854867, 0.0873645, 0.0892344, 0.0910961, 0.0929496,
  0.0947945, 0.0966308, 0.0984582, 0.100277, 0.102086, 0.103886,
  0.105676, 0.107456, 0.109227, 0.110988, 0.112738, 0.114478,
  0.116207, 0.117926, 0.119634, 0.12133, 0.123016, 0.12469, 0.126352,
  0.128003, 0.129642, 0.131268, 0.132883, 0.134485, 0.136075,
  0.137652, 0.139216, 0.140767, 0.142305, 0.14383, 0.145341, 0.146839,
  0.148323, 0.149793, 0.151249, 0.152691, 0.154118, 0.155531, 0.15693,
  0.158314, 0.159683, 0.161036, 0.162375, 0.163698, 0.165006,
  0.166299, 0.167576, 0.168836, 0.170081, 0.17131, 0.172523, 0.17372,
  0.174899, 0.176063, 0.17721, 0.17834, 0.179453, 0.180549, 0.181628,
  0.182689, 0.183733, 0.18476, 0.18577, 0.186761, 0.187735, 0.188691,
  0.189629, 0.190549, 0.19145, 0.192334, 0.193199, 0.194045, 0.194873,
  0.195682, 0.196473, 0.197245, 0.197998, 0.198732, 0.199447,
  0.200142, 0.200819, 0.201476, 0.202114, 0.202732, 0.203331,
  0.203911, 0.20447, 0.20501, 0.205531, 0.206031, 0.206511, 0.206972,
  0.207412, 0.207833, 0.208233, 0.208614, 0.208974, 0.209313,
  0.209633, 0.209932, 0.210211, 0.210469, 0.210707, 0.210924,
  0.211121, 0.211298, 0.211453, 0.211588, 0.211703, 0.211797, 0.21187,
  0.211922, 0.211954, 0.211965, 0.211955, 0.211925, 0.211874,
  0.211802, 0.211709, 0.211595, 0.211461, 0.211306, 0.21113, 0.210933,
  0.210716, 0.210477, 0.210218, 0.209939, 0.209638, 0.209317,
  0.208975, 0.208612, 0.208229, 0.207825, 0.207401, 0.206956, 0.20649,
  0.206004, 0.205498, 0.204971, 0.204423, 0.203856, 0.203268,
  0.202659, 0.202031, 0.201382, 0.200713, 0.200024, 0.199315,
  0.198586, 0.197837, 0.197069, 0.19628, 0.195472, 0.194644, 0.193797,
  0.19293, 0.192043, 0.191137, 0.190212, 0.189268, 0.188304, 0.187322,
  0.18632, 0.1853, 0.184261, 0.183203, 0.182126, 0.181031, 0.179918,
  0.178786, 0.177636, 0.176467, 0.175281, 0.174077, 0.172855,
  0.171615, 0.170358, 0.169083, 0.16779, 0.166481, 0.165154, 0.16381,
  0.16245, 0.161072, 0.159678, 0.158267, 0.15684, 0.155397, 0.153937,
  0.152462, 0.15097, 0.149463, 0.14794, 0.146402, 0.144849, 0.14328,
  0.141696, 0.140097, 0.138484, 0.136856, 0.135213, 0.133556,
  0.131885, 0.1302, 0.128502, 0.126789, 0.125063, 0.123324, 0.121571,
  0.119806, 0.118028, 0.116236, 0.114433, 0.112617, 0.110789,
  0.108949, 0.107097, 0.105234, 0.103359, 0.101472, 0.0995749,
  0.0976665, 0.0957475, 0.0938179, 0.0918779, 0.0899278, 0.0879676,
  0.0859976, 0.0840181, 0.0820291, 0.0800308, 0.0780236, 0.0760075,
  0.0739827, 0.0719495, 0.0699081, 0.0678586, 0.0658013, 0.0637363,
  0.0616639, 0.0595842, 0.0574975, 0.055404, 0.0533039, 0.0511973,
  0.0490846, 0.0469658, 0.0448413, 0.0427112, 0.0405758, 0.0384352,
  0.0362897, 0.0341394, 0.0319847, 0.0298257, 0.0276626, 0.0254956,
  0.023325, 0.021151, 0.0189739, 0.0167937, 0.0146108, 0.0124254,
  0.0102376, 0.00804777, 0.00585607, 0.00366274, 0.00146799,
  -0.000727956, -0.00292486, -0.00512251, -0.00732067, -0.00951913,
  -0.0117176, -0.013916, -0.0161139, -0.0183113, -0.0205078,
  -0.0227032, -0.0248973, -0.0270899, -0.0292807, -0.0314695,
  -0.0336561, -0.0358403, -0.0380218, -0.0402004, -0.0423758,
  -0.0445479, -0.0467164, -0.0488811, -0.0510417, -0.053198,
  -0.0553498, -0.0574969, -0.0596391, -0.061776, -0.0639075,
  -0.0660333, -0.0681533, -0.0702672, -0.0723747, -0.0744757,
  -0.0765699, -0.078657, -0.080737, -0.0828094, -0.0848742, -0.086931,
  -0.0889798, -0.0910201, -0.0930519, -0.0950748, -0.0970887,
  -0.0990934, -0.101089, -0.103074, -0.10505, -0.107015, -0.10897,
  -0.110915, -0.112848, -0.114771, -0.116683, -0.118583, -0.120471,
  -0.122348, -0.124212, -0.126064, -0.127904, -0.129731, -0.131545,
  -0.133346, -0.135134, -0.136908, -0.138668, -0.140414, -0.142147,
  -0.143865, -0.145568, -0.147257, -0.148931, -0.150589, -0.152232,
  -0.15386, -0.155472, -0.157068, -0.158648, -0.160212, -0.161759,
  -0.16329, -0.164804, -0.166301, -0.16778, -0.169243, -0.170687,
  -0.172114, -0.173523, -0.174914, -0.176287, -0.177641, -0.178977,
  -0.180294, -0.181592, -0.18287, -0.18413, -0.18537, -0.186591,
  -0.187792, -0.188973, -0.190134, -0.191275, -0.192396, -0.193496,
  -0.194575, -0.195634, -0.196672, -0.197688, -0.198684, -0.199658,
  -0.200611, -0.201542, -0.202452, -0.20334, -0.204205, -0.205049,
  -0.20587, -0.206669, -0.207446, -0.2082, -0.208932, -0.209641,
  -0.210326, -0.210989, -0.211629, -0.212246, -0.212839, -0.213409,
  -0.213955, -0.214478, -0.214977, -0.215453, -0.215904, -0.216332,
  -0.216736, -0.217116, -0.217471, -0.217803, -0.21811, -0.218393,
  -0.218651, -0.218885, -0.219094, -0.219279, -0.219439, -0.219575,
  -0.219685, -0.219771, -0.219833, -0.219869, -0.21988, -0.219867,
  -0.219828, -0.219765, -0.219676, -0.219563, -0.219424, -0.21926,
  -0.219071, -0.218857, -0.218618, -0.218354, -0.218065, -0.21775,
  -0.21741, -0.217046, -0.216656, -0.216241, -0.2158, -0.215335,
  -0.214845, -0.214329, -0.213789, -0.213223, -0.212633, -0.212017,
  -0.211377, -0.210712, -0.210022, -0.209307, -0.208567, -0.207803,
  -0.207014, -0.2062, -0.205362, -0.204499, -0.203612, -0.202701,
  -0.201765, -0.200806, -0.199821, -0.198813, -0.197781, -0.196725,
  -0.195646, -0.194542, -0.193415, -0.192264, -0.19109, -0.189893,
  -0.188672, -0.187429, -0.186162, -0.184872, -0.18356, -0.182225,
  -0.180867, -0.179487, -0.178085, -0.17666, -0.175214, -0.173745,
  -0.172255, -0.170743, -0.16921, -0.167655, -0.166079, -0.164483,
  -0.162865, -0.161227, -0.159568, -0.157888, -0.156189, -0.154469,
  -0.15273, -0.150971, -0.149192, -0.147394, -0.145577, -0.14374,
  -0.141885, -0.140012, -0.13812, -0.13621, -0.134281, -0.132335,
  -0.130372, -0.128391, -0.126393, -0.124377, -0.122345, -0.120297,
  -0.118232, -0.116151, -0.114054, -0.111942, -0.109814, -0.107671,
  -0.105513, -0.10334, -0.101153, -0.098951, -0.0967355, -0.0945061,
  -0.0922633, -0.0900072, -0.087738, -0.0854562, -0.0831618,
  -0.0808551, -0.0785365, -0.0762062, -0.0738644, -0.0715114,
  -0.0691474, -0.0667729, -0.064388, -0.0619929, -0.059588,
  -0.0571736, -0.05475, -0.0523173, -0.049876, -0.0474262, -0.0449683,
  -0.0425026, -0.0400293, -0.0375488, -0.0350613, -0.0325672,
  -0.0300667, -0.0275602, -0.0250479, -0.0225301, -0.0200072,
  -0.0174794, -0.0149472, -0.0124106, -0.0098702, -0.00732616,
  -0.00477882, -0.0022285, 0.000324482, 0.00287981, 0.00543717,
  0.00799625, 0.0105567, 0.0131182, 0.0156805, 0.0182432, 0.0208061,
  0.0233686, 0.0259307, 0.0284918, 0.0310518, 0.0336102, 0.0361668,
  0.0387212, 0.041273, 0.043822, 0.0463678, 0.0489101, 0.0514486,
  0.0539829, 0.0565126, 0.0590375, 0.0615572, 0.0640714, 0.0665798,
  0.0690819, 0.0715775, 0.0740663, 0.0765478, 0.0790218, 0.081488,
  0.0839459, 0.0863953, 0.0888358, 0.0912671, 0.0936889, 0.0961008,
  0.0985024, 0.100893, 0.103274, 0.105643, 0.108, 0.110346, 0.112679,
  0.115, 0.117307, 0.119602, 0.121883, 0.12415, 0.126403, 0.128642,
  0.130865, 0.133073, 0.135266, 0.137443, 0.139604, 0.141748,
  0.143876, 0.145986, 0.148079, 0.150154, 0.152212, 0.15425, 0.15627,
  0.158271, 0.160253, 0.162215, 0.164157, 0.166078, 0.16798, 0.16986,
  0.171719, 0.173557, 0.175373, 0.177167, 0.178938, 0.180687,
  0.182413, 0.184116, 0.185795, 0.18745, 0.189082, 0.190689, 0.192271,
  0.193829, 0.195361, 0.196868, 0.198349, 0.199805, 0.201234,
  0.202636, 0.204012, 0.205361, 0.206683, 0.207977, 0.209243,
  0.210481, 0.211692, 0.212873, 0.214027, 0.215151, 0.216246,
  0.217312, 0.218348, 0.219354, 0.22033, 0.221277, 0.222192, 0.223077,
  0.223932, 0.224755, 0.225547, 0.226308, 0.227037, 0.227734, 0.2284,
  0.229033, 0.229634, 0.230203, 0.230739, 0.231242, 0.231712, 0.23215,
  0.232554, 0.232924, 0.233262, 0.233565, 0.233835, 0.234071,
  0.234273, 0.234441, 0.234575, 0.234674, 0.234739, 0.23477, 0.234765,
  0.234727, 0.234653, 0.234544, 0.234401, 0.234223, 0.234009, 0.23376,
  0.233476, 0.233157, 0.232803, 0.232413, 0.231988, 0.231528,
  0.231032, 0.230501, 0.229934, 0.229332, 0.228695, 0.228022,
  0.227313, 0.226569, 0.22579, 0.224975, 0.224125, 0.223239, 0.222319,
  0.221363, 0.220371, 0.219345, 0.218283, 0.217187, 0.216055,
  0.214889, 0.213688, 0.212452, 0.211182, 0.209876, 0.208537,
  0.207163, 0.205755, 0.204313, 0.202837, 0.201327, 0.199784,
  0.198207, 0.196597, 0.194953, 0.193276, 0.191567, 0.189824,
  0.188049, 0.186242, 0.184403, 0.182531, 0.180628, 0.178693,
  0.176727, 0.17473, 0.172702, 0.170643, 0.168554, 0.166434, 0.164285,
  0.162106, 0.159897, 0.157659, 0.155393, 0.153097, 0.150774,
  0.148422, 0.146043, 0.143636, 0.141202, 0.138741, 0.136253,
  0.133739, 0.1312, 0.128635, 0.126044, 0.123429, 0.12079, 0.118126,
  0.115438, 0.112727, 0.109993, 0.107236, 0.104457, 0.101656,
  0.098834, 0.0959904, 0.0931262, 0.0902417, 0.0873374, 0.0844136,
  0.0814707, 0.0785093, 0.0755298, 0.0725325, 0.069518, 0.0664867,
  0.0634391, 0.0603755, 0.0572966, 0.0542027, 0.0510944, 0.047972,
  0.0448362, 0.0416874, 0.038526, 0.0353527, 0.0321679, 0.0289721,
  0.0257658, 0.0225495, 0.0193238, 0.0160892, 0.0128463, 0.00959546,
  0.00633737, 0.00307252, -0.000198532, -0.00347523, -0.00675703,
  -0.0100434, -0.0133337, -0.0166274, -0.0199239, -0.0232227,
  -0.0265232, -0.0298248, -0.0331269, -0.036429, -0.0397304,
  -0.0430305, -0.0463287, -0.0496246, -0.0529173, -0.0562064,
  -0.0594913, -0.0627713, -0.0660457, -0.0693141, -0.0725757,
  -0.0758301, -0.0790764, -0.0823141, -0.0855427, -0.0887614,
  -0.0919696, -0.0951667, -0.0983521, -0.101525, -0.104685, -0.107831,
  -0.110964, -0.114081, -0.117182, -0.120268, -0.123336, -0.126387,
  -0.12942, -0.132435, -0.135429, -0.138404, -0.141358, -0.144291,
  -0.147201, -0.150089, -0.152954, -0.155795, -0.158611, -0.161403,
  -0.164168, -0.166907, -0.169618, -0.172302, -0.174958, -0.177584,
  -0.180181, -0.182748, -0.185284, -0.187788, -0.19026, -0.192699,
  -0.195105, -0.197477, -0.199814, -0.202117, -0.204383, -0.206613,
  -0.208805, -0.21096, -0.213077, -0.215155, -0.217194, -0.219192,
  -0.221151, -0.223067, -0.224943, -0.226776, -0.228566, -0.230312,
  -0.232015, -0.233674, -0.235287, -0.236855, -0.238376, -0.239851,
  -0.241279, -0.242659, -0.243992, -0.245275, -0.24651, -0.247694,
  -0.248829, -0.249913, -0.250947, -0.251928, -0.252858, -0.253736,
  -0.25456, -0.255332, -0.25605, -0.256713, -0.257323, -0.257877,
  -0.258377, -0.258821, -0.259209, -0.25954, -0.259815, -0.260033,
  -0.260194, -0.260297, -0.260343, -0.26033, -0.260258, -0.260128,
  -0.259939, -0.259691, -0.259383, -0.259016, -0.258588, -0.258101,
  -0.257553, -0.256944, -0.256275, -0.255545, -0.254754, -0.253903,
  -0.252989, -0.252015, -0.250979, -0.249881, -0.248722, -0.247502,
  -0.24622, -0.244876, -0.24347, -0.242003, -0.240474, -0.238883,
  -0.237231, -0.235518, -0.233743, -0.231906, -0.230009, -0.22805,
  -0.22603, -0.22395, -0.221808, -0.219607, -0.217345, -0.215023,
  -0.212641, -0.2102, -0.207699, -0.20514, -0.202521, -0.199845,
  -0.19711, -0.194318, -0.191468, -0.188561, -0.185598, -0.182579,
  -0.179504, -0.176373, -0.173189, -0.169949, -0.166656, -0.16331,
  -0.159911, -0.156461, -0.152958, -0.149405, -0.145801, -0.142148,
  -0.138446, -0.134695, -0.130897, -0.127052, -0.123161, -0.119224,
  -0.115243, -0.111218, -0.10715, -0.103039, -0.0988875, -0.0946953,
  -0.0904635, -0.086193, -0.0818847, -0.0775396, -0.0731586,
  -0.0687428, -0.0642931, -0.0598105, -0.0552961, -0.0507509,
  -0.0461761, -0.0415726, -0.0369418, -0.0322846, -0.0276022,
  -0.0228958, -0.0181667, -0.0134159, -0.00864481, -0.00385458,
  0.000953485, 0.00577811, 0.010618, 0.0154718, 0.0203382, 0.0252158,
  0.0301033, 0.0349992, 0.0399022, 0.0448108, 0.0497235, 0.054639,
  0.0595557, 0.0644721, 0.0693867, 0.074298, 0.0792044, 0.0841045,
  0.0889965, 0.0938789, 0.0987501, 0.103608, 0.108452, 0.11328,
  0.11809, 0.122881, 0.12765, 0.132396, 0.137118, 0.141814, 0.146481,
  0.151119, 0.155725, 0.160297, 0.164835, 0.169335, 0.173797,
  0.178218, 0.182596, 0.186931, 0.191219, 0.195459, 0.199649,
  0.203788, 0.207873, 0.211902, 0.215874, 0.219787, 0.223639,
  0.227427, 0.231151, 0.234808, 0.238396, 0.241913, 0.245357,
  0.248727, 0.252021, 0.255236, 0.258372, 0.261424, 0.264393,
  0.267276, 0.270071, 0.272777, 0.27539, 0.277911, 0.280336, 0.282663,
  0.284892, 0.28702, 0.289045, 0.290965, 0.29278, 0.294486, 0.296082,
  0.297567, 0.298938, 0.300195, 0.301334, 0.302355, 0.303256,
  0.304036, 0.304692, 0.305223, 0.305627, 0.305904, 0.306051,
  0.306067, 0.305951, 0.305701, 0.305316, 0.304794, 0.304134,
  0.303336, 0.302396, 0.301316, 0.300093, 0.298726, 0.297214,
  0.295556, 0.293752, 0.2918, 0.289699, 0.287449, 0.285049, 0.282498,
  0.279795, 0.27694, 0.273933, 0.270773, 0.267459, 0.263992, 0.26037,
  0.256594, 0.252664, 0.24858, 0.244341, 0.239947, 0.2354, 0.230699,
  0.225845, 0.220837, 0.215677, 0.210365, 0.204903, 0.199289,
  0.193527, 0.187615, 0.181557, 0.175352, 0.169003, 0.16251, 0.155876,
  0.149101, 0.142188, 0.135138, 0.127954, 0.120638, 0.113191,
  0.105617, 0.0979177, 0.0900959, 0.0821543, 0.0740961, 0.0659241,
  0.0576418, 0.0492525, 0.0407596, 0.032167, 0.0234785, 0.0146981,
  0.00583006, -0.00312135, -0.0121515, -0.0212558, -0.0304293,
  -0.0396669, -0.0489633, -0.0583131, -0.0677107, -0.0771502,
  -0.0866255, -0.0961304, -0.105658, -0.115203, -0.124757, -0.134314,
  -0.143865, -0.153404, -0.162923, -0.172414, -0.181868, -0.191277,
  -0.200632, -0.209924, -0.219144, -0.228282, -0.237328, -0.246273,
  -0.255106, -0.263816, -0.272393, -0.280825, -0.2891, -0.297207,
  -0.305134, -0.312867, -0.320396, -0.327705, -0.334783, -0.341615,
  -0.348187, -0.354485, -0.360493, -0.366198, -0.371582, -0.376631,
  -0.381329, -0.385658, -0.389602, -0.393143, -0.396263, -0.398945,
  -0.40117, -0.402919, -0.404172, -0.404909, -0.405111, -0.404757,
  -0.403825, -0.402294, -0.400142, -0.397346, -0.393883, -0.38973,
  -0.384863, -0.379258, -0.372889, -0.365731, -0.357758, -0.348943,
  -0.33926, -0.328681, -0.317178, -0.304722, -0.291284, -0.276833,
  -0.261341, -0.244775, -0.227105, -0.208297, -0.18832, -0.16714,
  -0.144723, -0.121033, -0.0960371, -0.0696977, -0.0419788,
  -0.0128428, 0.017748, 0.0498324, 0.0834497, 0.11864, 0.155444,
  0.193903, 0.23406, 0.275958, 0.319639, 0.36515, 0.412535, 0.461839,
  0.513111, 0.566398, 0.621748, 0.679211, 0.738836, 0.800676,
  0.864781, 0.931204, 1}; G4double G4NeutronHPFastLegendre::i14[3001]
  = {0, 0.000643597, 0.00124212, 0.00179715, 0.00231019, 0.00278274,
  0.00321627, 0.0036122, 0.00397192, 0.00429679, 0.00458814,
  0.00484726, 0.00507542, 0.00527385, 0.00544375, 0.00558631,
  0.00570266, 0.00579393, 0.0058612, 0.00590554, 0.00592798,
  0.00592953, 0.00591117, 0.00587387, 0.00581854, 0.00574611,
  0.00565745, 0.00555343, 0.00543487, 0.0053026, 0.0051574,
  0.00500004, 0.00483127, 0.00465182, 0.00446239, 0.00426366,
  0.00405631, 0.00384097, 0.00361827, 0.00338882, 0.0031532,
  0.00291199, 0.00266574, 0.00241498, 0.00216023, 0.00190199,
  0.00164074, 0.00137696, 0.00111109, 0.000843579, 0.000574838,
  0.000305277, 3.52884e-05, -0.00023475, -0.000504474, -0.000773533,
  -0.00104159, -0.00130832, -0.00157342, -0.00183658, -0.00209752,
  -0.00235596, -0.00261164, -0.00286432, -0.00311374, -0.00335969,
  -0.00360193, -0.00384028, -0.00407452, -0.00430447, -0.00452995,
  -0.00475079, -0.00496684, -0.00517794, -0.00538395, -0.00558474,
  -0.00578018, -0.00597017, -0.00615458, -0.00633333, -0.00650631,
  -0.00667344, -0.00683465, -0.00698986, -0.007139, -0.00728203,
  -0.00741889, -0.00754953, -0.00767391, -0.00779201, -0.00790379,
  -0.00800923, -0.00810832, -0.00820105, -0.00828741, -0.00836739,
  -0.00844101, -0.00850827, -0.00856919, -0.00862378, -0.00867207,
  -0.00871407, -0.00874983, -0.00877937, -0.00880273, -0.00881995,
  -0.00883109, -0.00883617, -0.00883526, -0.00882842, -0.00881569,
  -0.00879713, -0.00877282, -0.00874281, -0.00870717, -0.00866598,
  -0.0086193, -0.00856721, -0.00850978, -0.0084471, -0.00837925,
  -0.00830631, -0.00822836, -0.00814549, -0.00805778, -0.00796533,
  -0.00786823, -0.00776656, -0.00766042, -0.00754991, -0.00743512,
  -0.00731614, -0.00719307, -0.00706602, -0.00693507, -0.00680033,
  -0.0066619, -0.00651988, -0.00637436, -0.00622546, -0.00607327,
  -0.0059179, -0.00575944, -0.005598, -0.00543368, -0.00526659,
  -0.00509683, -0.0049245, -0.00474971, -0.00457255, -0.00439313,
  -0.00421155, -0.00402792, -0.00384233, -0.00365489, -0.0034657,
  -0.00327486, -0.00308247, -0.00288863, -0.00269343, -0.00249699,
  -0.00229939, -0.00210074, -0.00190112, -0.00170064, -0.0014994,
  -0.00129748, -0.00109498, -0.000891998, -0.00068862, -0.00048494,
  -0.000281048, -7.70345e-05, 0.000127012, 0.000331005, 0.000534856,
  0.00073848, 0.000941792, 0.00114471, 0.00134715, 0.00154902,
  0.00175026, 0.00195078, 0.00215049, 0.00234934, 0.00254723,
  0.00274409, 0.00293985, 0.00313444, 0.00332778, 0.00351981,
  0.00371045, 0.00389964, 0.00408731, 0.0042734, 0.00445784,
  0.00464057, 0.00482152, 0.00500064, 0.00517787, 0.00535315,
  0.00552642, 0.00569763, 0.00586672, 0.00603364, 0.00619834,
  0.00636076, 0.00652087, 0.00667861, 0.00683393, 0.0069868,
  0.00713715, 0.00728497, 0.00743019, 0.00757279, 0.00771271,
  0.00784994, 0.00798442, 0.00811613, 0.00824502, 0.00837107,
  0.00849425, 0.00861453, 0.00873187, 0.00884625, 0.00895764,
  0.00906602, 0.00917136, 0.00927364, 0.00937284, 0.00946894,
  0.00956192, 0.00965176, 0.00973845, 0.00982196, 0.00990228,
  0.00997941, 0.0100533, 0.010124, 0.0101915, 0.0102557, 0.0103166,
  0.0103743, 0.0104288, 0.0104799, 0.0105278, 0.0105724, 0.0106138,
  0.0106519, 0.0106866, 0.0107182, 0.0107464, 0.0107714, 0.0107931,
  0.0108115, 0.0108267, 0.0108386, 0.0108473, 0.0108528, 0.010855,
  0.0108541, 0.0108499, 0.0108425, 0.010832, 0.0108183, 0.0108015,
  0.0107815, 0.0107584, 0.0107323, 0.010703, 0.0106707, 0.0106354,
  0.010597, 0.0105556, 0.0105113, 0.010464, 0.0104137, 0.0103606,
  0.0103046, 0.0102457, 0.0101839, 0.0101194, 0.0100521, 0.00998204,
  0.00990925, 0.00983376, 0.0097556, 0.00967481, 0.0095914,
  0.00950541, 0.00941688, 0.00932583, 0.0092323, 0.00913631,
  0.00903791, 0.00893712, 0.00883397, 0.00872851, 0.00862077,
  0.00851078, 0.00839857, 0.00828419, 0.00816767, 0.00804904,
  0.00792834, 0.00780561, 0.00768089, 0.00755421, 0.00742561,
  0.00729513, 0.00716281, 0.00702868, 0.00689279, 0.00675518,
  0.00661587, 0.00647492, 0.00633237, 0.00618824, 0.00604259,
  0.00589544, 0.00574685, 0.00559686, 0.00544549, 0.0052928,
  0.00513883, 0.00498361, 0.00482719, 0.0046696, 0.00451089,
  0.0043511, 0.00419027, 0.00402844, 0.00386566, 0.00370196,
  0.00353738, 0.00337197, 0.00320576, 0.00303881, 0.00287114,
  0.0027028, 0.00253383, 0.00236428, 0.00219417, 0.00202356,
  0.00185249, 0.00168098, 0.0015091, 0.00133686, 0.00116432,
  0.000991522, 0.000818494, 0.00064528, 0.000471921, 0.000298455,
  0.000124922, -4.86384e-05, -0.000222188, -0.000395689, -0.000569101,
  -0.000742387, -0.000915509, -0.00108843, -0.00126111, -0.00143351,
  -0.0016056, -0.00177733, -0.00194868, -0.00211961, -0.00229007,
  -0.00246004, -0.00262947, -0.00279834, -0.00296661, -0.00313423,
  -0.00330119, -0.00346744, -0.00363295, -0.00379769, -0.00396162,
  -0.00412471, -0.00428693, -0.00444825, -0.00460863, -0.00476804,
  -0.00492645, -0.00508383, -0.00524016, -0.00539539, -0.0055495,
  -0.00570246, -0.00585425, -0.00600482, -0.00615416, -0.00630223,
  -0.00644902, -0.00659448, -0.0067386, -0.00688135, -0.0070227,
  -0.00716262, -0.00730109, -0.0074381, -0.0075736, -0.00770758,
  -0.00784001, -0.00797087, -0.00810014, -0.0082278, -0.00835381,
  -0.00847817, -0.00860085, -0.00872183, -0.00884109, -0.0089586,
  -0.00907436, -0.00918833, -0.00930051, -0.00941087, -0.00951939,
  -0.00962607, -0.00973087, -0.00983379, -0.00993481, -0.0100339,
  -0.0101311, -0.0102263, -0.0103195, -0.0104108, -0.0105001,
  -0.0105874, -0.0106727, -0.0107559, -0.0108371, -0.0109163,
  -0.0109933, -0.0110684, -0.0111413, -0.0112121, -0.0112809,
  -0.0113475, -0.011412, -0.0114744, -0.0115346, -0.0115927,
  -0.0116487, -0.0117025, -0.0117541, -0.0118036, -0.0118509,
  -0.011896, -0.0119389, -0.0119797, -0.0120183, -0.0120546,
  -0.0120888, -0.0121208, -0.0121506, -0.0121782, -0.0122036,
  -0.0122268, -0.0122477, -0.0122665, -0.0122831, -0.0122975,
  -0.0123097, -0.0123197, -0.0123274, -0.012333, -0.0123365,
  -0.0123377, -0.0123367, -0.0123336, -0.0123283, -0.0123208,
  -0.0123111, -0.0122993, -0.0122854, -0.0122693, -0.012251,
  -0.0122307, -0.0122081, -0.0121835, -0.0121568, -0.0121279,
  -0.012097, -0.012064, -0.0120289, -0.0119917, -0.0119525,
  -0.0119112, -0.0118679, -0.0118226, -0.0117752, -0.0117259,
  -0.0116745, -0.0116212, -0.0115659, -0.0115086, -0.0114494,
  -0.0113883, -0.0113253, -0.0112603, -0.0111935, -0.0111248,
  -0.0110542, -0.0109818, -0.0109076, -0.0108315, -0.0107537,
  -0.010674, -0.0105926, -0.0105095, -0.0104246, -0.010338,
  -0.0102496, -0.0101596, -0.010068, -0.00997466, -0.00987971,
  -0.00978315, -0.00968499, -0.00958526, -0.00948397, -0.00938114,
  -0.00927678, -0.00917093, -0.00906359, -0.0089548, -0.00884455,
  -0.00873289, -0.00861982, -0.00850537, -0.00838956, -0.00827241,
  -0.00815393, -0.00803415, -0.0079131, -0.00779079, -0.00766724,
  -0.00754247, -0.00741651, -0.00728938, -0.0071611, -0.00703168,
  -0.00690117, -0.00676956, -0.0066369, -0.00650319, -0.00636847,
  -0.00623275, -0.00609606, -0.00595842, -0.00581985, -0.00568037,
  -0.00554002, -0.00539881, -0.00525676, -0.0051139, -0.00497025,
  -0.00482583, -0.00468067, -0.00453479, -0.00438822, -0.00424097,
  -0.00409308, -0.00394456, -0.00379543, -0.00364573, -0.00349547,
  -0.00334469, -0.00319339, -0.00304161, -0.00288937, -0.00273669,
  -0.0025836, -0.00243012, -0.00227627, -0.00212208, -0.00196758,
  -0.00181277, -0.0016577, -0.00150238, -0.00134683, -0.00119108,
  -0.00103516, -0.000879079, -0.000722869, -0.000566552, -0.000410151,
  -0.000253689, -9.71898e-05, 5.93239e-05, 0.000215829, 0.000372302,
  0.00052872, 0.000685061, 0.000841301, 0.000997418, 0.00115339,
  0.00130919, 0.0014648, 0.0016202, 0.00177536, 0.00193026,
  0.00208489, 0.00223921, 0.0023932, 0.00254685, 0.00270013,
  0.00285302, 0.0030055, 0.00315755, 0.00330914, 0.00346026,
  0.00361088, 0.00376098, 0.00391054, 0.00405955, 0.00420797,
  0.0043558, 0.004503, 0.00464957, 0.00479547, 0.00494069, 0.00508521,
  0.00522901, 0.00537207, 0.00551437, 0.0056559, 0.00579662,
  0.00593653, 0.00607561, 0.00621383, 0.00635118, 0.00648764,
  0.00662319, 0.00675781, 0.00689149, 0.00702421, 0.00715595,
  0.0072867, 0.00741643, 0.00754513, 0.00767279, 0.00779938,
  0.00792489, 0.00804931, 0.00817261, 0.00829479, 0.00841582,
  0.0085357, 0.0086544, 0.00877192, 0.00888823, 0.00900332,
  0.00911718, 0.0092298, 0.00934115, 0.00945123, 0.00956002,
  0.00966751, 0.00977369, 0.00987854, 0.00998204, 0.0100842, 0.010185,
  0.0102844, 0.0103824, 0.010479, 0.0105743, 0.010668, 0.0107604,
  0.0108513, 0.0109407, 0.0110287, 0.0111152, 0.0112002, 0.0112838,
  0.0113658, 0.0114463, 0.0115252, 0.0116027, 0.0116786, 0.0117529,
  0.0118257, 0.0118969, 0.0119665, 0.0120346, 0.0121011, 0.0121659,
  0.0122292, 0.0122909, 0.0123509, 0.0124093, 0.0124661, 0.0125212,
  0.0125747, 0.0126266, 0.0126768, 0.0127253, 0.0127722, 0.0128174,
  0.012861, 0.0129029, 0.0129431, 0.0129816, 0.0130184, 0.0130536,
  0.013087, 0.0131188, 0.0131488, 0.0131772, 0.0132039, 0.0132288,
  0.0132521, 0.0132736, 0.0132935, 0.0133116, 0.0133281, 0.0133428,
  0.0133558, 0.0133671, 0.0133767, 0.0133846, 0.0133908, 0.0133953,
  0.013398, 0.0133991, 0.0133985, 0.0133961, 0.0133921, 0.0133864,
  0.0133789, 0.0133698, 0.013359, 0.0133465, 0.0133323, 0.0133165,
  0.0132989, 0.0132797, 0.0132589, 0.0132363, 0.0132121, 0.0131863,
  0.0131587, 0.0131296, 0.0130988, 0.0130664, 0.0130323, 0.0129966,
  0.0129593, 0.0129204, 0.0128798, 0.0128377, 0.012794, 0.0127487,
  0.0127018, 0.0126533, 0.0126033, 0.0125517, 0.0124986, 0.0124439,
  0.0123877, 0.01233, 0.0122707, 0.01221, 0.0121477, 0.012084,
  0.0120187, 0.011952, 0.0118839, 0.0118143, 0.0117432, 0.0116707,
  0.0115968, 0.0115215, 0.0114447, 0.0113666, 0.0112871, 0.0112062,
  0.011124, 0.0110404, 0.0109554, 0.0108692, 0.0107816, 0.0106927,
  0.0106026, 0.0105111, 0.0104184, 0.0103244, 0.0102292, 0.0101328,
  0.0100351, 0.00993628, 0.00983622, 0.00973499, 0.00963259,
  0.00952903, 0.00942434, 0.00931852, 0.00921159, 0.00910355,
  0.00899444, 0.00888425, 0.008773, 0.00866071, 0.00854739,
  0.00843306, 0.00831773, 0.00820141, 0.00808411, 0.00796586,
  0.00784667, 0.00772655, 0.00760552, 0.00748359, 0.00736078,
  0.0072371, 0.00711257, 0.0069872, 0.00686101, 0.00673401,
  0.00660623, 0.00647767, 0.00634835, 0.00621828, 0.00608749,
  0.00595599, 0.00582379, 0.00569091, 0.00555736, 0.00542317,
  0.00528835, 0.00515291, 0.00501687, 0.00488025, 0.00474306,
  0.00460532, 0.00446705, 0.00432826, 0.00418896, 0.00404919,
  0.00390894, 0.00376824, 0.00362711, 0.00348556, 0.0033436,
  0.00320126, 0.00305856, 0.0029155, 0.0027721, 0.00262839,
  0.00248437, 0.00234007, 0.00219551, 0.00205069, 0.00190563,
  0.00176036, 0.00161488, 0.00146922, 0.0013234, 0.00117742,
  0.00103131, 0.000885079, 0.000738748, 0.000592334, 0.000445852,
  0.00029932, 0.000152753, 6.16968e-06, -0.000140415, -0.000286983,
  -0.000433519, -0.000580007, -0.000726428, -0.000872767, -0.00101901,
  -0.00116513, -0.00131113, -0.00145698, -0.00160266, -0.00174816,
  -0.00189347, -0.00203856, -0.00218342, -0.00232804, -0.0024724,
  -0.00261648, -0.00276027, -0.00290374, -0.0030469, -0.00318971,
  -0.00333217, -0.00347425, -0.00361595, -0.00375724, -0.00389811,
  -0.00403855, -0.00417854, -0.00431807, -0.00445711, -0.00459566,
  -0.0047337, -0.00487122, -0.00500819, -0.00514461, -0.00528046,
  -0.00541573, -0.00555039, -0.00568444, -0.00581787, -0.00595065,
  -0.00608278, -0.00621423, -0.006345, -0.00647507, -0.00660443,
  -0.00673306, -0.00686095, -0.00698809, -0.00711446, -0.00724005,
  -0.00736484, -0.00748883, -0.007612, -0.00773434, -0.00785582,
  -0.00797645, -0.00809621, -0.00821509, -0.00833306, -0.00845013,
  -0.00856628, -0.00868149, -0.00879576, -0.00890907, -0.00902141,
  -0.00913277, -0.00924314, -0.00935251, -0.00946086, -0.00956818,
  -0.00967447, -0.00977971, -0.00988389, -0.009987, -0.010089,
  -0.01019, -0.0102898, -0.0103885, -0.0104862, -0.0105826, -0.010678,
  -0.0107722, -0.0108652, -0.010957, -0.0110477, -0.0111372,
  -0.0112255, -0.0113126, -0.0113985, -0.0114832, -0.0115666,
  -0.0116488, -0.0117297, -0.0118094, -0.0118878, -0.011965,
  -0.0120408, -0.0121154, -0.0121887, -0.0122607, -0.0123314,
  -0.0124008, -0.0124688, -0.0125356, -0.012601, -0.012665,
  -0.0127277, -0.0127891, -0.0128491, -0.0129077, -0.012965,
  -0.0130209, -0.0130754, -0.0131285, -0.0131803, -0.0132306,
  -0.0132796, -0.0133271, -0.0133733, -0.013418, -0.0134613,
  -0.0135032, -0.0135437, -0.0135827, -0.0136203, -0.0136565,
  -0.0136913, -0.0137246, -0.0137564, -0.0137869, -0.0138158,
  -0.0138434, -0.0138694, -0.0138941, -0.0139172, -0.0139389,
  -0.0139592, -0.013978, -0.0139953, -0.0140112, -0.0140256,
  -0.0140385, -0.01405, -0.01406, -0.0140685, -0.0140756, -0.0140812,
  -0.0140854, -0.0140881, -0.0140893, -0.014089, -0.0140873,
  -0.0140841, -0.0140795, -0.0140734, -0.0140659, -0.0140568,
  -0.0140464, -0.0140345, -0.0140211, -0.0140063, -0.01399,
  -0.0139723, -0.0139531, -0.0139325, -0.0139105, -0.013887,
  -0.0138621, -0.0138357, -0.013808, -0.0137788, -0.0137482,
  -0.0137162, -0.0136827, -0.0136479, -0.0136117, -0.013574,
  -0.013535, -0.0134946, -0.0134528, -0.0134096, -0.0133651,
  -0.0133191, -0.0132718, -0.0132232, -0.0131732, -0.0131219,
  -0.0130692, -0.0130152, -0.0129598, -0.0129031, -0.0128451,
  -0.0127858, -0.0127252, -0.0126633, -0.0126002, -0.0125357,
  -0.0124699, -0.0124029, -0.0123346, -0.0122651, -0.0121943,
  -0.0121223, -0.0120491, -0.0119746, -0.0118989, -0.011822,
  -0.0117439, -0.0116647, -0.0115842, -0.0115026, -0.0114198,
  -0.0113358, -0.0112507, -0.0111645, -0.0110771, -0.0109886,
  -0.0108991, -0.0108084, -0.0107166, -0.0106237, -0.0105298,
  -0.0104348, -0.0103388, -0.0102417, -0.0101436, -0.0100444,
  -0.00994427, -0.00984313, -0.00974099, -0.00963788, -0.0095338,
  -0.00942876, -0.00932278, -0.00921586, -0.00910802, -0.00899927,
  -0.00888961, -0.00877906, -0.00866764, -0.00855535, -0.0084422,
  -0.00832821, -0.00821338, -0.00809774, -0.00798129, -0.00786403,
  -0.007746, -0.00762719, -0.00750762, -0.00738731, -0.00726625,
  -0.00714447, -0.00702199, -0.0068988, -0.00677492, -0.00665037,
  -0.00652516, -0.00639931, -0.00627281, -0.00614569, -0.00601797,
  -0.00588964, -0.00576073, -0.00563125, -0.00550121, -0.00537062,
  -0.00523951, -0.00510787, -0.00497573, -0.00484309, -0.00470998,
  -0.0045764, -0.00444237, -0.00430789, -0.004173, -0.00403769,
  -0.00390198, -0.00376588, -0.00362942, -0.00349259, -0.00335542,
  -0.00321792, -0.00308011, -0.00294199, -0.00280358, -0.00266489,
  -0.00252594, -0.00238675, -0.00224731, -0.00210766, -0.0019678,
  -0.00182775, -0.00168752, -0.00154712, -0.00140657, -0.00126588,
  -0.00112506, -0.000984141, -0.000843121, -0.000702018, -0.000560847,
  -0.00041962, -0.000278353, -0.000137058, 4.24963e-06, 0.000145557,
  0.000286851, 0.000428116, 0.000569339, 0.000710507, 0.000851605,
  0.00099262, 0.00113354, 0.00127435, 0.00141503, 0.00155557,
  0.00169597, 0.0018362, 0.00197624, 0.0021161, 0.00225575,
  0.00239518, 0.00253438, 0.00267333, 0.00281202, 0.00295043,
  0.00308856, 0.00322639, 0.00336391, 0.0035011, 0.00363794,
  0.00377444, 0.00391057, 0.00404631, 0.00418167, 0.00431662,
  0.00445115, 0.00458525, 0.00471891, 0.0048521, 0.00498483,
  0.00511707, 0.00524882, 0.00538006, 0.00551078, 0.00564097,
  0.00577061, 0.00589969, 0.0060282, 0.00615613, 0.00628347,
  0.00641019, 0.0065363, 0.00666178, 0.00678661, 0.00691079,
  0.0070343, 0.00715713, 0.00727927, 0.00740071, 0.00752144,
  0.00764144, 0.00776071, 0.00787922, 0.00799698, 0.00811397,
  0.00823018, 0.00834559, 0.00846021, 0.008574, 0.00868698,
  0.00879912, 0.00891041, 0.00902084, 0.00913041, 0.0092391,
  0.00934691, 0.00945382, 0.00955982, 0.0096649, 0.00976905,
  0.00987227, 0.00997454, 0.0100759, 0.0101762, 0.0102756, 0.010374,
  0.0104714, 0.0105677, 0.0106631, 0.0107575, 0.0108508, 0.0109431,
  0.0110343, 0.0111245, 0.0112137, 0.0113017, 0.0113887, 0.0114746,
  0.0115593, 0.011643, 0.0117256, 0.011807, 0.0118874, 0.0119666,
  0.0120446, 0.0121215, 0.0121972, 0.0122718, 0.0123452, 0.0124174,
  0.0124885, 0.0125583, 0.012627, 0.0126945, 0.0127607, 0.0128257,
  0.0128895, 0.0129521, 0.0130135, 0.0130736, 0.0131325, 0.0131901,
  0.0132464, 0.0133015, 0.0133554, 0.0134079, 0.0134592, 0.0135093,
  0.013558, 0.0136054, 0.0136516, 0.0136964, 0.01374, 0.0137822,
  0.0138232, 0.0138628, 0.0139011, 0.0139381, 0.0139738, 0.0140082,
  0.0140412, 0.0140729, 0.0141032, 0.0141323, 0.0141599, 0.0141863,
  0.0142113, 0.0142349, 0.0142572, 0.0142782, 0.0142978, 0.0143161,
  0.0143329, 0.0143485, 0.0143627, 0.0143755, 0.014387, 0.0143971,
  0.0144058, 0.0144132, 0.0144192, 0.0144239, 0.0144272, 0.0144291,
  0.0144297, 0.0144289, 0.0144267, 0.0144232, 0.0144183, 0.0144121,
  0.0144045, 0.0143955, 0.0143852, 0.0143735, 0.0143605, 0.0143461,
  0.0143304, 0.0143133, 0.0142948, 0.0142751, 0.0142539, 0.0142315,
  0.0142076, 0.0141825, 0.014156, 0.0141282, 0.014099, 0.0140686,
  0.0140368, 0.0140036, 0.0139692, 0.0139334, 0.0138964, 0.013858,
  0.0138183, 0.0137773, 0.013735, 0.0136915, 0.0136466, 0.0136005,
  0.0135531, 0.0135044, 0.0134544, 0.0134032, 0.0133507, 0.013297,
  0.013242, 0.0131858, 0.0131283, 0.0130696, 0.0130097, 0.0129485,
  0.0128862, 0.0128226, 0.0127578, 0.0126918, 0.0126247, 0.0125563,
  0.0124868, 0.0124161, 0.0123442, 0.0122712, 0.012197, 0.0121217,
  0.0120452, 0.0119676, 0.0118889, 0.0118091, 0.0117282, 0.0116462,
  0.011563, 0.0114788, 0.0113936, 0.0113072, 0.0112198, 0.0111313,
  0.0110418, 0.0109513, 0.0108597, 0.0107672, 0.0106736, 0.010579,
  0.0104834, 0.0103869, 0.0102893, 0.0101908, 0.0100914, 0.009991,
  0.00988967, 0.00978742, 0.00968425, 0.00958018, 0.00947521,
  0.00936935, 0.00926262, 0.00915502, 0.00904656, 0.00893726,
  0.00882712, 0.00871615, 0.00860437, 0.00849179, 0.00837841,
  0.00826425, 0.00814931, 0.00803362, 0.00791717, 0.00779998,
  0.00768207, 0.00756343, 0.00744409, 0.00732405, 0.00720333,
  0.00708194, 0.00695988, 0.00683717, 0.00671383, 0.00658985,
  0.00646526, 0.00634007, 0.00621428, 0.00608792, 0.00596098,
  0.00583349, 0.00570545, 0.00557689, 0.00544779, 0.0053182,
  0.0051881, 0.00505752, 0.00492647, 0.00479495, 0.00466299,
  0.0045306, 0.00439778, 0.00426455, 0.00413092, 0.00399691,
  0.00386252, 0.00372777, 0.00359268, 0.00345724, 0.00332149,
  0.00318543, 0.00304906, 0.00291242, 0.0027755, 0.00263832,
  0.0025009, 0.00236324, 0.00222537, 0.00208728, 0.001949, 0.00181054,
  0.00167191, 0.00153312, 0.00139419, 0.00125513, 0.00111595,
  0.000976673, 0.0008373, 0.000697849, 0.000558333, 0.000418765,
  0.000279158, 0.000139525, -1.21528e-07, -0.000139768, -0.000279401,
  -0.000419008, -0.000558576, -0.000698092, -0.000837543,
  -0.000976916, -0.0011162, -0.00125537, -0.00139443, -0.00153336,
  -0.00167215, -0.00181078, -0.00194924, -0.00208752, -0.00222561,
  -0.00236349, -0.00250114, -0.00263857, -0.00277574, -0.00291266,
  -0.00304931, -0.00318567, -0.00332173, -0.00345749, -0.00359292,
  -0.00372801, -0.00386276, -0.00399715, -0.00413116, -0.00426479,
  -0.00439802, -0.00453084, -0.00466324, -0.0047952, -0.00492671,
  -0.00505776, -0.00518834, -0.00531844, -0.00544804, -0.00557713,
  -0.0057057, -0.00583373, -0.00596123, -0.00608816, -0.00621453,
  -0.00634031, -0.00646551, -0.00659009, -0.00671407, -0.00683741,
  -0.00696012, -0.00708218, -0.00720357, -0.0073243, -0.00744433,
  -0.00756367, -0.00768231, -0.00780023, -0.00791741, -0.00803386,
  -0.00814956, -0.00826449, -0.00837865, -0.00849203, -0.00860462,
  -0.0087164, -0.00882736, -0.0089375, -0.0090468, -0.00915526,
  -0.00926286, -0.00936959, -0.00947545, -0.00958042, -0.00968449,
  -0.00978766, -0.00988992, -0.00999124, -0.0100916, -0.0101911,
  -0.0102896, -0.0103871, -0.0104837, -0.0105792, -0.0106738,
  -0.0107674, -0.01086, -0.0109515, -0.0110421, -0.0111316, -0.01122,
  -0.0113074, -0.0113938, -0.0114791, -0.0115633, -0.0116464,
  -0.0117284, -0.0118094, -0.0118892, -0.0119679, -0.0120455,
  -0.0121219, -0.0121972, -0.0122714, -0.0123444, -0.0124163,
  -0.012487, -0.0125565, -0.0126249, -0.0126921, -0.012758,
  -0.0128228, -0.0128864, -0.0129488, -0.0130099, -0.0130698,
  -0.0131285, -0.013186, -0.0132422, -0.0132972, -0.013351,
  -0.0134034, -0.0134547, -0.0135046, -0.0135533, -0.0136007,
  -0.0136469, -0.0136917, -0.0137353, -0.0137776, -0.0138185,
  -0.0138582, -0.0138966, -0.0139337, -0.0139694, -0.0140039,
  -0.014037, -0.0140688, -0.0140993, -0.0141284, -0.0141562,
  -0.0141827, -0.0142079, -0.0142317, -0.0142542, -0.0142753,
  -0.0142951, -0.0143135, -0.0143306, -0.0143464, -0.0143607,
  -0.0143738, -0.0143854, -0.0143958, -0.0144047, -0.0144123,
  -0.0144186, -0.0144234, -0.014427, -0.0144291, -0.0144299,
  -0.0144293, -0.0144274, -0.0144241, -0.0144195, -0.0144134,
  -0.0144061, -0.0143973, -0.0143872, -0.0143757, -0.0143629,
  -0.0143487, -0.0143332, -0.0143163, -0.014298, -0.0142784,
  -0.0142575, -0.0142352, -0.0142115, -0.0141865, -0.0141602,
  -0.0141325, -0.0141035, -0.0140731, -0.0140414, -0.0140084,
  -0.0139741, -0.0139384, -0.0139014, -0.0138631, -0.0138234,
  -0.0137825, -0.0137402, -0.0136967, -0.0136518, -0.0136057,
  -0.0135582, -0.0135095, -0.0134595, -0.0134082, -0.0133556,
  -0.0133018, -0.0132467, -0.0131903, -0.0131327, -0.0130738,
  -0.0130137, -0.0129524, -0.0128898, -0.012826, -0.0127609,
  -0.0126947, -0.0126272, -0.0125586, -0.0124887, -0.0124177,
  -0.0123455, -0.0122721, -0.0121975, -0.0121217, -0.0120448,
  -0.0119668, -0.0118876, -0.0118073, -0.0117258, -0.0116433,
  -0.0115596, -0.0114748, -0.0113889, -0.011302, -0.0112139,
  -0.0111248, -0.0110346, -0.0109433, -0.0108511, -0.0107577,
  -0.0106634, -0.010568, -0.0104716, -0.0103742, -0.0102758,
  -0.0101764, -0.0100761, -0.00997478, -0.00987251, -0.0097693,
  -0.00966514, -0.00956006, -0.00945406, -0.00934715, -0.00923935,
  -0.00913066, -0.00902109, -0.00891065, -0.00879936, -0.00868722,
  -0.00857425, -0.00846045, -0.00834584, -0.00823042, -0.00811421,
  -0.00799723, -0.00787947, -0.00776095, -0.00764168, -0.00752168,
  -0.00740096, -0.00727952, -0.00715737, -0.00703454, -0.00691103,
  -0.00678685, -0.00666202, -0.00653654, -0.00641044, -0.00628371,
  -0.00615638, -0.00602845, -0.00589994, -0.00577085, -0.00564121,
  -0.00551103, -0.00538031, -0.00524907, -0.00511732, -0.00498507,
  -0.00485235, -0.00471915, -0.00458549, -0.00445139, -0.00431686,
  -0.00418191, -0.00404656, -0.00391081, -0.00377468, -0.00363819,
  -0.00350134, -0.00336415, -0.00322663, -0.00308881, -0.00295068,
  -0.00281226, -0.00267357, -0.00253462, -0.00239542, -0.00225599,
  -0.00211634, -0.00197649, -0.00183644, -0.00169621, -0.00155582,
  -0.00141527, -0.00127459, -0.00113378, -0.000992864, -0.000851848,
  -0.00071075, -0.000569582, -0.000428359, -0.000287094, -0.0001458,
  -4.49268e-06, 0.000136815, 0.00027811, 0.000419377, 0.000560604,
  0.000701775, 0.000842878, 0.000983897, 0.00112482, 0.00126563,
  0.00140632, 0.00154687, 0.00168727, 0.00182751, 0.00196756,
  0.00210742, 0.00224707, 0.0023865, 0.0025257, 0.00266465,
  0.00280333, 0.00294174, 0.00307986, 0.00321768, 0.00335518,
  0.00349235, 0.00362917, 0.00376564, 0.00390173, 0.00403744,
  0.00417275, 0.00430765, 0.00444212, 0.00457616, 0.00470974,
  0.00484285, 0.00497548, 0.00510763, 0.00523926, 0.00537038,
  0.00550097, 0.00563101, 0.00576049, 0.0058894, 0.00601772,
  0.00614545, 0.00627257, 0.00639906, 0.00652492, 0.00665013,
  0.00677468, 0.00689855, 0.00702174, 0.00714423, 0.00726601,
  0.00738706, 0.00750738, 0.00762695, 0.00774576, 0.00786379,
  0.00798104, 0.0080975, 0.00821314, 0.00832796, 0.00844196,
  0.0085551, 0.0086674, 0.00877882, 0.00888937, 0.00899902,
  0.00910778, 0.00921562, 0.00932254, 0.00942852, 0.00953356,
  0.00963764, 0.00974075, 0.00984288, 0.00994403, 0.0100442,
  0.0101433, 0.0102414, 0.0103385, 0.0104346, 0.0105295, 0.0106235,
  0.0107163, 0.0108081, 0.0108988, 0.0109884, 0.0110769, 0.0111642,
  0.0112505, 0.0113356, 0.0114195, 0.0115023, 0.011584, 0.0116644,
  0.0117437, 0.0118218, 0.0118987, 0.0119744, 0.0120488, 0.0121221,
  0.0121941, 0.0122649, 0.0123344, 0.0124027, 0.0124697, 0.0125354,
  0.0125999, 0.0126631, 0.012725, 0.0127856, 0.0128449, 0.0129029,
  0.0129596, 0.0130149, 0.0130689, 0.0131216, 0.013173, 0.013223,
  0.0132716, 0.0133189, 0.0133648, 0.0134094, 0.0134525, 0.0134943,
  0.0135348, 0.0135738, 0.0136114, 0.0136477, 0.0136825, 0.0137159,
  0.0137479, 0.0137785, 0.0138077, 0.0138355, 0.0138618, 0.0138867,
  0.0139102, 0.0139323, 0.0139529, 0.013972, 0.0139897, 0.014006,
  0.0140208, 0.0140342, 0.0140461, 0.0140566, 0.0140656, 0.0140732,
  0.0140793, 0.0140839, 0.0140871, 0.0140888, 0.014089, 0.0140878,
  0.0140851, 0.014081, 0.0140754, 0.0140683, 0.0140597, 0.0140497,
  0.0140383, 0.0140253, 0.0140109, 0.0139951, 0.0139777, 0.0139589,
  0.0139387, 0.013917, 0.0138938, 0.0138692, 0.0138431, 0.0138156,
  0.0137866, 0.0137562, 0.0137243, 0.013691, 0.0136563, 0.0136201,
  0.0135825, 0.0135434, 0.013503, 0.0134611, 0.0134177, 0.013373,
  0.0133269, 0.0132793, 0.0132304, 0.01318, 0.0131283, 0.0130752,
  0.0130206, 0.0129647, 0.0129075, 0.0128488, 0.0127888, 0.0127275,
  0.0126648, 0.0126007, 0.0125353, 0.0124686, 0.0124005, 0.0123312,
  0.0122605, 0.0121885, 0.0121152, 0.0120406, 0.0119647, 0.0118876,
  0.0118091, 0.0117295, 0.0116485, 0.0115663, 0.0114829, 0.0113983,
  0.0113124, 0.0112253, 0.011137, 0.0110475, 0.0109568, 0.0108649,
  0.0107719, 0.0106777, 0.0105824, 0.0104859, 0.0103883, 0.0102896,
  0.0101897, 0.0100888, 0.00998676, 0.00988365, 0.00977947,
  0.00967423, 0.00956794, 0.00946062, 0.00935226, 0.0092429,
  0.00913253, 0.00902117, 0.00890883, 0.00879552, 0.00868125,
  0.00856603, 0.00844989, 0.00833282, 0.00821484, 0.00809597,
  0.00797621, 0.00785558, 0.00773409, 0.00761176, 0.00748859,
  0.0073646, 0.00723981, 0.00711422, 0.00698785, 0.00686071,
  0.00673282, 0.00660419, 0.00647483, 0.00634476, 0.00621399,
  0.00608253, 0.00595041, 0.00581763, 0.0056842, 0.00555015,
  0.00541548, 0.00528022, 0.00514437, 0.00500795, 0.00487097,
  0.00473346, 0.00459542, 0.00445687, 0.00431782, 0.0041783,
  0.00403831, 0.00389787, 0.00375699, 0.0036157, 0.00347401,
  0.00333192, 0.00318947, 0.00304665, 0.0029035, 0.00276002,
  0.00261624, 0.00247215, 0.0023278, 0.00218318, 0.00203832,
  0.00189322, 0.00174792, 0.00160241, 0.00145673, 0.00131089,
  0.00116489, 0.00101877, 0.000872524, 0.000726185, 0.000579763,
  0.000433276, 0.00028674, 0.000140172, -6.41273e-06, -0.000152996,
  -0.000299563, -0.000446095, -0.000592577, -0.000738991,
  -0.000885322, -0.00103155, -0.00117766, -0.00132364, -0.00146947,
  -0.00161513, -0.0017606, -0.00190587, -0.00205093, -0.00219575,
  -0.00234032, -0.00248462, -0.00262863, -0.00277235, -0.00291574,
  -0.0030588, -0.00320151, -0.00334385, -0.0034858, -0.00362735,
  -0.00376848, -0.00390918, -0.00404943, -0.00418921, -0.0043285,
  -0.00446729, -0.00460556, -0.0047433, -0.00488049, -0.00501711,
  -0.00515315, -0.00528859, -0.00542342, -0.00555761, -0.00569115,
  -0.00582403, -0.00595623, -0.00608773, -0.00621853, -0.00634859,
  -0.00647791, -0.00660647, -0.00673426, -0.00686125, -0.00698744,
  -0.00711281, -0.00723734, -0.00736102, -0.00748383, -0.00760576,
  -0.0077268, -0.00784691, -0.00796611, -0.00808436, -0.00820165,
  -0.00831797, -0.0084333, -0.00854764, -0.00866096, -0.00877325,
  -0.00888449, -0.00899468, -0.0091038, -0.00921183, -0.00931876,
  -0.00942458, -0.00952928, -0.00963283, -0.00973523, -0.00983646,
  -0.00993652, -0.0100354, -0.010133, -0.0102295, -0.0103247,
  -0.0104187, -0.0105114, -0.0106028, -0.010693, -0.0107819,
  -0.0108694, -0.0109557, -0.0110406, -0.0111242, -0.0112064,
  -0.0112873, -0.0113668, -0.011445, -0.0115217, -0.011597,
  -0.0116709, -0.0117434, -0.0118145, -0.0118841, -0.0119523,
  -0.012019, -0.0120842, -0.012148, -0.0122102, -0.012271, -0.0123302,
  -0.012388, -0.0124442, -0.0124988, -0.012552, -0.0126036,
  -0.0126536, -0.012702, -0.0127489, -0.0127942, -0.012838,
  -0.0128801, -0.0129206, -0.0129595, -0.0129968, -0.0130325,
  -0.0130666, -0.013099, -0.0131298, -0.013159, -0.0131865,
  -0.0132124, -0.0132366, -0.0132591, -0.01328, -0.0132992,
  -0.0133167, -0.0133326, -0.0133468, -0.0133593, -0.0133701,
  -0.0133792, -0.0133866, -0.0133923, -0.0133964, -0.0133987,
  -0.0133994, -0.0133983, -0.0133955, -0.013391, -0.0133849,
  -0.013377, -0.0133674, -0.0133561, -0.013343, -0.0133283,
  -0.0133119, -0.0132937, -0.0132739, -0.0132523, -0.0132291,
  -0.0132041, -0.0131774, -0.0131491, -0.013119, -0.0130873,
  -0.0130538, -0.0130187, -0.0129818, -0.0129433, -0.0129031,
  -0.0128612, -0.0128177, -0.0127725, -0.0127256, -0.012677,
  -0.0126268, -0.012575, -0.0125215, -0.0124663, -0.0124095,
  -0.0123511, -0.0122911, -0.0122294, -0.0121662, -0.0121013,
  -0.0120348, -0.0119668, -0.0118971, -0.0118259, -0.0117532,
  -0.0116788, -0.0116029, -0.0115255, -0.0114465, -0.011366,
  -0.011284, -0.0112005, -0.0111155, -0.011029, -0.010941, -0.0108515,
  -0.0107606, -0.0106683, -0.0105745, -0.0104793, -0.0103827,
  -0.0102846, -0.0101852, -0.0100844, -0.00998229, -0.00987878,
  -0.00977393, -0.00966775, -0.00956026, -0.00945147, -0.00934139,
  -0.00923004, -0.00911743, -0.00900356, -0.00888847, -0.00877216,
  -0.00865465, -0.00853594, -0.00841607, -0.00829503, -0.00817285,
  -0.00804955, -0.00792513, -0.00779962, -0.00767303, -0.00754537,
  -0.00741667, -0.00728694, -0.0071562, -0.00702446, -0.00689174,
  -0.00675806, -0.00662343, -0.00648788, -0.00635142, -0.00621407,
  -0.00607585, -0.00593678, -0.00579687, -0.00565614, -0.00551462,
  -0.00537231, -0.00522925, -0.00508545, -0.00494093, -0.00479571,
  -0.00464981, -0.00450325, -0.00435604, -0.00420822, -0.00405979,
  -0.00391079, -0.00376122, -0.00361112, -0.0034605, -0.00330938,
  -0.00315779, -0.00300574, -0.00285326, -0.00270037, -0.00254709,
  -0.00239344, -0.00223945, -0.00208513, -0.00193051, -0.0017756,
  -0.00162044, -0.00146504, -0.00130943, -0.00115363, -0.000997661,
  -0.000841544, -0.000685304, -0.000528963, -0.000372545,
  -0.000216072, -5.95669e-05, 9.69467e-05, 0.000253446, 0.000409908,
  0.000566309, 0.000722626, 0.000878836, 0.00103492, 0.00119084,
  0.00134659, 0.00150213, 0.00165746, 0.00181253, 0.00196733,
  0.00212184, 0.00227603, 0.00242988, 0.00258336, 0.00273645,
  0.00288913, 0.00304137, 0.00319315, 0.00334444, 0.00349523,
  0.00364549, 0.00379519, 0.00394431, 0.00409283, 0.00424073,
  0.00438798, 0.00453455, 0.00468043, 0.00482559, 0.00497, 0.00511365,
  0.00525652, 0.00539856, 0.00553978, 0.00568013, 0.0058196,
  0.00595817, 0.00609581, 0.00623251, 0.00636823, 0.00650295,
  0.00663665, 0.00676932, 0.00690092, 0.00703144, 0.00716085,
  0.00728914, 0.00741627, 0.00754223, 0.00766699, 0.00779054,
  0.00791286, 0.00803391, 0.00815369, 0.00827216, 0.00838932,
  0.00850513, 0.00861958, 0.00873265, 0.00884431, 0.00895455,
  0.00906335, 0.00917069, 0.00927654, 0.00938089, 0.00948373,
  0.00958502, 0.00968475, 0.00978291, 0.00987947, 0.00997442,
  0.0100677, 0.0101594, 0.0102494, 0.0103377, 0.0104243, 0.0105092,
  0.0105924, 0.0106738, 0.0107534, 0.0108313, 0.0109073, 0.0109816,
  0.011054, 0.0111246, 0.0111933, 0.0112601, 0.011325, 0.0113881,
  0.0114492, 0.0115084, 0.0115656, 0.0116209, 0.0116743, 0.0117256,
  0.011775, 0.0118223, 0.0118677, 0.011911, 0.0119522, 0.0119915,
  0.0120286, 0.0120637, 0.0120968, 0.0121277, 0.0121565, 0.0121833,
  0.0122079, 0.0122304, 0.0122508, 0.012269, 0.0122851, 0.0122991,
  0.0123109, 0.0123205, 0.012328, 0.0123333, 0.0123365, 0.0123374,
  0.0123362, 0.0123328, 0.0123272, 0.0123194, 0.0123094, 0.0122972,
  0.0122829, 0.0122663, 0.0122475, 0.0122265, 0.0122033, 0.0121779,
  0.0121504, 0.0121206, 0.0120886, 0.0120544, 0.012018, 0.0119795,
  0.0119387, 0.0118958, 0.0118506, 0.0118033, 0.0117539, 0.0117022,
  0.0116484, 0.0115925, 0.0115344, 0.0114741, 0.0114118, 0.0113473,
  0.0112806, 0.0112119, 0.0111411, 0.0110681, 0.0109931, 0.010916,
  0.0108369, 0.0107557, 0.0106724, 0.0105872, 0.0104999, 0.0104106,
  0.0103193, 0.010226, 0.0101308, 0.0100337, 0.00993456, 0.00983355,
  0.00973063, 0.00962582, 0.00951915, 0.00941063, 0.00930027,
  0.00918809, 0.00907412, 0.00895836, 0.00884084, 0.00872159,
  0.00860061, 0.00847793, 0.00835357, 0.00822755, 0.0080999,
  0.00797063, 0.00783977, 0.00770733, 0.00757335, 0.00743785,
  0.00730085, 0.00716238, 0.00702245, 0.0068811, 0.00673836,
  0.00659424, 0.00644878, 0.00630199, 0.00615392, 0.00600458,
  0.005854, 0.00570222, 0.00554926, 0.00539515, 0.00523991,
  0.00508359, 0.00492621, 0.00476779, 0.00460838, 0.004448,
  0.00428669, 0.00412447, 0.00396138, 0.00379745, 0.00363271,
  0.0034672, 0.00330095, 0.00313399, 0.00296636, 0.0027981,
  0.00262923, 0.00245979, 0.00228983, 0.00211936, 0.00194844,
  0.00177709, 0.00160536, 0.00143327, 0.00126087, 0.00108819,
  0.000915266, 0.000742144, 0.000568858, 0.000395446, 0.000221945,
  4.83954e-05, -0.000125165, -0.000298698, -0.000472164, -0.000645523,
  -0.000818737, -0.000991765, -0.00116457, -0.00133711, -0.00150934,
  -0.00168123, -0.00185273, -0.00202381, -0.00219442, -0.00236452,
  -0.00253408, -0.00270304, -0.00287138, -0.00303905, -0.00320601,
  -0.00337221, -0.00353762, -0.0037022, -0.0038659, -0.00402869,
  -0.00419052, -0.00435134, -0.00451113, -0.00466984, -0.00482743,
  -0.00498385, -0.00513907, -0.00529305, -0.00544574, -0.0055971,
  -0.0057471, -0.00589569, -0.00604283, -0.00618848, -0.00633261,
  -0.00647517, -0.00661612, -0.00675542, -0.00689304, -0.00702893,
  -0.00716305, -0.00729537, -0.00742585, -0.00755445, -0.00768113,
  -0.00780585, -0.00792858, -0.00804928, -0.00816791, -0.00828443,
  -0.00839881, -0.00851102, -0.00862101, -0.00872876, -0.00883422,
  -0.00893736, -0.00903815, -0.00913655, -0.00923254, -0.00932607,
  -0.00941712, -0.00950566, -0.00959164, -0.00967505, -0.00975585,
  -0.009834, -0.00990949, -0.00998229, -0.0100524, -0.0101197,
  -0.0101842, -0.0102459, -0.0103048, -0.0103608, -0.010414,
  -0.0104642, -0.0105115, -0.0105559, -0.0105972, -0.0106356,
  -0.0106709, -0.0107033, -0.0107325, -0.0107587, -0.0107818,
  -0.0108017, -0.0108186, -0.0108322, -0.0108428, -0.0108501,
  -0.0108543, -0.0108553, -0.010853, -0.0108476, -0.0108389,
  -0.0108269, -0.0108117, -0.0107933, -0.0107716, -0.0107466,
  -0.0107184, -0.0106869, -0.0106521, -0.010614, -0.0105727,
  -0.0105281, -0.0104802, -0.010429, -0.0103746, -0.0103169,
  -0.0102559, -0.0101917, -0.0101242, -0.0100536, -0.00997965,
  -0.00990253, -0.0098222, -0.00973869, -0.00965201, -0.00956217,
  -0.00946919, -0.00937309, -0.00927389, -0.0091716, -0.00906626,
  -0.00895788, -0.00884649, -0.00873211, -0.00861477, -0.00849449,
  -0.00837132, -0.00824526, -0.00811637, -0.00798466, -0.00785018,
  -0.00771296, -0.00757303, -0.00743043, -0.00728521, -0.0071374,
  -0.00698704, -0.00683418, -0.00667885, -0.00652111, -0.00636101,
  -0.00619858, -0.00603388, -0.00586696, -0.00569787, -0.00552666,
  -0.00535339, -0.00517811, -0.00500089, -0.00482177, -0.00464081,
  -0.00445808, -0.00427364, -0.00408756, -0.00389988, -0.00371069,
  -0.00352005, -0.00332802, -0.00313468, -0.00294009, -0.00274433,
  -0.00254747, -0.00234958, -0.00215074, -0.00195102, -0.0017505,
  -0.00154927, -0.00134739, -0.00114495, -0.000942035, -0.000738723,
  -0.000535099, -0.000331248, -0.000127255, 7.67915e-05, 0.000280805,
  0.000484697, 0.000688377, 0.000891755, 0.00109474, 0.00129724,
  0.00149916, 0.0017004, 0.00190088, 0.00210049, 0.00229915,
  0.00249675, 0.00269319, 0.00288838, 0.00308222, 0.00327462,
  0.00346546, 0.00365465, 0.00384209, 0.00402767, 0.00421131,
  0.00439288, 0.0045723, 0.00474946, 0.00492426, 0.00509659,
  0.00526635, 0.00543344, 0.00559776, 0.0057592, 0.00591765,
  0.00607303, 0.00622522, 0.00637412, 0.00651963, 0.00666166,
  0.00680009, 0.00693483, 0.00706578, 0.00719283, 0.0073159,
  0.00743488, 0.00754967, 0.00766018, 0.00776632, 0.00786798,
  0.00796509, 0.00805754, 0.00814524, 0.00822812, 0.00830607,
  0.00837901, 0.00844686, 0.00850954, 0.00856696, 0.00861905,
  0.00866573, 0.00870693, 0.00874257, 0.00877258, 0.00879689,
  0.00881544, 0.00882817, 0.00883502, 0.00883593, 0.00883084,
  0.00881971, 0.00880249, 0.00877912, 0.00874958, 0.00871383,
  0.00867182, 0.00862354, 0.00856895, 0.00850803, 0.00844077,
  0.00836715, 0.00828716, 0.00820081, 0.00810808, 0.00800899,
  0.00790355, 0.00779176, 0.00767367, 0.00754928, 0.00741864,
  0.00728179, 0.00713876, 0.00698961, 0.00683441, 0.0066732,
  0.00650607, 0.00633308, 0.00615434, 0.00596993, 0.00577994,
  0.0055845, 0.0053837, 0.00517769, 0.00496659, 0.00475055, 0.0045297,
  0.00430422, 0.00407427, 0.00384003, 0.00360169, 0.00335944,
  0.0031135, 0.00286407, 0.0026114, 0.00235572, 0.00209727,
  0.00183633, 0.00157317, 0.00130808, 0.00104135, 0.00077329,
  0.000504231, 0.000234507, -3.55314e-05, -0.00030552, -0.000575081,
  -0.000843822, -0.00111134, -0.0013772, -0.00164099, -0.00190223,
  -0.00216047, -0.00241522, -0.00266598, -0.00291223, -0.00315344,
  -0.00338906, -0.00361851, -0.00384121, -0.00405655, -0.0042639,
  -0.00446263, -0.00465206, -0.00483151, -0.00500028, -0.00515764,
  -0.00530284, -0.00543511, -0.00555367, -0.0056577, -0.00574635,
  -0.00581879, -0.00587411, -0.00591142, -0.00592977, -0.00592822,
  -0.00590578, -0.00586144, -0.00579417, -0.0057029, -0.00558655,
  -0.00544399, -0.00527409, -0.00507566, -0.0048475, -0.00458838,
  -0.00429704, -0.00397217, -0.00361245, -0.00321652, -0.00278299,
  -0.00231043, -0.00179739, -0.00124237, -0.00064384, -2.43055e-07};
  G4double G4NeutronHPFastLegendre::l15[3201] = {-1, -0.926383,
  -0.855488, -0.787249, -0.7216, -0.658478, -0.59782, -0.539564,
  -0.483651, -0.43002, -0.378613, -0.329374, -0.282246, -0.237173,
  -0.194103, -0.152981, -0.113755, -0.0763756, -0.0407912,
  -0.00695301, 0.0251872, 0.0556768, 0.0845622, 0.111889, 0.137701,
  0.162044, 0.184959, 0.206488, 0.226673, 0.245554, 0.263172,
  0.279563, 0.294768, 0.308821, 0.321762, 0.333624, 0.344443,
  0.354253, 0.363087, 0.370979, 0.377961, 0.384063, 0.389317,
  0.393753, 0.397401, 0.400288, 0.402443, 0.403894, 0.404668, 0.40479,
  0.404287, 0.403184, 0.401506, 0.399275, 0.396517, 0.393253,
  0.389506, 0.385298, 0.38065, 0.375583, 0.370117, 0.364272, 0.358068,
  0.351522, 0.344654, 0.337481, 0.330022, 0.322291, 0.314307,
  0.306086, 0.297642, 0.288992, 0.28015, 0.271131, 0.261948, 0.252616,
  0.243147, 0.233555, 0.223852, 0.214051, 0.204162, 0.194198, 0.18417,
  0.174088, 0.163963, 0.153806, 0.143625, 0.133431, 0.123232,
  0.113038, 0.102857, 0.0926981, 0.0825685, 0.0724761, 0.0624286,
  0.0524331, 0.0424967, 0.032626, 0.0228275, 0.0131074, 0.00347168,
  -0.00607393, -0.0155239, -0.024873, -0.0341161, -0.0432485,
  -0.0522654, -0.0611625, -0.0699355, -0.0785804, -0.0870935,
  -0.095471, -0.10371, -0.111806, -0.119757, -0.12756, -0.135211,
  -0.14271, -0.150052, -0.157236, -0.16426, -0.171121, -0.177819,
  -0.18435, -0.190715, -0.196911, -0.202937, -0.208792, -0.214475,
  -0.219986, -0.225323, -0.230485, -0.235473, -0.240286, -0.244924,
  -0.249386, -0.253672, -0.257783, -0.261719, -0.265479, -0.269064,
  -0.272475, -0.275711, -0.278774, -0.281664, -0.284382, -0.286929,
  -0.289305, -0.291511, -0.293549, -0.29542, -0.297124, -0.298663,
  -0.300039, -0.301251, -0.302303, -0.303195, -0.303929, -0.304506,
  -0.304929, -0.305198, -0.305315, -0.305282, -0.305101, -0.304773,
  -0.304301, -0.303686, -0.30293, -0.302036, -0.301004, -0.299838,
  -0.298539, -0.297109, -0.29555, -0.293865, -0.292055, -0.290123,
  -0.28807, -0.2859, -0.283614, -0.281215, -0.278704, -0.276084,
  -0.273357, -0.270525, -0.267592, -0.264558, -0.261427, -0.2582,
  -0.25488, -0.251469, -0.24797, -0.244385, -0.240715, -0.236965,
  -0.233135, -0.229228, -0.225246, -0.221192, -0.217068, -0.212876,
  -0.208619, -0.204299, -0.199918, -0.195478, -0.190982, -0.186432,
  -0.18183, -0.177178, -0.172479, -0.167735, -0.162948, -0.158119,
  -0.153253, -0.148349, -0.143412, -0.138442, -0.133442, -0.128414,
  -0.123359, -0.118281, -0.113182, -0.108062, -0.102924, -0.0977707,
  -0.0926034, -0.0874241, -0.0822347, -0.0770373, -0.0718336,
  -0.0666256, -0.0614151, -0.0562039, -0.0509938, -0.0457865,
  -0.040584, -0.0353878, -0.0301997, -0.0250215, -0.0198547,
  -0.014701, -0.00956205, -0.00443944, 0.000665262, 0.00575049,
  0.0108147, 0.0158565, 0.0208742, 0.0258666, 0.030832, 0.0357692,
  0.0406767, 0.0455532, 0.0503974, 0.0552079, 0.0599834, 0.0647227,
  0.0694246, 0.0740878, 0.0787112, 0.0832936, 0.0878338, 0.0923308,
  0.0967834, 0.101191, 0.105551, 0.109865, 0.11413, 0.118345, 0.12251,
  0.126624, 0.130686, 0.134694, 0.138649, 0.142549, 0.146394,
  0.150182, 0.153914, 0.157587, 0.161203, 0.164759, 0.168255,
  0.171691, 0.175066, 0.17838, 0.181631, 0.18482, 0.187945, 0.191007,
  0.194005, 0.196938, 0.199806, 0.202609, 0.205346, 0.208016,
  0.210621, 0.213158, 0.215628, 0.218031, 0.220367, 0.222634,
  0.224833, 0.226964, 0.229027, 0.231021, 0.232946, 0.234803, 0.23659,
  0.238308, 0.239958, 0.241538, 0.243049, 0.244491, 0.245863,
  0.247167, 0.248401, 0.249567, 0.250664, 0.251691, 0.252651,
  0.253541, 0.254363, 0.255117, 0.255803, 0.256421, 0.256971,
  0.257454, 0.25787, 0.258219, 0.258501, 0.258717, 0.258867, 0.258951,
  0.25897, 0.258924, 0.258812, 0.258637, 0.258398, 0.258095, 0.257729,
  0.2573, 0.256809, 0.256256, 0.255641, 0.254966, 0.25423, 0.253434,
  0.252579, 0.251665, 0.250692, 0.249661, 0.248573, 0.247428,
  0.246226, 0.244969, 0.243657, 0.24229, 0.240869, 0.239395, 0.237868,
  0.236288, 0.234658, 0.232976, 0.231244, 0.229462, 0.227631,
  0.225752, 0.223825, 0.221851, 0.219831, 0.217765, 0.215654,
  0.213499, 0.2113, 0.209058, 0.206774, 0.204448, 0.202082, 0.199675,
  0.197229, 0.194745, 0.192222, 0.189663, 0.187067, 0.184435,
  0.181768, 0.179067, 0.176333, 0.173566, 0.170767, 0.167936,
  0.165075, 0.162185, 0.159265, 0.156317, 0.153342, 0.15034, 0.147312,
  0.144258, 0.141181, 0.138079, 0.134955, 0.131809, 0.128641,
  0.125453, 0.122244, 0.119017, 0.115771, 0.112507, 0.109227,
  0.105931, 0.102619, 0.0992927, 0.0959525, 0.0925992, 0.0892336,
  0.0858563, 0.0824681, 0.0790699, 0.0756622, 0.0722458, 0.0688215,
  0.06539, 0.061952, 0.0585083, 0.0550595, 0.0516064, 0.0481497,
  0.04469, 0.0412282, 0.0377648, 0.0343007, 0.0308364, 0.0273727,
  0.0239103, 0.0204498, 0.016992, 0.0135374, 0.0100868, 0.00664083,
  0.00320013, -0.000234633, -0.00366281, -0.00708377, -0.0104969,
  -0.0139014, -0.0172969, -0.0206826, -0.024058, -0.0274223,
  -0.0307751, -0.0341157, -0.0374435, -0.0407579, -0.0440584,
  -0.0473443, -0.0506152, -0.0538703, -0.0571092, -0.0603314,
  -0.0635362, -0.0667231, -0.0698916, -0.0730411, -0.0761712,
  -0.0792813, -0.0823709, -0.0854395, -0.0884867, -0.0915118,
  -0.0945145, -0.0974942, -0.10045, -0.103383, -0.106291, -0.109174,
  -0.112032, -0.114865, -0.117671, -0.120451, -0.123204, -0.125929,
  -0.128627, -0.131296, -0.133937, -0.13655, -0.139132, -0.141686,
  -0.144209, -0.146702, -0.149164, -0.151595, -0.153995, -0.156363,
  -0.158698, -0.161002, -0.163273, -0.165511, -0.167716, -0.169887,
  -0.172025, -0.174129, -0.176198, -0.178232, -0.180232, -0.182197,
  -0.184127, -0.186021, -0.187879, -0.189702, -0.191488, -0.193238,
  -0.194952, -0.196629, -0.198269, -0.199872, -0.201438, -0.202967,
  -0.204458, -0.205911, -0.207327, -0.208705, -0.210045, -0.211346,
  -0.21261, -0.213835, -0.215022, -0.21617, -0.21728, -0.218351,
  -0.219384, -0.220378, -0.221333, -0.222249, -0.223126, -0.223965,
  -0.224764, -0.225525, -0.226246, -0.226929, -0.227573, -0.228178,
  -0.228743, -0.22927, -0.229758, -0.230207, -0.230618, -0.230989,
  -0.231322, -0.231617, -0.231872, -0.232089, -0.232268, -0.232408,
  -0.23251, -0.232574, -0.2326, -0.232588, -0.232538, -0.23245,
  -0.232324, -0.232161, -0.231961, -0.231723, -0.231449, -0.231137,
  -0.230789, -0.230403, -0.229982, -0.229524, -0.22903, -0.2285,
  -0.227934, -0.227333, -0.226696, -0.226024, -0.225317, -0.224575,
  -0.223799, -0.222988, -0.222143, -0.221264, -0.220352, -0.219406,
  -0.218427, -0.217414, -0.216369, -0.215292, -0.214182, -0.213041,
  -0.211867, -0.210662, -0.209426, -0.208159, -0.206862, -0.205534,
  -0.204176, -0.202788, -0.20137, -0.199924, -0.198448, -0.196944,
  -0.195412, -0.193851, -0.192263, -0.190648, -0.189005, -0.187336,
  -0.18564, -0.183918, -0.18217, -0.180397, -0.178599, -0.176775,
  -0.174928, -0.173056, -0.17116, -0.169241, -0.167299, -0.165335,
  -0.163347, -0.161338, -0.159307, -0.157255, -0.155181, -0.153087,
  -0.150973, -0.148839, -0.146685, -0.144512, -0.14232, -0.14011,
  -0.137881, -0.135635, -0.133372, -0.131092, -0.128795, -0.126481,
  -0.124152, -0.121808, -0.119448, -0.117074, -0.114685, -0.112282,
  -0.109866, -0.107437, -0.104994, -0.102539, -0.100073, -0.0975942,
  -0.0951044, -0.0926037, -0.0900925, -0.0875712, -0.0850401,
  -0.0824996, -0.0799501, -0.077392, -0.0748257, -0.0722515,
  -0.0696699, -0.0670812, -0.0644859, -0.0618842, -0.0592765,
  -0.0566634, -0.054045, -0.0514219, -0.0487944, -0.0461629,
  -0.0435277, -0.0408892, -0.0382478, -0.035604, -0.032958,
  -0.0303102, -0.027661, -0.0250108, -0.02236, -0.0197088, -0.0170578,
  -0.0144072, -0.0117575, -0.0091089, -0.00646189, -0.00381679,
  -0.00117397, 0.00146621, 0.0041034, 0.00673724, 0.00936737,
  0.0119934, 0.0146151, 0.017232, 0.0198438, 0.0224501, 0.0250506,
  0.027645, 0.0302329, 0.032814, 0.0353879, 0.0379543, 0.0405129,
  0.0430634, 0.0456053, 0.0481384, 0.0506624, 0.0531769, 0.0556816,
  0.0581763, 0.0606605, 0.063134, 0.0655964, 0.0680475, 0.0704869,
  0.0729144, 0.0753296, 0.0777323, 0.0801221, 0.0824987, 0.0848619,
  0.0872114, 0.0895469, 0.091868, 0.0941746, 0.0964664, 0.098743,
  0.101004, 0.10325, 0.105479, 0.107693, 0.10989, 0.11207, 0.114233,
  0.116379, 0.118508, 0.120618, 0.122711, 0.124786, 0.126842, 0.12888,
  0.130898, 0.132898, 0.134878, 0.136838, 0.138779, 0.1407, 0.1426,
  0.14448, 0.14634, 0.148178, 0.149996, 0.151792, 0.153567, 0.15532,
  0.157052, 0.158761, 0.160448, 0.162113, 0.163756, 0.165375,
  0.166972, 0.168546, 0.170097, 0.171624, 0.173128, 0.174608,
  0.176064, 0.177497, 0.178905, 0.180289, 0.181649, 0.182984,
  0.184295, 0.185581, 0.186842, 0.188078, 0.189289, 0.190475,
  0.191636, 0.192771, 0.193881, 0.194965, 0.196024, 0.197057,
  0.198064, 0.199045, 0.2, 0.200929, 0.201831, 0.202708, 0.203558,
  0.204382, 0.20518, 0.205951, 0.206695, 0.207413, 0.208104, 0.208769,
  0.209407, 0.210019, 0.210603, 0.211161, 0.211692, 0.212196,
  0.212673, 0.213124, 0.213547, 0.213944, 0.214314, 0.214657,
  0.214973, 0.215262, 0.215524, 0.21576, 0.215969, 0.21615, 0.216305,
  0.216434, 0.216535, 0.21661, 0.216658, 0.216679, 0.216674, 0.216642,
  0.216584, 0.216499, 0.216388, 0.216251, 0.216087, 0.215897,
  0.215681, 0.215438, 0.21517, 0.214875, 0.214555, 0.214209, 0.213837,
  0.21344, 0.213017, 0.212568, 0.212094, 0.211595, 0.211071, 0.210521,
  0.209947, 0.209347, 0.208723, 0.208074, 0.207401, 0.206703,
  0.205981, 0.205235, 0.204465, 0.203671, 0.202853, 0.202011,
  0.201146, 0.200257, 0.199346, 0.198411, 0.197453, 0.196472,
  0.195469, 0.194443, 0.193395, 0.192324, 0.191232, 0.190117,
  0.188981, 0.187823, 0.186644, 0.185444, 0.184223, 0.18298, 0.181717,
  0.180434, 0.17913, 0.177806, 0.176462, 0.175098, 0.173715, 0.172312,
  0.17089, 0.169449, 0.167989, 0.16651, 0.165013, 0.163498, 0.161964,
  0.160413, 0.158844, 0.157258, 0.155654, 0.154034, 0.152396,
  0.150742, 0.149072, 0.147385, 0.145683, 0.143964, 0.142231,
  0.140481, 0.138717, 0.136938, 0.135144, 0.133336, 0.131514,
  0.129678, 0.127828, 0.125964, 0.124088, 0.122198, 0.120295, 0.11838,
  0.116453, 0.114513, 0.112561, 0.110598, 0.108624, 0.106638,
  0.104642, 0.102635, 0.100617, 0.0985891, 0.0965513, 0.0945039,
  0.092447, 0.0903808, 0.0883057, 0.0862219, 0.0841296, 0.0820291,
  0.0799205, 0.0778043, 0.0756805, 0.0735496, 0.0714116, 0.0692669,
  0.0671157, 0.0649582, 0.0627947, 0.0606255, 0.0584508, 0.0562709,
  0.054086, 0.0518963, 0.0497021, 0.0475037, 0.0453012, 0.0430951,
  0.0408854, 0.0386725, 0.0364566, 0.0342379, 0.0320168, 0.0297934,
  0.027568, 0.0253408, 0.0231122, 0.0208823, 0.0186514, 0.0164197,
  0.0141876, 0.0119551, 0.00972269, 0.00749049, 0.00525876,
  0.00302776, 0.000797724, -0.0014311, -0.00365846, -0.00588413,
  -0.00810785, -0.0103294, -0.0125485, -0.0147649, -0.0169785,
  -0.0191889, -0.0213959, -0.0235993, -0.0257988, -0.0279943,
  -0.0301854, -0.0323719, -0.0345537, -0.0367304, -0.0389018,
  -0.0410678, -0.043228, -0.0453823, -0.0475305, -0.0496722,
  -0.0518073, -0.0539355, -0.0560566, -0.0581705, -0.0602768,
  -0.0623754, -0.064466, -0.0665485, -0.0686225, -0.070688,
  -0.0727446, -0.0747922, -0.0768306, -0.0788595, -0.0808787,
  -0.082888, -0.0848873, -0.0868763, -0.0888548, -0.0908227,
  -0.0927796, -0.0947255, -0.09666, -0.0985831, -0.100495, -0.102394,
  -0.104282, -0.106157, -0.10802, -0.10987, -0.111707, -0.113532,
  -0.115343, -0.117141, -0.118925, -0.120696, -0.122453, -0.124195,
  -0.125924, -0.127638, -0.129338, -0.131023, -0.132693, -0.134347,
  -0.135987, -0.137612, -0.13922, -0.140813, -0.142391, -0.143952,
  -0.145497, -0.147026, -0.148539, -0.150034, -0.151514, -0.152976,
  -0.154421, -0.15585, -0.15726, -0.158654, -0.16003, -0.161388,
  -0.162729, -0.164052, -0.165356, -0.166643, -0.167911, -0.169161,
  -0.170393, -0.171605, -0.1728, -0.173975, -0.175131, -0.176269,
  -0.177387, -0.178486, -0.179565, -0.180626, -0.181667, -0.182688,
  -0.183689, -0.184671, -0.185633, -0.186575, -0.187496, -0.188398,
  -0.18928, -0.190141, -0.190982, -0.191803, -0.192603, -0.193383,
  -0.194142, -0.19488, -0.195598, -0.196295, -0.196971, -0.197627,
  -0.198261, -0.198875, -0.199467, -0.200038, -0.200589, -0.201118,
  -0.201626, -0.202113, -0.202579, -0.203023, -0.203446, -0.203848,
  -0.204228, -0.204588, -0.204925, -0.205242, -0.205537, -0.20581,
  -0.206062, -0.206293, -0.206502, -0.20669, -0.206857, -0.207002,
  -0.207125, -0.207227, -0.207308, -0.207367, -0.207405, -0.207422,
  -0.207417, -0.207391, -0.207343, -0.207274, -0.207184, -0.207072,
  -0.20694, -0.206786, -0.206611, -0.206415, -0.206198, -0.205959,
  -0.2057, -0.20542, -0.205118, -0.204796, -0.204453, -0.20409,
  -0.203705, -0.2033, -0.202874, -0.202428, -0.201961, -0.201474,
  -0.200966, -0.200439, -0.19989, -0.199322, -0.198734, -0.198126,
  -0.197497, -0.196849, -0.196181, -0.195494, -0.194786, -0.19406,
  -0.193313, -0.192548, -0.191763, -0.190959, -0.190136, -0.189294,
  -0.188433, -0.187554, -0.186656, -0.185739, -0.184803, -0.18385,
  -0.182878, -0.181888, -0.18088, -0.179854, -0.17881, -0.177749,
  -0.17667, -0.175574, -0.17446, -0.173329, -0.172181, -0.171016,
  -0.169835, -0.168636, -0.167421, -0.16619, -0.164943, -0.163679,
  -0.162399, -0.161104, -0.159792, -0.158465, -0.157123, -0.155765,
  -0.154393, -0.153005, -0.151602, -0.150185, -0.148753, -0.147307,
  -0.145846, -0.144371, -0.142883, -0.14138, -0.139864, -0.138335,
  -0.136792, -0.135236, -0.133667, -0.132085, -0.130491, -0.128884,
  -0.127265, -0.125633, -0.12399, -0.122335, -0.120668, -0.118989,
  -0.1173, -0.115599, -0.113887, -0.112165, -0.110432, -0.108688,
  -0.106935, -0.105171, -0.103397, -0.101614, -0.0998208, -0.0980185,
  -0.0962071, -0.0943867, -0.0925575, -0.0907197, -0.0888734,
  -0.087019, -0.0851565, -0.0832861, -0.0814081, -0.0795226,
  -0.0776297, -0.0757298, -0.073823, -0.0719094, -0.0699894,
  -0.0680629, -0.0661303, -0.0641918, -0.0622475, -0.0602977,
  -0.0583424, -0.056382, -0.0544166, -0.0524464, -0.0504716,
  -0.0484924, -0.0465089, -0.0445215, -0.0425303, -0.0405354,
  -0.0385371, -0.0365356, -0.0345311, -0.0325237, -0.0305137,
  -0.0285013, -0.0264866, -0.0244698, -0.0224512, -0.020431,
  -0.0184093, -0.0163864, -0.0143624, -0.0123375, -0.010312,
  -0.00828596, -0.00625969, -0.00423334, -0.00220711, -0.000181195,
  0.0018442, 0.00386889, 0.00589268, 0.00791536, 0.00993675,
  0.0119566, 0.0139749, 0.0159912, 0.0180055, 0.0200174, 0.022027,
  0.0240339, 0.0260379, 0.0280389, 0.0300367, 0.032031, 0.0340217,
  0.0360087, 0.0379916, 0.0399704, 0.0419448, 0.0439146, 0.0458797,
  0.0478398, 0.0497949, 0.0517446, 0.0536889, 0.0556274, 0.0575602,
  0.0594868, 0.0614073, 0.0633213, 0.0652288, 0.0671295, 0.0690232,
  0.0709099, 0.0727892, 0.074661, 0.0765252, 0.0783816, 0.0802299,
  0.0820701, 0.083902, 0.0857253, 0.0875399, 0.0893456, 0.0911423,
  0.0929298, 0.094708, 0.0964766, 0.0982355, 0.0999845, 0.101724,
  0.103452, 0.105171, 0.106879, 0.108576, 0.110263, 0.111938,
  0.113602, 0.115255, 0.116897, 0.118527, 0.120145, 0.121752,
  0.123346, 0.124928, 0.126498, 0.128055, 0.1296, 0.131132, 0.132651,
  0.134157, 0.13565, 0.137129, 0.138595, 0.140047, 0.141486, 0.142911,
  0.144322, 0.145718, 0.147101, 0.148469, 0.149822, 0.151161,
  0.152486, 0.153795, 0.155089, 0.156369, 0.157633, 0.158881,
  0.160115, 0.161332, 0.162534, 0.163721, 0.164891, 0.166046,
  0.167184, 0.168306, 0.169412, 0.170502, 0.171575, 0.172631,
  0.173671, 0.174694, 0.1757, 0.176689, 0.177661, 0.178616, 0.179554,
  0.180474, 0.181378, 0.182263, 0.183131, 0.183982, 0.184815, 0.18563,
  0.186427, 0.187207, 0.187968, 0.188712, 0.189437, 0.190144,
  0.190833, 0.191504, 0.192156, 0.19279, 0.193406, 0.194003, 0.194581,
  0.195141, 0.195682, 0.196205, 0.196708, 0.197194, 0.19766, 0.198107,
  0.198536, 0.198945, 0.199336, 0.199707, 0.20006, 0.200394, 0.200708,
  0.201003, 0.20128, 0.201537, 0.201775, 0.201994, 0.202193, 0.202374,
  0.202535, 0.202677, 0.2028, 0.202903, 0.202987, 0.203052, 0.203098,
  0.203125, 0.203132, 0.20312, 0.203089, 0.203038, 0.202969, 0.20288,
  0.202772, 0.202645, 0.202498, 0.202333, 0.202148, 0.201944,
  0.201721, 0.20148, 0.201219, 0.200939, 0.20064, 0.200322, 0.199985,
  0.19963, 0.199255, 0.198862, 0.19845, 0.19802, 0.197571, 0.197103,
  0.196616, 0.196111, 0.195588, 0.195046, 0.194486, 0.193907,
  0.193311, 0.192696, 0.192063, 0.191412, 0.190743, 0.190056,
  0.189351, 0.188628, 0.187888, 0.18713, 0.186354, 0.185561, 0.184751,
  0.183923, 0.183078, 0.182215, 0.181336, 0.18044, 0.179526, 0.178596,
  0.177649, 0.176686, 0.175706, 0.174709, 0.173696, 0.172667,
  0.171622, 0.17056, 0.169483, 0.16839, 0.167281, 0.166156, 0.165016,
  0.16386, 0.162689, 0.161503, 0.160302, 0.159085, 0.157854, 0.156608,
  0.155348, 0.154072, 0.152783, 0.151479, 0.150161, 0.148829,
  0.147483, 0.146124, 0.14475, 0.143364, 0.141963, 0.14055, 0.139123,
  0.137684, 0.136231, 0.134766, 0.133289, 0.131799, 0.130296,
  0.128782, 0.127255, 0.125716, 0.124166, 0.122605, 0.121031,
  0.119447, 0.117851, 0.116245, 0.114627, 0.112999, 0.11136, 0.109711,
  0.108052, 0.106383, 0.104704, 0.103015, 0.101316, 0.0996079,
  0.0978906, 0.0961642, 0.0944289, 0.0926847, 0.0909319, 0.0891706,
  0.0874011, 0.0856234, 0.0838377, 0.0820442, 0.0802431, 0.0784345,
  0.0766186, 0.0747956, 0.0729657, 0.0711289, 0.0692855, 0.0674357,
  0.0655796, 0.0637174, 0.0618492, 0.0599754, 0.0580959, 0.056211,
  0.0543209, 0.0524258, 0.0505258, 0.048621, 0.0467118, 0.0447982,
  0.0428804, 0.0409587, 0.0390331, 0.0371039, 0.0351713, 0.0332354,
  0.0312964, 0.0293545, 0.0274099, 0.0254627, 0.0235131, 0.0215614,
  0.0196076, 0.0176521, 0.0156949, 0.0137362, 0.0117763, 0.00981523,
  0.00785328, 0.0058906, 0.00392737, 0.00196378, -0, -0.00196378,
  -0.00392737, -0.0058906, -0.00785328, -0.00981523, -0.0117763,
  -0.0137362, -0.0156949, -0.0176521, -0.0196076, -0.0215614,
  -0.0235131, -0.0254627, -0.0274099, -0.0293545, -0.0312964,
  -0.0332354, -0.0351713, -0.0371039, -0.0390331, -0.0409587,
  -0.0428804, -0.0447982, -0.0467118, -0.048621, -0.0505258,
  -0.0524258, -0.0543209, -0.056211, -0.0580959, -0.0599754,
  -0.0618492, -0.0637174, -0.0655796, -0.0674357, -0.0692855,
  -0.0711289, -0.0729657, -0.0747956, -0.0766186, -0.0784345,
  -0.0802431, -0.0820442, -0.0838377, -0.0856234, -0.0874011,
  -0.0891706, -0.0909319, -0.0926847, -0.0944289, -0.0961642,
  -0.0978906, -0.0996079, -0.101316, -0.103015, -0.104704, -0.106383,
  -0.108052, -0.109711, -0.11136, -0.112999, -0.114627, -0.116245,
  -0.117851, -0.119447, -0.121031, -0.122605, -0.124166, -0.125716,
  -0.127255, -0.128782, -0.130296, -0.131799, -0.133289, -0.134766,
  -0.136231, -0.137684, -0.139123, -0.14055, -0.141963, -0.143364,
  -0.14475, -0.146124, -0.147483, -0.148829, -0.150161, -0.151479,
  -0.152783, -0.154072, -0.155348, -0.156608, -0.157854, -0.159085,
  -0.160302, -0.161503, -0.162689, -0.16386, -0.165016, -0.166156,
  -0.167281, -0.16839, -0.169483, -0.17056, -0.171622, -0.172667,
  -0.173696, -0.174709, -0.175706, -0.176686, -0.177649, -0.178596,
  -0.179526, -0.18044, -0.181336, -0.182215, -0.183078, -0.183923,
  -0.184751, -0.185561, -0.186354, -0.18713, -0.187888, -0.188628,
  -0.189351, -0.190056, -0.190743, -0.191412, -0.192063, -0.192696,
  -0.193311, -0.193907, -0.194486, -0.195046, -0.195588, -0.196111,
  -0.196616, -0.197103, -0.197571, -0.19802, -0.19845, -0.198862,
  -0.199255, -0.19963, -0.199985, -0.200322, -0.20064, -0.200939,
  -0.201219, -0.20148, -0.201721, -0.201944, -0.202148, -0.202333,
  -0.202498, -0.202645, -0.202772, -0.20288, -0.202969, -0.203038,
  -0.203089, -0.20312, -0.203132, -0.203125, -0.203098, -0.203052,
  -0.202987, -0.202903, -0.2028, -0.202677, -0.202535, -0.202374,
  -0.202193, -0.201994, -0.201775, -0.201537, -0.20128, -0.201003,
  -0.200708, -0.200394, -0.20006, -0.199707, -0.199336, -0.198945,
  -0.198536, -0.198107, -0.19766, -0.197194, -0.196708, -0.196205,
  -0.195682, -0.195141, -0.194581, -0.194003, -0.193406, -0.19279,
  -0.192156, -0.191504, -0.190833, -0.190144, -0.189437, -0.188712,
  -0.187968, -0.187207, -0.186427, -0.18563, -0.184815, -0.183982,
  -0.183131, -0.182263, -0.181378, -0.180474, -0.179554, -0.178616,
  -0.177661, -0.176689, -0.1757, -0.174694, -0.173671, -0.172631,
  -0.171575, -0.170502, -0.169412, -0.168306, -0.167184, -0.166046,
  -0.164891, -0.163721, -0.162534, -0.161332, -0.160115, -0.158881,
  -0.157633, -0.156369, -0.155089, -0.153795, -0.152486, -0.151161,
  -0.149822, -0.148469, -0.147101, -0.145718, -0.144322, -0.142911,
  -0.141486, -0.140047, -0.138595, -0.137129, -0.13565, -0.134157,
  -0.132651, -0.131132, -0.1296, -0.128055, -0.126498, -0.124928,
  -0.123346, -0.121752, -0.120145, -0.118527, -0.116897, -0.115255,
  -0.113602, -0.111938, -0.110263, -0.108576, -0.106879, -0.105171,
  -0.103452, -0.101724, -0.0999845, -0.0982355, -0.0964766, -0.094708,
  -0.0929298, -0.0911423, -0.0893456, -0.0875399, -0.0857253,
  -0.083902, -0.0820701, -0.0802299, -0.0783816, -0.0765252,
  -0.074661, -0.0727892, -0.0709099, -0.0690232, -0.0671295,
  -0.0652288, -0.0633213, -0.0614073, -0.0594868, -0.0575602,
  -0.0556274, -0.0536889, -0.0517446, -0.0497949, -0.0478398,
  -0.0458797, -0.0439146, -0.0419448, -0.0399704, -0.0379916,
  -0.0360087, -0.0340217, -0.032031, -0.0300367, -0.0280389,
  -0.0260379, -0.0240339, -0.022027, -0.0200174, -0.0180055,
  -0.0159912, -0.0139749, -0.0119566, -0.00993675, -0.00791536,
  -0.00589268, -0.00386889, -0.0018442, 0.000181195, 0.00220711,
  0.00423334, 0.00625969, 0.00828596, 0.010312, 0.0123375, 0.0143624,
  0.0163864, 0.0184093, 0.020431, 0.0224512, 0.0244698, 0.0264866,
  0.0285013, 0.0305137, 0.0325237, 0.0345311, 0.0365356, 0.0385371,
  0.0405354, 0.0425303, 0.0445215, 0.0465089, 0.0484924, 0.0504716,
  0.0524464, 0.0544166, 0.056382, 0.0583424, 0.0602977, 0.0622475,
  0.0641918, 0.0661303, 0.0680629, 0.0699894, 0.0719094, 0.073823,
  0.0757298, 0.0776297, 0.0795226, 0.0814081, 0.0832861, 0.0851565,
  0.087019, 0.0888734, 0.0907197, 0.0925575, 0.0943867, 0.0962071,
  0.0980185, 0.0998208, 0.101614, 0.103397, 0.105171, 0.106935,
  0.108688, 0.110432, 0.112165, 0.113887, 0.115599, 0.1173, 0.118989,
  0.120668, 0.122335, 0.12399, 0.125633, 0.127265, 0.128884, 0.130491,
  0.132085, 0.133667, 0.135236, 0.136792, 0.138335, 0.139864, 0.14138,
  0.142883, 0.144371, 0.145846, 0.147307, 0.148753, 0.150185,
  0.151602, 0.153005, 0.154393, 0.155765, 0.157123, 0.158465,
  0.159792, 0.161104, 0.162399, 0.163679, 0.164943, 0.16619, 0.167421,
  0.168636, 0.169835, 0.171016, 0.172181, 0.173329, 0.17446, 0.175574,
  0.17667, 0.177749, 0.17881, 0.179854, 0.18088, 0.181888, 0.182878,
  0.18385, 0.184803, 0.185739, 0.186656, 0.187554, 0.188433, 0.189294,
  0.190136, 0.190959, 0.191763, 0.192548, 0.193313, 0.19406, 0.194786,
  0.195494, 0.196181, 0.196849, 0.197497, 0.198126, 0.198734,
  0.199322, 0.19989, 0.200439, 0.200966, 0.201474, 0.201961, 0.202428,
  0.202874, 0.2033, 0.203705, 0.20409, 0.204453, 0.204796, 0.205118,
  0.20542, 0.2057, 0.205959, 0.206198, 0.206415, 0.206611, 0.206786,
  0.20694, 0.207072, 0.207184, 0.207274, 0.207343, 0.207391, 0.207417,
  0.207422, 0.207405, 0.207367, 0.207308, 0.207227, 0.207125,
  0.207002, 0.206857, 0.20669, 0.206502, 0.206293, 0.206062, 0.20581,
  0.205537, 0.205242, 0.204925, 0.204588, 0.204228, 0.203848,
  0.203446, 0.203023, 0.202579, 0.202113, 0.201626, 0.201118,
  0.200589, 0.200038, 0.199467, 0.198875, 0.198261, 0.197627,
  0.196971, 0.196295, 0.195598, 0.19488, 0.194142, 0.193383, 0.192603,
  0.191803, 0.190982, 0.190141, 0.18928, 0.188398, 0.187496, 0.186575,
  0.185633, 0.184671, 0.183689, 0.182688, 0.181667, 0.180626,
  0.179565, 0.178486, 0.177387, 0.176269, 0.175131, 0.173975, 0.1728,
  0.171605, 0.170393, 0.169161, 0.167911, 0.166643, 0.165356,
  0.164052, 0.162729, 0.161388, 0.16003, 0.158654, 0.15726, 0.15585,
  0.154421, 0.152976, 0.151514, 0.150034, 0.148539, 0.147026,
  0.145497, 0.143952, 0.142391, 0.140813, 0.13922, 0.137612, 0.135987,
  0.134347, 0.132693, 0.131023, 0.129338, 0.127638, 0.125924,
  0.124195, 0.122453, 0.120696, 0.118925, 0.117141, 0.115343,
  0.113532, 0.111707, 0.10987, 0.10802, 0.106157, 0.104282, 0.102394,
  0.100495, 0.0985831, 0.09666, 0.0947255, 0.0927796, 0.0908227,
  0.0888548, 0.0868763, 0.0848873, 0.082888, 0.0808787, 0.0788595,
  0.0768306, 0.0747922, 0.0727446, 0.070688, 0.0686225, 0.0665485,
  0.064466, 0.0623754, 0.0602768, 0.0581705, 0.0560566, 0.0539355,
  0.0518073, 0.0496722, 0.0475305, 0.0453823, 0.043228, 0.0410678,
  0.0389018, 0.0367304, 0.0345537, 0.0323719, 0.0301854, 0.0279943,
  0.0257988, 0.0235993, 0.0213959, 0.0191889, 0.0169785, 0.0147649,
  0.0125485, 0.0103294, 0.00810785, 0.00588413, 0.00365846, 0.0014311,
  -0.000797724, -0.00302776, -0.00525876, -0.00749049, -0.00972269,
  -0.0119551, -0.0141876, -0.0164197, -0.0186514, -0.0208823,
  -0.0231122, -0.0253408, -0.027568, -0.0297934, -0.0320168,
  -0.0342379, -0.0364566, -0.0386725, -0.0408854, -0.0430951,
  -0.0453012, -0.0475037, -0.0497021, -0.0518963, -0.054086,
  -0.0562709, -0.0584508, -0.0606255, -0.0627947, -0.0649582,
  -0.0671157, -0.0692669, -0.0714116, -0.0735496, -0.0756805,
  -0.0778043, -0.0799205, -0.0820291, -0.0841296, -0.0862219,
  -0.0883057, -0.0903808, -0.092447, -0.0945039, -0.0965513,
  -0.0985891, -0.100617, -0.102635, -0.104642, -0.106638, -0.108624,
  -0.110598, -0.112561, -0.114513, -0.116453, -0.11838, -0.120295,
  -0.122198, -0.124088, -0.125964, -0.127828, -0.129678, -0.131514,
  -0.133336, -0.135144, -0.136938, -0.138717, -0.140481, -0.142231,
  -0.143964, -0.145683, -0.147385, -0.149072, -0.150742, -0.152396,
  -0.154034, -0.155654, -0.157258, -0.158844, -0.160413, -0.161964,
  -0.163498, -0.165013, -0.16651, -0.167989, -0.169449, -0.17089,
  -0.172312, -0.173715, -0.175098, -0.176462, -0.177806, -0.17913,
  -0.180434, -0.181717, -0.18298, -0.184223, -0.185444, -0.186644,
  -0.187823, -0.188981, -0.190117, -0.191232, -0.192324, -0.193395,
  -0.194443, -0.195469, -0.196472, -0.197453, -0.198411, -0.199346,
  -0.200257, -0.201146, -0.202011, -0.202853, -0.203671, -0.204465,
  -0.205235, -0.205981, -0.206703, -0.207401, -0.208074, -0.208723,
  -0.209347, -0.209947, -0.210521, -0.211071, -0.211595, -0.212094,
  -0.212568, -0.213017, -0.21344, -0.213837, -0.214209, -0.214555,
  -0.214875, -0.21517, -0.215438, -0.215681, -0.215897, -0.216087,
  -0.216251, -0.216388, -0.216499, -0.216584, -0.216642, -0.216674,
  -0.216679, -0.216658, -0.21661, -0.216535, -0.216434, -0.216305,
  -0.21615, -0.215969, -0.21576, -0.215524, -0.215262, -0.214973,
  -0.214657, -0.214314, -0.213944, -0.213547, -0.213124, -0.212673,
  -0.212196, -0.211692, -0.211161, -0.210603, -0.210019, -0.209407,
  -0.208769, -0.208104, -0.207413, -0.206695, -0.205951, -0.20518,
  -0.204382, -0.203558, -0.202708, -0.201831, -0.200929, -0.2,
  -0.199045, -0.198064, -0.197057, -0.196024, -0.194965, -0.193881,
  -0.192771, -0.191636, -0.190475, -0.189289, -0.188078, -0.186842,
  -0.185581, -0.184295, -0.182984, -0.181649, -0.180289, -0.178905,
  -0.177497, -0.176064, -0.174608, -0.173128, -0.171624, -0.170097,
  -0.168546, -0.166972, -0.165375, -0.163756, -0.162113, -0.160448,
  -0.158761, -0.157052, -0.15532, -0.153567, -0.151792, -0.149996,
  -0.148178, -0.14634, -0.14448, -0.1426, -0.1407, -0.138779,
  -0.136838, -0.134878, -0.132898, -0.130898, -0.12888, -0.126842,
  -0.124786, -0.122711, -0.120618, -0.118508, -0.116379, -0.114233,
  -0.11207, -0.10989, -0.107693, -0.105479, -0.10325, -0.101004,
  -0.098743, -0.0964664, -0.0941746, -0.091868, -0.0895469,
  -0.0872114, -0.0848619, -0.0824987, -0.0801221, -0.0777323,
  -0.0753296, -0.0729144, -0.0704869, -0.0680475, -0.0655964,
  -0.063134, -0.0606605, -0.0581763, -0.0556816, -0.0531769,
  -0.0506624, -0.0481384, -0.0456053, -0.0430634, -0.0405129,
  -0.0379543, -0.0353879, -0.032814, -0.0302329, -0.027645,
  -0.0250506, -0.0224501, -0.0198438, -0.017232, -0.0146151,
  -0.0119934, -0.00936737, -0.00673724, -0.0041034, -0.00146621,
  0.00117397, 0.00381679, 0.00646189, 0.0091089, 0.0117575, 0.0144072,
  0.0170578, 0.0197088, 0.02236, 0.0250108, 0.027661, 0.0303102,
  0.032958, 0.035604, 0.0382478, 0.0408892, 0.0435277, 0.0461629,
  0.0487944, 0.0514219, 0.054045, 0.0566634, 0.0592765, 0.0618842,
  0.0644859, 0.0670812, 0.0696699, 0.0722515, 0.0748257, 0.077392,
  0.0799501, 0.0824996, 0.0850401, 0.0875712, 0.0900925, 0.0926037,
  0.0951044, 0.0975942, 0.100073, 0.102539, 0.104994, 0.107437,
  0.109866, 0.112282, 0.114685, 0.117074, 0.119448, 0.121808,
  0.124152, 0.126481, 0.128795, 0.131092, 0.133372, 0.135635,
  0.137881, 0.14011, 0.14232, 0.144512, 0.146685, 0.148839, 0.150973,
  0.153087, 0.155181, 0.157255, 0.159307, 0.161338, 0.163347,
  0.165335, 0.167299, 0.169241, 0.17116, 0.173056, 0.174928, 0.176775,
  0.178599, 0.180397, 0.18217, 0.183918, 0.18564, 0.187336, 0.189005,
  0.190648, 0.192263, 0.193851, 0.195412, 0.196944, 0.198448,
  0.199924, 0.20137, 0.202788, 0.204176, 0.205534, 0.206862, 0.208159,
  0.209426, 0.210662, 0.211867, 0.213041, 0.214182, 0.215292,
  0.216369, 0.217414, 0.218427, 0.219406, 0.220352, 0.221264,
  0.222143, 0.222988, 0.223799, 0.224575, 0.225317, 0.226024,
  0.226696, 0.227333, 0.227934, 0.2285, 0.22903, 0.229524, 0.229982,
  0.230403, 0.230789, 0.231137, 0.231449, 0.231723, 0.231961,
  0.232161, 0.232324, 0.23245, 0.232538, 0.232588, 0.2326, 0.232574,
  0.23251, 0.232408, 0.232268, 0.232089, 0.231872, 0.231617, 0.231322,
  0.230989, 0.230618, 0.230207, 0.229758, 0.22927, 0.228743, 0.228178,
  0.227573, 0.226929, 0.226246, 0.225525, 0.224764, 0.223965,
  0.223126, 0.222249, 0.221333, 0.220378, 0.219384, 0.218351, 0.21728,
  0.21617, 0.215022, 0.213835, 0.21261, 0.211346, 0.210045, 0.208705,
  0.207327, 0.205911, 0.204458, 0.202967, 0.201438, 0.199872,
  0.198269, 0.196629, 0.194952, 0.193238, 0.191488, 0.189702,
  0.187879, 0.186021, 0.184127, 0.182197, 0.180232, 0.178232,
  0.176198, 0.174129, 0.172025, 0.169887, 0.167716, 0.165511,
  0.163273, 0.161002, 0.158698, 0.156363, 0.153995, 0.151595,
  0.149164, 0.146702, 0.144209, 0.141686, 0.139132, 0.13655, 0.133937,
  0.131296, 0.128627, 0.125929, 0.123204, 0.120451, 0.117671,
  0.114865, 0.112032, 0.109174, 0.106291, 0.103383, 0.10045,
  0.0974942, 0.0945145, 0.0915118, 0.0884867, 0.0854395, 0.0823709,
  0.0792813, 0.0761712, 0.0730411, 0.0698916, 0.0667231, 0.0635362,
  0.0603314, 0.0571092, 0.0538703, 0.0506152, 0.0473443, 0.0440584,
  0.0407579, 0.0374435, 0.0341157, 0.0307751, 0.0274223, 0.024058,
  0.0206826, 0.0172969, 0.0139014, 0.0104969, 0.00708377, 0.00366281,
  0.000234633, -0.00320013, -0.00664083, -0.0100868, -0.0135374,
  -0.016992, -0.0204498, -0.0239103, -0.0273727, -0.0308364,
  -0.0343007, -0.0377648, -0.0412282, -0.04469, -0.0481497,
  -0.0516064, -0.0550595, -0.0585083, -0.061952, -0.06539, -0.0688215,
  -0.0722458, -0.0756622, -0.0790699, -0.0824681, -0.0858563,
  -0.0892336, -0.0925992, -0.0959525, -0.0992927, -0.102619,
  -0.105931, -0.109227, -0.112507, -0.115771, -0.119017, -0.122244,
  -0.125453, -0.128641, -0.131809, -0.134955, -0.138079, -0.141181,
  -0.144258, -0.147312, -0.15034, -0.153342, -0.156317, -0.159265,
  -0.162185, -0.165075, -0.167936, -0.170767, -0.173566, -0.176333,
  -0.179067, -0.181768, -0.184435, -0.187067, -0.189663, -0.192222,
  -0.194745, -0.197229, -0.199675, -0.202082, -0.204448, -0.206774,
  -0.209058, -0.2113, -0.213499, -0.215654, -0.217765, -0.219831,
  -0.221851, -0.223825, -0.225752, -0.227631, -0.229462, -0.231244,
  -0.232976, -0.234658, -0.236288, -0.237868, -0.239395, -0.240869,
  -0.24229, -0.243657, -0.244969, -0.246226, -0.247428, -0.248573,
  -0.249661, -0.250692, -0.251665, -0.252579, -0.253434, -0.25423,
  -0.254966, -0.255641, -0.256256, -0.256809, -0.2573, -0.257729,
  -0.258095, -0.258398, -0.258637, -0.258812, -0.258924, -0.25897,
  -0.258951, -0.258867, -0.258717, -0.258501, -0.258219, -0.25787,
  -0.257454, -0.256971, -0.256421, -0.255803, -0.255117, -0.254363,
  -0.253541, -0.252651, -0.251691, -0.250664, -0.249567, -0.248401,
  -0.247167, -0.245863, -0.244491, -0.243049, -0.241538, -0.239958,
  -0.238308, -0.23659, -0.234803, -0.232946, -0.231021, -0.229027,
  -0.226964, -0.224833, -0.222634, -0.220367, -0.218031, -0.215628,
  -0.213158, -0.210621, -0.208016, -0.205346, -0.202609, -0.199806,
  -0.196938, -0.194005, -0.191007, -0.187945, -0.18482, -0.181631,
  -0.17838, -0.175066, -0.171691, -0.168255, -0.164759, -0.161203,
  -0.157587, -0.153914, -0.150182, -0.146394, -0.142549, -0.138649,
  -0.134694, -0.130686, -0.126624, -0.12251, -0.118345, -0.11413,
  -0.109865, -0.105551, -0.101191, -0.0967834, -0.0923308, -0.0878338,
  -0.0832936, -0.0787112, -0.0740878, -0.0694246, -0.0647227,
  -0.0599834, -0.0552079, -0.0503974, -0.0455532, -0.0406767,
  -0.0357692, -0.030832, -0.0258666, -0.0208742, -0.0158565,
  -0.0108147, -0.00575049, -0.000665262, 0.00443944, 0.00956205,
  0.014701, 0.0198547, 0.0250215, 0.0301997, 0.0353878, 0.040584,
  0.0457865, 0.0509938, 0.0562039, 0.0614151, 0.0666256, 0.0718336,
  0.0770373, 0.0822347, 0.0874241, 0.0926034, 0.0977707, 0.102924,
  0.108062, 0.113182, 0.118281, 0.123359, 0.128414, 0.133442,
  0.138442, 0.143412, 0.148349, 0.153253, 0.158119, 0.162948,
  0.167735, 0.172479, 0.177178, 0.18183, 0.186432, 0.190982, 0.195478,
  0.199918, 0.204299, 0.208619, 0.212876, 0.217068, 0.221192,
  0.225246, 0.229228, 0.233135, 0.236965, 0.240715, 0.244385, 0.24797,
  0.251469, 0.25488, 0.2582, 0.261427, 0.264558, 0.267592, 0.270525,
  0.273357, 0.276084, 0.278704, 0.281215, 0.283614, 0.2859, 0.28807,
  0.290123, 0.292055, 0.293865, 0.29555, 0.297109, 0.298539, 0.299838,
  0.301004, 0.302036, 0.30293, 0.303686, 0.304301, 0.304773, 0.305101,
  0.305282, 0.305315, 0.305198, 0.304929, 0.304506, 0.303929,
  0.303195, 0.302303, 0.301251, 0.300039, 0.298663, 0.297124, 0.29542,
  0.293549, 0.291511, 0.289305, 0.286929, 0.284382, 0.281664,
  0.278774, 0.275711, 0.272475, 0.269064, 0.265479, 0.261719,
  0.257783, 0.253672, 0.249386, 0.244924, 0.240286, 0.235473,
  0.230485, 0.225323, 0.219986, 0.214475, 0.208792, 0.202937,
  0.196911, 0.190715, 0.18435, 0.177819, 0.171121, 0.16426, 0.157236,
  0.150052, 0.14271, 0.135211, 0.12756, 0.119757, 0.111806, 0.10371,
  0.095471, 0.0870935, 0.0785804, 0.0699355, 0.0611625, 0.0522654,
  0.0432485, 0.0341161, 0.024873, 0.0155239, 0.00607393, -0.00347168,
  -0.0131074, -0.0228275, -0.032626, -0.0424967, -0.0524331,
  -0.0624286, -0.0724761, -0.0825685, -0.0926981, -0.102857,
  -0.113038, -0.123232, -0.133431, -0.143625, -0.153806, -0.163963,
  -0.174088, -0.18417, -0.194198, -0.204162, -0.214051, -0.223852,
  -0.233555, -0.243147, -0.252616, -0.261948, -0.271131, -0.28015,
  -0.288992, -0.297642, -0.306086, -0.314307, -0.322291, -0.330022,
  -0.337481, -0.344654, -0.351522, -0.358068, -0.364272, -0.370117,
  -0.375583, -0.38065, -0.385298, -0.389506, -0.393253, -0.396517,
  -0.399275, -0.401506, -0.403184, -0.404287, -0.40479, -0.404668,
  -0.403894, -0.402443, -0.400288, -0.397401, -0.393753, -0.389317,
  -0.384063, -0.377961, -0.370979, -0.363087, -0.354253, -0.344443,
  -0.333624, -0.321762, -0.308821, -0.294768, -0.279563, -0.263172,
  -0.245554, -0.226673, -0.206488, -0.184959, -0.162044, -0.137701,
  -0.111889, -0.0845622, -0.0556768, -0.0251872, 0.00695301,
  0.0407912, 0.0763756, 0.113755, 0.152981, 0.194103, 0.237173,
  0.282246, 0.329374, 0.378613, 0.43002, 0.483651, 0.539564, 0.59782,
  0.658478, 0.7216, 0.787249, 0.855488, 0.926383, 1}; G4double
  G4NeutronHPFastLegendre::i15[3201] = {0, -0.000601847, -0.00115854,
  -0.00167175, -0.00214313, -0.00257427, -0.00296673, -0.00332204,
  -0.00364167, -0.00392707, -0.00417965, -0.00440078, -0.0045918,
  -0.00475401, -0.00488868, -0.00499704, -0.00508029, -0.00513961,
  -0.00517613, -0.00519096, -0.00518517, -0.00515981, -0.0051159,
  -0.00505443, -0.00497635, -0.0048826, -0.00477409, -0.00465169,
  -0.00451626, -0.00436862, -0.00420957, -0.0040399, -0.00386036,
  -0.00367168, -0.00347456, -0.0032697, -0.00305775, -0.00283935,
  -0.00261513, -0.00238569, -0.00215159, -0.00191341, -0.00167169,
  -0.00142694, -0.00117966, -0.000930341, -0.000679449, -0.000427432,
  -0.00017472, 7.82695e-05, 0.000331139, 0.000583506, 0.000835002,
  0.00108527, 0.00133399, 0.00158082, 0.00182545, 0.00206761,
  0.00230699, 0.00254333, 0.00277638, 0.0030059, 0.00323165,
  0.00345342, 0.00367099, 0.00388417, 0.00409278, 0.00429664,
  0.00449559, 0.00468948, 0.00487815, 0.00506149, 0.00523936,
  0.00541164, 0.00557824, 0.00573904, 0.00589398, 0.00604295,
  0.0061859, 0.00632275, 0.00645344, 0.00657794, 0.00669618,
  0.00680814, 0.00691378, 0.00701308, 0.00710603, 0.00719261,
  0.00727282, 0.00734665, 0.00741412, 0.00747523, 0.00753, 0.00757845,
  0.0076206, 0.00765649, 0.00768616, 0.00770963, 0.00772695,
  0.00773818, 0.00774336, 0.00774254, 0.00773578, 0.00772315,
  0.00770471, 0.00768053, 0.00765068, 0.00761522, 0.00757425,
  0.00752783, 0.00747605, 0.00741899, 0.00735674, 0.00728938,
  0.00721701, 0.00713972, 0.00705759, 0.00697074, 0.00687924,
  0.0067832, 0.00668273, 0.00657791, 0.00646886, 0.00635567,
  0.00623846, 0.00611731, 0.00599235, 0.00586368, 0.0057314,
  0.00559562, 0.00545645, 0.005314, 0.00516838, 0.00501969,
  0.00486806, 0.00471358, 0.00455636, 0.00439652, 0.00423417,
  0.00406941, 0.00390235, 0.00373311, 0.0035618, 0.00338851,
  0.00321337, 0.00303647, 0.00285792, 0.00267784, 0.00249633,
  0.00231349, 0.00212942, 0.00194425, 0.00175805, 0.00157095,
  0.00138304, 0.00119442, 0.00100519, 0.000815457, 0.000625313,
  0.000434856, 0.000244183, 5.33901e-05, -0.000137429, -0.000328182,
  -0.000518775, -0.000709118, -0.000899122, -0.0010887, -0.00127776,
  -0.00146621, -0.00165398, -0.00184098, -0.00202713, -0.00221234,
  -0.00239654, -0.00257965, -0.00276159, -0.00294228, -0.00312165,
  -0.00329963, -0.00347614, -0.00365112, -0.0038245, -0.00399621,
  -0.00416617, -0.00433434, -0.00450064, -0.00466502, -0.00482741,
  -0.00498775, -0.00514599, -0.00530207, -0.00545593, -0.00560753,
  -0.00575681, -0.00590372, -0.00604821, -0.00619024, -0.00632976,
  -0.00646672, -0.00660108, -0.0067328, -0.00686184, -0.00698816,
  -0.00711172, -0.0072325, -0.00735044, -0.00746553, -0.00757772,
  -0.00768699, -0.00779331, -0.00789665, -0.00799698, -0.00809429,
  -0.00818854, -0.00827972, -0.0083678, -0.00845277, -0.0085346,
  -0.00861328, -0.00868879, -0.00876112, -0.00883026, -0.0088962,
  -0.00895892, -0.00901841, -0.00907467, -0.00912769, -0.00917746,
  -0.00922398, -0.00926725, -0.00930726, -0.00934402, -0.00937752,
  -0.00940776, -0.00943475, -0.00945849, -0.00947899, -0.00949625,
  -0.00951027, -0.00952107, -0.00952865, -0.00953302, -0.0095342,
  -0.00953219, -0.00952702, -0.00951868, -0.0095072, -0.00949259,
  -0.00947487, -0.00945406, -0.00943017, -0.00940322, -0.00937323,
  -0.00934023, -0.00930423, -0.00926526, -0.00922333, -0.00917849,
  -0.00913073, -0.0090801, -0.00902662, -0.00897032, -0.00891122,
  -0.00884935, -0.00878474, -0.00871742, -0.00864742, -0.00857477,
  -0.0084995, -0.00842164, -0.00834123, -0.0082583, -0.00817287,
  -0.008085, -0.0079947, -0.00790201, -0.00780698, -0.00770963,
  -0.00761001, -0.00750814, -0.00740407, -0.00729784, -0.00718947,
  -0.00707902, -0.00696651, -0.00685199, -0.0067355, -0.00661707,
  -0.00649675, -0.00637458, -0.00625059, -0.00612483, -0.00599734,
  -0.00586817, -0.00573734, -0.0056049, -0.0054709, -0.00533538,
  -0.00519838, -0.00505994, -0.0049201, -0.00477891, -0.00463641,
  -0.00449264, -0.00434765, -0.00420147, -0.00405416, -0.00390575,
  -0.00375629, -0.00360581, -0.00345438, -0.00330202, -0.00314878,
  -0.0029947, -0.00283983, -0.00268422, -0.00252789, -0.0023709,
  -0.00221329, -0.0020551, -0.00189638, -0.00173716, -0.00157749,
  -0.00141742, -0.00125698, -0.00109622, -0.000935178, -0.000773896,
  -0.000612418, -0.000450783, -0.000289035, -0.000127213, 3.46408e-05,
  0.000196486, 0.000358282, 0.000519988, 0.000681565, 0.000842972,
  0.00100417, 0.00116512, 0.00132578, 0.00148612, 0.00164609,
  0.00180566, 0.00196478, 0.00212343, 0.00228157, 0.00243914,
  0.00259613, 0.0027525, 0.0029082, 0.0030632, 0.00321747, 0.00337097,
  0.00352367, 0.00367553, 0.00382652, 0.00397661, 0.00412576,
  0.00427393, 0.00442111, 0.00456724, 0.00471232, 0.00485629,
  0.00499913, 0.00514082, 0.00528131, 0.00542059, 0.00555862,
  0.00569537, 0.00583081, 0.00596493, 0.00609768, 0.00622904,
  0.00635899, 0.0064875, 0.00661454, 0.00674009, 0.00686413,
  0.00698662, 0.00710755, 0.00722689, 0.00734462, 0.00746072,
  0.00757516, 0.00768792, 0.00779899, 0.00790833, 0.00801594,
  0.00812179, 0.00822585, 0.00832812, 0.00842858, 0.0085272,
  0.00862397, 0.00871887, 0.00881189, 0.008903, 0.00899221,
  0.00907948, 0.0091648, 0.00924817, 0.00932956, 0.00940896,
  0.00948637, 0.00956176, 0.00963514, 0.00970647, 0.00977577,
  0.009843, 0.00990818, 0.00997127, 0.0100323, 0.0100912, 0.010148,
  0.0102028, 0.0102554, 0.0103058, 0.0103542, 0.0104004, 0.0104445,
  0.0104864, 0.0105262, 0.0105639, 0.0105994, 0.0106327, 0.0106639,
  0.0106929, 0.0107197, 0.0107444, 0.0107669, 0.0107873, 0.0108055,
  0.0108215, 0.0108354, 0.0108471, 0.0108566, 0.010864, 0.0108692,
  0.0108723, 0.0108732, 0.010872, 0.0108686, 0.0108632, 0.0108555,
  0.0108458, 0.0108339, 0.0108199, 0.0108038, 0.0107857, 0.0107654,
  0.010743, 0.0107186, 0.0106921, 0.0106635, 0.0106329, 0.0106002,
  0.0105656, 0.0105289, 0.0104901, 0.0104494, 0.0104067, 0.0103621,
  0.0103154, 0.0102669, 0.0102163, 0.0101639, 0.0101096, 0.0100533,
  0.00999517, 0.00993517, 0.00987331, 0.00980961, 0.00974408,
  0.00967675, 0.00960762, 0.00953671, 0.00946404, 0.00938963,
  0.00931349, 0.00923563, 0.00915608, 0.00907485, 0.00899197,
  0.00890744, 0.00882129, 0.00873353, 0.00864418, 0.00855327,
  0.00846081, 0.00836683, 0.00827133, 0.00817434, 0.00807588,
  0.00797597, 0.00787463, 0.00777189, 0.00766775, 0.00756225,
  0.0074554, 0.00734722, 0.00723775, 0.00712698, 0.00701496,
  0.0069017, 0.00678722, 0.00667155, 0.0065547, 0.00643671,
  0.00631758, 0.00619735, 0.00607604, 0.00595367, 0.00583026,
  0.00570584, 0.00558043, 0.00545405, 0.00532673, 0.00519849,
  0.00506935, 0.00493934, 0.00480848, 0.00467679, 0.0045443,
  0.00441104, 0.00427702, 0.00414227, 0.00400681, 0.00387067,
  0.00373388, 0.00359645, 0.00345842, 0.00331979, 0.00318061,
  0.00304089, 0.00290066, 0.00275995, 0.00261877, 0.00247715,
  0.00233511, 0.00219269, 0.0020499, 0.00190677, 0.00176332,
  0.00161958, 0.00147557, 0.00133131, 0.00118684, 0.00104217,
  0.000897326, 0.000752336, 0.000607223, 0.000462009, 0.00031672,
  0.000171379, 2.60098e-05, -0.000119363, -0.000264717, -0.000410028,
  -0.000555272, -0.000700426, -0.000845466, -0.00099037, -0.00113511,
  -0.00127967, -0.00142403, -0.00156815, -0.00171202, -0.00185562,
  -0.00199892, -0.0021419, -0.00228454, -0.00242681, -0.0025687,
  -0.00271017, -0.00285122, -0.00299181, -0.00313193, -0.00327155,
  -0.00341066, -0.00354923, -0.00368723, -0.00382466, -0.00396148,
  -0.00409769, -0.00423325, -0.00436814, -0.00450235, -0.00463586,
  -0.00476865, -0.00490069, -0.00503197, -0.00516247, -0.00529216,
  -0.00542104, -0.00554907, -0.00567625, -0.00580255, -0.00592796,
  -0.00605245, -0.00617601, -0.00629863, -0.00642027, -0.00654093,
  -0.0066606, -0.00677924, -0.00689685, -0.0070134, -0.00712889,
  -0.00724329, -0.0073566, -0.00746879, -0.00757984, -0.00768975,
  -0.0077985, -0.00790606, -0.00801244, -0.00811761, -0.00822156,
  -0.00832428, -0.00842574, -0.00852594, -0.00862487, -0.00872251,
  -0.00881884, -0.00891386, -0.00900755, -0.00909991, -0.00919091,
  -0.00928054, -0.0093688, -0.00945568, -0.00954115, -0.00962522,
  -0.00970786, -0.00978908, -0.00986885, -0.00994718, -0.010024,
  -0.0100994, -0.0101733, -0.0102458, -0.0103167, -0.0103861,
  -0.010454, -0.0105204, -0.0105853, -0.0106486, -0.0107104,
  -0.0107706, -0.0108292, -0.0108863, -0.0109419, -0.0109958,
  -0.0110481, -0.0110989, -0.0111481, -0.0111957, -0.0112416,
  -0.011286, -0.0113287, -0.0113698, -0.0114093, -0.0114472,
  -0.0114834, -0.011518, -0.011551, -0.0115823, -0.0116119, -0.01164,
  -0.0116664, -0.0116911, -0.0117142, -0.0117356, -0.0117554,
  -0.0117735, -0.0117899, -0.0118047, -0.0118179, -0.0118294,
  -0.0118392, -0.0118474, -0.0118539, -0.0118588, -0.011862,
  -0.0118635, -0.0118635, -0.0118617, -0.0118583, -0.0118533,
  -0.0118466, -0.0118383, -0.0118284, -0.0118168, -0.0118035,
  -0.0117887, -0.0117722, -0.0117541, -0.0117344, -0.0117131,
  -0.0116902, -0.0116657, -0.0116396, -0.0116119, -0.0115826,
  -0.0115517, -0.0115192, -0.0114852, -0.0114496, -0.0114125,
  -0.0113738, -0.0113336, -0.0112918, -0.0112485, -0.0112037,
  -0.0111574, -0.0111096, -0.0110602, -0.0110094, -0.0109571,
  -0.0109033, -0.0108481, -0.0107914, -0.0107333, -0.0106737,
  -0.0106127, -0.0105503, -0.0104864, -0.0104212, -0.0103546,
  -0.0102866, -0.0102172, -0.0101465, -0.0100744, -0.010001,
  -0.00992631, -0.00985027, -0.00977292, -0.00969429, -0.00961438,
  -0.00953319, -0.00945076, -0.00936708, -0.00928216, -0.00919603,
  -0.00910869, -0.00902016, -0.00893045, -0.00883956, -0.00874753,
  -0.00865435, -0.00856004, -0.00846461, -0.00836808, -0.00827046,
  -0.00817177, -0.00807202, -0.00797122, -0.00786938, -0.00776653,
  -0.00766267, -0.00755782, -0.00745199, -0.0073452, -0.00723746,
  -0.00712879, -0.00701921, -0.00690872, -0.00679734, -0.00668509,
  -0.00657199, -0.00645804, -0.00634326, -0.00622767, -0.00611129,
  -0.00599413, -0.0058762, -0.00575752, -0.00563811, -0.00551798,
  -0.00539715, -0.00527563, -0.00515345, -0.00503061, -0.00490713,
  -0.00478304, -0.00465833, -0.00453304, -0.00440718, -0.00428076,
  -0.0041538, -0.00402632, -0.00389833, -0.00376985, -0.00364089,
  -0.00351148, -0.00338163, -0.00325136, -0.00312068, -0.0029896,
  -0.00285816, -0.00272636, -0.00259421, -0.00246175, -0.00232897,
  -0.00219591, -0.00206257, -0.00192898, -0.00179515, -0.0016611,
  -0.00152683, -0.00139238, -0.00125776, -0.00112298, -0.000988068,
  -0.000853029, -0.000717885, -0.000582653, -0.000447349,
  -0.000311989, -0.000176592, -4.11725e-05, 9.4252e-05, 0.000229665,
  0.00036505, 0.00050039, 0.000635668, 0.00077087, 0.000905977,
  0.00104097, 0.00117584, 0.00131057, 0.00144513, 0.00157953,
  0.00171372, 0.00184771, 0.00198148, 0.002115, 0.00224827,
  0.00238127, 0.00251398, 0.00264638, 0.00277847, 0.00291022,
  0.00304161, 0.00317264, 0.00330329, 0.00343354, 0.00356338,
  0.00369279, 0.00382175, 0.00395026, 0.00407829, 0.00420584,
  0.00433288, 0.0044594, 0.00458539, 0.00471083, 0.0048357, 0.00496,
  0.00508371, 0.00520681, 0.0053293, 0.00545115, 0.00557235,
  0.00569288, 0.00581275, 0.00593192, 0.00605039, 0.00616814,
  0.00628516, 0.00640144, 0.00651696, 0.00663172, 0.00674569,
  0.00685886, 0.00697122, 0.00708277, 0.00719348, 0.00730334,
  0.00741235, 0.00752048, 0.00762773, 0.00773409, 0.00783954,
  0.00794407, 0.00804767, 0.00815033, 0.00825204, 0.00835279,
  0.00845255, 0.00855134, 0.00864912, 0.0087459, 0.00884166,
  0.00893639, 0.00903009, 0.00912273, 0.00921431, 0.00930483,
  0.00939427, 0.00948261, 0.00956986, 0.00965601, 0.00974103,
  0.00982494, 0.0099077, 0.00998933, 0.0100698, 0.0101491, 0.0102272,
  0.0103042, 0.01038, 0.0104546, 0.010528, 0.0106001, 0.0106711,
  0.0107408, 0.0108094, 0.0108766, 0.0109426, 0.0110074, 0.0110709,
  0.0111332, 0.0111942, 0.0112539, 0.0113123, 0.0113694, 0.0114253,
  0.0114798, 0.011533, 0.011585, 0.0116356, 0.0116849, 0.0117328,
  0.0117795, 0.0118248, 0.0118687, 0.0119114, 0.0119526, 0.0119926,
  0.0120311, 0.0120683, 0.0121042, 0.0121387, 0.0121718, 0.0122035,
  0.0122339, 0.0122629, 0.0122905, 0.0123168, 0.0123416, 0.0123651,
  0.0123872, 0.0124079, 0.0124272, 0.0124452, 0.0124617, 0.0124768,
  0.0124906, 0.0125029, 0.0125139, 0.0125235, 0.0125316, 0.0125384,
  0.0125438, 0.0125478, 0.0125504, 0.0125516, 0.0125514, 0.0125498,
  0.0125468, 0.0125424, 0.0125367, 0.0125295, 0.012521, 0.012511,
  0.0124997, 0.0124871, 0.012473, 0.0124576, 0.0124408, 0.0124226,
  0.012403, 0.0123821, 0.0123598, 0.0123362, 0.0123112, 0.0122849,
  0.0122572, 0.0122281, 0.0121978, 0.012166, 0.012133, 0.0120986,
  0.0120629, 0.0120259, 0.0119876, 0.011948, 0.011907, 0.0118648,
  0.0118212, 0.0117764, 0.0117303, 0.0116829, 0.0116343, 0.0115843,
  0.0115332, 0.0114807, 0.0114271, 0.0113721, 0.011316, 0.0112586,
  0.0112, 0.0111402, 0.0110792, 0.011017, 0.0109536, 0.010889,
  0.0108232, 0.0107563, 0.0106882, 0.010619, 0.0105486, 0.0104771,
  0.0104044, 0.0103306, 0.0102558, 0.0101798, 0.0101027, 0.0100245,
  0.00994529, 0.00986498, 0.00978362, 0.00970121, 0.00961776,
  0.00953328, 0.00944778, 0.00936127, 0.00927375, 0.00918525,
  0.00909577, 0.00900532, 0.0089139, 0.00882154, 0.00872823, 0.008634,
  0.00853884, 0.00844278, 0.00834582, 0.00824797, 0.00814925,
  0.00804966, 0.00794921, 0.00784793, 0.00774581, 0.00764287,
  0.00753911, 0.00743457, 0.00732923, 0.00722312, 0.00711624,
  0.00700861, 0.00690025, 0.00679115, 0.00668134, 0.00657082,
  0.00645961, 0.00634771, 0.00623515, 0.00612194, 0.00600807,
  0.00589358, 0.00577847, 0.00566275, 0.00554643, 0.00542953,
  0.00531206, 0.00519404, 0.00507547, 0.00495637, 0.00483675,
  0.00471662, 0.004596, 0.00447489, 0.00435332, 0.0042313, 0.00410883,
  0.00398593, 0.00386262, 0.0037389, 0.0036148, 0.00349031,
  0.00336547, 0.00324027, 0.00311474, 0.00298888, 0.00286271,
  0.00273624, 0.00260949, 0.00248247, 0.00235519, 0.00222766,
  0.0020999, 0.00197193, 0.00184375, 0.00171538, 0.00158684,
  0.00145812, 0.00132926, 0.00120026, 0.00107114, 0.000941903,
  0.000812571, 0.000683156, 0.000553669, 0.000424126, 0.000294539,
  0.000164921, 3.52866e-05, -9.43516e-05, -0.00022398, -0.000353585,
  -0.000483154, -0.000612674, -0.00074213, -0.00087151, -0.0010008,
  -0.00112999, -0.00125906, -0.001388, -0.0015168, -0.00164545,
  -0.00177392, -0.00190222, -0.00203032, -0.00215821, -0.00228588,
  -0.00241332, -0.00254051, -0.00266744, -0.00279409, -0.00292047,
  -0.00304654, -0.00317231, -0.00329775, -0.00342285, -0.0035476,
  -0.003672, -0.00379602, -0.00391965, -0.00404289, -0.00416571,
  -0.00428811, -0.00441007, -0.00453159, -0.00465264, -0.00477322,
  -0.00489332, -0.00501292, -0.00513202, -0.00525059, -0.00536863,
  -0.00548613, -0.00560307, -0.00571944, -0.00583524, -0.00595045,
  -0.00606505, -0.00617904, -0.00629241, -0.00640514, -0.00651722,
  -0.00662864, -0.0067394, -0.00684948, -0.00695887, -0.00706755,
  -0.00717552, -0.00728277, -0.00738929, -0.00749506, -0.00760008,
  -0.00770434, -0.00780782, -0.00791051, -0.00801241, -0.00811351,
  -0.00821379, -0.00831324, -0.00841187, -0.00850965, -0.00860657,
  -0.00870263, -0.00879782, -0.00889213, -0.00898555, -0.00907807,
  -0.00916968, -0.00926038, -0.00935014, -0.00943898, -0.00952687,
  -0.0096138, -0.00969978, -0.00978479, -0.00986882, -0.00995187,
  -0.0100339, -0.010115, -0.010195, -0.0102741, -0.0103521, -0.010429,
  -0.010505, -0.0105799, -0.0106537, -0.0107265, -0.0107982,
  -0.0108689, -0.0109384, -0.0110069, -0.0110743, -0.0111406,
  -0.0112057, -0.0112698, -0.0113328, -0.0113946, -0.0114553,
  -0.0115148, -0.0115733, -0.0116305, -0.0116867, -0.0117416,
  -0.0117954, -0.0118481, -0.0118995, -0.0119498, -0.0119989,
  -0.0120469, -0.0120936, -0.0121391, -0.0121835, -0.0122266,
  -0.0122686, -0.0123093, -0.0123488, -0.0123871, -0.0124242,
  -0.01246, -0.0124946, -0.012528, -0.0125602, -0.0125911, -0.0126208,
  -0.0126493, -0.0126765, -0.0127024, -0.0127271, -0.0127506,
  -0.0127728, -0.0127938, -0.0128135, -0.0128319, -0.0128491,
  -0.012865, -0.0128797, -0.0128931, -0.0129052, -0.0129161,
  -0.0129257, -0.012934, -0.0129411, -0.0129469, -0.0129515,
  -0.0129548, -0.0129568, -0.0129575, -0.012957, -0.0129552,
  -0.0129522, -0.0129478, -0.0129423, -0.0129354, -0.0129273,
  -0.012918, -0.0129073, -0.0128954, -0.0128823, -0.0128679,
  -0.0128523, -0.0128354, -0.0128172, -0.0127978, -0.0127772,
  -0.0127553, -0.0127322, -0.0127078, -0.0126822, -0.0126554,
  -0.0126273, -0.012598, -0.0125675, -0.0125358, -0.0125028,
  -0.0124687, -0.0124333, -0.0123967, -0.0123589, -0.01232,
  -0.0122798, -0.0122384, -0.0121959, -0.0121522, -0.0121072,
  -0.0120612, -0.0120139, -0.0119655, -0.0119159, -0.0118652,
  -0.0118134, -0.0117604, -0.0117062, -0.0116509, -0.0115945,
  -0.011537, -0.0114784, -0.0114186, -0.0113578, -0.0112958,
  -0.0112328, -0.0111687, -0.0111035, -0.0110372, -0.0109699,
  -0.0109015, -0.0108321, -0.0107616, -0.0106901, -0.0106175,
  -0.0105439, -0.0104694, -0.0103938, -0.0103172, -0.0102396,
  -0.010161, -0.0100815, -0.0100009, -0.00991946, -0.00983703,
  -0.00975365, -0.00966934, -0.00958409, -0.00949793, -0.00941085,
  -0.00932287, -0.009234, -0.00914423, -0.0090536, -0.00896209,
  -0.00886972, -0.00877651, -0.00868245, -0.00858756, -0.00849184,
  -0.00839532, -0.00829799, -0.00819986, -0.00810095, -0.00800126,
  -0.00790081, -0.0077996, -0.00769764, -0.00759495, -0.00749153,
  -0.0073874, -0.00728256, -0.00717702, -0.00707079, -0.00696389,
  -0.00685633, -0.00674811, -0.00663924, -0.00652975, -0.00641962,
  -0.00630889, -0.00619755, -0.00608562, -0.00597311, -0.00586003,
  -0.00574639, -0.00563221, -0.00551748, -0.00540223, -0.00528647,
  -0.0051702, -0.00505344, -0.00493619, -0.00481848, -0.00470031,
  -0.00458169, -0.00446263, -0.00434315, -0.00422326, -0.00410296,
  -0.00398227, -0.00386121, -0.00373977, -0.00361798, -0.00349585,
  -0.00337338, -0.0032506, -0.0031275, -0.00300411, -0.00288043,
  -0.00275648, -0.00263227, -0.0025078, -0.0023831, -0.00225817,
  -0.00213303, -0.00200768, -0.00188215, -0.00175643, -0.00163055,
  -0.00150452, -0.00137834, -0.00125203, -0.0011256, -0.000999065,
  -0.000872435, -0.000745723, -0.00061894, -0.000492098, -0.000365209,
  -0.000238286, -0.000111341, 1.56157e-05, 0.00014257, 0.000269512,
  0.000396427, 0.000523306, 0.000650134, 0.000776902, 0.000903595,
  0.0010302, 0.00115671, 0.00128312, 0.0014094, 0.00153554,
  0.00166154, 0.00178739, 0.00191306, 0.00203856, 0.00216386,
  0.00228896, 0.00241384, 0.00253849, 0.0026629, 0.00278706,
  0.00291096, 0.00303458, 0.00315792, 0.00328096, 0.00340369,
  0.00352609, 0.00364817, 0.0037699, 0.00389127, 0.00401228,
  0.00413291, 0.00425314, 0.00437298, 0.0044924, 0.00461141,
  0.00472997, 0.00484809, 0.00496575, 0.00508295, 0.00519966,
  0.00531589, 0.00543161, 0.00554682, 0.00566151, 0.00577566,
  0.00588927, 0.00600233, 0.00611482, 0.00622673, 0.00633806,
  0.00644879, 0.00655892, 0.00666842, 0.0067773, 0.00688554,
  0.00699313, 0.00710006, 0.00720633, 0.00731191, 0.00741681,
  0.00752101, 0.0076245, 0.00772728, 0.00782932, 0.00793064,
  0.0080312, 0.00813101, 0.00823005, 0.00832832, 0.00842581,
  0.0085225, 0.0086184, 0.00871348, 0.00880774, 0.00890118,
  0.00899378, 0.00908553, 0.00917643, 0.00926647, 0.00935563,
  0.00944392, 0.00953132, 0.00961782, 0.00970342, 0.00978811,
  0.00987187, 0.00995471, 0.0100366, 0.0101176, 0.0101976, 0.0102766,
  0.0103547, 0.0104319, 0.010508, 0.0105831, 0.0106573, 0.0107305,
  0.0108026, 0.0108737, 0.0109438, 0.0110129, 0.011081, 0.011148,
  0.011214, 0.0112789, 0.0113427, 0.0114055, 0.0114672, 0.0115279,
  0.0115874, 0.0116459, 0.0117033, 0.0117596, 0.0118148, 0.0118688,
  0.0119218, 0.0119736, 0.0120243, 0.0120739, 0.0121224, 0.0121697,
  0.0122159, 0.0122609, 0.0123048, 0.0123475, 0.0123891, 0.0124295,
  0.0124687, 0.0125068, 0.0125437, 0.0125794, 0.0126139, 0.0126473,
  0.0126795, 0.0127105, 0.0127403, 0.0127689, 0.0127963, 0.0128225,
  0.0128475, 0.0128712, 0.0128938, 0.0129152, 0.0129354, 0.0129543,
  0.0129721, 0.0129886, 0.0130039, 0.013018, 0.0130308, 0.0130425,
  0.0130529, 0.0130621, 0.0130701, 0.0130768, 0.0130823, 0.0130866,
  0.0130897, 0.0130916, 0.0130922, 0.0130916, 0.0130897, 0.0130866,
  0.0130823, 0.0130768, 0.0130701, 0.0130621, 0.0130529, 0.0130425,
  0.0130308, 0.013018, 0.0130039, 0.0129886, 0.0129721, 0.0129543,
  0.0129354, 0.0129152, 0.0128938, 0.0128712, 0.0128475, 0.0128225,
  0.0127963, 0.0127689, 0.0127403, 0.0127105, 0.0126795, 0.0126473,
  0.0126139, 0.0125794, 0.0125437, 0.0125068, 0.0124687, 0.0124295,
  0.0123891, 0.0123475, 0.0123048, 0.0122609, 0.0122159, 0.0121697,
  0.0121224, 0.0120739, 0.0120243, 0.0119736, 0.0119218, 0.0118688,
  0.0118148, 0.0117596, 0.0117033, 0.0116459, 0.0115874, 0.0115279,
  0.0114672, 0.0114055, 0.0113427, 0.0112789, 0.011214, 0.011148,
  0.011081, 0.0110129, 0.0109438, 0.0108737, 0.0108026, 0.0107305,
  0.0106573, 0.0105831, 0.010508, 0.0104319, 0.0103547, 0.0102766,
  0.0101976, 0.0101176, 0.0100366, 0.00995471, 0.00987187, 0.00978811,
  0.00970342, 0.00961782, 0.00953132, 0.00944392, 0.00935563,
  0.00926647, 0.00917643, 0.00908553, 0.00899378, 0.00890118,
  0.00880774, 0.00871348, 0.0086184, 0.0085225, 0.00842581,
  0.00832832, 0.00823005, 0.00813101, 0.0080312, 0.00793064,
  0.00782932, 0.00772728, 0.0076245, 0.00752101, 0.00741681,
  0.00731191, 0.00720633, 0.00710006, 0.00699313, 0.00688554,
  0.0067773, 0.00666842, 0.00655892, 0.00644879, 0.00633806,
  0.00622673, 0.00611482, 0.00600233, 0.00588927, 0.00577566,
  0.00566151, 0.00554682, 0.00543161, 0.00531589, 0.00519966,
  0.00508295, 0.00496575, 0.00484809, 0.00472997, 0.00461141,
  0.0044924, 0.00437298, 0.00425314, 0.00413291, 0.00401228,
  0.00389127, 0.0037699, 0.00364817, 0.00352609, 0.00340369,
  0.00328096, 0.00315792, 0.00303458, 0.00291096, 0.00278706,
  0.0026629, 0.00253849, 0.00241384, 0.00228896, 0.00216386,
  0.00203856, 0.00191306, 0.00178739, 0.00166154, 0.00153554,
  0.0014094, 0.00128312, 0.00115671, 0.0010302, 0.000903595,
  0.000776902, 0.000650134, 0.000523306, 0.000396427, 0.000269512,
  0.00014257, 1.56157e-05, -0.000111341, -0.000238286, -0.000365209,
  -0.000492098, -0.00061894, -0.000745723, -0.000872435, -0.000999065,
  -0.0011256, -0.00125203, -0.00137834, -0.00150452, -0.00163055,
  -0.00175643, -0.00188215, -0.00200768, -0.00213303, -0.00225817,
  -0.0023831, -0.0025078, -0.00263227, -0.00275648, -0.00288043,
  -0.00300411, -0.0031275, -0.0032506, -0.00337338, -0.00349585,
  -0.00361798, -0.00373977, -0.00386121, -0.00398227, -0.00410296,
  -0.00422326, -0.00434315, -0.00446263, -0.00458169, -0.00470031,
  -0.00481848, -0.00493619, -0.00505344, -0.0051702, -0.00528647,
  -0.00540223, -0.00551748, -0.00563221, -0.00574639, -0.00586003,
  -0.00597311, -0.00608562, -0.00619755, -0.00630889, -0.00641962,
  -0.00652975, -0.00663924, -0.00674811, -0.00685633, -0.00696389,
  -0.00707079, -0.00717702, -0.00728256, -0.0073874, -0.00749153,
  -0.00759495, -0.00769764, -0.0077996, -0.00790081, -0.00800126,
  -0.00810095, -0.00819986, -0.00829799, -0.00839532, -0.00849184,
  -0.00858756, -0.00868245, -0.00877651, -0.00886972, -0.00896209,
  -0.0090536, -0.00914423, -0.009234, -0.00932287, -0.00941085,
  -0.00949793, -0.00958409, -0.00966934, -0.00975365, -0.00983703,
  -0.00991946, -0.0100009, -0.0100815, -0.010161, -0.0102396,
  -0.0103172, -0.0103938, -0.0104694, -0.0105439, -0.0106175,
  -0.0106901, -0.0107616, -0.0108321, -0.0109015, -0.0109699,
  -0.0110372, -0.0111035, -0.0111687, -0.0112328, -0.0112958,
  -0.0113578, -0.0114186, -0.0114784, -0.011537, -0.0115945,
  -0.0116509, -0.0117062, -0.0117604, -0.0118134, -0.0118652,
  -0.0119159, -0.0119655, -0.0120139, -0.0120612, -0.0121072,
  -0.0121522, -0.0121959, -0.0122384, -0.0122798, -0.01232,
  -0.0123589, -0.0123967, -0.0124333, -0.0124687, -0.0125028,
  -0.0125358, -0.0125675, -0.012598, -0.0126273, -0.0126554,
  -0.0126822, -0.0127078, -0.0127322, -0.0127553, -0.0127772,
  -0.0127978, -0.0128172, -0.0128354, -0.0128523, -0.0128679,
  -0.0128823, -0.0128954, -0.0129073, -0.012918, -0.0129273,
  -0.0129354, -0.0129423, -0.0129478, -0.0129522, -0.0129552,
  -0.012957, -0.0129575, -0.0129568, -0.0129548, -0.0129515,
  -0.0129469, -0.0129411, -0.012934, -0.0129257, -0.0129161,
  -0.0129052, -0.0128931, -0.0128797, -0.012865, -0.0128491,
  -0.0128319, -0.0128135, -0.0127938, -0.0127728, -0.0127506,
  -0.0127271, -0.0127024, -0.0126765, -0.0126493, -0.0126208,
  -0.0125911, -0.0125602, -0.012528, -0.0124946, -0.01246, -0.0124242,
  -0.0123871, -0.0123488, -0.0123093, -0.0122686, -0.0122266,
  -0.0121835, -0.0121391, -0.0120936, -0.0120469, -0.0119989,
  -0.0119498, -0.0118995, -0.0118481, -0.0117954, -0.0117416,
  -0.0116867, -0.0116305, -0.0115733, -0.0115148, -0.0114553,
  -0.0113946, -0.0113328, -0.0112698, -0.0112057, -0.0111406,
  -0.0110743, -0.0110069, -0.0109384, -0.0108689, -0.0107982,
  -0.0107265, -0.0106537, -0.0105799, -0.010505, -0.010429,
  -0.0103521, -0.0102741, -0.010195, -0.010115, -0.0100339,
  -0.00995187, -0.00986882, -0.00978479, -0.00969978, -0.0096138,
  -0.00952687, -0.00943898, -0.00935014, -0.00926038, -0.00916968,
  -0.00907807, -0.00898555, -0.00889213, -0.00879782, -0.00870263,
  -0.00860657, -0.00850965, -0.00841187, -0.00831324, -0.00821379,
  -0.00811351, -0.00801241, -0.00791051, -0.00780782, -0.00770434,
  -0.00760008, -0.00749506, -0.00738929, -0.00728277, -0.00717552,
  -0.00706755, -0.00695887, -0.00684948, -0.0067394, -0.00662864,
  -0.00651722, -0.00640514, -0.00629241, -0.00617904, -0.00606505,
  -0.00595045, -0.00583524, -0.00571944, -0.00560307, -0.00548613,
  -0.00536863, -0.00525059, -0.00513202, -0.00501292, -0.00489332,
  -0.00477322, -0.00465264, -0.00453159, -0.00441007, -0.00428811,
  -0.00416571, -0.00404289, -0.00391965, -0.00379602, -0.003672,
  -0.0035476, -0.00342285, -0.00329775, -0.00317231, -0.00304654,
  -0.00292047, -0.00279409, -0.00266744, -0.00254051, -0.00241332,
  -0.00228588, -0.00215821, -0.00203032, -0.00190222, -0.00177392,
  -0.00164545, -0.0015168, -0.001388, -0.00125906, -0.00112999,
  -0.0010008, -0.00087151, -0.00074213, -0.000612674, -0.000483154,
  -0.000353585, -0.00022398, -9.43516e-05, 3.52866e-05, 0.000164921,
  0.000294539, 0.000424126, 0.000553669, 0.000683156, 0.000812571,
  0.000941903, 0.00107114, 0.00120026, 0.00132926, 0.00145812,
  0.00158684, 0.00171538, 0.00184375, 0.00197193, 0.0020999,
  0.00222766, 0.00235519, 0.00248247, 0.00260949, 0.00273624,
  0.00286271, 0.00298888, 0.00311474, 0.00324027, 0.00336547,
  0.00349031, 0.0036148, 0.0037389, 0.00386262, 0.00398593,
  0.00410883, 0.0042313, 0.00435332, 0.00447489, 0.004596, 0.00471662,
  0.00483675, 0.00495637, 0.00507547, 0.00519404, 0.00531206,
  0.00542953, 0.00554643, 0.00566275, 0.00577847, 0.00589358,
  0.00600807, 0.00612194, 0.00623515, 0.00634771, 0.00645961,
  0.00657082, 0.00668134, 0.00679115, 0.00690025, 0.00700861,
  0.00711624, 0.00722312, 0.00732923, 0.00743457, 0.00753911,
  0.00764287, 0.00774581, 0.00784793, 0.00794921, 0.00804966,
  0.00814925, 0.00824797, 0.00834582, 0.00844278, 0.00853884,
  0.008634, 0.00872823, 0.00882154, 0.0089139, 0.00900532, 0.00909577,
  0.00918525, 0.00927375, 0.00936127, 0.00944778, 0.00953328,
  0.00961776, 0.00970121, 0.00978362, 0.00986498, 0.00994529,
  0.0100245, 0.0101027, 0.0101798, 0.0102558, 0.0103306, 0.0104044,
  0.0104771, 0.0105486, 0.010619, 0.0106882, 0.0107563, 0.0108232,
  0.010889, 0.0109536, 0.011017, 0.0110792, 0.0111402, 0.0112,
  0.0112586, 0.011316, 0.0113721, 0.0114271, 0.0114807, 0.0115332,
  0.0115843, 0.0116343, 0.0116829, 0.0117303, 0.0117764, 0.0118212,
  0.0118648, 0.011907, 0.011948, 0.0119876, 0.0120259, 0.0120629,
  0.0120986, 0.012133, 0.012166, 0.0121978, 0.0122281, 0.0122572,
  0.0122849, 0.0123112, 0.0123362, 0.0123598, 0.0123821, 0.012403,
  0.0124226, 0.0124408, 0.0124576, 0.012473, 0.0124871, 0.0124997,
  0.012511, 0.012521, 0.0125295, 0.0125367, 0.0125424, 0.0125468,
  0.0125498, 0.0125514, 0.0125516, 0.0125504, 0.0125478, 0.0125438,
  0.0125384, 0.0125316, 0.0125235, 0.0125139, 0.0125029, 0.0124906,
  0.0124768, 0.0124617, 0.0124452, 0.0124272, 0.0124079, 0.0123872,
  0.0123651, 0.0123416, 0.0123168, 0.0122905, 0.0122629, 0.0122339,
  0.0122035, 0.0121718, 0.0121387, 0.0121042, 0.0120683, 0.0120311,
  0.0119926, 0.0119526, 0.0119114, 0.0118687, 0.0118248, 0.0117795,
  0.0117328, 0.0116849, 0.0116356, 0.011585, 0.011533, 0.0114798,
  0.0114253, 0.0113694, 0.0113123, 0.0112539, 0.0111942, 0.0111332,
  0.0110709, 0.0110074, 0.0109426, 0.0108766, 0.0108094, 0.0107408,
  0.0106711, 0.0106001, 0.010528, 0.0104546, 0.01038, 0.0103042,
  0.0102272, 0.0101491, 0.0100698, 0.00998933, 0.0099077, 0.00982494,
  0.00974103, 0.00965601, 0.00956986, 0.00948261, 0.00939427,
  0.00930483, 0.00921431, 0.00912273, 0.00903009, 0.00893639,
  0.00884166, 0.0087459, 0.00864912, 0.00855134, 0.00845255,
  0.00835279, 0.00825204, 0.00815033, 0.00804767, 0.00794407,
  0.00783954, 0.00773409, 0.00762773, 0.00752048, 0.00741235,
  0.00730334, 0.00719348, 0.00708277, 0.00697122, 0.00685886,
  0.00674569, 0.00663172, 0.00651696, 0.00640144, 0.00628516,
  0.00616814, 0.00605039, 0.00593192, 0.00581275, 0.00569288,
  0.00557235, 0.00545115, 0.0053293, 0.00520681, 0.00508371, 0.00496,
  0.0048357, 0.00471083, 0.00458539, 0.0044594, 0.00433288,
  0.00420584, 0.00407829, 0.00395026, 0.00382175, 0.00369279,
  0.00356338, 0.00343354, 0.00330329, 0.00317264, 0.00304161,
  0.00291022, 0.00277847, 0.00264638, 0.00251398, 0.00238127,
  0.00224827, 0.002115, 0.00198148, 0.00184771, 0.00171372,
  0.00157953, 0.00144513, 0.00131057, 0.00117584, 0.00104097,
  0.000905977, 0.00077087, 0.000635668, 0.00050039, 0.00036505,
  0.000229665, 9.4252e-05, -4.11725e-05, -0.000176592, -0.000311989,
  -0.000447349, -0.000582653, -0.000717885, -0.000853029,
  -0.000988068, -0.00112298, -0.00125776, -0.00139238, -0.00152683,
  -0.0016611, -0.00179515, -0.00192898, -0.00206257, -0.00219591,
  -0.00232897, -0.00246175, -0.00259421, -0.00272636, -0.00285816,
  -0.0029896, -0.00312068, -0.00325136, -0.00338163, -0.00351148,
  -0.00364089, -0.00376985, -0.00389833, -0.00402632, -0.0041538,
  -0.00428076, -0.00440718, -0.00453304, -0.00465833, -0.00478304,
  -0.00490713, -0.00503061, -0.00515345, -0.00527563, -0.00539715,
  -0.00551798, -0.00563811, -0.00575752, -0.0058762, -0.00599413,
  -0.00611129, -0.00622767, -0.00634326, -0.00645804, -0.00657199,
  -0.00668509, -0.00679734, -0.00690872, -0.00701921, -0.00712879,
  -0.00723746, -0.0073452, -0.00745199, -0.00755782, -0.00766267,
  -0.00776653, -0.00786938, -0.00797122, -0.00807202, -0.00817177,
  -0.00827046, -0.00836808, -0.00846461, -0.00856004, -0.00865435,
  -0.00874753, -0.00883956, -0.00893045, -0.00902016, -0.00910869,
  -0.00919603, -0.00928216, -0.00936708, -0.00945076, -0.00953319,
  -0.00961438, -0.00969429, -0.00977292, -0.00985027, -0.00992631,
  -0.010001, -0.0100744, -0.0101465, -0.0102172, -0.0102866,
  -0.0103546, -0.0104212, -0.0104864, -0.0105503, -0.0106127,
  -0.0106737, -0.0107333, -0.0107914, -0.0108481, -0.0109033,
  -0.0109571, -0.0110094, -0.0110602, -0.0111096, -0.0111574,
  -0.0112037, -0.0112485, -0.0112918, -0.0113336, -0.0113738,
  -0.0114125, -0.0114496, -0.0114852, -0.0115192, -0.0115517,
  -0.0115826, -0.0116119, -0.0116396, -0.0116657, -0.0116902,
  -0.0117131, -0.0117344, -0.0117541, -0.0117722, -0.0117887,
  -0.0118035, -0.0118168, -0.0118284, -0.0118383, -0.0118466,
  -0.0118533, -0.0118583, -0.0118617, -0.0118635, -0.0118635,
  -0.011862, -0.0118588, -0.0118539, -0.0118474, -0.0118392,
  -0.0118294, -0.0118179, -0.0118047, -0.0117899, -0.0117735,
  -0.0117554, -0.0117356, -0.0117142, -0.0116911, -0.0116664,
  -0.01164, -0.0116119, -0.0115823, -0.011551, -0.011518, -0.0114834,
  -0.0114472, -0.0114093, -0.0113698, -0.0113287, -0.011286,
  -0.0112416, -0.0111957, -0.0111481, -0.0110989, -0.0110481,
  -0.0109958, -0.0109419, -0.0108863, -0.0108292, -0.0107706,
  -0.0107104, -0.0106486, -0.0105853, -0.0105204, -0.010454,
  -0.0103861, -0.0103167, -0.0102458, -0.0101733, -0.0100994,
  -0.010024, -0.00994718, -0.00986885, -0.00978908, -0.00970786,
  -0.00962522, -0.00954115, -0.00945568, -0.0093688, -0.00928054,
  -0.00919091, -0.00909991, -0.00900755, -0.00891386, -0.00881884,
  -0.00872251, -0.00862487, -0.00852594, -0.00842574, -0.00832428,
  -0.00822156, -0.00811761, -0.00801244, -0.00790606, -0.0077985,
  -0.00768975, -0.00757984, -0.00746879, -0.0073566, -0.00724329,
  -0.00712889, -0.0070134, -0.00689685, -0.00677924, -0.0066606,
  -0.00654093, -0.00642027, -0.00629863, -0.00617601, -0.00605245,
  -0.00592796, -0.00580255, -0.00567625, -0.00554907, -0.00542104,
  -0.00529216, -0.00516247, -0.00503197, -0.00490069, -0.00476865,
  -0.00463586, -0.00450235, -0.00436814, -0.00423325, -0.00409769,
  -0.00396148, -0.00382466, -0.00368723, -0.00354923, -0.00341066,
  -0.00327155, -0.00313193, -0.00299181, -0.00285122, -0.00271017,
  -0.0025687, -0.00242681, -0.00228454, -0.0021419, -0.00199892,
  -0.00185562, -0.00171202, -0.00156815, -0.00142403, -0.00127967,
  -0.00113511, -0.00099037, -0.000845466, -0.000700426, -0.000555272,
  -0.000410028, -0.000264717, -0.000119363, 2.60098e-05, 0.000171379,
  0.00031672, 0.000462009, 0.000607223, 0.000752336, 0.000897326,
  0.00104217, 0.00118684, 0.00133131, 0.00147557, 0.00161958,
  0.00176332, 0.00190677, 0.0020499, 0.00219269, 0.00233511,
  0.00247715, 0.00261877, 0.00275995, 0.00290066, 0.00304089,
  0.00318061, 0.00331979, 0.00345842, 0.00359645, 0.00373388,
  0.00387067, 0.00400681, 0.00414227, 0.00427702, 0.00441104,
  0.0045443, 0.00467679, 0.00480848, 0.00493934, 0.00506935,
  0.00519849, 0.00532673, 0.00545405, 0.00558043, 0.00570584,
  0.00583026, 0.00595367, 0.00607604, 0.00619735, 0.00631758,
  0.00643671, 0.0065547, 0.00667155, 0.00678722, 0.0069017,
  0.00701496, 0.00712698, 0.00723775, 0.00734722, 0.0074554,
  0.00756225, 0.00766775, 0.00777189, 0.00787463, 0.00797597,
  0.00807588, 0.00817434, 0.00827133, 0.00836683, 0.00846081,
  0.00855327, 0.00864418, 0.00873353, 0.00882129, 0.00890744,
  0.00899197, 0.00907485, 0.00915608, 0.00923563, 0.00931349,
  0.00938963, 0.00946404, 0.00953671, 0.00960762, 0.00967675,
  0.00974408, 0.00980961, 0.00987331, 0.00993517, 0.00999517,
  0.0100533, 0.0101096, 0.0101639, 0.0102163, 0.0102669, 0.0103154,
  0.0103621, 0.0104067, 0.0104494, 0.0104901, 0.0105289, 0.0105656,
  0.0106002, 0.0106329, 0.0106635, 0.0106921, 0.0107186, 0.010743,
  0.0107654, 0.0107857, 0.0108038, 0.0108199, 0.0108339, 0.0108458,
  0.0108555, 0.0108632, 0.0108686, 0.010872, 0.0108732, 0.0108723,
  0.0108692, 0.010864, 0.0108566, 0.0108471, 0.0108354, 0.0108215,
  0.0108055, 0.0107873, 0.0107669, 0.0107444, 0.0107197, 0.0106929,
  0.0106639, 0.0106327, 0.0105994, 0.0105639, 0.0105262, 0.0104864,
  0.0104445, 0.0104004, 0.0103542, 0.0103058, 0.0102554, 0.0102028,
  0.010148, 0.0100912, 0.0100323, 0.00997127, 0.00990818, 0.009843,
  0.00977577, 0.00970647, 0.00963514, 0.00956176, 0.00948637,
  0.00940896, 0.00932956, 0.00924817, 0.0091648, 0.00907948,
  0.00899221, 0.008903, 0.00881189, 0.00871887, 0.00862397, 0.0085272,
  0.00842858, 0.00832812, 0.00822585, 0.00812179, 0.00801594,
  0.00790833, 0.00779899, 0.00768792, 0.00757516, 0.00746072,
  0.00734462, 0.00722689, 0.00710755, 0.00698662, 0.00686413,
  0.00674009, 0.00661454, 0.0064875, 0.00635899, 0.00622904,
  0.00609768, 0.00596493, 0.00583081, 0.00569537, 0.00555862,
  0.00542059, 0.00528131, 0.00514082, 0.00499913, 0.00485629,
  0.00471232, 0.00456724, 0.00442111, 0.00427393, 0.00412576,
  0.00397661, 0.00382652, 0.00367553, 0.00352367, 0.00337097,
  0.00321747, 0.0030632, 0.0029082, 0.0027525, 0.00259613, 0.00243914,
  0.00228157, 0.00212343, 0.00196478, 0.00180566, 0.00164609,
  0.00148612, 0.00132578, 0.00116512, 0.00100417, 0.000842972,
  0.000681565, 0.000519988, 0.000358282, 0.000196486, 3.46408e-05,
  -0.000127213, -0.000289035, -0.000450783, -0.000612418,
  -0.000773896, -0.000935178, -0.00109622, -0.00125698, -0.00141742,
  -0.00157749, -0.00173716, -0.00189638, -0.0020551, -0.00221329,
  -0.0023709, -0.00252789, -0.00268422, -0.00283983, -0.0029947,
  -0.00314878, -0.00330202, -0.00345438, -0.00360581, -0.00375629,
  -0.00390575, -0.00405416, -0.00420147, -0.00434765, -0.00449264,
  -0.00463641, -0.00477891, -0.0049201, -0.00505994, -0.00519838,
  -0.00533538, -0.0054709, -0.0056049, -0.00573734, -0.00586817,
  -0.00599734, -0.00612483, -0.00625059, -0.00637458, -0.00649675,
  -0.00661707, -0.0067355, -0.00685199, -0.00696651, -0.00707902,
  -0.00718947, -0.00729784, -0.00740407, -0.00750814, -0.00761001,
  -0.00770963, -0.00780698, -0.00790201, -0.0079947, -0.008085,
  -0.00817287, -0.0082583, -0.00834123, -0.00842164, -0.0084995,
  -0.00857477, -0.00864742, -0.00871742, -0.00878474, -0.00884935,
  -0.00891122, -0.00897032, -0.00902662, -0.0090801, -0.00913073,
  -0.00917849, -0.00922333, -0.00926526, -0.00930423, -0.00934023,
  -0.00937323, -0.00940322, -0.00943017, -0.00945406, -0.00947487,
  -0.00949259, -0.0095072, -0.00951868, -0.00952702, -0.00953219,
  -0.0095342, -0.00953302, -0.00952865, -0.00952107, -0.00951027,
  -0.00949625, -0.00947899, -0.00945849, -0.00943475, -0.00940776,
  -0.00937752, -0.00934402, -0.00930726, -0.00926725, -0.00922398,
  -0.00917746, -0.00912769, -0.00907467, -0.00901841, -0.00895892,
  -0.0088962, -0.00883026, -0.00876112, -0.00868879, -0.00861328,
  -0.0085346, -0.00845277, -0.0083678, -0.00827972, -0.00818854,
  -0.00809429, -0.00799698, -0.00789665, -0.00779331, -0.00768699,
  -0.00757772, -0.00746553, -0.00735044, -0.0072325, -0.00711172,
  -0.00698816, -0.00686184, -0.0067328, -0.00660108, -0.00646672,
  -0.00632976, -0.00619024, -0.00604821, -0.00590372, -0.00575681,
  -0.00560753, -0.00545593, -0.00530207, -0.00514599, -0.00498775,
  -0.00482741, -0.00466502, -0.00450064, -0.00433434, -0.00416617,
  -0.00399621, -0.0038245, -0.00365112, -0.00347614, -0.00329963,
  -0.00312165, -0.00294228, -0.00276159, -0.00257965, -0.00239654,
  -0.00221234, -0.00202713, -0.00184098, -0.00165398, -0.00146621,
  -0.00127776, -0.0010887, -0.000899122, -0.000709118, -0.000518775,
  -0.000328182, -0.000137429, 5.33901e-05, 0.000244183, 0.000434856,
  0.000625313, 0.000815457, 0.00100519, 0.00119442, 0.00138304,
  0.00157095, 0.00175805, 0.00194425, 0.00212942, 0.00231349,
  0.00249633, 0.00267784, 0.00285792, 0.00303647, 0.00321337,
  0.00338851, 0.0035618, 0.00373311, 0.00390235, 0.00406941,
  0.00423417, 0.00439652, 0.00455636, 0.00471358, 0.00486806,
  0.00501969, 0.00516838, 0.005314, 0.00545645, 0.00559562, 0.0057314,
  0.00586368, 0.00599235, 0.00611731, 0.00623846, 0.00635567,
  0.00646886, 0.00657791, 0.00668273, 0.0067832, 0.00687924,
  0.00697074, 0.00705759, 0.00713972, 0.00721701, 0.00728938,
  0.00735674, 0.00741899, 0.00747605, 0.00752783, 0.00757425,
  0.00761522, 0.00765068, 0.00768053, 0.00770471, 0.00772315,
  0.00773578, 0.00774254, 0.00774336, 0.00773818, 0.00772695,
  0.00770963, 0.00768616, 0.00765649, 0.0076206, 0.00757845, 0.00753,
  0.00747523, 0.00741412, 0.00734665, 0.00727282, 0.00719261,
  0.00710603, 0.00701308, 0.00691378, 0.00680814, 0.00669618,
  0.00657794, 0.00645344, 0.00632275, 0.0061859, 0.00604295,
  0.00589398, 0.00573904, 0.00557824, 0.00541164, 0.00523936,
  0.00506149, 0.00487815, 0.00468948, 0.00449559, 0.00429664,
  0.00409278, 0.00388417, 0.00367099, 0.00345342, 0.00323165,
  0.0030059, 0.00277638, 0.00254333, 0.00230699, 0.00206761,
  0.00182545, 0.00158082, 0.00133399, 0.00108527, 0.000835002,
  0.000583506, 0.000331139, 7.82695e-05, -0.00017472, -0.000427432,
  -0.000679449, -0.000930341, -0.00117966, -0.00142694, -0.00167169,
  -0.00191341, -0.00215159, -0.00238569, -0.00261513, -0.00283935,
  -0.00305775, -0.0032697, -0.00347456, -0.00367168, -0.00386036,
  -0.0040399, -0.00420957, -0.00436862, -0.00451626, -0.00465169,
  -0.00477409, -0.0048826, -0.00497635, -0.00505443, -0.0051159,
  -0.00515981, -0.00518517, -0.00519096, -0.00517613, -0.00513961,
  -0.00508029, -0.00499704, -0.00488868, -0.00475401, -0.0045918,
  -0.00440078, -0.00417965, -0.00392707, -0.00364167, -0.00332204,
  -0.00296673, -0.00257427, -0.00214313, -0.00167175, -0.00115854,
  -0.000601847, 3.06016e-17}; G4double
  G4NeutronHPFastLegendre::l16[3401] = {1, 0.921574, 0.846244,
  0.773927, 0.704545, 0.638021, 0.574278, 0.513243, 0.454842,
  0.399004, 0.345658, 0.294736, 0.246169, 0.199893, 0.155842,
  0.113953, 0.0741636, 0.0364125, 0.000640403, -0.0332113, -0.0651999,
  -0.0953815, -0.123811, -0.150542, -0.175628, -0.199119, -0.221066,
  -0.24152, -0.260527, -0.278135, -0.294391, -0.30934, -0.323025,
  -0.335491, -0.346779, -0.356931, -0.365987, -0.373987, -0.380969,
  -0.386972, -0.392031, -0.396183, -0.399463, -0.401906, -0.403545,
  -0.404412, -0.404539, -0.403959, -0.4027, -0.400794, -0.398268,
  -0.39515, -0.39147, -0.387252, -0.382524, -0.37731, -0.371636,
  -0.365526, -0.359002, -0.352089, -0.344808, -0.337182, -0.32923,
  -0.320974, -0.312433, -0.303628, -0.294575, -0.285295, -0.275805,
  -0.266122, -0.256262, -0.246243, -0.236079, -0.225786, -0.215379,
  -0.204872, -0.19428, -0.183614, -0.172889, -0.162118, -0.151311,
  -0.140481, -0.12964, -0.118798, -0.107966, -0.0971544, -0.0863725,
  -0.0756301, -0.0649363, -0.0542998, -0.0437291, -0.0332323,
  -0.0228173, -0.0124914, -0.00226187, 0.00786445, 0.017881,
  0.0277815, 0.03756, 0.0472107, 0.0567283, 0.0661075, 0.0753434,
  0.0844313, 0.0933669, 0.102146, 0.110764, 0.119219, 0.127505,
  0.135621, 0.143563, 0.151327, 0.158912, 0.166316, 0.173535,
  0.180567, 0.187411, 0.194066, 0.200529, 0.206799, 0.212875,
  0.218756, 0.224441, 0.229929, 0.23522, 0.240313, 0.245208, 0.249905,
  0.254404, 0.258704, 0.262806, 0.266711, 0.270418, 0.273928,
  0.277243, 0.280362, 0.283286, 0.286017, 0.288556, 0.290903,
  0.293061, 0.295029, 0.296811, 0.298406, 0.299817, 0.301045,
  0.302093, 0.302961, 0.303652, 0.304167, 0.304509, 0.304679,
  0.304679, 0.304513, 0.304181, 0.303686, 0.303031, 0.302217,
  0.301248, 0.300124, 0.298849, 0.297426, 0.295856, 0.294143,
  0.292288, 0.290294, 0.288165, 0.285902, 0.283508, 0.280986,
  0.278339, 0.275569, 0.272678, 0.269671, 0.266548, 0.263314,
  0.259971, 0.256522, 0.252968, 0.249314, 0.245562, 0.241715,
  0.237775, 0.233745, 0.229628, 0.225427, 0.221145, 0.216784,
  0.212346, 0.207836, 0.203255, 0.198606, 0.193893, 0.189116,
  0.184281, 0.179388, 0.17444, 0.169441, 0.164393, 0.159298, 0.15416,
  0.14898, 0.143761, 0.138506, 0.133218, 0.127898, 0.122549, 0.117174,
  0.111775, 0.106355, 0.100916, 0.0954596, 0.089989, 0.0845063,
  0.0790138, 0.0735138, 0.0680084, 0.0624999, 0.0569904, 0.0514821,
  0.0459772, 0.0404776, 0.0349855, 0.0295029, 0.0240318, 0.0185742,
  0.013132, 0.00770721, 0.00230163, -0.00308286, -0.00844443,
  -0.0137813, -0.0190916, -0.0243738, -0.029626, -0.0348466,
  -0.040034, -0.0451865, -0.0503026, -0.0553807, -0.0604193,
  -0.0654169, -0.0703721, -0.0752834, -0.0801495, -0.0849689,
  -0.0897403, -0.0944626, -0.0991343, -0.103754, -0.108321, -0.112834,
  -0.117292, -0.121693, -0.126037, -0.130322, -0.134548, -0.138713,
  -0.142816, -0.146858, -0.150836, -0.154749, -0.158598, -0.162381,
  -0.166098, -0.169747, -0.173328, -0.17684, -0.180283, -0.183656,
  -0.186958, -0.190189, -0.193348, -0.196434, -0.199449, -0.202389,
  -0.205256, -0.208049, -0.210768, -0.213412, -0.21598, -0.218473,
  -0.220891, -0.223232, -0.225497, -0.227686, -0.229798, -0.231833,
  -0.233791, -0.235673, -0.237477, -0.239204, -0.240854, -0.242427,
  -0.243922, -0.245341, -0.246682, -0.247947, -0.249134, -0.250245,
  -0.251279, -0.252236, -0.253118, -0.253923, -0.254652, -0.255306,
  -0.255884, -0.256387, -0.256815, -0.257169, -0.257449, -0.257654,
  -0.257787, -0.257846, -0.257833, -0.257747, -0.25759, -0.257361,
  -0.257062, -0.256692, -0.256252, -0.255743, -0.255165, -0.254518,
  -0.253804, -0.253023, -0.252175, -0.251261, -0.250281, -0.249237,
  -0.248129, -0.246957, -0.245722, -0.244425, -0.243066, -0.241647,
  -0.240167, -0.238628, -0.23703, -0.235374, -0.233661, -0.231892,
  -0.230066, -0.228186, -0.226251, -0.224263, -0.222222, -0.220129,
  -0.217985, -0.215791, -0.213547, -0.211255, -0.208915, -0.206528,
  -0.204094, -0.201615, -0.199092, -0.196525, -0.193916, -0.191264,
  -0.188571, -0.185838, -0.183066, -0.180255, -0.177406, -0.174521,
  -0.1716, -0.168644, -0.165654, -0.162631, -0.159575, -0.156488,
  -0.153371, -0.150223, -0.147047, -0.143844, -0.140613, -0.137356,
  -0.134074, -0.130767, -0.127438, -0.124085, -0.120711, -0.117317,
  -0.113902, -0.110469, -0.107017, -0.103548, -0.100063, -0.0965624,
  -0.0930472, -0.0895184, -0.0859767, -0.0824231, -0.0788583,
  -0.0752833, -0.071699, -0.0681061, -0.0645055, -0.0608981,
  -0.0572848, -0.0536662, -0.0500434, -0.0464171, -0.0427881,
  -0.0391572, -0.0355254, -0.0318933, -0.0282618, -0.0246317,
  -0.0210038, -0.0173788, -0.0137576, -0.010141, -0.00652961,
  -0.00292432, 0.000674135, 0.00426501, 0.00784755, 0.011421,
  0.0149847, 0.0185378, 0.0220797, 0.0256096, 0.0291268, 0.0326307,
  0.0361204, 0.0395954, 0.043055, 0.0464985, 0.0499252, 0.0533345,
  0.0567256, 0.0600981, 0.0634512, 0.0667843, 0.0700969, 0.0733882,
  0.0766577, 0.0799048, 0.0831288, 0.0863294, 0.0895057, 0.0926574,
  0.0957838, 0.0988843, 0.101959, 0.105006, 0.108026, 0.111018,
  0.113982, 0.116916, 0.119822, 0.122697, 0.125542, 0.128357, 0.13114,
  0.133891, 0.13661, 0.139297, 0.141951, 0.144571, 0.147157, 0.14971,
  0.152228, 0.154711, 0.157158, 0.15957, 0.161946, 0.164286, 0.166588,
  0.168854, 0.171083, 0.173274, 0.175427, 0.177542, 0.179619,
  0.181657, 0.183655, 0.185615, 0.187535, 0.189416, 0.191256,
  0.193056, 0.194816, 0.196536, 0.198215, 0.199853, 0.201449,
  0.203005, 0.204519, 0.205991, 0.207422, 0.208811, 0.210158,
  0.211464, 0.212726, 0.213947, 0.215126, 0.216261, 0.217355,
  0.218406, 0.219414, 0.22038, 0.221303, 0.222183, 0.22302, 0.223815,
  0.224567, 0.225276, 0.225943, 0.226567, 0.227148, 0.227686,
  0.228182, 0.228635, 0.229045, 0.229413, 0.229739, 0.230022,
  0.230263, 0.230462, 0.230619, 0.230734, 0.230807, 0.230838,
  0.230828, 0.230776, 0.230683, 0.230549, 0.230373, 0.230157, 0.2299,
  0.229602, 0.229264, 0.228886, 0.228468, 0.22801, 0.227512, 0.226975,
  0.226399, 0.225783, 0.225129, 0.224437, 0.223706, 0.222937,
  0.222131, 0.221287, 0.220405, 0.219487, 0.218531, 0.217539,
  0.216511, 0.215448, 0.214348, 0.213213, 0.212043, 0.210838,
  0.209599, 0.208326, 0.207019, 0.205678, 0.204304, 0.202898,
  0.201458, 0.199987, 0.198484, 0.196949, 0.195383, 0.193786,
  0.192159, 0.190502, 0.188815, 0.187098, 0.185353, 0.183579,
  0.181776, 0.179946, 0.178088, 0.176204, 0.174292, 0.172354, 0.17039,
  0.168401, 0.166386, 0.164347, 0.162283, 0.160195, 0.158084, 0.15595,
  0.153792, 0.151613, 0.149412, 0.147189, 0.144945, 0.14268, 0.140395,
  0.13809, 0.135766, 0.133423, 0.131062, 0.128682, 0.126284, 0.12387,
  0.121438, 0.11899, 0.116527, 0.114047, 0.111553, 0.109044, 0.10652,
  0.103983, 0.101433, 0.0988694, 0.0962935, 0.0937057, 0.0911062,
  0.0884956, 0.0858742, 0.0832426, 0.0806011, 0.0779502, 0.0752904,
  0.072622, 0.0699456, 0.0672615, 0.0645702, 0.0618721, 0.0591676,
  0.0564572, 0.0537414, 0.0510205, 0.048295, 0.0455654, 0.042832,
  0.0400952, 0.0373556, 0.0346135, 0.0318694, 0.0291237, 0.0263767,
  0.0236291, 0.020881, 0.0181331, 0.0153856, 0.0126391, 0.00989385,
  0.00715037, 0.00440904, 0.00167027, -0.00106553, -0.00379796,
  -0.00652661, -0.00925108, -0.011971, -0.0146859, -0.0173954,
  -0.0200992, -0.0227968, -0.0254879, -0.028172, -0.0308488,
  -0.0335179, -0.0361789, -0.0388315, -0.0414752, -0.0441097,
  -0.0467347, -0.0493497, -0.0519544, -0.0545484, -0.0571314,
  -0.059703, -0.0622629, -0.0648107, -0.067346, -0.0698686,
  -0.0723781, -0.0748741, -0.0773563, -0.0798244, -0.0822781,
  -0.0847169, -0.0871407, -0.089549, -0.0919416, -0.0943182,
  -0.0966784, -0.0990219, -0.101348, -0.103658, -0.105949, -0.108223,
  -0.110479, -0.112716, -0.114935, -0.117135, -0.119315, -0.121476,
  -0.123617, -0.125738, -0.127838, -0.129918, -0.131977, -0.134015,
  -0.136032, -0.138027, -0.140001, -0.141952, -0.143881, -0.145788,
  -0.147671, -0.149532, -0.15137, -0.153184, -0.154975, -0.156742,
  -0.158485, -0.160204, -0.161898, -0.163568, -0.165213, -0.166834,
  -0.168429, -0.169998, -0.171543, -0.173062, -0.174555, -0.176022,
  -0.177463, -0.178878, -0.180266, -0.181628, -0.182964, -0.184272,
  -0.185554, -0.186809, -0.188036, -0.189237, -0.19041, -0.191555,
  -0.192673, -0.193763, -0.194826, -0.19586, -0.196867, -0.197846,
  -0.198796, -0.199719, -0.200613, -0.201479, -0.202316, -0.203125,
  -0.203905, -0.204657, -0.20538, -0.206075, -0.206741, -0.207378,
  -0.207987, -0.208566, -0.209117, -0.209639, -0.210133, -0.210597,
  -0.211032, -0.211439, -0.211817, -0.212166, -0.212486, -0.212777,
  -0.213039, -0.213273, -0.213478, -0.213654, -0.213801, -0.21392,
  -0.214009, -0.214071, -0.214103, -0.214108, -0.214083, -0.21403,
  -0.213949, -0.21384, -0.213702, -0.213536, -0.213342, -0.21312,
  -0.21287, -0.212592, -0.212286, -0.211953, -0.211592, -0.211204,
  -0.210788, -0.210345, -0.209874, -0.209377, -0.208852, -0.208301,
  -0.207723, -0.207118, -0.206487, -0.205829, -0.205145, -0.204435,
  -0.203699, -0.202938, -0.20215, -0.201337, -0.200499, -0.199635,
  -0.198746, -0.197832, -0.196894, -0.195931, -0.194943, -0.193931,
  -0.192895, -0.191835, -0.190752, -0.189644, -0.188514, -0.18736,
  -0.186183, -0.184983, -0.18376, -0.182515, -0.181248, -0.179958,
  -0.178647, -0.177314, -0.17596, -0.174584, -0.173187, -0.17177,
  -0.170331, -0.168873, -0.167394, -0.165895, -0.164376, -0.162838,
  -0.16128, -0.159704, -0.158108, -0.156494, -0.154861, -0.15321,
  -0.151542, -0.149855, -0.148151, -0.14643, -0.144692, -0.142937,
  -0.141165, -0.139378, -0.137574, -0.135754, -0.133919, -0.132069,
  -0.130204, -0.128324, -0.126429, -0.12452, -0.122598, -0.120661,
  -0.118711, -0.116748, -0.114771, -0.112783, -0.110781, -0.108768,
  -0.106742, -0.104705, -0.102657, -0.100597, -0.098527, -0.096446,
  -0.0943548, -0.0922535, -0.0901425, -0.088022, -0.0858923,
  -0.0837536, -0.0816063, -0.0794506, -0.0772867, -0.075115,
  -0.0729358, -0.0707492, -0.0685556, -0.0663552, -0.0641484,
  -0.0619354, -0.0597164, -0.0574918, -0.0552618, -0.0530267,
  -0.0507868, -0.0485424, -0.0462937, -0.044041, -0.0417845,
  -0.0395247, -0.0372616, -0.0349957, -0.0327271, -0.0304562,
  -0.0281833, -0.0259085, -0.0236322, -0.0213547, -0.0190761,
  -0.0167969, -0.0145173, -0.0122374, -0.00995772, -0.00767839,
  -0.0053997, -0.00312193, -0.000845346, 0.00142979, 0.0037032,
  0.00597463, 0.00824381, 0.0105105, 0.0127744, 0.0150352, 0.0172927,
  0.0195467, 0.0217969, 0.0240429, 0.0262847, 0.0285218, 0.0307541,
  0.0329812, 0.035203, 0.0374192, 0.0396295, 0.0418337, 0.0440316,
  0.0462228, 0.0484071, 0.0505844, 0.0527543, 0.0549166, 0.0570711,
  0.0592174, 0.0613555, 0.063485, 0.0656058, 0.0677175, 0.0698199,
  0.0719129, 0.0739961, 0.0760694, 0.0781326, 0.0801853, 0.0822274,
  0.0842587, 0.0862789, 0.0882878, 0.0902852, 0.0922709, 0.0942447,
  0.0962063, 0.0981556, 0.100092, 0.102016, 0.103927, 0.105825,
  0.10771, 0.10958, 0.111438, 0.113281, 0.11511, 0.116924, 0.118724,
  0.12051, 0.12228, 0.124036, 0.125776, 0.1275, 0.129209, 0.130902,
  0.13258, 0.134241, 0.135885, 0.137514, 0.139125, 0.14072, 0.142298,
  0.143859, 0.145402, 0.146928, 0.148436, 0.149927, 0.1514, 0.152854,
  0.154291, 0.155709, 0.157109, 0.15849, 0.159852, 0.161196, 0.16252,
  0.163826, 0.165112, 0.166379, 0.167626, 0.168854, 0.170062, 0.17125,
  0.172419, 0.173567, 0.174695, 0.175803, 0.17689, 0.177958, 0.179004,
  0.18003, 0.181035, 0.182019, 0.182983, 0.183925, 0.184847, 0.185747,
  0.186626, 0.187484, 0.18832, 0.189135, 0.189929, 0.1907, 0.191451,
  0.192179, 0.192886, 0.193571, 0.194234, 0.194875, 0.195495,
  0.196092, 0.196667, 0.19722, 0.197752, 0.198261, 0.198747, 0.199212,
  0.199654, 0.200074, 0.200472, 0.200847, 0.201201, 0.201531, 0.20184,
  0.202126, 0.20239, 0.202631, 0.20285, 0.203047, 0.203221, 0.203373,
  0.203503, 0.20361, 0.203695, 0.203757, 0.203797, 0.203815, 0.203811,
  0.203784, 0.203735, 0.203664, 0.203571, 0.203456, 0.203318,
  0.203159, 0.202977, 0.202774, 0.202548, 0.202301, 0.202032,
  0.201741, 0.201428, 0.201094, 0.200738, 0.20036, 0.199961, 0.19954,
  0.199098, 0.198635, 0.198151, 0.197645, 0.197118, 0.19657, 0.196002,
  0.195412, 0.194802, 0.194171, 0.193519, 0.192847, 0.192155,
  0.191442, 0.190709, 0.189956, 0.189182, 0.188389, 0.187576,
  0.186743, 0.185891, 0.185019, 0.184128, 0.183217, 0.182288,
  0.181339, 0.180371, 0.179385, 0.17838, 0.177356, 0.176314, 0.175253,
  0.174174, 0.173078, 0.171963, 0.17083, 0.16968, 0.168512, 0.167327,
  0.166125, 0.164906, 0.163669, 0.162416, 0.161146, 0.15986, 0.158557,
  0.157239, 0.155904, 0.154553, 0.153186, 0.151804, 0.150406,
  0.148993, 0.147565, 0.146122, 0.144665, 0.143192, 0.141705,
  0.140204, 0.138689, 0.13716, 0.135617, 0.13406, 0.13249, 0.130907,
  0.129311, 0.127701, 0.12608, 0.124445, 0.122798, 0.121139, 0.119468,
  0.117785, 0.116091, 0.114385, 0.112668, 0.11094, 0.1092, 0.107451,
  0.10569, 0.10392, 0.102139, 0.100348, 0.0985481, 0.0967381,
  0.0949189, 0.0930905, 0.0912531, 0.089407, 0.0875523, 0.0856893,
  0.0838181, 0.081939, 0.0800521, 0.0781576, 0.0762558, 0.0743468,
  0.0724309, 0.0705082, 0.0685789, 0.0666434, 0.0647016, 0.062754,
  0.0608006, 0.0588416, 0.0568774, 0.054908, 0.0529337, 0.0509547,
  0.0489712, 0.0469835, 0.0449916, 0.0429958, 0.0409964, 0.0389935,
  0.0369874, 0.0349782, 0.0329661, 0.0309515, 0.0289343, 0.026915,
  0.0248937, 0.0228705, 0.0208458, 0.0188196, 0.0167923, 0.014764,
  0.0127349, 0.0107053, 0.00867528, 0.00664513, 0.00461505,
  0.00258522, 0.000555861, -0.00147282, -0.00350063, -0.00552735,
  -0.00755278, -0.00957672, -0.011599, -0.0136193, -0.0156375,
  -0.0176535, -0.0196669, -0.0216776, -0.0236854, -0.0256901,
  -0.0276915, -0.0296893, -0.0316835, -0.0336737, -0.0356599,
  -0.0376417, -0.039619, -0.0415917, -0.0435594, -0.045522,
  -0.0474794, -0.0494313, -0.0513775, -0.0533178, -0.0552521,
  -0.0571802, -0.0591018, -0.0610168, -0.062925, -0.0648262,
  -0.0667203, -0.0686069, -0.070486, -0.0723574, -0.0742209,
  -0.0760762, -0.0779233, -0.0797619, -0.0815919, -0.0834131,
  -0.0852253, -0.0870283, -0.088822, -0.0906061, -0.0923806,
  -0.0941452, -0.0958998, -0.0976442, -0.0993783, -0.101102,
  -0.102815, -0.104517, -0.106208, -0.107887, -0.109556, -0.111213,
  -0.112858, -0.114491, -0.116113, -0.117722, -0.119319, -0.120904,
  -0.122476, -0.124035, -0.125582, -0.127115, -0.128635, -0.130142,
  -0.131636, -0.133116, -0.134582, -0.136035, -0.137473, -0.138897,
  -0.140307, -0.141703, -0.143084, -0.14445, -0.145802, -0.147138,
  -0.14846, -0.149767, -0.151058, -0.152334, -0.153594, -0.154839,
  -0.156068, -0.157281, -0.158478, -0.15966, -0.160824, -0.161973,
  -0.163105, -0.164221, -0.165321, -0.166403, -0.167469, -0.168518,
  -0.16955, -0.170565, -0.171562, -0.172543, -0.173506, -0.174452,
  -0.17538, -0.17629, -0.177183, -0.178059, -0.178916, -0.179756,
  -0.180577, -0.181381, -0.182166, -0.182933, -0.183682, -0.184413,
  -0.185126, -0.18582, -0.186495, -0.187152, -0.18779, -0.18841,
  -0.189011, -0.189593, -0.190157, -0.190702, -0.191227, -0.191734,
  -0.192222, -0.192691, -0.193141, -0.193572, -0.193983, -0.194376,
  -0.194749, -0.195104, -0.195439, -0.195754, -0.196051, -0.196328,
  -0.196586, -0.196825, -0.197044, -0.197244, -0.197425, -0.197586,
  -0.197728, -0.197851, -0.197954, -0.198038, -0.198102, -0.198147,
  -0.198173, -0.198179, -0.198166, -0.198134, -0.198082, -0.198011,
  -0.197921, -0.197812, -0.197683, -0.197535, -0.197368, -0.197181,
  -0.196976, -0.196751, -0.196507, -0.196244, -0.195962, -0.195662,
  -0.195342, -0.195003, -0.194645, -0.194269, -0.193873, -0.193459,
  -0.193027, -0.192575, -0.192105, -0.191617, -0.19111, -0.190584,
  -0.19004, -0.189478, -0.188898, -0.188299, -0.187682, -0.187047,
  -0.186394, -0.185724, -0.185035, -0.184329, -0.183605, -0.182863,
  -0.182104, -0.181327, -0.180533, -0.179722, -0.178893, -0.178047,
  -0.177184, -0.176305, -0.175408, -0.174495, -0.173565, -0.172618,
  -0.171655, -0.170675, -0.16968, -0.168668, -0.16764, -0.166595,
  -0.165536, -0.16446, -0.163369, -0.162262, -0.161139, -0.160002,
  -0.158849, -0.157681, -0.156498, -0.155301, -0.154088, -0.152861,
  -0.151619, -0.150364, -0.149093, -0.147809, -0.146511, -0.145199,
  -0.143873, -0.142533, -0.14118, -0.139814, -0.138435, -0.137042,
  -0.135637, -0.134219, -0.132788, -0.131344, -0.129889, -0.128421,
  -0.126941, -0.125449, -0.123945, -0.122429, -0.120903, -0.119364,
  -0.117815, -0.116255, -0.114683, -0.113101, -0.111508, -0.109905,
  -0.108292, -0.106669, -0.105035, -0.103392, -0.101739, -0.100077,
  -0.0984049, -0.0967241, -0.0950343, -0.0933356, -0.0916283,
  -0.0899124, -0.0881883, -0.0864559, -0.0847156, -0.0829674,
  -0.0812115, -0.0794481, -0.0776774, -0.0758995, -0.0741147,
  -0.072323, -0.0705247, -0.0687199, -0.0669087, -0.0650915,
  -0.0632683, -0.0614393, -0.0596047, -0.0577646, -0.0559193,
  -0.054069, -0.0522137, -0.0503537, -0.0484891, -0.0466202,
  -0.044747, -0.0428699, -0.0409889, -0.0391042, -0.037216,
  -0.0353246, -0.03343, -0.0315325, -0.0296322, -0.0277294,
  -0.0258241, -0.0239166, -0.0220071, -0.0200957, -0.0181826,
  -0.016268, -0.0143521, -0.0124351, -0.0105171, -0.00859835,
  -0.00667899, -0.00475922, -0.00283922, -0.00091916, 0.00100077,
  0.00292038, 0.0048395, 0.00675796, 0.00867555, 0.0105921, 0.0125075,
  0.0144214, 0.0163338, 0.0182444, 0.0201531, 0.0220597, 0.023964,
  0.0258658, 0.027765, 0.0296613, 0.0315547, 0.0334448, 0.0353316,
  0.0372149, 0.0390944, 0.0409701, 0.0428417, 0.044709, 0.046572,
  0.0484303, 0.0502839, 0.0521325, 0.0539761, 0.0558143, 0.0576471,
  0.0594743, 0.0612957, 0.0631111, 0.0649204, 0.0667233, 0.0685198,
  0.0703097, 0.0720928, 0.0738688, 0.0756378, 0.0773994, 0.0791536,
  0.0809001, 0.0826389, 0.0843697, 0.0860924, 0.0878068, 0.0895127,
  0.0912101, 0.0928987, 0.0945784, 0.096249, 0.0979104, 0.0995625,
  0.101205, 0.102838, 0.104461, 0.106074, 0.107677, 0.109269,
  0.110851, 0.112423, 0.113984, 0.115534, 0.117073, 0.118601,
  0.120117, 0.121622, 0.123116, 0.124597, 0.126067, 0.127525,
  0.128971, 0.130405, 0.131826, 0.133234, 0.13463, 0.136014, 0.137384,
  0.138741, 0.140085, 0.141416, 0.142733, 0.144037, 0.145327,
  0.146604, 0.147866, 0.149115, 0.150349, 0.15157, 0.152775, 0.153967,
  0.155144, 0.156306, 0.157453, 0.158585, 0.159703, 0.160805,
  0.161892, 0.162964, 0.164021, 0.165061, 0.166087, 0.167096, 0.16809,
  0.169068, 0.17003, 0.170976, 0.171906, 0.17282, 0.173717, 0.174598,
  0.175462, 0.17631, 0.177141, 0.177956, 0.178753, 0.179534, 0.180298,
  0.181045, 0.181775, 0.182488, 0.183183, 0.183861, 0.184522,
  0.185166, 0.185792, 0.1864, 0.186991, 0.187565, 0.188121, 0.188659,
  0.189179, 0.189681, 0.190166, 0.190632, 0.191081, 0.191512,
  0.191924, 0.192319, 0.192695, 0.193054, 0.193394, 0.193716,
  0.194019, 0.194305, 0.194572, 0.194821, 0.195051, 0.195263,
  0.195457, 0.195633, 0.195789, 0.195928, 0.196048, 0.19615, 0.196233,
  0.196297, 0.196344, 0.196371, 0.196381, 0.196371, 0.196344,
  0.196297, 0.196233, 0.19615, 0.196048, 0.195928, 0.195789, 0.195633,
  0.195457, 0.195263, 0.195051, 0.194821, 0.194572, 0.194305,
  0.194019, 0.193716, 0.193394, 0.193054, 0.192695, 0.192319,
  0.191924, 0.191512, 0.191081, 0.190632, 0.190166, 0.189681,
  0.189179, 0.188659, 0.188121, 0.187565, 0.186991, 0.1864, 0.185792,
  0.185166, 0.184522, 0.183861, 0.183183, 0.182488, 0.181775,
  0.181045, 0.180298, 0.179534, 0.178753, 0.177956, 0.177141, 0.17631,
  0.175462, 0.174598, 0.173717, 0.17282, 0.171906, 0.170976, 0.17003,
  0.169068, 0.16809, 0.167096, 0.166087, 0.165061, 0.164021, 0.162964,
  0.161892, 0.160805, 0.159703, 0.158585, 0.157453, 0.156306,
  0.155144, 0.153967, 0.152775, 0.15157, 0.150349, 0.149115, 0.147866,
  0.146604, 0.145327, 0.144037, 0.142733, 0.141416, 0.140085,
  0.138741, 0.137384, 0.136014, 0.13463, 0.133234, 0.131826, 0.130405,
  0.128971, 0.127525, 0.126067, 0.124597, 0.123116, 0.121622,
  0.120117, 0.118601, 0.117073, 0.115534, 0.113984, 0.112423,
  0.110851, 0.109269, 0.107677, 0.106074, 0.104461, 0.102838,
  0.101205, 0.0995625, 0.0979104, 0.096249, 0.0945784, 0.0928987,
  0.0912101, 0.0895127, 0.0878068, 0.0860924, 0.0843697, 0.0826389,
  0.0809001, 0.0791536, 0.0773994, 0.0756378, 0.0738688, 0.0720928,
  0.0703097, 0.0685198, 0.0667233, 0.0649204, 0.0631111, 0.0612957,
  0.0594743, 0.0576471, 0.0558143, 0.0539761, 0.0521325, 0.0502839,
  0.0484303, 0.046572, 0.044709, 0.0428417, 0.0409701, 0.0390944,
  0.0372149, 0.0353316, 0.0334448, 0.0315547, 0.0296613, 0.027765,
  0.0258658, 0.023964, 0.0220597, 0.0201531, 0.0182444, 0.0163338,
  0.0144214, 0.0125075, 0.0105921, 0.00867555, 0.00675796, 0.0048395,
  0.00292038, 0.00100077, -0.00091916, -0.00283922, -0.00475922,
  -0.00667899, -0.00859835, -0.0105171, -0.0124351, -0.0143521,
  -0.016268, -0.0181826, -0.0200957, -0.0220071, -0.0239166,
  -0.0258241, -0.0277294, -0.0296322, -0.0315325, -0.03343,
  -0.0353246, -0.037216, -0.0391042, -0.0409889, -0.0428699,
  -0.044747, -0.0466202, -0.0484891, -0.0503537, -0.0522137,
  -0.054069, -0.0559193, -0.0577646, -0.0596047, -0.0614393,
  -0.0632683, -0.0650915, -0.0669087, -0.0687199, -0.0705247,
  -0.072323, -0.0741147, -0.0758995, -0.0776774, -0.0794481,
  -0.0812115, -0.0829674, -0.0847156, -0.0864559, -0.0881883,
  -0.0899124, -0.0916283, -0.0933356, -0.0950343, -0.0967241,
  -0.0984049, -0.100077, -0.101739, -0.103392, -0.105035, -0.106669,
  -0.108292, -0.109905, -0.111508, -0.113101, -0.114683, -0.116255,
  -0.117815, -0.119364, -0.120903, -0.122429, -0.123945, -0.125449,
  -0.126941, -0.128421, -0.129889, -0.131344, -0.132788, -0.134219,
  -0.135637, -0.137042, -0.138435, -0.139814, -0.14118, -0.142533,
  -0.143873, -0.145199, -0.146511, -0.147809, -0.149093, -0.150364,
  -0.151619, -0.152861, -0.154088, -0.155301, -0.156498, -0.157681,
  -0.158849, -0.160002, -0.161139, -0.162262, -0.163369, -0.16446,
  -0.165536, -0.166595, -0.16764, -0.168668, -0.16968, -0.170675,
  -0.171655, -0.172618, -0.173565, -0.174495, -0.175408, -0.176305,
  -0.177184, -0.178047, -0.178893, -0.179722, -0.180533, -0.181327,
  -0.182104, -0.182863, -0.183605, -0.184329, -0.185035, -0.185724,
  -0.186394, -0.187047, -0.187682, -0.188299, -0.188898, -0.189478,
  -0.19004, -0.190584, -0.19111, -0.191617, -0.192105, -0.192575,
  -0.193027, -0.193459, -0.193873, -0.194269, -0.194645, -0.195003,
  -0.195342, -0.195662, -0.195962, -0.196244, -0.196507, -0.196751,
  -0.196976, -0.197181, -0.197368, -0.197535, -0.197683, -0.197812,
  -0.197921, -0.198011, -0.198082, -0.198134, -0.198166, -0.198179,
  -0.198173, -0.198147, -0.198102, -0.198038, -0.197954, -0.197851,
  -0.197728, -0.197586, -0.197425, -0.197244, -0.197044, -0.196825,
  -0.196586, -0.196328, -0.196051, -0.195754, -0.195439, -0.195104,
  -0.194749, -0.194376, -0.193983, -0.193572, -0.193141, -0.192691,
  -0.192222, -0.191734, -0.191227, -0.190702, -0.190157, -0.189593,
  -0.189011, -0.18841, -0.18779, -0.187152, -0.186495, -0.18582,
  -0.185126, -0.184413, -0.183682, -0.182933, -0.182166, -0.181381,
  -0.180577, -0.179756, -0.178916, -0.178059, -0.177183, -0.17629,
  -0.17538, -0.174452, -0.173506, -0.172543, -0.171562, -0.170565,
  -0.16955, -0.168518, -0.167469, -0.166403, -0.165321, -0.164221,
  -0.163105, -0.161973, -0.160824, -0.15966, -0.158478, -0.157281,
  -0.156068, -0.154839, -0.153594, -0.152334, -0.151058, -0.149767,
  -0.14846, -0.147138, -0.145802, -0.14445, -0.143084, -0.141703,
  -0.140307, -0.138897, -0.137473, -0.136035, -0.134582, -0.133116,
  -0.131636, -0.130142, -0.128635, -0.127115, -0.125582, -0.124035,
  -0.122476, -0.120904, -0.119319, -0.117722, -0.116113, -0.114491,
  -0.112858, -0.111213, -0.109556, -0.107887, -0.106208, -0.104517,
  -0.102815, -0.101102, -0.0993783, -0.0976442, -0.0958998,
  -0.0941452, -0.0923806, -0.0906061, -0.088822, -0.0870283,
  -0.0852253, -0.0834131, -0.0815919, -0.0797619, -0.0779233,
  -0.0760762, -0.0742209, -0.0723574, -0.070486, -0.0686069,
  -0.0667203, -0.0648262, -0.062925, -0.0610168, -0.0591018,
  -0.0571802, -0.0552521, -0.0533178, -0.0513775, -0.0494313,
  -0.0474794, -0.045522, -0.0435594, -0.0415917, -0.039619,
  -0.0376417, -0.0356599, -0.0336737, -0.0316835, -0.0296893,
  -0.0276915, -0.0256901, -0.0236854, -0.0216776, -0.0196669,
  -0.0176535, -0.0156375, -0.0136193, -0.011599, -0.00957672,
  -0.00755278, -0.00552735, -0.00350063, -0.00147282, 0.000555861,
  0.00258522, 0.00461505, 0.00664513, 0.00867528, 0.0107053,
  0.0127349, 0.014764, 0.0167923, 0.0188196, 0.0208458, 0.0228705,
  0.0248937, 0.026915, 0.0289343, 0.0309515, 0.0329661, 0.0349782,
  0.0369874, 0.0389935, 0.0409964, 0.0429958, 0.0449916, 0.0469835,
  0.0489712, 0.0509547, 0.0529337, 0.054908, 0.0568774, 0.0588416,
  0.0608006, 0.062754, 0.0647016, 0.0666434, 0.0685789, 0.0705082,
  0.0724309, 0.0743468, 0.0762558, 0.0781576, 0.0800521, 0.081939,
  0.0838181, 0.0856893, 0.0875523, 0.089407, 0.0912531, 0.0930905,
  0.0949189, 0.0967381, 0.0985481, 0.100348, 0.102139, 0.10392,
  0.10569, 0.107451, 0.1092, 0.11094, 0.112668, 0.114385, 0.116091,
  0.117785, 0.119468, 0.121139, 0.122798, 0.124445, 0.12608, 0.127701,
  0.129311, 0.130907, 0.13249, 0.13406, 0.135617, 0.13716, 0.138689,
  0.140204, 0.141705, 0.143192, 0.144665, 0.146122, 0.147565,
  0.148993, 0.150406, 0.151804, 0.153186, 0.154553, 0.155904,
  0.157239, 0.158557, 0.15986, 0.161146, 0.162416, 0.163669, 0.164906,
  0.166125, 0.167327, 0.168512, 0.16968, 0.17083, 0.171963, 0.173078,
  0.174174, 0.175253, 0.176314, 0.177356, 0.17838, 0.179385, 0.180371,
  0.181339, 0.182288, 0.183217, 0.184128, 0.185019, 0.185891,
  0.186743, 0.187576, 0.188389, 0.189182, 0.189956, 0.190709,
  0.191442, 0.192155, 0.192847, 0.193519, 0.194171, 0.194802,
  0.195412, 0.196002, 0.19657, 0.197118, 0.197645, 0.198151, 0.198635,
  0.199098, 0.19954, 0.199961, 0.20036, 0.200738, 0.201094, 0.201428,
  0.201741, 0.202032, 0.202301, 0.202548, 0.202774, 0.202977,
  0.203159, 0.203318, 0.203456, 0.203571, 0.203664, 0.203735,
  0.203784, 0.203811, 0.203815, 0.203797, 0.203757, 0.203695, 0.20361,
  0.203503, 0.203373, 0.203221, 0.203047, 0.20285, 0.202631, 0.20239,
  0.202126, 0.20184, 0.201531, 0.201201, 0.200847, 0.200472, 0.200074,
  0.199654, 0.199212, 0.198747, 0.198261, 0.197752, 0.19722, 0.196667,
  0.196092, 0.195495, 0.194875, 0.194234, 0.193571, 0.192886,
  0.192179, 0.191451, 0.1907, 0.189929, 0.189135, 0.18832, 0.187484,
  0.186626, 0.185747, 0.184847, 0.183925, 0.182983, 0.182019,
  0.181035, 0.18003, 0.179004, 0.177958, 0.17689, 0.175803, 0.174695,
  0.173567, 0.172419, 0.17125, 0.170062, 0.168854, 0.167626, 0.166379,
  0.165112, 0.163826, 0.16252, 0.161196, 0.159852, 0.15849, 0.157109,
  0.155709, 0.154291, 0.152854, 0.1514, 0.149927, 0.148436, 0.146928,
  0.145402, 0.143859, 0.142298, 0.14072, 0.139125, 0.137514, 0.135885,
  0.134241, 0.13258, 0.130902, 0.129209, 0.1275, 0.125776, 0.124036,
  0.12228, 0.12051, 0.118724, 0.116924, 0.11511, 0.113281, 0.111438,
  0.10958, 0.10771, 0.105825, 0.103927, 0.102016, 0.100092, 0.0981556,
  0.0962063, 0.0942447, 0.0922709, 0.0902852, 0.0882878, 0.0862789,
  0.0842587, 0.0822274, 0.0801853, 0.0781326, 0.0760694, 0.0739961,
  0.0719129, 0.0698199, 0.0677175, 0.0656058, 0.063485, 0.0613555,
  0.0592174, 0.0570711, 0.0549166, 0.0527543, 0.0505844, 0.0484071,
  0.0462228, 0.0440316, 0.0418337, 0.0396295, 0.0374192, 0.035203,
  0.0329812, 0.0307541, 0.0285218, 0.0262847, 0.0240429, 0.0217969,
  0.0195467, 0.0172927, 0.0150352, 0.0127744, 0.0105105, 0.00824381,
  0.00597463, 0.0037032, 0.00142979, -0.000845346, -0.00312193,
  -0.0053997, -0.00767839, -0.00995772, -0.0122374, -0.0145173,
  -0.0167969, -0.0190761, -0.0213547, -0.0236322, -0.0259085,
  -0.0281833, -0.0304562, -0.0327271, -0.0349957, -0.0372616,
  -0.0395247, -0.0417845, -0.044041, -0.0462937, -0.0485424,
  -0.0507868, -0.0530267, -0.0552618, -0.0574918, -0.0597164,
  -0.0619354, -0.0641484, -0.0663552, -0.0685556, -0.0707492,
  -0.0729358, -0.075115, -0.0772867, -0.0794506, -0.0816063,
  -0.0837536, -0.0858923, -0.088022, -0.0901425, -0.0922535,
  -0.0943548, -0.096446, -0.098527, -0.100597, -0.102657, -0.104705,
  -0.106742, -0.108768, -0.110781, -0.112783, -0.114771, -0.116748,
  -0.118711, -0.120661, -0.122598, -0.12452, -0.126429, -0.128324,
  -0.130204, -0.132069, -0.133919, -0.135754, -0.137574, -0.139378,
  -0.141165, -0.142937, -0.144692, -0.14643, -0.148151, -0.149855,
  -0.151542, -0.15321, -0.154861, -0.156494, -0.158108, -0.159704,
  -0.16128, -0.162838, -0.164376, -0.165895, -0.167394, -0.168873,
  -0.170331, -0.17177, -0.173187, -0.174584, -0.17596, -0.177314,
  -0.178647, -0.179958, -0.181248, -0.182515, -0.18376, -0.184983,
  -0.186183, -0.18736, -0.188514, -0.189644, -0.190752, -0.191835,
  -0.192895, -0.193931, -0.194943, -0.195931, -0.196894, -0.197832,
  -0.198746, -0.199635, -0.200499, -0.201337, -0.20215, -0.202938,
  -0.203699, -0.204435, -0.205145, -0.205829, -0.206487, -0.207118,
  -0.207723, -0.208301, -0.208852, -0.209377, -0.209874, -0.210345,
  -0.210788, -0.211204, -0.211592, -0.211953, -0.212286, -0.212592,
  -0.21287, -0.21312, -0.213342, -0.213536, -0.213702, -0.21384,
  -0.213949, -0.21403, -0.214083, -0.214108, -0.214103, -0.214071,
  -0.214009, -0.21392, -0.213801, -0.213654, -0.213478, -0.213273,
  -0.213039, -0.212777, -0.212486, -0.212166, -0.211817, -0.211439,
  -0.211032, -0.210597, -0.210133, -0.209639, -0.209117, -0.208566,
  -0.207987, -0.207378, -0.206741, -0.206075, -0.20538, -0.204657,
  -0.203905, -0.203125, -0.202316, -0.201479, -0.200613, -0.199719,
  -0.198796, -0.197846, -0.196867, -0.19586, -0.194826, -0.193763,
  -0.192673, -0.191555, -0.19041, -0.189237, -0.188036, -0.186809,
  -0.185554, -0.184272, -0.182964, -0.181628, -0.180266, -0.178878,
  -0.177463, -0.176022, -0.174555, -0.173062, -0.171543, -0.169998,
  -0.168429, -0.166834, -0.165213, -0.163568, -0.161898, -0.160204,
  -0.158485, -0.156742, -0.154975, -0.153184, -0.15137, -0.149532,
  -0.147671, -0.145788, -0.143881, -0.141952, -0.140001, -0.138027,
  -0.136032, -0.134015, -0.131977, -0.129918, -0.127838, -0.125738,
  -0.123617, -0.121476, -0.119315, -0.117135, -0.114935, -0.112716,
  -0.110479, -0.108223, -0.105949, -0.103658, -0.101348, -0.0990219,
  -0.0966784, -0.0943182, -0.0919416, -0.089549, -0.0871407,
  -0.0847169, -0.0822781, -0.0798244, -0.0773563, -0.0748741,
  -0.0723781, -0.0698686, -0.067346, -0.0648107, -0.0622629,
  -0.059703, -0.0571314, -0.0545484, -0.0519544, -0.0493497,
  -0.0467347, -0.0441097, -0.0414752, -0.0388315, -0.0361789,
  -0.0335179, -0.0308488, -0.028172, -0.0254879, -0.0227968,
  -0.0200992, -0.0173954, -0.0146859, -0.011971, -0.00925108,
  -0.00652661, -0.00379796, -0.00106553, 0.00167027, 0.00440904,
  0.00715037, 0.00989385, 0.0126391, 0.0153856, 0.0181331, 0.020881,
  0.0236291, 0.0263767, 0.0291237, 0.0318694, 0.0346135, 0.0373556,
  0.0400952, 0.042832, 0.0455654, 0.048295, 0.0510205, 0.0537414,
  0.0564572, 0.0591676, 0.0618721, 0.0645702, 0.0672615, 0.0699456,
  0.072622, 0.0752904, 0.0779502, 0.0806011, 0.0832426, 0.0858742,
  0.0884956, 0.0911062, 0.0937057, 0.0962935, 0.0988694, 0.101433,
  0.103983, 0.10652, 0.109044, 0.111553, 0.114047, 0.116527, 0.11899,
  0.121438, 0.12387, 0.126284, 0.128682, 0.131062, 0.133423, 0.135766,
  0.13809, 0.140395, 0.14268, 0.144945, 0.147189, 0.149412, 0.151613,
  0.153792, 0.15595, 0.158084, 0.160195, 0.162283, 0.164347, 0.166386,
  0.168401, 0.17039, 0.172354, 0.174292, 0.176204, 0.178088, 0.179946,
  0.181776, 0.183579, 0.185353, 0.187098, 0.188815, 0.190502,
  0.192159, 0.193786, 0.195383, 0.196949, 0.198484, 0.199987,
  0.201458, 0.202898, 0.204304, 0.205678, 0.207019, 0.208326,
  0.209599, 0.210838, 0.212043, 0.213213, 0.214348, 0.215448,
  0.216511, 0.217539, 0.218531, 0.219487, 0.220405, 0.221287,
  0.222131, 0.222937, 0.223706, 0.224437, 0.225129, 0.225783,
  0.226399, 0.226975, 0.227512, 0.22801, 0.228468, 0.228886, 0.229264,
  0.229602, 0.2299, 0.230157, 0.230373, 0.230549, 0.230683, 0.230776,
  0.230828, 0.230838, 0.230807, 0.230734, 0.230619, 0.230462,
  0.230263, 0.230022, 0.229739, 0.229413, 0.229045, 0.228635,
  0.228182, 0.227686, 0.227148, 0.226567, 0.225943, 0.225276,
  0.224567, 0.223815, 0.22302, 0.222183, 0.221303, 0.22038, 0.219414,
  0.218406, 0.217355, 0.216261, 0.215126, 0.213947, 0.212726,
  0.211464, 0.210158, 0.208811, 0.207422, 0.205991, 0.204519,
  0.203005, 0.201449, 0.199853, 0.198215, 0.196536, 0.194816,
  0.193056, 0.191256, 0.189416, 0.187535, 0.185615, 0.183655,
  0.181657, 0.179619, 0.177542, 0.175427, 0.173274, 0.171083,
  0.168854, 0.166588, 0.164286, 0.161946, 0.15957, 0.157158, 0.154711,
  0.152228, 0.14971, 0.147157, 0.144571, 0.141951, 0.139297, 0.13661,
  0.133891, 0.13114, 0.128357, 0.125542, 0.122697, 0.119822, 0.116916,
  0.113982, 0.111018, 0.108026, 0.105006, 0.101959, 0.0988843,
  0.0957838, 0.0926574, 0.0895057, 0.0863294, 0.0831288, 0.0799048,
  0.0766577, 0.0733882, 0.0700969, 0.0667843, 0.0634512, 0.0600981,
  0.0567256, 0.0533345, 0.0499252, 0.0464985, 0.043055, 0.0395954,
  0.0361204, 0.0326307, 0.0291268, 0.0256096, 0.0220797, 0.0185378,
  0.0149847, 0.011421, 0.00784755, 0.00426501, 0.000674135,
  -0.00292432, -0.00652961, -0.010141, -0.0137576, -0.0173788,
  -0.0210038, -0.0246317, -0.0282618, -0.0318933, -0.0355254,
  -0.0391572, -0.0427881, -0.0464171, -0.0500434, -0.0536662,
  -0.0572848, -0.0608981, -0.0645055, -0.0681061, -0.071699,
  -0.0752833, -0.0788583, -0.0824231, -0.0859767, -0.0895184,
  -0.0930472, -0.0965624, -0.100063, -0.103548, -0.107017, -0.110469,
  -0.113902, -0.117317, -0.120711, -0.124085, -0.127438, -0.130767,
  -0.134074, -0.137356, -0.140613, -0.143844, -0.147047, -0.150223,
  -0.153371, -0.156488, -0.159575, -0.162631, -0.165654, -0.168644,
  -0.1716, -0.174521, -0.177406, -0.180255, -0.183066, -0.185838,
  -0.188571, -0.191264, -0.193916, -0.196525, -0.199092, -0.201615,
  -0.204094, -0.206528, -0.208915, -0.211255, -0.213547, -0.215791,
  -0.217985, -0.220129, -0.222222, -0.224263, -0.226251, -0.228186,
  -0.230066, -0.231892, -0.233661, -0.235374, -0.23703, -0.238628,
  -0.240167, -0.241647, -0.243066, -0.244425, -0.245722, -0.246957,
  -0.248129, -0.249237, -0.250281, -0.251261, -0.252175, -0.253023,
  -0.253804, -0.254518, -0.255165, -0.255743, -0.256252, -0.256692,
  -0.257062, -0.257361, -0.25759, -0.257747, -0.257833, -0.257846,
  -0.257787, -0.257654, -0.257449, -0.257169, -0.256815, -0.256387,
  -0.255884, -0.255306, -0.254652, -0.253923, -0.253118, -0.252236,
  -0.251279, -0.250245, -0.249134, -0.247947, -0.246682, -0.245341,
  -0.243922, -0.242427, -0.240854, -0.239204, -0.237477, -0.235673,
  -0.233791, -0.231833, -0.229798, -0.227686, -0.225497, -0.223232,
  -0.220891, -0.218473, -0.21598, -0.213412, -0.210768, -0.208049,
  -0.205256, -0.202389, -0.199449, -0.196434, -0.193348, -0.190189,
  -0.186958, -0.183656, -0.180283, -0.17684, -0.173328, -0.169747,
  -0.166098, -0.162381, -0.158598, -0.154749, -0.150836, -0.146858,
  -0.142816, -0.138713, -0.134548, -0.130322, -0.126037, -0.121693,
  -0.117292, -0.112834, -0.108321, -0.103754, -0.0991343, -0.0944626,
  -0.0897403, -0.0849689, -0.0801495, -0.0752834, -0.0703721,
  -0.0654169, -0.0604193, -0.0553807, -0.0503026, -0.0451865,
  -0.040034, -0.0348466, -0.029626, -0.0243738, -0.0190916,
  -0.0137813, -0.00844443, -0.00308286, 0.00230163, 0.00770721,
  0.013132, 0.0185742, 0.0240318, 0.0295029, 0.0349855, 0.0404776,
  0.0459772, 0.0514821, 0.0569904, 0.0624999, 0.0680084, 0.0735138,
  0.0790138, 0.0845063, 0.089989, 0.0954596, 0.100916, 0.106355,
  0.111775, 0.117174, 0.122549, 0.127898, 0.133218, 0.138506,
  0.143761, 0.14898, 0.15416, 0.159298, 0.164393, 0.169441, 0.17444,
  0.179388, 0.184281, 0.189116, 0.193893, 0.198606, 0.203255,
  0.207836, 0.212346, 0.216784, 0.221145, 0.225427, 0.229628,
  0.233745, 0.237775, 0.241715, 0.245562, 0.249314, 0.252968,
  0.256522, 0.259971, 0.263314, 0.266548, 0.269671, 0.272678,
  0.275569, 0.278339, 0.280986, 0.283508, 0.285902, 0.288165,
  0.290294, 0.292288, 0.294143, 0.295856, 0.297426, 0.298849,
  0.300124, 0.301248, 0.302217, 0.303031, 0.303686, 0.304181,
  0.304513, 0.304679, 0.304679, 0.304509, 0.304167, 0.303652,
  0.302961, 0.302093, 0.301045, 0.299817, 0.298406, 0.296811,
  0.295029, 0.293061, 0.290903, 0.288556, 0.286017, 0.283286,
  0.280362, 0.277243, 0.273928, 0.270418, 0.266711, 0.262806,
  0.258704, 0.254404, 0.249905, 0.245208, 0.240313, 0.23522, 0.229929,
  0.224441, 0.218756, 0.212875, 0.206799, 0.200529, 0.194066,
  0.187411, 0.180567, 0.173535, 0.166316, 0.158912, 0.151327,
  0.143563, 0.135621, 0.127505, 0.119219, 0.110764, 0.102146,
  0.0933669, 0.0844313, 0.0753434, 0.0661075, 0.0567283, 0.0472107,
  0.03756, 0.0277815, 0.017881, 0.00786445, -0.00226187, -0.0124914,
  -0.0228173, -0.0332323, -0.0437291, -0.0542998, -0.0649363,
  -0.0756301, -0.0863725, -0.0971544, -0.107966, -0.118798, -0.12964,
  -0.140481, -0.151311, -0.162118, -0.172889, -0.183614, -0.19428,
  -0.204872, -0.215379, -0.225786, -0.236079, -0.246243, -0.256262,
  -0.266122, -0.275805, -0.285295, -0.294575, -0.303628, -0.312433,
  -0.320974, -0.32923, -0.337182, -0.344808, -0.352089, -0.359002,
  -0.365526, -0.371636, -0.37731, -0.382524, -0.387252, -0.39147,
  -0.39515, -0.398268, -0.400794, -0.4027, -0.403959, -0.404539,
  -0.404412, -0.403545, -0.401906, -0.399463, -0.396183, -0.392031,
  -0.386972, -0.380969, -0.373987, -0.365987, -0.356931, -0.346779,
  -0.335491, -0.323025, -0.30934, -0.294391, -0.278135, -0.260527,
  -0.24152, -0.221066, -0.199119, -0.175628, -0.150542, -0.123811,
  -0.0953815, -0.0651999, -0.0332113, 0.000640403, 0.0364125,
  0.0741636, 0.113953, 0.155842, 0.199893, 0.246169, 0.294736,
  0.345658, 0.399004, 0.454842, 0.513243, 0.574278, 0.638021,
  0.704545, 0.773927, 0.846244, 0.921574, 1}; G4double
  G4NeutronHPFastLegendre::i16[3401] = {0, 0.00056501, 0.0010848,
  0.00156117, 0.00199587, 0.0023906, 0.00274702, 0.00306674,
  0.00335134, 0.00360235, 0.00382124, 0.00400947, 0.00416844,
  0.00429953, 0.00440404, 0.00448329, 0.00453851, 0.00457093,
  0.00458173, 0.00457206, 0.00454302, 0.0044957, 0.00443114,
  0.00435037, 0.00425435, 0.00414405, 0.00402039, 0.00388426,
  0.00373653, 0.00357803, 0.00340957, 0.00323194, 0.00304589,
  0.00285215, 0.00265142, 0.00244439, 0.00223171, 0.00201402,
  0.00179192, 0.00156601, 0.00133685, 0.00110497, 0.000870916,
  0.000635178, 0.000398241, 0.000160569, -7.73948e-05, -0.000315223,
  -0.00055251, -0.000788863, -0.00102391, -0.0012573, -0.00148869,
  -0.00171775, -0.00194418, -0.00216768, -0.00238798, -0.00260482,
  -0.00281793, -0.0030271, -0.00323209, -0.00343269, -0.00362871,
  -0.00381996, -0.00400627, -0.00418748, -0.00436343, -0.00453399,
  -0.00469903, -0.00485843, -0.00501208, -0.00515988, -0.00530175,
  -0.0054376, -0.00556736, -0.00569097, -0.00580837, -0.00591952,
  -0.00602438, -0.00612291, -0.00621509, -0.00630092, -0.00638036,
  -0.00645343, -0.00652013, -0.00658046, -0.00663443, -0.00668208,
  -0.00672342, -0.00675849, -0.00678732, -0.00680995, -0.00682643,
  -0.00683681, -0.00684114, -0.00683949, -0.00683191, -0.00681847,
  -0.00679925, -0.00677431, -0.00674373, -0.0067076, -0.00666599,
  -0.00661899, -0.00656669, -0.00650917, -0.00644655, -0.0063789,
  -0.00630632, -0.00622892, -0.0061468, -0.00606006, -0.0059688,
  -0.00587314, -0.00577317, -0.00566902, -0.00556078, -0.00544857,
  -0.0053325, -0.00521269, -0.00508925, -0.00496229, -0.00483192,
  -0.00469828, -0.00456146, -0.00442158, -0.00427877, -0.00413314,
  -0.00398481, -0.00383388, -0.00368049, -0.00352474, -0.00336675,
  -0.00320664, -0.00304452, -0.00288051, -0.00271472, -0.00254727,
  -0.00237826, -0.00220782, -0.00203606, -0.00186308, -0.001689,
  -0.00151393, -0.00133797, -0.00116124, -0.000983838, -0.000805872,
  -0.000627448, -0.000448669, -0.000269638, -9.04564e-05, 8.87751e-05,
  0.000267958, 0.000446994, 0.000625786, 0.000804241, 0.000982263,
  0.00115976, 0.00133664, 0.00151282, 0.0016882, 0.0018627,
  0.00203624, 0.00220873, 0.00238008, 0.00255022, 0.00271907,
  0.00288655, 0.00305259, 0.0032171, 0.00338002, 0.00354127,
  0.0037008, 0.00385851, 0.00401436, 0.00416827, 0.00432019,
  0.00447004, 0.00461778, 0.00476334, 0.00490666, 0.00504769,
  0.00518637, 0.00532266, 0.00545651, 0.00558786, 0.00571666,
  0.00584288, 0.00596647, 0.00608738, 0.00620558, 0.00632102,
  0.00643368, 0.0065435, 0.00665047, 0.00675454, 0.00685568,
  0.00695387, 0.00704908, 0.00714127, 0.00723043, 0.00731653,
  0.00739956, 0.00747948, 0.00755628, 0.00762994, 0.00770045,
  0.00776779, 0.00783194, 0.00789291, 0.00795066, 0.00800521,
  0.00805653, 0.00810463, 0.00814949, 0.00819111, 0.0082295,
  0.00826464, 0.00829654, 0.00832521, 0.00835064, 0.00837283,
  0.0083918, 0.00840754, 0.00842007, 0.0084294, 0.00843553,
  0.00843847, 0.00843824, 0.00843485, 0.00842831, 0.00841864,
  0.00840585, 0.00838997, 0.008371, 0.00834898, 0.00832391,
  0.00829583, 0.00826474, 0.00823068, 0.00819367, 0.00815373,
  0.00811088, 0.00806517, 0.0080166, 0.00796521, 0.00791103,
  0.00785409, 0.00779441, 0.00773204, 0.00766699, 0.0075993,
  0.00752901, 0.00745614, 0.00738074, 0.00730284, 0.00722246,
  0.00713966, 0.00705445, 0.00696689, 0.00687701, 0.00678485,
  0.00669044, 0.00659382, 0.00649504, 0.00639414, 0.00629114,
  0.0061861, 0.00607906, 0.00597005, 0.00585912, 0.00574631,
  0.00563167, 0.00551523, 0.00539704, 0.00527714, 0.00515557,
  0.00503239, 0.00490762, 0.00478133, 0.00465354, 0.00452432,
  0.00439369, 0.00426171, 0.00412841, 0.00399385, 0.00385808,
  0.00372112, 0.00358304, 0.00344388, 0.00330367, 0.00316248,
  0.00302033, 0.00287728, 0.00273338, 0.00258866, 0.00244318,
  0.00229697, 0.00215009, 0.00200258, 0.00185449, 0.00170585,
  0.00155672, 0.00140713, 0.00125714, 0.00110679, 0.000956116,
  0.00080517, 0.000653995, 0.000502633, 0.000351128, 0.000199524,
  4.78636e-05, -0.00010381, -0.000255455, -0.000407029, -0.000558489,
  -0.000709793, -0.000860901, -0.00101177, -0.00116236, -0.00131263,
  -0.00146254, -0.00161205, -0.00176112, -0.00190971, -0.00205778,
  -0.0022053, -0.00235222, -0.00249851, -0.00264412, -0.00278903,
  -0.0029332, -0.00307658, -0.00321915, -0.00336086, -0.00350168,
  -0.00364159, -0.00378053, -0.00391849, -0.00405542, -0.00419129,
  -0.00432607, -0.00445973, -0.00459224, -0.00472356, -0.00485367,
  -0.00498253, -0.00511011, -0.00523639, -0.00536133, -0.00548491,
  -0.00560711, -0.00572788, -0.00584721, -0.00596507, -0.00608143,
  -0.00619626, -0.00630955, -0.00642127, -0.00653139, -0.0066399,
  -0.00674676, -0.00685195, -0.00695546, -0.00705727, -0.00715734,
  -0.00725567, -0.00735222, -0.00744699, -0.00753995, -0.00763109,
  -0.00772038, -0.00780782, -0.00789337, -0.00797704, -0.00805879,
  -0.00813863, -0.00821652, -0.00829247, -0.00836645, -0.00843845,
  -0.00850846, -0.00857646, -0.00864245, -0.00870642, -0.00876835,
  -0.00882824, -0.00888607, -0.00894184, -0.00899554, -0.00904715,
  -0.00909668, -0.00914412, -0.00918946, -0.00923269, -0.00927381,
  -0.00931281, -0.00934969, -0.00938445, -0.00941709, -0.00944759,
  -0.00947596, -0.0095022, -0.0095263, -0.00954826, -0.00956809,
  -0.00958579, -0.00960134, -0.00961476, -0.00962605, -0.00963521,
  -0.00964224, -0.00964714, -0.00964992, -0.00965058, -0.00964913,
  -0.00964557, -0.0096399, -0.00963213, -0.00962227, -0.00961033,
  -0.0095963, -0.0095802, -0.00956203, -0.00954181, -0.00951954,
  -0.00949523, -0.00946889, -0.00944053, -0.00941016, -0.00937779,
  -0.00934343, -0.00930709, -0.00926878, -0.00922852, -0.00918632,
  -0.00914219, -0.00909614, -0.00904819, -0.00899835, -0.00894663,
  -0.00889305, -0.00883762, -0.00878037, -0.0087213, -0.00866042,
  -0.00859776, -0.00853334, -0.00846716, -0.00839925, -0.00832962,
  -0.00825829, -0.00818527, -0.0081106, -0.00803427, -0.00795632,
  -0.00787676, -0.00779561, -0.00771289, -0.00762861, -0.00754281,
  -0.00745549, -0.00736669, -0.00727641, -0.00718468, -0.00709152,
  -0.00699696, -0.00690101, -0.00680369, -0.00670503, -0.00660504,
  -0.00650376, -0.0064012, -0.00629738, -0.00619233, -0.00608607,
  -0.00597863, -0.00587002, -0.00576026, -0.0056494, -0.00553743,
  -0.0054244, -0.00531031, -0.00519521, -0.0050791, -0.00496202,
  -0.00484399, -0.00472503, -0.00460517, -0.00448443, -0.00436283,
  -0.00424041, -0.00411718, -0.00399317, -0.00386841, -0.00374291,
  -0.00361671, -0.00348983, -0.0033623, -0.00323413, -0.00310536,
  -0.002976, -0.0028461, -0.00271566, -0.00258471, -0.00245329,
  -0.00232141, -0.0021891, -0.00205639, -0.00192329, -0.00178984,
  -0.00165607, -0.00152199, -0.00138763, -0.00125301, -0.00111817,
  -0.000983123, -0.000847897, -0.000712517, -0.000577007,
  -0.000441393, -0.000305699, -0.000169949, -3.4169e-05, 0.000101617,
  0.000237385, 0.000373111, 0.000508769, 0.000644336, 0.000779788,
  0.000915101, 0.00105025, 0.00118521, 0.00131997, 0.00145448,
  0.00158874, 0.00172272, 0.0018564, 0.00198974, 0.00212274,
  0.00225536, 0.00238759, 0.0025194, 0.00265077, 0.00278167,
  0.00291209, 0.003042, 0.00317138, 0.00330021, 0.00342847,
  0.00355614, 0.00368318, 0.0038096, 0.00393535, 0.00406043,
  0.00418481, 0.00430847, 0.00443139, 0.00455355, 0.00467493,
  0.00479552, 0.00491528, 0.00503421, 0.00515229, 0.00526949,
  0.00538579, 0.00550119, 0.00561565, 0.00572916, 0.00584171,
  0.00595328, 0.00606384, 0.00617339, 0.0062819, 0.00638936,
  0.00649575, 0.00660105, 0.00670526, 0.00680835, 0.0069103,
  0.00701111, 0.00711076, 0.00720922, 0.0073065, 0.00740257,
  0.00749742, 0.00759103, 0.00768339, 0.00777449, 0.00786432,
  0.00795286, 0.00804009, 0.00812602, 0.00821061, 0.00829387,
  0.00837578, 0.00845633, 0.0085355, 0.00861329, 0.00868969,
  0.00876468, 0.00883826, 0.00891041, 0.00898112, 0.00905039,
  0.00911821, 0.00918456, 0.00924944, 0.00931285, 0.00937476,
  0.00943518, 0.00949409, 0.00955149, 0.00960737, 0.00966173,
  0.00971456, 0.00976584, 0.00981558, 0.00986377, 0.0099104,
  0.00995548, 0.00999898, 0.0100409, 0.0100813, 0.01012, 0.0101572,
  0.0101928, 0.0102268, 0.0102593, 0.0102901, 0.0103193, 0.0103469,
  0.0103729, 0.0103973, 0.01042, 0.0104412, 0.0104608, 0.0104787,
  0.010495, 0.0105097, 0.0105228, 0.0105343, 0.0105442, 0.0105524,
  0.010559, 0.010564, 0.0105674, 0.0105692, 0.0105694, 0.010568,
  0.0105649, 0.0105603, 0.0105541, 0.0105462, 0.0105368, 0.0105258,
  0.0105131, 0.0104989, 0.0104832, 0.0104658, 0.0104469, 0.0104264,
  0.0104043, 0.0103807, 0.0103555, 0.0103288, 0.0103005, 0.0102707,
  0.0102394, 0.0102066, 0.0101722, 0.0101363, 0.010099, 0.0100601,
  0.0100197, 0.00997789, 0.00993458, 0.0098898, 0.00984357,
  0.00979589, 0.00974678, 0.00969623, 0.00964426, 0.00959088,
  0.0095361, 0.00947992, 0.00942236, 0.00936343, 0.00930313,
  0.00924148, 0.00917849, 0.00911416, 0.00904852, 0.00898156,
  0.0089133, 0.00884376, 0.00877294, 0.00870085, 0.00862751,
  0.00855293, 0.00847711, 0.00840009, 0.00832185, 0.00824242,
  0.00816182, 0.00808004, 0.00799711, 0.00791304, 0.00782785,
  0.00774153, 0.00765412, 0.00756562, 0.00747604, 0.00738541,
  0.00729372, 0.00720101, 0.00710728, 0.00701254, 0.00691681,
  0.00682011, 0.00672245, 0.00662384, 0.0065243, 0.00642385,
  0.00632249, 0.00622025, 0.00611714, 0.00601317, 0.00590836,
  0.00580273, 0.00569629, 0.00558905, 0.00548104, 0.00537227,
  0.00526275, 0.0051525, 0.00504153, 0.00492987, 0.00481753,
  0.00470452, 0.00459086, 0.00447657, 0.00436166, 0.00424615,
  0.00413006, 0.00401339, 0.00389618, 0.00377844, 0.00366017,
  0.00354141, 0.00342216, 0.00330244, 0.00318228, 0.00306168,
  0.00294066, 0.00281924, 0.00269744, 0.00257527, 0.00245275,
  0.0023299, 0.00220674, 0.00208328, 0.00195953, 0.00183552,
  0.00171126, 0.00158677, 0.00146207, 0.00133717, 0.00121209,
  0.00108685, 0.000961465, 0.000835949, 0.00071032, 0.000584597,
  0.000458795, 0.000332932, 0.000207025, 8.10898e-05, -4.4856e-05,
  -0.000170796, -0.000296713, -0.000422591, -0.000548413,
  -0.000674162, -0.000799821, -0.000925375, -0.00105081, -0.0011761,
  -0.00130124, -0.0014262, -0.00155098, -0.00167555, -0.00179991,
  -0.00192402, -0.00204789, -0.00217148, -0.00229479, -0.0024178,
  -0.0025405, -0.00266286, -0.00278487, -0.00290652, -0.00302779,
  -0.00314867, -0.00326913, -0.00338917, -0.00350877, -0.00362792,
  -0.00374659, -0.00386478, -0.00398247, -0.00409964, -0.00421628,
  -0.00433238, -0.00444792, -0.00456288, -0.00467726, -0.00479103,
  -0.00490419, -0.00501672, -0.0051286, -0.00523982, -0.00535038,
  -0.00546024, -0.00556941, -0.00567786, -0.00578559, -0.00589258,
  -0.00599882, -0.0061043, -0.00620899, -0.0063129, -0.006416,
  -0.00651828, -0.00661974, -0.00672036, -0.00682013, -0.00691903,
  -0.00701706, -0.0071142, -0.00721044, -0.00730577, -0.00740018,
  -0.00749365, -0.00758618, -0.00767776, -0.00776837, -0.007858,
  -0.00794665, -0.0080343, -0.00812094, -0.00820657, -0.00829117,
  -0.00837473, -0.00845724, -0.0085387, -0.00861909, -0.0086984,
  -0.00877664, -0.00885378, -0.00892982, -0.00900474, -0.00907855,
  -0.00915124, -0.00922278, -0.00929319, -0.00936244, -0.00943053,
  -0.00949746, -0.00956322, -0.00962779, -0.00969118, -0.00975337,
  -0.00981436, -0.00987414, -0.00993271, -0.00999005, -0.0100462,
  -0.0101011, -0.0101547, -0.0102071, -0.0102583, -0.0103082,
  -0.0103568, -0.0104042, -0.0104503, -0.0104951, -0.0105386,
  -0.0105809, -0.0106219, -0.0106615, -0.0106999, -0.010737,
  -0.0107728, -0.0108073, -0.0108404, -0.0108723, -0.0109028,
  -0.010932, -0.0109599, -0.0109865, -0.0110117, -0.0110356,
  -0.0110582, -0.0110795, -0.0110994, -0.011118, -0.0111352,
  -0.0111511, -0.0111657, -0.0111789, -0.0111908, -0.0112014,
  -0.0112106, -0.0112185, -0.011225, -0.0112302, -0.011234,
  -0.0112365, -0.0112377, -0.0112375, -0.011236, -0.0112332,
  -0.011229, -0.0112235, -0.0112166, -0.0112084, -0.0111989,
  -0.0111881, -0.0111759, -0.0111625, -0.0111477, -0.0111315,
  -0.0111141, -0.0110954, -0.0110753, -0.0110539, -0.0110313,
  -0.0110073, -0.0109821, -0.0109555, -0.0109277, -0.0108986,
  -0.0108682, -0.0108365, -0.0108036, -0.0107694, -0.0107339,
  -0.0106972, -0.0106592, -0.01062, -0.0105795, -0.0105379,
  -0.0104949, -0.0104508, -0.0104055, -0.0103589, -0.0103111,
  -0.0102622, -0.010212, -0.0101607, -0.0101081, -0.0100544,
  -0.00999958, -0.00994356, -0.0098864, -0.00982809, -0.00976864,
  -0.00970807, -0.00964638, -0.00958357, -0.00951966, -0.00945466,
  -0.00938856, -0.00932139, -0.00925314, -0.00918383, -0.00911347,
  -0.00904206, -0.00896961, -0.00889614, -0.00882165, -0.00874614,
  -0.00866964, -0.00859214, -0.00851366, -0.00843421, -0.0083538,
  -0.00827244, -0.00819013, -0.00810689, -0.00802272, -0.00793765,
  -0.00785167, -0.00776479, -0.00767704, -0.00758841, -0.00749892,
  -0.00740859, -0.00731741, -0.0072254, -0.00713258, -0.00703895,
  -0.00694452, -0.00684931, -0.00675332, -0.00665658, -0.00655908,
  -0.00646084, -0.00636188, -0.00626219, -0.00616181, -0.00606073,
  -0.00595896, -0.00585653, -0.00575344, -0.00564971, -0.00554534,
  -0.00544035, -0.00533475, -0.00522856, -0.00512177, -0.00501442,
  -0.0049065, -0.00479804, -0.00468904, -0.00457952, -0.00446949,
  -0.00435895, -0.00424794, -0.00413645, -0.0040245, -0.0039121,
  -0.00379926, -0.00368601, -0.00357234, -0.00345828, -0.00334384,
  -0.00322902, -0.00311385, -0.00299833, -0.00288248, -0.00276631,
  -0.00264983, -0.00253307, -0.00241602, -0.0022987, -0.00218114,
  -0.00206333, -0.00194529, -0.00182704, -0.00170859, -0.00158995,
  -0.00147113, -0.00135216, -0.00123303, -0.00111377, -0.000994389,
  -0.000874897, -0.000755309, -0.000635639, -0.000515899,
  -0.000396102, -0.000276262, -0.000156392, -3.65052e-05, 8.33859e-05,
  0.000203268, 0.000323128, 0.000442952, 0.000562728, 0.000682443,
  0.000802084, 0.000921637, 0.00104109, 0.00116043, 0.00127964,
  0.00139872, 0.00151764, 0.0016364, 0.00175498, 0.00187337,
  0.00199155, 0.00210952, 0.00222727, 0.00234477, 0.00246202,
  0.002579, 0.0026957, 0.00281211, 0.00292822, 0.00304401, 0.00315948,
  0.0032746, 0.00338937, 0.00350377, 0.0036178, 0.00373144,
  0.00384468, 0.0039575, 0.0040699, 0.00418186, 0.00429337,
  0.00440442, 0.004515, 0.0046251, 0.0047347, 0.00484379, 0.00495236,
  0.00506041, 0.00516791, 0.00527486, 0.00538124, 0.00548706,
  0.00559228, 0.00569691, 0.00580093, 0.00590433, 0.00600711,
  0.00610924, 0.00621073, 0.00631155, 0.0064117, 0.00651117,
  0.00660995, 0.00670802, 0.00680538, 0.00690202, 0.00699793,
  0.0070931, 0.00718751, 0.00728117, 0.00737405, 0.00746615,
  0.00755746, 0.00764797, 0.00773768, 0.00782656, 0.00791462,
  0.00800185, 0.00808823, 0.00817375, 0.00825842, 0.00834221,
  0.00842513, 0.00850715, 0.00858829, 0.00866852, 0.00874783,
  0.00882623, 0.0089037, 0.00898024, 0.00905583, 0.00913047,
  0.00920416, 0.00927688, 0.00934862, 0.00941939, 0.00948917,
  0.00955796, 0.00962575, 0.00969253, 0.00975829, 0.00982304,
  0.00988676, 0.00994945, 0.0100111, 0.0100717, 0.0101313, 0.0101898,
  0.0102472, 0.0103036, 0.0103589, 0.0104131, 0.0104662, 0.0105183,
  0.0105692, 0.0106191, 0.0106678, 0.0107155, 0.010762, 0.0108074,
  0.0108517, 0.0108949, 0.0109369, 0.0109778, 0.0110176, 0.0110562,
  0.0110937, 0.0111301, 0.0111653, 0.0111993, 0.0112322, 0.0112639,
  0.0112944, 0.0113238, 0.0113521, 0.0113791, 0.011405, 0.0114297,
  0.0114532, 0.0114756, 0.0114967, 0.0115167, 0.0115355, 0.0115531,
  0.0115696, 0.0115848, 0.0115988, 0.0116117, 0.0116234, 0.0116338,
  0.0116431, 0.0116512, 0.0116581, 0.0116638, 0.0116683, 0.0116716,
  0.0116737, 0.0116747, 0.0116744, 0.0116729, 0.0116703, 0.0116664,
  0.0116614, 0.0116552, 0.0116477, 0.0116391, 0.0116294, 0.0116184,
  0.0116062, 0.0115929, 0.0115783, 0.0115626, 0.0115458, 0.0115277,
  0.0115085, 0.0114881, 0.0114665, 0.0114438, 0.0114199, 0.0113949,
  0.0113687, 0.0113413, 0.0113128, 0.0112832, 0.0112524, 0.0112205,
  0.0111874, 0.0111532, 0.0111179, 0.0110814, 0.0110438, 0.0110051,
  0.0109653, 0.0109244, 0.0108824, 0.0108393, 0.0107951, 0.0107498,
  0.0107034, 0.010656, 0.0106074, 0.0105578, 0.0105072, 0.0104555,
  0.0104027, 0.0103489, 0.010294, 0.0102381, 0.0101812, 0.0101232,
  0.0100643, 0.0100043, 0.00994331, 0.00988133, 0.00981836, 0.0097544,
  0.00968947, 0.00962357, 0.0095567, 0.00948887, 0.0094201,
  0.00935038, 0.00927973, 0.00920814, 0.00913564, 0.00906222,
  0.0089879, 0.00891268, 0.00883656, 0.00875957, 0.0086817,
  0.00860297, 0.00852337, 0.00844293, 0.00836164, 0.00827952,
  0.00819658, 0.00811282, 0.00802825, 0.00794288, 0.00785672,
  0.00776978, 0.00768206, 0.00759358, 0.00750435, 0.00741437,
  0.00732365, 0.00723221, 0.00714005, 0.00704718, 0.0069536,
  0.00685934, 0.0067644, 0.00666879, 0.00657252, 0.00647559,
  0.00637803, 0.00627983, 0.00618101, 0.00608157, 0.00598154,
  0.00588091, 0.0057797, 0.00567793, 0.00557558, 0.00547269,
  0.00536926, 0.00526529, 0.00516081, 0.00505582, 0.00495032,
  0.00484434, 0.00473788, 0.00463096, 0.00452357, 0.00441575,
  0.00430748, 0.00419879, 0.00408969, 0.00398018, 0.00387029,
  0.00376001, 0.00364936, 0.00353835, 0.003427, 0.00331531,
  0.00320329, 0.00309096, 0.00297832, 0.00286539, 0.00275218,
  0.0026387, 0.00252496, 0.00241097, 0.00229675, 0.0021823,
  0.00206763, 0.00195277, 0.00183771, 0.00172247, 0.00160706,
  0.0014915, 0.00137579, 0.00125995, 0.00114398, 0.0010279,
  0.000911717, 0.000795447, 0.000679099, 0.000562685, 0.000446216,
  0.000329704, 0.000213159, 9.65932e-05, -1.99819e-05, -0.000136555,
  -0.000253115, -0.00036965, -0.000486149, -0.000602601, -0.000718994,
  -0.000835317, -0.000951558, -0.00106771, -0.00118375, -0.00129968,
  -0.00141548, -0.00153115, -0.00164667, -0.00176202, -0.00187721,
  -0.00199221, -0.00210702, -0.00222162, -0.00233601, -0.00245017,
  -0.00256409, -0.00267776, -0.00279118, -0.00290432, -0.00301718,
  -0.00312975, -0.00324201, -0.00335396, -0.00346558, -0.00357687,
  -0.00368781, -0.0037984, -0.00390861, -0.00401845, -0.00412789,
  -0.00423694, -0.00434558, -0.0044538, -0.00456158, -0.00466893,
  -0.00477582, -0.00488225, -0.00498821, -0.00509368, -0.00519867,
  -0.00530315, -0.00540711, -0.00551056, -0.00561347, -0.00571584,
  -0.00581766, -0.00591892, -0.00601961, -0.00611971, -0.00621923,
  -0.00631814, -0.00641645, -0.00651413, -0.00661119, -0.00670761,
  -0.00680339, -0.00689851, -0.00699296, -0.00708674, -0.00717984,
  -0.00727225, -0.00736395, -0.00745495, -0.00754523, -0.00763478,
  -0.0077236, -0.00781168, -0.007899, -0.00798557, -0.00807137,
  -0.00815639, -0.00824063, -0.00832407, -0.00840672, -0.00848856,
  -0.00856958, -0.00864978, -0.00872915, -0.00880768, -0.00888537,
  -0.0089622, -0.00903818, -0.00911328, -0.00918751, -0.00926087,
  -0.00933333, -0.0094049, -0.00947557, -0.00954533, -0.00961417,
  -0.00968209, -0.00974909, -0.00981515, -0.00988027, -0.00994445,
  -0.0100077, -0.0100699, -0.0101312, -0.0101916, -0.0102509,
  -0.0103093, -0.0103667, -0.0104231, -0.0104785, -0.0105329,
  -0.0105863, -0.0106387, -0.0106901, -0.0107404, -0.0107897,
  -0.010838, -0.0108853, -0.0109315, -0.0109766, -0.0110208,
  -0.0110638, -0.0111058, -0.0111468, -0.0111867, -0.0112255,
  -0.0112633, -0.0112999, -0.0113356, -0.0113701, -0.0114035,
  -0.0114359, -0.0114671, -0.0114973, -0.0115264, -0.0115543,
  -0.0115812, -0.011607, -0.0116316, -0.0116552, -0.0116776,
  -0.011699, -0.0117192, -0.0117383, -0.0117563, -0.0117732,
  -0.0117889, -0.0118035, -0.0118171, -0.0118294, -0.0118407,
  -0.0118508, -0.0118598, -0.0118677, -0.0118745, -0.0118801,
  -0.0118846, -0.0118879, -0.0118902, -0.0118913, -0.0118913,
  -0.0118901, -0.0118878, -0.0118844, -0.0118799, -0.0118742,
  -0.0118674, -0.0118595, -0.0118504, -0.0118403, -0.011829,
  -0.0118166, -0.011803, -0.0117884, -0.0117726, -0.0117557,
  -0.0117377, -0.0117186, -0.0116984, -0.011677, -0.0116546,
  -0.011631, -0.0116064, -0.0115806, -0.0115538, -0.0115258,
  -0.0114968, -0.0114667, -0.0114355, -0.0114032, -0.0113698,
  -0.0113354, -0.0112998, -0.0112633, -0.0112256, -0.0111869,
  -0.0111471, -0.0111063, -0.0110644, -0.0110215, -0.0109775,
  -0.0109325, -0.0108864, -0.0108393, -0.0107912, -0.0107421,
  -0.010692, -0.0106408, -0.0105887, -0.0105355, -0.0104814,
  -0.0104262, -0.0103701, -0.010313, -0.0102549, -0.0101959,
  -0.0101359, -0.0100749, -0.010013, -0.00995011, -0.0098863,
  -0.00982156, -0.00975589, -0.0096893, -0.00962179, -0.00955338,
  -0.00948406, -0.00941385, -0.00934275, -0.00927077, -0.00919791,
  -0.00912418, -0.0090496, -0.00897416, -0.00889787, -0.00882074,
  -0.00874278, -0.008664, -0.0085844, -0.00850398, -0.00842277,
  -0.00834076, -0.00825797, -0.00817439, -0.00809005, -0.00800494,
  -0.00791908, -0.00783247, -0.00774512, -0.00765704, -0.00756824,
  -0.00747873, -0.00738851, -0.00729759, -0.00720599, -0.00711371,
  -0.00702075, -0.00692714, -0.00683287, -0.00673796, -0.00664241,
  -0.00654624, -0.00644945, -0.00635205, -0.00625406, -0.00615547,
  -0.00605631, -0.00595657, -0.00585627, -0.00575542, -0.00565403,
  -0.00555211, -0.00544966, -0.00534671, -0.00524324, -0.00513928,
  -0.00503484, -0.00492993, -0.00482455, -0.00471872, -0.00461244,
  -0.00450572, -0.00439859, -0.00429104, -0.00418308, -0.00407473,
  -0.003966, -0.00385689, -0.00374742, -0.0036376, -0.00352744,
  -0.00341694, -0.00330612, -0.00319499, -0.00308356, -0.00297184,
  -0.00285984, -0.00274757, -0.00263504, -0.00252227, -0.00240925,
  -0.00229601, -0.00218256, -0.0020689, -0.00195504, -0.001841,
  -0.00172678, -0.00161241, -0.00149788, -0.00138321, -0.00126841,
  -0.00115349, -0.00103846, -0.000923339, -0.000808127, -0.000692839,
  -0.000577486, -0.000462079, -0.000346628, -0.000231144,
  -0.000115639, -1.22549e-07, 0.000115394, 0.000230899, 0.000346383,
  0.000461834, 0.000577241, 0.000692594, 0.000807882, 0.000923094,
  0.00103822, 0.00115325, 0.00126817, 0.00138296, 0.00149763,
  0.00161216, 0.00172654, 0.00184075, 0.00195479, 0.00206865,
  0.00218231, 0.00229577, 0.00240901, 0.00252202, 0.0026348,
  0.00274733, 0.0028596, 0.0029716, 0.00308332, 0.00319475,
  0.00330588, 0.0034167, 0.00352719, 0.00363736, 0.00374718,
  0.00385665, 0.00396575, 0.00407449, 0.00418284, 0.00429079,
  0.00439834, 0.00450548, 0.00461219, 0.00471847, 0.0048243,
  0.00492968, 0.0050346, 0.00513904, 0.005243, 0.00534646, 0.00544942,
  0.00555187, 0.00565379, 0.00575518, 0.00585603, 0.00595633,
  0.00605606, 0.00615523, 0.00625381, 0.00635181, 0.0064492,
  0.00654599, 0.00664217, 0.00673771, 0.00683262, 0.00692689,
  0.00702051, 0.00711346, 0.00720574, 0.00729735, 0.00738826,
  0.00747848, 0.007568, 0.0076568, 0.00774487, 0.00783222, 0.00791883,
  0.0080047, 0.0080898, 0.00817415, 0.00825772, 0.00834052,
  0.00842253, 0.00850374, 0.00858415, 0.00866375, 0.00874254,
  0.0088205, 0.00889762, 0.00897391, 0.00904935, 0.00912394,
  0.00919766, 0.00927052, 0.0093425, 0.0094136, 0.00948382,
  0.00955313, 0.00962155, 0.00968905, 0.00975564, 0.00982131,
  0.00988605, 0.00994986, 0.0100127, 0.0100747, 0.0101356, 0.0101956,
  0.0102547, 0.0103128, 0.0103699, 0.010426, 0.0104811, 0.0105353,
  0.0105884, 0.0106406, 0.0106917, 0.0107419, 0.010791, 0.0108391,
  0.0108862, 0.0109322, 0.0109772, 0.0110212, 0.0110641, 0.011106,
  0.0111469, 0.0111866, 0.0112254, 0.011263, 0.0112996, 0.0113351,
  0.0113696, 0.0114029, 0.0114352, 0.0114664, 0.0114966, 0.0115256,
  0.0115535, 0.0115804, 0.0116061, 0.0116308, 0.0116543, 0.0116768,
  0.0116981, 0.0117183, 0.0117375, 0.0117555, 0.0117724, 0.0117881,
  0.0118028, 0.0118163, 0.0118287, 0.01184, 0.0118502, 0.0118592,
  0.0118672, 0.011874, 0.0118796, 0.0118842, 0.0118876, 0.0118899,
  0.011891, 0.011891, 0.0118899, 0.0118877, 0.0118843, 0.0118798,
  0.0118742, 0.0118675, 0.0118596, 0.0118506, 0.0118405, 0.0118292,
  0.0118168, 0.0118033, 0.0117887, 0.0117729, 0.0117561, 0.0117381,
  0.011719, 0.0116987, 0.0116774, 0.0116549, 0.0116314, 0.0116067,
  0.011581, 0.0115541, 0.0115261, 0.011497, 0.0114669, 0.0114356,
  0.0114033, 0.0113698, 0.0113353, 0.0112997, 0.011263, 0.0112253,
  0.0111864, 0.0111466, 0.0111056, 0.0110636, 0.0110205, 0.0109764,
  0.0109312, 0.010885, 0.0108378, 0.0107895, 0.0107402, 0.0106898,
  0.0106384, 0.0105861, 0.0105327, 0.0104783, 0.0104229, 0.0103665,
  0.0103091, 0.0102507, 0.0101913, 0.010131, 0.0100697, 0.0100074,
  0.0099442, 0.00988003, 0.00981491, 0.00974884, 0.00968185,
  0.00961392, 0.00954508, 0.00947532, 0.00940465, 0.00933309,
  0.00926062, 0.00918727, 0.00911304, 0.00903793, 0.00896196,
  0.00888512, 0.00880744, 0.0087289, 0.00864953, 0.00856933,
  0.00848831, 0.00840647, 0.00832383, 0.00824038, 0.00815614,
  0.00807112, 0.00798532, 0.00789876, 0.00781143, 0.00772336,
  0.00763454, 0.00754498, 0.0074547, 0.00736371, 0.007272, 0.00717959,
  0.0070865, 0.00699272, 0.00689826, 0.00680314, 0.00670737,
  0.00661095, 0.00651389, 0.0064162, 0.0063179, 0.00621898,
  0.00611947, 0.00601936, 0.00591868, 0.00581742, 0.0057156,
  0.00561323, 0.00551032, 0.00540687, 0.0053029, 0.00519842,
  0.00509344, 0.00498796, 0.004882, 0.00477557, 0.00466868,
  0.00456134, 0.00445355, 0.00434533, 0.0042367, 0.00412765,
  0.0040182, 0.00390837, 0.00379815, 0.00368757, 0.00357663,
  0.00346534, 0.00335371, 0.00324176, 0.0031295, 0.00301693,
  0.00290407, 0.00279093, 0.00267752, 0.00256384, 0.00244992,
  0.00233576, 0.00222137, 0.00210677, 0.00199196, 0.00187696,
  0.00176178, 0.00164642, 0.0015309, 0.00141524, 0.00129944,
  0.00118351, 0.00106746, 0.000951313, 0.000835072, 0.000718749,
  0.000602356, 0.000485904, 0.000369405, 0.00025287, 0.00013631,
  1.97368e-05, -9.68383e-05, -0.000213404, -0.000329949, -0.000446461,
  -0.00056293, -0.000679344, -0.000795692, -0.000911962, -0.00102814,
  -0.00114422, -0.00126019, -0.00137604, -0.00149175, -0.00160731,
  -0.00172272, -0.00183795, -0.00195301, -0.00206788, -0.00218254,
  -0.00229699, -0.00241122, -0.0025252, -0.00263894, -0.00275242,
  -0.00286563, -0.00297856, -0.0030912, -0.00320353, -0.00331555,
  -0.00342724, -0.0035386, -0.00364961, -0.00376025, -0.00387053,
  -0.00398043, -0.00408994, -0.00419904, -0.00430773, -0.00441599,
  -0.00452382, -0.0046312, -0.00473813, -0.00484459, -0.00495057,
  -0.00505606, -0.00516106, -0.00526554, -0.0053695, -0.00547294,
  -0.00557583, -0.00567817, -0.00577995, -0.00588116, -0.00598178,
  -0.00608182, -0.00618125, -0.00628007, -0.00637827, -0.00647584,
  -0.00657276, -0.00666904, -0.00676465, -0.00685959, -0.00695385,
  -0.00704742, -0.00714029, -0.00723245, -0.0073239, -0.00741461,
  -0.00750459, -0.00759383, -0.00768231, -0.00777002, -0.00785696,
  -0.00794312, -0.00802849, -0.00811306, -0.00819682, -0.00827977,
  -0.00836189, -0.00844317, -0.00852362, -0.00860321, -0.00868195,
  -0.00875982, -0.00883681, -0.00891292, -0.00898814, -0.00906247,
  -0.00913588, -0.00920839, -0.00927997, -0.00935062, -0.00942034,
  -0.00948912, -0.00955694, -0.00962381, -0.00968972, -0.00975465,
  -0.0098186, -0.00988157, -0.00994355, -0.0100045, -0.0100645,
  -0.0101235, -0.0101814, -0.0102383, -0.0102942, -0.0103491,
  -0.0104029, -0.0104557, -0.0105074, -0.0105581, -0.0106077,
  -0.0106562, -0.0107037, -0.01075, -0.0107953, -0.0108395,
  -0.0108827, -0.0109247, -0.0109656, -0.0110054, -0.0110441,
  -0.0110817, -0.0111181, -0.0111534, -0.0111876, -0.0112207,
  -0.0112526, -0.0112834, -0.0113131, -0.0113416, -0.0113689,
  -0.0113951, -0.0114202, -0.0114441, -0.0114668, -0.0114884,
  -0.0115087, -0.011528, -0.011546, -0.0115629, -0.0115786,
  -0.0115931, -0.0116065, -0.0116186, -0.0116296, -0.0116394,
  -0.011648, -0.0116554, -0.0116616, -0.0116667, -0.0116705,
  -0.0116732, -0.0116746, -0.0116749, -0.011674, -0.0116719,
  -0.0116686, -0.0116641, -0.0116584, -0.0116515, -0.0116434,
  -0.0116341, -0.0116236, -0.0116119, -0.0115991, -0.011585,
  -0.0115698, -0.0115534, -0.0115358, -0.011517, -0.011497,
  -0.0114758, -0.0114535, -0.0114299, -0.0114052, -0.0113794,
  -0.0113523, -0.0113241, -0.0112947, -0.0112641, -0.0112324,
  -0.0111995, -0.0111655, -0.0111303, -0.011094, -0.0110565,
  -0.0110179, -0.0109781, -0.0109372, -0.0108951, -0.010852,
  -0.0108077, -0.0107623, -0.0107157, -0.0106681, -0.0106193,
  -0.0105695, -0.0105185, -0.0104665, -0.0104133, -0.0103591,
  -0.0103038, -0.0102474, -0.01019, -0.0101315, -0.010072, -0.0100113,
  -0.0099497, -0.00988701, -0.00982329, -0.00975854, -0.00969277,
  -0.00962599, -0.0095582, -0.00948942, -0.00941963, -0.00934887,
  -0.00927712, -0.0092044, -0.00913072, -0.00905607, -0.00898048,
  -0.00890395, -0.00882648, -0.00874808, -0.00866876, -0.00858853,
  -0.0085074, -0.00842537, -0.00834246, -0.00825866, -0.008174,
  -0.00808847, -0.00800209, -0.00791487, -0.00782681, -0.00773792,
  -0.00764822, -0.00755771, -0.0074664, -0.00737429, -0.00728141,
  -0.00718776, -0.00709334, -0.00699818, -0.00690227, -0.00680563,
  -0.00670827, -0.00661019, -0.00651141, -0.00641194, -0.00631179,
  -0.00621097, -0.00610949, -0.00600735, -0.00590458, -0.00580118,
  -0.00569716, -0.00559253, -0.0054873, -0.00538149, -0.0052751,
  -0.00516815, -0.00506065, -0.00495261, -0.00484403, -0.00473494,
  -0.00462534, -0.00451525, -0.00440467, -0.00429362, -0.0041821,
  -0.00407014, -0.00395774, -0.00384492, -0.00373168, -0.00361805,
  -0.00350402, -0.00338961, -0.00327484, -0.00315972, -0.00304426,
  -0.00292847, -0.00281236, -0.00269595, -0.00257924, -0.00246226,
  -0.00234501, -0.00222751, -0.00210977, -0.0019918, -0.00187361,
  -0.00175522, -0.00163664, -0.00151788, -0.00139896, -0.00127989,
  -0.00116067, -0.00104133, -0.000921882, -0.000802329, -0.000682688,
  -0.000562974, -0.000443197, -0.000323373, -0.000203513, -8.3631e-05,
  3.62601e-05, 0.000156147, 0.000276017, 0.000395857, 0.000515654,
  0.000635394, 0.000755064, 0.000874652, 0.000994144, 0.00111353,
  0.00123279, 0.00135191, 0.00147089, 0.0015897, 0.00170834,
  0.00182679, 0.00194504, 0.00206308, 0.00218089, 0.00229846,
  0.00241577, 0.00253282, 0.00264959, 0.00276606, 0.00288223,
  0.00299808, 0.0031136, 0.00322878, 0.00334359, 0.00345804,
  0.0035721, 0.00368576, 0.00379902, 0.00391185, 0.00402425,
  0.0041362, 0.00424769, 0.00435871, 0.00446924, 0.00457927,
  0.0046888, 0.0047978, 0.00490626, 0.00501418, 0.00512153,
  0.00522831, 0.00533451, 0.00544011, 0.0055451, 0.00564947,
  0.0057532, 0.00585629, 0.00595872, 0.00606048, 0.00616156,
  0.00626195, 0.00636163, 0.0064606, 0.00655883, 0.00665633,
  0.00675308, 0.00684906, 0.00694428, 0.0070387, 0.00713233,
  0.00722516, 0.00731716, 0.00740834, 0.00749868, 0.00758817,
  0.00767679, 0.00776455, 0.00785142, 0.0079374, 0.00802248,
  0.00810664, 0.00818988, 0.00827219, 0.00835356, 0.00843397,
  0.00851342, 0.0085919, 0.00866939, 0.0087459, 0.0088214, 0.00889589,
  0.00896937, 0.00904182, 0.00911322, 0.00918359, 0.0092529,
  0.00932114, 0.00938832, 0.00945441, 0.00951942, 0.00958333,
  0.00964613, 0.00970783, 0.0097684, 0.00982784, 0.00988615,
  0.00994332, 0.00999933, 0.0100542, 0.0101079, 0.0101604, 0.0102117,
  0.0102619, 0.0103109, 0.0103586, 0.0104052, 0.0104506, 0.0104947,
  0.0105376, 0.0105793, 0.0106198, 0.010659, 0.0106969, 0.0107337,
  0.0107691, 0.0108033, 0.0108363, 0.0108679, 0.0108983, 0.0109274,
  0.0109553, 0.0109818, 0.0110071, 0.011031, 0.0110537, 0.0110751,
  0.0110951, 0.0111139, 0.0111313, 0.0111474, 0.0111622, 0.0111757,
  0.0111879, 0.0111987, 0.0112082, 0.0112164, 0.0112232, 0.0112287,
  0.0112329, 0.0112358, 0.0112373, 0.0112374, 0.0112363, 0.0112338,
  0.0112299, 0.0112247, 0.0112182, 0.0112103, 0.0112011, 0.0111906,
  0.0111787, 0.0111655, 0.0111509, 0.011135, 0.0111177, 0.0110992,
  0.0110792, 0.011058, 0.0110354, 0.0110115, 0.0109862, 0.0109597,
  0.0109318, 0.0109026, 0.010872, 0.0108402, 0.010807, 0.0107725,
  0.0107368, 0.0106997, 0.0106613, 0.0106216, 0.0105806, 0.0105384,
  0.0104948, 0.01045, 0.0104039, 0.0103565, 0.0103079, 0.010258,
  0.0102069, 0.0101545, 0.0101008, 0.0100459, 0.00998981, 0.00993246,
  0.00987389, 0.00981411, 0.00975312, 0.00969093, 0.00962755,
  0.00956297, 0.00949722, 0.00943029, 0.00936219, 0.00929294,
  0.00922254, 0.00915099, 0.00907831, 0.0090045, 0.00892957,
  0.00885353, 0.00877639, 0.00869816, 0.00861884, 0.00853845,
  0.00845699, 0.00837448, 0.00829092, 0.00820632, 0.0081207,
  0.00803406, 0.00794641, 0.00785776, 0.00776812, 0.00767751,
  0.00758594, 0.00749341, 0.00739993, 0.00730552, 0.00721019,
  0.00711395, 0.00701681, 0.00691879, 0.00681988, 0.00672012,
  0.0066195, 0.00651804, 0.00641575, 0.00631265, 0.00620875,
  0.00610405, 0.00599858, 0.00589234, 0.00578535, 0.00567762,
  0.00556916, 0.00546, 0.00535013, 0.00523958, 0.00512835, 0.00501647,
  0.00490394, 0.00479079, 0.00467701, 0.00456264, 0.00444767,
  0.00433214, 0.00421604, 0.0040994, 0.00398222, 0.00386454,
  0.00374635, 0.00362767, 0.00350853, 0.00338893, 0.00326889,
  0.00314842, 0.00302755, 0.00290628, 0.00278463, 0.00266261,
  0.00254025, 0.00241756, 0.00229455, 0.00217124, 0.00204764,
  0.00192378, 0.00179966, 0.00167531, 0.00155073, 0.00142596,
  0.00130099, 0.00117585, 0.00105056, 0.00092513, 0.000799576,
  0.000673916, 0.000548168, 0.000422346, 0.000296468, 0.000170551,
  4.46109e-05, -8.13349e-05, -0.00020727, -0.000333177, -0.00045904,
  -0.000584842, -0.000710565, -0.000836194, -0.00096171, -0.0010871,
  -0.00121234, -0.00133742, -0.00146232, -0.00158702, -0.00171151,
  -0.00183577, -0.00195978, -0.00208352, -0.00220698, -0.00233015,
  -0.002453, -0.00257552, -0.00269768, -0.00281949, -0.0029409,
  -0.00306192, -0.00318252, -0.00330269, -0.0034224, -0.00354165,
  -0.00366042, -0.00377868, -0.00389643, -0.00401364, -0.0041303,
  -0.00424639, -0.0043619, -0.00447681, -0.0045911, -0.00470476,
  -0.00481777, -0.00493012, -0.00504178, -0.00515274, -0.00526299,
  -0.00537251, -0.00548129, -0.0055893, -0.00569653, -0.00580298,
  -0.00590861, -0.00601341, -0.00611738, -0.00622049, -0.00632274,
  -0.00642409, -0.00652455, -0.00662408, -0.00672269, -0.00682035,
  -0.00691706, -0.00701278, -0.00710752, -0.00720125, -0.00729397,
  -0.00738565, -0.00747629, -0.00756586, -0.00765437, -0.00774178,
  -0.00782809, -0.00791329, -0.00799736, -0.00808029, -0.00816206,
  -0.00824267, -0.0083221, -0.00840033, -0.00847736, -0.00855317,
  -0.00862775, -0.00870109, -0.00877318, -0.008844, -0.00891355,
  -0.0089818, -0.00904876, -0.00911441, -0.00917873, -0.00924173,
  -0.00930338, -0.00936367, -0.00942261, -0.00948017, -0.00953634,
  -0.00959113, -0.00964451, -0.00969647, -0.00974702, -0.00979614,
  -0.00984382, -0.00989005, -0.00993482, -0.00997813, -0.01002,
  -0.0100603, -0.0100992, -0.0101366, -0.0101724, -0.0102068,
  -0.0102397, -0.010271, -0.0103008, -0.010329, -0.0103558,
  -0.0103809, -0.0104046, -0.0104266, -0.0104471, -0.010466,
  -0.0104834, -0.0104992, -0.0105134, -0.010526, -0.010537,
  -0.0105465, -0.0105543, -0.0105606, -0.0105652, -0.0105682,
  -0.0105697, -0.0105695, -0.0105677, -0.0105643, -0.0105593,
  -0.0105527, -0.0105444, -0.0105346, -0.0105231, -0.01051,
  -0.0104953, -0.010479, -0.010461, -0.0104415, -0.0104203,
  -0.0103975, -0.0103731, -0.0103471, -0.0103195, -0.0102903,
  -0.0102595, -0.0102271, -0.0101931, -0.0101575, -0.0101203,
  -0.0100815, -0.0100412, -0.00999923, -0.00995572, -0.00991065,
  -0.00986402, -0.00981583, -0.00976609, -0.0097148, -0.00966198,
  -0.00960762, -0.00955174, -0.00949433, -0.00943542, -0.009375,
  -0.00931309, -0.00924969, -0.00918481, -0.00911845, -0.00905064,
  -0.00898137, -0.00891065, -0.0088385, -0.00876493, -0.00868993,
  -0.00861354, -0.00853575, -0.00845657, -0.00837603, -0.00829412,
  -0.00821086, -0.00812626, -0.00804034, -0.0079531, -0.00786457,
  -0.00777474, -0.00768364, -0.00759127, -0.00749766, -0.00740281,
  -0.00730674, -0.00720947, -0.007111, -0.00701136, -0.00691055,
  -0.00680859, -0.0067055, -0.0066013, -0.00649599, -0.0063896,
  -0.00628214, -0.00617363, -0.00606409, -0.00595352, -0.00584196,
  -0.00572941, -0.00561589, -0.00550143, -0.00538604, -0.00526973,
  -0.00515253, -0.00503446, -0.00491553, -0.00479576, -0.00467518,
  -0.0045538, -0.00443163, -0.00430871, -0.00418505, -0.00406067,
  -0.0039356, -0.00380984, -0.00368343, -0.00355638, -0.00342872,
  -0.00330046, -0.00317163, -0.00304225, -0.00291234, -0.00278192,
  -0.00265101, -0.00251965, -0.00238784, -0.00225561, -0.00212299,
  -0.00198999, -0.00185664, -0.00172297, -0.00158899, -0.00145473,
  -0.00132021, -0.00118546, -0.0010505, -0.000915346, -0.000780033,
  -0.000644581, -0.000509014, -0.000373356, -0.00023763, -0.000101862,
  3.39239e-05, 0.000169704, 0.000305454, 0.000441148, 0.000576762,
  0.000712272, 0.000847652, 0.000982878, 0.00111793, 0.00125277,
  0.00138738, 0.00152174, 0.00165582, 0.0017896, 0.00192305,
  0.00205614, 0.00218885, 0.00232116, 0.00245304, 0.00258447,
  0.00271541, 0.00284585, 0.00297576, 0.00310511, 0.00323389,
  0.00336205, 0.00348959, 0.00361647, 0.00374267, 0.00386816,
  0.00399293, 0.00411694, 0.00424016, 0.00436259, 0.00448418,
  0.00460492, 0.00472479, 0.00484374, 0.00496178, 0.00507886,
  0.00519496, 0.00531007, 0.00542415, 0.00553719, 0.00564915,
  0.00576002, 0.00586977, 0.00597838, 0.00608583, 0.00619209,
  0.00629714, 0.00640095, 0.00650352, 0.0066048, 0.00670478,
  0.00680344, 0.00690076, 0.00699671, 0.00709128, 0.00718444,
  0.00727616, 0.00736644, 0.00745525, 0.00754256, 0.00762837,
  0.00771264, 0.00779536, 0.00787651, 0.00795607, 0.00803403,
  0.00811035, 0.00818503, 0.00825804, 0.00832937, 0.008399,
  0.00846692, 0.00853309, 0.00859752, 0.00866018, 0.00872105,
  0.00878012, 0.00883738, 0.0088928, 0.00894638, 0.0089981,
  0.00904794, 0.00909589, 0.00914194, 0.00918608, 0.00922828,
  0.00926854, 0.00930684, 0.00934318, 0.00937754, 0.00940992,
  0.00944029, 0.00946865, 0.00949499, 0.0095193, 0.00954157,
  0.00956179, 0.00957995, 0.00959605, 0.00961008, 0.00962203,
  0.00963189, 0.00963965, 0.00964532, 0.00964889, 0.00965034,
  0.00964968, 0.0096469, 0.00964199, 0.00963497, 0.00962581,
  0.00961452, 0.0096011, 0.00958554, 0.00956785, 0.00954802,
  0.00952605, 0.00950195, 0.00947571, 0.00944734, 0.00941684,
  0.00938421, 0.00934945, 0.00931256, 0.00927356, 0.00923244,
  0.00918921, 0.00914387, 0.00909644, 0.00904691, 0.00899529,
  0.00894159, 0.00888583, 0.00882799, 0.00876811, 0.00870618,
  0.00864221, 0.00857622, 0.00850821, 0.0084382, 0.0083662,
  0.00829222, 0.00821628, 0.00813838, 0.00805855, 0.00797679,
  0.00789313, 0.00780757, 0.00772014, 0.00763084, 0.00753971,
  0.00744674, 0.00735198, 0.00725542, 0.0071571, 0.00705702,
  0.00695522, 0.00685171, 0.00674651, 0.00663965, 0.00653115,
  0.00642103, 0.00630931, 0.00619602, 0.00608118, 0.00596482,
  0.00584696, 0.00572763, 0.00560686, 0.00548467, 0.00536109,
  0.00523614, 0.00510986, 0.00498228, 0.00485342, 0.00472332,
  0.00459199, 0.00445949, 0.00432583, 0.00419104, 0.00405517,
  0.00391824, 0.00378029, 0.00364134, 0.00350144, 0.00336061,
  0.0032189, 0.00307633, 0.00293295, 0.00278879, 0.00264388,
  0.00249826, 0.00235198, 0.00220506, 0.00205754, 0.00190947,
  0.00176088, 0.00161181, 0.0014623, 0.00131239, 0.00116212,
  0.00101153, 0.000860656, 0.000709548, 0.000558244, 0.000406784,
  0.00025521, 0.000103565, -4.81087e-05, -0.000199769, -0.000351373,
  -0.000502878, -0.00065424, -0.000805415, -0.000956361, -0.00110703,
  -0.00125739, -0.00140738, -0.00155696, -0.0017061, -0.00185473,
  -0.00200283, -0.00215034, -0.00229722, -0.00244342, -0.00258891,
  -0.00273362, -0.00287753, -0.00302058, -0.00316272, -0.00330392,
  -0.00344412, -0.00358329, -0.00372137, -0.00385832, -0.0039941,
  -0.00412866, -0.00426195, -0.00439393, -0.00452456, -0.00465379,
  -0.00478157, -0.00490787, -0.00503263, -0.00515582, -0.00527738,
  -0.00539728, -0.00551547, -0.00563191, -0.00574656, -0.00585937,
  -0.0059703, -0.0060793, -0.00618635, -0.00629139, -0.00639438,
  -0.00649529, -0.00659407, -0.00669068, -0.00678509, -0.00687726,
  -0.00696714, -0.0070547, -0.0071399, -0.00722271, -0.00730308,
  -0.00738099, -0.00745639, -0.00752925, -0.00759955, -0.00766723,
  -0.00773228, -0.00779466, -0.00785433, -0.00791128, -0.00796546,
  -0.00801684, -0.00806541, -0.00811113, -0.00815397, -0.00819391,
  -0.00823092, -0.00826499, -0.00829607, -0.00832416, -0.00834922,
  -0.00837125, -0.00839021, -0.0084061, -0.00841888, -0.00842855,
  -0.00843509, -0.00843848, -0.00843871, -0.00843577, -0.00842964,
  -0.00842032, -0.00840779, -0.00839204, -0.00837308, -0.00835088,
  -0.00832545, -0.00829679, -0.00826489, -0.00822974, -0.00819136,
  -0.00814973, -0.00810487, -0.00805678, -0.00800545, -0.00795091,
  -0.00789315, -0.00783219, -0.00776803, -0.00770069, -0.00763018,
  -0.00755652, -0.00747972, -0.0073998, -0.00731678, -0.00723068,
  -0.00714152, -0.00704932, -0.00695411, -0.00685593, -0.00675478,
  -0.00665071, -0.00654375, -0.00643392, -0.00632127, -0.00620583,
  -0.00608763, -0.00596671, -0.00584313, -0.00571691, -0.0055881,
  -0.00545675, -0.00532291, -0.00518662, -0.00504793, -0.0049069,
  -0.00476358, -0.00461802, -0.00447029, -0.00432043, -0.00416852,
  -0.00401461, -0.00385876, -0.00370104, -0.00354152, -0.00338027,
  -0.00321734, -0.00305283, -0.0028868, -0.00271932, -0.00255047,
  -0.00238033, -0.00220897, -0.00203648, -0.00186295, -0.00168845,
  -0.00151306, -0.00133689, -0.00116001, -0.000982508, -0.000804486,
  -0.000626032, -0.000447239, -0.000268203, -8.90202e-05, 9.02113e-05,
  0.000269393, 0.000448424, 0.000627202, 0.000805627, 0.000983593,
  0.001161, 0.00133773, 0.00151369, 0.00168876, 0.00186284,
  0.00203582, 0.00220758, 0.00237802, 0.00254702, 0.00271447,
  0.00288026, 0.00304427, 0.00320639, 0.0033665, 0.00352449,
  0.00368024, 0.00383364, 0.00398456, 0.0041329, 0.00427853,
  0.00442134, 0.00456121, 0.00469803, 0.00483168, 0.00496204,
  0.005089, 0.00521244, 0.00533226, 0.00544832, 0.00556053,
  0.00566877, 0.00577293, 0.00587289, 0.00596856, 0.00605981,
  0.00614656, 0.00622868, 0.00630608, 0.00637865, 0.0064463,
  0.00650893, 0.00656644, 0.00661874, 0.00666574, 0.00670735,
  0.00674349, 0.00677407, 0.00679901, 0.00681823, 0.00683167,
  0.00683924, 0.0068409, 0.00683656, 0.00682618, 0.0068097,
  0.00678707, 0.00675824, 0.00672318, 0.00668183, 0.00663419,
  0.00658021, 0.00651988, 0.00645319, 0.00638012, 0.00630067,
  0.00621485, 0.00612266, 0.00602413, 0.00591927, 0.00580812,
  0.00569072, 0.00556711, 0.00543735, 0.00530151, 0.00515964,
  0.00501184, 0.00485819, 0.00469879, 0.00453375, 0.00436318,
  0.00418723, 0.00400602, 0.00381971, 0.00362846, 0.00343244,
  0.00323184, 0.00302685, 0.00281769, 0.00260457, 0.00238774,
  0.00216744, 0.00194393, 0.0017175, 0.00148844, 0.00125705,
  0.00102367, 0.000788618, 0.000552265, 0.000314978, 7.71497e-05,
  -0.000160814, -0.000398486, -0.000635423, -0.000871162, -0.00110522,
  -0.00133709, -0.00156626, -0.00179217, -0.00201427, -0.00223196,
  -0.00244464, -0.00265167, -0.00285239, -0.00304613, -0.00323219,
  -0.00340982, -0.00357828, -0.00373678, -0.00388451, -0.00402064,
  -0.0041443, -0.0042546, -0.00435061, -0.00443139, -0.00449594,
  -0.00454326, -0.0045723, -0.00458198, -0.00457118, -0.00453876,
  -0.00448353, -0.00440429, -0.00429977, -0.00416869, -0.00400972,
  -0.00382149, -0.00360259, -0.00335159, -0.00306699, -0.00274727,
  -0.00239085, -0.00199612, -0.00156142, -0.00108505, -0.000565256,
  -2.45098e-07}; G4double G4NeutronHPFastLegendre::l17[3601] = {-1,
  -0.916778, -0.837046, -0.760708, -0.687669, -0.617836, -0.551119,
  -0.487428, -0.426676, -0.368778, -0.313651, -0.261212, -0.211382,
  -0.164082, -0.119236, -0.0767687, -0.0366065, 0.00132215, 0.0370875,
  0.0707583, 0.102402, 0.132083, 0.159867, 0.185816, 0.209992,
  0.232454, 0.253261, 0.272471, 0.290139, 0.306319, 0.321066,
  0.334431, 0.346465, 0.357218, 0.366738, 0.375073, 0.382268,
  0.388369, 0.393419, 0.397462, 0.400538, 0.40269, 0.403956, 0.404374,
  0.403984, 0.402821, 0.400921, 0.398319, 0.395049, 0.391144,
  0.386636, 0.381555, 0.375933, 0.369799, 0.363181, 0.356108,
  0.348606, 0.340703, 0.332422, 0.32379, 0.314831, 0.305567, 0.296021,
  0.286216, 0.276173, 0.265912, 0.255453, 0.244816, 0.234019,
  0.223081, 0.212019, 0.20085, 0.189591, 0.178257, 0.166863, 0.155425,
  0.143956, 0.132471, 0.120982, 0.109502, 0.0980438, 0.0866188,
  0.0752382, 0.0639131, 0.0526538, 0.0414703, 0.0303722, 0.0193688,
  0.00846862, -0.00231977, -0.0129884, -0.0235297, -0.0339363,
  -0.0442014, -0.0543183, -0.0642809, -0.0740832, -0.0837197,
  -0.093185, -0.102474, -0.111583, -0.120506, -0.12924, -0.137782,
  -0.146126, -0.154271, -0.162213, -0.169949, -0.177476, -0.184794,
  -0.191898, -0.198788, -0.205462, -0.211918, -0.218155, -0.224172,
  -0.229969, -0.235544, -0.240897, -0.246027, -0.250935, -0.255621,
  -0.260085, -0.264326, -0.268346, -0.272145, -0.275724, -0.279084,
  -0.282225, -0.285149, -0.287857, -0.290351, -0.292632, -0.294701,
  -0.296561, -0.298213, -0.299658, -0.300899, -0.301939, -0.302778,
  -0.30342, -0.303866, -0.304119, -0.304182, -0.304057, -0.303746,
  -0.303252, -0.302578, -0.301727, -0.300701, -0.299503, -0.298137,
  -0.296604, -0.294908, -0.293053, -0.29104, -0.288873, -0.286556,
  -0.284091, -0.281481, -0.278731, -0.275841, -0.272817, -0.269662,
  -0.266378, -0.262968, -0.259437, -0.255787, -0.252021, -0.248144,
  -0.244157, -0.240066, -0.235871, -0.231578, -0.227189, -0.222708,
  -0.218138, -0.213481, -0.208742, -0.203924, -0.199029, -0.194062,
  -0.189024, -0.18392, -0.178753, -0.173525, -0.168241, -0.162902,
  -0.157512, -0.152074, -0.146591, -0.141067, -0.135503, -0.129904,
  -0.124271, -0.118609, -0.112919, -0.107205, -0.101469, -0.0957145,
  -0.089944, -0.0841603, -0.0783659, -0.0725636, -0.066756,
  -0.0609457, -0.0551352, -0.049327, -0.0435237, -0.0377277,
  -0.0319414, -0.0261672, -0.0204074, -0.0146644, -0.00894035,
  -0.00323755, 0.00244183, 0.00809562, 0.0137217, 0.019318, 0.0248826,
  0.0304133, 0.0359082, 0.0413654, 0.0467831, 0.0521593, 0.0574923,
  0.0627803, 0.0680216, 0.0732145, 0.0783573, 0.0834485, 0.0884864,
  0.0934696, 0.0983965, 0.103266, 0.108076, 0.112825, 0.117513,
  0.122138, 0.126698, 0.131193, 0.135621, 0.139981, 0.144272,
  0.148493, 0.152643, 0.15672, 0.160725, 0.164656, 0.168512, 0.172292,
  0.175995, 0.179622, 0.18317, 0.18664, 0.19003, 0.19334, 0.19657,
  0.199718, 0.202785, 0.205769, 0.208671, 0.21149, 0.214226, 0.216877,
  0.219445, 0.221928, 0.224326, 0.226639, 0.228867, 0.23101, 0.233067,
  0.235039, 0.236925, 0.238726, 0.24044, 0.242069, 0.243612, 0.24507,
  0.246442, 0.247728, 0.248929, 0.250045, 0.251076, 0.252022,
  0.252884, 0.253661, 0.254355, 0.254965, 0.255491, 0.255935,
  0.256296, 0.256574, 0.256771, 0.256887, 0.256922, 0.256876,
  0.256751, 0.256546, 0.256262, 0.2559, 0.255461, 0.254944, 0.254351,
  0.253683, 0.252939, 0.252121, 0.251228, 0.250263, 0.249226,
  0.248116, 0.246936, 0.245686, 0.244366, 0.242978, 0.241522,
  0.239999, 0.23841, 0.236756, 0.235037, 0.233255, 0.23141, 0.229503,
  0.227535, 0.225507, 0.22342, 0.221275, 0.219073, 0.216814, 0.2145,
  0.212131, 0.209709, 0.207234, 0.204708, 0.202131, 0.199505, 0.19683,
  0.194107, 0.191338, 0.188523, 0.185664, 0.182761, 0.179816,
  0.176829, 0.173802, 0.170735, 0.167629, 0.164487, 0.161308,
  0.158093, 0.154845, 0.151563, 0.148249, 0.144903, 0.141528,
  0.138123, 0.134691, 0.131231, 0.127746, 0.124235, 0.120701,
  0.117144, 0.113565, 0.109965, 0.106345, 0.102707, 0.0990506,
  0.0953779, 0.0916894, 0.0879863, 0.0842696, 0.0805402, 0.0767992,
  0.0730475, 0.0692862, 0.0655162, 0.0617385, 0.0579542, 0.0541641,
  0.0503693, 0.0465707, 0.0427693, 0.038966, 0.0351618, 0.0313576,
  0.0275543, 0.0237529, 0.0199543, 0.0161594, 0.0123691, 0.00858436,
  0.00480598, 0.00103488, -0.00272806, -0.00648197, -0.010226,
  -0.0139593, -0.017681, -0.0213903, -0.0250863, -0.0287683,
  -0.0324354, -0.0360868, -0.0397217, -0.0433394, -0.0469391,
  -0.0505199, -0.0540812, -0.0576222, -0.0611422, -0.0646404,
  -0.0681162, -0.0715687, -0.0749974, -0.0784015, -0.0817803,
  -0.0851332, -0.0884595, -0.0917585, -0.0950297, -0.0982724,
  -0.101486, -0.10467, -0.107823, -0.110946, -0.114037, -0.117096,
  -0.120123, -0.123116, -0.126076, -0.129001, -0.131892, -0.134747,
  -0.137567, -0.14035, -0.143097, -0.145807, -0.148479, -0.151113,
  -0.153708, -0.156265, -0.158783, -0.16126, -0.163698, -0.166096,
  -0.168452, -0.170767, -0.173041, -0.175274, -0.177464, -0.179611,
  -0.181716, -0.183778, -0.185796, -0.187771, -0.189702, -0.191589,
  -0.193432, -0.19523, -0.196983, -0.198692, -0.200355, -0.201973,
  -0.203546, -0.205073, -0.206554, -0.207989, -0.209378, -0.210721,
  -0.212018, -0.213268, -0.214472, -0.215629, -0.216739, -0.217803,
  -0.21882, -0.21979, -0.220714, -0.22159, -0.22242, -0.223203,
  -0.223939, -0.224628, -0.22527, -0.225866, -0.226414, -0.226917,
  -0.227372, -0.227781, -0.228143, -0.228459, -0.228729, -0.228953,
  -0.22913, -0.229261, -0.229347, -0.229387, -0.229381, -0.229331,
  -0.229234, -0.229093, -0.228907, -0.228676, -0.228401, -0.228081,
  -0.227718, -0.22731, -0.226859, -0.226364, -0.225826, -0.225246,
  -0.224622, -0.223956, -0.223248, -0.222498, -0.221707, -0.220874,
  -0.22, -0.219086, -0.218131, -0.217136, -0.216101, -0.215026,
  -0.213913, -0.21276, -0.211569, -0.210341, -0.209074, -0.20777,
  -0.206428, -0.20505, -0.203636, -0.202186, -0.2007, -0.199179,
  -0.197623, -0.196033, -0.194409, -0.192751, -0.19106, -0.189336,
  -0.18758, -0.185792, -0.183973, -0.182122, -0.180241, -0.178329,
  -0.176388, -0.174417, -0.172418, -0.17039, -0.168334, -0.16625,
  -0.16414, -0.162002, -0.159839, -0.15765, -0.155435, -0.153196,
  -0.150933, -0.148646, -0.146335, -0.144002, -0.141646, -0.139268,
  -0.136869, -0.134449, -0.132009, -0.129548, -0.127068, -0.124569,
  -0.122052, -0.119517, -0.116964, -0.114394, -0.111808, -0.109206,
  -0.106588, -0.103955, -0.101308, -0.0986465, -0.0959718, -0.093284,
  -0.0905837, -0.0878714, -0.0851477, -0.0824129, -0.0796676,
  -0.0769124, -0.0741476, -0.0713738, -0.0685915, -0.0658012,
  -0.0630034, -0.0601986, -0.0573873, -0.05457, -0.0517471,
  -0.0489192, -0.0460867, -0.0432502, -0.0404101, -0.0375669,
  -0.0347212, -0.0318733, -0.0290238, -0.0261732, -0.0233219,
  -0.0204704, -0.0176192, -0.0147688, -0.0119196, -0.00907211,
  -0.0062268, -0.00338413, -0.000544558, 0.00229145, 0.00512343,
  0.00795093, 0.0107735, 0.0135907, 0.016402, 0.0192071, 0.0220054,
  0.0247966, 0.0275802, 0.0303557, 0.0331227, 0.0358809, 0.0386297,
  0.0413688, 0.0440977, 0.0468161, 0.0495234, 0.0522193, 0.0549034,
  0.0575753, 0.0602346, 0.0628808, 0.0655137, 0.0681327, 0.0707376,
  0.0733279, 0.0759032, 0.0784633, 0.0810076, 0.0835359, 0.0860478,
  0.0885428, 0.0910208, 0.0934813, 0.0959239, 0.0983483, 0.100754,
  0.103141, 0.105509, 0.107858, 0.110186, 0.112495, 0.114783, 0.11705,
  0.119296, 0.12152, 0.123723, 0.125904, 0.128063, 0.130199, 0.132313,
  0.134403, 0.13647, 0.138513, 0.140533, 0.142528, 0.144499, 0.146445,
  0.148366, 0.150262, 0.152133, 0.153978, 0.155798, 0.157591,
  0.159358, 0.161098, 0.162812, 0.164499, 0.166159, 0.167792,
  0.169397, 0.170974, 0.172524, 0.174046, 0.17554, 0.177005, 0.178442,
  0.17985, 0.181229, 0.182579, 0.183901, 0.185193, 0.186456, 0.187689,
  0.188893, 0.190067, 0.191211, 0.192326, 0.19341, 0.194464, 0.195488,
  0.196482, 0.197445, 0.198378, 0.199281, 0.200153, 0.200994,
  0.201804, 0.202584, 0.203333, 0.204051, 0.204738, 0.205394,
  0.206019, 0.206613, 0.207176, 0.207708, 0.208209, 0.208679,
  0.209118, 0.209526, 0.209902, 0.210248, 0.210563, 0.210846,
  0.211099, 0.21132, 0.211511, 0.211671, 0.2118, 0.211898, 0.211965,
  0.212002, 0.212008, 0.211983, 0.211927, 0.211842, 0.211725,
  0.211579, 0.211402, 0.211195, 0.210958, 0.210691, 0.210394,
  0.210068, 0.209711, 0.209326, 0.20891, 0.208466, 0.207992, 0.207489,
  0.206957, 0.206396, 0.205806, 0.205188, 0.204542, 0.203867,
  0.203164, 0.202433, 0.201674, 0.200888, 0.200074, 0.199232,
  0.198364, 0.197469, 0.196546, 0.195597, 0.194622, 0.19362, 0.192593,
  0.191539, 0.19046, 0.189355, 0.188225, 0.18707, 0.18589, 0.184685,
  0.183455, 0.182202, 0.180924, 0.179623, 0.178298, 0.176949,
  0.175578, 0.174183, 0.172766, 0.171326, 0.169865, 0.168381,
  0.166875, 0.165348, 0.1638, 0.16223, 0.16064, 0.15903, 0.157399,
  0.155748, 0.154078, 0.152388, 0.150678, 0.14895, 0.147203, 0.145438,
  0.143655, 0.141854, 0.140035, 0.138198, 0.136345, 0.134475,
  0.132589, 0.130686, 0.128768, 0.126833, 0.124884, 0.122919, 0.12094,
  0.118946, 0.116938, 0.114916, 0.11288, 0.110831, 0.108769, 0.106694,
  0.104607, 0.102508, 0.100396, 0.0982736, 0.0961396, 0.0939946,
  0.091839, 0.089673, 0.087497, 0.0853112, 0.083116, 0.0809116,
  0.0786984, 0.0764767, 0.0742467, 0.0720088, 0.0697633, 0.0675104,
  0.0652506, 0.062984, 0.0607111, 0.058432, 0.0561472, 0.0538569,
  0.0515614, 0.049261, 0.0469561, 0.0446469, 0.0423337, 0.0400169,
  0.0376968, 0.0353736, 0.0330477, 0.0307193, 0.0283888, 0.0260565,
  0.0237226, 0.0213875, 0.0190515, 0.0167149, 0.0143779, 0.012041,
  0.00970427, 0.00736814, 0.00503288, 0.00269878, 0.000366149,
  -0.00196473, -0.00429356, -0.00662004, -0.0089439, -0.0112648,
  -0.0135825, -0.0158968, -0.0182072, -0.0205135, -0.0228155,
  -0.0251128, -0.0274052, -0.0296924, -0.0319741, -0.0342501,
  -0.03652, -0.0387835, -0.0410405, -0.0432906, -0.0455335,
  -0.0477691, -0.0499969, -0.0522168, -0.0544285, -0.0566317,
  -0.0588262, -0.0610116, -0.0631878, -0.0653545, -0.0675114,
  -0.0696583, -0.0717948, -0.0739209, -0.0760362, -0.0781404,
  -0.0802333, -0.0823148, -0.0843845, -0.0864422, -0.0884876,
  -0.0905206, -0.0925409, -0.0945482, -0.0965424, -0.0985232,
  -0.10049, -0.102444, -0.104383, -0.106308, -0.108219, -0.110114,
  -0.111995, -0.113861, -0.115712, -0.117546, -0.119366, -0.121169,
  -0.122956, -0.124727, -0.126481, -0.128218, -0.129939, -0.131642,
  -0.133329, -0.134997, -0.136649, -0.138282, -0.139897, -0.141494,
  -0.143073, -0.144634, -0.146175, -0.147698, -0.149202, -0.150687,
  -0.152152, -0.153599, -0.155025, -0.156432, -0.157819, -0.159186,
  -0.160532, -0.161859, -0.163165, -0.16445, -0.165715, -0.166959,
  -0.168182, -0.169384, -0.170565, -0.171725, -0.172863, -0.17398,
  -0.175075, -0.176149, -0.1772, -0.17823, -0.179238, -0.180224,
  -0.181188, -0.182129, -0.183048, -0.183945, -0.184819, -0.18567,
  -0.186499, -0.187306, -0.188089, -0.18885, -0.189588, -0.190302,
  -0.190994, -0.191663, -0.192308, -0.192931, -0.19353, -0.194106,
  -0.194659, -0.195188, -0.195695, -0.196177, -0.196637, -0.197072,
  -0.197485, -0.197874, -0.198239, -0.198581, -0.1989, -0.199194,
  -0.199466, -0.199714, -0.199938, -0.200139, -0.200316, -0.20047,
  -0.2006, -0.200707, -0.20079, -0.20085, -0.200886, -0.200899,
  -0.200889, -0.200855, -0.200798, -0.200717, -0.200613, -0.200487,
  -0.200336, -0.200163, -0.199967, -0.199748, -0.199505, -0.19924,
  -0.198952, -0.198641, -0.198307, -0.197951, -0.197572, -0.197171,
  -0.196747, -0.1963, -0.195831, -0.19534, -0.194827, -0.194292,
  -0.193735, -0.193156, -0.192555, -0.191932, -0.191288, -0.190622,
  -0.189935, -0.189226, -0.188496, -0.187746, -0.186974, -0.186181,
  -0.185367, -0.184533, -0.183678, -0.182803, -0.181907, -0.180992,
  -0.180056, -0.1791, -0.178125, -0.177129, -0.176115, -0.17508,
  -0.174027, -0.172954, -0.171863, -0.170753, -0.169623, -0.168476,
  -0.16731, -0.166126, -0.164923, -0.163703, -0.162465, -0.161209,
  -0.159936, -0.158645, -0.157338, -0.156013, -0.154671, -0.153313,
  -0.151939, -0.150548, -0.149141, -0.147718, -0.146279, -0.144824,
  -0.143354, -0.141869, -0.140369, -0.138854, -0.137324, -0.13578,
  -0.134221, -0.132648, -0.131061, -0.129461, -0.127847, -0.126219,
  -0.124578, -0.122924, -0.121258, -0.119579, -0.117887, -0.116183,
  -0.114467, -0.112739, -0.111, -0.109249, -0.107487, -0.105714,
  -0.103931, -0.102136, -0.100332, -0.0985168, -0.0966919, -0.0948572,
  -0.0930131, -0.0911595, -0.0892969, -0.0874253, -0.0855451,
  -0.0836563, -0.0817593, -0.0798542, -0.0779413, -0.0760207,
  -0.0740928, -0.0721576, -0.0702155, -0.0682666, -0.0663112,
  -0.0643494, -0.0623815, -0.0604078, -0.0584284, -0.0564436,
  -0.0544535, -0.0524584, -0.0504586, -0.0484541, -0.0464454,
  -0.0444325, -0.0424157, -0.0403953, -0.0383714, -0.0363443,
  -0.0343141, -0.0322812, -0.0302457, -0.0282078, -0.0261679,
  -0.024126, -0.0220824, -0.0200374, -0.0179911, -0.0159439,
  -0.0138958, -0.0118471, -0.00979812, -0.00774897, -0.00569991,
  -0.00365115, -0.00160291, 0.00044459, 0.00249113, 0.00453649,
  0.00658046, 0.00862282, 0.0106634, 0.0127018, 0.0147381, 0.0167718,
  0.0188029, 0.020831, 0.0228561, 0.0248778, 0.0268959, 0.0289103,
  0.0309208, 0.032927, 0.0349289, 0.0369262, 0.0389187, 0.0409062,
  0.0428884, 0.0448653, 0.0468365, 0.0488019, 0.0507612, 0.0527143,
  0.054661, 0.056601, 0.0585342, 0.0604604, 0.0623793, 0.0642908,
  0.0661947, 0.0680907, 0.0699788, 0.0718586, 0.07373, 0.0755929,
  0.077447, 0.0792921, 0.081128, 0.0829546, 0.0847717, 0.0865791,
  0.0883766, 0.0901641, 0.0919413, 0.0937081, 0.0954642, 0.0972096,
  0.0989441, 0.100667, 0.102379, 0.10408, 0.105769, 0.107446,
  0.109111, 0.110764, 0.112405, 0.114033, 0.115649, 0.117252,
  0.118842, 0.120419, 0.121982, 0.123532, 0.125069, 0.126592,
  0.128101, 0.129596, 0.131077, 0.132544, 0.133996, 0.135434,
  0.136857, 0.138266, 0.139659, 0.141037, 0.1424, 0.143747, 0.14508,
  0.146396, 0.147697, 0.148982, 0.150251, 0.151503, 0.15274, 0.15396,
  0.155164, 0.156351, 0.157522, 0.158675, 0.159812, 0.160932,
  0.162035, 0.163121, 0.164189, 0.16524, 0.166273, 0.167289, 0.168287,
  0.169268, 0.17023, 0.171175, 0.172101, 0.17301, 0.1739, 0.174772,
  0.175626, 0.176461, 0.177278, 0.178076, 0.178856, 0.179617,
  0.180359, 0.181082, 0.181787, 0.182472, 0.183139, 0.183786,
  0.184414, 0.185024, 0.185614, 0.186184, 0.186736, 0.187268,
  0.187781, 0.188274, 0.188748, 0.189202, 0.189637, 0.190052,
  0.190448, 0.190824, 0.191181, 0.191517, 0.191834, 0.192132, 0.19241,
  0.192668, 0.192906, 0.193124, 0.193323, 0.193502, 0.193661, 0.1938,
  0.19392, 0.19402, 0.1941, 0.19416, 0.1942, 0.194221, 0.194222,
  0.194203, 0.194164, 0.194106, 0.194028, 0.193931, 0.193813,
  0.193677, 0.19352, 0.193344, 0.193149, 0.192933, 0.192699, 0.192445,
  0.192172, 0.191879, 0.191567, 0.191235, 0.190885, 0.190515,
  0.190126, 0.189718, 0.189291, 0.188845, 0.18838, 0.187897, 0.187394,
  0.186873, 0.186333, 0.185774, 0.185197, 0.184601, 0.183987,
  0.183355, 0.182704, 0.182036, 0.181349, 0.180644, 0.179921, 0.17918,
  0.178421, 0.177645, 0.176851, 0.17604, 0.175211, 0.174365, 0.173502,
  0.172621, 0.171724, 0.170809, 0.169878, 0.16893, 0.167965, 0.166984,
  0.165986, 0.164972, 0.163942, 0.162895, 0.161833, 0.160755,
  0.159661, 0.158551, 0.157426, 0.156285, 0.15513, 0.153959, 0.152772,
  0.151572, 0.150356, 0.149125, 0.147881, 0.146621, 0.145348, 0.14406,
  0.142758, 0.141443, 0.140114, 0.138771, 0.137415, 0.136045,
  0.134662, 0.133267, 0.131858, 0.130437, 0.129003, 0.127556,
  0.126098, 0.124627, 0.123144, 0.12165, 0.120143, 0.118626, 0.117096,
  0.115556, 0.114005, 0.112442, 0.110869, 0.109286, 0.107692,
  0.106088, 0.104473, 0.102849, 0.101215, 0.0995711, 0.097918,
  0.0962557, 0.0945842, 0.0929038, 0.0912147, 0.0895169, 0.0878108,
  0.0860964, 0.0843739, 0.0826435, 0.0809054, 0.0791597, 0.0774066,
  0.0756463, 0.073879, 0.0721048, 0.0703239, 0.0685366, 0.0667429,
  0.064943, 0.0631372, 0.0613256, 0.0595084, 0.0576858, 0.0558578,
  0.0540249, 0.052187, 0.0503444, 0.0484973, 0.0466459, 0.0447903,
  0.0429307, 0.0410673, 0.0392003, 0.0373299, 0.0354562, 0.0335794,
  0.0316998, 0.0298175, 0.0279326, 0.0260455, 0.0241561, 0.0222649,
  0.0203718, 0.0184772, 0.0165812, 0.0146839, 0.0127856, 0.0108865,
  0.00898664, 0.00708635, 0.00518576, 0.00328505, 0.00138441,
  -0.000515968, -0.00241591, -0.00431523, -0.00621374, -0.00811126,
  -0.0100076, -0.0119026, -0.0137961, -0.0156878, -0.0175776,
  -0.0194653, -0.0213508, -0.0232338, -0.0251142, -0.0269918,
  -0.0288664, -0.0307378, -0.0326059, -0.0344704, -0.0363312,
  -0.0381882, -0.040041, -0.0418897, -0.0437339, -0.0455735,
  -0.0474083, -0.0492382, -0.051063, -0.0528825, -0.0546965,
  -0.0565049, -0.0583074, -0.060104, -0.0618944, -0.0636785,
  -0.0654562, -0.0672271, -0.0689912, -0.0707483, -0.0724983,
  -0.0742409, -0.075976, -0.0777034, -0.0794231, -0.0811347,
  -0.0828382, -0.0845334, -0.0862201, -0.0878982, -0.0895676,
  -0.0912279, -0.0928792, -0.0945212, -0.0961538, -0.0977769,
  -0.0993902, -0.100994, -0.102587, -0.10417, -0.105743, -0.107306,
  -0.108858, -0.110399, -0.111929, -0.113448, -0.114956, -0.116453,
  -0.117938, -0.119412, -0.120874, -0.122324, -0.123762, -0.125188,
  -0.126601, -0.128002, -0.129391, -0.130767, -0.13213, -0.133481,
  -0.134818, -0.136142, -0.137453, -0.13875, -0.140034, -0.141304,
  -0.14256, -0.143803, -0.145031, -0.146246, -0.147446, -0.148632,
  -0.149803, -0.15096, -0.152102, -0.153229, -0.154342, -0.15544,
  -0.156522, -0.157589, -0.158642, -0.159678, -0.1607, -0.161705,
  -0.162695, -0.16367, -0.164628, -0.165571, -0.166498, -0.167408,
  -0.168303, -0.169181, -0.170043, -0.170888, -0.171717, -0.17253,
  -0.173326, -0.174105, -0.174867, -0.175613, -0.176341, -0.177053,
  -0.177748, -0.178425, -0.179086, -0.179729, -0.180355, -0.180964,
  -0.181555, -0.182129, -0.182686, -0.183225, -0.183746, -0.18425,
  -0.184736, -0.185204, -0.185655, -0.186088, -0.186503, -0.1869,
  -0.187279, -0.187641, -0.187984, -0.18831, -0.188618, -0.188907,
  -0.189179, -0.189432, -0.189667, -0.189884, -0.190084, -0.190264,
  -0.190427, -0.190572, -0.190698, -0.190807, -0.190897, -0.190969,
  -0.191022, -0.191058, -0.191075, -0.191074, -0.191055, -0.191018,
  -0.190963, -0.190889, -0.190797, -0.190687, -0.190559, -0.190413,
  -0.190249, -0.190067, -0.189866, -0.189648, -0.189411, -0.189157,
  -0.188884, -0.188594, -0.188286, -0.18796, -0.187616, -0.187254,
  -0.186875, -0.186477, -0.186062, -0.18563, -0.18518, -0.184712,
  -0.184227, -0.183724, -0.183204, -0.182667, -0.182112, -0.18154,
  -0.180951, -0.180345, -0.179722, -0.179081, -0.178424, -0.17775,
  -0.177059, -0.176351, -0.175627, -0.174886, -0.174128, -0.173354,
  -0.172564, -0.171757, -0.170934, -0.170095, -0.16924, -0.168369,
  -0.167482, -0.166579, -0.16566, -0.164726, -0.163776, -0.162811,
  -0.161831, -0.160835, -0.159824, -0.158798, -0.157756, -0.1567,
  -0.15563, -0.154544, -0.153444, -0.15233, -0.151201, -0.150058,
  -0.148901, -0.147729, -0.146544, -0.145345, -0.144133, -0.142906,
  -0.141667, -0.140414, -0.139147, -0.137868, -0.136575, -0.13527,
  -0.133952, -0.132622, -0.131279, -0.129923, -0.128556, -0.127176,
  -0.125784, -0.12438, -0.122965, -0.121538, -0.1201, -0.118651,
  -0.11719, -0.115718, -0.114236, -0.112742, -0.111238, -0.109724,
  -0.108199, -0.106664, -0.105119, -0.103564, -0.102, -0.100426,
  -0.098842, -0.0972492, -0.0956472, -0.0940362, -0.0924163,
  -0.0907878, -0.0891508, -0.0875053, -0.0858517, -0.08419,
  -0.0825204, -0.080843, -0.079158, -0.0774656, -0.075766, -0.0740592,
  -0.0723454, -0.0706249, -0.0688977, -0.0671641, -0.0654242,
  -0.0636781, -0.061926, -0.0601681, -0.0584046, -0.0566356,
  -0.0548613, -0.0530818, -0.0512973, -0.0495081, -0.0477141,
  -0.0459157, -0.044113, -0.0423062, -0.0404954, -0.0386808,
  -0.0368625, -0.0350408, -0.0332158, -0.0313877, -0.0295566,
  -0.0277228, -0.0258864, -0.0240475, -0.0222064, -0.0203632,
  -0.0185181, -0.0166712, -0.0148228, -0.012973, -0.011122,
  -0.0092699, -0.00741697, -0.00556333, -0.00370918, -0.00185468, 0,
  0.00185468, 0.00370918, 0.00556333, 0.00741697, 0.0092699, 0.011122,
  0.012973, 0.0148228, 0.0166712, 0.0185181, 0.0203632, 0.0222064,
  0.0240475, 0.0258864, 0.0277228, 0.0295566, 0.0313877, 0.0332158,
  0.0350408, 0.0368625, 0.0386808, 0.0404954, 0.0423062, 0.044113,
  0.0459157, 0.0477141, 0.0495081, 0.0512973, 0.0530818, 0.0548613,
  0.0566356, 0.0584046, 0.0601681, 0.061926, 0.0636781, 0.0654242,
  0.0671641, 0.0688977, 0.0706249, 0.0723454, 0.0740592, 0.075766,
  0.0774656, 0.079158, 0.080843, 0.0825204, 0.08419, 0.0858517,
  0.0875053, 0.0891508, 0.0907878, 0.0924163, 0.0940362, 0.0956472,
  0.0972492, 0.098842, 0.100426, 0.102, 0.103564, 0.105119, 0.106664,
  0.108199, 0.109724, 0.111238, 0.112742, 0.114236, 0.115718, 0.11719,
  0.118651, 0.1201, 0.121538, 0.122965, 0.12438, 0.125784, 0.127176,
  0.128556, 0.129923, 0.131279, 0.132622, 0.133952, 0.13527, 0.136575,
  0.137868, 0.139147, 0.140414, 0.141667, 0.142906, 0.144133,
  0.145345, 0.146544, 0.147729, 0.148901, 0.150058, 0.151201, 0.15233,
  0.153444, 0.154544, 0.15563, 0.1567, 0.157756, 0.158798, 0.159824,
  0.160835, 0.161831, 0.162811, 0.163776, 0.164726, 0.16566, 0.166579,
  0.167482, 0.168369, 0.16924, 0.170095, 0.170934, 0.171757, 0.172564,
  0.173354, 0.174128, 0.174886, 0.175627, 0.176351, 0.177059, 0.17775,
  0.178424, 0.179081, 0.179722, 0.180345, 0.180951, 0.18154, 0.182112,
  0.182667, 0.183204, 0.183724, 0.184227, 0.184712, 0.18518, 0.18563,
  0.186062, 0.186477, 0.186875, 0.187254, 0.187616, 0.18796, 0.188286,
  0.188594, 0.188884, 0.189157, 0.189411, 0.189648, 0.189866,
  0.190067, 0.190249, 0.190413, 0.190559, 0.190687, 0.190797,
  0.190889, 0.190963, 0.191018, 0.191055, 0.191074, 0.191075,
  0.191058, 0.191022, 0.190969, 0.190897, 0.190807, 0.190698,
  0.190572, 0.190427, 0.190264, 0.190084, 0.189884, 0.189667,
  0.189432, 0.189179, 0.188907, 0.188618, 0.18831, 0.187984, 0.187641,
  0.187279, 0.1869, 0.186503, 0.186088, 0.185655, 0.185204, 0.184736,
  0.18425, 0.183746, 0.183225, 0.182686, 0.182129, 0.181555, 0.180964,
  0.180355, 0.179729, 0.179086, 0.178425, 0.177748, 0.177053,
  0.176341, 0.175613, 0.174867, 0.174105, 0.173326, 0.17253, 0.171717,
  0.170888, 0.170043, 0.169181, 0.168303, 0.167408, 0.166498,
  0.165571, 0.164628, 0.16367, 0.162695, 0.161705, 0.1607, 0.159678,
  0.158642, 0.157589, 0.156522, 0.15544, 0.154342, 0.153229, 0.152102,
  0.15096, 0.149803, 0.148632, 0.147446, 0.146246, 0.145031, 0.143803,
  0.14256, 0.141304, 0.140034, 0.13875, 0.137453, 0.136142, 0.134818,
  0.133481, 0.13213, 0.130767, 0.129391, 0.128002, 0.126601, 0.125188,
  0.123762, 0.122324, 0.120874, 0.119412, 0.117938, 0.116453,
  0.114956, 0.113448, 0.111929, 0.110399, 0.108858, 0.107306,
  0.105743, 0.10417, 0.102587, 0.100994, 0.0993902, 0.0977769,
  0.0961538, 0.0945212, 0.0928792, 0.0912279, 0.0895676, 0.0878982,
  0.0862201, 0.0845334, 0.0828382, 0.0811347, 0.0794231, 0.0777034,
  0.075976, 0.0742409, 0.0724983, 0.0707483, 0.0689912, 0.0672271,
  0.0654562, 0.0636785, 0.0618944, 0.060104, 0.0583074, 0.0565049,
  0.0546965, 0.0528825, 0.051063, 0.0492382, 0.0474083, 0.0455735,
  0.0437339, 0.0418897, 0.040041, 0.0381882, 0.0363312, 0.0344704,
  0.0326059, 0.0307378, 0.0288664, 0.0269918, 0.0251142, 0.0232338,
  0.0213508, 0.0194653, 0.0175776, 0.0156878, 0.0137961, 0.0119026,
  0.0100076, 0.00811126, 0.00621374, 0.00431523, 0.00241591,
  0.000515968, -0.00138441, -0.00328505, -0.00518576, -0.00708635,
  -0.00898664, -0.0108865, -0.0127856, -0.0146839, -0.0165812,
  -0.0184772, -0.0203718, -0.0222649, -0.0241561, -0.0260455,
  -0.0279326, -0.0298175, -0.0316998, -0.0335794, -0.0354562,
  -0.0373299, -0.0392003, -0.0410673, -0.0429307, -0.0447903,
  -0.0466459, -0.0484973, -0.0503444, -0.052187, -0.0540249,
  -0.0558578, -0.0576858, -0.0595084, -0.0613256, -0.0631372,
  -0.064943, -0.0667429, -0.0685366, -0.0703239, -0.0721048,
  -0.073879, -0.0756463, -0.0774066, -0.0791597, -0.0809054,
  -0.0826435, -0.0843739, -0.0860964, -0.0878108, -0.0895169,
  -0.0912147, -0.0929038, -0.0945842, -0.0962557, -0.097918,
  -0.0995711, -0.101215, -0.102849, -0.104473, -0.106088, -0.107692,
  -0.109286, -0.110869, -0.112442, -0.114005, -0.115556, -0.117096,
  -0.118626, -0.120143, -0.12165, -0.123144, -0.124627, -0.126098,
  -0.127556, -0.129003, -0.130437, -0.131858, -0.133267, -0.134662,
  -0.136045, -0.137415, -0.138771, -0.140114, -0.141443, -0.142758,
  -0.14406, -0.145348, -0.146621, -0.147881, -0.149125, -0.150356,
  -0.151572, -0.152772, -0.153959, -0.15513, -0.156285, -0.157426,
  -0.158551, -0.159661, -0.160755, -0.161833, -0.162895, -0.163942,
  -0.164972, -0.165986, -0.166984, -0.167965, -0.16893, -0.169878,
  -0.170809, -0.171724, -0.172621, -0.173502, -0.174365, -0.175211,
  -0.17604, -0.176851, -0.177645, -0.178421, -0.17918, -0.179921,
  -0.180644, -0.181349, -0.182036, -0.182704, -0.183355, -0.183987,
  -0.184601, -0.185197, -0.185774, -0.186333, -0.186873, -0.187394,
  -0.187897, -0.18838, -0.188845, -0.189291, -0.189718, -0.190126,
  -0.190515, -0.190885, -0.191235, -0.191567, -0.191879, -0.192172,
  -0.192445, -0.192699, -0.192933, -0.193149, -0.193344, -0.19352,
  -0.193677, -0.193813, -0.193931, -0.194028, -0.194106, -0.194164,
  -0.194203, -0.194222, -0.194221, -0.1942, -0.19416, -0.1941,
  -0.19402, -0.19392, -0.1938, -0.193661, -0.193502, -0.193323,
  -0.193124, -0.192906, -0.192668, -0.19241, -0.192132, -0.191834,
  -0.191517, -0.191181, -0.190824, -0.190448, -0.190052, -0.189637,
  -0.189202, -0.188748, -0.188274, -0.187781, -0.187268, -0.186736,
  -0.186184, -0.185614, -0.185024, -0.184414, -0.183786, -0.183139,
  -0.182472, -0.181787, -0.181082, -0.180359, -0.179617, -0.178856,
  -0.178076, -0.177278, -0.176461, -0.175626, -0.174772, -0.1739,
  -0.17301, -0.172101, -0.171175, -0.17023, -0.169268, -0.168287,
  -0.167289, -0.166273, -0.16524, -0.164189, -0.163121, -0.162035,
  -0.160932, -0.159812, -0.158675, -0.157522, -0.156351, -0.155164,
  -0.15396, -0.15274, -0.151503, -0.150251, -0.148982, -0.147697,
  -0.146396, -0.14508, -0.143747, -0.1424, -0.141037, -0.139659,
  -0.138266, -0.136857, -0.135434, -0.133996, -0.132544, -0.131077,
  -0.129596, -0.128101, -0.126592, -0.125069, -0.123532, -0.121982,
  -0.120419, -0.118842, -0.117252, -0.115649, -0.114033, -0.112405,
  -0.110764, -0.109111, -0.107446, -0.105769, -0.10408, -0.102379,
  -0.100667, -0.0989441, -0.0972096, -0.0954642, -0.0937081,
  -0.0919413, -0.0901641, -0.0883766, -0.0865791, -0.0847717,
  -0.0829546, -0.081128, -0.0792921, -0.077447, -0.0755929, -0.07373,
  -0.0718586, -0.0699788, -0.0680907, -0.0661947, -0.0642908,
  -0.0623793, -0.0604604, -0.0585342, -0.056601, -0.054661,
  -0.0527143, -0.0507612, -0.0488019, -0.0468365, -0.0448653,
  -0.0428884, -0.0409062, -0.0389187, -0.0369262, -0.0349289,
  -0.032927, -0.0309208, -0.0289103, -0.0268959, -0.0248778,
  -0.0228561, -0.020831, -0.0188029, -0.0167718, -0.0147381,
  -0.0127018, -0.0106634, -0.00862282, -0.00658046, -0.00453649,
  -0.00249113, -0.00044459, 0.00160291, 0.00365115, 0.00569991,
  0.00774897, 0.00979812, 0.0118471, 0.0138958, 0.0159439, 0.0179911,
  0.0200374, 0.0220824, 0.024126, 0.0261679, 0.0282078, 0.0302457,
  0.0322812, 0.0343141, 0.0363443, 0.0383714, 0.0403953, 0.0424157,
  0.0444325, 0.0464454, 0.0484541, 0.0504586, 0.0524584, 0.0544535,
  0.0564436, 0.0584284, 0.0604078, 0.0623815, 0.0643494, 0.0663112,
  0.0682666, 0.0702155, 0.0721576, 0.0740928, 0.0760207, 0.0779413,
  0.0798542, 0.0817593, 0.0836563, 0.0855451, 0.0874253, 0.0892969,
  0.0911595, 0.0930131, 0.0948572, 0.0966919, 0.0985168, 0.100332,
  0.102136, 0.103931, 0.105714, 0.107487, 0.109249, 0.111, 0.112739,
  0.114467, 0.116183, 0.117887, 0.119579, 0.121258, 0.122924,
  0.124578, 0.126219, 0.127847, 0.129461, 0.131061, 0.132648,
  0.134221, 0.13578, 0.137324, 0.138854, 0.140369, 0.141869, 0.143354,
  0.144824, 0.146279, 0.147718, 0.149141, 0.150548, 0.151939,
  0.153313, 0.154671, 0.156013, 0.157338, 0.158645, 0.159936,
  0.161209, 0.162465, 0.163703, 0.164923, 0.166126, 0.16731, 0.168476,
  0.169623, 0.170753, 0.171863, 0.172954, 0.174027, 0.17508, 0.176115,
  0.177129, 0.178125, 0.1791, 0.180056, 0.180992, 0.181907, 0.182803,
  0.183678, 0.184533, 0.185367, 0.186181, 0.186974, 0.187746,
  0.188496, 0.189226, 0.189935, 0.190622, 0.191288, 0.191932,
  0.192555, 0.193156, 0.193735, 0.194292, 0.194827, 0.19534, 0.195831,
  0.1963, 0.196747, 0.197171, 0.197572, 0.197951, 0.198307, 0.198641,
  0.198952, 0.19924, 0.199505, 0.199748, 0.199967, 0.200163, 0.200336,
  0.200487, 0.200613, 0.200717, 0.200798, 0.200855, 0.200889,
  0.200899, 0.200886, 0.20085, 0.20079, 0.200707, 0.2006, 0.20047,
  0.200316, 0.200139, 0.199938, 0.199714, 0.199466, 0.199194, 0.1989,
  0.198581, 0.198239, 0.197874, 0.197485, 0.197072, 0.196637,
  0.196177, 0.195695, 0.195188, 0.194659, 0.194106, 0.19353, 0.192931,
  0.192308, 0.191663, 0.190994, 0.190302, 0.189588, 0.18885, 0.188089,
  0.187306, 0.186499, 0.18567, 0.184819, 0.183945, 0.183048, 0.182129,
  0.181188, 0.180224, 0.179238, 0.17823, 0.1772, 0.176149, 0.175075,
  0.17398, 0.172863, 0.171725, 0.170565, 0.169384, 0.168182, 0.166959,
  0.165715, 0.16445, 0.163165, 0.161859, 0.160532, 0.159186, 0.157819,
  0.156432, 0.155025, 0.153599, 0.152152, 0.150687, 0.149202,
  0.147698, 0.146175, 0.144634, 0.143073, 0.141494, 0.139897,
  0.138282, 0.136649, 0.134997, 0.133329, 0.131642, 0.129939,
  0.128218, 0.126481, 0.124727, 0.122956, 0.121169, 0.119366,
  0.117546, 0.115712, 0.113861, 0.111995, 0.110114, 0.108219,
  0.106308, 0.104383, 0.102444, 0.10049, 0.0985232, 0.0965424,
  0.0945482, 0.0925409, 0.0905206, 0.0884876, 0.0864422, 0.0843845,
  0.0823148, 0.0802333, 0.0781404, 0.0760362, 0.0739209, 0.0717948,
  0.0696583, 0.0675114, 0.0653545, 0.0631878, 0.0610116, 0.0588262,
  0.0566317, 0.0544285, 0.0522168, 0.0499969, 0.0477691, 0.0455335,
  0.0432906, 0.0410405, 0.0387835, 0.03652, 0.0342501, 0.0319741,
  0.0296924, 0.0274052, 0.0251128, 0.0228155, 0.0205135, 0.0182072,
  0.0158968, 0.0135825, 0.0112648, 0.0089439, 0.00662004, 0.00429356,
  0.00196473, -0.000366149, -0.00269878, -0.00503288, -0.00736814,
  -0.00970427, -0.012041, -0.0143779, -0.0167149, -0.0190515,
  -0.0213875, -0.0237226, -0.0260565, -0.0283888, -0.0307193,
  -0.0330477, -0.0353736, -0.0376968, -0.0400169, -0.0423337,
  -0.0446469, -0.0469561, -0.049261, -0.0515614, -0.0538569,
  -0.0561472, -0.058432, -0.0607111, -0.062984, -0.0652506,
  -0.0675104, -0.0697633, -0.0720088, -0.0742467, -0.0764767,
  -0.0786984, -0.0809116, -0.083116, -0.0853112, -0.087497, -0.089673,
  -0.091839, -0.0939946, -0.0961396, -0.0982736, -0.100396, -0.102508,
  -0.104607, -0.106694, -0.108769, -0.110831, -0.11288, -0.114916,
  -0.116938, -0.118946, -0.12094, -0.122919, -0.124884, -0.126833,
  -0.128768, -0.130686, -0.132589, -0.134475, -0.136345, -0.138198,
  -0.140035, -0.141854, -0.143655, -0.145438, -0.147203, -0.14895,
  -0.150678, -0.152388, -0.154078, -0.155748, -0.157399, -0.15903,
  -0.16064, -0.16223, -0.1638, -0.165348, -0.166875, -0.168381,
  -0.169865, -0.171326, -0.172766, -0.174183, -0.175578, -0.176949,
  -0.178298, -0.179623, -0.180924, -0.182202, -0.183455, -0.184685,
  -0.18589, -0.18707, -0.188225, -0.189355, -0.19046, -0.191539,
  -0.192593, -0.19362, -0.194622, -0.195597, -0.196546, -0.197469,
  -0.198364, -0.199232, -0.200074, -0.200888, -0.201674, -0.202433,
  -0.203164, -0.203867, -0.204542, -0.205188, -0.205806, -0.206396,
  -0.206957, -0.207489, -0.207992, -0.208466, -0.20891, -0.209326,
  -0.209711, -0.210068, -0.210394, -0.210691, -0.210958, -0.211195,
  -0.211402, -0.211579, -0.211725, -0.211842, -0.211927, -0.211983,
  -0.212008, -0.212002, -0.211965, -0.211898, -0.2118, -0.211671,
  -0.211511, -0.21132, -0.211099, -0.210846, -0.210563, -0.210248,
  -0.209902, -0.209526, -0.209118, -0.208679, -0.208209, -0.207708,
  -0.207176, -0.206613, -0.206019, -0.205394, -0.204738, -0.204051,
  -0.203333, -0.202584, -0.201804, -0.200994, -0.200153, -0.199281,
  -0.198378, -0.197445, -0.196482, -0.195488, -0.194464, -0.19341,
  -0.192326, -0.191211, -0.190067, -0.188893, -0.187689, -0.186456,
  -0.185193, -0.183901, -0.182579, -0.181229, -0.17985, -0.178442,
  -0.177005, -0.17554, -0.174046, -0.172524, -0.170974, -0.169397,
  -0.167792, -0.166159, -0.164499, -0.162812, -0.161098, -0.159358,
  -0.157591, -0.155798, -0.153978, -0.152133, -0.150262, -0.148366,
  -0.146445, -0.144499, -0.142528, -0.140533, -0.138513, -0.13647,
  -0.134403, -0.132313, -0.130199, -0.128063, -0.125904, -0.123723,
  -0.12152, -0.119296, -0.11705, -0.114783, -0.112495, -0.110186,
  -0.107858, -0.105509, -0.103141, -0.100754, -0.0983483, -0.0959239,
  -0.0934813, -0.0910208, -0.0885428, -0.0860478, -0.0835359,
  -0.0810076, -0.0784633, -0.0759032, -0.0733279, -0.0707376,
  -0.0681327, -0.0655137, -0.0628808, -0.0602346, -0.0575753,
  -0.0549034, -0.0522193, -0.0495234, -0.0468161, -0.0440977,
  -0.0413688, -0.0386297, -0.0358809, -0.0331227, -0.0303557,
  -0.0275802, -0.0247966, -0.0220054, -0.0192071, -0.016402,
  -0.0135907, -0.0107735, -0.00795093, -0.00512343, -0.00229145,
  0.000544558, 0.00338413, 0.0062268, 0.00907211, 0.0119196,
  0.0147688, 0.0176192, 0.0204704, 0.0233219, 0.0261732, 0.0290238,
  0.0318733, 0.0347212, 0.0375669, 0.0404101, 0.0432502, 0.0460867,
  0.0489192, 0.0517471, 0.05457, 0.0573873, 0.0601986, 0.0630034,
  0.0658012, 0.0685915, 0.0713738, 0.0741476, 0.0769124, 0.0796676,
  0.0824129, 0.0851477, 0.0878714, 0.0905837, 0.093284, 0.0959718,
  0.0986465, 0.101308, 0.103955, 0.106588, 0.109206, 0.111808,
  0.114394, 0.116964, 0.119517, 0.122052, 0.124569, 0.127068,
  0.129548, 0.132009, 0.134449, 0.136869, 0.139268, 0.141646,
  0.144002, 0.146335, 0.148646, 0.150933, 0.153196, 0.155435, 0.15765,
  0.159839, 0.162002, 0.16414, 0.16625, 0.168334, 0.17039, 0.172418,
  0.174417, 0.176388, 0.178329, 0.180241, 0.182122, 0.183973,
  0.185792, 0.18758, 0.189336, 0.19106, 0.192751, 0.194409, 0.196033,
  0.197623, 0.199179, 0.2007, 0.202186, 0.203636, 0.20505, 0.206428,
  0.20777, 0.209074, 0.210341, 0.211569, 0.21276, 0.213913, 0.215026,
  0.216101, 0.217136, 0.218131, 0.219086, 0.22, 0.220874, 0.221707,
  0.222498, 0.223248, 0.223956, 0.224622, 0.225246, 0.225826,
  0.226364, 0.226859, 0.22731, 0.227718, 0.228081, 0.228401, 0.228676,
  0.228907, 0.229093, 0.229234, 0.229331, 0.229381, 0.229387,
  0.229347, 0.229261, 0.22913, 0.228953, 0.228729, 0.228459, 0.228143,
  0.227781, 0.227372, 0.226917, 0.226414, 0.225866, 0.22527, 0.224628,
  0.223939, 0.223203, 0.22242, 0.22159, 0.220714, 0.21979, 0.21882,
  0.217803, 0.216739, 0.215629, 0.214472, 0.213268, 0.212018,
  0.210721, 0.209378, 0.207989, 0.206554, 0.205073, 0.203546,
  0.201973, 0.200355, 0.198692, 0.196983, 0.19523, 0.193432, 0.191589,
  0.189702, 0.187771, 0.185796, 0.183778, 0.181716, 0.179611,
  0.177464, 0.175274, 0.173041, 0.170767, 0.168452, 0.166096,
  0.163698, 0.16126, 0.158783, 0.156265, 0.153708, 0.151113, 0.148479,
  0.145807, 0.143097, 0.14035, 0.137567, 0.134747, 0.131892, 0.129001,
  0.126076, 0.123116, 0.120123, 0.117096, 0.114037, 0.110946,
  0.107823, 0.10467, 0.101486, 0.0982724, 0.0950297, 0.0917585,
  0.0884595, 0.0851332, 0.0817803, 0.0784015, 0.0749974, 0.0715687,
  0.0681162, 0.0646404, 0.0611422, 0.0576222, 0.0540812, 0.0505199,
  0.0469391, 0.0433394, 0.0397217, 0.0360868, 0.0324354, 0.0287683,
  0.0250863, 0.0213903, 0.017681, 0.0139593, 0.010226, 0.00648197,
  0.00272806, -0.00103488, -0.00480598, -0.00858436, -0.0123691,
  -0.0161594, -0.0199543, -0.0237529, -0.0275543, -0.0313576,
  -0.0351618, -0.038966, -0.0427693, -0.0465707, -0.0503693,
  -0.0541641, -0.0579542, -0.0617385, -0.0655162, -0.0692862,
  -0.0730475, -0.0767992, -0.0805402, -0.0842696, -0.0879863,
  -0.0916894, -0.0953779, -0.0990506, -0.102707, -0.106345, -0.109965,
  -0.113565, -0.117144, -0.120701, -0.124235, -0.127746, -0.131231,
  -0.134691, -0.138123, -0.141528, -0.144903, -0.148249, -0.151563,
  -0.154845, -0.158093, -0.161308, -0.164487, -0.167629, -0.170735,
  -0.173802, -0.176829, -0.179816, -0.182761, -0.185664, -0.188523,
  -0.191338, -0.194107, -0.19683, -0.199505, -0.202131, -0.204708,
  -0.207234, -0.209709, -0.212131, -0.2145, -0.216814, -0.219073,
  -0.221275, -0.22342, -0.225507, -0.227535, -0.229503, -0.23141,
  -0.233255, -0.235037, -0.236756, -0.23841, -0.239999, -0.241522,
  -0.242978, -0.244366, -0.245686, -0.246936, -0.248116, -0.249226,
  -0.250263, -0.251228, -0.252121, -0.252939, -0.253683, -0.254351,
  -0.254944, -0.255461, -0.2559, -0.256262, -0.256546, -0.256751,
  -0.256876, -0.256922, -0.256887, -0.256771, -0.256574, -0.256296,
  -0.255935, -0.255491, -0.254965, -0.254355, -0.253661, -0.252884,
  -0.252022, -0.251076, -0.250045, -0.248929, -0.247728, -0.246442,
  -0.24507, -0.243612, -0.242069, -0.24044, -0.238726, -0.236925,
  -0.235039, -0.233067, -0.23101, -0.228867, -0.226639, -0.224326,
  -0.221928, -0.219445, -0.216877, -0.214226, -0.21149, -0.208671,
  -0.205769, -0.202785, -0.199718, -0.19657, -0.19334, -0.19003,
  -0.18664, -0.18317, -0.179622, -0.175995, -0.172292, -0.168512,
  -0.164656, -0.160725, -0.15672, -0.152643, -0.148493, -0.144272,
  -0.139981, -0.135621, -0.131193, -0.126698, -0.122138, -0.117513,
  -0.112825, -0.108076, -0.103266, -0.0983965, -0.0934696, -0.0884864,
  -0.0834485, -0.0783573, -0.0732145, -0.0680216, -0.0627803,
  -0.0574923, -0.0521593, -0.0467831, -0.0413654, -0.0359082,
  -0.0304133, -0.0248826, -0.019318, -0.0137217, -0.00809562,
  -0.00244183, 0.00323755, 0.00894035, 0.0146644, 0.0204074,
  0.0261672, 0.0319414, 0.0377277, 0.0435237, 0.049327, 0.0551352,
  0.0609457, 0.066756, 0.0725636, 0.0783659, 0.0841603, 0.089944,
  0.0957145, 0.101469, 0.107205, 0.112919, 0.118609, 0.124271,
  0.129904, 0.135503, 0.141067, 0.146591, 0.152074, 0.157512,
  0.162902, 0.168241, 0.173525, 0.178753, 0.18392, 0.189024, 0.194062,
  0.199029, 0.203924, 0.208742, 0.213481, 0.218138, 0.222708,
  0.227189, 0.231578, 0.235871, 0.240066, 0.244157, 0.248144,
  0.252021, 0.255787, 0.259437, 0.262968, 0.266378, 0.269662,
  0.272817, 0.275841, 0.278731, 0.281481, 0.284091, 0.286556,
  0.288873, 0.29104, 0.293053, 0.294908, 0.296604, 0.298137, 0.299503,
  0.300701, 0.301727, 0.302578, 0.303252, 0.303746, 0.304057,
  0.304182, 0.304119, 0.303866, 0.30342, 0.302778, 0.301939, 0.300899,
  0.299658, 0.298213, 0.296561, 0.294701, 0.292632, 0.290351,
  0.287857, 0.285149, 0.282225, 0.279084, 0.275724, 0.272145,
  0.268346, 0.264326, 0.260085, 0.255621, 0.250935, 0.246027,
  0.240897, 0.235544, 0.229969, 0.224172, 0.218155, 0.211918,
  0.205462, 0.198788, 0.191898, 0.184794, 0.177476, 0.169949,
  0.162213, 0.154271, 0.146126, 0.137782, 0.12924, 0.120506, 0.111583,
  0.102474, 0.093185, 0.0837197, 0.0740832, 0.0642809, 0.0543183,
  0.0442014, 0.0339363, 0.0235297, 0.0129884, 0.00231977, -0.00846862,
  -0.0193688, -0.0303722, -0.0414703, -0.0526538, -0.0639131,
  -0.0752382, -0.0866188, -0.0980438, -0.109502, -0.120982, -0.132471,
  -0.143956, -0.155425, -0.166863, -0.178257, -0.189591, -0.20085,
  -0.212019, -0.223081, -0.234019, -0.244816, -0.255453, -0.265912,
  -0.276173, -0.286216, -0.296021, -0.305567, -0.314831, -0.32379,
  -0.332422, -0.340703, -0.348606, -0.356108, -0.363181, -0.369799,
  -0.375933, -0.381555, -0.386636, -0.391144, -0.395049, -0.398319,
  -0.400921, -0.402821, -0.403984, -0.404374, -0.403956, -0.40269,
  -0.400538, -0.397462, -0.393419, -0.388369, -0.382268, -0.375073,
  -0.366738, -0.357218, -0.346465, -0.334431, -0.321066, -0.306319,
  -0.290139, -0.272471, -0.253261, -0.232454, -0.209992, -0.185816,
  -0.159867, -0.132083, -0.102402, -0.0707583, -0.0370875,
  -0.00132215, 0.0366065, 0.0767687, 0.119236, 0.164082, 0.211382,
  0.261212, 0.313651, 0.368778, 0.426676, 0.487428, 0.551119,
  0.617836, 0.687669, 0.760708, 0.837046, 0.916778, 1}; G4double
  G4NeutronHPFastLegendre::i17[3601] = {0, -0.000532269, -0.00101928,
  -0.00146294, -0.00186511, -0.0022276, -0.00255216, -0.00284051,
  -0.00309429, -0.00331511, -0.00350454, -0.0036641, -0.00379526,
  -0.00389943, -0.00397802, -0.00403235, -0.00406374, -0.00407343,
  -0.00406266, -0.00403261, -0.00398441, -0.00391918, -0.003838,
  -0.00374189, -0.00363186, -0.00350888, -0.00337388, -0.00322777,
  -0.00307141, -0.00290566, -0.00273132, -0.00254917, -0.00235997,
  -0.00216444, -0.00196329, -0.00175717, -0.00154675, -0.00133263,
  -0.00111542, -0.000895682, -0.00067397, -0.000450808, -0.000226698,
  -2.12281e-06, 0.000222459, 0.000446608, 0.000669904, 0.000891948,
  0.00111236, 0.00133078, 0.00154685, 0.00176027, 0.00197071,
  0.00217788, 0.0023815, 0.00258133, 0.0027771, 0.0029686, 0.00315559,
  0.00333789, 0.0035153, 0.00368765, 0.00385477, 0.00401651,
  0.00417274, 0.00432333, 0.00446816, 0.00460713, 0.00474015,
  0.00486713, 0.004988, 0.00510269, 0.00521115, 0.00531333, 0.0054092,
  0.00549872, 0.00558189, 0.00565867, 0.00572908, 0.0057931,
  0.00585075, 0.00590204, 0.005947, 0.00598565, 0.00601803,
  0.00604417, 0.00606412, 0.00607793, 0.00608566, 0.00608736,
  0.0060831, 0.00607295, 0.00605699, 0.00603527, 0.0060079,
  0.00597495, 0.00593651, 0.00589266, 0.00584351, 0.00578916,
  0.00572969, 0.00566521, 0.00559583, 0.00552164, 0.00544277,
  0.00535932, 0.0052714, 0.00517912, 0.0050826, 0.00498196,
  0.00487732, 0.00476878, 0.00465648, 0.00454053, 0.00442105,
  0.00429818, 0.00417201, 0.00404269, 0.00391034, 0.00377507,
  0.00363702, 0.0034963, 0.00335303, 0.00320735, 0.00305938,
  0.00290923, 0.00275703, 0.00260291, 0.00244698, 0.00228937,
  0.00213019, 0.00196957, 0.00180762, 0.00164446, 0.00148021,
  0.00131498, 0.0011489, 0.000982067, 0.000814602, 0.000646616,
  0.000478218, 0.000309518, 0.000140624, -2.83578e-05, -0.000197322,
  -0.000366165, -0.000534784, -0.000703079, -0.00087095, -0.0010383,
  -0.00120503, -0.00137105, -0.00153626, -0.00170058, -0.00186391,
  -0.00202617, -0.00218726, -0.00234711, -0.00250563, -0.00266274,
  -0.00281836, -0.00297242, -0.00312483, -0.00327552, -0.00342443,
  -0.00357147, -0.00371659, -0.00385972, -0.00400078, -0.00413972,
  -0.00427647, -0.00441099, -0.0045432, -0.00467305, -0.00480049,
  -0.00492546, -0.00504792, -0.00516782, -0.00528511, -0.00539974,
  -0.00551168, -0.00562087, -0.00572729, -0.00583089, -0.00593163,
  -0.00602949, -0.00612443, -0.00621642, -0.00630542, -0.00639142,
  -0.00647439, -0.00655429, -0.00663112, -0.00670484, -0.00677545,
  -0.00684292, -0.00690723, -0.00696838, -0.00702634, -0.00708112,
  -0.00713269, -0.00718105, -0.0072262, -0.00726813, -0.00730683,
  -0.0073423, -0.00737454, -0.00740356, -0.00742935, -0.00745192,
  -0.00747127, -0.00748741, -0.00750035, -0.00751009, -0.00751665,
  -0.00752003, -0.00752025, -0.00751732, -0.00751126, -0.00750208,
  -0.0074898, -0.00747444, -0.00745601, -0.00743455, -0.00741006,
  -0.00738257, -0.00735211, -0.0073187, -0.00728237, -0.00724313,
  -0.00720103, -0.00715608, -0.00710832, -0.00705777, -0.00700447,
  -0.00694845, -0.00688974, -0.00682838, -0.00676439, -0.00669782,
  -0.00662869, -0.00655705, -0.00648294, -0.00640638, -0.00632741,
  -0.00624609, -0.00616244, -0.0060765, -0.00598831, -0.00589793,
  -0.00580538, -0.00571071, -0.00561396, -0.00551517, -0.00541439,
  -0.00531166, -0.00520703, -0.00510053, -0.00499222, -0.00488214,
  -0.00477033, -0.00465684, -0.00454171, -0.00442499, -0.00430674,
  -0.00418698, -0.00406578, -0.00394317, -0.0038192, -0.00369393,
  -0.0035674, -0.00343965, -0.00331074, -0.0031807, -0.0030496,
  -0.00291747, -0.00278436, -0.00265033, -0.00251541, -0.00237966,
  -0.00224313, -0.00210585, -0.00196789, -0.00182928, -0.00169008,
  -0.00155032, -0.00141007, -0.00126936, -0.00112824, -0.000986756,
  -0.000844959, -0.000702892, -0.000560602, -0.000418134,
  -0.000275534, -0.000132848, 9.88078e-06, 0.000152606, 0.000295284,
  0.00043787, 0.000580321, 0.000722592, 0.00086464, 0.00100642,
  0.0011479, 0.00128902, 0.00142975, 0.00157005, 0.00170987,
  0.00184918, 0.00198793, 0.00212609, 0.0022636, 0.00240045,
  0.00253658, 0.00267195, 0.00280654, 0.0029403, 0.00307319,
  0.00320519, 0.00333624, 0.00346633, 0.0035954, 0.00372344,
  0.0038504, 0.00397624, 0.00410095, 0.00422448, 0.0043468,
  0.00446788, 0.00458769, 0.00470621, 0.00482339, 0.00493921,
  0.00505364, 0.00516665, 0.00527822, 0.00538831, 0.00549691,
  0.00560398, 0.0057095, 0.00581344, 0.00591578, 0.0060165,
  0.00611557, 0.00621297, 0.00630868, 0.00640267, 0.00649492,
  0.00658542, 0.00667415, 0.00676108, 0.00684619, 0.00692947,
  0.00701091, 0.00709047, 0.00716816, 0.00724394, 0.00731781,
  0.00738975, 0.00745974, 0.00752778, 0.00759385, 0.00765794,
  0.00772003, 0.00778012, 0.00783819, 0.00789423, 0.00794824,
  0.0080002, 0.00805011, 0.00809796, 0.00814374, 0.00818745,
  0.00822908, 0.00826861, 0.00830606, 0.00834141, 0.00837466,
  0.0084058, 0.00843484, 0.00846176, 0.00848658, 0.00850929,
  0.00852988, 0.00854835, 0.00856472, 0.00857897, 0.00859111,
  0.00860114, 0.00860907, 0.00861489, 0.00861861, 0.00862023,
  0.00861976, 0.0086172, 0.00861256, 0.00860584, 0.00859705,
  0.0085862, 0.00857328, 0.00855832, 0.00854132, 0.00852229,
  0.00850123, 0.00847816, 0.00845308, 0.008426, 0.00839695,
  0.00836592, 0.00833293, 0.00829799, 0.00826111, 0.00822231,
  0.00818159, 0.00813898, 0.00809448, 0.00804812, 0.0079999,
  0.00794983, 0.00789795, 0.00784425, 0.00778876, 0.00773149,
  0.00767247, 0.0076117, 0.0075492, 0.00748499, 0.0074191, 0.00735153,
  0.00728231, 0.00721145, 0.00713898, 0.00706491, 0.00698927,
  0.00691207, 0.00683333, 0.00675308, 0.00667133, 0.00658811,
  0.00650343, 0.00641733, 0.00632981, 0.00624091, 0.00615064,
  0.00605903, 0.0059661, 0.00587187, 0.00577637, 0.00567961,
  0.00558162, 0.00548244, 0.00538206, 0.00528054, 0.00517788,
  0.0050741, 0.00496925, 0.00486333, 0.00475638, 0.00464842,
  0.00453947, 0.00442955, 0.00431871, 0.00420695, 0.0040943,
  0.00398079, 0.00386645, 0.0037513, 0.00363536, 0.00351866,
  0.00340123, 0.00328309, 0.00316428, 0.0030448, 0.0029247,
  0.00280399, 0.0026827, 0.00256086, 0.0024385, 0.00231563, 0.0021923,
  0.00206851, 0.0019443, 0.0018197, 0.00169472, 0.00156941,
  0.00144377, 0.00131784, 0.00119165, 0.00106521, 0.000938567,
  0.000811731, 0.000684732, 0.000557596, 0.000430349, 0.000303016,
  0.000175622, 4.81937e-05, -7.92442e-05, -0.000206666, -0.000334048,
  -0.000461363, -0.000588587, -0.000715696, -0.000842664,
  -0.000969467, -0.00109608, -0.00122248, -0.00134864, -0.00147454,
  -0.00160015, -0.00172545, -0.00185041, -0.00197502, -0.00209924,
  -0.00222306, -0.00234646, -0.0024694, -0.00259186, -0.00271383,
  -0.00283529, -0.00295619, -0.00307654, -0.0031963, -0.00331545,
  -0.00343397, -0.00355184, -0.00366904, -0.00378555, -0.00390134,
  -0.0040164, -0.0041307, -0.00424422, -0.00435695, -0.00446887,
  -0.00457995, -0.00469017, -0.00479952, -0.00490798, -0.00501553,
  -0.00512214, -0.00522781, -0.00533251, -0.00543623, -0.00553894,
  -0.00564064, -0.00574129, -0.0058409, -0.00593943, -0.00603688,
  -0.00613322, -0.00622845, -0.00632254, -0.00641548, -0.00650726,
  -0.00659785, -0.00668726, -0.00677545, -0.00686242, -0.00694815,
  -0.00703263, -0.00711585, -0.00719779, -0.00727844, -0.00735779,
  -0.00743582, -0.00751253, -0.00758789, -0.00766191, -0.00773456,
  -0.00780585, -0.00787575, -0.00794425, -0.00801136, -0.00807705,
  -0.00814131, -0.00820415, -0.00826554, -0.00832549, -0.00838397,
  -0.00844099, -0.00849653, -0.00855059, -0.00860317, -0.00865424,
  -0.00870381, -0.00875187, -0.00879842, -0.00884344, -0.00888694,
  -0.0089289, -0.00896932, -0.0090082, -0.00904553, -0.00908131,
  -0.00911553, -0.0091482, -0.0091793, -0.00920883, -0.00923679,
  -0.00926318, -0.009288, -0.00931124, -0.0093329, -0.00935298,
  -0.00937148, -0.00938839, -0.00940373, -0.00941748, -0.00942964,
  -0.00944022, -0.00944922, -0.00945663, -0.00946246, -0.00946671,
  -0.00946938, -0.00947047, -0.00946999, -0.00946793, -0.00946429,
  -0.00945909, -0.00945232, -0.00944399, -0.0094341, -0.00942265,
  -0.00940965, -0.0093951, -0.00937901, -0.00936138, -0.00934221,
  -0.00932151, -0.00929929, -0.00927555, -0.00925029, -0.00922353,
  -0.00919527, -0.00916551, -0.00913427, -0.00910154, -0.00906734,
  -0.00903168, -0.00899455, -0.00895598, -0.00891596, -0.0088745,
  -0.00883162, -0.00878732, -0.00874162, -0.00869451, -0.00864601,
  -0.00859613, -0.00854488, -0.00849227, -0.0084383, -0.00838299,
  -0.00832636, -0.0082684, -0.00820913, -0.00814856, -0.0080867,
  -0.00802357, -0.00795917, -0.00789352, -0.00782662, -0.0077585,
  -0.00768916, -0.00761861, -0.00754687, -0.00747395, -0.00739986,
  -0.00732461, -0.00724823, -0.00717071, -0.00709208, -0.00701235,
  -0.00693153, -0.00684964, -0.00676669, -0.00668269, -0.00659766,
  -0.00651161, -0.00642455, -0.00633651, -0.00624749, -0.00615752,
  -0.0060666, -0.00597474, -0.00588198, -0.00578831, -0.00569377,
  -0.00559835, -0.00550208, -0.00540497, -0.00530704, -0.0052083,
  -0.00510877, -0.00500847, -0.00490741, -0.00480561, -0.00470309,
  -0.00459985, -0.00449592, -0.00439131, -0.00428604, -0.00418013,
  -0.00407359, -0.00396644, -0.0038587, -0.00375037, -0.00364149,
  -0.00353207, -0.00342211, -0.00331165, -0.0032007, -0.00308927,
  -0.00297738, -0.00286504, -0.00275229, -0.00263913, -0.00252557,
  -0.00241164, -0.00229736, -0.00218274, -0.0020678, -0.00195255,
  -0.00183702, -0.00172121, -0.00160516, -0.00148887, -0.00137236,
  -0.00125565, -0.00113875, -0.00102169, -0.000904485, -0.000787145,
  -0.00066969, -0.000552138, -0.000434506, -0.00031681, -0.000199069,
  -8.12991e-05, 3.64827e-05, 0.000154259, 0.000272013, 0.000389729,
  0.000507388, 0.000624974, 0.00074247, 0.000859859, 0.000977126,
  0.00109425, 0.00121122, 0.00132802, 0.00144463, 0.00156103,
  0.0016772, 0.00179314, 0.00190883, 0.00202424, 0.00213936,
  0.00225419, 0.00236869, 0.00248285, 0.00259667, 0.00271012,
  0.00282318, 0.00293585, 0.0030481, 0.00315993, 0.00327131,
  0.00338223, 0.00349267, 0.00360263, 0.00371208, 0.00382101,
  0.0039294, 0.00403725, 0.00414453, 0.00425123, 0.00435735,
  0.00446285, 0.00456774, 0.00467199, 0.00477559, 0.00487853,
  0.00498079, 0.00508236, 0.00518323, 0.00528338, 0.00538281,
  0.00548149, 0.00557941, 0.00567657, 0.00577295, 0.00586853,
  0.0059633, 0.00605726, 0.00615039, 0.00624268, 0.00633411,
  0.00642467, 0.00651436, 0.00660316, 0.00669106, 0.00677804,
  0.00686411, 0.00694924, 0.00703342, 0.00711665, 0.00719892,
  0.00728021, 0.00736051, 0.00743982, 0.00751812, 0.00759541,
  0.00767168, 0.0077469, 0.00782109, 0.00789422, 0.00796629,
  0.00803729, 0.00810722, 0.00817605, 0.00824379, 0.00831043,
  0.00837595, 0.00844035, 0.00850363, 0.00856577, 0.00862677,
  0.00868663, 0.00874532, 0.00880285, 0.00885922, 0.0089144,
  0.00896841, 0.00902122, 0.00907284, 0.00912326, 0.00917248,
  0.00922048, 0.00926727, 0.00931283, 0.00935717, 0.00940027,
  0.00944214, 0.00948277, 0.00952215, 0.00956028, 0.00959716,
  0.00963278, 0.00966714, 0.00970024, 0.00973206, 0.00976262,
  0.0097919, 0.00981991, 0.00984664, 0.00987208, 0.00989624,
  0.00991912, 0.00994071, 0.009961, 0.00998001, 0.00999772, 0.0100141,
  0.0100293, 0.0100431, 0.0100556, 0.0100669, 0.0100768, 0.0100854,
  0.0100928, 0.0100988, 0.0101036, 0.010107, 0.0101091, 0.01011,
  0.0101096, 0.0101078, 0.0101048, 0.0101005, 0.0100948, 0.0100879,
  0.0100798, 0.0100703, 0.0100595, 0.0100475, 0.0100342, 0.0100196,
  0.0100037, 0.00998659, 0.0099682, 0.00994854, 0.00992762,
  0.00990545, 0.00988202, 0.00985735, 0.00983143, 0.00980427,
  0.00977588, 0.00974626, 0.0097154, 0.00968333, 0.00965004,
  0.00961554, 0.00957984, 0.00954293, 0.00950483, 0.00946553,
  0.00942506, 0.0093834, 0.00934057, 0.00929658, 0.00925143,
  0.00920512, 0.00915767, 0.00910908, 0.00905935, 0.0090085,
  0.00895653, 0.00890345, 0.00884926, 0.00879398, 0.00873761,
  0.00868016, 0.00862163, 0.00856204, 0.00850139, 0.00843969,
  0.00837696, 0.00831318, 0.00824839, 0.00818258, 0.00811576,
  0.00804795, 0.00797915, 0.00790937, 0.00783862, 0.00776691,
  0.00769424, 0.00762064, 0.0075461, 0.00747065, 0.00739428, 0.007317,
  0.00723884, 0.00715979, 0.00707987, 0.00699909, 0.00691746,
  0.00683498, 0.00675168, 0.00666756, 0.00658263, 0.0064969,
  0.00641038, 0.00632309, 0.00623503, 0.00614622, 0.00605666,
  0.00596638, 0.00587537, 0.00578366, 0.00569125, 0.00559815,
  0.00550438, 0.00540995, 0.00531487, 0.00521915, 0.0051228,
  0.00502584, 0.00492828, 0.00483013, 0.00473139, 0.0046321,
  0.00453225, 0.00443185, 0.00433093, 0.00422949, 0.00412755,
  0.00402511, 0.0039222, 0.00381882, 0.00371498, 0.0036107, 0.003506,
  0.00340087, 0.00329535, 0.00318943, 0.00308314, 0.00297648,
  0.00286946, 0.00276211, 0.00265443, 0.00254644, 0.00243815,
  0.00232957, 0.00222072, 0.0021116, 0.00200224, 0.00189264,
  0.00178281, 0.00167278, 0.00156255, 0.00145214, 0.00134156,
  0.00123082, 0.00111993, 0.00100892, 0.000897783, 0.000786544,
  0.000675214, 0.000563804, 0.000452329, 0.000340801, 0.000229233,
  0.000117639, 6.03092e-06, -0.000105578, -0.000217174, -0.000328746,
  -0.000440279, -0.00055176, -0.000663178, -0.000774519, -0.00088577,
  -0.000996918, -0.00110795, -0.00121886, -0.00132962, -0.00144023,
  -0.00155067, -0.00166094, -0.00177101, -0.00188088, -0.00199053,
  -0.00209995, -0.00220913, -0.00231806, -0.00242672, -0.0025351,
  -0.00264319, -0.00275098, -0.00285845, -0.00296559, -0.00307239,
  -0.00317885, -0.00328493, -0.00339064, -0.00349597, -0.00360089,
  -0.0037054, -0.00380949, -0.00391315, -0.00401636, -0.00411911,
  -0.00422139, -0.00432319, -0.0044245, -0.00452531, -0.0046256,
  -0.00472537, -0.0048246, -0.00492328, -0.0050214, -0.00511896,
  -0.00521593, -0.00531232, -0.0054081, -0.00550327, -0.00559782,
  -0.00569174, -0.00578501, -0.00587764, -0.0059696, -0.00606088,
  -0.00615148, -0.00624139, -0.0063306, -0.0064191, -0.00650687,
  -0.00659391, -0.00668022, -0.00676577, -0.00685056, -0.00693459,
  -0.00701783, -0.00710029, -0.00718196, -0.00726282, -0.00734287,
  -0.0074221, -0.0075005, -0.00757807, -0.00765478, -0.00773065,
  -0.00780565, -0.00787978, -0.00795303, -0.0080254, -0.00809687,
  -0.00816745, -0.00823712, -0.00830587, -0.0083737, -0.0084406,
  -0.00850656, -0.00857158, -0.00863565, -0.00869876, -0.00876091,
  -0.00882209, -0.0088823, -0.00894152, -0.00899976, -0.009057,
  -0.00911324, -0.00916848, -0.0092227, -0.00927591, -0.0093281,
  -0.00937926, -0.00942938, -0.00947847, -0.00952652, -0.00957352,
  -0.00961947, -0.00966436, -0.0097082, -0.00975096, -0.00979266,
  -0.00983329, -0.00987284, -0.0099113, -0.00994869, -0.00998498,
  -0.0100202, -0.0100543, -0.0100873, -0.0101192, -0.01015,
  -0.0101797, -0.0102083, -0.0102358, -0.0102621, -0.0102874,
  -0.0103115, -0.0103345, -0.0103564, -0.0103771, -0.0103968,
  -0.0104153, -0.0104326, -0.0104489, -0.010464, -0.010478,
  -0.0104908, -0.0105025, -0.0105131, -0.0105225, -0.0105308,
  -0.0105379, -0.0105439, -0.0105488, -0.0105525, -0.0105551,
  -0.0105566, -0.0105569, -0.0105561, -0.0105542, -0.0105511,
  -0.0105468, -0.0105415, -0.010535, -0.0105274, -0.0105186,
  -0.0105087, -0.0104977, -0.0104856, -0.0104723, -0.010458,
  -0.0104424, -0.0104258, -0.0104081, -0.0103892, -0.0103693,
  -0.0103482, -0.010326, -0.0103028, -0.0102784, -0.0102529,
  -0.0102264, -0.0101987, -0.01017, -0.0101401, -0.0101092,
  -0.0100772, -0.0100442, -0.0100101, -0.00997487, -0.00993862,
  -0.00990132, -0.00986297, -0.00982357, -0.00978313, -0.00974165,
  -0.00969914, -0.0096556, -0.00961104, -0.00956546, -0.00951887,
  -0.00947127, -0.00942267, -0.00937307, -0.00932249, -0.00927092,
  -0.00921837, -0.00916485, -0.00911036, -0.00905491, -0.00899851,
  -0.00894116, -0.00888287, -0.00882364, -0.00876349, -0.00870241,
  -0.00864042, -0.00857752, -0.00851372, -0.00844902, -0.00838344,
  -0.00831698, -0.00824964, -0.00818144, -0.00811239, -0.00804248,
  -0.00797173, -0.00790015, -0.00782774, -0.00775451, -0.00768047,
  -0.00760563, -0.00752999, -0.00745357, -0.00737637, -0.00729839,
  -0.00721966, -0.00714017, -0.00705994, -0.00697898, -0.00689728,
  -0.00681487, -0.00673175, -0.00664793, -0.00656342, -0.00647822,
  -0.00639235, -0.00630582, -0.00621863, -0.0061308, -0.00604233,
  -0.00595323, -0.00586352, -0.0057732, -0.00568228, -0.00559077,
  -0.00549868, -0.00540603, -0.00531281, -0.00521904, -0.00512474,
  -0.0050299, -0.00493455, -0.00483868, -0.00474232, -0.00464546,
  -0.00454813, -0.00445033, -0.00435206, -0.00425335, -0.0041542,
  -0.00405463, -0.00395463, -0.00385423, -0.00375344, -0.00365225,
  -0.00355069, -0.00344877, -0.00334649, -0.00324387, -0.00314091,
  -0.00303763, -0.00293404, -0.00283015, -0.00272597, -0.00262151,
  -0.00251678, -0.00241179, -0.00230656, -0.00220109, -0.00209539,
  -0.00198948, -0.00188337, -0.00177706, -0.00167058, -0.00156392,
  -0.0014571, -0.00135013, -0.00124303, -0.0011358, -0.00102845,
  -0.000920998, -0.000813452, -0.000705823, -0.000598122, -0.00049036,
  -0.000382549, -0.000274698, -0.000166819, -5.89235e-05, 4.89782e-05,
  0.000156875, 0.000264756, 0.00037261, 0.000480426, 0.000588193,
  0.000695901, 0.000803538, 0.000911093, 0.00101856, 0.00112592,
  0.00123316, 0.00134028, 0.00144727, 0.00155411, 0.00166079,
  0.0017673, 0.00187364, 0.00197978, 0.00208573, 0.00219146,
  0.00229698, 0.00240226, 0.0025073, 0.00261208, 0.0027166,
  0.00282085, 0.00292482, 0.00302849, 0.00313185, 0.0032349,
  0.00333762, 0.00344001, 0.00354205, 0.00364373, 0.00374505,
  0.00384599, 0.00394654, 0.0040467, 0.00414645, 0.00424579,
  0.0043447, 0.00444317, 0.00454119, 0.00463877, 0.00473587,
  0.0048325, 0.00492865, 0.0050243, 0.00511945, 0.00521408, 0.0053082,
  0.00540178, 0.00549482, 0.00558731, 0.00567925, 0.00577061,
  0.0058614, 0.00595161, 0.00604121, 0.00613022, 0.00621861,
  0.00630638, 0.00639353, 0.00648003, 0.00656589, 0.00665109,
  0.00673563, 0.0068195, 0.00690269, 0.0069852, 0.007067, 0.00714811,
  0.0072285, 0.00730817, 0.00738712, 0.00746533, 0.0075428,
  0.00761951, 0.00769548, 0.00777067, 0.0078451, 0.00791874,
  0.0079916, 0.00806367, 0.00813494, 0.0082054, 0.00827504,
  0.00834387, 0.00841187, 0.00847903, 0.00854536, 0.00861084,
  0.00867547, 0.00873923, 0.00880214, 0.00886417, 0.00892532,
  0.00898559, 0.00904498, 0.00910347, 0.00916106, 0.00921774,
  0.00927352, 0.00932837, 0.00938231, 0.00943532, 0.0094874,
  0.00953855, 0.00958875, 0.00963801, 0.00968632, 0.00973367,
  0.00978007, 0.0098255, 0.00986996, 0.00991345, 0.00995597,
  0.0099975, 0.0100381, 0.0100776, 0.0101162, 0.0101538, 0.0101903,
  0.0102259, 0.0102605, 0.0102941, 0.0103266, 0.0103582, 0.0103887,
  0.0104182, 0.0104467, 0.0104741, 0.0105005, 0.0105259, 0.0105503,
  0.0105736, 0.0105959, 0.0106172, 0.0106374, 0.0106566, 0.0106747,
  0.0106918, 0.0107079, 0.0107229, 0.0107368, 0.0107497, 0.0107615,
  0.0107723, 0.0107821, 0.0107908, 0.0107984, 0.010805, 0.0108105,
  0.0108149, 0.0108184, 0.0108207, 0.010822, 0.0108222, 0.0108214,
  0.0108196, 0.0108166, 0.0108127, 0.0108076, 0.0108015, 0.0107944,
  0.0107862, 0.010777, 0.0107667, 0.0107553, 0.010743, 0.0107295,
  0.0107151, 0.0106995, 0.010683, 0.0106654, 0.0106468, 0.0106271,
  0.0106064, 0.0105847, 0.0105619, 0.0105381, 0.0105133, 0.0104875,
  0.0104606, 0.0104328, 0.0104039, 0.010374, 0.0103431, 0.0103112,
  0.0102783, 0.0102444, 0.0102096, 0.0101737, 0.0101368, 0.010099,
  0.0100602, 0.0100204, 0.00997963, 0.0099379, 0.00989521, 0.00985156,
  0.00980697, 0.00976142, 0.00971492, 0.00966749, 0.00961913,
  0.00956983, 0.00951961, 0.00946847, 0.00941641, 0.00936344,
  0.00930957, 0.00925481, 0.00919914, 0.00914259, 0.00908516,
  0.00902685, 0.00896767, 0.00890762, 0.00884672, 0.00878496,
  0.00872235, 0.00865891, 0.00859463, 0.00852952, 0.00846359,
  0.00839684, 0.00832928, 0.00826093, 0.00819177, 0.00812183,
  0.00805111, 0.00797961, 0.00790734, 0.00783431, 0.00776053,
  0.007686, 0.00761074, 0.00753474, 0.00745801, 0.00738057,
  0.00730242, 0.00722357, 0.00714403, 0.00706379, 0.00698288,
  0.0069013, 0.00681906, 0.00673616, 0.00665261, 0.00656843,
  0.00648361, 0.00639818, 0.00631212, 0.00622547, 0.00613821,
  0.00605037, 0.00596195, 0.00587295, 0.0057834, 0.00569328,
  0.00560263, 0.00551143, 0.00541971, 0.00532747, 0.00523471,
  0.00514146, 0.00504771, 0.00495348, 0.00485878, 0.00476361,
  0.00466799, 0.00457191, 0.00447541, 0.00437847, 0.00428111,
  0.00418335, 0.00408518, 0.00398662, 0.00388769, 0.00378838,
  0.0036887, 0.00358868, 0.00348831, 0.00338761, 0.00328659,
  0.00318525, 0.00308361, 0.00298167, 0.00287945, 0.00277695,
  0.00267419, 0.00257117, 0.00246791, 0.00236441, 0.00226069,
  0.00215675, 0.0020526, 0.00194826, 0.00184373, 0.00173903,
  0.00163416, 0.00152914, 0.00142397, 0.00131866, 0.00121323,
  0.00110768, 0.00100203, 0.00089628, 0.000790446, 0.000684537,
  0.000578562, 0.000472533, 0.000366458, 0.000260349, 0.000154214,
  4.80653e-05, -5.80882e-05, -0.000164236, -0.000270368, -0.000376475,
  -0.000482546, -0.000588571, -0.000694539, -0.000800442,
  -0.000906269, -0.00101201, -0.00111765, -0.00122319, -0.00132861,
  -0.00143391, -0.00153907, -0.00164408, -0.00174893, -0.00185362,
  -0.00195814, -0.00206246, -0.0021666, -0.00227052, -0.00237423,
  -0.00247772, -0.00258096, -0.00268397, -0.00278672, -0.0028892,
  -0.00299141, -0.00309334, -0.00319497, -0.0032963, -0.00339731,
  -0.003498, -0.00359836, -0.00369838, -0.00379805, -0.00389736,
  -0.0039963, -0.00409486, -0.00419303, -0.0042908, -0.00438816,
  -0.00448511, -0.00458164, -0.00467773, -0.00477337, -0.00486856,
  -0.00496329, -0.00505756, -0.00515134, -0.00524463, -0.00533742,
  -0.00542971, -0.00552149, -0.00561274, -0.00570346, -0.00579364,
  -0.00588327, -0.00597234, -0.00606085, -0.00614878, -0.00623613,
  -0.00632289, -0.00640905, -0.0064946, -0.00657954, -0.00666385,
  -0.00674754, -0.00683058, -0.00691298, -0.00699472, -0.00707581,
  -0.00715622, -0.00723595, -0.007315, -0.00739336, -0.00747101,
  -0.00754796, -0.0076242, -0.00769971, -0.00777449, -0.00784854,
  -0.00792185, -0.00799441, -0.00806621, -0.00813724, -0.00820751,
  -0.008277, -0.00834571, -0.00841363, -0.00848075, -0.00854707,
  -0.00861258, -0.00867728, -0.00874115, -0.0088042, -0.00886642,
  -0.0089278, -0.00898833, -0.00904802, -0.00910685, -0.00916482,
  -0.00922192, -0.00927815, -0.0093335, -0.00938797, -0.00944155,
  -0.00949424, -0.00954604, -0.00959693, -0.00964691, -0.00969598,
  -0.00974414, -0.00979137, -0.00983768, -0.00988306, -0.0099275,
  -0.00997101, -0.0100136, -0.0100552, -0.0100959, -0.0101356,
  -0.0101743, -0.0102121, -0.010249, -0.0102848, -0.0103197,
  -0.0103536, -0.0103866, -0.0104185, -0.0104495, -0.0104795,
  -0.0105085, -0.0105365, -0.0105635, -0.0105895, -0.0106145,
  -0.0106385, -0.0106615, -0.0106835, -0.0107045, -0.0107245,
  -0.0107434, -0.0107614, -0.0107783, -0.0107942, -0.0108091,
  -0.010823, -0.0108358, -0.0108476, -0.0108584, -0.0108682,
  -0.010877, -0.0108847, -0.0108914, -0.010897, -0.0109017,
  -0.0109053, -0.0109079, -0.0109094, -0.0109099, -0.0109094,
  -0.0109079, -0.0109053, -0.0109017, -0.010897, -0.0108914,
  -0.0108847, -0.010877, -0.0108682, -0.0108584, -0.0108476,
  -0.0108358, -0.010823, -0.0108091, -0.0107942, -0.0107783,
  -0.0107614, -0.0107434, -0.0107245, -0.0107045, -0.0106835,
  -0.0106615, -0.0106385, -0.0106145, -0.0105895, -0.0105635,
  -0.0105365, -0.0105085, -0.0104795, -0.0104495, -0.0104185,
  -0.0103866, -0.0103536, -0.0103197, -0.0102848, -0.010249,
  -0.0102121, -0.0101743, -0.0101356, -0.0100959, -0.0100552,
  -0.0100136, -0.00997101, -0.0099275, -0.00988306, -0.00983768,
  -0.00979137, -0.00974414, -0.00969598, -0.00964691, -0.00959693,
  -0.00954604, -0.00949424, -0.00944155, -0.00938797, -0.0093335,
  -0.00927815, -0.00922192, -0.00916482, -0.00910685, -0.00904802,
  -0.00898833, -0.0089278, -0.00886642, -0.0088042, -0.00874115,
  -0.00867728, -0.00861258, -0.00854707, -0.00848075, -0.00841363,
  -0.00834571, -0.008277, -0.00820751, -0.00813724, -0.00806621,
  -0.00799441, -0.00792185, -0.00784854, -0.00777449, -0.00769971,
  -0.0076242, -0.00754796, -0.00747101, -0.00739336, -0.007315,
  -0.00723595, -0.00715622, -0.00707581, -0.00699472, -0.00691298,
  -0.00683058, -0.00674754, -0.00666385, -0.00657954, -0.0064946,
  -0.00640905, -0.00632289, -0.00623613, -0.00614878, -0.00606085,
  -0.00597234, -0.00588327, -0.00579364, -0.00570346, -0.00561274,
  -0.00552149, -0.00542971, -0.00533742, -0.00524463, -0.00515134,
  -0.00505756, -0.00496329, -0.00486856, -0.00477337, -0.00467773,
  -0.00458164, -0.00448511, -0.00438816, -0.0042908, -0.00419303,
  -0.00409486, -0.0039963, -0.00389736, -0.00379805, -0.00369838,
  -0.00359836, -0.003498, -0.00339731, -0.0032963, -0.00319497,
  -0.00309334, -0.00299141, -0.0028892, -0.00278672, -0.00268397,
  -0.00258096, -0.00247772, -0.00237423, -0.00227052, -0.0021666,
  -0.00206246, -0.00195814, -0.00185362, -0.00174893, -0.00164408,
  -0.00153907, -0.00143391, -0.00132861, -0.00122319, -0.00111765,
  -0.00101201, -0.000906269, -0.000800442, -0.000694539, -0.000588571,
  -0.000482546, -0.000376475, -0.000270368, -0.000164236,
  -5.80882e-05, 4.80653e-05, 0.000154214, 0.000260349, 0.000366458,
  0.000472533, 0.000578562, 0.000684537, 0.000790446, 0.00089628,
  0.00100203, 0.00110768, 0.00121323, 0.00131866, 0.00142397,
  0.00152914, 0.00163416, 0.00173903, 0.00184373, 0.00194826,
  0.0020526, 0.00215675, 0.00226069, 0.00236441, 0.00246791,
  0.00257117, 0.00267419, 0.00277695, 0.00287945, 0.00298167,
  0.00308361, 0.00318525, 0.00328659, 0.00338761, 0.00348831,
  0.00358868, 0.0036887, 0.00378838, 0.00388769, 0.00398662,
  0.00408518, 0.00418335, 0.00428111, 0.00437847, 0.00447541,
  0.00457191, 0.00466799, 0.00476361, 0.00485878, 0.00495348,
  0.00504771, 0.00514146, 0.00523471, 0.00532747, 0.00541971,
  0.00551143, 0.00560263, 0.00569328, 0.0057834, 0.00587295,
  0.00596195, 0.00605037, 0.00613821, 0.00622547, 0.00631212,
  0.00639818, 0.00648361, 0.00656843, 0.00665261, 0.00673616,
  0.00681906, 0.0069013, 0.00698288, 0.00706379, 0.00714403,
  0.00722357, 0.00730242, 0.00738057, 0.00745801, 0.00753474,
  0.00761074, 0.007686, 0.00776053, 0.00783431, 0.00790734,
  0.00797961, 0.00805111, 0.00812183, 0.00819177, 0.00826093,
  0.00832928, 0.00839684, 0.00846359, 0.00852952, 0.00859463,
  0.00865891, 0.00872235, 0.00878496, 0.00884672, 0.00890762,
  0.00896767, 0.00902685, 0.00908516, 0.00914259, 0.00919914,
  0.00925481, 0.00930957, 0.00936344, 0.00941641, 0.00946847,
  0.00951961, 0.00956983, 0.00961913, 0.00966749, 0.00971492,
  0.00976142, 0.00980697, 0.00985156, 0.00989521, 0.0099379,
  0.00997963, 0.0100204, 0.0100602, 0.010099, 0.0101368, 0.0101737,
  0.0102096, 0.0102444, 0.0102783, 0.0103112, 0.0103431, 0.010374,
  0.0104039, 0.0104328, 0.0104606, 0.0104875, 0.0105133, 0.0105381,
  0.0105619, 0.0105847, 0.0106064, 0.0106271, 0.0106468, 0.0106654,
  0.010683, 0.0106995, 0.0107151, 0.0107295, 0.010743, 0.0107553,
  0.0107667, 0.010777, 0.0107862, 0.0107944, 0.0108015, 0.0108076,
  0.0108127, 0.0108166, 0.0108196, 0.0108214, 0.0108222, 0.010822,
  0.0108207, 0.0108184, 0.0108149, 0.0108105, 0.010805, 0.0107984,
  0.0107908, 0.0107821, 0.0107723, 0.0107615, 0.0107497, 0.0107368,
  0.0107229, 0.0107079, 0.0106918, 0.0106747, 0.0106566, 0.0106374,
  0.0106172, 0.0105959, 0.0105736, 0.0105503, 0.0105259, 0.0105005,
  0.0104741, 0.0104467, 0.0104182, 0.0103887, 0.0103582, 0.0103266,
  0.0102941, 0.0102605, 0.0102259, 0.0101903, 0.0101538, 0.0101162,
  0.0100776, 0.0100381, 0.0099975, 0.00995597, 0.00991345, 0.00986996,
  0.0098255, 0.00978007, 0.00973367, 0.00968632, 0.00963801,
  0.00958875, 0.00953855, 0.0094874, 0.00943532, 0.00938231,
  0.00932837, 0.00927352, 0.00921774, 0.00916106, 0.00910347,
  0.00904498, 0.00898559, 0.00892532, 0.00886417, 0.00880214,
  0.00873923, 0.00867547, 0.00861084, 0.00854536, 0.00847903,
  0.00841187, 0.00834387, 0.00827504, 0.0082054, 0.00813494,
  0.00806367, 0.0079916, 0.00791874, 0.0078451, 0.00777067,
  0.00769548, 0.00761951, 0.0075428, 0.00746533, 0.00738712,
  0.00730817, 0.0072285, 0.00714811, 0.007067, 0.0069852, 0.00690269,
  0.0068195, 0.00673563, 0.00665109, 0.00656589, 0.00648003,
  0.00639353, 0.00630638, 0.00621861, 0.00613022, 0.00604121,
  0.00595161, 0.0058614, 0.00577061, 0.00567925, 0.00558731,
  0.00549482, 0.00540178, 0.0053082, 0.00521408, 0.00511945,
  0.0050243, 0.00492865, 0.0048325, 0.00473587, 0.00463877,
  0.00454119, 0.00444317, 0.0043447, 0.00424579, 0.00414645,
  0.0040467, 0.00394654, 0.00384599, 0.00374505, 0.00364373,
  0.00354205, 0.00344001, 0.00333762, 0.0032349, 0.00313185,
  0.00302849, 0.00292482, 0.00282085, 0.0027166, 0.00261208,
  0.0025073, 0.00240226, 0.00229698, 0.00219146, 0.00208573,
  0.00197978, 0.00187364, 0.0017673, 0.00166079, 0.00155411,
  0.00144727, 0.00134028, 0.00123316, 0.00112592, 0.00101856,
  0.000911093, 0.000803538, 0.000695901, 0.000588193, 0.000480426,
  0.00037261, 0.000264756, 0.000156875, 4.89782e-05, -5.89235e-05,
  -0.000166819, -0.000274698, -0.000382549, -0.00049036, -0.000598122,
  -0.000705823, -0.000813452, -0.000920998, -0.00102845, -0.0011358,
  -0.00124303, -0.00135013, -0.0014571, -0.00156392, -0.00167058,
  -0.00177706, -0.00188337, -0.00198948, -0.00209539, -0.00220109,
  -0.00230656, -0.00241179, -0.00251678, -0.00262151, -0.00272597,
  -0.00283015, -0.00293404, -0.00303763, -0.00314091, -0.00324387,
  -0.00334649, -0.00344877, -0.00355069, -0.00365225, -0.00375344,
  -0.00385423, -0.00395463, -0.00405463, -0.0041542, -0.00425335,
  -0.00435206, -0.00445033, -0.00454813, -0.00464546, -0.00474232,
  -0.00483868, -0.00493455, -0.0050299, -0.00512474, -0.00521904,
  -0.00531281, -0.00540603, -0.00549868, -0.00559077, -0.00568228,
  -0.0057732, -0.00586352, -0.00595323, -0.00604233, -0.0061308,
  -0.00621863, -0.00630582, -0.00639235, -0.00647822, -0.00656342,
  -0.00664793, -0.00673175, -0.00681487, -0.00689728, -0.00697898,
  -0.00705994, -0.00714017, -0.00721966, -0.00729839, -0.00737637,
  -0.00745357, -0.00752999, -0.00760563, -0.00768047, -0.00775451,
  -0.00782774, -0.00790015, -0.00797173, -0.00804248, -0.00811239,
  -0.00818144, -0.00824964, -0.00831698, -0.00838344, -0.00844902,
  -0.00851372, -0.00857752, -0.00864042, -0.00870241, -0.00876349,
  -0.00882364, -0.00888287, -0.00894116, -0.00899851, -0.00905491,
  -0.00911036, -0.00916485, -0.00921837, -0.00927092, -0.00932249,
  -0.00937307, -0.00942267, -0.00947127, -0.00951887, -0.00956546,
  -0.00961104, -0.0096556, -0.00969914, -0.00974165, -0.00978313,
  -0.00982357, -0.00986297, -0.00990132, -0.00993862, -0.00997487,
  -0.0100101, -0.0100442, -0.0100772, -0.0101092, -0.0101401,
  -0.01017, -0.0101987, -0.0102264, -0.0102529, -0.0102784,
  -0.0103028, -0.010326, -0.0103482, -0.0103693, -0.0103892,
  -0.0104081, -0.0104258, -0.0104424, -0.010458, -0.0104723,
  -0.0104856, -0.0104977, -0.0105087, -0.0105186, -0.0105274,
  -0.010535, -0.0105415, -0.0105468, -0.0105511, -0.0105542,
  -0.0105561, -0.0105569, -0.0105566, -0.0105551, -0.0105525,
  -0.0105488, -0.0105439, -0.0105379, -0.0105308, -0.0105225,
  -0.0105131, -0.0105025, -0.0104908, -0.010478, -0.010464,
  -0.0104489, -0.0104326, -0.0104153, -0.0103968, -0.0103771,
  -0.0103564, -0.0103345, -0.0103115, -0.0102874, -0.0102621,
  -0.0102358, -0.0102083, -0.0101797, -0.01015, -0.0101192,
  -0.0100873, -0.0100543, -0.0100202, -0.00998498, -0.00994869,
  -0.0099113, -0.00987284, -0.00983329, -0.00979266, -0.00975096,
  -0.0097082, -0.00966436, -0.00961947, -0.00957352, -0.00952652,
  -0.00947847, -0.00942938, -0.00937926, -0.0093281, -0.00927591,
  -0.0092227, -0.00916848, -0.00911324, -0.009057, -0.00899976,
  -0.00894152, -0.0088823, -0.00882209, -0.00876091, -0.00869876,
  -0.00863565, -0.00857158, -0.00850656, -0.0084406, -0.0083737,
  -0.00830587, -0.00823712, -0.00816745, -0.00809687, -0.0080254,
  -0.00795303, -0.00787978, -0.00780565, -0.00773065, -0.00765478,
  -0.00757807, -0.0075005, -0.0074221, -0.00734287, -0.00726282,
  -0.00718196, -0.00710029, -0.00701783, -0.00693459, -0.00685056,
  -0.00676577, -0.00668022, -0.00659391, -0.00650687, -0.0064191,
  -0.0063306, -0.00624139, -0.00615148, -0.00606088, -0.0059696,
  -0.00587764, -0.00578501, -0.00569174, -0.00559782, -0.00550327,
  -0.0054081, -0.00531232, -0.00521593, -0.00511896, -0.0050214,
  -0.00492328, -0.0048246, -0.00472537, -0.0046256, -0.00452531,
  -0.0044245, -0.00432319, -0.00422139, -0.00411911, -0.00401636,
  -0.00391315, -0.00380949, -0.0037054, -0.00360089, -0.00349597,
  -0.00339064, -0.00328493, -0.00317885, -0.00307239, -0.00296559,
  -0.00285845, -0.00275098, -0.00264319, -0.0025351, -0.00242672,
  -0.00231806, -0.00220913, -0.00209995, -0.00199053, -0.00188088,
  -0.00177101, -0.00166094, -0.00155067, -0.00144023, -0.00132962,
  -0.00121886, -0.00110795, -0.000996918, -0.00088577, -0.000774519,
  -0.000663178, -0.00055176, -0.000440279, -0.000328746, -0.000217174,
  -0.000105578, 6.03092e-06, 0.000117639, 0.000229233, 0.000340801,
  0.000452329, 0.000563804, 0.000675214, 0.000786544, 0.000897783,
  0.00100892, 0.00111993, 0.00123082, 0.00134156, 0.00145214,
  0.00156255, 0.00167278, 0.00178281, 0.00189264, 0.00200224,
  0.0021116, 0.00222072, 0.00232957, 0.00243815, 0.00254644,
  0.00265443, 0.00276211, 0.00286946, 0.00297648, 0.00308314,
  0.00318943, 0.00329535, 0.00340087, 0.003506, 0.0036107, 0.00371498,
  0.00381882, 0.0039222, 0.00402511, 0.00412755, 0.00422949,
  0.00433093, 0.00443185, 0.00453225, 0.0046321, 0.00473139,
  0.00483013, 0.00492828, 0.00502584, 0.0051228, 0.00521915,
  0.00531487, 0.00540995, 0.00550438, 0.00559815, 0.00569125,
  0.00578366, 0.00587537, 0.00596638, 0.00605666, 0.00614622,
  0.00623503, 0.00632309, 0.00641038, 0.0064969, 0.00658263,
  0.00666756, 0.00675168, 0.00683498, 0.00691746, 0.00699909,
  0.00707987, 0.00715979, 0.00723884, 0.007317, 0.00739428,
  0.00747065, 0.0075461, 0.00762064, 0.00769424, 0.00776691,
  0.00783862, 0.00790937, 0.00797915, 0.00804795, 0.00811576,
  0.00818258, 0.00824839, 0.00831318, 0.00837696, 0.00843969,
  0.00850139, 0.00856204, 0.00862163, 0.00868016, 0.00873761,
  0.00879398, 0.00884926, 0.00890345, 0.00895653, 0.0090085,
  0.00905935, 0.00910908, 0.00915767, 0.00920512, 0.00925143,
  0.00929658, 0.00934057, 0.0093834, 0.00942506, 0.00946553,
  0.00950483, 0.00954293, 0.00957984, 0.00961554, 0.00965004,
  0.00968333, 0.0097154, 0.00974626, 0.00977588, 0.00980427,
  0.00983143, 0.00985735, 0.00988202, 0.00990545, 0.00992762,
  0.00994854, 0.0099682, 0.00998659, 0.0100037, 0.0100196, 0.0100342,
  0.0100475, 0.0100595, 0.0100703, 0.0100798, 0.0100879, 0.0100948,
  0.0101005, 0.0101048, 0.0101078, 0.0101096, 0.01011, 0.0101091,
  0.010107, 0.0101036, 0.0100988, 0.0100928, 0.0100854, 0.0100768,
  0.0100669, 0.0100556, 0.0100431, 0.0100293, 0.0100141, 0.00999772,
  0.00998001, 0.009961, 0.00994071, 0.00991912, 0.00989624,
  0.00987208, 0.00984664, 0.00981991, 0.0097919, 0.00976262,
  0.00973206, 0.00970024, 0.00966714, 0.00963278, 0.00959716,
  0.00956028, 0.00952215, 0.00948277, 0.00944214, 0.00940027,
  0.00935717, 0.00931283, 0.00926727, 0.00922048, 0.00917248,
  0.00912326, 0.00907284, 0.00902122, 0.00896841, 0.0089144,
  0.00885922, 0.00880285, 0.00874532, 0.00868663, 0.00862677,
  0.00856577, 0.00850363, 0.00844035, 0.00837595, 0.00831043,
  0.00824379, 0.00817605, 0.00810722, 0.00803729, 0.00796629,
  0.00789422, 0.00782109, 0.0077469, 0.00767168, 0.00759541,
  0.00751812, 0.00743982, 0.00736051, 0.00728021, 0.00719892,
  0.00711665, 0.00703342, 0.00694924, 0.00686411, 0.00677804,
  0.00669106, 0.00660316, 0.00651436, 0.00642467, 0.00633411,
  0.00624268, 0.00615039, 0.00605726, 0.0059633, 0.00586853,
  0.00577295, 0.00567657, 0.00557941, 0.00548149, 0.00538281,
  0.00528338, 0.00518323, 0.00508236, 0.00498079, 0.00487853,
  0.00477559, 0.00467199, 0.00456774, 0.00446285, 0.00435735,
  0.00425123, 0.00414453, 0.00403725, 0.0039294, 0.00382101,
  0.00371208, 0.00360263, 0.00349267, 0.00338223, 0.00327131,
  0.00315993, 0.0030481, 0.00293585, 0.00282318, 0.00271012,
  0.00259667, 0.00248285, 0.00236869, 0.00225419, 0.00213936,
  0.00202424, 0.00190883, 0.00179314, 0.0016772, 0.00156103,
  0.00144463, 0.00132802, 0.00121122, 0.00109425, 0.000977126,
  0.000859859, 0.00074247, 0.000624974, 0.000507388, 0.000389729,
  0.000272013, 0.000154259, 3.64827e-05, -8.12991e-05, -0.000199069,
  -0.00031681, -0.000434506, -0.000552138, -0.00066969, -0.000787145,
  -0.000904485, -0.00102169, -0.00113875, -0.00125565, -0.00137236,
  -0.00148887, -0.00160516, -0.00172121, -0.00183702, -0.00195255,
  -0.0020678, -0.00218274, -0.00229736, -0.00241164, -0.00252557,
  -0.00263913, -0.00275229, -0.00286504, -0.00297738, -0.00308927,
  -0.0032007, -0.00331165, -0.00342211, -0.00353207, -0.00364149,
  -0.00375037, -0.0038587, -0.00396644, -0.00407359, -0.00418013,
  -0.00428604, -0.00439131, -0.00449592, -0.00459985, -0.00470309,
  -0.00480561, -0.00490741, -0.00500847, -0.00510877, -0.0052083,
  -0.00530704, -0.00540497, -0.00550208, -0.00559835, -0.00569377,
  -0.00578831, -0.00588198, -0.00597474, -0.0060666, -0.00615752,
  -0.00624749, -0.00633651, -0.00642455, -0.00651161, -0.00659766,
  -0.00668269, -0.00676669, -0.00684964, -0.00693153, -0.00701235,
  -0.00709208, -0.00717071, -0.00724823, -0.00732461, -0.00739986,
  -0.00747395, -0.00754687, -0.00761861, -0.00768916, -0.0077585,
  -0.00782662, -0.00789352, -0.00795917, -0.00802357, -0.0080867,
  -0.00814856, -0.00820913, -0.0082684, -0.00832636, -0.00838299,
  -0.0084383, -0.00849227, -0.00854488, -0.00859613, -0.00864601,
  -0.00869451, -0.00874162, -0.00878732, -0.00883162, -0.0088745,
  -0.00891596, -0.00895598, -0.00899455, -0.00903168, -0.00906734,
  -0.00910154, -0.00913427, -0.00916551, -0.00919527, -0.00922353,
  -0.00925029, -0.00927555, -0.00929929, -0.00932151, -0.00934221,
  -0.00936138, -0.00937901, -0.0093951, -0.00940965, -0.00942265,
  -0.0094341, -0.00944399, -0.00945232, -0.00945909, -0.00946429,
  -0.00946793, -0.00946999, -0.00947047, -0.00946938, -0.00946671,
  -0.00946246, -0.00945663, -0.00944922, -0.00944022, -0.00942964,
  -0.00941748, -0.00940373, -0.00938839, -0.00937148, -0.00935298,
  -0.0093329, -0.00931124, -0.009288, -0.00926318, -0.00923679,
  -0.00920883, -0.0091793, -0.0091482, -0.00911553, -0.00908131,
  -0.00904553, -0.0090082, -0.00896932, -0.0089289, -0.00888694,
  -0.00884344, -0.00879842, -0.00875187, -0.00870381, -0.00865424,
  -0.00860317, -0.00855059, -0.00849653, -0.00844099, -0.00838397,
  -0.00832549, -0.00826554, -0.00820415, -0.00814131, -0.00807705,
  -0.00801136, -0.00794425, -0.00787575, -0.00780585, -0.00773456,
  -0.00766191, -0.00758789, -0.00751253, -0.00743582, -0.00735779,
  -0.00727844, -0.00719779, -0.00711585, -0.00703263, -0.00694815,
  -0.00686242, -0.00677545, -0.00668726, -0.00659785, -0.00650726,
  -0.00641548, -0.00632254, -0.00622845, -0.00613322, -0.00603688,
  -0.00593943, -0.0058409, -0.00574129, -0.00564064, -0.00553894,
  -0.00543623, -0.00533251, -0.00522781, -0.00512214, -0.00501553,
  -0.00490798, -0.00479952, -0.00469017, -0.00457995, -0.00446887,
  -0.00435695, -0.00424422, -0.0041307, -0.0040164, -0.00390134,
  -0.00378555, -0.00366904, -0.00355184, -0.00343397, -0.00331545,
  -0.0031963, -0.00307654, -0.00295619, -0.00283529, -0.00271383,
  -0.00259186, -0.0024694, -0.00234646, -0.00222306, -0.00209924,
  -0.00197502, -0.00185041, -0.00172545, -0.00160015, -0.00147454,
  -0.00134864, -0.00122248, -0.00109608, -0.000969467, -0.000842664,
  -0.000715696, -0.000588587, -0.000461363, -0.000334048,
  -0.000206666, -7.92442e-05, 4.81937e-05, 0.000175622, 0.000303016,
  0.000430349, 0.000557596, 0.000684732, 0.000811731, 0.000938567,
  0.00106521, 0.00119165, 0.00131784, 0.00144377, 0.00156941,
  0.00169472, 0.0018197, 0.0019443, 0.00206851, 0.0021923, 0.00231563,
  0.0024385, 0.00256086, 0.0026827, 0.00280399, 0.0029247, 0.0030448,
  0.00316428, 0.00328309, 0.00340123, 0.00351866, 0.00363536,
  0.0037513, 0.00386645, 0.00398079, 0.0040943, 0.00420695,
  0.00431871, 0.00442955, 0.00453947, 0.00464842, 0.00475638,
  0.00486333, 0.00496925, 0.0050741, 0.00517788, 0.00528054,
  0.00538206, 0.00548244, 0.00558162, 0.00567961, 0.00577637,
  0.00587187, 0.0059661, 0.00605903, 0.00615064, 0.00624091,
  0.00632981, 0.00641733, 0.00650343, 0.00658811, 0.00667133,
  0.00675308, 0.00683333, 0.00691207, 0.00698927, 0.00706491,
  0.00713898, 0.00721145, 0.00728231, 0.00735153, 0.0074191,
  0.00748499, 0.0075492, 0.0076117, 0.00767247, 0.00773149,
  0.00778876, 0.00784425, 0.00789795, 0.00794983, 0.0079999,
  0.00804812, 0.00809448, 0.00813898, 0.00818159, 0.00822231,
  0.00826111, 0.00829799, 0.00833293, 0.00836592, 0.00839695,
  0.008426, 0.00845308, 0.00847816, 0.00850123, 0.00852229,
  0.00854132, 0.00855832, 0.00857328, 0.0085862, 0.00859705,
  0.00860584, 0.00861256, 0.0086172, 0.00861976, 0.00862023,
  0.00861861, 0.00861489, 0.00860907, 0.00860114, 0.00859111,
  0.00857897, 0.00856472, 0.00854835, 0.00852988, 0.00850929,
  0.00848658, 0.00846176, 0.00843484, 0.0084058, 0.00837466,
  0.00834141, 0.00830606, 0.00826861, 0.00822908, 0.00818745,
  0.00814374, 0.00809796, 0.00805011, 0.0080002, 0.00794824,
  0.00789423, 0.00783819, 0.00778012, 0.00772003, 0.00765794,
  0.00759385, 0.00752778, 0.00745974, 0.00738975, 0.00731781,
  0.00724394, 0.00716816, 0.00709047, 0.00701091, 0.00692947,
  0.00684619, 0.00676108, 0.00667415, 0.00658542, 0.00649492,
  0.00640267, 0.00630868, 0.00621297, 0.00611557, 0.0060165,
  0.00591578, 0.00581344, 0.0057095, 0.00560398, 0.00549691,
  0.00538831, 0.00527822, 0.00516665, 0.00505364, 0.00493921,
  0.00482339, 0.00470621, 0.00458769, 0.00446788, 0.0043468,
  0.00422448, 0.00410095, 0.00397624, 0.0038504, 0.00372344,
  0.0035954, 0.00346633, 0.00333624, 0.00320519, 0.00307319,
  0.0029403, 0.00280654, 0.00267195, 0.00253658, 0.00240045,
  0.0022636, 0.00212609, 0.00198793, 0.00184918, 0.00170987,
  0.00157005, 0.00142975, 0.00128902, 0.0011479, 0.00100642,
  0.00086464, 0.000722592, 0.000580321, 0.00043787, 0.000295284,
  0.000152606, 9.88078e-06, -0.000132848, -0.000275534, -0.000418134,
  -0.000560602, -0.000702892, -0.000844959, -0.000986756, -0.00112824,
  -0.00126936, -0.00141007, -0.00155032, -0.00169008, -0.00182928,
  -0.00196789, -0.00210585, -0.00224313, -0.00237966, -0.00251541,
  -0.00265033, -0.00278436, -0.00291747, -0.0030496, -0.0031807,
  -0.00331074, -0.00343965, -0.0035674, -0.00369393, -0.0038192,
  -0.00394317, -0.00406578, -0.00418698, -0.00430674, -0.00442499,
  -0.00454171, -0.00465684, -0.00477033, -0.00488214, -0.00499222,
  -0.00510053, -0.00520703, -0.00531166, -0.00541439, -0.00551517,
  -0.00561396, -0.00571071, -0.00580538, -0.00589793, -0.00598831,
  -0.0060765, -0.00616244, -0.00624609, -0.00632741, -0.00640638,
  -0.00648294, -0.00655705, -0.00662869, -0.00669782, -0.00676439,
  -0.00682838, -0.00688974, -0.00694845, -0.00700447, -0.00705777,
  -0.00710832, -0.00715608, -0.00720103, -0.00724313, -0.00728237,
  -0.0073187, -0.00735211, -0.00738257, -0.00741006, -0.00743455,
  -0.00745601, -0.00747444, -0.0074898, -0.00750208, -0.00751126,
  -0.00751732, -0.00752025, -0.00752003, -0.00751665, -0.00751009,
  -0.00750035, -0.00748741, -0.00747127, -0.00745192, -0.00742935,
  -0.00740356, -0.00737454, -0.0073423, -0.00730683, -0.00726813,
  -0.0072262, -0.00718105, -0.00713269, -0.00708112, -0.00702634,
  -0.00696838, -0.00690723, -0.00684292, -0.00677545, -0.00670484,
  -0.00663112, -0.00655429, -0.00647439, -0.00639142, -0.00630542,
  -0.00621642, -0.00612443, -0.00602949, -0.00593163, -0.00583089,
  -0.00572729, -0.00562087, -0.00551168, -0.00539974, -0.00528511,
  -0.00516782, -0.00504792, -0.00492546, -0.00480049, -0.00467305,
  -0.0045432, -0.00441099, -0.00427647, -0.00413972, -0.00400078,
  -0.00385972, -0.00371659, -0.00357147, -0.00342443, -0.00327552,
  -0.00312483, -0.00297242, -0.00281836, -0.00266274, -0.00250563,
  -0.00234711, -0.00218726, -0.00202617, -0.00186391, -0.00170058,
  -0.00153626, -0.00137105, -0.00120503, -0.0010383, -0.00087095,
  -0.000703079, -0.000534784, -0.000366165, -0.000197322,
  -2.83578e-05, 0.000140624, 0.000309518, 0.000478218, 0.000646616,
  0.000814602, 0.000982067, 0.0011489, 0.00131498, 0.00148021,
  0.00164446, 0.00180762, 0.00196957, 0.00213019, 0.00228937,
  0.00244698, 0.00260291, 0.00275703, 0.00290923, 0.00305938,
  0.00320735, 0.00335303, 0.0034963, 0.00363702, 0.00377507,
  0.00391034, 0.00404269, 0.00417201, 0.00429818, 0.00442105,
  0.00454053, 0.00465648, 0.00476878, 0.00487732, 0.00498196,
  0.0050826, 0.00517912, 0.0052714, 0.00535932, 0.00544277,
  0.00552164, 0.00559583, 0.00566521, 0.00572969, 0.00578916,
  0.00584351, 0.00589266, 0.00593651, 0.00597495, 0.0060079,
  0.00603527, 0.00605699, 0.00607295, 0.0060831, 0.00608736,
  0.00608566, 0.00607793, 0.00606412, 0.00604417, 0.00601803,
  0.00598565, 0.005947, 0.00590204, 0.00585075, 0.0057931, 0.00572908,
  0.00565867, 0.00558189, 0.00549872, 0.0054092, 0.00531333,
  0.00521115, 0.00510269, 0.004988, 0.00486713, 0.00474015,
  0.00460713, 0.00446816, 0.00432333, 0.00417274, 0.00401651,
  0.00385477, 0.00368765, 0.0035153, 0.00333789, 0.00315559,
  0.0029686, 0.0027771, 0.00258133, 0.0023815, 0.00217788, 0.00197071,
  0.00176027, 0.00154685, 0.00133078, 0.00111236, 0.000891948,
  0.000669904, 0.000446608, 0.000222459, -2.12281e-06, -0.000226698,
  -0.000450808, -0.00067397, -0.000895682, -0.00111542, -0.00133263,
  -0.00154675, -0.00175717, -0.00196329, -0.00216444, -0.00235997,
  -0.00254917, -0.00273132, -0.00290566, -0.00307141, -0.00322777,
  -0.00337388, -0.00350888, -0.00363186, -0.00374189, -0.003838,
  -0.00391918, -0.00398441, -0.00403261, -0.00406266, -0.00407343,
  -0.00406374, -0.00403235, -0.00397802, -0.00389943, -0.00379526,
  -0.0036641, -0.00350454, -0.00331511, -0.00309429, -0.00284051,
  -0.00255216, -0.0022276, -0.00186511, -0.00146294, -0.00101928,
  -0.000532269, 6.54858e-17}; 
