#set echo on

set here = $PWD
set package = `cmt -quiet show macro_value package`
set pack = `cmt -quiet show macro_value package | tr -d "G4"`
if ( "$pack" == "parmodels" ) set pack = "parameterisations"

cd ${G4SRC}/${pack}
set list = `find . -name src -print | sed -e 's;^./;;'`
set incl = `find . -name include -print | sed -e 's;^./;;'`
cd $here/..

set n = 0
foreach p ($list[*])
set test = `echo $p | awk '{print(index($0,"test/"))}'`
  if ($test == "0") then
    if !( -d $p ) then
      mkdir -p $p 
      cp -a ${G4SRC}/${pack}/${p}/*.* ${p}/.
    else
#     echo ' ' ${G4SRC}/${pack}/${p} ' exists - skip copy'
      @ n++
    endif
  endif
end
if ( $n <= 0 ) then 
  echo ' source files have been copied from '${G4SRC}'/'${pack}
else 
  echo ' source files exist - NO copy'
endif
#
# copy include files if not yet done
if !( -f ${package}.stamp) then 
  foreach p ($incl[*])
   set test = `echo $p | awk '{print(index($0,"test/"))}'`
   if ($test == "0") then
      cp -a ${G4SRC}/${pack}/${p}/*.* ${package}/.
   endif
  end
  touch ${package}.stamp
  echo ' include files have been copied from '${G4SRC}'/'${pack}
else 
  echo ' include files exist - NO copy'
endif

cd $here
unset echo


