here=$PWD
package=`cmt -quiet show macro_value package`

pack=`cmt -quiet show macro_value package | tr -d "G4"`
if [ "$pack" == "parmodels" ] 
 then
   pack="parameterisations"
fi
cd ${G4SRC}/${pack}
list=`find . -name src -print | sed -e 's;^./;;'`
incl=`find . -name include -print | sed -e 's;^./;;'`

cd $here/..

n=yes
for p in $list
do
 test=`echo $p | awk '{print(index($0,"test/"))}'`
 if [ "${test}" == "0" ]
 then
   if [ ! -d $p ] 
   then
    mkdir -p $p
    cp -a ${G4SRC}/${pack}/${p}/*.* ${p}/.
   else
#   echo ' ' ${G4SRC}/${pack}/${p} ' exists - skip copy'
    n=no
   fi
 fi
done

if [ "$n" == "yes" ] 
then 
  echo ' source files have been copied from '${G4SRC}'/'${pack}
else 
  echo ' source files exist - NO copy'
fi
#
# copy include files if not yet done
if [ ! -f ${package}.stamp ]
then
  for p in $incl
  do
    test=`echo $p | awk '{print(index($0,"test/"))}'`
    if [ "${test}" == "0" ]
    then
     cp -a ${G4SRC}/${pack}/${p}/*.* ${package}/.
    fi
  done
  touch ${package}.stamp
  echo ' include files have been copied from '${G4SRC}'/'${pack}
else 
  echo ' include files exist - NO copy'
fi

cd $here
