#set echo on

#copy files from G4Dir = visualization
set G4Dir = "visualization"

set here = $PWD
 
set pack = `cmt -quiet show macro_value package | tr -d "G4"`

if ( "$pack" == "VRML" || "$pack" == "modeling" || "$pack" == "RayTracer" || "$pack" == "Tree" ) then
   set p = "${pack}/src"
else if ("$pack" == "OpenL" ) then
   set pack = "OpenGL"
   set p = "OpenGL/src"
else if ("$pack" == "FR") then
   set p = "FukuiRenderer/src"
else if ("$pack" == "vis_management") then
   set p = "management/src"
else if ("$pack" == "visHepRep") then
   set p = "HepRep/src"
else if ("$pack" == "visXXX") then
   set p = "XXX/src"
endif  


cd $here/..
if !( -d $p) then
  mkdir -p $p
  cp -a ${G4SRC}/${G4Dir}/${p}/*.* ${p}/.
  cp -a ${G4SRC}/${G4Dir}/${p}/../include/*.* G4${pack}/.
  echo ' source files have been copied from '${G4SRC}'/'${G4Dir}
else
  echo ' ' ${G4SRC}/${G4Dir}/${p} ' exists - skip copy'
endif

cd $here

unset echo

